/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.api.ExtensionAPI;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.network.DomainMatcher;

public class OptionsParamApi
extends AbstractParam {
    private static final Logger LOGGER = LogManager.getLogger(OptionsParamApi.class);
    public static final String ENABLED = "api.enabled";
    public static final String UI_ENABLED = "api.uienabled";
    public static final String SECURE_ONLY = "api.secure";
    public static final String API_KEY = "api.key";
    public static final String DISABLE_KEY = "api.disablekey";
    public static final String INC_ERROR_DETAILS = "api.incerrordetails";
    public static final String AUTOFILL_KEY = "api.autofillkey";
    public static final String ENABLE_JSONP = "api.enablejsonp";
    public static final String NO_KEY_FOR_SAFE_OPS = "api.nokeyforsafeops";
    public static final String REPORT_PERM_ERRORS = "api.reportpermerrors";
    private static final String NONCE_TTL_IN_SECS = "api.noncettlsecs";
    public static final String FILE_TRANSFER = "api.filexfer";
    public static final String TRANSFER_DIR = "api.xferdir";
    private static final String PROXY_PERMITTED_ADDRS_KEY = "api.addrs";
    private static final String ADDRESS_KEY = "api.addrs.addr";
    private static final String ADDRESS_VALUE_KEY = "name";
    private static final String ADDRESS_REGEX_KEY = "regex";
    private static final String ADDRESS_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_ADDRESS = "api.addrs.confirmRemoveAddr";
    protected static final String CALLBACK_KEY = "api.callbacks.callback";
    private static final String CALLBACK_URL_KEY = "url";
    private static final String CALLBACK_PREFIX_KEY = "prefix";
    private static final int DEFAULT_NONCE_TTL_IN_SECS = 300;
    private static final String IPV6_LOOPBACK_ADDRS = "0:0:0:0:0:0:0:1";
    private boolean enabled = true;
    private boolean uiEnabled = true;
    private boolean secureOnly;
    private boolean disableKey;
    private boolean incErrorDetails;
    private boolean autofillKey;
    private boolean enableJSONP;
    private boolean noKeyForSafeOps;
    private boolean reportPermErrors;
    private boolean fileTransferAllowed;
    private boolean confirmRemovePermittedAddress = true;
    private List<DomainMatcher> permittedAddresses = new ArrayList<DomainMatcher>(0);
    private List<DomainMatcher> permittedAddressesEnabled = new ArrayList<DomainMatcher>(0);
    private int nonceTimeToLiveInSecs = 300;
    private Map<String, String> persistentCallBacks = new HashMap<String, String>();
    private String transferDir;
    private String key = "";

    @Override
    protected void parse() {
        this.enabled = this.getBoolean(ENABLED, true);
        this.uiEnabled = this.getBoolean(UI_ENABLED, true);
        this.secureOnly = this.getBoolean(SECURE_ONLY, false);
        this.disableKey = this.getBoolean(DISABLE_KEY, false);
        this.incErrorDetails = this.getBoolean(INC_ERROR_DETAILS, false);
        this.autofillKey = this.getBoolean(AUTOFILL_KEY, false);
        this.enableJSONP = this.getBoolean(ENABLE_JSONP, false);
        this.noKeyForSafeOps = this.getBoolean(NO_KEY_FOR_SAFE_OPS, false);
        this.reportPermErrors = this.getBoolean(REPORT_PERM_ERRORS, false);
        this.fileTransferAllowed = this.getBoolean(FILE_TRANSFER, false);
        this.nonceTimeToLiveInSecs = this.getInt(NONCE_TTL_IN_SECS, 300);
        this.key = this.getString(API_KEY, "");
        this.loadPermittedAddresses();
        this.confirmRemovePermittedAddress = this.getBoolean(CONFIRM_REMOVE_ADDRESS, true);
        this.loadPersistentCallBacks();
        this.transferDir = this.getString(TRANSFER_DIR, new File(Constant.getZapHome(), "transfer").getAbsolutePath());
        File transferFile = new File(this.transferDir);
        if (!transferFile.exists()) {
            try {
                Files.createDirectories(transferFile.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create API transfer directory {}", (Object)transferFile.getAbsolutePath(), (Object)e);
            }
        }
    }

    @Override
    public OptionsParamApi clone() {
        return (OptionsParamApi)super.clone();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.getConfig().setProperty(ENABLED, (Object)enabled);
    }

    public boolean isUiEnabled() {
        return this.uiEnabled;
    }

    public void setUiEnabled(boolean uiEnabled) {
        this.uiEnabled = uiEnabled;
        this.getConfig().setProperty(UI_ENABLED, (Object)uiEnabled);
    }

    public boolean isSecureOnly() {
        return this.secureOnly;
    }

    public void setSecureOnly(boolean secureOnly) {
        this.secureOnly = secureOnly;
        this.getConfig().setProperty(SECURE_ONLY, (Object)secureOnly);
    }

    public boolean isDisableKey() {
        return this.disableKey;
    }

    public void setDisableKey(boolean disableKey) {
        this.disableKey = disableKey;
        this.getConfig().setProperty(DISABLE_KEY, (Object)disableKey);
    }

    public boolean isIncErrorDetails() {
        return this.incErrorDetails;
    }

    public void setIncErrorDetails(boolean incErrorDetails) {
        this.incErrorDetails = incErrorDetails;
        this.getConfig().setProperty(INC_ERROR_DETAILS, (Object)incErrorDetails);
    }

    public boolean isAutofillKey() {
        return this.autofillKey;
    }

    public void setAutofillKey(boolean autofillKey) {
        this.autofillKey = autofillKey;
        this.getConfig().setProperty(AUTOFILL_KEY, (Object)autofillKey);
    }

    public boolean isEnableJSONP() {
        return this.enableJSONP;
    }

    public void setEnableJSONP(boolean enableJSONP) {
        this.enableJSONP = enableJSONP;
        this.getConfig().setProperty(ENABLE_JSONP, (Object)enableJSONP);
    }

    public boolean isNoKeyForSafeOps() {
        return this.noKeyForSafeOps;
    }

    public void setNoKeyForSafeOps(boolean noKeyForSafeOps) {
        this.noKeyForSafeOps = noKeyForSafeOps;
        this.getConfig().setProperty(NO_KEY_FOR_SAFE_OPS, (Object)noKeyForSafeOps);
    }

    public boolean isReportPermErrors() {
        return this.reportPermErrors;
    }

    public void setReportPermErrors(boolean reportErrors) {
        this.reportPermErrors = reportErrors;
        this.getConfig().setProperty(REPORT_PERM_ERRORS, (Object)reportErrors);
    }

    @ZapApiIgnore
    public int getNonceTimeToLiveInSecs() {
        return this.nonceTimeToLiveInSecs;
    }

    protected String getRealKey() {
        return this.key;
    }

    protected String getKey() {
        if (this.isDisableKey()) {
            return "";
        }
        if (this.key == null || this.key.length() == 0) {
            this.key = ExtensionAPI.generateApiKey();
            if (this.getConfig() != null) {
                this.getConfig().setProperty(API_KEY, (Object)this.key);
                try {
                    this.getConfig().save();
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this.getConfig().setProperty(API_KEY, (Object)key);
    }

    public boolean isPermittedAddress(String addr) {
        if (addr == null || addr.isEmpty()) {
            return false;
        }
        for (DomainMatcher permAddr : this.permittedAddressesEnabled) {
            if (!permAddr.matches(addr)) continue;
            return true;
        }
        return false;
    }

    @ZapApiIgnore
    public List<DomainMatcher> getPermittedAddresses() {
        return this.permittedAddresses;
    }

    @ZapApiIgnore
    public List<DomainMatcher> getPermittedAddressesEnabled() {
        return this.permittedAddressesEnabled;
    }

    public void setPermittedAddresses(List<DomainMatcher> addrs) {
        if (addrs == null || addrs.isEmpty()) {
            ((HierarchicalConfiguration)this.getConfig()).clearTree(ADDRESS_KEY);
            this.permittedAddresses = Collections.emptyList();
            this.permittedAddressesEnabled = Collections.emptyList();
            return;
        }
        this.permittedAddresses = new ArrayList<DomainMatcher>(addrs);
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ADDRESS_KEY);
        int size = addrs.size();
        ArrayList<DomainMatcher> enabledAddrs = new ArrayList<DomainMatcher>(size);
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "api.addrs.addr(" + i + ").";
            DomainMatcher addr = addrs.get(i);
            this.getConfig().setProperty(elementBaseKey + ADDRESS_VALUE_KEY, (Object)addr.getValue());
            this.getConfig().setProperty(elementBaseKey + ADDRESS_REGEX_KEY, (Object)addr.isRegex());
            this.getConfig().setProperty(elementBaseKey + ADDRESS_ENABLED_KEY, (Object)addr.isEnabled());
            if (!addr.isEnabled()) continue;
            enabledAddrs.add(addr);
        }
        enabledAddrs.trimToSize();
        this.permittedAddressesEnabled = enabledAddrs;
    }

    private void loadPermittedAddresses() {
        List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ADDRESS_KEY);
        this.permittedAddresses = new ArrayList<DomainMatcher>(fields.size());
        ArrayList<DomainMatcher> addrsEnabled = new ArrayList<DomainMatcher>(fields.size());
        for (HierarchicalConfiguration sub : fields) {
            String value = sub.getString(ADDRESS_VALUE_KEY, "");
            if (value.isEmpty()) {
                LOGGER.warn("Failed to read a permitted address entry, required value is empty.");
                continue;
            }
            DomainMatcher addr = null;
            boolean regex = sub.getBoolean(ADDRESS_REGEX_KEY, false);
            if (regex) {
                try {
                    Pattern pattern = DomainMatcher.createPattern(value);
                    addr = new DomainMatcher(pattern);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Failed to read a permitted address entry with regex: {}", (Object)value, (Object)e);
                }
            } else {
                addr = new DomainMatcher(value);
            }
            if (addr == null) continue;
            addr.setEnabled(sub.getBoolean(ADDRESS_ENABLED_KEY, true));
            this.permittedAddresses.add(addr);
            if (!addr.isEnabled()) continue;
            addrsEnabled.add(addr);
        }
        addrsEnabled.trimToSize();
        if (this.permittedAddresses.isEmpty()) {
            DomainMatcher addr = new DomainMatcher("127.0.0.1");
            this.permittedAddresses.add(addr);
            addrsEnabled.add(addr);
            addr = new DomainMatcher("localhost");
            this.permittedAddresses.add(addr);
            addrsEnabled.add(addr);
            addr = new DomainMatcher("zap");
            this.permittedAddresses.add(addr);
            addrsEnabled.add(addr);
            addr = new DomainMatcher(IPV6_LOOPBACK_ADDRS);
            this.permittedAddresses.add(addr);
            addrsEnabled.add(addr);
        }
        this.permittedAddressesEnabled = addrsEnabled;
    }

    @ZapApiIgnore
    public boolean isConfirmRemovePermittedAddress() {
        return this.confirmRemovePermittedAddress;
    }

    @ZapApiIgnore
    public void setConfirmRemovePermittedAddress(boolean confirmRemove) {
        this.confirmRemovePermittedAddress = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_ADDRESS, (Object)this.confirmRemovePermittedAddress);
    }

    private void loadPersistentCallBacks() {
        List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(CALLBACK_KEY);
        this.persistentCallBacks = new HashMap<String, String>(fields.size());
        for (HierarchicalConfiguration sub : fields) {
            String cbUrl = sub.getString(CALLBACK_URL_KEY, "");
            if (cbUrl.isEmpty()) {
                LOGGER.warn("Failed to read a callback entry, required url is empty.");
                continue;
            }
            String cbPrefix = sub.getString(CALLBACK_PREFIX_KEY, null);
            if (cbPrefix == null) {
                LOGGER.warn("Failed to read a callback entry, required prefix is empty.");
                continue;
            }
            this.persistentCallBacks.put(cbUrl, cbPrefix);
        }
    }

    private void savePersistentCallBacks() {
        ((HierarchicalConfiguration)this.getConfig()).clearTree(CALLBACK_KEY);
        int i = 0;
        for (Map.Entry<String, String> entry : this.persistentCallBacks.entrySet()) {
            String elementBaseKey = "api.callbacks.callback(" + i + ").";
            this.getConfig().setProperty(elementBaseKey + CALLBACK_URL_KEY, (Object)entry.getKey());
            this.getConfig().setProperty(elementBaseKey + CALLBACK_PREFIX_KEY, (Object)entry.getValue());
            ++i;
        }
        try {
            this.getConfig().save();
        }
        catch (ConfigurationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addPersistantCallBack(String url, String prefix) {
        this.persistentCallBacks.put(url, prefix);
        this.savePersistentCallBacks();
    }

    public String removePersistantCallBack(String url) {
        String value = this.persistentCallBacks.remove(url);
        this.savePersistentCallBacks();
        return value;
    }

    public Map<String, String> getPersistentCallBacks() {
        return this.persistentCallBacks;
    }

    public boolean isFileTransferAllowed() {
        return !this.disableKey && this.fileTransferAllowed;
    }

    public void setFileTransferAllowed(boolean fileTransferAllowed) {
        if (!this.disableKey) {
            this.fileTransferAllowed = fileTransferAllowed;
            this.getConfig().setProperty(FILE_TRANSFER, (Object)fileTransferAllowed);
        }
    }

    public void setTransferDir(String transferDir) {
        this.transferDir = transferDir;
        this.getConfig().setProperty(TRANSFER_DIR, (Object)transferDir);
    }

    public String getTransferDir() {
        return this.transferDir;
    }
}

