---
layout: post
title:  "Coot 1 Released"
date: Fri 2 Apr 09:51:52 BST 2022
---


Coot 1

18 years after the release of Coot 0 it's time that I actually released Coot 1.

Coot 1 is a major change beyond Coot 0. It has required a lot of writing and rewriting [1]
and has been the preponderance of my work since 2017. I have had to learn how to program
graphics from scratch using the new style. Much of the GUI internals has been
rewritten [2].

My experience with 0.9 was that I sat on it, bug-fixing for a long time, releasing it
too late. I don't want to repeat that mistake. So here we are, there's a lot of good new
stuff in Coot 1, but it's not as slick as it might be (or will become).

  - Update graphics to use OpenGL 3.3
  - Update Python to use version 3.9
  - Update GTK+ to use version 3

While many of the features that were available in 0.9.x have been reworked or
reimplemented, there are some gaps. Dropped features include Cross-hairs, Stereo, Pisa
interface, built-in key-bindings, NCS Ghosts, Edit Phi/Psi, antialiasing, Kleywegt
plots, the clipping dialog, Chemical Feature Clustering, Dynamically-Transformed/NCS
Maps, LSQ plane distances, dynamic distances, CABLAM-markup, the test suite,
user-defined colour schemes, anisotropic atoms, CURLEW, Scheme GUI scripting,
Skeletonization and Baton-Building.

"So, is there anything that _does_ work?" - you might ask...

The GUI has been updated, I have tried to cut down on the number of dialogs, the Real
Space Refinement in particular has seen quite a lot of work. The GUI now uses dark mode
if the theme is installed [3]. Several menu items have been relocated. More menus are now
alphabetically ordered [4].

The graphics is, by default, now based on triangles instead of lines which affords a
more pleasing representation (density maps can be represented using both modes) and one
can have a more expeditious if not pleasant experience with a fast graphics card and a
big screen. The various graphics effects and filters can be tailored to some extent by
changing the configuration using the GUI or by editing/replacing the shaders.
Full-screen mode is now an option [5].

Overall, the GUI has only had light testing. At the moment, it's probably best to
avoid closing dialogs using the window manager. The "OK" button now appears after the
"Cancel" button in dialogs.

Python scripting now has uses a history from previous sessions and the functions need
to be used with namespaces/modules (e.g. "coot", or "coot_utils"). Coot (or coot) is
now a module that can be imported into python.

This build compiles with the RDKit and optionally MoleculestoTriangles from Martin Noble.

The map and the model can now be exported to glTF files (for use in Blender and other
3D modelling software).

The build script for Coot 1, called build-it-3-3 can be found in the "Build from Scratch"
menu on the web page (you will need to have already installed cmake and Gtk+). The catch
though is that (at least in my hands) Python and friends are frustratingly difficult to
install, so it's possible/likely that the build script won't work. Likewise,
the script doesn't work for Mac OS either. But it is currently the best method to get
binaries so I will support it if you try it [6]. (Homebrew might be another method.)

Bernhard Lohkamp has been working on the WinCoot version - I will defer WinCoot
questions to him.

Mac Coot is now native (no X11/XQuartz needed). I would be interested to see how a
natively-compiled [7] version works on a M1 Max processor [8,9].

Judging from previous experience, a few rapid iterations of bug-fix releases will be
needed. After this, the version numbers will become sane - it's my plan to release a new
major version every year or so.

[coot-1.tar.gz](https://www2.mrc-lmb.cam.ac.uk/personal/pemsley/coot/source/releases/coot-1.tar.gz)


[1] new as in OpenGL 3.3 or later - using shaders - I don't mean Vulkan (that's for the
    future)
    
[2] the patch from the 0.9.x version is 285k lines

[3] I recommend it

[4] rather than chronologically

[5] double-tap Esc key (the first time) to revert to standard display

[6] I have be working with CCP4 collaborators to use their system to build Coot binaries.
    Hopefully the binaries will be available stand-alone, as well as integrated into
    the CCP4 Suite via that method
    
[7] so that's a different meaning of "native"

[8] the little testing I have done on a recent intel MacBook Pro shows unimpressive
    performance (Iris graphics, retina display)
    
[9] Thanks to my Mac-using colleagues for their feedback.
