/* Generated by wayland-scanner 1.23.0 */

#ifndef KDE_SCREEN_EDGE_V1_CLIENT_PROTOCOL_H
#define KDE_SCREEN_EDGE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_kde_screen_edge_v1 The kde_screen_edge_v1 protocol
 * @section page_ifaces_kde_screen_edge_v1 Interfaces
 * - @subpage page_iface_kde_screen_edge_manager_v1 - screen edge manager
 * - @subpage page_iface_kde_auto_hide_screen_edge_v1 - auto hide screen edge
 * @section page_copyright_kde_screen_edge_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2023 Vlad Zahorodnii
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct kde_auto_hide_screen_edge_v1;
struct kde_screen_edge_manager_v1;
struct wl_surface;

#ifndef KDE_SCREEN_EDGE_MANAGER_V1_INTERFACE
#define KDE_SCREEN_EDGE_MANAGER_V1_INTERFACE
/**
 * @page page_iface_kde_screen_edge_manager_v1 kde_screen_edge_manager_v1
 * @section page_iface_kde_screen_edge_manager_v1_desc Description
 *
 * This interface allows clients to associate actions with screen edges. For
 * example, showing a surface by moving the pointer to a screen edge.
 *
 * Potential ways to trigger the screen edge are subject to compositor
 * policies. As an example, the compositor may consider the screen edge to be
 * triggered if the pointer hits its associated screen border. Other ways may
 * include using touchscreen or touchpad gestures.
 *
 * Warning! The protocol described in this file is a desktop environment
 * implementation detail. Regular clients must not use this protocol.
 * Backward incompatible changes may be added without bumping the major
 * version of the extension.
 * @section page_iface_kde_screen_edge_manager_v1_api API
 * See @ref iface_kde_screen_edge_manager_v1.
 */
/**
 * @defgroup iface_kde_screen_edge_manager_v1 The kde_screen_edge_manager_v1 interface
 *
 * This interface allows clients to associate actions with screen edges. For
 * example, showing a surface by moving the pointer to a screen edge.
 *
 * Potential ways to trigger the screen edge are subject to compositor
 * policies. As an example, the compositor may consider the screen edge to be
 * triggered if the pointer hits its associated screen border. Other ways may
 * include using touchscreen or touchpad gestures.
 *
 * Warning! The protocol described in this file is a desktop environment
 * implementation detail. Regular clients must not use this protocol.
 * Backward incompatible changes may be added without bumping the major
 * version of the extension.
 */
extern const struct wl_interface kde_screen_edge_manager_v1_interface;
#endif
#ifndef KDE_AUTO_HIDE_SCREEN_EDGE_V1_INTERFACE
#define KDE_AUTO_HIDE_SCREEN_EDGE_V1_INTERFACE
/**
 * @page page_iface_kde_auto_hide_screen_edge_v1 kde_auto_hide_screen_edge_v1
 * @section page_iface_kde_auto_hide_screen_edge_v1_desc Description
 *
 * The auto hide screen edge object allows to hide the surface and make it
 * visible by triggering the screen edge. The screen edge is inactive and
 * the surface is visible by default.
 *
 * This interface can be used to implement user interface elements such as
 * auto-hide panels or docks.
 *
 * kde_auto_hide_screen_edge_v1.activate activates the screen edge and makes
 * the surface hidden. The surface can be made visible by triggering the
 * screen edge or calling kde_auto_hide_screen_edge_v1.deactivate.
 *
 * If the screen edge has been triggered, it won't be re-activated again.
 * Another kde_auto_hide_screen_edge_v1.activate request must be made by the
 * client to activate the screen edge.
 * @section page_iface_kde_auto_hide_screen_edge_v1_api API
 * See @ref iface_kde_auto_hide_screen_edge_v1.
 */
/**
 * @defgroup iface_kde_auto_hide_screen_edge_v1 The kde_auto_hide_screen_edge_v1 interface
 *
 * The auto hide screen edge object allows to hide the surface and make it
 * visible by triggering the screen edge. The screen edge is inactive and
 * the surface is visible by default.
 *
 * This interface can be used to implement user interface elements such as
 * auto-hide panels or docks.
 *
 * kde_auto_hide_screen_edge_v1.activate activates the screen edge and makes
 * the surface hidden. The surface can be made visible by triggering the
 * screen edge or calling kde_auto_hide_screen_edge_v1.deactivate.
 *
 * If the screen edge has been triggered, it won't be re-activated again.
 * Another kde_auto_hide_screen_edge_v1.activate request must be made by the
 * client to activate the screen edge.
 */
extern const struct wl_interface kde_auto_hide_screen_edge_v1_interface;
#endif

#ifndef KDE_SCREEN_EDGE_MANAGER_V1_ERROR_ENUM
#define KDE_SCREEN_EDGE_MANAGER_V1_ERROR_ENUM
enum kde_screen_edge_manager_v1_error {
	/**
	 * the specified border value is invalid
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_ERROR_INVALID_BORDER = 0,
	/**
	 * the surface has invalid role
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_ERROR_INVALID_ROLE = 1,
	/**
	 * the surface already has a screen edge
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_ERROR_ALREADY_CONSTRUCTED = 2,
};
#endif /* KDE_SCREEN_EDGE_MANAGER_V1_ERROR_ENUM */

#ifndef KDE_SCREEN_EDGE_MANAGER_V1_BORDER_ENUM
#define KDE_SCREEN_EDGE_MANAGER_V1_BORDER_ENUM
/**
 * @ingroup iface_kde_screen_edge_manager_v1
 * screen border
 *
 * These values describe possible screen borders.
 */
enum kde_screen_edge_manager_v1_border {
	/**
	 * top screen edge
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_BORDER_TOP = 1,
	/**
	 * bottom screen edge
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_BORDER_BOTTOM = 2,
	/**
	 * left screen edge
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_BORDER_LEFT = 3,
	/**
	 * right screen edge
	 */
	KDE_SCREEN_EDGE_MANAGER_V1_BORDER_RIGHT = 4,
};
#endif /* KDE_SCREEN_EDGE_MANAGER_V1_BORDER_ENUM */

#define KDE_SCREEN_EDGE_MANAGER_V1_DESTROY 0
#define KDE_SCREEN_EDGE_MANAGER_V1_GET_AUTO_HIDE_SCREEN_EDGE 1


/**
 * @ingroup iface_kde_screen_edge_manager_v1
 */
#define KDE_SCREEN_EDGE_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_screen_edge_manager_v1
 */
#define KDE_SCREEN_EDGE_MANAGER_V1_GET_AUTO_HIDE_SCREEN_EDGE_SINCE_VERSION 1

/** @ingroup iface_kde_screen_edge_manager_v1 */
static inline void
kde_screen_edge_manager_v1_set_user_data(struct kde_screen_edge_manager_v1 *kde_screen_edge_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kde_screen_edge_manager_v1, user_data);
}

/** @ingroup iface_kde_screen_edge_manager_v1 */
static inline void *
kde_screen_edge_manager_v1_get_user_data(struct kde_screen_edge_manager_v1 *kde_screen_edge_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kde_screen_edge_manager_v1);
}

static inline uint32_t
kde_screen_edge_manager_v1_get_version(struct kde_screen_edge_manager_v1 *kde_screen_edge_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) kde_screen_edge_manager_v1);
}

/**
 * @ingroup iface_kde_screen_edge_manager_v1
 *
 * Destroy the screen edge manager. This doesn't destroy objects created
 * with this manager.
 */
static inline void
kde_screen_edge_manager_v1_destroy(struct kde_screen_edge_manager_v1 *kde_screen_edge_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_screen_edge_manager_v1,
			 KDE_SCREEN_EDGE_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_screen_edge_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_kde_screen_edge_manager_v1
 *
 * Create a new auto hide screen edge object associated with the specified
 * surface and the border.
 *
 * Creating a kde_auto_hide_screen_edge_v1 object does not change the
 * visibility of the surface. The kde_auto_hide_screen_edge_v1.activate
 * request must be issued in order to hide the surface.
 *
 * The "border" argument must be a valid enum entry, otherwise the
 * invalid_border protocol error is raised.
 *
 * The invalid_role protocol error will be raised if the specified surface
 * does not have layer_surface role.
 */
static inline struct kde_auto_hide_screen_edge_v1 *
kde_screen_edge_manager_v1_get_auto_hide_screen_edge(struct kde_screen_edge_manager_v1 *kde_screen_edge_manager_v1, uint32_t border, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) kde_screen_edge_manager_v1,
			 KDE_SCREEN_EDGE_MANAGER_V1_GET_AUTO_HIDE_SCREEN_EDGE, &kde_auto_hide_screen_edge_v1_interface, wl_proxy_get_version((struct wl_proxy *) kde_screen_edge_manager_v1), 0, NULL, border, surface);

	return (struct kde_auto_hide_screen_edge_v1 *) id;
}

#define KDE_AUTO_HIDE_SCREEN_EDGE_V1_DESTROY 0
#define KDE_AUTO_HIDE_SCREEN_EDGE_V1_DEACTIVATE 1
#define KDE_AUTO_HIDE_SCREEN_EDGE_V1_ACTIVATE 2


/**
 * @ingroup iface_kde_auto_hide_screen_edge_v1
 */
#define KDE_AUTO_HIDE_SCREEN_EDGE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_auto_hide_screen_edge_v1
 */
#define KDE_AUTO_HIDE_SCREEN_EDGE_V1_DEACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_auto_hide_screen_edge_v1
 */
#define KDE_AUTO_HIDE_SCREEN_EDGE_V1_ACTIVATE_SINCE_VERSION 1

/** @ingroup iface_kde_auto_hide_screen_edge_v1 */
static inline void
kde_auto_hide_screen_edge_v1_set_user_data(struct kde_auto_hide_screen_edge_v1 *kde_auto_hide_screen_edge_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kde_auto_hide_screen_edge_v1, user_data);
}

/** @ingroup iface_kde_auto_hide_screen_edge_v1 */
static inline void *
kde_auto_hide_screen_edge_v1_get_user_data(struct kde_auto_hide_screen_edge_v1 *kde_auto_hide_screen_edge_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kde_auto_hide_screen_edge_v1);
}

static inline uint32_t
kde_auto_hide_screen_edge_v1_get_version(struct kde_auto_hide_screen_edge_v1 *kde_auto_hide_screen_edge_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) kde_auto_hide_screen_edge_v1);
}

/**
 * @ingroup iface_kde_auto_hide_screen_edge_v1
 *
 * Destroy the auto hide screen edge object. If the screen edge is active,
 * it will be deactivated and the surface will be made visible.
 */
static inline void
kde_auto_hide_screen_edge_v1_destroy(struct kde_auto_hide_screen_edge_v1 *kde_auto_hide_screen_edge_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_auto_hide_screen_edge_v1,
			 KDE_AUTO_HIDE_SCREEN_EDGE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_auto_hide_screen_edge_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_kde_auto_hide_screen_edge_v1
 *
 * Deactivate the screen edge. The surface will be made visible.
 */
static inline void
kde_auto_hide_screen_edge_v1_deactivate(struct kde_auto_hide_screen_edge_v1 *kde_auto_hide_screen_edge_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_auto_hide_screen_edge_v1,
			 KDE_AUTO_HIDE_SCREEN_EDGE_V1_DEACTIVATE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_auto_hide_screen_edge_v1), 0);
}

/**
 * @ingroup iface_kde_auto_hide_screen_edge_v1
 *
 * Activate the screen edge. The surface will be hidden until the screen
 * edge is triggered.
 */
static inline void
kde_auto_hide_screen_edge_v1_activate(struct kde_auto_hide_screen_edge_v1 *kde_auto_hide_screen_edge_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_auto_hide_screen_edge_v1,
			 KDE_AUTO_HIDE_SCREEN_EDGE_V1_ACTIVATE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_auto_hide_screen_edge_v1), 0);
}

#ifdef  __cplusplus
}
#endif

#endif
