import { BinaryView } from "@ot-builder/bin-util";
import { Gpos, Gsub, GsubGpos } from "@ot-builder/ot-layout";
import { LookupReader, SubtableReadingContext } from "../gsub-gpos-shared/general";
declare abstract class ChainingContextualReader<L, CL extends L & GsubGpos.ChainingProp<L>> implements LookupReader<L, CL> {
    private chaining;
    constructor(chaining: boolean);
    abstract createLookup(): CL;
    parseSubtable(view: BinaryView, lookup: CL, ctx: SubtableReadingContext<L>): void;
}
export declare class GsubContextualReader extends ChainingContextualReader<Gsub.Lookup, Gsub.Chaining> {
    constructor();
    createLookup(): import("@ot-builder/prelude").CaseType<typeof Gsub.LookupType.Chaining, Gsub.ChainingProp>;
}
export declare class GsubChainingReader extends ChainingContextualReader<Gsub.Lookup, Gsub.Chaining> {
    constructor();
    createLookup(): import("@ot-builder/prelude").CaseType<typeof Gsub.LookupType.Chaining, Gsub.ChainingProp>;
}
export declare class GposContextualReader extends ChainingContextualReader<Gpos.Lookup, Gpos.Chaining> {
    constructor();
    createLookup(): import("@ot-builder/prelude").CaseType<typeof Gpos.LookupType.Chaining, Gpos.ChainingProp>;
}
export declare class GposChainingReader extends ChainingContextualReader<Gpos.Lookup, Gpos.Chaining> {
    constructor();
    createLookup(): import("@ot-builder/prelude").CaseType<typeof Gpos.LookupType.Chaining, Gpos.ChainingProp>;
}
export {};
//# sourceMappingURL=contextual-read.d.ts.map