"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeVttPrivate = exports.readVttPrivate = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ot_vtt_private_1 = require("@ot-builder/ot-vtt-private");
const read_1 = require("../tsi0123/read");
const write_1 = require("../tsi0123/write");
const tsi5_1 = require("../tsi5");
const tsic_1 = require("../tsic");
function readVttPrivate(sfnt, cfg, gOrd, md) {
    const result = {};
    if (cfg.vttPrivate.processVttPrivateTables) {
        const bTSI0 = sfnt.tables.get(ot_vtt_private_1.TSI0123.TagTSI0);
        const bTSI1 = sfnt.tables.get(ot_vtt_private_1.TSI0123.TagTSI1);
        if (bTSI0 && bTSI1) {
            result.tsi01 = (0, read_1.readTSI0123)(new bin_util_1.BinaryView(bTSI0), new bin_util_1.BinaryView(bTSI1), gOrd);
        }
        const bTSI2 = sfnt.tables.get(ot_vtt_private_1.TSI0123.TagTSI2);
        const bTSI3 = sfnt.tables.get(ot_vtt_private_1.TSI0123.TagTSI3);
        if (bTSI2 && bTSI3) {
            result.tsi23 = (0, read_1.readTSI0123)(new bin_util_1.BinaryView(bTSI2), new bin_util_1.BinaryView(bTSI3), gOrd);
        }
        const bTSI5 = sfnt.tables.get(ot_vtt_private_1.TSI5.Tag);
        if (bTSI5) {
            result.tsi5 = new bin_util_1.BinaryView(bTSI5).next(tsi5_1.TSI5Table, gOrd);
        }
        const bTSIC = sfnt.tables.get(ot_vtt_private_1.TSIC.Tag);
        if (bTSIC && md.fvar) {
            result.tsic = new bin_util_1.BinaryView(bTSIC).next(tsic_1.TsicTable, md.fvar.getDesignSpace());
        }
    }
    return result;
}
exports.readVttPrivate = readVttPrivate;
function writeVttPrivate(out, cfg, otVttPrivate, gOrd, md, eis) {
    if (!cfg.vttPrivate.processVttPrivateTables)
        return;
    if (otVttPrivate.tsi01) {
        const frTSI0 = new bin_util_1.Frag();
        const frTSI1 = new bin_util_1.Frag();
        const textProcessor = cfg.vttPrivate.recalculatePseudoInstructions
            ? new write_1.TSI01Processor(eis)
            : new write_1.NopProcessor();
        (0, write_1.writeTSI0123)(frTSI0, frTSI1, otVttPrivate.tsi01, gOrd, textProcessor);
        out.add(ot_vtt_private_1.TSI0123.TagTSI0, bin_util_1.Frag.pack(frTSI0));
        out.add(ot_vtt_private_1.TSI0123.TagTSI1, bin_util_1.Frag.pack(frTSI1));
    }
    if (otVttPrivate.tsi23) {
        const frTSI2 = new bin_util_1.Frag();
        const frTSI3 = new bin_util_1.Frag();
        (0, write_1.writeTSI0123)(frTSI2, frTSI3, otVttPrivate.tsi23, gOrd, new write_1.NopProcessor());
        out.add(ot_vtt_private_1.TSI0123.TagTSI2, bin_util_1.Frag.pack(frTSI2));
        out.add(ot_vtt_private_1.TSI0123.TagTSI3, bin_util_1.Frag.pack(frTSI3));
    }
    if (otVttPrivate.tsi5) {
        out.add(ot_vtt_private_1.TSI5.Tag, bin_util_1.Frag.packFrom(tsi5_1.TSI5Table, otVttPrivate.tsi5, gOrd));
    }
    if (otVttPrivate.tsic && md.fvar) {
        out.add(ot_vtt_private_1.TSIC.Tag, bin_util_1.Frag.packFrom(tsic_1.TsicTable, otVttPrivate.tsic, md.fvar.getDesignSpace()));
    }
}
exports.writeVttPrivate = writeVttPrivate;
//# sourceMappingURL=index.js.map