//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armreservations_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/reservations/armreservations/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/CalculateRefund.json
func ExampleCalculateRefundClient_Post() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCalculateRefundClient().Post(ctx, "276e7ae4-84d0-4da6-ab4b-d6b94f3557da", armreservations.CalculateRefundRequest{
		ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/50000000-aaaa-bbbb-cccc-100000000004"),
		Properties: &armreservations.CalculateRefundRequestProperties{
			ReservationToReturn: &armreservations.ReservationToReturn{
				Quantity:      to.Ptr[int32](1),
				ReservationID: to.Ptr("/providers/microsoft.capacity/reservationOrders/50000000-aaaa-bbbb-cccc-100000000004/reservations/40000000-aaaa-bbbb-cccc-100000000000"),
			},
			Scope: to.Ptr("Reservation"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CalculateRefundResponse = armreservations.CalculateRefundResponse{
	// 	ID: to.Ptr("/providers/Microsoft.Capacity/reservationOrders/50000000-aaaa-bbbb-cccc-100000000004/reservations/40000000-aaaa-bbbb-cccc-100000000000"),
	// 	Properties: &armreservations.RefundResponseProperties{
	// 		BillingInformation: &armreservations.RefundBillingInformation{
	// 			BillingCurrencyProratedAmount: &armreservations.Price{
	// 				Amount: to.Ptr[float64](3.28),
	// 				CurrencyCode: to.Ptr("GBP"),
	// 			},
	// 			BillingCurrencyRemainingCommitmentAmount: &armreservations.Price{
	// 				Amount: to.Ptr[float64](0),
	// 				CurrencyCode: to.Ptr("GBP"),
	// 			},
	// 			BillingCurrencyTotalPaidAmount: &armreservations.Price{
	// 				Amount: to.Ptr[float64](24),
	// 				CurrencyCode: to.Ptr("GBP"),
	// 			},
	// 			BillingPlan: to.Ptr(armreservations.ReservationBillingPlanUpfront),
	// 			CompletedTransactions: to.Ptr[int32](1),
	// 			TotalTransactions: to.Ptr[int32](1),
	// 		},
	// 		BillingRefundAmount: &armreservations.Price{
	// 			Amount: to.Ptr[float64](20.72),
	// 			CurrencyCode: to.Ptr("GBP"),
	// 		},
	// 		PolicyResult: &armreservations.RefundPolicyResult{
	// 			Properties: &armreservations.RefundPolicyResultProperty{
	// 				ConsumedRefundsTotal: &armreservations.Price{
	// 					Amount: to.Ptr[float64](83.69),
	// 					CurrencyCode: to.Ptr("USD"),
	// 				},
	// 				MaxRefundLimit: &armreservations.Price{
	// 					Amount: to.Ptr[float64](50000),
	// 					CurrencyCode: to.Ptr("USD"),
	// 				},
	// 				PolicyErrors: []*armreservations.RefundPolicyError{
	// 					{
	// 						Code: to.Ptr(armreservations.ErrorResponseCodeSelfServiceRefundNotSupported),
	// 						Message: to.Ptr("Self Service refunds are currently not supported for this resource, please contact support."),
	// 				}},
	// 			},
	// 		},
	// 		PricingRefundAmount: &armreservations.Price{
	// 			Amount: to.Ptr[float64](24.92),
	// 			CurrencyCode: to.Ptr("USD"),
	// 		},
	// 		Quantity: to.Ptr[int32](1),
	// 		SessionID: to.Ptr("10000000-aaaa-bbbb-cccc-200000000000"),
	// 	},
	// }
}
