//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// HealthReportServer is a fake server for instances of the armsecurity.HealthReportClient type.
type HealthReportServer struct {
	// Get is the fake for method HealthReportClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceID string, healthReportName string, options *armsecurity.HealthReportClientGetOptions) (resp azfake.Responder[armsecurity.HealthReportClientGetResponse], errResp azfake.ErrorResponder)
}

// NewHealthReportServerTransport creates a new instance of HealthReportServerTransport with the provided implementation.
// The returned HealthReportServerTransport instance is connected to an instance of armsecurity.HealthReportClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewHealthReportServerTransport(srv *HealthReportServer) *HealthReportServerTransport {
	return &HealthReportServerTransport{srv: srv}
}

// HealthReportServerTransport connects instances of armsecurity.HealthReportClient to instances of HealthReportServer.
// Don't use this type directly, use NewHealthReportServerTransport instead.
type HealthReportServerTransport struct {
	srv *HealthReportServer
}

// Do implements the policy.Transporter interface for HealthReportServerTransport.
func (h *HealthReportServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "HealthReportClient.Get":
		resp, err = h.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (h *HealthReportServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if h.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/healthReports/(?P<healthReportName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	healthReportNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("healthReportName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Get(req.Context(), resourceIDParam, healthReportNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HealthReport, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
