
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAudioDevice.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAudioDevice>
#include <QAudioFormat>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAudioDevice

//  Constructor QAudioDevice::QAudioDevice()


static void _init_ctor_QAudioDevice_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QAudioDevice> ();
}

static void _call_ctor_QAudioDevice_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioDevice *> (new QAudioDevice ());
}


//  Constructor QAudioDevice::QAudioDevice(const QAudioDevice &other)


static void _init_ctor_QAudioDevice_2484 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QAudioDevice & > (argspec_0);
  decl->set_return_new<QAudioDevice> ();
}

static void _call_ctor_QAudioDevice_2484 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioDevice &arg1 = gsi::arg_reader<const QAudioDevice & >() (args, heap);
  ret.write<QAudioDevice *> (new QAudioDevice (arg1));
}


// QString QAudioDevice::description()


static void _init_f_description_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_description_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAudioDevice *)cls)->description ());
}


// QByteArray QAudioDevice::id()


static void _init_f_id_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_id_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QAudioDevice *)cls)->id ());
}


// bool QAudioDevice::isDefault()


static void _init_f_isDefault_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDefault_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAudioDevice *)cls)->isDefault ());
}


// bool QAudioDevice::isFormatSupported(const QAudioFormat &format)


static void _init_f_isFormatSupported_c2509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isFormatSupported_c2509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = gsi::arg_reader<const QAudioFormat & >() (args, heap);
  ret.write<bool > ((bool)((QAudioDevice *)cls)->isFormatSupported (arg1));
}


// bool QAudioDevice::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAudioDevice *)cls)->isNull ());
}


// int QAudioDevice::maximumChannelCount()


static void _init_f_maximumChannelCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumChannelCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAudioDevice *)cls)->maximumChannelCount ());
}


// int QAudioDevice::maximumSampleRate()


static void _init_f_maximumSampleRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumSampleRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAudioDevice *)cls)->maximumSampleRate ());
}


// int QAudioDevice::minimumChannelCount()


static void _init_f_minimumChannelCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumChannelCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAudioDevice *)cls)->minimumChannelCount ());
}


// int QAudioDevice::minimumSampleRate()


static void _init_f_minimumSampleRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumSampleRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAudioDevice *)cls)->minimumSampleRate ());
}


// QAudioDevice::Mode QAudioDevice::mode()


static void _init_f_mode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudioDevice::Mode>::target_type > ();
}

static void _call_f_mode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudioDevice::Mode>::target_type > ((qt_gsi::Converter<QAudioDevice::Mode>::target_type)qt_gsi::CppToQtAdaptor<QAudioDevice::Mode>(((QAudioDevice *)cls)->mode ()));
}


// bool QAudioDevice::operator!=(const QAudioDevice &other)


static void _init_f_operator_excl__eq__c2484 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QAudioDevice & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2484 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioDevice &arg1 = gsi::arg_reader<const QAudioDevice & >() (args, heap);
  ret.write<bool > ((bool)((QAudioDevice *)cls)->operator!= (arg1));
}


// QAudioDevice &QAudioDevice::operator=(const QAudioDevice &other)


static void _init_f_operator_eq__2484 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QAudioDevice & > (argspec_0);
  decl->set_return<QAudioDevice & > ();
}

static void _call_f_operator_eq__2484 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioDevice &arg1 = gsi::arg_reader<const QAudioDevice & >() (args, heap);
  ret.write<QAudioDevice & > ((QAudioDevice &)((QAudioDevice *)cls)->operator= (arg1));
}


// bool QAudioDevice::operator==(const QAudioDevice &other)


static void _init_f_operator_eq__eq__c2484 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QAudioDevice & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2484 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioDevice &arg1 = gsi::arg_reader<const QAudioDevice & >() (args, heap);
  ret.write<bool > ((bool)((QAudioDevice *)cls)->operator== (arg1));
}


// QAudioFormat QAudioDevice::preferredFormat()


static void _init_f_preferredFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioFormat > ();
}

static void _call_f_preferredFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioFormat > ((QAudioFormat)((QAudioDevice *)cls)->preferredFormat ());
}


// QList<QAudioFormat::SampleFormat> QAudioDevice::supportedSampleFormats()


static void _init_f_supportedSampleFormats_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAudioFormat::SampleFormat> > ();
}

static void _call_f_supportedSampleFormats_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAudioFormat::SampleFormat> > ((QList<QAudioFormat::SampleFormat>)((QAudioDevice *)cls)->supportedSampleFormats ());
}


// void QAudioDevice::swap(QAudioDevice &other)


static void _init_f_swap_1789 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<QAudioDevice & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_swap_1789 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAudioDevice &arg1 = gsi::arg_reader<QAudioDevice & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDevice *)cls)->swap (arg1);
}



namespace gsi
{

static gsi::Methods methods_QAudioDevice () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAudioDevice::QAudioDevice()\nThis method creates an object of class QAudioDevice.", &_init_ctor_QAudioDevice_0, &_call_ctor_QAudioDevice_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAudioDevice::QAudioDevice(const QAudioDevice &other)\nThis method creates an object of class QAudioDevice.", &_init_ctor_QAudioDevice_2484, &_call_ctor_QAudioDevice_2484);
  methods += new qt_gsi::GenericMethod ("description", "@brief Method QString QAudioDevice::description()\n", true, &_init_f_description_c0, &_call_f_description_c0);
  methods += new qt_gsi::GenericMethod ("id", "@brief Method QByteArray QAudioDevice::id()\n", true, &_init_f_id_c0, &_call_f_id_c0);
  methods += new qt_gsi::GenericMethod ("isDefault?", "@brief Method bool QAudioDevice::isDefault()\n", true, &_init_f_isDefault_c0, &_call_f_isDefault_c0);
  methods += new qt_gsi::GenericMethod ("isFormatSupported?", "@brief Method bool QAudioDevice::isFormatSupported(const QAudioFormat &format)\n", true, &_init_f_isFormatSupported_c2509, &_call_f_isFormatSupported_c2509);
  methods += new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QAudioDevice::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
  methods += new qt_gsi::GenericMethod ("maximumChannelCount", "@brief Method int QAudioDevice::maximumChannelCount()\n", true, &_init_f_maximumChannelCount_c0, &_call_f_maximumChannelCount_c0);
  methods += new qt_gsi::GenericMethod ("maximumSampleRate", "@brief Method int QAudioDevice::maximumSampleRate()\n", true, &_init_f_maximumSampleRate_c0, &_call_f_maximumSampleRate_c0);
  methods += new qt_gsi::GenericMethod ("minimumChannelCount", "@brief Method int QAudioDevice::minimumChannelCount()\n", true, &_init_f_minimumChannelCount_c0, &_call_f_minimumChannelCount_c0);
  methods += new qt_gsi::GenericMethod ("minimumSampleRate", "@brief Method int QAudioDevice::minimumSampleRate()\n", true, &_init_f_minimumSampleRate_c0, &_call_f_minimumSampleRate_c0);
  methods += new qt_gsi::GenericMethod ("mode", "@brief Method QAudioDevice::Mode QAudioDevice::mode()\n", true, &_init_f_mode_c0, &_call_f_mode_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QAudioDevice::operator!=(const QAudioDevice &other)\n", true, &_init_f_operator_excl__eq__c2484, &_call_f_operator_excl__eq__c2484);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QAudioDevice &QAudioDevice::operator=(const QAudioDevice &other)\n", false, &_init_f_operator_eq__2484, &_call_f_operator_eq__2484);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QAudioDevice::operator==(const QAudioDevice &other)\n", true, &_init_f_operator_eq__eq__c2484, &_call_f_operator_eq__eq__c2484);
  methods += new qt_gsi::GenericMethod ("preferredFormat", "@brief Method QAudioFormat QAudioDevice::preferredFormat()\n", true, &_init_f_preferredFormat_c0, &_call_f_preferredFormat_c0);
  methods += new qt_gsi::GenericMethod ("supportedSampleFormats", "@brief Method QList<QAudioFormat::SampleFormat> QAudioDevice::supportedSampleFormats()\n", true, &_init_f_supportedSampleFormats_c0, &_call_f_supportedSampleFormats_c0);
  methods += new qt_gsi::GenericMethod ("swap", "@brief Method void QAudioDevice::swap(QAudioDevice &other)\n", false, &_init_f_swap_1789, &_call_f_swap_1789);
  return methods;
}

gsi::Class<QAudioDevice> decl_QAudioDevice ("QtMultimedia", "QAudioDevice",
  methods_QAudioDevice (),
  "@qt\n@brief Binding of QAudioDevice");


GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QAudioDevice> &qtdecl_QAudioDevice () { return decl_QAudioDevice; }

}


//  Implementation of the enum wrapper class for QAudioDevice::Mode
namespace qt_gsi
{

static gsi::Enum<QAudioDevice::Mode> decl_QAudioDevice_Mode_Enum ("QtMultimedia", "QAudioDevice_Mode",
    gsi::enum_const ("Null", QAudioDevice::Null, "@brief Enum constant QAudioDevice::Null") +
    gsi::enum_const ("Input", QAudioDevice::Input, "@brief Enum constant QAudioDevice::Input") +
    gsi::enum_const ("Output", QAudioDevice::Output, "@brief Enum constant QAudioDevice::Output"),
  "@qt\n@brief This class represents the QAudioDevice::Mode enum");

static gsi::QFlagsClass<QAudioDevice::Mode > decl_QAudioDevice_Mode_Enums ("QtMultimedia", "QAudioDevice_QFlags_Mode",
  "@qt\n@brief This class represents the QFlags<QAudioDevice::Mode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAudioDevice> inject_QAudioDevice_Mode_Enum_in_parent (decl_QAudioDevice_Mode_Enum.defs ());
static gsi::ClassExt<QAudioDevice> decl_QAudioDevice_Mode_Enum_as_child (decl_QAudioDevice_Mode_Enum, "Mode");
static gsi::ClassExt<QAudioDevice> decl_QAudioDevice_Mode_Enums_as_child (decl_QAudioDevice_Mode_Enums, "QFlags_Mode");

}

