execute_process(
    COMMAND git rev-parse --short main
    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
    OUTPUT_VARIABLE HEAD_SHA1_MAIN
    OUTPUT_STRIP_TRAILING_WHITESPACE
)

message("HEAD_SHA1_MAIN: ${HEAD_SHA1_MAIN}")

execute_process(
    COMMAND git log -1 --format=%cd --date=format:%Y%m%d ${HEAD_SHA1_MAIN}
    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
    OUTPUT_VARIABLE COMMIT_DATE
    OUTPUT_STRIP_TRAILING_WHITESPACE
)

message(STATUS "COMMIT_DATE: ${COMMIT_DATE}")

set(GIT_RECORD_IDENTIFIER "build-${COMMIT_DATE}-${HEAD_SHA1_MAIN}")

message(STATUS "GIT_RECORD_IDENTIFIER: ${GIT_RECORD_IDENTIFIER}")
