# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ChangeDetectionMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Change Detection Mode. Applies to a directory specified in directoryPath parameter."""

    DEFAULT = "Default"
    RECURSIVE = "Recursive"


class CloudEndpointChangeEnumerationActivityState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of change enumeration activity."""

    INITIAL_ENUMERATION_IN_PROGRESS = "InitialEnumerationInProgress"
    ENUMERATION_IN_PROGRESS = "EnumerationInProgress"


class CloudEndpointChangeEnumerationTotalCountsState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the total counts of change enumeration activity."""

    CALCULATING = "Calculating"
    FINAL = "Final"


class CloudTieringLowDiskModeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the cloud tiering low disk mode state."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class FeatureStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the Feature Status."""

    ON = "on"
    OFF = "off"


class IncomingTrafficPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the Incoming Traffic Policy."""

    ALLOW_ALL_TRAFFIC = "AllowAllTraffic"
    ALLOW_VIRTUAL_NETWORKS_ONLY = "AllowVirtualNetworksOnly"


class InitialDownloadPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Policy for how namespace and files are recalled during FastDr."""

    NAMESPACE_ONLY = "NamespaceOnly"
    NAMESPACE_THEN_MODIFIED_FILES = "NamespaceThenModifiedFiles"
    AVOID_TIERED_FILES = "AvoidTieredFiles"


class InitialUploadPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Policy for how the initial upload sync session is performed."""

    SERVER_AUTHORITATIVE = "ServerAuthoritative"
    MERGE = "Merge"


class LocalCacheMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Policy for enabling follow-the-sun business models: link local cache to cloud behavior to
    pre-populate before local access.
    """

    DOWNLOAD_NEW_AND_MODIFIED_FILES = "DownloadNewAndModifiedFiles"
    UPDATE_LOCALLY_CACHED_FILES = "UpdateLocallyCachedFiles"


class NameAvailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the reason that a Storage Sync Service name could not be used. The Reason element is only
    returned if NameAvailable is false.
    """

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class OperationDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the Operation Direction."""

    DO = "do"
    UNDO = "undo"
    CANCEL = "cancel"


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"


class ProgressType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the ProgressType."""

    NONE = "none"
    INITIALIZE = "initialize"
    DOWNLOAD = "download"
    UPLOAD = "upload"
    RECALL = "recall"


class Reason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of Azure Subscription."""

    REGISTERED = "Registered"
    UNREGISTERED = "Unregistered"
    WARNED = "Warned"
    SUSPENDED = "Suspended"
    DELETED = "Deleted"


class RegisteredServerAgentVersionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the registered server agent version status."""

    OK = "Ok"
    NEAR_EXPIRY = "NearExpiry"
    EXPIRED = "Expired"
    BLOCKED = "Blocked"


class ServerEndpointHealthState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the server endpoint health state."""

    UNAVAILABLE = "Unavailable"
    HEALTHY = "Healthy"
    ERROR = "Error"


class ServerEndpointOfflineDataTransferState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the Health state."""

    IN_PROGRESS = "InProgress"
    STOPPING = "Stopping"
    NOT_RUNNING = "NotRunning"
    COMPLETE = "Complete"


class ServerEndpointSyncActivityState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the sync activity state."""

    UPLOAD = "Upload"
    DOWNLOAD = "Download"
    UPLOAD_AND_DOWNLOAD = "UploadAndDownload"


class ServerEndpointSyncMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sync mode for the server endpoint."""

    REGULAR = "Regular"
    NAMESPACE_DOWNLOAD = "NamespaceDownload"
    INITIAL_UPLOAD = "InitialUpload"
    SNAPSHOT_UPLOAD = "SnapshotUpload"
    INITIAL_FULL_DOWNLOAD = "InitialFullDownload"


class WorkflowStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the Workflow Status."""

    ACTIVE = "active"
    EXPIRED = "expired"
    SUCCEEDED = "succeeded"
    ABORTED = "aborted"
    FAILED = "failed"
