---
layout: post
title: Polyglot 1.11 - 기타 수정사항 릴리스
lang: ko
description: Jekyll Polyglot 1.11.0 릴리스는 다양한 업데이트와 아랍어 및 일본어 사이트 언어 지원과 함께 제공됩니다
---

Jekyll Polyglot 1.11.0이 출시되었습니다. 최근까지 해결하기 어려웠던 까다로운 버그들에 대한 수정사항을 포함하고 있습니다. 이 릴리스는 당신과 같은 기여자들과 사용자들 덕분에 가능했습니다.

## jekyll 테마와의 충돌 수정

[minimal-mistakes](https://github.com/mmistakes/minimal-mistakes/blob/master/_config.yml#L168-L169)나 [chirpy](https://github.com/cotes2020/jekyll-theme-chirpy/blob/master/_config.yml#L208-L210)와 같은 다른 jekyll 테마들은 `exclude:` 설정에서 glob 패턴을 사용하는데, 이전에는 URL 상대화를 사용하는 웹사이트의 polyglot 처리와 충돌했습니다. [@mattions](https://github.com/mattions)이 상대화 정규식에 적용되기 전에 이러한 값들을 `regex.escape`하는 수정사항을 기여했습니다.

이 조정은 다른 일반적인 jekyll 테마와 함께 polyglot을 즉시 사용하는 데 도움이 될 것입니다.

## 기타 다양한 수정사항

* [:polyglot, :post_write 훅이 사이트를 올바르게 전달](https://github.com/untra/polyglot/pull/266)
* [i18n_headers x-default 값이 사이트 URL과 올바르게 일치](https://github.com/untra/polyglot/pull/262)
* [codecov 및 ci 조정](https://github.com/untra/polyglot/pull/263)

## 일본어 및 아랍어 지원

polyglot 웹사이트는 이제 [아랍어](https://polyglot.untra.io/ar/)와 [일본어](https://polyglot.untra.io/jp/)로 번역된 지원 버전을 가지고 있습니다. 이러한 사이트 번역은 AI의 도움으로 만들어졌습니다; 잘못 번역된 부분이 있다면 더 나은 수정사항을 기여해 주세요!
