use core:debug;

class Cons {
	Int value;
	Cons? next;

	init(Int value) {
		init() { value = value; }
	}

	init(Int value, Cons next) {
		init() { value = value; next = next; }
	}

	init(Int value, Cons? next) {
		init() { value = value; next = next; }
	}

	Str toS() {
		if (next) {
			value # ", " # next;
		} else {
			value.toS;
		}
	}
}

Cons create(Int len) {
	if (len > 0) {
		Cons(len, create(len - 1));
	} else {
		Cons(len);
	}
}

Cons? append(Cons? a, Cons? b) {
	if (a) {
		?Cons(a.value, append(a.next, b));
	} else {
		b;
	}
}

Cons? reverse(Cons? a) {
	Cons? r;
	if (a) {
		r = append(reverse(a.next), Cons(a.value));
	}
	r;
}

void testReverse() {
	Moment start;

	reverse(create(3000));

	print("Total time: " # (Moment() - start).inMs);
}

void fullReverse() {
	for (Int i = 0; i < 100; i++)
		testReverse();
}
