/*
 * QT Client for X2GoKDrive
 * Copyright (C) 2018-2023 Oleksandr Shneyder <o.shneyder@phoca-gmbh.de>
 * Copyright (C) 2018-2023 phoca-GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef DISPLAYAREA_H
#define DISPLAYAREA_H
#include <QFrame>

#ifdef Q_OS_WIN
#include <Windows.h>
#endif

class Client;
class QPainter;
class QTimer;
class DisplayArea : public QFrame
{
#ifdef Q_OS_WIN
    friend LRESULT CALLBACK LowLevelKeyboardProc(_In_ int    nCode, _In_ WPARAM wParam, _In_ LPARAM lParam );
#endif
    Q_OBJECT
public:
    DisplayArea(Client* client, QWidget* parentWidget);
    ~DisplayArea();
private:
    Client* client;
    QWidget* parentWidget;

protected:
    void paintEvent(QPaintEvent *);
    void mouseMoveEvent(QMouseEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

    void keyPressEvent(QKeyEvent *event);
    void keyReleaseEvent(QKeyEvent *event);
    void wheelEvent(QWheelEvent *event);

private:
    uint32_t X11MouseButtonsState(Qt::MouseButtons qtMouseButtons);
    uint32_t X11MouseButton(Qt::MouseButton qtMouseButton);
//     void debugLinuxMods(uint32_t nativeModifiers);
    uint32_t qtModifiers2pc105(Qt::KeyboardModifiers qtModifiers );
    void grabKeyboard();

#ifdef Q_OS_WIN
    static uint32_t win2pc105(uint32_t nativeCode);
    uint32_t qtwinModifiers2pc105(uint32_t nativeModifiers, Qt::KeyboardModifiers qtModifiers );
#endif
};

#endif // DISPLAYAREA_H
