/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.BaseDescriptionImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.ExportPackageDescriptionImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.GenericDescriptionImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.ImportPackageSpecificationImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.VersionConstraintImpl;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateWire;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;

final class BundleDescriptionImpl
extends BaseDescriptionImpl
implements BundleDescription,
KeyedElement {
    static final String[] EMPTY_STRING = new String[0];
    static final ImportPackageSpecification[] EMPTY_IMPORTS = new ImportPackageSpecification[0];
    static final BundleSpecification[] EMPTY_BUNDLESPECS = new BundleSpecification[0];
    static final ExportPackageDescription[] EMPTY_EXPORTS = new ExportPackageDescription[0];
    static final BundleDescription[] EMPTY_BUNDLEDESCS = new BundleDescription[0];
    static final GenericSpecification[] EMPTY_GENERICSPECS = new GenericSpecification[0];
    static final GenericDescription[] EMPTY_GENERICDESCS = new GenericDescription[0];
    static final int RESOLVED = 1;
    static final int SINGLETON = 2;
    static final int REMOVAL_PENDING = 4;
    static final int FULLY_LOADED = 8;
    static final int LAZY_LOADED = 16;
    static final int HAS_DYNAMICIMPORT = 32;
    static final int ATTACH_FRAGMENTS = 64;
    static final int DYNAMIC_FRAGMENTS = 128;
    private volatile int stateBits = 200;
    private volatile long bundleId = -1L;
    volatile HostSpecification host;
    private List<BundleDescription> dependents;
    private String[] mandatory;
    private Map<String, Object> attributes;
    private Map<String, String> arbitraryDirectives;
    private volatile LazyData lazyData;
    private volatile int equinox_ee = -1;
    private DescriptionWiring bundleWiring;

    public long getBundleId() {
        return this.bundleId;
    }

    public String getSymbolicName() {
        return this.getName();
    }

    public BundleDescription getSupplier() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocation() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return currentData.location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlatformFilter() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return currentData.platformFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExecutionEnvironments() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.executionEnvironments == null) {
                return EMPTY_STRING;
            }
            return currentData.executionEnvironments;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportPackageSpecification[] getImportPackages() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.importPackages == null) {
                return EMPTY_IMPORTS;
            }
            return currentData.importPackages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportPackageSpecification[] getAddedDynamicImportPackages() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.addedDynamicImports == null) {
                return EMPTY_IMPORTS;
            }
            return currentData.addedDynamicImports.toArray(new ImportPackageSpecification[currentData.addedDynamicImports.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleSpecification[] getRequiredBundles() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.requiredBundles == null) {
                return EMPTY_BUNDLESPECS;
            }
            return currentData.requiredBundles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericSpecification[] getGenericRequires() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.genericRequires == null) {
                return EMPTY_GENERICSPECS;
            }
            return currentData.genericRequires;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericDescription[] getGenericCapabilities() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.genericCapabilities == null) {
                return EMPTY_GENERICDESCS;
            }
            return currentData.genericCapabilities;
        }
    }

    public NativeCodeSpecification getNativeCodeSpecification() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportPackageDescription[] getExportPackages() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return currentData.exportPackages == null ? EMPTY_EXPORTS : currentData.exportPackages;
        }
    }

    public boolean isResolved() {
        return (this.stateBits & 1) != 0;
    }

    public State getContainingState() {
        return null;
    }

    public BundleDescription[] getFragments() {
        if (this.host != null) {
            return EMPTY_BUNDLEDESCS;
        }
        throw new IllegalStateException("BundleDescription does not belong to a state.");
    }

    public HostSpecification getHost() {
        return this.host;
    }

    public boolean isSingleton() {
        return (this.stateBits & 2) != 0;
    }

    public boolean isRemovalPending() {
        return (this.stateBits & 4) != 0;
    }

    public boolean hasDynamicImports() {
        return (this.stateBits & 0x20) != 0;
    }

    public boolean attachFragments() {
        return (this.stateBits & 0x40) != 0;
    }

    public boolean dynamicFragments() {
        return (this.stateBits & 0x80) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportPackageDescription[] getSelectedExports() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.selectedExports == null) {
                return EMPTY_EXPORTS;
            }
            return currentData.selectedExports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericDescription[] getSelectedGenericCapabilities() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.selectedCapabilities == null) {
                return EMPTY_GENERICDESCS;
            }
            return currentData.selectedCapabilities;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportPackageDescription[] getSubstitutedExports() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.substitutedExports == null) {
                return EMPTY_EXPORTS;
            }
            return currentData.substitutedExports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleDescription[] getResolvedRequires() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.resolvedRequires == null) {
                return EMPTY_BUNDLEDESCS;
            }
            return currentData.resolvedRequires;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportPackageDescription[] getResolvedImports() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.resolvedImports == null) {
                return EMPTY_EXPORTS;
            }
            return currentData.resolvedImports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericDescription[] getResolvedGenericRequires() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.resolvedCapabilities == null) {
                return EMPTY_GENERICDESCS;
            }
            return currentData.resolvedCapabilities;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<StateWire>> getWires() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.stateWires == null) {
                currentData.stateWires = new HashMap<String, List<StateWire>>(0);
            }
            return currentData.stateWires;
        }
    }

    protected void setBundleId(long bundleId) {
        this.bundleId = bundleId;
    }

    protected void setSymbolicName(String symbolicName) {
        this.setName(symbolicName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocation(String location) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.location = location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPlatformFilter(String platformFilter) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.platformFilter = platformFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExecutionEnvironments(String[] executionEnvironments) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.executionEnvironments = executionEnvironments == null || executionEnvironments.length > 0 ? executionEnvironments : EMPTY_STRING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExportPackages(ExportPackageDescription[] exportPackages) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            ExportPackageDescription[] exportPackageDescriptionArray = this.lazyData.exportPackages = exportPackages == null || exportPackages.length > 0 ? exportPackages : EMPTY_EXPORTS;
            if (exportPackages != null) {
                ExportPackageDescription[] exportPackageDescriptionArray2 = exportPackages;
                int n = exportPackages.length;
                int n2 = 0;
                while (n2 < n) {
                    ExportPackageDescription exportPackage = exportPackageDescriptionArray2[n2];
                    ((ExportPackageDescriptionImpl)exportPackage).setExporter(this);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setImportPackages(ImportPackageSpecification[] importPackages) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            ImportPackageSpecification[] importPackageSpecificationArray = this.lazyData.importPackages = importPackages == null || importPackages.length > 0 ? importPackages : EMPTY_IMPORTS;
            if (importPackages != null) {
                ImportPackageSpecification[] importPackageSpecificationArray2 = importPackages;
                int n = importPackages.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportPackageSpecification importPackage = importPackageSpecificationArray2[n2];
                    ((ImportPackageSpecificationImpl)importPackage).setBundle(this);
                    if ("dynamic".equals(importPackage.getDirective("resolution"))) {
                        this.stateBits |= 0x20;
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRequiredBundles(BundleSpecification[] requiredBundles) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            BundleSpecification[] bundleSpecificationArray = this.lazyData.requiredBundles = requiredBundles == null || requiredBundles.length > 0 ? requiredBundles : EMPTY_BUNDLESPECS;
            if (requiredBundles != null) {
                BundleSpecification[] bundleSpecificationArray2 = requiredBundles;
                int n = requiredBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleSpecification requiredBundle = bundleSpecificationArray2[n2];
                    ((VersionConstraintImpl)requiredBundle).setBundle(this);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGenericCapabilities(GenericDescription[] genericCapabilities) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            GenericDescription[] genericDescriptionArray = this.lazyData.genericCapabilities = genericCapabilities == null || genericCapabilities.length > 0 ? genericCapabilities : EMPTY_GENERICDESCS;
            if (genericCapabilities != null) {
                GenericDescription[] genericDescriptionArray2 = genericCapabilities;
                int n = genericCapabilities.length;
                int n2 = 0;
                while (n2 < n) {
                    GenericDescription genericCapability = genericDescriptionArray2[n2];
                    ((GenericDescriptionImpl)genericCapability).setSupplier(this);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGenericRequires(GenericSpecification[] genericRequires) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            GenericSpecification[] genericSpecificationArray = this.lazyData.genericRequires = genericRequires == null || genericRequires.length > 0 ? genericRequires : EMPTY_GENERICSPECS;
            if (genericRequires != null) {
                GenericSpecification[] genericSpecificationArray2 = genericRequires;
                int n = genericRequires.length;
                int n2 = 0;
                while (n2 < n) {
                    GenericSpecification genericRequire = genericSpecificationArray2[n2];
                    ((VersionConstraintImpl)genericRequire).setBundle(this);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStateBit(int stateBit, boolean on) {
        Object object = this.monitor;
        synchronized (object) {
            if (on) {
                this.stateBits |= stateBit;
            } else {
                this.stateBits &= ~stateBit;
                if (stateBit == 1) {
                    if (this.bundleWiring != null) {
                        this.bundleWiring.invalidate();
                    }
                    this.bundleWiring = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHost(HostSpecification host) {
        Object object = this.monitor;
        synchronized (object) {
            this.host = host;
            if (host != null) {
                ((VersionConstraintImpl)host).setBundle(this);
            }
        }
    }

    public String toString() {
        if (this.getSymbolicName() == null) {
            return "[" + this.getBundleId() + "]";
        }
        return this.getSymbolicName() + "_" + String.valueOf(this.getVersion());
    }

    public Object getKey() {
        return this.bundleId;
    }

    /*
     * WARNING - void declaration
     */
    public boolean compare(KeyedElement other) {
        void otherBundleDescription;
        if (!(other instanceof BundleDescriptionImpl)) {
            return false;
        }
        BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)other;
        return this.bundleId == otherBundleDescription.bundleId;
    }

    public int getKeyHashCode() {
        return (int)(this.bundleId ^ this.bundleId >>> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleDescription[] getDependents() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.dependents == null) {
                return EMPTY_BUNDLEDESCS;
            }
            return this.dependents.toArray(new BundleDescription[this.dependents.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasDependents() {
        Object object = this.monitor;
        synchronized (object) {
            return this.dependents == null ? false : this.dependents.size() > 0;
        }
    }

    private LazyData loadLazyData() {
        if ((this.stateBits & 0x10) == 0) {
            return this.lazyData;
        }
        throw new IllegalStateException("No valid reader for the bundle description");
    }

    public void setEquinoxEE(int equinox_ee) {
        this.equinox_ee = equinox_ee;
    }

    public int getEquinoxEE() {
        return this.equinox_ee;
    }

    private void checkLazyData() {
        if (this.lazyData == null) {
            this.lazyData = new LazyData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getAttributes() {
        Object object = this.monitor;
        synchronized (object) {
            return this.attributes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributes(Map<String, ?> attributes) {
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = attributes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getDirective(String key) {
        Object object = this.monitor;
        synchronized (object) {
            block8: {
                block10: {
                    block9: {
                        if ("mandatory".equals(key)) {
                            return this.mandatory;
                        }
                        if ("singleton".equals(key)) {
                            return this.isSingleton() ? Boolean.TRUE : Boolean.FALSE;
                        }
                        if (!"fragment-attachment".equals(key)) break block8;
                        if (this.attachFragments()) break block9;
                        return "never";
                    }
                    if (!this.dynamicFragments()) break block10;
                    return "always";
                }
                return "resolve-time";
            }
        }
        return null;
    }

    void setDirective(String key, Object value) {
        if ("mandatory".equals(key)) {
            this.mandatory = (String[])value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setArbitraryDirectives(Map<String, ?> directives) {
        Object object = this.monitor;
        synchronized (object) {
            this.arbitraryDirectives = directives;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getArbitraryDirectives() {
        Object object = this.monitor;
        synchronized (object) {
            return this.arbitraryDirectives;
        }
    }

    public Map<String, String> getDeclaredDirectives() {
        String[] mandatoryDirective;
        HashMap<String, String> result = new HashMap<String, String>(2);
        Map<String, String> arbitrary = this.getArbitraryDirectives();
        if (arbitrary != null) {
            result.putAll(arbitrary);
        }
        if (!this.attachFragments()) {
            result.put("fragment-attachment", "never");
        } else if (this.dynamicFragments()) {
            result.put("fragment-attachment", "always");
        } else {
            result.put("fragment-attachment", "resolve-time");
        }
        if (this.isSingleton()) {
            result.put("singleton", Boolean.TRUE.toString());
        }
        if ((mandatoryDirective = (String[])this.getDirective("mandatory")) != null) {
            result.put("mandatory", ExportPackageDescriptionImpl.toString(mandatoryDirective));
        }
        return Collections.unmodifiableMap(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getDeclaredAttributes() {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        Object object = this.monitor;
        synchronized (object) {
            if (this.attributes != null) {
                result.putAll(this.attributes);
            }
        }
        result.put("osgi.wiring.bundle", this.getName());
        result.put("bundle-version", this.getVersion());
        return Collections.unmodifiableMap(result);
    }

    public List<BundleRequirement> getDeclaredRequirements(String namespace) {
        int n;
        int n2;
        BundleSpecification[] bundleSpecificationArray;
        ArrayList<BundleRequirement> result = new ArrayList<BundleRequirement>();
        if (namespace == null || "osgi.wiring.bundle".equals(namespace)) {
            BundleSpecification[] requires;
            bundleSpecificationArray = requires = this.getRequiredBundles();
            n2 = requires.length;
            n = 0;
            while (n < n2) {
                BundleSpecification require = bundleSpecificationArray[n];
                result.add(require.getRequirement());
                ++n;
            }
        }
        if (this.host != null && (namespace == null || "osgi.wiring.host".equals(namespace))) {
            result.add(this.host.getRequirement());
        }
        if (namespace == null || "osgi.wiring.package".equals(namespace)) {
            ImportPackageSpecification[] imports = this.getImportPackages();
            bundleSpecificationArray = imports;
            n2 = imports.length;
            n = 0;
            while (n < n2) {
                BundleSpecification importPkg = bundleSpecificationArray[n];
                result.add(importPkg.getRequirement());
                ++n;
            }
        }
        GenericSpecification[] genericSpecifications = this.getGenericRequires();
        bundleSpecificationArray = genericSpecifications;
        n2 = genericSpecifications.length;
        n = 0;
        while (n < n2) {
            BundleSpecification requirement = bundleSpecificationArray[n];
            if (namespace == null || namespace.equals(requirement.getType())) {
                result.add(requirement.getRequirement());
            }
            ++n;
        }
        return Collections.unmodifiableList(result);
    }

    public List<BundleCapability> getDeclaredCapabilities(String namespace) {
        int n;
        int n2;
        ExportPackageDescription[] exportPackageDescriptionArray;
        ArrayList<BundleCapability> result = new ArrayList<BundleCapability>();
        if (this.host == null && this.getSymbolicName() != null) {
            if (namespace == null || "osgi.wiring.bundle".equals(namespace)) {
                result.add(this.getCapability());
            }
            if (this.attachFragments() && (namespace == null || "osgi.wiring.host".equals(namespace))) {
                result.add(this.getCapability("osgi.wiring.host"));
            }
        }
        if (namespace == null || "osgi.wiring.package".equals(namespace)) {
            ExportPackageDescription[] exports;
            exportPackageDescriptionArray = exports = this.getExportPackages();
            n2 = exports.length;
            n = 0;
            while (n < n2) {
                ExportPackageDescription exportPkg = exportPackageDescriptionArray[n];
                result.add(exportPkg.getCapability());
                ++n;
            }
        }
        GenericDescription[] genericCapabilities = this.getGenericCapabilities();
        exportPackageDescriptionArray = genericCapabilities;
        n2 = genericCapabilities.length;
        n = 0;
        while (n < n2) {
            ExportPackageDescription capabilitiy = exportPackageDescriptionArray[n];
            if (namespace == null || namespace.equals(capabilitiy.getType())) {
                result.add(capabilitiy.getCapability());
            }
            ++n;
        }
        return Collections.unmodifiableList(result);
    }

    public int getTypes() {
        return this.getHost() != null ? 1 : 0;
    }

    public Bundle getBundle() {
        Object ref = this.getUserObject();
        if (ref instanceof BundleReference) {
            return ((BundleReference)ref).getBundle();
        }
        return null;
    }

    @Override
    String getInternalNameSpace() {
        return "osgi.wiring.bundle";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleWiring getWiring() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.bundleWiring != null || !this.isResolved()) {
                return this.bundleWiring;
            }
            this.bundleWiring = new DescriptionWiring();
            return this.bundleWiring;
        }
    }

    static List<Wire> asListWire(List<? extends Wire> l) {
        return l;
    }

    static List<Capability> asListCapability(List<? extends Capability> l) {
        return l;
    }

    static List<Requirement> asListRequirement(List<? extends Requirement> l) {
        return l;
    }

    public List<Capability> getCapabilities(String namespace) {
        return BundleDescriptionImpl.asListCapability(this.getDeclaredCapabilities(namespace));
    }

    public List<Requirement> getRequirements(String namespace) {
        return BundleDescriptionImpl.asListRequirement(this.getDeclaredRequirements(namespace));
    }

    static class BundleWireImpl
    implements BundleWire {
        private final BundleCapability capability;
        private final BundleWiring provider;
        private final BundleRequirement requirement;
        private final BundleWiring requirer;

        public BundleWireImpl(StateWire wire) {
            VersionConstraint declaredRequirement = wire.getDeclaredRequirement();
            this.capability = declaredRequirement instanceof HostSpecification ? ((BaseDescriptionImpl)wire.getDeclaredCapability()).getCapability("osgi.wiring.host") : wire.getDeclaredCapability().getCapability();
            this.provider = wire.getCapabilityHost().getWiring();
            this.requirement = declaredRequirement.getRequirement();
            this.requirer = wire.getRequirementHost().getWiring();
        }

        public BundleCapability getCapability() {
            return this.capability;
        }

        public BundleRequirement getRequirement() {
            return this.requirement;
        }

        public BundleWiring getProviderWiring() {
            return this.provider;
        }

        public BundleWiring getRequirerWiring() {
            return this.requirer;
        }

        public int hashCode() {
            int hashcode = 31 + this.capability.hashCode();
            hashcode = hashcode * 31 + this.requirement.hashCode();
            hashcode = hashcode * 31 + this.provider.hashCode();
            hashcode = hashcode * 31 + this.requirer.hashCode();
            return hashcode;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void other;
            if (!(obj instanceof BundleWireImpl)) {
                return false;
            }
            BundleWireImpl bundleWireImpl = (BundleWireImpl)obj;
            return this.capability.equals((Object)other.getCapability()) && this.requirement.equals((Object)other.getRequirement()) && this.provider.equals(other.getProviderWiring()) && this.requirer.equals(other.getRequirerWiring());
        }

        public String toString() {
            return String.valueOf(this.getRequirement()) + " -> " + String.valueOf(this.getCapability());
        }

        public BundleRevision getProvider() {
            return this.provider.getRevision();
        }

        public BundleRevision getRequirer() {
            return this.requirer.getRevision();
        }
    }

    class DescriptionWiring
    implements BundleWiring {
        private volatile boolean valid = true;

        DescriptionWiring() {
        }

        public Bundle getBundle() {
            return BundleDescriptionImpl.this.getBundle();
        }

        public boolean isInUse() {
            return this.valid && (this.isCurrent() || BundleDescriptionImpl.this.hasDependents());
        }

        void invalidate() {
            this.valid = false;
        }

        public boolean isCurrent() {
            return this.valid && !BundleDescriptionImpl.this.isRemovalPending();
        }

        public List<BundleCapability> getCapabilities(String namespace) {
            GenericDescription[] genericCapabilities;
            if (!this.isInUse()) {
                return null;
            }
            ArrayList<BundleCapability> result = new ArrayList<BundleCapability>();
            GenericDescription[] genericDescriptionArray = genericCapabilities = BundleDescriptionImpl.this.getSelectedGenericCapabilities();
            int n = genericCapabilities.length;
            int n2 = 0;
            while (n2 < n) {
                GenericDescription capabilitiy = genericDescriptionArray[n2];
                if (namespace == null || namespace.equals(capabilitiy.getType())) {
                    result.add(capabilitiy.getCapability());
                }
                ++n2;
            }
            if (BundleDescriptionImpl.this.host != null) {
                return result;
            }
            if (BundleDescriptionImpl.this.getSymbolicName() != null) {
                if (namespace == null || "osgi.wiring.bundle".equals(namespace)) {
                    result.add(BundleDescriptionImpl.this.getCapability());
                }
                if (BundleDescriptionImpl.this.attachFragments() && (namespace == null || "osgi.wiring.host".equals(namespace))) {
                    result.add(BundleDescriptionImpl.this.getCapability("osgi.wiring.host"));
                }
            }
            if (namespace == null || "osgi.wiring.package".equals(namespace)) {
                ExportPackageDescription[] exports;
                ExportPackageDescription[] exportPackageDescriptionArray = exports = BundleDescriptionImpl.this.getSelectedExports();
                int n3 = exports.length;
                n = 0;
                while (n < n3) {
                    ExportPackageDescription exportPkg = exportPackageDescriptionArray[n];
                    result.add(exportPkg.getCapability());
                    ++n;
                }
            }
            return result;
        }

        public List<Capability> getResourceCapabilities(String namespace) {
            return BundleDescriptionImpl.asListCapability(this.getCapabilities(namespace));
        }

        public List<BundleRequirement> getRequirements(String namespace) {
            List<BundleWire> requiredWires = this.getRequiredWires(namespace);
            if (requiredWires == null) {
                return null;
            }
            ArrayList<BundleRequirement> requirements = new ArrayList<BundleRequirement>(requiredWires.size());
            for (BundleWire wire : requiredWires) {
                if (requirements.contains(wire.getRequirement())) continue;
                requirements.add(wire.getRequirement());
            }
            if (BundleDescriptionImpl.this.getHost() == null && (namespace == null || "osgi.wiring.package".equals(namespace))) {
                BundleRequirement req;
                int n;
                int n2;
                ImportPackageSpecification[] importPackageSpecificationArray;
                if (BundleDescriptionImpl.this.hasDynamicImports()) {
                    ImportPackageSpecification[] imports;
                    importPackageSpecificationArray = imports = BundleDescriptionImpl.this.getImportPackages();
                    n2 = imports.length;
                    n = 0;
                    while (n < n2) {
                        ImportPackageSpecification impPackage = importPackageSpecificationArray[n];
                        if ("dynamic".equals(impPackage.getDirective("resolution")) && !requirements.contains(req = impPackage.getRequirement())) {
                            requirements.add(req);
                        }
                        ++n;
                    }
                }
                ImportPackageSpecification[] addedDynamic = BundleDescriptionImpl.this.getAddedDynamicImportPackages();
                importPackageSpecificationArray = addedDynamic;
                n2 = addedDynamic.length;
                n = 0;
                while (n < n2) {
                    ImportPackageSpecification dynamicImport = importPackageSpecificationArray[n];
                    req = dynamicImport.getRequirement();
                    if (!requirements.contains(req)) {
                        requirements.add(req);
                    }
                    ++n;
                }
            }
            return requirements;
        }

        public List<Requirement> getResourceRequirements(String namespace) {
            return BundleDescriptionImpl.asListRequirement(this.getRequirements(namespace));
        }

        public List<BundleWire> getProvidedWires(String namespace) {
            if (!this.isInUse()) {
                return null;
            }
            BundleDescription[] dependentBundles = BundleDescriptionImpl.this.getDependents();
            ArrayList<BundleWire> unorderedResult = new ArrayList<BundleWire>();
            BundleDescription[] bundleDescriptionArray = dependentBundles;
            int n = dependentBundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription dependent = bundleDescriptionArray[n2];
                List dependentWires = dependent.getWiring().getRequiredWires(namespace);
                if (dependentWires != null) {
                    for (BundleWire bundleWire : dependentWires) {
                        if (bundleWire.getProviderWiring() != this) continue;
                        unorderedResult.add(bundleWire);
                    }
                }
                ++n2;
            }
            ArrayList<BundleWire> orderedResult = new ArrayList<BundleWire>(unorderedResult.size());
            List<BundleCapability> capabilities = this.getCapabilities(namespace);
            for (BundleCapability capability : capabilities) {
                Iterator wires = unorderedResult.iterator();
                while (wires.hasNext()) {
                    BundleWire wire = (BundleWire)wires.next();
                    if (!wire.getCapability().equals((Object)capability)) continue;
                    wires.remove();
                    orderedResult.add(wire);
                }
            }
            return orderedResult;
        }

        public List<Wire> getProvidedResourceWires(String namespace) {
            return BundleDescriptionImpl.asListWire(this.getProvidedWires(namespace));
        }

        public List<BundleWire> getRequiredWires(String namespace) {
            if (!this.isInUse()) {
                return null;
            }
            List<BundleWire> result = Collections.emptyList();
            Map<String, List<StateWire>> wireMap = BundleDescriptionImpl.this.getWires();
            if (namespace == null) {
                result = new ArrayList();
                for (List<StateWire> wires : wireMap.values()) {
                    for (StateWire wire : wires) {
                        result.add(new BundleWireImpl(wire));
                    }
                }
                return result;
            }
            List<StateWire> wires = wireMap.get(namespace);
            if (wires == null) {
                return result;
            }
            result = new ArrayList<BundleWire>(wires.size());
            for (StateWire wire : wires) {
                result.add(new BundleWireImpl(wire));
            }
            return result;
        }

        public List<Wire> getRequiredResourceWires(String namespace) {
            return BundleDescriptionImpl.asListWire(this.getRequiredWires(namespace));
        }

        public BundleRevision getRevision() {
            return BundleDescriptionImpl.this;
        }

        public BundleRevision getResource() {
            return this.getRevision();
        }

        public ClassLoader getClassLoader() {
            throw new UnsupportedOperationException();
        }

        public List<URL> findEntries(String path, String filePattern, int options) {
            return null;
        }

        public Collection<String> listResources(String path, String filePattern, int options) {
            return null;
        }

        public String toString() {
            return BundleDescriptionImpl.this.toString();
        }
    }

    static final class LazyData {
        String location;
        String platformFilter;
        BundleSpecification[] requiredBundles;
        ExportPackageDescription[] exportPackages;
        ImportPackageSpecification[] importPackages;
        GenericDescription[] genericCapabilities;
        GenericSpecification[] genericRequires;
        ExportPackageDescription[] selectedExports;
        GenericDescription[] selectedCapabilities;
        BundleDescription[] resolvedRequires;
        ExportPackageDescription[] resolvedImports;
        GenericDescription[] resolvedCapabilities;
        ExportPackageDescription[] substitutedExports;
        String[] executionEnvironments;
        Map<String, List<StateWire>> stateWires;
        List<ImportPackageSpecification> addedDynamicImports;

        LazyData() {
        }
    }
}

