/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui.tree;

import java.util.ArrayList;
import java.util.Iterator;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.FieldIdentifier;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.UnknownOopException;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.CIntegerType;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.JBooleanField;
import sun.jvm.hotspot.types.JByteField;
import sun.jvm.hotspot.types.JCharField;
import sun.jvm.hotspot.types.JDoubleField;
import sun.jvm.hotspot.types.JFloatField;
import sun.jvm.hotspot.types.JIntField;
import sun.jvm.hotspot.types.JLongField;
import sun.jvm.hotspot.types.JShortField;
import sun.jvm.hotspot.types.PointerType;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.ui.tree.BadAddressTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.BooleanTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.CStringTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.CharTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.DoubleTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.FieldTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.LongTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.OopTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.SimpleTreeNode;
import sun.jvm.hotspot.utilities.CStringUtilities;

public class CTypeTreeNodeAdapter
extends FieldTreeNodeAdapter {
    private final Address addr;
    private final Type type;
    private CTypeFieldIdentifier[] fields = null;

    private void collectFields(Type type, ArrayList list, boolean statics, boolean recurse) {
        Type supertype = type.getSuperclass();
        if (supertype != null && recurse) {
            this.collectFields(supertype, list, statics, recurse);
        }
        Iterator i = type.getFields();
        while (i.hasNext()) {
            Field f = (Field)i.next();
            if (f.isStatic() != statics) continue;
            list.add(new CTypeFieldIdentifier(type, f));
        }
    }

    private CTypeFieldIdentifier[] getFields() {
        if (this.fields == null) {
            ArrayList f = new ArrayList();
            this.collectFields(this.type, f, false, true);
            this.fields = f.toArray(new CTypeFieldIdentifier[0]);
        }
        return this.fields;
    }

    public CTypeTreeNodeAdapter(Address a, Type t, FieldIdentifier id) {
        this(a, t, id, false);
    }

    public CTypeTreeNodeAdapter(Address a, Type t, FieldIdentifier id, boolean treeTableMode) {
        super(id, treeTableMode);
        this.type = t;
        this.addr = a;
    }

    public CTypeTreeNodeAdapter(Type t) {
        super(null, false);
        this.type = t;
        this.addr = null;
        ArrayList statics = new ArrayList();
        this.collectFields(this.type, statics, true, false);
        this.fields = statics.toArray(new CTypeFieldIdentifier[0]);
    }

    public CTypeTreeNodeAdapter(Iterator types) {
        super(null, false);
        this.addr = null;
        this.type = null;
        ArrayList statics = new ArrayList();
        while (types.hasNext()) {
            this.collectFields((Type)types.next(), statics, true, false);
        }
        this.fields = statics.toArray(new CTypeFieldIdentifier[0]);
    }

    @Override
    public int getChildCount() {
        return this.getFields().length;
    }

    @Override
    public SimpleTreeNode getChild(int index) {
        CTypeFieldIdentifier cf = this.getFields()[index];
        Field f = cf.getField();
        Type t = f.getType();
        try {
            if (t.isOopType()) {
                OopHandle handle = f.isStatic() ? f.getOopHandle() : f.getOopHandle(this.addr);
                try {
                    Oop oop = VM.getVM().getObjectHeap().newOop(handle);
                    return new OopTreeNodeAdapter(oop, cf, this.getTreeTableMode());
                }
                catch (AddressException e) {
                    return new BadAddressTreeNodeAdapter(handle, (FieldIdentifier)new CTypeFieldIdentifier(this.type, f), this.getTreeTableMode());
                }
                catch (UnknownOopException e) {
                    return new BadAddressTreeNodeAdapter(handle, (FieldIdentifier)new CTypeFieldIdentifier(this.type, f), this.getTreeTableMode());
                }
            }
            if (t.isCIntegerType()) {
                long value = 0L;
                value = f.isStatic() ? f.getCInteger((CIntegerType)t) : f.getCInteger(this.addr, (CIntegerType)t);
                return new LongTreeNodeAdapter(value, cf, this.getTreeTableMode());
            }
            if (t.isJavaPrimitiveType()) {
                boolean isStatic = f.isStatic();
                if (f instanceof JByteField) {
                    long value = isStatic ? (long)f.getJByte() : (long)f.getJByte(this.addr);
                    return new LongTreeNodeAdapter(value, cf, this.getTreeTableMode());
                }
                if (f instanceof JShortField) {
                    long value = isStatic ? (long)f.getJShort() : (long)f.getJShort(this.addr);
                    return new LongTreeNodeAdapter(value, cf, this.getTreeTableMode());
                }
                if (f instanceof JIntField) {
                    long value = isStatic ? (long)f.getJInt() : (long)f.getJInt(this.addr);
                    return new LongTreeNodeAdapter(value, cf, this.getTreeTableMode());
                }
                if (f instanceof JLongField) {
                    long value = isStatic ? f.getJLong() : f.getJLong(this.addr);
                    return new LongTreeNodeAdapter(value, cf, this.getTreeTableMode());
                }
                if (f instanceof JCharField) {
                    char value = isStatic ? f.getJChar() : f.getJChar(this.addr);
                    return new CharTreeNodeAdapter(value, cf, this.getTreeTableMode());
                }
                if (f instanceof JBooleanField) {
                    boolean value = isStatic ? f.getJBoolean() : f.getJBoolean(this.addr);
                    return new BooleanTreeNodeAdapter(value, cf, this.getTreeTableMode());
                }
                if (f instanceof JFloatField) {
                    float value = isStatic ? f.getJFloat() : f.getJFloat(this.addr);
                    return new DoubleTreeNodeAdapter(value, cf, this.getTreeTableMode());
                }
                if (f instanceof JDoubleField) {
                    double value = isStatic ? f.getJDouble() : f.getJDouble(this.addr);
                    return new DoubleTreeNodeAdapter(value, cf, this.getTreeTableMode());
                }
                throw new RuntimeException("unhandled type: " + t.getName());
            }
            if (t.isPointerType()) {
                Address ptr = f.isStatic() ? f.getAddress() : f.getAddress(this.addr);
                if (t.isCStringType()) {
                    return new CStringTreeNodeAdapter(CStringUtilities.getString(ptr), cf);
                }
                return new CTypeTreeNodeAdapter(ptr, ((PointerType)t).getTargetType(), cf, this.getTreeTableMode());
            }
            if (f.isStatic()) {
                return new CTypeTreeNodeAdapter(f.getStaticFieldAddress(), f.getType(), cf, this.getTreeTableMode());
            }
            return new CTypeTreeNodeAdapter(this.addr.addOffsetTo(f.getOffset()), f.getType(), cf, this.getTreeTableMode());
        }
        catch (AddressException e) {
            return new BadAddressTreeNodeAdapter(e.getAddress(), (FieldIdentifier)new CTypeFieldIdentifier(this.type, f), this.getTreeTableMode());
        }
    }

    @Override
    public boolean isLeaf() {
        return this.getFields().length == 0;
    }

    @Override
    public int getIndexOfChild(SimpleTreeNode child) {
        CTypeFieldIdentifier id = (CTypeFieldIdentifier)((FieldTreeNodeAdapter)child).getID();
        CTypeFieldIdentifier[] f = this.getFields();
        for (int i = 0; i < f.length; ++i) {
            if (id != f[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getValue() {
        if (this.type != null) {
            return this.type.getName() + " @ " + this.addr;
        }
        return "<statics>";
    }

    static class CTypeFieldIdentifier
    extends FieldIdentifier {
        private final Field field;
        private final Type holder;

        CTypeFieldIdentifier(Type t, Field f) {
            this.holder = t;
            this.field = f;
        }

        public Field getField() {
            return this.field;
        }

        @Override
        public String getName() {
            return this.field.getType().getName() + " " + this.holder.getName() + "::" + this.field.getName();
        }
    }
}

