/*
    SPDX-FileCopyrightText: 2011 Alex Richardson <alex.richardson@gmx.de>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_BOOLDATAINFORMATION_HPP
#define KASTEN_BOOLDATAINFORMATION_HPP

// lib
#include "uintdatainformation.hpp"
// Qt
#include <QScriptValue>

template <typename T>
class BoolDataInformationMethods
{
public:
    [[nodiscard]]
    static QScriptValue asScriptValue(T value, QScriptEngine* engine, ScriptHandlerInfo* handler);
    [[nodiscard]]
    static QString staticValueString(T val, int base = Kasten::StructureViewPreferences::unsignedDisplayBase());
    [[nodiscard]]
    static PrimitiveDataType staticType();
    [[nodiscard]]
    static T fromVariant(const QVariant& value, bool* ok);
    [[nodiscard]]
    static QVariant staticToQVariant(T value);

    [[nodiscard]]
    static QWidget* staticCreateEditWidget(QWidget* parent);
    [[nodiscard]]
    static QVariant staticDataFromWidget(const QWidget* w);
    static void staticSetWidgetData(T value, QWidget* w);
};

template <>
inline PrimitiveDataType BoolDataInformationMethods<quint8>::staticType()
{
    return PrimitiveDataType::Bool8;
}
template <>
inline PrimitiveDataType BoolDataInformationMethods<quint16>::staticType()
{
    return PrimitiveDataType::Bool16;
}
template <>
inline PrimitiveDataType BoolDataInformationMethods<quint32>::staticType()
{
    return PrimitiveDataType::Bool32;
}
template <>
inline PrimitiveDataType BoolDataInformationMethods<quint64>::staticType()
{
    return PrimitiveDataType::Bool64;
}

template <typename T>
inline QScriptValue BoolDataInformationMethods<T>::asScriptValue(T value, QScriptEngine* engine,
                                                                 ScriptHandlerInfo* handler)
{
    Q_UNUSED(engine)
    Q_UNUSED(handler)
    return {(value != 0)};
}

template <typename T>
inline QVariant BoolDataInformationMethods<T>::staticToQVariant(T value)
{
    return UIntDataInformationMethods<T>::staticToQVariant(value);
}

template <typename T>
inline T BoolDataInformationMethods<T>::fromVariant(const QVariant& value, bool* ok)
{
    return UIntDataInformationMethods<T>::fromVariant(value, ok);
}

#endif // KASTEN_BOOLDATAINFORMATION_HPP
