#include <curses.h>

#define PCONST(ty, NAME) printf("pub const " #NAME ": " #ty " = %lld;\n", (long long) (NAME))
#define PCONSTU(ty, NAME) printf("pub const " #NAME ": " #ty " = %llu;\n", (unsigned long long) (NAME))

int main() {
        /* some values aren't set until after this is run */
        printf("//");
	initscr();
	endwin();
        printf("\n");

	/* Success/Failure. */
	PCONST(i32, ERR);
	PCONST(i32, OK);
	PCONST(c_bool, TRUE);
	PCONST(c_bool, FALSE);

	/* Attributes. */
#ifdef NCURSES_ATTR_SHIFT
	PCONST(u32, NCURSES_ATTR_SHIFT);
#endif

	/* Colors */
	PCONST(i16, COLOR_BLACK);
	PCONST(i16, COLOR_RED);
	PCONST(i16, COLOR_GREEN);
	PCONST(i16, COLOR_YELLOW);
	PCONST(i16, COLOR_BLUE);
	PCONST(i16, COLOR_MAGENTA);
	PCONST(i16, COLOR_CYAN);
	PCONST(i16, COLOR_WHITE);

	/* Values for the _flags member */
#ifdef _SUBWIN
	PCONST(i32, _SUBWIN);
#endif

#ifdef _ENDLINE
	PCONST(i32, _ENDLINE);
#endif

#ifdef _FULLWIN
	PCONST(i32, _FULLWIN);
#endif

#ifdef _SCROLLWIN
	PCONST(i32, _SCROLLWIN);
#endif

#ifdef _ISPAD
	PCONST(i32, _ISPAD);
#endif

#ifdef _HASMOVED
	PCONST(i32, _HASMOVED);
#endif

#ifdef _WRAPPED
	PCONST(i32, _WRAPPED);
#endif

	/*
	 * This value is used in the firstchar and lastchar fields to mark
	 * unchanged lines
	 */
#ifdef _NOCHANGE
	PCONST(i32, _NOCHANGE);
#endif

	/*
	 * This value is used in the oldindex field to mark lines created by insertions
	 * and scrolls.
	 */
#ifdef _NEWINDEX
	PCONST(i32, _NEWINDEX);
#endif

	/* Keys */
	PCONST(i32, KEY_CODE_YES);
	PCONST(i32, KEY_MIN);
	PCONST(i32, KEY_BREAK);
	PCONST(i32, KEY_SRESET);
	PCONST(i32, KEY_RESET);
	PCONST(i32, KEY_DOWN);
	PCONST(i32, KEY_UP);
	PCONST(i32, KEY_LEFT);
	PCONST(i32, KEY_RIGHT);
	PCONST(i32, KEY_HOME);
	PCONST(i32, KEY_BACKSPACE);
	PCONST(i32, KEY_F0);
	PCONST(i32, KEY_DL);
	PCONST(i32, KEY_IL);
	PCONST(i32, KEY_DC);
	PCONST(i32, KEY_IC);
	PCONST(i32, KEY_EIC);
	PCONST(i32, KEY_CLEAR);
	PCONST(i32, KEY_EOS);
	PCONST(i32, KEY_EOL);
	PCONST(i32, KEY_SF);
	PCONST(i32, KEY_SR);
	PCONST(i32, KEY_NPAGE);
	PCONST(i32, KEY_PPAGE);
	PCONST(i32, KEY_STAB);
	PCONST(i32, KEY_CTAB);
	PCONST(i32, KEY_CATAB);
	PCONST(i32, KEY_ENTER);
	PCONST(i32, KEY_PRINT);
	PCONST(i32, KEY_LL);
#ifdef KEY_A1
	PCONST(i32, KEY_A1);
#endif
#ifdef KEY_A3
	PCONST(i32, KEY_A3);
#endif
#ifdef KEY_B2
	PCONST(i32, KEY_B2);
#endif
#ifdef KEY_C1
	PCONST(i32, KEY_C1);
#endif
#ifdef KEY_C3
	PCONST(i32, KEY_C3);
#endif
	PCONST(i32, KEY_BTAB);
	PCONST(i32, KEY_BEG);
	PCONST(i32, KEY_CANCEL);
	PCONST(i32, KEY_CLOSE);
	PCONST(i32, KEY_COMMAND);
	PCONST(i32, KEY_COPY);
	PCONST(i32, KEY_CREATE);
	PCONST(i32, KEY_END);
	PCONST(i32, KEY_EXIT);
	PCONST(i32, KEY_FIND);
	PCONST(i32, KEY_HELP);
	PCONST(i32, KEY_MARK);
	PCONST(i32, KEY_MESSAGE);
	PCONST(i32, KEY_MOVE);
	PCONST(i32, KEY_NEXT);
	PCONST(i32, KEY_OPEN);
	PCONST(i32, KEY_OPTIONS);
	PCONST(i32, KEY_PREVIOUS);
	PCONST(i32, KEY_REDO);
	PCONST(i32, KEY_REFERENCE);
	PCONST(i32, KEY_REFRESH);
	PCONST(i32, KEY_REPLACE);
	PCONST(i32, KEY_RESTART);
	PCONST(i32, KEY_RESUME);
	PCONST(i32, KEY_SAVE);
	PCONST(i32, KEY_SBEG);
	PCONST(i32, KEY_SCANCEL);
	PCONST(i32, KEY_SCOMMAND);
	PCONST(i32, KEY_SCOPY);
	PCONST(i32, KEY_SCREATE);
	PCONST(i32, KEY_SDC);
	PCONST(i32, KEY_SDL);
	PCONST(i32, KEY_SELECT);
	PCONST(i32, KEY_SEND);
	PCONST(i32, KEY_SEOL);
	PCONST(i32, KEY_SEXIT);
	PCONST(i32, KEY_SFIND);
	PCONST(i32, KEY_SHELP);
	PCONST(i32, KEY_SHOME);
	PCONST(i32, KEY_SIC);
	PCONST(i32, KEY_SLEFT);
	PCONST(i32, KEY_SMESSAGE);
	PCONST(i32, KEY_SMOVE);
	PCONST(i32, KEY_SNEXT);
	PCONST(i32, KEY_SOPTIONS);
	PCONST(i32, KEY_SPREVIOUS);
	PCONST(i32, KEY_SPRINT);
	PCONST(i32, KEY_SREDO);
	PCONST(i32, KEY_SREPLACE);
	PCONST(i32, KEY_SRIGHT);
	PCONST(i32, KEY_SRSUME);
	PCONST(i32, KEY_SSAVE);
	PCONST(i32, KEY_SSUSPEND);
	PCONST(i32, KEY_SUNDO);
	PCONST(i32, KEY_SUSPEND);
	PCONST(i32, KEY_UNDO);
	PCONST(i32, KEY_MOUSE);
	PCONST(i32, KEY_RESIZE);
#ifdef KEY_EVENT
	PCONST(i32, KEY_EVENT);
#endif
	PCONST(i32, KEY_MAX);

#ifdef NCURSES_MOUSE_VERSION
	PCONST(i32, NCURSES_MOUSE_VERSION);
#endif

#ifdef MASK_SHIFT
	PCONST(i32, MASK_SHIFT);
#endif

#ifdef MODIFIER_SHIFT
	PCONST(i32, MODIFIER_SHIFT);
#endif

	/* Mouse Support */
#ifdef NCURSES_BUTTON_RELEASED
	PCONST(i32, NCURSES_BUTTON_RELEASED);
#endif

#ifdef NCURSES_BUTTON_PRESSED
	PCONST(i32, NCURSES_BUTTON_PRESSED);
#endif

#ifdef NCURSES_BUTTON_CLICKED
	PCONST(i32, NCURSES_BUTTON_CLICKED);
#endif

#ifdef NCURSES_DOUBLE_CLICKED
	PCONST(i32, NCURSES_DOUBLE_CLICKED);
#endif

#ifdef NCURSES_TRIPLE_CLICKED
	PCONST(i32, NCURSES_TRIPLE_CLICKED);
#endif

#ifdef NCURSES_RESERVED_EVENT
	PCONST(i32, NCURSES_RESERVED_EVENT);
#endif

	/* event masks */
	PCONST(i32, BUTTON1_RELEASED);
	PCONST(i32, BUTTON1_PRESSED);
	PCONST(i32, BUTTON1_CLICKED);
	PCONST(i32, BUTTON1_DOUBLE_CLICKED);
	PCONST(i32, BUTTON1_TRIPLE_CLICKED);

	PCONST(i32, BUTTON2_RELEASED);
	PCONST(i32, BUTTON2_PRESSED);
	PCONST(i32, BUTTON2_CLICKED);
	PCONST(i32, BUTTON2_DOUBLE_CLICKED);
	PCONST(i32, BUTTON2_TRIPLE_CLICKED);

	PCONST(i32, BUTTON3_RELEASED);
	PCONST(i32, BUTTON3_PRESSED);
	PCONST(i32, BUTTON3_CLICKED);
	PCONST(i32, BUTTON3_DOUBLE_CLICKED);
	PCONST(i32, BUTTON3_TRIPLE_CLICKED);

	PCONST(i32, BUTTON4_RELEASED);
	PCONST(i32, BUTTON4_PRESSED);
	PCONST(i32, BUTTON4_CLICKED);
	PCONST(i32, BUTTON4_DOUBLE_CLICKED);
	PCONST(i32, BUTTON4_TRIPLE_CLICKED);

#ifdef BUTTON5_RELEASED
	PCONST(i32, BUTTON5_RELEASED);
#endif

#ifdef BUTTON5_PRESSED
	PCONST(i32, BUTTON5_PRESSED);
#endif

#ifdef BUTTON5_CLICKED
	PCONST(i32, BUTTON5_CLICKED);
#endif

#ifdef BUTTON5_DOUBLE_CLICKED
	PCONST(i32, BUTTON5_DOUBLE_CLICKED);
#endif

#ifdef BUTTON5_TRIPLE_CLICKED
	PCONST(i32, BUTTON5_TRIPLE_CLICKED);
#endif

	PCONST(i32, BUTTON_CTRL);
	PCONST(i32, BUTTON_SHIFT);
	PCONST(i32, BUTTON_ALT);
	PCONST(i32, REPORT_MOUSE_POSITION);

	PCONST(i32, ALL_MOUSE_EVENTS);

	/* Attributes */
	PCONSTU(crate::ll::chtype, A_NORMAL);
	PCONSTU(crate::ll::chtype, A_STANDOUT);
	PCONSTU(crate::ll::chtype, A_UNDERLINE);
#ifdef A_ITALIC
	PCONSTU(crate::ll::chtype, A_ITALIC);
#endif
	PCONSTU(crate::ll::chtype, A_REVERSE);
	PCONSTU(crate::ll::chtype, A_BLINK);
	PCONSTU(crate::ll::chtype, A_DIM);
	PCONSTU(crate::ll::chtype, A_BOLD);

#ifdef A_BLANK
	PCONSTU(crate::ll::chtype, A_BLANK);
#endif

	PCONSTU(crate::ll::chtype, A_INVIS);
	PCONSTU(crate::ll::chtype, A_PROTECT);
	PCONSTU(crate::ll::chtype, A_ALTCHARSET);
	PCONSTU(crate::ll::chtype, A_ATTRIBUTES);
	PCONSTU(crate::ll::chtype, A_CHARTEXT);
	PCONSTU(crate::ll::chtype, A_COLOR);
}
