//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-audio-types")]
use objc2_core_audio_types::*;

use crate::*;

/// A type for four char codes for property IDs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioformatpropertyid?language=objc)
pub type AudioFormatPropertyID = u32;

/// Different panning algorithms.
///
/// Sound field panning algorithm
///
/// Vector based panning algorithm
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiopanningmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioPanningMode(pub u32);
impl AudioPanningMode {
    #[doc(alias = "kPanningMode_SoundField")]
    pub const PanningMode_SoundField: Self = Self(3);
    #[doc(alias = "kPanningMode_VectorBasedPanning")]
    pub const PanningMode_VectorBasedPanning: Self = Self(4);
}

unsafe impl Encode for AudioPanningMode {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioPanningMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// This struct is for use with kAudioFormatProperty_PanningMatrix.
///
///
///
///
/// mGainScale is used to multiply the panning values.
/// In typical usage you are applying an existing volume.
/// value in 0 -> 1 (where 1 is unity gain) to the panned values.
/// 1 would give you panning at unity.
/// 0 would give you back a matrix of zeroes.
///
/// This is the channel map that is going to be used to determine channel volumes for this pan.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiopanninginfo?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioPanningInfo {
    pub mPanningMode: AudioPanningMode,
    pub mCoordinateFlags: u32,
    pub mCoordinates: [f32; 3],
    pub mGainScale: f32,
    pub mOutputChannelMap: NonNull<AudioChannelLayout>,
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl Encode for AudioPanningInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioPanningInfo",
        &[
            <AudioPanningMode>::ENCODING,
            <u32>::ENCODING,
            <[f32; 3]>::ENCODING,
            <f32>::ENCODING,
            <NonNull<AudioChannelLayout>>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl RefEncode for AudioPanningInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// used for mType field of AudioBalanceFade struct
///
/// the gain value never exceeds 1.0, the opposite channel fades out.
/// This can reduce overall loudness when the balance or fade is not in the center.
///
/// The overall loudness remains constant, but gain can exceed 1.0.
/// the gain value is 1.0 when the balance and fade are in the center.
/// From there they can increase to +3dB (1.414) and decrease to -inf dB (0.0).
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiobalancefadetype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioBalanceFadeType(pub u32);
impl AudioBalanceFadeType {
    #[doc(alias = "kAudioBalanceFadeType_MaxUnityGain")]
    pub const MaxUnityGain: Self = Self(0);
    #[doc(alias = "kAudioBalanceFadeType_EqualPower")]
    pub const EqualPower: Self = Self(1);
}

unsafe impl Encode for AudioBalanceFadeType {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioBalanceFadeType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// this struct is used with kAudioFormatProperty_BalanceFade
///
/// -1 is full left, 0 is center, +1 is full right
///
/// -1 is full rear, 0 is center, +1 is full front
///
/// an AudioBalanceFadeType constant
///
/// a pointer to an AudioChannelLayout
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiobalancefade?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioBalanceFade {
    pub mLeftRightBalance: f32,
    pub mBackFrontFade: f32,
    pub mType: AudioBalanceFadeType,
    pub mChannelLayout: NonNull<AudioChannelLayout>,
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl Encode for AudioBalanceFade {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioBalanceFade",
        &[
            <f32>::ENCODING,
            <f32>::ENCODING,
            <AudioBalanceFadeType>::ENCODING,
            <NonNull<AudioChannelLayout>>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl RefEncode for AudioBalanceFade {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// this struct is used as a specifier for the kAudioFormatProperty_FormatList property
///
/// an AudioStreamBasicDescription
///
/// a pointer to the decompression info for the data described in mASBD
///
/// the size in bytes of mMagicCookie
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioformatinfo?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioFormatInfo {
    pub mASBD: AudioStreamBasicDescription,
    pub mMagicCookie: NonNull<c_void>,
    pub mMagicCookieSize: u32,
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl Encode for AudioFormatInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioFormatInfo",
        &[
            <AudioStreamBasicDescription>::ENCODING,
            <NonNull<c_void>>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl RefEncode for AudioFormatInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// this struct is used as a specifier for the kAudioFormatProperty_FormatList property
///
/// an AudioStreamBasicDescription
///
/// a pointer to the decompression info for the data described in mASBD
///
/// the size in bytes of mMagicCookie
///
/// an AudioClassDescription specifying the codec to be used in answering the question.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/extendedaudioformatinfo?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ExtendedAudioFormatInfo {
    pub mASBD: AudioStreamBasicDescription,
    pub mMagicCookie: *const c_void,
    pub mMagicCookieSize: u32,
    pub mClassDescription: AudioClassDescription,
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl Encode for ExtendedAudioFormatInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "ExtendedAudioFormatInfo",
        &[
            <AudioStreamBasicDescription>::ENCODING,
            <*const c_void>::ENCODING,
            <u32>::ENCODING,
            <AudioClassDescription>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl RefEncode for ExtendedAudioFormatInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_formatinfo?language=objc)
pub const kAudioFormatProperty_FormatInfo: AudioFormatPropertyID = 0x666d7469;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_formatname?language=objc)
pub const kAudioFormatProperty_FormatName: AudioFormatPropertyID = 0x666e616d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_encodeformatids?language=objc)
pub const kAudioFormatProperty_EncodeFormatIDs: AudioFormatPropertyID = 0x61636f66;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_decodeformatids?language=objc)
pub const kAudioFormatProperty_DecodeFormatIDs: AudioFormatPropertyID = 0x61636966;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_formatlist?language=objc)
pub const kAudioFormatProperty_FormatList: AudioFormatPropertyID = 0x666c7374;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_asbdfromesds?language=objc)
pub const kAudioFormatProperty_ASBDFromESDS: AudioFormatPropertyID = 0x65737364;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_channellayoutfromesds?language=objc)
pub const kAudioFormatProperty_ChannelLayoutFromESDS: AudioFormatPropertyID = 0x6573636c;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_outputformatlist?language=objc)
pub const kAudioFormatProperty_OutputFormatList: AudioFormatPropertyID = 0x6f666c73;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_firstplayableformatfromlist?language=objc)
pub const kAudioFormatProperty_FirstPlayableFormatFromList: AudioFormatPropertyID = 0x6670666c;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_formatisvbr?language=objc)
pub const kAudioFormatProperty_FormatIsVBR: AudioFormatPropertyID = 0x66766272;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_formatisexternallyframed?language=objc)
pub const kAudioFormatProperty_FormatIsExternallyFramed: AudioFormatPropertyID = 0x66657866;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_formatemploysdependentpackets?language=objc)
pub const kAudioFormatProperty_FormatEmploysDependentPackets: AudioFormatPropertyID = 0x66646570;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_formatisencrypted?language=objc)
pub const kAudioFormatProperty_FormatIsEncrypted: AudioFormatPropertyID = 0x63727970;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_encoders?language=objc)
pub const kAudioFormatProperty_Encoders: AudioFormatPropertyID = 0x6176656e;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_decoders?language=objc)
pub const kAudioFormatProperty_Decoders: AudioFormatPropertyID = 0x61766465;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_availableencodebitrates?language=objc)
pub const kAudioFormatProperty_AvailableEncodeBitRates: AudioFormatPropertyID = 0x61656272;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_availableencodesamplerates?language=objc)
pub const kAudioFormatProperty_AvailableEncodeSampleRates: AudioFormatPropertyID = 0x61657372;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_availableencodechannellayouttags?language=objc)
pub const kAudioFormatProperty_AvailableEncodeChannelLayoutTags: AudioFormatPropertyID = 0x6165636c;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_availableencodenumberchannels?language=objc)
pub const kAudioFormatProperty_AvailableEncodeNumberChannels: AudioFormatPropertyID = 0x61766e63;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_availabledecodenumberchannels?language=objc)
pub const kAudioFormatProperty_AvailableDecodeNumberChannels: AudioFormatPropertyID = 0x61646e63;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_asbdfrommpegpacket?language=objc)
pub const kAudioFormatProperty_ASBDFromMPEGPacket: AudioFormatPropertyID = 0x61646d70;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_bitmapforlayouttag?language=objc)
pub const kAudioFormatProperty_BitmapForLayoutTag: AudioFormatPropertyID = 0x626d7467;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_matrixmixmap?language=objc)
pub const kAudioFormatProperty_MatrixMixMap: AudioFormatPropertyID = 0x6d6d6170;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_channelmap?language=objc)
pub const kAudioFormatProperty_ChannelMap: AudioFormatPropertyID = 0x63686d70;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_numberofchannelsforlayout?language=objc)
pub const kAudioFormatProperty_NumberOfChannelsForLayout: AudioFormatPropertyID = 0x6e63686d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_arechannellayoutsequivalent?language=objc)
pub const kAudioFormatProperty_AreChannelLayoutsEquivalent: AudioFormatPropertyID = 0x63686571;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_channellayouthash?language=objc)
pub const kAudioFormatProperty_ChannelLayoutHash: AudioFormatPropertyID = 0x63686861;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_validatechannellayout?language=objc)
pub const kAudioFormatProperty_ValidateChannelLayout: AudioFormatPropertyID = 0x7661636c;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_channellayoutfortag?language=objc)
pub const kAudioFormatProperty_ChannelLayoutForTag: AudioFormatPropertyID = 0x636d706c;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_tagforchannellayout?language=objc)
pub const kAudioFormatProperty_TagForChannelLayout: AudioFormatPropertyID = 0x636d7074;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_channellayoutname?language=objc)
pub const kAudioFormatProperty_ChannelLayoutName: AudioFormatPropertyID = 0x6c6f6e6d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_channellayoutsimplename?language=objc)
pub const kAudioFormatProperty_ChannelLayoutSimpleName: AudioFormatPropertyID = 0x6c736e6d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_channellayoutforbitmap?language=objc)
pub const kAudioFormatProperty_ChannelLayoutForBitmap: AudioFormatPropertyID = 0x636d7062;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_channelname?language=objc)
pub const kAudioFormatProperty_ChannelName: AudioFormatPropertyID = 0x636e616d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_channelshortname?language=objc)
pub const kAudioFormatProperty_ChannelShortName: AudioFormatPropertyID = 0x63736e6d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_tagsfornumberofchannels?language=objc)
pub const kAudioFormatProperty_TagsForNumberOfChannels: AudioFormatPropertyID = 0x74616763;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_panningmatrix?language=objc)
pub const kAudioFormatProperty_PanningMatrix: AudioFormatPropertyID = 0x70616e6d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_balancefade?language=objc)
pub const kAudioFormatProperty_BalanceFade: AudioFormatPropertyID = 0x62616c66;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_id3tagsize?language=objc)
pub const kAudioFormatProperty_ID3TagSize: AudioFormatPropertyID = 0x69643373;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatproperty_id3tagtodictionary?language=objc)
pub const kAudioFormatProperty_ID3TagToDictionary: AudioFormatPropertyID = 0x69643364;

extern "C-unwind" {
    /// Retrieve information about the given property
    ///
    /// Parameter `inPropertyID`: an AudioFormatPropertyID constant.
    ///
    /// Parameter `inSpecifierSize`: The size of the specifier data.
    ///
    /// Parameter `inSpecifier`: A specifier is a buffer of data used as an input argument to some of the properties.
    ///
    /// Parameter `outPropertyDataSize`: The size in bytes of the current value of the property. In order to get the property value,
    /// you will need a buffer of this size.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFormatGetPropertyInfo(
        in_property_id: AudioFormatPropertyID,
        in_specifier_size: u32,
        in_specifier: *const c_void,
        out_property_data_size: NonNull<u32>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Retrieve the indicated property data
    ///
    /// Parameter `inPropertyID`: an AudioFormatPropertyID constant.
    ///
    /// Parameter `inSpecifierSize`: The size of the specifier data.
    ///
    /// Parameter `inSpecifier`: A specifier is a buffer of data used as an input argument to some of the properties.
    ///
    /// Parameter `ioPropertyDataSize`: on input the size of the outPropertyData buffer. On output the number of bytes written to the buffer.
    ///
    /// Parameter `outPropertyData`: the buffer in which to write the property data. If outPropertyData is NULL and ioPropertyDataSize is
    /// not, the amount that would have been written will be reported.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFormatGetProperty(
        in_property_id: AudioFormatPropertyID,
        in_specifier_size: u32,
        in_specifier: *const c_void,
        io_property_data_size: *mut u32,
        out_property_data: *mut c_void,
    ) -> OSStatus;
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatunspecifiederror?language=objc)
pub const kAudioFormatUnspecifiedError: OSStatus = 0x77686174;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatunsupportedpropertyerror?language=objc)
pub const kAudioFormatUnsupportedPropertyError: OSStatus = 0x70726f70;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatbadpropertysizeerror?language=objc)
pub const kAudioFormatBadPropertySizeError: OSStatus = 0x2173697a;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatbadspecifiersizeerror?language=objc)
pub const kAudioFormatBadSpecifierSizeError: OSStatus = 0x21737063;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatunsupporteddataformaterror?language=objc)
pub const kAudioFormatUnsupportedDataFormatError: OSStatus = 0x666d743f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioformatunknownformaterror?language=objc)
pub const kAudioFormatUnknownFormatError: OSStatus = 0x21666d74;
