---
name: 📌 Support Question
about: Ask a question about rsyslog configuration, behavior, or general usage.
title: "[Question]: "
labels: ['question', 'needs-triage']
assignees: ''
---

**👋 Before you ask, consider trying the rsyslog Assistant!**

We're excited to announce an **experimental AI-powered support tool**, the [rsyslog Assistant](https://rsyslog.ai). It's designed to provide quick answers to your rsyslog questions based on our extensive documentation and knowledge base.

**👉 Give it a try first at [https://rsyslog.ai](https://rsyslog.ai) – it might save you time!**

---

### 📝 Your Question / What you need help with:
(Provide a clear and concise description of your question or the problem you're trying to solve. What are you trying to achieve? What's the desired outcome?)


### 🧐 Expected Behavior (if applicable):
(Describe what you *expect* rsyslog to do or how you expect a feature to work.)


### 🤯 Actual Behavior / What's happening:
(Describe what rsyslog is *actually* doing, or the specific issue you're encountering. Include any error messages, unexpected outputs, or incorrect behavior.)


### 🔁 Steps to Reproduce the Behavior (if applicable):
(Provide a clear, step-by-step description of how to reliably reproduce the issue or the scenario leading to your question. This is crucial for us to understand and help.)

1. ...
2. ...
3. ...


### 💻 Environment:
(Please provide the following details about your setup. This information is vital for debugging.)

* **Rsyslog Version:** ``
* **Platform:** ``
* **Kernel Version:** ``
* **Deployment Method:** ``

### ⚙️ Configuration (if applicable):
(If your question relates to a configuration issue, please include your `rsyslog.conf` and any included configuration files (`*.conf` from `conf.d` etc.). **Please sanitize any sensitive information like passwords, API keys, or private IP addresses before pasting!** Use code blocks for readability.)

```conf
# Paste your rsyslog.conf or relevant snippets here
```

### ➕ Additional Context:

(Add any other relevant information that might help us understand your question better. This could include recent changes to your system, other software interacting with rsyslog, or any attempts you've already made to resolve the issue.)

-----

**Thank you for helping us improve rsyslog\!** 🙏
