/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai.dto;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatFunctionParameters;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatFunctionProperty;

public class ChatFunctionDynamic {
    @NotNull
    private String name;
    private String description;
    private ChatFunctionParameters parameters;

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ChatFunctionParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(ChatFunctionParameters parameters) {
        this.parameters = parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private ChatFunctionParameters parameters = new ChatFunctionParameters();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parameters(ChatFunctionParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder addProperty(ChatFunctionProperty property) {
            this.parameters.addProperty(property);
            return this;
        }

        public ChatFunctionDynamic build() {
            ChatFunctionDynamic chatFunction = new ChatFunctionDynamic();
            chatFunction.name = this.name;
            chatFunction.description = this.description;
            chatFunction.parameters = this.parameters;
            return chatFunction;
        }
    }
}

