/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridSequence;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.generic.edit.GenericSequenceManager;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class CubridSequenceManager
extends GenericSequenceManager {
    public static final String BASE_SERIAL_NAME = "new_serial";

    public boolean canCreateObject(@NotNull Object container) {
        CubridUser user = (CubridUser)((Object)container);
        CubridDataSource dataSource = user.getDataSource();
        boolean supportsMultiSchema = dataSource.getSupportMultiSchema();
        boolean isCurrentUser = user.getName().equalsIgnoreCase(dataSource.getCurrentUser());
        return supportsMultiSchema || isCurrentUser || !dataSource.isShard();
    }

    public boolean canEditObject(GenericSequence object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }

    public boolean canDeleteObject(GenericSequence object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    @NotNull
    protected GenericSequence createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, @Nullable Object container, @Nullable Object copyFrom, @NotNull Map<String, Object> options) {
        return new CubridSequence((GenericStructContainer)container, BASE_SERIAL_NAME);
    }

    @NotNull
    public String buildStatement(@NotNull CubridSequence sequence, boolean forUpdate, boolean hasComment) {
        StringBuilder sb = new StringBuilder();
        if (forUpdate) {
            sb.append("ALTER SERIAL ");
        } else {
            sb.append("CREATE SERIAL ");
        }
        sb.append(sequence.getFullyQualifiedName(DBPEvaluationContext.DDL));
        this.buildBody(sequence, sb);
        this.buildOtherValue(sequence, sb, hasComment);
        return sb.toString();
    }

    public void buildBody(@NotNull CubridSequence sequence, @NotNull StringBuilder sb) {
        if (sequence.getIncrementBy() != null) {
            sb.append(" INCREMENT BY ").append(sequence.getIncrementBy());
        }
        if (sequence.getStartValue() != null) {
            sb.append(" START WITH ").append(sequence.getStartValue());
        }
        if (sequence.getMaxValue() != null) {
            sb.append(" MAXVALUE ").append(sequence.getMaxValue());
        }
        if (sequence.getMinValue() != null) {
            sb.append(" MINVALUE ").append(sequence.getMinValue());
        }
    }

    public void buildOtherValue(@NotNull CubridSequence sequence, @NotNull StringBuilder sb, boolean hasComment) {
        if (sequence.getCycle()) {
            sb.append(" CYCLE");
        } else {
            sb.append(" NOCYCLE");
        }
        if (sequence.getCachedNum() != 0) {
            sb.append(" CACHE ").append(sequence.getCachedNum());
        }
        if (hasComment || sequence.getDescription() != null) {
            sb.append(" COMMENT ").append(SQLUtils.quoteString((DBSObject)sequence, (String)CommonUtils.notEmpty((String)sequence.getDescription())));
        }
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        CubridSequence sequence = (CubridSequence)command.getObject();
        boolean hasComment = command.hasProperty((Object)"description");
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Serial", this.buildStatement(sequence, false, hasComment)));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        CubridSequence sequence = (CubridSequence)command.getObject();
        boolean hasComment = command.hasProperty((Object)"description");
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter Serial", this.buildStatement(sequence, true, hasComment)));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop Serial", "DROP SERIAL " + ((GenericSequence)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.NestedObjectCommand<GenericSequence, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) {
    }
}

