/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.ByteArrayOutputStream;

public class PngDeflater {
    static final int BASE = 65521;
    static final int WINDOW = 32768;
    static final int MIN_LENGTH = 3;
    static final int MAX_MATCHES = 32;
    static final int HASH = 8209;
    byte[] in;
    int inLength;
    ByteArrayOutputStream bytes = new ByteArrayOutputStream(1024);
    int adler32 = 1;
    int buffer;
    int bitCount;
    Link[] hashtable = new Link[8209];
    Link[] window = new Link[32768];
    int nextWindow;
    static final short[] mirrorBytes = new short[]{0, 128, 64, 192, 32, 160, 96, 224, 16, 144, 80, 208, 48, 176, 112, 240, 8, 136, 72, 200, 40, 168, 104, 232, 24, 152, 88, 216, 56, 184, 120, 248, 4, 132, 68, 196, 36, 164, 100, 228, 20, 148, 84, 212, 52, 180, 116, 244, 12, 140, 76, 204, 44, 172, 108, 236, 28, 156, 92, 220, 60, 188, 124, 252, 2, 130, 66, 194, 34, 162, 98, 226, 18, 146, 82, 210, 50, 178, 114, 242, 10, 138, 74, 202, 42, 170, 106, 234, 26, 154, 90, 218, 58, 186, 122, 250, 6, 134, 70, 198, 38, 166, 102, 230, 22, 150, 86, 214, 54, 182, 118, 246, 14, 142, 78, 206, 46, 174, 110, 238, 30, 158, 94, 222, 62, 190, 126, 254, 1, 129, 65, 193, 33, 161, 97, 225, 17, 145, 81, 209, 49, 177, 113, 241, 9, 137, 73, 201, 41, 169, 105, 233, 25, 153, 89, 217, 57, 185, 121, 249, 5, 133, 69, 197, 37, 165, 101, 229, 21, 149, 85, 213, 53, 181, 117, 245, 13, 141, 77, 205, 45, 173, 109, 237, 29, 157, 93, 221, 61, 189, 125, 253, 3, 131, 67, 195, 35, 163, 99, 227, 19, 147, 83, 211, 51, 179, 115, 243, 11, 139, 75, 203, 43, 171, 107, 235, 27, 155, 91, 219, 59, 187, 123, 251, 7, 135, 71, 199, 39, 167, 103, 231, 23, 151, 87, 215, 55, 183, 119, 247, 15, 143, 79, 207, 47, 175, 111, 239, 31, 159, 95, 223, 63, 191, 127, 255};
    static final Code[] lengthCodes = new Code[]{new Code(257, 0, 3, 3), new Code(258, 0, 4, 4), new Code(259, 0, 5, 5), new Code(260, 0, 6, 6), new Code(261, 0, 7, 7), new Code(262, 0, 8, 8), new Code(263, 0, 9, 9), new Code(264, 0, 10, 10), new Code(265, 1, 11, 12), new Code(266, 1, 13, 14), new Code(267, 1, 15, 16), new Code(268, 1, 17, 18), new Code(269, 2, 19, 22), new Code(270, 2, 23, 26), new Code(271, 2, 27, 30), new Code(272, 2, 31, 34), new Code(273, 3, 35, 42), new Code(274, 3, 43, 50), new Code(275, 3, 51, 58), new Code(276, 3, 59, 66), new Code(277, 4, 67, 82), new Code(278, 4, 83, 98), new Code(279, 4, 99, 114), new Code(280, 4, 115, 130), new Code(281, 5, 131, 162), new Code(282, 5, 163, 194), new Code(283, 5, 195, 226), new Code(284, 5, 227, 257), new Code(285, 0, 258, 258)};
    static final Code[] distanceCodes = new Code[]{new Code(0, 0, 1, 1), new Code(1, 0, 2, 2), new Code(2, 0, 3, 3), new Code(3, 0, 4, 4), new Code(4, 1, 5, 6), new Code(5, 1, 7, 8), new Code(6, 2, 9, 12), new Code(7, 2, 13, 16), new Code(8, 3, 17, 24), new Code(9, 3, 25, 32), new Code(10, 4, 33, 48), new Code(11, 4, 49, 64), new Code(12, 5, 65, 96), new Code(13, 5, 97, 128), new Code(14, 6, 129, 192), new Code(15, 6, 193, 256), new Code(16, 7, 257, 384), new Code(17, 7, 385, 512), new Code(18, 8, 513, 768), new Code(19, 8, 769, 1024), new Code(20, 9, 1025, 1536), new Code(21, 9, 1537, 2048), new Code(22, 10, 2049, 3072), new Code(23, 10, 3073, 4096), new Code(24, 11, 4097, 6144), new Code(25, 11, 6145, 8192), new Code(26, 12, 8193, 12288), new Code(27, 12, 12289, 16384), new Code(28, 13, 16385, 24576), new Code(29, 13, 24577, 32768)};

    void writeShortLSB(ByteArrayOutputStream baos, int theShort) {
        byte byte1 = (byte)(theShort & 0xFF);
        byte byte2 = (byte)(theShort >> 8 & 0xFF);
        byte[] temp = new byte[]{byte1, byte2};
        baos.write(temp, 0, 2);
    }

    void writeInt(ByteArrayOutputStream baos, int theInt) {
        byte byte1 = (byte)(theInt >> 24 & 0xFF);
        byte byte2 = (byte)(theInt >> 16 & 0xFF);
        byte byte3 = (byte)(theInt >> 8 & 0xFF);
        byte byte4 = (byte)(theInt & 0xFF);
        byte[] temp = new byte[]{byte1, byte2, byte3, byte4};
        baos.write(temp, 0, 4);
    }

    void updateAdler(byte value) {
        int low = this.adler32 & 0xFFFF;
        int high = this.adler32 >> 16 & 0xFFFF;
        int valueInt = value & 0xFF;
        low = (low + valueInt) % 65521;
        high = (low + high) % 65521;
        this.adler32 = high << 16 | low;
    }

    int hash(byte[] bytes) {
        int hash = ((bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8) % 8209;
        if (hash < 0) {
            hash += 8209;
        }
        return hash;
    }

    void writeBits(int value, int count) {
        this.buffer |= value << this.bitCount;
        this.bitCount += count;
        if (this.bitCount >= 16) {
            this.bytes.write((byte)this.buffer);
            this.bytes.write((byte)(this.buffer >>> 8));
            this.buffer >>>= 16;
            this.bitCount -= 16;
        }
    }

    void alignToByte() {
        if (this.bitCount > 0) {
            this.bytes.write((byte)this.buffer);
            if (this.bitCount > 8) {
                this.bytes.write((byte)(this.buffer >>> 8));
            }
        }
        this.buffer = 0;
        this.bitCount = 0;
    }

    void outputLiteral(byte literal) {
        int i = literal & 0xFF;
        if (i <= 143) {
            this.writeBits(mirrorBytes[48 + i], 8);
        } else {
            this.writeBits(1 + 2 * mirrorBytes[0 + i], 9);
        }
    }

    Code findCode(int value, Code[] codes) {
        int k;
        int i = -1;
        int j = codes.length;
        while (true) {
            k = (j + i) / 2;
            if (value < codes[k].min) {
                j = k;
                continue;
            }
            if (value <= codes[k].max) break;
            i = k;
        }
        return codes[k];
    }

    void outputMatch(int length, int distance) {
        while (length > 0) {
            int thisLength = length > 260 ? 258 : (length <= 258 ? length : length - 3);
            length -= thisLength;
            Code l = this.findCode(thisLength, lengthCodes);
            if (l.code <= 279) {
                this.writeBits(mirrorBytes[(l.code - 256) * 2], 7);
            } else {
                this.writeBits(mirrorBytes[-88 + l.code], 8);
            }
            if (l.extraBits != 0) {
                this.writeBits(thisLength - l.min, l.extraBits);
            }
            Code d = this.findCode(distance, distanceCodes);
            this.writeBits(mirrorBytes[d.code * 8], 5);
            if (d.extraBits == 0) continue;
            this.writeBits(distance - d.min, d.extraBits);
        }
    }

    Match findLongestMatch(int position, Link firstPosition) {
        Link link = firstPosition;
        int numberOfMatches = 0;
        Match bestMatch = new Match(-1, -1);
        do {
            int matchPosition;
            if (position - (matchPosition = link.value) >= 32768 || matchPosition == 0) continue;
            int i = 1;
            while (position + i < this.inLength && this.in[position + i] == this.in[matchPosition + i]) {
                ++i;
            }
            if (i < 3) continue;
            if (i > bestMatch.length) {
                bestMatch.length = i;
                bestMatch.distance = position - matchPosition;
            }
            if (++numberOfMatches == 32) break;
        } while ((link = link.next) != null);
        if (bestMatch.length < 3 || bestMatch.distance < 1 || bestMatch.distance > 32768) {
            return null;
        }
        return bestMatch;
    }

    void updateHashtable(int to, int from) {
        byte[] data = new byte[3];
        for (int i = to; i < from && i + 3 <= this.inLength; ++i) {
            data[0] = this.in[i];
            data[1] = this.in[i + 1];
            data[2] = this.in[i + 2];
            int hash = this.hash(data);
            if (this.window[this.nextWindow].previous != null) {
                this.window[this.nextWindow].previous.next = null;
            } else if (this.window[this.nextWindow].hash != 0) {
                this.hashtable[this.window[this.nextWindow].hash].next = null;
            }
            this.window[this.nextWindow].hash = hash;
            this.window[this.nextWindow].value = i;
            this.window[this.nextWindow].previous = null;
            Link temp = this.window[this.nextWindow].next = this.hashtable[hash].next;
            this.hashtable[hash].next = this.window[this.nextWindow];
            if (temp != null) {
                temp.previous = this.window[this.nextWindow];
            }
            ++this.nextWindow;
            if (this.nextWindow != 32768) continue;
            this.nextWindow = 0;
        }
    }

    void compress() {
        int i;
        byte[] data = new byte[3];
        for (i = 0; i < 8209; ++i) {
            this.hashtable[i] = new Link();
        }
        for (i = 0; i < 32768; ++i) {
            this.window[i] = new Link();
        }
        this.nextWindow = 0;
        int deferredPosition = -1;
        Match deferredMatch = null;
        this.writeBits(1, 1);
        this.writeBits(1, 2);
        this.outputLiteral(this.in[0]);
        int position = 1;
        while (position < this.inLength) {
            int newPosition;
            if (this.inLength - position < 3) {
                this.outputLiteral(this.in[position]);
                ++position;
                continue;
            }
            data[0] = this.in[position];
            data[1] = this.in[position + 1];
            data[2] = this.in[position + 2];
            int hash = this.hash(data);
            Link firstPosition = this.hashtable[hash];
            Match match = this.findLongestMatch(position, firstPosition);
            this.updateHashtable(position, position + 1);
            if (match != null) {
                if (deferredMatch != null) {
                    if (match.length > deferredMatch.length + 1) {
                        this.outputLiteral(this.in[deferredPosition]);
                        deferredPosition = position++;
                        deferredMatch = match;
                        continue;
                    }
                    this.outputMatch(deferredMatch.length, deferredMatch.distance);
                    newPosition = deferredPosition + deferredMatch.length;
                    deferredPosition = -1;
                    deferredMatch = null;
                    this.updateHashtable(position + 1, newPosition);
                    position = newPosition;
                    continue;
                }
                deferredPosition = position++;
                deferredMatch = match;
                continue;
            }
            if (deferredMatch != null) {
                this.outputMatch(deferredMatch.length, deferredMatch.distance);
                newPosition = deferredPosition + deferredMatch.length;
                deferredPosition = -1;
                deferredMatch = null;
                this.updateHashtable(position + 1, newPosition);
                position = newPosition;
                continue;
            }
            this.outputLiteral(this.in[position]);
            ++position;
        }
        this.writeBits(0, 7);
        this.alignToByte();
    }

    void compressHuffmanOnly() {
        this.writeBits(1, 1);
        this.writeBits(1, 2);
        for (int position = 0; position < this.inLength; ++position) {
            this.outputLiteral(this.in[position]);
        }
        this.writeBits(0, 7);
        this.alignToByte();
    }

    void store() {
        int start = 0;
        int length = this.inLength;
        boolean BFINAL = false;
        while (length > 0) {
            int blockLength;
            if (length < 65535) {
                blockLength = length;
                BFINAL = true;
            } else {
                blockLength = 65535;
                BFINAL = false;
            }
            this.bytes.write((byte)(BFINAL ? 1 : 0));
            this.writeShortLSB(this.bytes, blockLength);
            this.writeShortLSB(this.bytes, blockLength ^ 0xFFFF);
            this.bytes.write(this.in, start, blockLength);
            length -= blockLength;
            start += blockLength;
        }
    }

    public byte[] deflate(byte[] input) {
        this.in = input;
        this.inLength = input.length;
        this.bytes.write(120);
        this.bytes.write(-100);
        for (int i = 0; i < this.inLength; ++i) {
            this.updateAdler(this.in[i]);
        }
        this.compress();
        this.writeInt(this.bytes, this.adler32);
        return this.bytes.toByteArray();
    }

    static class Link {
        int hash = 0;
        int value = 0;
        Link previous = null;
        Link next = null;

        Link() {
        }
    }

    static class Code {
        int code;
        int extraBits;
        int min;
        int max;

        Code(int code, int extraBits, int min, int max) {
            this.code = code;
            this.extraBits = extraBits;
            this.min = min;
            this.max = max;
        }
    }

    static class Match {
        int length;
        int distance;

        Match(int length, int distance) {
            this.length = length;
            this.distance = distance;
        }
    }
}

