/*
 * Created on 16-Mar-2006
 * Created by Paul Gardner
 * Copyright (C) Azureus Software, Inc, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package com.biglybt.core.speedmanager;

public interface
SpeedManagerAdapter
{
	public int
	getCurrentProtocolUploadSpeed(
		int	average_period );

	public long
	getCurrentDataUploadSpeed(
		int	average_period );

	public long
	getCurrentUploadLimit();

	public void
	setCurrentUploadLimit(
		long	bytes_per_second );

	public long
	getCurrentDownloadLimit();

	public void
	setCurrentDownloadLimit(
		long	bytes_per_second );

    public int
    getCurrentProtocolDownloadSpeed(
    	int	average_period );

    public long
    getCurrentDataDownloadSpeed(
    	int	average_period );

    public Object
	getLimits();

	public void
	setLimits(
		Object		limits,
		boolean		do_up,
		boolean		do_down );
}
