/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.tcp;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;

public class SslContextBuilder {
    private static final String[] NULL_STRING_ARRAY = new String[0];
    private static final Logger logger = LogManager.getLogger(SslContextBuilder.class);
    private boolean sslEnabled;
    private boolean shouldVerify;
    private String certPath;
    private String keyPath;
    private char[] keyPassword;
    private String[] certificateAuthorities = NULL_STRING_ARRAY;
    private String[] extraChainCerts = NULL_STRING_ARRAY;

    public SslContextBuilder setSslEnabled(boolean enabled) {
        this.sslEnabled = enabled;
        return this;
    }

    public SslContextBuilder setShouldVerify(boolean verify) {
        this.shouldVerify = verify;
        return this;
    }

    public SslContextBuilder setSslCert(String path) {
        this.certPath = path;
        return this;
    }

    public SslContextBuilder setSslKey(String path) {
        this.keyPath = path;
        return this;
    }

    public SslContextBuilder setSslKeyPassword(String password) {
        this.keyPassword = password == null ? null : password.toCharArray();
        return this;
    }

    public SslContextBuilder setSslCertificateAuthorities(String[] paths) {
        this.certificateAuthorities = paths;
        return this;
    }

    public SslContextBuilder setSslExtraChainCerts(String[] paths) {
        this.extraChainCerts = paths;
        return this;
    }

    public SslContext buildContext() throws Exception {
        PEMDecryptorProvider decryptor;
        PrivateKey privateKey;
        CertificateFactory certFactory;
        List<Certificate> certChain;
        if (!this.sslEnabled) {
            return null;
        }
        if (this.certPath == null) {
            throw new IllegalArgumentException("missing ssl_cert");
        }
        if (this.keyPath == null) {
            throw new IllegalArgumentException("missing ssl_key");
        }
        SslContextBuilder.installBouncyCastleProvider();
        if (Cipher.getMaxAllowedKeyLength("AES") <= 128) {
            logger.warn("JCE Unlimited Strength Jurisdiction Policy not installed - max key length is 128 bits");
        }
        if ((certChain = SslContextBuilder.getCertificatesFromFile(this.certPath, certFactory = CertificateFactory.getInstance("X.509"))).isEmpty()) {
            logger.warn("Failed to read certificate from path: {}", (Object)this.certPath);
            throw new IllegalArgumentException("failed to read certificate from ssl_cert path");
        }
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        converter.setProvider((Provider)new BouncyCastleProvider());
        Object obj = new PEMParser((Reader)new FileReader(this.keyPath)).readObject();
        if (obj instanceof PEMKeyPair) {
            privateKey = converter.getKeyPair((PEMKeyPair)obj).getPrivate();
        } else if (obj instanceof PrivateKeyInfo) {
            privateKey = converter.getPrivateKey((PrivateKeyInfo)obj);
        } else if (obj instanceof PEMEncryptedKeyPair) {
            decryptor = new JcePEMDecryptorProviderBuilder().build(this.keyPassword);
            PEMKeyPair keyPair = ((PEMEncryptedKeyPair)obj).decryptKeyPair(decryptor);
            privateKey = converter.getKeyPair(keyPair).getPrivate();
        } else if (obj instanceof PKCS8EncryptedPrivateKeyInfo) {
            decryptor = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(this.keyPassword);
            PrivateKeyInfo keyInfo = ((PKCS8EncryptedPrivateKeyInfo)obj).decryptPrivateKeyInfo((InputDecryptorProvider)decryptor);
            privateKey = converter.getPrivateKey(keyInfo);
        } else {
            throw new IllegalArgumentException("unexpected key format (" + (obj == null ? null : obj.getClass()) + ")");
        }
        for (PEMDecryptorProvider certPath : this.extraChainCerts) {
            certChain.addAll(SslContextBuilder.getCertificatesFromFile((String)certPath, certFactory));
        }
        io.netty.handler.ssl.SslContextBuilder sslContextBuilder = io.netty.handler.ssl.SslContextBuilder.forServer((PrivateKey)privateKey, (String)(this.keyPassword == null ? null : new String(this.keyPassword)), (X509Certificate[])certChain.toArray(new X509Certificate[certChain.size()]));
        ArrayList<Certificate> trustedCerts = new ArrayList<Certificate>();
        for (String certPath : this.certificateAuthorities) {
            trustedCerts.addAll(SslContextBuilder.getCertificatesFromFile(certPath, certFactory));
        }
        if (!trustedCerts.isEmpty()) {
            sslContextBuilder.trustManager(trustedCerts.toArray(new X509Certificate[trustedCerts.size()]));
        }
        sslContextBuilder.clientAuth(this.shouldVerify ? ClientAuth.REQUIRE : ClientAuth.NONE);
        try {
            return sslContextBuilder.build();
        }
        catch (SSLException e) {
            logger.debug("Failed to initialize SSL", (Throwable)e);
            if (("failed to initialize the server-side SSL context".equals(e.getMessage()) || "failed to initialize the client-side SSL context".equals(e.getMessage())) && e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        catch (Exception e) {
            logger.debug("Failed to initialize SSL", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Certificate> getCertificatesFromFile(String file, CertificateFactory factory) throws IOException, CertificateException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        try (FileInputStream fis = new FileInputStream(file);){
            while (fis.available() > 0) {
                try {
                    certificates.add(factory.generateCertificate(fis));
                }
                catch (CertificateException e) {
                    logger.debug("Failed to read certificate", (Throwable)e);
                    Throwable cause = e.getCause();
                    if (cause == null || !"Empty input".equals(cause.getMessage())) throw e;
                    logger.debug("Detected empty input while reading certificate (" + cause + ")");
                    continue;
                    return certificates;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installBouncyCastleProvider() {
        Class<Security> clazz = Security.class;
        synchronized (Security.class) {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

