// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The trace object in a response from <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>. Currently, you can only trace guardrails.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ConverseStreamTrace {
    /// <p>The guardrail trace object.</p>
    pub guardrail: ::std::option::Option<crate::types::GuardrailTraceAssessment>,
    /// <p>The request's prompt router.</p>
    pub prompt_router: ::std::option::Option<crate::types::PromptRouterTrace>,
}
impl ConverseStreamTrace {
    /// <p>The guardrail trace object.</p>
    pub fn guardrail(&self) -> ::std::option::Option<&crate::types::GuardrailTraceAssessment> {
        self.guardrail.as_ref()
    }
    /// <p>The request's prompt router.</p>
    pub fn prompt_router(&self) -> ::std::option::Option<&crate::types::PromptRouterTrace> {
        self.prompt_router.as_ref()
    }
}
impl ConverseStreamTrace {
    /// Creates a new builder-style object to manufacture [`ConverseStreamTrace`](crate::types::ConverseStreamTrace).
    pub fn builder() -> crate::types::builders::ConverseStreamTraceBuilder {
        crate::types::builders::ConverseStreamTraceBuilder::default()
    }
}

/// A builder for [`ConverseStreamTrace`](crate::types::ConverseStreamTrace).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ConverseStreamTraceBuilder {
    pub(crate) guardrail: ::std::option::Option<crate::types::GuardrailTraceAssessment>,
    pub(crate) prompt_router: ::std::option::Option<crate::types::PromptRouterTrace>,
}
impl ConverseStreamTraceBuilder {
    /// <p>The guardrail trace object.</p>
    pub fn guardrail(mut self, input: crate::types::GuardrailTraceAssessment) -> Self {
        self.guardrail = ::std::option::Option::Some(input);
        self
    }
    /// <p>The guardrail trace object.</p>
    pub fn set_guardrail(mut self, input: ::std::option::Option<crate::types::GuardrailTraceAssessment>) -> Self {
        self.guardrail = input;
        self
    }
    /// <p>The guardrail trace object.</p>
    pub fn get_guardrail(&self) -> &::std::option::Option<crate::types::GuardrailTraceAssessment> {
        &self.guardrail
    }
    /// <p>The request's prompt router.</p>
    pub fn prompt_router(mut self, input: crate::types::PromptRouterTrace) -> Self {
        self.prompt_router = ::std::option::Option::Some(input);
        self
    }
    /// <p>The request's prompt router.</p>
    pub fn set_prompt_router(mut self, input: ::std::option::Option<crate::types::PromptRouterTrace>) -> Self {
        self.prompt_router = input;
        self
    }
    /// <p>The request's prompt router.</p>
    pub fn get_prompt_router(&self) -> &::std::option::Option<crate::types::PromptRouterTrace> {
        &self.prompt_router
    }
    /// Consumes the builder and constructs a [`ConverseStreamTrace`](crate::types::ConverseStreamTrace).
    pub fn build(self) -> crate::types::ConverseStreamTrace {
        crate::types::ConverseStreamTrace {
            guardrail: self.guardrail,
            prompt_router: self.prompt_router,
        }
    }
}
