// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The unit of data of the Kinesis data stream, which is composed of a sequence number, a partition key, and a data blob.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Record {
    /// <p>The unique identifier of the record within its shard.</p>
    pub sequence_number: ::std::string::String,
    /// <p>The approximate time that the record was inserted into the stream.</p>
    pub approximate_arrival_timestamp: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The data blob. The data in the blob is both opaque and immutable to Kinesis Data Streams, which does not inspect, interpret, or change the data in the blob in any way. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).</p>
    pub data: ::aws_smithy_types::Blob,
    /// <p>Identifies which shard in the stream the data record is assigned to.</p>
    pub partition_key: ::std::string::String,
    /// <p>The encryption type used on the record. This parameter can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p><code>NONE</code>: Do not encrypt the records in the stream.</p></li>
    /// <li>
    /// <p><code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed Amazon Web Services KMS key.</p></li>
    /// </ul>
    pub encryption_type: ::std::option::Option<crate::types::EncryptionType>,
}
impl Record {
    /// <p>The unique identifier of the record within its shard.</p>
    pub fn sequence_number(&self) -> &str {
        use std::ops::Deref;
        self.sequence_number.deref()
    }
    /// <p>The approximate time that the record was inserted into the stream.</p>
    pub fn approximate_arrival_timestamp(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.approximate_arrival_timestamp.as_ref()
    }
    /// <p>The data blob. The data in the blob is both opaque and immutable to Kinesis Data Streams, which does not inspect, interpret, or change the data in the blob in any way. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).</p>
    pub fn data(&self) -> &::aws_smithy_types::Blob {
        &self.data
    }
    /// <p>Identifies which shard in the stream the data record is assigned to.</p>
    pub fn partition_key(&self) -> &str {
        use std::ops::Deref;
        self.partition_key.deref()
    }
    /// <p>The encryption type used on the record. This parameter can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p><code>NONE</code>: Do not encrypt the records in the stream.</p></li>
    /// <li>
    /// <p><code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed Amazon Web Services KMS key.</p></li>
    /// </ul>
    pub fn encryption_type(&self) -> ::std::option::Option<&crate::types::EncryptionType> {
        self.encryption_type.as_ref()
    }
}
impl Record {
    /// Creates a new builder-style object to manufacture [`Record`](crate::types::Record).
    pub fn builder() -> crate::types::builders::RecordBuilder {
        crate::types::builders::RecordBuilder::default()
    }
}

/// A builder for [`Record`](crate::types::Record).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct RecordBuilder {
    pub(crate) sequence_number: ::std::option::Option<::std::string::String>,
    pub(crate) approximate_arrival_timestamp: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) data: ::std::option::Option<::aws_smithy_types::Blob>,
    pub(crate) partition_key: ::std::option::Option<::std::string::String>,
    pub(crate) encryption_type: ::std::option::Option<crate::types::EncryptionType>,
}
impl RecordBuilder {
    /// <p>The unique identifier of the record within its shard.</p>
    /// This field is required.
    pub fn sequence_number(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.sequence_number = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The unique identifier of the record within its shard.</p>
    pub fn set_sequence_number(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.sequence_number = input;
        self
    }
    /// <p>The unique identifier of the record within its shard.</p>
    pub fn get_sequence_number(&self) -> &::std::option::Option<::std::string::String> {
        &self.sequence_number
    }
    /// <p>The approximate time that the record was inserted into the stream.</p>
    pub fn approximate_arrival_timestamp(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.approximate_arrival_timestamp = ::std::option::Option::Some(input);
        self
    }
    /// <p>The approximate time that the record was inserted into the stream.</p>
    pub fn set_approximate_arrival_timestamp(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.approximate_arrival_timestamp = input;
        self
    }
    /// <p>The approximate time that the record was inserted into the stream.</p>
    pub fn get_approximate_arrival_timestamp(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.approximate_arrival_timestamp
    }
    /// <p>The data blob. The data in the blob is both opaque and immutable to Kinesis Data Streams, which does not inspect, interpret, or change the data in the blob in any way. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).</p>
    /// This field is required.
    pub fn data(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.data = ::std::option::Option::Some(input);
        self
    }
    /// <p>The data blob. The data in the blob is both opaque and immutable to Kinesis Data Streams, which does not inspect, interpret, or change the data in the blob in any way. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).</p>
    pub fn set_data(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.data = input;
        self
    }
    /// <p>The data blob. The data in the blob is both opaque and immutable to Kinesis Data Streams, which does not inspect, interpret, or change the data in the blob in any way. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).</p>
    pub fn get_data(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.data
    }
    /// <p>Identifies which shard in the stream the data record is assigned to.</p>
    /// This field is required.
    pub fn partition_key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.partition_key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Identifies which shard in the stream the data record is assigned to.</p>
    pub fn set_partition_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.partition_key = input;
        self
    }
    /// <p>Identifies which shard in the stream the data record is assigned to.</p>
    pub fn get_partition_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.partition_key
    }
    /// <p>The encryption type used on the record. This parameter can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p><code>NONE</code>: Do not encrypt the records in the stream.</p></li>
    /// <li>
    /// <p><code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed Amazon Web Services KMS key.</p></li>
    /// </ul>
    pub fn encryption_type(mut self, input: crate::types::EncryptionType) -> Self {
        self.encryption_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The encryption type used on the record. This parameter can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p><code>NONE</code>: Do not encrypt the records in the stream.</p></li>
    /// <li>
    /// <p><code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed Amazon Web Services KMS key.</p></li>
    /// </ul>
    pub fn set_encryption_type(mut self, input: ::std::option::Option<crate::types::EncryptionType>) -> Self {
        self.encryption_type = input;
        self
    }
    /// <p>The encryption type used on the record. This parameter can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p><code>NONE</code>: Do not encrypt the records in the stream.</p></li>
    /// <li>
    /// <p><code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed Amazon Web Services KMS key.</p></li>
    /// </ul>
    pub fn get_encryption_type(&self) -> &::std::option::Option<crate::types::EncryptionType> {
        &self.encryption_type
    }
    /// Consumes the builder and constructs a [`Record`](crate::types::Record).
    /// This method will fail if any of the following fields are not set:
    /// - [`sequence_number`](crate::types::builders::RecordBuilder::sequence_number)
    /// - [`data`](crate::types::builders::RecordBuilder::data)
    /// - [`partition_key`](crate::types::builders::RecordBuilder::partition_key)
    pub fn build(self) -> ::std::result::Result<crate::types::Record, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::Record {
            sequence_number: self.sequence_number.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "sequence_number",
                    "sequence_number was not specified but it is required when building Record",
                )
            })?,
            approximate_arrival_timestamp: self.approximate_arrival_timestamp,
            data: self.data.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "data",
                    "data was not specified but it is required when building Record",
                )
            })?,
            partition_key: self.partition_key.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "partition_key",
                    "partition_key was not specified but it is required when building Record",
                )
            })?,
            encryption_type: self.encryption_type,
        })
    }
}
