//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextformattingviewcontrollerdelegate?language=objc)
    pub unsafe trait UITextFormattingViewControllerDelegate:
        NSObjectProtocol + MainThreadOnly
    {
        #[cfg(all(
            feature = "UIResponder",
            feature = "UITextFormattingViewControllerChangeValue",
            feature = "UIViewController"
        ))]
        /// Delegate method that will be invoked on any text formatting changes.
        ///
        /// - Parameters:
        /// - viewController: Text formatting controller in which action was performed.
        /// - changeValue: Object describing the change made via view controller.
        #[unsafe(method(textFormattingViewController:didChangeValue:))]
        #[unsafe(method_family = none)]
        unsafe fn textFormattingViewController_didChangeValue(
            &self,
            view_controller: &UITextFormattingViewController,
            change_value: &UITextFormattingViewControllerChangeValue,
        );

        #[cfg(all(
            feature = "UIFontPickerViewController",
            feature = "UIResponder",
            feature = "UIViewController"
        ))]
        /// If implemented, text formatting will call this method before presenting font picker controller.
        /// Use this method to make any presentation modifications or to prevent presentation altogether.
        ///
        /// If you decide to prevent presentation of font picker via text formatting controller, you may present provided font picker yourself.
        /// In this case, you will have to handle any font picker actions independently.
        ///
        /// - Parameters:
        /// - viewController: Text formatting controller that is attempting to present font picker controller
        /// - fontPicker: Font picker controller that will be presented.
        /// - Returns: Flag indicating if text formatting controller should present font picker.
        #[optional]
        #[unsafe(method(textFormattingViewController:shouldPresentFontPicker:))]
        #[unsafe(method_family = none)]
        unsafe fn textFormattingViewController_shouldPresentFontPicker(
            &self,
            view_controller: &UITextFormattingViewController,
            font_picker: &UIFontPickerViewController,
        ) -> bool;

        #[cfg(all(
            feature = "UIColorPickerViewController",
            feature = "UIResponder",
            feature = "UIViewController"
        ))]
        /// If implemented, text formatting will call this method before presenting color picker controller.
        /// Use this method to make any presentation modifications or to prevent presentation altogether.
        ///
        /// You may decide to prevent presentation of color picker via text formatting controller.
        /// In that case, you may present provided color picker controller yourself, but you will have to handle any actions in that controller separately.
        ///
        /// - Parameters:
        /// - viewController: Text formatting controller that is attempting to present font picker controller
        /// - colorPicker: Color picker controller that will be presented.
        /// - Returns: Flag indicating if text formatting controller should present font picker.
        #[optional]
        #[unsafe(method(textFormattingViewController:shouldPresentColorPicker:))]
        #[unsafe(method_family = none)]
        unsafe fn textFormattingViewController_shouldPresentColorPicker(
            &self,
            view_controller: &UITextFormattingViewController,
            color_picker: &UIColorPickerViewController,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        /// Informs the delegate that user has dismissed text formatting view controller.
        #[optional]
        #[unsafe(method(textFormattingDidFinish:))]
        #[unsafe(method_family = none)]
        unsafe fn textFormattingDidFinish(&self, view_controller: &UITextFormattingViewController);
    }
);

extern_class!(
    /// A view controller that manages the interface for common text formatting options.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextformattingviewcontroller?language=objc)
    #[unsafe(super(UIViewController, UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
    pub struct UITextFormattingViewController;
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
extern_conformance!(
    unsafe impl NSCoding for UITextFormattingViewController {}
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for UITextFormattingViewController {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIResponder",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UITextFormattingViewController {}
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
extern_conformance!(
    unsafe impl UIContentContainer for UITextFormattingViewController {}
);

#[cfg(all(
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UITextFormattingViewController {}
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UITextFormattingViewController {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UITraitCollection",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UITextFormattingViewController {}
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
impl UITextFormattingViewController {
    extern_methods!(
        #[cfg(feature = "UITextFormattingViewControllerConfiguration")]
        /// Current text formatting configuration object.
        #[unsafe(method(configuration))]
        #[unsafe(method_family = none)]
        pub unsafe fn configuration(&self)
            -> Retained<UITextFormattingViewControllerConfiguration>;

        #[cfg(feature = "UITextFormattingViewControllerFormattingDescriptor")]
        /// Current formatting descriptor.
        #[unsafe(method(formattingDescriptor))]
        #[unsafe(method_family = none)]
        pub unsafe fn formattingDescriptor(
            &self,
        ) -> Option<Retained<UITextFormattingViewControllerFormattingDescriptor>>;

        #[cfg(feature = "UITextFormattingViewControllerFormattingDescriptor")]
        /// Setter for [`formattingDescriptor`][Self::formattingDescriptor].
        #[unsafe(method(setFormattingDescriptor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFormattingDescriptor(
            &self,
            formatting_descriptor: Option<&UITextFormattingViewControllerFormattingDescriptor>,
        );

        /// Text formatting delegate.
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UITextFormattingViewControllerDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn UITextFormattingViewControllerDelegate>>,
        );

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(initWithNibName:bundle:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithNibName_bundle(
            this: Allocated<Self>,
            nib_name_or_nil: Option<&NSString>,
            nib_bundle_or_nil: Option<&NSBundle>,
        ) -> Retained<Self>;

        #[cfg(feature = "UITextFormattingViewControllerConfiguration")]
        #[unsafe(method(initWithConfiguration:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithConfiguration(
            this: Allocated<Self>,
            configuration: &UITextFormattingViewControllerConfiguration,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `UIViewController`.
#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
impl UITextFormattingViewController {
    extern_methods!(
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
impl UITextFormattingViewController {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
