// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test_request_id.proto

#include "generator/integration_tests/golden/v1/request_id_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace golden_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

RequestIdServiceConnectionIdempotencyPolicy::~RequestIdServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<RequestIdServiceConnectionIdempotencyPolicy>
RequestIdServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<RequestIdServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency RequestIdServiceConnectionIdempotencyPolicy::CreateFoo(google::test::requestid::v1::CreateFooRequest const& request) {
  if (!request.request_id().empty()) return Idempotency::kIdempotent;
  return Idempotency::kNonIdempotent;
}

Idempotency RequestIdServiceConnectionIdempotencyPolicy::RenameFoo(google::test::requestid::v1::RenameFooRequest const& request) {
  if (!request.request_id().empty()) return Idempotency::kIdempotent;
  return Idempotency::kNonIdempotent;
}

Idempotency RequestIdServiceConnectionIdempotencyPolicy::ListFoos(google::test::requestid::v1::ListFoosRequest) {  // NOLINT
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<RequestIdServiceConnectionIdempotencyPolicy>
    MakeDefaultRequestIdServiceConnectionIdempotencyPolicy() {
  return std::make_unique<RequestIdServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1
}  // namespace cloud
}  // namespace google
