// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#include "google/cloud/appengine/v1/domain_mappings_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace appengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DomainMappingsClient::DomainMappingsClient(
    std::shared_ptr<DomainMappingsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DomainMappingsClient::~DomainMappingsClient() = default;

StreamRange<google::appengine::v1::DomainMapping>
DomainMappingsClient::ListDomainMappings(
    google::appengine::v1::ListDomainMappingsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDomainMappings(std::move(request));
}

StatusOr<google::appengine::v1::DomainMapping>
DomainMappingsClient::GetDomainMapping(
    google::appengine::v1::GetDomainMappingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDomainMapping(request);
}

future<StatusOr<google::appengine::v1::DomainMapping>>
DomainMappingsClient::CreateDomainMapping(
    google::appengine::v1::CreateDomainMappingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDomainMapping(request);
}

StatusOr<google::longrunning::Operation>
DomainMappingsClient::CreateDomainMapping(
    NoAwaitTag,
    google::appengine::v1::CreateDomainMappingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDomainMapping(NoAwaitTag{}, request);
}

future<StatusOr<google::appengine::v1::DomainMapping>>
DomainMappingsClient::CreateDomainMapping(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDomainMapping(operation);
}

future<StatusOr<google::appengine::v1::DomainMapping>>
DomainMappingsClient::UpdateDomainMapping(
    google::appengine::v1::UpdateDomainMappingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDomainMapping(request);
}

StatusOr<google::longrunning::Operation>
DomainMappingsClient::UpdateDomainMapping(
    NoAwaitTag,
    google::appengine::v1::UpdateDomainMappingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDomainMapping(NoAwaitTag{}, request);
}

future<StatusOr<google::appengine::v1::DomainMapping>>
DomainMappingsClient::UpdateDomainMapping(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDomainMapping(operation);
}

future<StatusOr<google::appengine::v1::OperationMetadataV1>>
DomainMappingsClient::DeleteDomainMapping(
    google::appengine::v1::DeleteDomainMappingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDomainMapping(request);
}

StatusOr<google::longrunning::Operation>
DomainMappingsClient::DeleteDomainMapping(
    NoAwaitTag,
    google::appengine::v1::DeleteDomainMappingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDomainMapping(NoAwaitTag{}, request);
}

future<StatusOr<google::appengine::v1::OperationMetadataV1>>
DomainMappingsClient::DeleteDomainMapping(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDomainMapping(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine_v1
}  // namespace cloud
}  // namespace google
