// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/artifactregistry/v1/service.proto

#include "google/cloud/artifactregistry/v1/internal/artifact_registry_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/devtools/artifactregistry/v1/service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace artifactregistry_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ArtifactRegistryMetadata::ArtifactRegistryMetadata(
    std::shared_ptr<ArtifactRegistryStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::devtools::artifactregistry::v1::ListDockerImagesResponse>
ArtifactRegistryMetadata::ListDockerImages(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::ListDockerImagesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListDockerImages(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::DockerImage>
ArtifactRegistryMetadata::GetDockerImage(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::GetDockerImageRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetDockerImage(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::ListMavenArtifactsResponse>
ArtifactRegistryMetadata::ListMavenArtifacts(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::ListMavenArtifactsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListMavenArtifacts(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::MavenArtifact>
ArtifactRegistryMetadata::GetMavenArtifact(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::GetMavenArtifactRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetMavenArtifact(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::ListNpmPackagesResponse>
ArtifactRegistryMetadata::ListNpmPackages(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::ListNpmPackagesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListNpmPackages(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::NpmPackage>
ArtifactRegistryMetadata::GetNpmPackage(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::GetNpmPackageRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetNpmPackage(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::ListPythonPackagesResponse>
ArtifactRegistryMetadata::ListPythonPackages(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::ListPythonPackagesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListPythonPackages(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::PythonPackage>
ArtifactRegistryMetadata::GetPythonPackage(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::GetPythonPackageRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetPythonPackage(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ArtifactRegistryMetadata::AsyncImportAptArtifacts(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::devtools::artifactregistry::v1::ImportAptArtifactsRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncImportAptArtifacts(cq, std::move(context),
                                         std::move(options), request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryMetadata::ImportAptArtifacts(
    grpc::ClientContext& context, Options options,
    google::devtools::artifactregistry::v1::ImportAptArtifactsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ImportAptArtifacts(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ArtifactRegistryMetadata::AsyncImportYumArtifacts(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::devtools::artifactregistry::v1::ImportYumArtifactsRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncImportYumArtifacts(cq, std::move(context),
                                         std::move(options), request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryMetadata::ImportYumArtifacts(
    grpc::ClientContext& context, Options options,
    google::devtools::artifactregistry::v1::ImportYumArtifactsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ImportYumArtifacts(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::ListRepositoriesResponse>
ArtifactRegistryMetadata::ListRepositories(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::ListRepositoriesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListRepositories(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryMetadata::GetRepository(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::GetRepositoryRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetRepository(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ArtifactRegistryMetadata::AsyncCreateRepository(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::devtools::artifactregistry::v1::CreateRepositoryRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateRepository(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryMetadata::CreateRepository(
    grpc::ClientContext& context, Options options,
    google::devtools::artifactregistry::v1::CreateRepositoryRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateRepository(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryMetadata::UpdateRepository(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::UpdateRepositoryRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("repository.name=",
                           internal::UrlEncode(request.repository().name())));
  return child_->UpdateRepository(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ArtifactRegistryMetadata::AsyncDeleteRepository(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::devtools::artifactregistry::v1::DeleteRepositoryRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteRepository(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryMetadata::DeleteRepository(
    grpc::ClientContext& context, Options options,
    google::devtools::artifactregistry::v1::DeleteRepositoryRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteRepository(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::ListPackagesResponse>
ArtifactRegistryMetadata::ListPackages(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::ListPackagesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListPackages(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::Package>
ArtifactRegistryMetadata::GetPackage(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::GetPackageRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetPackage(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ArtifactRegistryMetadata::AsyncDeletePackage(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::devtools::artifactregistry::v1::DeletePackageRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeletePackage(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryMetadata::DeletePackage(
    grpc::ClientContext& context, Options options,
    google::devtools::artifactregistry::v1::DeletePackageRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeletePackage(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::ListVersionsResponse>
ArtifactRegistryMetadata::ListVersions(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::ListVersionsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListVersions(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::Version>
ArtifactRegistryMetadata::GetVersion(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::GetVersionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetVersion(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ArtifactRegistryMetadata::AsyncDeleteVersion(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::devtools::artifactregistry::v1::DeleteVersionRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteVersion(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryMetadata::DeleteVersion(
    grpc::ClientContext& context, Options options,
    google::devtools::artifactregistry::v1::DeleteVersionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteVersion(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ArtifactRegistryMetadata::AsyncBatchDeleteVersions(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::devtools::artifactregistry::v1::BatchDeleteVersionsRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncBatchDeleteVersions(cq, std::move(context),
                                          std::move(options), request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryMetadata::BatchDeleteVersions(
    grpc::ClientContext& context, Options options,
    google::devtools::artifactregistry::v1::BatchDeleteVersionsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchDeleteVersions(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::ListFilesResponse>
ArtifactRegistryMetadata::ListFiles(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::ListFilesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListFiles(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::File>
ArtifactRegistryMetadata::GetFile(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::GetFileRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetFile(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::ListTagsResponse>
ArtifactRegistryMetadata::ListTags(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::ListTagsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListTags(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryMetadata::GetTag(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::GetTagRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetTag(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryMetadata::CreateTag(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::CreateTagRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateTag(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryMetadata::UpdateTag(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::UpdateTagRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("tag.name=", internal::UrlEncode(request.tag().name())));
  return child_->UpdateTag(context, options, request);
}

Status ArtifactRegistryMetadata::DeleteTag(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::DeleteTagRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteTag(context, options, request);
}

StatusOr<google::iam::v1::Policy> ArtifactRegistryMetadata::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> ArtifactRegistryMetadata::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ArtifactRegistryMetadata::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->TestIamPermissions(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
ArtifactRegistryMetadata::GetProjectSettings(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::GetProjectSettingsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetProjectSettings(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
ArtifactRegistryMetadata::UpdateProjectSettings(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::UpdateProjectSettingsRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("project_settings.name=",
                   internal::UrlEncode(request.project_settings().name())));
  return child_->UpdateProjectSettings(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
ArtifactRegistryMetadata::GetVPCSCConfig(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::GetVPCSCConfigRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetVPCSCConfig(context, options, request);
}

StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
ArtifactRegistryMetadata::UpdateVPCSCConfig(
    grpc::ClientContext& context, Options const& options,
    google::devtools::artifactregistry::v1::UpdateVPCSCConfigRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("vpcsc_config.name=",
                           internal::UrlEncode(request.vpcsc_config().name())));
  return child_->UpdateVPCSCConfig(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ArtifactRegistryMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> ArtifactRegistryMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void ArtifactRegistryMetadata::SetMetadata(grpc::ClientContext& context,
                                           Options const& options,
                                           std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void ArtifactRegistryMetadata::SetMetadata(grpc::ClientContext& context,
                                           Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace artifactregistry_v1_internal
}  // namespace cloud
}  // namespace google
