// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

#include "google/cloud/bigtable/admin/bigtable_table_admin_connection.h"
#include "google/cloud/bigtable/admin/bigtable_table_admin_options.h"
#include "google/cloud/bigtable/admin/internal/bigtable_table_admin_connection_impl.h"
#include "google/cloud/bigtable/admin/internal/bigtable_table_admin_option_defaults.h"
#include "google/cloud/bigtable/admin/internal/bigtable_table_admin_stub_factory.h"
#include "google/cloud/bigtable/admin/internal/bigtable_table_admin_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigtable_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BigtableTableAdminConnection::~BigtableTableAdminConnection() = default;

StatusOr<google::bigtable::admin::v2::Table>
BigtableTableAdminConnection::CreateTable(
    google::bigtable::admin::v2::CreateTableRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::bigtable::admin::v2::Table>
BigtableTableAdminConnection::ListTables(
    google::bigtable::admin::v2::
        ListTablesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::bigtable::admin::v2::Table>>();
}

StatusOr<google::bigtable::admin::v2::Table>
BigtableTableAdminConnection::GetTable(
    google::bigtable::admin::v2::GetTableRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::bigtable::admin::v2::Table>>
BigtableTableAdminConnection::UpdateTable(
    google::bigtable::admin::v2::UpdateTableRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Table>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableTableAdminConnection::UpdateTable(
    NoAwaitTag, google::bigtable::admin::v2::UpdateTableRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::Table>>
BigtableTableAdminConnection::UpdateTable(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Table>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status BigtableTableAdminConnection::DeleteTable(
    google::bigtable::admin::v2::DeleteTableRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::bigtable::admin::v2::Table>>
BigtableTableAdminConnection::UndeleteTable(
    google::bigtable::admin::v2::UndeleteTableRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Table>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableTableAdminConnection::UndeleteTable(
    NoAwaitTag, google::bigtable::admin::v2::UndeleteTableRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::Table>>
BigtableTableAdminConnection::UndeleteTable(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Table>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::AuthorizedView>>
BigtableTableAdminConnection::CreateAuthorizedView(
    google::bigtable::admin::v2::CreateAuthorizedViewRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::AuthorizedView>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableTableAdminConnection::CreateAuthorizedView(
    NoAwaitTag,
    google::bigtable::admin::v2::CreateAuthorizedViewRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::AuthorizedView>>
BigtableTableAdminConnection::CreateAuthorizedView(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::AuthorizedView>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::bigtable::admin::v2::AuthorizedView>
BigtableTableAdminConnection::ListAuthorizedViews(
    google::bigtable::admin::v2::
        ListAuthorizedViewsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::bigtable::admin::v2::AuthorizedView>>();
}

StatusOr<google::bigtable::admin::v2::AuthorizedView>
BigtableTableAdminConnection::GetAuthorizedView(
    google::bigtable::admin::v2::GetAuthorizedViewRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::bigtable::admin::v2::AuthorizedView>>
BigtableTableAdminConnection::UpdateAuthorizedView(
    google::bigtable::admin::v2::UpdateAuthorizedViewRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::AuthorizedView>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableTableAdminConnection::UpdateAuthorizedView(
    NoAwaitTag,
    google::bigtable::admin::v2::UpdateAuthorizedViewRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::AuthorizedView>>
BigtableTableAdminConnection::UpdateAuthorizedView(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::AuthorizedView>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status BigtableTableAdminConnection::DeleteAuthorizedView(
    google::bigtable::admin::v2::DeleteAuthorizedViewRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::bigtable::admin::v2::Table>
BigtableTableAdminConnection::ModifyColumnFamilies(
    google::bigtable::admin::v2::ModifyColumnFamiliesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status BigtableTableAdminConnection::DropRowRange(
    google::bigtable::admin::v2::DropRowRangeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::bigtable::admin::v2::GenerateConsistencyTokenResponse>
BigtableTableAdminConnection::GenerateConsistencyToken(
    google::bigtable::admin::v2::GenerateConsistencyTokenRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::bigtable::admin::v2::CheckConsistencyResponse>
BigtableTableAdminConnection::CheckConsistency(
    google::bigtable::admin::v2::CheckConsistencyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::bigtable::admin::v2::Backup>>
BigtableTableAdminConnection::CreateBackup(
    google::bigtable::admin::v2::CreateBackupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Backup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableTableAdminConnection::CreateBackup(
    NoAwaitTag, google::bigtable::admin::v2::CreateBackupRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::Backup>>
BigtableTableAdminConnection::CreateBackup(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Backup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::bigtable::admin::v2::Backup>
BigtableTableAdminConnection::GetBackup(
    google::bigtable::admin::v2::GetBackupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::bigtable::admin::v2::Backup>
BigtableTableAdminConnection::UpdateBackup(
    google::bigtable::admin::v2::UpdateBackupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status BigtableTableAdminConnection::DeleteBackup(
    google::bigtable::admin::v2::DeleteBackupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::bigtable::admin::v2::Backup>
BigtableTableAdminConnection::ListBackups(
    google::bigtable::admin::v2::
        ListBackupsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::bigtable::admin::v2::Backup>>();
}

future<StatusOr<google::bigtable::admin::v2::Table>>
BigtableTableAdminConnection::RestoreTable(
    google::bigtable::admin::v2::RestoreTableRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Table>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableTableAdminConnection::RestoreTable(
    NoAwaitTag, google::bigtable::admin::v2::RestoreTableRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::Table>>
BigtableTableAdminConnection::RestoreTable(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Table>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::Backup>>
BigtableTableAdminConnection::CopyBackup(
    google::bigtable::admin::v2::CopyBackupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Backup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BigtableTableAdminConnection::CopyBackup(
    NoAwaitTag, google::bigtable::admin::v2::CopyBackupRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::bigtable::admin::v2::Backup>>
BigtableTableAdminConnection::CopyBackup(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::Backup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::iam::v1::Policy> BigtableTableAdminConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> BigtableTableAdminConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
BigtableTableAdminConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::bigtable::admin::v2::CheckConsistencyResponse>>
BigtableTableAdminConnection::AsyncCheckConsistency(
    google::bigtable::admin::v2::CheckConsistencyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::bigtable::admin::v2::CheckConsistencyResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<BigtableTableAdminConnection> MakeBigtableTableAdminConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 BigtableTableAdminPolicyOptionList>(options,
                                                                     __func__);
  options = bigtable_admin_internal::BigtableTableAdminDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = bigtable_admin_internal::CreateDefaultBigtableTableAdminStub(
      std::move(auth), options);
  return bigtable_admin_internal::MakeBigtableTableAdminTracingConnection(
      std::make_shared<
          bigtable_admin_internal::BigtableTableAdminConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigtable_admin
}  // namespace cloud
}  // namespace google
