// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/data_taxonomy.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_DATA_TAXONOMY_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_DATA_TAXONOMY_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/dataplex/v1/data_taxonomy.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DataTaxonomyServiceConnectionIdempotencyPolicy {
 public:
  virtual ~DataTaxonomyServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<DataTaxonomyServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency CreateDataTaxonomy(
      google::cloud::dataplex::v1::CreateDataTaxonomyRequest const& request);

  virtual google::cloud::Idempotency UpdateDataTaxonomy(
      google::cloud::dataplex::v1::UpdateDataTaxonomyRequest const& request);

  virtual google::cloud::Idempotency DeleteDataTaxonomy(
      google::cloud::dataplex::v1::DeleteDataTaxonomyRequest const& request);

  virtual google::cloud::Idempotency ListDataTaxonomies(
      google::cloud::dataplex::v1::ListDataTaxonomiesRequest request);

  virtual google::cloud::Idempotency GetDataTaxonomy(
      google::cloud::dataplex::v1::GetDataTaxonomyRequest const& request);

  virtual google::cloud::Idempotency CreateDataAttributeBinding(
      google::cloud::dataplex::v1::CreateDataAttributeBindingRequest const&
          request);

  virtual google::cloud::Idempotency UpdateDataAttributeBinding(
      google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest const&
          request);

  virtual google::cloud::Idempotency DeleteDataAttributeBinding(
      google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest const&
          request);

  virtual google::cloud::Idempotency ListDataAttributeBindings(
      google::cloud::dataplex::v1::ListDataAttributeBindingsRequest request);

  virtual google::cloud::Idempotency GetDataAttributeBinding(
      google::cloud::dataplex::v1::GetDataAttributeBindingRequest const&
          request);

  virtual google::cloud::Idempotency CreateDataAttribute(
      google::cloud::dataplex::v1::CreateDataAttributeRequest const& request);

  virtual google::cloud::Idempotency UpdateDataAttribute(
      google::cloud::dataplex::v1::UpdateDataAttributeRequest const& request);

  virtual google::cloud::Idempotency DeleteDataAttribute(
      google::cloud::dataplex::v1::DeleteDataAttributeRequest const& request);

  virtual google::cloud::Idempotency ListDataAttributes(
      google::cloud::dataplex::v1::ListDataAttributesRequest request);

  virtual google::cloud::Idempotency GetDataAttribute(
      google::cloud::dataplex::v1::GetDataAttributeRequest const& request);
};

std::unique_ptr<DataTaxonomyServiceConnectionIdempotencyPolicy>
MakeDefaultDataTaxonomyServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_DATA_TAXONOMY_CONNECTION_IDEMPOTENCY_POLICY_H
