// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/metric_service.proto

#include "google/cloud/monitoring/v3/internal/metric_connection_impl.h"
#include "google/cloud/monitoring/v3/internal/metric_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_retry_loop.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<monitoring_v3::MetricServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<monitoring_v3::MetricServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<monitoring_v3::MetricServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<monitoring_v3::MetricServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<monitoring_v3::MetricServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

MetricServiceConnectionImpl::MetricServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<monitoring_v3_internal::MetricServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      MetricServiceConnection::options())) {}

StreamRange<google::api::MonitoredResourceDescriptor>
MetricServiceConnectionImpl::ListMonitoredResourceDescriptors(
    google::monitoring::v3::ListMonitoredResourceDescriptorsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListMonitoredResourceDescriptors(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::api::MonitoredResourceDescriptor>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<monitoring_v3::MetricServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::monitoring::v3::ListMonitoredResourceDescriptorsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::monitoring::v3::
                       ListMonitoredResourceDescriptorsRequest const& request) {
              return stub->ListMonitoredResourceDescriptors(context, options,
                                                            request);
            },
            options, r, function_name);
      },
      [](google::monitoring::v3::ListMonitoredResourceDescriptorsResponse r) {
        std::vector<google::api::MonitoredResourceDescriptor> result(
            r.resource_descriptors().size());
        auto& messages = *r.mutable_resource_descriptors();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::api::MonitoredResourceDescriptor>
MetricServiceConnectionImpl::GetMonitoredResourceDescriptor(
    google::monitoring::v3::GetMonitoredResourceDescriptorRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetMonitoredResourceDescriptor(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::monitoring::v3::GetMonitoredResourceDescriptorRequest const&
              request) {
        return stub_->GetMonitoredResourceDescriptor(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::api::MetricDescriptor>
MetricServiceConnectionImpl::ListMetricDescriptors(
    google::monitoring::v3::ListMetricDescriptorsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListMetricDescriptors(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::api::MetricDescriptor>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<monitoring_v3::MetricServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::monitoring::v3::ListMetricDescriptorsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::monitoring::v3::ListMetricDescriptorsRequest const&
                       request) {
              return stub->ListMetricDescriptors(context, options, request);
            },
            options, r, function_name);
      },
      [](google::monitoring::v3::ListMetricDescriptorsResponse r) {
        std::vector<google::api::MetricDescriptor> result(
            r.metric_descriptors().size());
        auto& messages = *r.mutable_metric_descriptors();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::api::MetricDescriptor>
MetricServiceConnectionImpl::GetMetricDescriptor(
    google::monitoring::v3::GetMetricDescriptorRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetMetricDescriptor(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::monitoring::v3::GetMetricDescriptorRequest const& request) {
        return stub_->GetMetricDescriptor(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::api::MetricDescriptor>
MetricServiceConnectionImpl::CreateMetricDescriptor(
    google::monitoring::v3::CreateMetricDescriptorRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateMetricDescriptor(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::CreateMetricDescriptorRequest const&
                 request) {
        return stub_->CreateMetricDescriptor(context, options, request);
      },
      *current, request, __func__);
}

Status MetricServiceConnectionImpl::DeleteMetricDescriptor(
    google::monitoring::v3::DeleteMetricDescriptorRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteMetricDescriptor(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::DeleteMetricDescriptorRequest const&
                 request) {
        return stub_->DeleteMetricDescriptor(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::monitoring::v3::TimeSeries>
MetricServiceConnectionImpl::ListTimeSeries(
    google::monitoring::v3::ListTimeSeriesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListTimeSeries(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::TimeSeries>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<monitoring_v3::MetricServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::monitoring::v3::ListTimeSeriesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::monitoring::v3::ListTimeSeriesRequest const& request) {
              return stub->ListTimeSeries(context, options, request);
            },
            options, r, function_name);
      },
      [](google::monitoring::v3::ListTimeSeriesResponse r) {
        std::vector<google::monitoring::v3::TimeSeries> result(
            r.time_series().size());
        auto& messages = *r.mutable_time_series();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status MetricServiceConnectionImpl::CreateTimeSeries(
    google::monitoring::v3::CreateTimeSeriesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateTimeSeries(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::CreateTimeSeriesRequest const& request) {
        return stub_->CreateTimeSeries(context, options, request);
      },
      *current, request, __func__);
}

Status MetricServiceConnectionImpl::CreateServiceTimeSeries(
    google::monitoring::v3::CreateTimeSeriesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateServiceTimeSeries(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::CreateTimeSeriesRequest const& request) {
        return stub_->CreateServiceTimeSeries(context, options, request);
      },
      *current, request, __func__);
}

future<Status> MetricServiceConnectionImpl::AsyncCreateTimeSeries(
    google::monitoring::v3::CreateTimeSeriesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateTimeSeries(request_copy);
  auto retry = retry_policy(*current);
  auto backoff = backoff_policy(*current);
  return google::cloud::internal::AsyncRetryLoop(
      std::move(retry), std::move(backoff), idempotent, background_->cq(),
      [stub = stub_](
          CompletionQueue& cq, std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::monitoring::v3::CreateTimeSeriesRequest const& request) {
        return stub->AsyncCreateTimeSeries(cq, std::move(context),
                                           std::move(options), request);
      },
      std::move(current), std::move(request_copy), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
