/**
 *  Copyright Notice:
 *  Copyright 2021-2022 DMTF. All rights reserved.
 *  License: BSD 3-Clause License. For full text see link: https://github.com/DMTF/libspdm/blob/main/LICENSE.md
 **/

/*automatic generated by raw_data_key_gen.py*/

#ifndef RAW_DATA_KEY_H
#define RAW_DATA_KEY_H

#include "spdm_device_secret_lib_internal.h"

#if LIBSPDM_ECDSA_SUPPORT
#define LIBSPDM_EC256_RESPONDER_PRIVATE_KEY     { \
        0xad, 0x7c, 0x3a, 0x3a, 0xea, 0x46, 0xe0, 0xc1, 0x4d, 0x69, 0xb8, 0xd5, 0x6f, 0x86, 0x23, \
        0xcc, 0x37, 0xb5, 0x61, 0xb6, 0x8c, 0xa4, 0x48, 0x62, 0x32, 0xa3, 0x90, 0x0e, 0x77, 0x80, \
        0x3d, 0x8a,}
#define LIBSPDM_EC256_RESPONDER_PUBLIC_KEY     { \
        0x0d, 0xf4, 0x6e, 0x4d, 0x65, 0xfa, 0x52, 0xfe, 0xce, 0xb0, 0xbd, 0xa0, 0x59, 0x40, 0x49, \
        0xa0, 0x7b, 0x8d, 0x67, 0xfc, 0x61, 0x91, 0xae, 0x7e, 0x7a, 0xa5, 0x60, 0x93, 0x78, 0x97, \
        0xe2, 0xab, 0x42, 0x90, 0x28, 0xca, 0x3e, 0x72, 0x51, 0x1e, 0x6d, 0xd7, 0x1b, 0xeb, 0x1a, \
        0x13, 0x11, 0xa5, 0x1d, 0x36, 0x4f, 0x27, 0xdf, 0x80, 0x66, 0x96, 0x41, 0x73, 0xea, 0x51, \
        0xdd, 0x54, 0xf9, 0x95,}

#define LIBSPDM_EC384_RESPONDER_PRIVATE_KEY     { \
        0xbd, 0x85, 0x02, 0x54, 0x11, 0x46, 0xec, 0x9e, 0x53, 0xca, 0x2a, 0x0c, 0x74, 0x0a, 0xdc, \
        0xd8, 0x5d, 0xa0, 0x55, 0xbb, 0x81, 0x48, 0xf8, 0x2d, 0xfe, 0x9a, 0x32, 0x82, 0x6c, 0xe4, \
        0x68, 0xb9, 0x3c, 0x76, 0xd6, 0xc3, 0x4a, 0x65, 0x4c, 0x98, 0x60, 0x91, 0x9b, 0xbd, 0x91, \
        0x96, 0x97, 0x06,}
#define LIBSPDM_EC384_RESPONDER_PUBLIC_KEY     { \
        0x0d, 0x1c, 0xb9, 0x20, 0x1c, 0xdc, 0xed, 0xc8, 0x64, 0xe9, 0x70, 0xa3, 0x62, 0x12, 0xda, \
        0xd4, 0xfe, 0x59, 0x94, 0xce, 0xbd, 0xae, 0xd7, 0xd2, 0x94, 0xe4, 0xe3, 0x11, 0x88, 0x78, \
        0xb9, 0x88, 0xc0, 0xed, 0x5b, 0xe1, 0x41, 0x4a, 0xdf, 0x28, 0xdb, 0x49, 0x0f, 0x38, 0x81, \
        0x52, 0x68, 0xb5, 0x4c, 0x6a, 0x11, 0x0b, 0x58, 0xb1, 0x9c, 0xc1, 0x4d, 0x47, 0x41, 0x14, \
        0x1f, 0x6d, 0xd6, 0x57, 0xac, 0xa3, 0x9f, 0xd1, 0xb9, 0x64, 0xde, 0x07, 0x11, 0xe8, 0x31, \
        0x78, 0xde, 0x75, 0x3a, 0xb7, 0x2c, 0x15, 0x56, 0xea, 0xf5, 0x20, 0x63, 0x93, 0x0f, 0x33, \
        0xa9, 0x71, 0xa3, 0x7e, 0x78, 0x19,}

#define LIBSPDM_EC521_RESPONDER_PRIVATE_KEY     { \
        0x01, 0x2a, 0x61, 0x6e, 0x4a, 0x21, 0xf5, 0x2a, 0x65, 0x6e, 0x2a, 0x82, 0x38, 0x77, 0xd1, \
        0x5e, 0x09, 0x49, 0x84, 0x32, 0x3c, 0x3a, 0x55, 0xb1, 0xcd, 0x25, 0x47, 0xa3, 0x8a, 0xdb, \
        0x3a, 0x8a, 0x56, 0x7b, 0x69, 0x1d, 0xca, 0x15, 0xbe, 0x26, 0xc7, 0xad, 0x42, 0xab, 0xf5, \
        0x61, 0x1c, 0x05, 0xd9, 0x51, 0xa0, 0x14, 0x4f, 0xaf, 0xae, 0x25, 0xd6, 0x96, 0x7c, 0xb5, \
        0x53, 0x27, 0xb0, 0xf8, 0x23, 0x13,}
#define LIBSPDM_EC521_RESPONDER_PUBLIC_KEY     { \
        0x00, 0xab, 0xc8, 0xcc, 0x17, 0x86, 0x1c, 0x4a, 0x9e, 0xe4, 0xd9, 0x7a, 0x53, 0x62, 0xeb, \
        0xbf, 0xb8, 0x35, 0xfc, 0x15, 0x04, 0xa1, 0x5a, 0xa2, 0x36, 0x5c, 0x1c, 0xda, 0xcb, 0x1d, \
        0x92, 0x78, 0x17, 0x37, 0xa5, 0x16, 0xf5, 0x8e, 0x58, 0x69, 0x25, 0x27, 0x89, 0xd5, 0xb6, \
        0x12, 0x09, 0xc8, 0x43, 0x09, 0x44, 0x82, 0xb3, 0x40, 0x1a, 0x19, 0xa9, 0xc0, 0x35, 0xdf, \
        0x06, 0xc8, 0x68, 0xd6, 0x95, 0x0d, 0x01, 0xcb, 0xd3, 0x70, 0xfa, 0x8b, 0x5d, 0xe8, 0xcb, \
        0xb5, 0x0d, 0xab, 0xee, 0x2b, 0xd6, 0x93, 0x7d, 0xdf, 0x05, 0xa5, 0x47, 0xbf, 0xde, 0x6f, \
        0x3b, 0x92, 0x23, 0xaf, 0xed, 0x7a, 0x9d, 0x3a, 0x72, 0x2c, 0x2d, 0xdb, 0xba, 0x84, 0x66, \
        0x34, 0x99, 0xaa, 0x61, 0xf5, 0xfc, 0x16, 0x92, 0x65, 0x2a, 0xe5, 0x11, 0x42, 0xb8, 0x6b, \
        0x28, 0xf9, 0x9e, 0x89, 0xd0, 0x4a, 0xa6, 0x3c, 0x1c, 0x45, 0xb4, 0x7a,}

#define LIBSPDM_EC256_REQUESTER_PRIVATE_KEY     { \
        0x31, 0x51, 0x10, 0x95, 0xaf, 0xc3, 0xef, 0xf7, 0x74, 0xe0, 0xfa, 0x1a, 0x24, 0xf6, 0xda, \
        0x48, 0xf8, 0x6d, 0x86, 0x3e, 0xcb, 0x06, 0xef, 0xd3, 0xda, 0x32, 0x81, 0xa3, 0xed, 0xf5, \
        0x2e, 0x42,}
#define LIBSPDM_EC256_REQUESTER_PUBLIC_KEY     { \
        0xea, 0x85, 0xba, 0x33, 0x6f, 0x68, 0xd7, 0x6c, 0x8c, 0xd3, 0xcf, 0xf1, 0x3b, 0x0f, 0x3c, \
        0x55, 0x26, 0x70, 0x28, 0xc2, 0x8f, 0x1b, 0x90, 0x42, 0x7e, 0x2d, 0x31, 0x61, 0x28, 0x71, \
        0x40, 0x37, 0x12, 0x64, 0x43, 0x3c, 0xe8, 0xd5, 0xcd, 0xdf, 0xa3, 0x16, 0xec, 0x27, 0x33, \
        0x19, 0xdb, 0xf8, 0xd6, 0xb9, 0x96, 0x80, 0xfa, 0x10, 0xe4, 0x59, 0x8a, 0x6d, 0xa6, 0x32, \
        0xf4, 0xe8, 0xca, 0x17,}

#define LIBSPDM_EC384_REQUESTER_PRIVATE_KEY     { \
        0x8b, 0x52, 0x08, 0xf9, 0x3b, 0x09, 0x9f, 0x96, 0x6f, 0x33, 0xf3, 0x52, 0x99, 0xdb, 0x2a, \
        0x32, 0xf1, 0x42, 0x12, 0xc9, 0xf4, 0x72, 0x48, 0x77, 0xc3, 0x7f, 0x5c, 0x33, 0xed, 0x71, \
        0x66, 0xde, 0x49, 0xd3, 0xa1, 0xbf, 0xfb, 0xc8, 0x25, 0xd3, 0xde, 0x3d, 0x14, 0x4c, 0x18, \
        0xbe, 0xf1, 0x22,}
#define LIBSPDM_EC384_REQUESTER_PUBLIC_KEY     { \
        0x3d, 0xad, 0x90, 0xd6, 0xba, 0x44, 0xb0, 0x79, 0xe6, 0xdf, 0xc9, 0x28, 0x3b, 0x6e, 0xb0, \
        0xb6, 0xc0, 0x85, 0x81, 0xfc, 0x0a, 0xb3, 0xa6, 0x1a, 0x5a, 0x01, 0x49, 0x2e, 0x71, 0x19, \
        0xba, 0xfc, 0x57, 0x23, 0x0b, 0xd1, 0x5f, 0xa2, 0xd5, 0x55, 0x5d, 0xa1, 0x73, 0xd0, 0xf7, \
        0xbc, 0x4c, 0x59, 0xba, 0xf2, 0xaa, 0x86, 0xe6, 0xb0, 0x0f, 0xba, 0x31, 0x1a, 0x0b, 0x38, \
        0x97, 0x15, 0xe6, 0x29, 0x9b, 0x7b, 0x27, 0x1f, 0x88, 0xe9, 0x76, 0xa9, 0xa5, 0x45, 0x7f, \
        0xfb, 0x47, 0x1c, 0xc0, 0xe1, 0xde, 0x21, 0xa4, 0x9c, 0x58, 0x42, 0xf9, 0xcf, 0xae, 0xdf, \
        0x6c, 0x0d, 0x9d, 0xef, 0xcc, 0x87,}

#define LIBSPDM_EC521_REQUESTER_PRIVATE_KEY     { \
        0x00, 0x78, 0xd9, 0xfe, 0xfd, 0x98, 0x7a, 0x47, 0x5a, 0x00, 0x84, 0x69, 0xd6, 0x5b, 0x85, \
        0x67, 0x0d, 0xdc, 0x0b, 0x6a, 0x2a, 0x2d, 0x35, 0x01, 0x39, 0xff, 0x33, 0xd4, 0x83, 0x9d, \
        0x1d, 0x69, 0x29, 0xc1, 0x73, 0x84, 0xa1, 0xb7, 0x1e, 0x35, 0x15, 0x10, 0x69, 0xbb, 0xf8, \
        0xc5, 0xdd, 0xd9, 0x2f, 0xaf, 0xff, 0x6a, 0x04, 0x94, 0x6e, 0x69, 0xe9, 0x0c, 0x4c, 0x2c, \
        0x37, 0x52, 0x4a, 0xb6, 0x73, 0xf1,}
#define LIBSPDM_EC521_REQUESTER_PUBLIC_KEY     { \
        0x00, 0xf3, 0x27, 0x0a, 0x26, 0x57, 0x09, 0x3c, 0xa0, 0xe2, 0xfe, 0xd1, 0x1d, 0x85, 0x63, \
        0xd7, 0x3d, 0x45, 0xfa, 0xb6, 0x47, 0xf0, 0xf0, 0x0f, 0x83, 0xdf, 0x03, 0x65, 0xd0, 0x82, \
        0x30, 0x89, 0x69, 0xbe, 0x41, 0xcd, 0xbb, 0xa2, 0xf0, 0x78, 0xfd, 0x2f, 0xb7, 0x82, 0xab, \
        0x5c, 0x0f, 0xa2, 0x14, 0x34, 0x09, 0x79, 0x26, 0xfc, 0x96, 0x6d, 0x4a, 0xf6, 0x1d, 0xb1, \
        0x40, 0x40, 0xe1, 0x40, 0xc5, 0xdd, 0x00, 0x95, 0xa5, 0xc8, 0x65, 0x21, 0x55, 0xe8, 0xb9, \
        0xba, 0xa7, 0xa3, 0xf4, 0x1d, 0xee, 0x20, 0xcf, 0x2c, 0x81, 0xc1, 0xf0, 0xd0, 0x89, 0x2d, \
        0xcb, 0x38, 0x70, 0xc0, 0x22, 0x96, 0x60, 0x50, 0x24, 0x83, 0x75, 0x0f, 0x1a, 0x28, 0x55, \
        0x67, 0x4d, 0xa8, 0xc6, 0x55, 0xdf, 0xe4, 0x67, 0xda, 0xcf, 0xba, 0xfc, 0xca, 0x9c, 0xaa, \
        0xd2, 0xd9, 0x06, 0xe2, 0x27, 0x6e, 0x79, 0xcd, 0x7a, 0xc5, 0x32, 0x7d,}
#endif /*LIBSPDM_ECDSA_SUPPORT*/

#if (LIBSPDM_RSA_SSA_SUPPORT) || (LIBSPDM_RSA_PSS_SUPPORT)
#define LIBSPDM_RSA2048_RES_N     { \
        0x00, 0xbb, 0xd3, 0xd9, 0x10, 0x38, 0x39, 0x0a, 0x1f, 0xb3, 0x09, 0x06, 0xdf, 0x70, 0x0e, \
        0x8f, 0x5a, 0x53, 0x69, 0x93, 0x60, 0xb9, 0x65, 0xa9, 0xe1, 0xc1, 0x8c, 0x58, 0xd7, 0x28, \
        0xf9, 0xe7, 0x51, 0x75, 0xda, 0x63, 0x99, 0x3a, 0x70, 0x36, 0xb9, 0x80, 0x88, 0x81, 0xe5, \
        0xa8, 0xcc, 0x4a, 0x0c, 0x3c, 0x8e, 0xba, 0xed, 0x81, 0x59, 0x7c, 0x68, 0x9c, 0x5a, 0x60, \
        0x90, 0x3a, 0xe4, 0x0a, 0x8e, 0xbb, 0x32, 0x92, 0xd3, 0xbc, 0x19, 0x3e, 0x64, 0xee, 0x19, \
        0x11, 0x97, 0x6f, 0x55, 0x3a, 0xf0, 0x54, 0x2a, 0x37, 0xb3, 0xb8, 0x15, 0xb0, 0xc7, 0xcf, \
        0x20, 0x0f, 0x44, 0xc9, 0x74, 0xe1, 0xad, 0x89, 0x56, 0xc3, 0xbe, 0xc6, 0xf6, 0x4f, 0x6e, \
        0x7d, 0x09, 0xd7, 0xa1, 0xb3, 0xbd, 0xfd, 0xb7, 0x02, 0x47, 0x4a, 0x25, 0x73, 0xaf, 0x2a, \
        0x39, 0xa4, 0xce, 0x96, 0x09, 0x6c, 0xce, 0xb5, 0x49, 0x31, 0xe5, 0x9f, 0x91, 0x78, 0xa3, \
        0x6a, 0xe3, 0xd7, 0xc3, 0x12, 0xb6, 0x27, 0xe5, 0x55, 0xda, 0xc7, 0x3e, 0x5f, 0xd0, 0xe6, \
        0x1c, 0x73, 0x5e, 0xb1, 0x3c, 0x64, 0x54, 0x36, 0xfb, 0x53, 0xde, 0xdb, 0x5b, 0x2d, 0xaa, \
        0x05, 0x14, 0x60, 0x10, 0x6a, 0xdc, 0xe4, 0x85, 0x6c, 0x2c, 0x4b, 0x95, 0x05, 0xec, 0xd0, \
        0xe1, 0x4e, 0xaf, 0x6c, 0x40, 0xe6, 0x78, 0xe7, 0xc2, 0x88, 0x55, 0x30, 0xbb, 0x68, 0x4d, \
        0x8c, 0xa2, 0xd6, 0x0d, 0xbc, 0xa6, 0xbf, 0xfa, 0xdc, 0xc0, 0x6a, 0xbe, 0x4a, 0x2b, 0xb7, \
        0xfe, 0xff, 0xe6, 0xb6, 0x88, 0xff, 0x38, 0x3e, 0x13, 0x8f, 0x89, 0xc3, 0x1c, 0x25, 0x7b, \
        0xc5, 0x01, 0x5e, 0xc8, 0xf3, 0xbc, 0xe5, 0xa5, 0x57, 0x68, 0xb1, 0x8b, 0x29, 0x51, 0x42, \
        0x90, 0xe6, 0x41, 0xdf, 0x1c, 0x34, 0xcf, 0x38, 0xf8, 0x4f, 0xc3, 0xba, 0x89, 0x42, 0x3c, \
        0x6e, 0x31,}
#define LIBSPDM_RSA2048_RES_E     {0x01, 0x00, 0x01,}
#define LIBSPDM_RSA2048_RES_D     { \
        0x50, 0x23, 0x71, 0x47, 0xa4, 0x55, 0x61, 0xe6, 0x68, 0x82, 0xff, 0x75, 0xb1, 0xdf, 0xe4, \
        0x76, 0x0b, 0x84, 0xce, 0x26, 0xc4, 0xb3, 0x85, 0xaa, 0x16, 0xe4, 0x84, 0xbb, 0x38, 0x76, \
        0x77, 0xa5, 0x9f, 0xfd, 0x0f, 0xe5, 0xbe, 0xb3, 0x46, 0x06, 0x1b, 0xbb, 0x22, 0x81, 0x14, \
        0x66, 0x25, 0x69, 0xd7, 0x24, 0xa6, 0xc8, 0xd3, 0x19, 0x95, 0x25, 0x25, 0x20, 0xc2, 0x76, \
        0x87, 0x49, 0xe8, 0xdf, 0x41, 0x2b, 0xb0, 0xcd, 0xba, 0x41, 0xa3, 0x07, 0x79, 0x37, 0x24, \
        0xf4, 0x51, 0xc2, 0x31, 0xa5, 0x7c, 0xa3, 0x8e, 0xa4, 0x95, 0x74, 0x5b, 0xba, 0xc4, 0xba, \
        0xcf, 0x08, 0xf0, 0x53, 0x78, 0x3e, 0x8c, 0x8c, 0x82, 0x74, 0x11, 0x7b, 0xe2, 0x24, 0x28, \
        0x21, 0x5c, 0xe9, 0x57, 0x41, 0x46, 0xd1, 0x20, 0x9d, 0xbe, 0x1b, 0x00, 0xa2, 0xca, 0x07, \
        0x52, 0x33, 0xfa, 0x7c, 0x06, 0xfa, 0xa3, 0x09, 0xdd, 0x71, 0x72, 0xe2, 0x2e, 0x80, 0x9a, \
        0xc2, 0xd7, 0x38, 0x4f, 0x68, 0xdb, 0xa7, 0xb1, 0xc8, 0x80, 0x8e, 0xc4, 0xde, 0x33, 0xa1, \
        0x8d, 0xd4, 0xf8, 0xa0, 0xa7, 0x16, 0xb4, 0x1e, 0x90, 0x60, 0x03, 0x5b, 0x25, 0xc8, 0x56, \
        0x9f, 0x32, 0xe5, 0x38, 0xf5, 0xec, 0x86, 0x72, 0xf2, 0xe2, 0xcf, 0xa1, 0x5a, 0x64, 0xe9, \
        0xa3, 0xf7, 0xb0, 0x2d, 0x9a, 0x6c, 0x86, 0x12, 0x07, 0xa9, 0x34, 0x24, 0x1f, 0x48, 0x2b, \
        0xa3, 0xa1, 0xba, 0xcb, 0xfc, 0xb9, 0x2d, 0xbe, 0x83, 0x7b, 0xb4, 0x16, 0x01, 0x90, 0x98, \
        0xa2, 0x2e, 0xac, 0x8a, 0x84, 0x8d, 0x5a, 0x04, 0x0e, 0x1b, 0x6e, 0xe3, 0xbb, 0x61, 0x04, \
        0x08, 0xe5, 0xcb, 0xb0, 0x22, 0x54, 0x45, 0x10, 0x98, 0xdf, 0xbb, 0x8c, 0xf5, 0x40, 0x8c, \
        0xd4, 0x92, 0xd9, 0x8a, 0x67, 0x7f, 0x1c, 0x5f, 0xa3, 0x30, 0x99, 0x9f, 0x02, 0x97, 0x14, \
        0x29,}

#define LIBSPDM_RSA3072_RES_N     { \
        0x00, 0xa7, 0xb1, 0x22, 0x4c, 0x16, 0x7e, 0x79, 0xe8, 0xd5, 0xd7, 0xdd, 0x23, 0x46, 0x4e, \
        0x0a, 0xd6, 0x3c, 0xbd, 0xab, 0x6c, 0xe6, 0xcb, 0xaf, 0x62, 0xbe, 0x4c, 0xe5, 0x5f, 0xfd, \
        0x3e, 0x56, 0xdb, 0xf8, 0xa8, 0x93, 0x38, 0x0e, 0xf3, 0x59, 0x9e, 0x57, 0xe7, 0x91, 0x8e, \
        0x5a, 0x8b, 0xee, 0xb1, 0xbf, 0xbe, 0x3c, 0x71, 0xfd, 0x3c, 0x43, 0x8e, 0x98, 0xae, 0xa5, \
        0x48, 0xd1, 0x04, 0xb3, 0xc0, 0xdb, 0xaa, 0xe8, 0x23, 0x1d, 0xb4, 0xe5, 0x1e, 0x4f, 0xa2, \
        0x57, 0x33, 0xf6, 0xb4, 0x71, 0x17, 0xd1, 0xfb, 0x5c, 0x3b, 0x98, 0x64, 0x88, 0xfb, 0xb0, \
        0xa0, 0x48, 0xb9, 0xee, 0xbf, 0x18, 0x96, 0x4f, 0xf0, 0x86, 0x35, 0xcd, 0x09, 0xab, 0x4e, \
        0xe7, 0x9f, 0xc2, 0xac, 0xac, 0xed, 0xf0, 0xce, 0x5f, 0x9c, 0x03, 0xf7, 0xa2, 0xdf, 0x0c, \
        0xf7, 0xb4, 0x27, 0x02, 0xc3, 0xb1, 0x5a, 0xcb, 0x06, 0xb9, 0xfe, 0xbb, 0xdb, 0xba, 0x12, \
        0xc0, 0x08, 0xef, 0x61, 0x0a, 0x74, 0x98, 0xa5, 0xcf, 0xa5, 0xeb, 0x80, 0xc8, 0x34, 0x66, \
        0xd8, 0x75, 0xbf, 0x74, 0xb5, 0x0c, 0x49, 0xa1, 0xd8, 0xba, 0xc5, 0xbd, 0x4a, 0x76, 0x14, \
        0x33, 0x5a, 0x58, 0x80, 0x16, 0xcd, 0x1b, 0xd7, 0xa9, 0xc8, 0xf0, 0x39, 0x00, 0x0f, 0x80, \
        0xa9, 0x1c, 0xb1, 0xb9, 0x65, 0xbd, 0xa2, 0xab, 0x54, 0x88, 0x96, 0x76, 0x85, 0xa0, 0xa0, \
        0x74, 0xf7, 0x9a, 0xfc, 0x6d, 0xd8, 0xf5, 0x4b, 0xbc, 0x73, 0xb6, 0xa3, 0x3f, 0xc0, 0x0f, \
        0x7c, 0x51, 0x72, 0x72, 0xa7, 0x8e, 0xa5, 0xd7, 0x3d, 0x9a, 0x63, 0x31, 0xaa, 0xbf, 0xda, \
        0x04, 0x70, 0x7c, 0x4c, 0x08, 0xc2, 0xb4, 0xcb, 0x45, 0x2b, 0xf5, 0xb8, 0x8b, 0xa7, 0xf4, \
        0x50, 0x17, 0x9d, 0x18, 0xd3, 0x5f, 0x81, 0xb3, 0x05, 0x11, 0xa1, 0x31, 0xc4, 0x4e, 0x25, \
        0xfb, 0x5d, 0x41, 0x0a, 0x58, 0xbb, 0x2f, 0xf5, 0xc0, 0xa2, 0x35, 0x56, 0x2a, 0x9d, 0xfe, \
        0x29, 0xa1, 0xee, 0xeb, 0x1c, 0x5f, 0x11, 0xe2, 0x76, 0xa3, 0x65, 0xfc, 0xec, 0x48, 0x4b, \
        0x00, 0x78, 0x5a, 0x2c, 0x7a, 0x85, 0x62, 0x52, 0x05, 0xc3, 0xc8, 0xd0, 0x62, 0x1f, 0xae, \
        0x87, 0x99, 0xef, 0x7f, 0xb7, 0xbb, 0x58, 0xd8, 0x13, 0x55, 0x98, 0xf9, 0xbd, 0x1b, 0x80, \
        0xb9, 0xb5, 0x28, 0x8f, 0x05, 0xfd, 0xe6, 0xd5, 0x9f, 0x44, 0x53, 0xa6, 0x31, 0x3f, 0x87, \
        0x65, 0x53, 0x67, 0xdd, 0xd4, 0x84, 0xc8, 0xd2, 0xad, 0xac, 0x37, 0xed, 0x85, 0xea, 0xce, \
        0xe2, 0x7e, 0xbf, 0x1a, 0x81, 0xc7, 0xd4, 0xed, 0xd8, 0x27, 0x2b, 0x0a, 0x56, 0xa0, 0xd7, \
        0xf5, 0xd4, 0x26, 0xc2, 0xeb, 0xb0, 0x4b, 0x0f, 0x06, 0x1b, 0x4c, 0x35, 0xec, 0x29, 0x5c, \
        0x00, 0xff, 0xd4, 0x9d, 0xd9, 0x90, 0xb6, 0xd1, 0xd6, 0xb3,}
#define LIBSPDM_RSA3072_RES_E     {0x01, 0x00, 0x01,}
#define LIBSPDM_RSA3072_RES_D     { \
        0x00, 0x8f, 0xbf, 0x4d, 0x2a, 0x32, 0x42, 0x1a, 0xd8, 0xd7, 0xae, 0xe2, 0x76, 0xa1, 0x86, \
        0xb6, 0xcd, 0x6d, 0x66, 0x1d, 0x74, 0x0d, 0xe7, 0xde, 0xa1, 0x63, 0x85, 0xe1, 0x3e, 0x46, \
        0x84, 0xd0, 0xca, 0x61, 0xbe, 0x87, 0xec, 0x8f, 0x0c, 0x55, 0xef, 0x61, 0x65, 0x35, 0x25, \
        0xf5, 0x42, 0x6c, 0xcb, 0xdc, 0x15, 0x04, 0x15, 0xa6, 0xc1, 0xa9, 0x1b, 0xac, 0x90, 0x51, \
        0x49, 0x39, 0x3b, 0xb1, 0xa7, 0x09, 0xe6, 0xd8, 0x75, 0x79, 0xba, 0x9e, 0x89, 0x3c, 0x34, \
        0x6a, 0x52, 0x36, 0x11, 0xf9, 0xbc, 0x34, 0x99, 0x27, 0x38, 0x42, 0xeb, 0x33, 0x6d, 0xa5, \
        0xbb, 0xd0, 0x7b, 0xea, 0x47, 0xcf, 0x98, 0xd2, 0x4f, 0xd9, 0x8c, 0x77, 0x05, 0xe9, 0xde, \
        0x8a, 0xb9, 0x2d, 0x94, 0xfd, 0xec, 0x3d, 0xf7, 0x7a, 0x87, 0xef, 0xf2, 0xb0, 0xa0, 0x49, \
        0xaa, 0x70, 0xb8, 0xdc, 0x2a, 0xca, 0x76, 0x8d, 0x01, 0x68, 0x21, 0x10, 0x02, 0x4b, 0xe0, \
        0x54, 0xd3, 0x93, 0xf7, 0xf8, 0x91, 0x78, 0x64, 0xf2, 0xba, 0x45, 0x45, 0xb0, 0xd9, 0x12, \
        0xac, 0x4d, 0x4b, 0x60, 0x8c, 0xee, 0x4a, 0x94, 0x3d, 0x87, 0xe5, 0x87, 0xdd, 0x33, 0x99, \
        0x1f, 0x68, 0x3b, 0xe3, 0x19, 0x28, 0x9b, 0xcc, 0x64, 0x53, 0xc6, 0x70, 0xe6, 0x37, 0x63, \
        0xd0, 0x13, 0xb3, 0xd9, 0xbc, 0x78, 0x31, 0xe0, 0x72, 0x67, 0x5f, 0xab, 0x9a, 0x7f, 0x99, \
        0x17, 0x5a, 0x0c, 0x64, 0x5b, 0x9d, 0x35, 0x9a, 0x0c, 0xed, 0xeb, 0x31, 0xcc, 0xb4, 0x66, \
        0xf2, 0x63, 0x52, 0xd4, 0x55, 0x9a, 0x8d, 0x66, 0x21, 0xfc, 0x84, 0x7c, 0x89, 0x98, 0x4a, \
        0x0e, 0x58, 0x3b, 0x0d, 0x81, 0x76, 0xa5, 0x4a, 0xe8, 0x0d, 0x62, 0x92, 0x81, 0xd6, 0x63, \
        0x70, 0xf6, 0xc2, 0x84, 0x11, 0xce, 0x87, 0x8b, 0xed, 0x99, 0x16, 0x9b, 0x35, 0xa1, 0x59, \
        0x7f, 0x09, 0x46, 0x8d, 0xfa, 0xe2, 0x45, 0xae, 0xc2, 0xf5, 0x7c, 0x84, 0x1a, 0xd8, 0x6a, \
        0x11, 0xb5, 0xb2, 0xe9, 0x14, 0x83, 0x77, 0xd8, 0xd0, 0x5c, 0xb0, 0x02, 0xfd, 0x90, 0x89, \
        0xde, 0x2e, 0xe3, 0x05, 0xfe, 0x9f, 0xbd, 0x7c, 0x1b, 0x87, 0xbf, 0x2c, 0x6c, 0x4f, 0x32, \
        0xd1, 0x43, 0x97, 0x0a, 0x08, 0xc5, 0xd4, 0xc1, 0x2e, 0x24, 0xa3, 0xcd, 0x22, 0x16, 0x51, \
        0x52, 0xa2, 0x5c, 0x7d, 0x1b, 0xbe, 0x86, 0xcf, 0xbe, 0x96, 0x2f, 0xdc, 0x99, 0xb4, 0x39, \
        0x7d, 0xff, 0xec, 0xf7, 0x13, 0xf4, 0x08, 0x3a, 0x1d, 0x2c, 0xf3, 0xb9, 0x6d, 0xde, 0x53, \
        0xfd, 0x84, 0x8d, 0x82, 0xb9, 0x5c, 0x8e, 0x7f, 0x2d, 0x17, 0x34, 0x26, 0x18, 0x99, 0x9b, \
        0x28, 0xb6, 0x02, 0x06, 0xf6, 0x19, 0x60, 0xec, 0x65, 0x47, 0xb6, 0x3e, 0x02, 0x6d, 0xe6, \
        0xbb, 0x70, 0x20, 0x89, 0xcc, 0x76, 0x92, 0x36, 0xbe, 0xa1,}

#define LIBSPDM_RSA4096_RES_N     { \
        0x00, 0xcf, 0x55, 0x79, 0x8e, 0x15, 0xd3, 0xfa, 0x5b, 0xf8, 0xef, 0xb5, 0xc7, 0x47, 0x0b, \
        0x66, 0x8b, 0x8e, 0xa9, 0xbe, 0xd7, 0x15, 0x3c, 0x2e, 0x22, 0xb0, 0xca, 0xe9, 0xf3, 0x8c, \
        0xf5, 0x54, 0x4a, 0x0d, 0xd1, 0xb2, 0xd9, 0xa0, 0xbc, 0x51, 0x4e, 0x26, 0xdc, 0xa9, 0x77, \
        0x2f, 0x0d, 0x7a, 0x48, 0x90, 0x8d, 0xf5, 0x39, 0x9e, 0xfb, 0x70, 0x08, 0xda, 0x46, 0xe3, \
        0x62, 0xf4, 0x5b, 0x60, 0x90, 0x23, 0x1a, 0xc6, 0xd1, 0x75, 0x72, 0x38, 0x1c, 0x7d, 0x90, \
        0x83, 0x08, 0x21, 0x3a, 0xe6, 0xcf, 0x53, 0x88, 0x04, 0x3f, 0x54, 0xfd, 0x80, 0x51, 0xb2, \
        0xa8, 0x7f, 0xde, 0x7b, 0x04, 0x63, 0x72, 0xb1, 0xaa, 0x46, 0x22, 0xb9, 0x26, 0x3a, 0x15, \
        0x3e, 0x28, 0xd7, 0xe8, 0x62, 0xdd, 0x23, 0x9c, 0x70, 0xd0, 0xaf, 0x43, 0x32, 0x14, 0xde, \
        0xa9, 0x4f, 0xc2, 0x42, 0xec, 0x75, 0x2b, 0x81, 0xa9, 0x01, 0xd0, 0xfc, 0xcc, 0x94, 0x0c, \
        0x2b, 0x29, 0x3a, 0xa4, 0xe7, 0xe8, 0xc5, 0xc2, 0xdd, 0x77, 0xe3, 0x29, 0xd7, 0x06, 0xf5, \
        0xf6, 0x03, 0x56, 0xfe, 0xb5, 0xd8, 0xeb, 0xeb, 0x33, 0xf0, 0x6b, 0xbc, 0x60, 0xa4, 0x73, \
        0x7e, 0x99, 0x1b, 0x0c, 0x41, 0xf7, 0xca, 0x06, 0xfe, 0xc7, 0x64, 0xf3, 0x32, 0x97, 0x51, \
        0x5a, 0x54, 0xbe, 0xd4, 0xcd, 0xc2, 0x49, 0xc2, 0x2e, 0x72, 0x11, 0x53, 0x22, 0x8b, 0x5b, \
        0xe2, 0x4b, 0x54, 0xd1, 0x71, 0x93, 0xd3, 0x37, 0xc4, 0xc8, 0xe2, 0x21, 0xbc, 0x87, 0x4e, \
        0x59, 0x57, 0xbd, 0xd0, 0x0b, 0xd0, 0xc1, 0x82, 0xda, 0xdc, 0xbf, 0x92, 0x2d, 0xd8, 0x42, \
        0x29, 0x9d, 0xe7, 0xc2, 0x49, 0xbc, 0xdf, 0x99, 0x64, 0x2f, 0x92, 0x09, 0x5d, 0xb0, 0x84, \
        0x89, 0x34, 0x14, 0x0c, 0xde, 0x08, 0xc8, 0x37, 0xca, 0x67, 0xce, 0x71, 0xa1, 0xc9, 0xb4, \
        0x66, 0xd5, 0xb4, 0xa0, 0xb2, 0x84, 0x54, 0xeb, 0xf4, 0x62, 0x15, 0xd5, 0xc1, 0x86, 0xbd, \
        0x6e, 0x6e, 0x43, 0xcf, 0x63, 0xcd, 0x06, 0xc6, 0x81, 0xc5, 0x74, 0x1f, 0x54, 0xc7, 0xd5, \
        0x92, 0x70, 0x61, 0xb1, 0x54, 0xa7, 0x44, 0xb4, 0x5f, 0x76, 0xfa, 0x26, 0xdf, 0xdd, 0xa5, \
        0x04, 0x30, 0x16, 0x74, 0xf6, 0x80, 0x22, 0xaf, 0x30, 0x0b, 0x0a, 0x52, 0x33, 0x46, 0xcb, \
        0x63, 0xc2, 0x85, 0x78, 0x19, 0x3c, 0x0b, 0xd0, 0x5b, 0x03, 0xfc, 0xaa, 0x59, 0x00, 0xb1, \
        0x9e, 0x52, 0x68, 0x88, 0x56, 0x35, 0x1d, 0xff, 0x4a, 0x68, 0x81, 0xc2, 0x10, 0x3e, 0x88, \
        0xf9, 0x50, 0x91, 0xff, 0x85, 0x86, 0xbb, 0x23, 0x1a, 0x5a, 0xae, 0x75, 0xe5, 0xaa, 0x3a, \
        0xf4, 0x38, 0xdb, 0x24, 0x04, 0xd1, 0x6e, 0x22, 0x11, 0xe9, 0xb8, 0x7f, 0x02, 0x90, 0x09, \
        0xcd, 0x95, 0x2d, 0x9e, 0x48, 0xef, 0x6c, 0xcf, 0xd5, 0x13, 0x3f, 0x7a, 0xe6, 0x8b, 0x99, \
        0x2b, 0x88, 0xfb, 0xf4, 0x1c, 0x80, 0x9f, 0xe9, 0x2f, 0x28, 0xfc, 0x68, 0xa2, 0x66, 0x1a, \
        0x6d, 0xbe, 0x9c, 0x47, 0x28, 0xcf, 0x08, 0x47, 0xe2, 0x10, 0x1c, 0x1c, 0xff, 0x31, 0x7c, \
        0x49, 0x55, 0x4d, 0xf2, 0x4e, 0x10, 0xa2, 0x6e, 0x9b, 0xd7, 0x02, 0x21, 0x29, 0xba, 0x8c, \
        0xce, 0xf7, 0xf6, 0x2c, 0x5c, 0x26, 0x54, 0x4b, 0x03, 0x52, 0xd3, 0xaa, 0x2e, 0x80, 0x7d, \
        0x33, 0x68, 0xea, 0x5f, 0x4e, 0x6a, 0xb6, 0xf4, 0x65, 0x18, 0x84, 0x4c, 0xbe, 0x0a, 0x98, \
        0x24, 0x4b, 0x37, 0x19, 0xcd, 0xfe, 0x4c, 0x34, 0x6a, 0xa9, 0x00, 0xda, 0x32, 0x77, 0x16, \
        0xe1, 0xb5, 0x13, 0x7e, 0x8a, 0x67, 0x90, 0x62, 0xc9, 0x14, 0x57, 0x99, 0x88, 0xd8, 0xbe, \
        0x60, 0x92, 0xb2, 0x6e, 0x46, 0xf5, 0x66, 0xd1, 0xa3, 0x34, 0x30, 0x03, 0x65, 0x76, 0xa5, \
        0xd4, 0xb5, 0xcf,}
#define LIBSPDM_RSA4096_RES_E     {0x01, 0x00, 0x01,}
#define LIBSPDM_RSA4096_RES_D     { \
        0x18, 0x5c, 0xed, 0xe4, 0xb1, 0x51, 0xf0, 0x68, 0x60, 0x4f, 0x22, 0xa8, 0x21, 0x04, 0x08, \
        0xef, 0xbb, 0x3a, 0xdd, 0x0e, 0xff, 0x12, 0xcc, 0x45, 0x0d, 0x4b, 0x3a, 0xc4, 0x80, 0xba, \
        0xcf, 0x45, 0xc8, 0x6b, 0xec, 0xbd, 0x3f, 0xf3, 0x01, 0x06, 0xd2, 0xf0, 0x39, 0x05, 0xa5, \
        0x44, 0xcb, 0x2a, 0xbd, 0xb9, 0xc0, 0xa8, 0x1d, 0xb3, 0x64, 0x0d, 0xd6, 0x40, 0x60, 0x35, \
        0xdf, 0x8a, 0xe1, 0x44, 0xee, 0xab, 0x15, 0xd3, 0xc5, 0x1e, 0x3f, 0xd3, 0xb1, 0x39, 0x8a, \
        0xfc, 0x28, 0x93, 0x78, 0x4d, 0xc2, 0x7e, 0x08, 0x29, 0xbc, 0xfd, 0xf0, 0xd7, 0x28, 0xcc, \
        0x3e, 0x02, 0x51, 0xa8, 0x49, 0x5b, 0x4f, 0xdf, 0x37, 0x50, 0x9b, 0x3b, 0x0f, 0xb6, 0x31, \
        0x50, 0xb1, 0x56, 0x40, 0x4f, 0xc6, 0x00, 0x7b, 0x0d, 0x3a, 0x9b, 0x05, 0xc6, 0x88, 0x07, \
        0x93, 0x34, 0xbb, 0x92, 0x77, 0x8e, 0x3e, 0x35, 0x32, 0xde, 0x70, 0xe6, 0x45, 0x3b, 0x4c, \
        0xd3, 0x12, 0x6e, 0x10, 0x46, 0x3c, 0xfe, 0xd1, 0xf1, 0x65, 0x83, 0x24, 0x1e, 0x50, 0x46, \
        0xb1, 0x4b, 0xc6, 0xb0, 0x6d, 0xa6, 0x03, 0x44, 0x5e, 0x2a, 0xfa, 0xbe, 0xcc, 0x74, 0x39, \
        0xdb, 0x19, 0xdf, 0x8d, 0xdc, 0xe5, 0x23, 0x7f, 0x4a, 0xc4, 0xe5, 0x02, 0xfb, 0xde, 0xf6, \
        0x63, 0x60, 0xed, 0x36, 0xa4, 0x6e, 0xf0, 0x5f, 0x6e, 0xcd, 0xf4, 0x5b, 0xe9, 0xce, 0x49, \
        0x40, 0x1a, 0xde, 0x65, 0x9f, 0x3e, 0x41, 0x9e, 0x61, 0x10, 0x99, 0x70, 0x42, 0xe2, 0x05, \
        0x03, 0x97, 0x6d, 0x5c, 0x06, 0x12, 0xc7, 0x22, 0x9a, 0xaf, 0xf4, 0x28, 0x68, 0xf2, 0x15, \
        0x5b, 0xd5, 0xc0, 0xf1, 0xd3, 0x3c, 0xdf, 0x14, 0x73, 0xb6, 0x90, 0x5d, 0x2f, 0x01, 0xd3, \
        0xf1, 0x87, 0xad, 0x9f, 0x65, 0x9e, 0xc9, 0x57, 0x82, 0x6d, 0x32, 0xd3, 0x15, 0x15, 0x9a, \
        0xc3, 0xa9, 0xab, 0x15, 0xa6, 0x7a, 0xf8, 0x16, 0xcd, 0xd1, 0xf9, 0xaa, 0x20, 0x82, 0xb3, \
        0x75, 0xd7, 0xed, 0x01, 0xe3, 0xd7, 0x29, 0x39, 0x12, 0xe5, 0x76, 0x6f, 0xb6, 0x5d, 0x17, \
        0x6b, 0x00, 0x14, 0xa5, 0x59, 0xfa, 0xba, 0x47, 0x79, 0xe2, 0x9d, 0x3c, 0x12, 0xa0, 0xf5, \
        0x14, 0x3f, 0xaf, 0x3c, 0x1a, 0xc2, 0x24, 0xea, 0x3c, 0x50, 0x3a, 0x8e, 0x06, 0x8b, 0x09, \
        0x7d, 0x3f, 0x36, 0x20, 0xad, 0xf6, 0xee, 0x03, 0xb7, 0x38, 0xa9, 0x63, 0xf6, 0x36, 0xcb, \
        0x85, 0x95, 0x17, 0x37, 0xed, 0x17, 0x92, 0x2f, 0x23, 0x73, 0x62, 0x79, 0xdb, 0x5d, 0x29, \
        0x51, 0x4a, 0xdf, 0x85, 0xee, 0xd5, 0x41, 0x92, 0x8d, 0xed, 0x5c, 0xa7, 0x12, 0x39, 0x21, \
        0x50, 0xe7, 0x79, 0xbf, 0x53, 0x84, 0xcc, 0x9c, 0x02, 0x5c, 0x4c, 0x72, 0x29, 0xc9, 0x1b, \
        0x49, 0x95, 0xd8, 0xda, 0xea, 0x29, 0x1c, 0x2e, 0xd4, 0x48, 0xe8, 0x16, 0x31, 0x39, 0xa2, \
        0x24, 0xc4, 0xbf, 0x0d, 0x20, 0x66, 0x29, 0x23, 0xb1, 0xc0, 0x0a, 0x72, 0xa8, 0xc7, 0x88, \
        0xfa, 0x50, 0x9e, 0x34, 0xad, 0xaa, 0xda, 0x09, 0x6c, 0x04, 0x4c, 0xe8, 0x82, 0x4f, 0xef, \
        0xdb, 0x72, 0xee, 0x34, 0xe6, 0x78, 0xbb, 0x96, 0x80, 0x43, 0x92, 0x3f, 0x94, 0xbd, 0xb7, \
        0x20, 0x7c, 0xa2, 0xc5, 0xa6, 0xc5, 0x15, 0x9a, 0x16, 0x6c, 0x0a, 0x2f, 0xe3, 0x8b, 0x87, \
        0x72, 0xc4, 0xed, 0xb8, 0xbb, 0x28, 0x63, 0x08, 0x07, 0x0b, 0x98, 0x28, 0xd4, 0xeb, 0x75, \
        0x1d, 0x73, 0xa7, 0xad, 0x1f, 0x9c, 0xba, 0x80, 0x83, 0x34, 0x58, 0xb6, 0x0a, 0xe7, 0xe6, \
        0x2c, 0x91, 0x3f, 0x09, 0x6d, 0x4d, 0x11, 0x63, 0x5a, 0x5f, 0x49, 0x81, 0xf0, 0x3a, 0xeb, \
        0x60, 0x79, 0x7d, 0x2b, 0x86, 0x85, 0x45, 0x06, 0x00, 0x59, 0xfa, 0x60, 0xec, 0xcd, 0xcb, \
        0x87, 0xc1,}

#define LIBSPDM_RSA2048_REQ_N     { \
        0x00, 0xb2, 0x89, 0x92, 0x2b, 0x0d, 0x3a, 0x76, 0x93, 0xcf, 0x6b, 0xab, 0x28, 0x8e, 0x80, \
        0xfd, 0xe3, 0xc4, 0xa0, 0xf0, 0xdb, 0xa5, 0xef, 0xab, 0x7c, 0xa9, 0x2a, 0x1a, 0xdc, 0x51, \
        0x81, 0xc7, 0x1a, 0x02, 0x10, 0xc8, 0xf0, 0x19, 0x07, 0x34, 0x24, 0x3c, 0xfa, 0x65, 0xa3, \
        0x72, 0xd0, 0x18, 0x21, 0x0f, 0xe5, 0x9f, 0x23, 0xcb, 0x62, 0xa3, 0x51, 0x89, 0xcb, 0x40, \
        0x54, 0xc6, 0xed, 0xcf, 0x0c, 0x13, 0x21, 0x19, 0x05, 0x2e, 0xfb, 0x17, 0x86, 0x09, 0x8e, \
        0xdd, 0x35, 0x90, 0x1c, 0x5b, 0x7b, 0x46, 0xfb, 0xe6, 0xb0, 0x35, 0xba, 0x94, 0x22, 0x77, \
        0x6a, 0x99, 0x37, 0x50, 0xba, 0xa7, 0xeb, 0x67, 0xb2, 0x97, 0x42, 0x7b, 0xe8, 0x04, 0x3c, \
        0x45, 0xad, 0x16, 0x7e, 0x67, 0x61, 0xe2, 0x7b, 0xd2, 0xda, 0xef, 0xb1, 0xd5, 0x52, 0x00, \
        0x14, 0xd9, 0x19, 0x31, 0x77, 0xf6, 0xdc, 0x0e, 0xb6, 0x18, 0x07, 0x97, 0x35, 0xed, 0xc0, \
        0xd2, 0x31, 0xd9, 0xf1, 0x1c, 0xb8, 0xd9, 0xbc, 0x04, 0xda, 0x64, 0x82, 0xaa, 0xdf, 0x63, \
        0x24, 0xb7, 0x91, 0x7d, 0xa6, 0xde, 0x6d, 0xfa, 0xbf, 0xee, 0x85, 0x5d, 0x21, 0x35, 0x34, \
        0xb8, 0x10, 0x7b, 0x91, 0x7d, 0xbd, 0x59, 0xe7, 0x1f, 0x08, 0xc6, 0x22, 0xc1, 0x94, 0x7c, \
        0x81, 0x70, 0xa0, 0x70, 0xd1, 0x9c, 0xab, 0x03, 0xe2, 0x05, 0xbe, 0x31, 0x2f, 0x66, 0x65, \
        0x94, 0x85, 0xf5, 0x57, 0xff, 0xd6, 0x37, 0x3b, 0x14, 0xdf, 0x6e, 0xda, 0x09, 0x7a, 0x81, \
        0xc0, 0xed, 0xbc, 0x8c, 0x99, 0x77, 0xef, 0x29, 0x5f, 0xfc, 0x87, 0x43, 0xba, 0x4d, 0x2e, \
        0x9c, 0xf2, 0x5a, 0x50, 0xe0, 0xc8, 0xb4, 0x18, 0xd6, 0x8c, 0x06, 0xec, 0xd5, 0xec, 0x9b, \
        0x64, 0xf2, 0x04, 0xd7, 0x94, 0x22, 0xdb, 0x2b, 0x71, 0xd8, 0xd2, 0x0d, 0x9f, 0x46, 0x45, \
        0xac, 0x27,}
#define LIBSPDM_RSA2048_REQ_E     {0x01, 0x00, 0x01,}
#define LIBSPDM_RSA2048_REQ_D     { \
        0x22, 0xb1, 0x66, 0xec, 0xe4, 0xba, 0x2a, 0x96, 0x98, 0x64, 0xc4, 0xb2, 0xb1, 0xd6, 0x50, \
        0xff, 0xb4, 0x92, 0xcd, 0x9a, 0xf1, 0x08, 0xbc, 0x9b, 0x11, 0xc8, 0x33, 0xc6, 0x02, 0x34, \
        0xa4, 0xba, 0xe2, 0x11, 0xde, 0xea, 0x01, 0x03, 0x0c, 0x57, 0xca, 0x5d, 0xa1, 0xe8, 0x7c, \
        0x04, 0x01, 0xdc, 0x52, 0xd9, 0x7c, 0xee, 0x18, 0xb4, 0x87, 0x25, 0xee, 0x0f, 0xc7, 0xe5, \
        0x71, 0x6e, 0x7e, 0xa0, 0x4b, 0x0b, 0x50, 0x70, 0x58, 0x6b, 0xc4, 0x6b, 0x70, 0x6a, 0x09, \
        0x84, 0x42, 0x07, 0xb0, 0xa3, 0x28, 0xed, 0x04, 0x2b, 0xd3, 0x94, 0xf8, 0xfa, 0x25, 0x98, \
        0x5a, 0x43, 0x8c, 0x75, 0x68, 0xf1, 0xee, 0x89, 0x9e, 0xa8, 0xf5, 0xa8, 0xe5, 0x41, 0xcd, \
        0x0c, 0x50, 0x65, 0xa9, 0xb3, 0x34, 0xae, 0x79, 0x0f, 0xc0, 0x2a, 0x1f, 0x58, 0xba, 0xd9, \
        0x52, 0x42, 0x7a, 0x01, 0x64, 0xbf, 0xe8, 0x3f, 0x99, 0x1f, 0x7c, 0x38, 0x46, 0x3d, 0x9e, \
        0x1f, 0xa9, 0x45, 0xb7, 0x54, 0xdd, 0xe5, 0x95, 0xb5, 0xd1, 0x56, 0xf7, 0xea, 0x0d, 0x15, \
        0x37, 0x09, 0xe2, 0xf9, 0x58, 0x99, 0x22, 0xa2, 0x7e, 0x1b, 0xda, 0x0a, 0xa4, 0xbb, 0xe1, \
        0xdf, 0x3b, 0x88, 0xd8, 0xd6, 0x44, 0xf6, 0x56, 0x89, 0xff, 0xe5, 0xd4, 0x3a, 0x12, 0x53, \
        0x3c, 0xff, 0x38, 0xed, 0x03, 0x08, 0x8f, 0x13, 0xb9, 0x0a, 0x5a, 0xb0, 0xde, 0xdf, 0xc1, \
        0x13, 0xa0, 0x06, 0xa8, 0x5a, 0x3f, 0xd7, 0xec, 0xe0, 0x14, 0x38, 0xf1, 0x66, 0x84, 0xfd, \
        0xd0, 0xd2, 0x7f, 0x80, 0x63, 0xca, 0x1e, 0xb6, 0x88, 0xa2, 0xe9, 0x3f, 0xcb, 0xdb, 0x4d, \
        0x10, 0x82, 0xd2, 0xf3, 0x17, 0xb9, 0xf0, 0x30, 0xa4, 0x9f, 0x42, 0xe2, 0xda, 0x59, 0xd0, \
        0xd8, 0x6d, 0xb1, 0xf5, 0xe4, 0x3f, 0xdd, 0x4a, 0x1f, 0x83, 0x56, 0xa8, 0x0a, 0x6c, 0x15, \
        0x81,}

#define LIBSPDM_RSA3072_REQ_N     { \
        0x00, 0xb0, 0x46, 0x67, 0x82, 0x63, 0xb9, 0x22, 0x69, 0x01, 0x9b, 0xe7, 0xf9, 0x52, 0xf7, \
        0x09, 0x1b, 0x72, 0x15, 0x0c, 0x67, 0x3e, 0xe4, 0x6e, 0x41, 0x09, 0xed, 0x01, 0x42, 0xf1, \
        0xd8, 0x3c, 0x0d, 0xa0, 0x0c, 0x35, 0xfb, 0x5c, 0x36, 0x00, 0x21, 0x58, 0x4a, 0x1b, 0x4e, \
        0x85, 0xaf, 0xe7, 0x84, 0xc9, 0x8f, 0xb8, 0xe0, 0xb1, 0xa4, 0x3d, 0x78, 0x54, 0x4d, 0xf3, \
        0x92, 0x8d, 0xe6, 0xb5, 0x97, 0x98, 0x68, 0xd6, 0x4e, 0xde, 0xf3, 0x2d, 0x89, 0xb6, 0x57, \
        0x9d, 0xb0, 0x83, 0x95, 0x3c, 0x7a, 0x71, 0x7f, 0xf9, 0x0e, 0x57, 0x77, 0xcc, 0x69, 0xa8, \
        0x01, 0xab, 0x2e, 0x7b, 0x30, 0x50, 0x3b, 0xd1, 0xee, 0xc8, 0x3d, 0xfe, 0xa6, 0x74, 0xe4, \
        0xf7, 0x7f, 0xf2, 0xfc, 0xd1, 0xe6, 0x4a, 0xb4, 0x7b, 0x45, 0x0b, 0x59, 0xcb, 0x53, 0x60, \
        0x48, 0x91, 0x59, 0xd9, 0x1b, 0xcc, 0x61, 0x5c, 0x5b, 0xe2, 0xb2, 0xa5, 0xca, 0xce, 0x93, \
        0x96, 0xde, 0xc9, 0xdb, 0xf8, 0x3a, 0x94, 0x1c, 0x3e, 0xe4, 0x44, 0x44, 0xad, 0x04, 0xe0, \
        0x2f, 0x63, 0xf1, 0xa5, 0xb7, 0x01, 0x55, 0x4f, 0xbc, 0xb7, 0x7e, 0x7d, 0x8d, 0x82, 0xcb, \
        0x74, 0xba, 0xc5, 0xed, 0xef, 0x9e, 0x41, 0x4c, 0xb0, 0x54, 0x6d, 0x15, 0x48, 0x18, 0x07, \
        0x3c, 0x2d, 0x44, 0xe0, 0xe2, 0x38, 0x90, 0x35, 0x34, 0xee, 0x0e, 0xc7, 0x1e, 0x32, 0x58, \
        0xbe, 0x89, 0x55, 0x9f, 0x7e, 0x68, 0xe5, 0xe7, 0x7f, 0xd1, 0xd0, 0x61, 0xf4, 0x80, 0x48, \
        0xe0, 0xd4, 0x97, 0x50, 0x74, 0xca, 0x27, 0xa6, 0xb5, 0xcf, 0x6e, 0xa5, 0x0f, 0xc9, 0x4f, \
        0x21, 0xc7, 0xe6, 0xc9, 0xfd, 0xfe, 0x1a, 0x33, 0x88, 0xe3, 0xb5, 0xa7, 0xb8, 0x3a, 0x4f, \
        0xbf, 0xf8, 0xc6, 0x54, 0x4d, 0x63, 0x14, 0x05, 0xdf, 0x45, 0x81, 0x4e, 0x84, 0x9a, 0x0a, \
        0x8a, 0x45, 0x40, 0x52, 0xcf, 0xee, 0x15, 0xb7, 0x71, 0x66, 0x98, 0x43, 0x11, 0x84, 0x7c, \
        0x2e, 0x1b, 0x02, 0xda, 0xb2, 0x92, 0xa1, 0x01, 0x85, 0x37, 0xb1, 0xce, 0x70, 0x11, 0xa4, \
        0xcf, 0x46, 0xeb, 0x08, 0x22, 0xdd, 0xad, 0x05, 0x89, 0xf7, 0x2e, 0x1e, 0xa7, 0xbb, 0x36, \
        0xcd, 0x7f, 0x13, 0xaa, 0xec, 0xdd, 0x2a, 0x2d, 0x23, 0xb1, 0xd0, 0xc6, 0x74, 0xfb, 0x84, \
        0x23, 0x36, 0xba, 0x90, 0xa0, 0x30, 0x31, 0x48, 0xd5, 0x52, 0xa9, 0x10, 0xd9, 0x4e, 0x5b, \
        0xa7, 0xb5, 0x06, 0x1c, 0x4b, 0x1c, 0xb1, 0x5e, 0xeb, 0xf0, 0xe1, 0x12, 0xf2, 0xe1, 0x5b, \
        0x41, 0x22, 0xf2, 0x93, 0x72, 0x62, 0x85, 0x7c, 0x72, 0x52, 0x37, 0x50, 0x52, 0x7b, 0x95, \
        0xe3, 0x2c, 0xa4, 0x5e, 0xbb, 0xa2, 0xd5, 0x7c, 0xa5, 0x4c, 0xfe, 0x7a, 0x31, 0x40, 0xda, \
        0x6f, 0xeb, 0xa5, 0x87, 0x4a, 0x49, 0x96, 0x96, 0x32, 0x8f,}
#define LIBSPDM_RSA3072_REQ_E     {0x01, 0x00, 0x01,}
#define LIBSPDM_RSA3072_REQ_D     { \
        0x00, 0xa7, 0x70, 0x78, 0xea, 0x16, 0x27, 0xc9, 0x53, 0xcd, 0x3f, 0x76, 0xbe, 0x11, 0xdc, \
        0xae, 0x3d, 0xef, 0xc3, 0xa6, 0xa0, 0x7b, 0xd1, 0x28, 0x19, 0x87, 0x80, 0x25, 0x6e, 0x9d, \
        0xa3, 0x34, 0x88, 0x0c, 0xbb, 0x0c, 0x9b, 0xd3, 0x1f, 0x48, 0x48, 0x64, 0x41, 0x20, 0x67, \
        0x19, 0xfd, 0xd9, 0x00, 0xfd, 0x25, 0x14, 0x0b, 0xfb, 0x31, 0x73, 0x62, 0x55, 0x52, 0x26, \
        0x47, 0xd3, 0x9a, 0x8e, 0x6b, 0x8d, 0x4e, 0x28, 0x23, 0x8b, 0x0b, 0x9a, 0xf9, 0xf0, 0xc6, \
        0x90, 0xf7, 0x16, 0x46, 0x2f, 0xc8, 0x6e, 0xff, 0x8c, 0x67, 0xdf, 0x15, 0xe0, 0x89, 0x8c, \
        0x18, 0xe9, 0xad, 0xa1, 0x3e, 0x67, 0x38, 0x2b, 0x55, 0x91, 0xc7, 0xb1, 0x98, 0x13, 0xf9, \
        0x5a, 0x4f, 0xa3, 0x54, 0x1b, 0x5d, 0x91, 0x20, 0x96, 0xe7, 0x22, 0xbd, 0x0c, 0xb2, 0x0a, \
        0x07, 0x64, 0x69, 0xe0, 0x1c, 0xd3, 0xaa, 0xb7, 0xbc, 0x60, 0x3e, 0x29, 0xd5, 0xd7, 0x1b, \
        0xc2, 0x77, 0xa5, 0x6e, 0xd8, 0xff, 0x6b, 0xa8, 0xd8, 0xe4, 0xa3, 0x24, 0x48, 0xe5, 0x14, \
        0xbe, 0x6f, 0x45, 0x1e, 0x90, 0x13, 0x28, 0x22, 0x31, 0xb4, 0x6a, 0xe6, 0x80, 0x00, 0xf9, \
        0x99, 0xcb, 0xc0, 0x2f, 0x1f, 0x29, 0x48, 0x05, 0xbc, 0x88, 0xb5, 0x85, 0x3d, 0x91, 0xf5, \
        0x6d, 0x67, 0xe2, 0xc1, 0x6a, 0xa1, 0x27, 0xfa, 0x22, 0x68, 0xee, 0x88, 0x9b, 0xc6, 0x4f, \
        0x1f, 0xdb, 0x22, 0x70, 0x99, 0x21, 0xa7, 0x41, 0x7f, 0x6b, 0x07, 0x7c, 0xc9, 0xd3, 0x57, \
        0x00, 0xde, 0xd6, 0xc6, 0xca, 0x61, 0x6b, 0x1a, 0x10, 0xaa, 0x8e, 0x0c, 0xbc, 0xe9, 0x69, \
        0x16, 0xbc, 0xdc, 0xd4, 0x4b, 0xc2, 0xac, 0xa0, 0x03, 0x6e, 0x6b, 0x57, 0x4f, 0x60, 0x67, \
        0x76, 0x9e, 0xa6, 0x0d, 0xf6, 0x7c, 0x10, 0xdf, 0x40, 0x21, 0x8c, 0xde, 0x78, 0xc5, 0xad, \
        0x71, 0x45, 0x65, 0x20, 0x74, 0xc2, 0x9a, 0x27, 0x9c, 0x0e, 0x70, 0x0a, 0x56, 0xb0, 0x91, \
        0xcd, 0xa9, 0x09, 0x3f, 0xe1, 0x4b, 0x17, 0x3e, 0xc8, 0xc7, 0xe6, 0xe8, 0xb9, 0xe1, 0xaa, \
        0xe8, 0x4a, 0xaa, 0xb7, 0xdc, 0xd6, 0x3b, 0x40, 0x29, 0x88, 0x13, 0xd3, 0x47, 0x96, 0xa5, \
        0x2f, 0xbb, 0x21, 0xb1, 0xd0, 0xfd, 0x36, 0xe0, 0x57, 0xb9, 0x9e, 0x41, 0xd4, 0xa7, 0x75, \
        0x9a, 0x6c, 0xfb, 0xb9, 0x36, 0x32, 0xc9, 0x16, 0x2e, 0xe3, 0x87, 0x68, 0x7b, 0x6c, 0xb5, \
        0x59, 0x9f, 0xed, 0x1b, 0xe8, 0x30, 0xca, 0xdf, 0xe5, 0x76, 0xf3, 0xfd, 0x33, 0x24, 0xae, \
        0x7f, 0x04, 0x4d, 0x82, 0x12, 0xc2, 0x10, 0x0a, 0xcb, 0x20, 0xee, 0x4b, 0x1a, 0x58, 0x67, \
        0x88, 0x69, 0x63, 0x62, 0xf1, 0x96, 0x38, 0xca, 0x22, 0x08, 0xab, 0xee, 0x30, 0x61, 0x80, \
        0x45, 0xff, 0x10, 0xb1, 0x10, 0x1f, 0xfb, 0xd4, 0x07, 0x01,}

#define LIBSPDM_RSA4096_REQ_N     { \
        0x00, 0xbc, 0xc0, 0x4a, 0x14, 0x67, 0xa6, 0x8c, 0x30, 0x19, 0x06, 0x78, 0xb3, 0x8b, 0x28, \
        0xbc, 0x6d, 0x41, 0xd1, 0x2c, 0x64, 0x71, 0x57, 0x51, 0xb7, 0xf4, 0xf5, 0x12, 0xbd, 0xd1, \
        0xab, 0x45, 0x2f, 0x00, 0xa7, 0x9f, 0x50, 0xf8, 0xa8, 0xf5, 0xde, 0xc2, 0x4c, 0xfa, 0x57, \
        0x07, 0xce, 0x3a, 0x9b, 0xc8, 0xcd, 0x77, 0x1e, 0x3c, 0xaa, 0x5a, 0x70, 0x8d, 0xb7, 0x32, \
        0xf1, 0xa9, 0x62, 0xd1, 0x71, 0x6f, 0x6a, 0x30, 0x37, 0x87, 0xd5, 0x47, 0x05, 0x8b, 0x0e, \
        0x4d, 0x35, 0x00, 0x84, 0x1d, 0xfe, 0xb6, 0xe3, 0x46, 0xdd, 0x88, 0x26, 0x04, 0xb7, 0x37, \
        0x16, 0x43, 0x09, 0x49, 0xb4, 0x3e, 0x49, 0xe4, 0x60, 0x0d, 0x91, 0x34, 0xa7, 0x23, 0xa9, \
        0x09, 0x91, 0xc5, 0x48, 0x27, 0xb0, 0x99, 0xdb, 0x04, 0x8d, 0xd3, 0x8b, 0x0a, 0x16, 0x83, \
        0x81, 0xf3, 0x57, 0x24, 0xc0, 0xce, 0x71, 0xf4, 0x7d, 0x25, 0xee, 0x81, 0x6f, 0x21, 0x79, \
        0x2a, 0x34, 0x0c, 0x19, 0x7c, 0x7b, 0x52, 0xeb, 0x6a, 0x54, 0x18, 0xad, 0x90, 0xaf, 0x0c, \
        0x84, 0xde, 0xd4, 0x69, 0x42, 0xca, 0xe4, 0x7b, 0xeb, 0xad, 0xd9, 0x99, 0x62, 0xe4, 0xd7, \
        0x03, 0x73, 0x96, 0x07, 0x7e, 0xab, 0xca, 0x9e, 0xb9, 0x46, 0x80, 0x1e, 0x43, 0xd4, 0xeb, \
        0x05, 0x6e, 0x66, 0x49, 0x20, 0x34, 0x43, 0x1e, 0x5c, 0x95, 0xe8, 0x08, 0xce, 0x5c, 0x97, \
        0x94, 0x0d, 0x86, 0x9a, 0x13, 0x5b, 0x92, 0xb6, 0x91, 0xa0, 0x01, 0xcc, 0x0f, 0x49, 0xa0, \
        0x55, 0xb1, 0x86, 0x0a, 0xb9, 0xba, 0x37, 0xd8, 0xa8, 0x3d, 0x65, 0xdc, 0x76, 0x64, 0xe1, \
        0x99, 0x6b, 0xeb, 0xe0, 0x51, 0x05, 0x8b, 0x89, 0x75, 0x20, 0xf5, 0xa9, 0xbf, 0x9c, 0x62, \
        0x23, 0x70, 0x48, 0x88, 0xe2, 0x58, 0x92, 0xb3, 0xb3, 0xb0, 0x87, 0xe3, 0x0e, 0xd0, 0x93, \
        0x31, 0xf0, 0x6e, 0xef, 0xb7, 0x2b, 0x7d, 0xe7, 0xa8, 0x80, 0x79, 0x41, 0x4a, 0x93, 0x4c, \
        0xc9, 0x49, 0xce, 0x09, 0x77, 0xc0, 0xd5, 0xd4, 0x3c, 0xe5, 0x8f, 0xb8, 0x4e, 0x19, 0x18, \
        0x40, 0x65, 0xaf, 0xcc, 0x63, 0x75, 0x81, 0x42, 0x4b, 0xea, 0xdc, 0x7f, 0x42, 0x97, 0x69, \
        0x62, 0xb2, 0xb9, 0x0a, 0xa8, 0x6f, 0xde, 0xba, 0x7b, 0x62, 0x49, 0x1e, 0x87, 0xb4, 0xb0, \
        0xa6, 0xd4, 0x61, 0x82, 0x12, 0x56, 0xd1, 0x4d, 0xad, 0xad, 0xaf, 0xf7, 0x1a, 0x52, 0xa8, \
        0x38, 0x62, 0x24, 0x7d, 0x50, 0x17, 0x43, 0x76, 0x86, 0xfa, 0x08, 0x32, 0xc6, 0xff, 0x8e, \
        0x1b, 0xdd, 0xbc, 0xf4, 0x55, 0xbb, 0x68, 0x81, 0xb7, 0xdf, 0x4d, 0x9d, 0xe9, 0xef, 0xbe, \
        0x6d, 0xb6, 0x27, 0xfe, 0x38, 0x9a, 0xde, 0xea, 0x86, 0xb9, 0xab, 0x9e, 0xc3, 0xe6, 0x53, \
        0xa2, 0xd1, 0x2a, 0x7a, 0x9e, 0x42, 0x51, 0xb3, 0x3c, 0xe3, 0xb1, 0x56, 0x75, 0xfc, 0xe0, \
        0x17, 0xd2, 0xdf, 0x82, 0x48, 0x70, 0xfa, 0xe6, 0xdb, 0x05, 0xc2, 0xde, 0x2b, 0xd7, 0x68, \
        0xdc, 0xc0, 0x8d, 0x30, 0xa3, 0x6a, 0x6f, 0x7e, 0x8a, 0xc9, 0x4d, 0x1d, 0xab, 0x39, 0x0c, \
        0xbe, 0x02, 0xe2, 0x35, 0x3a, 0xb8, 0xda, 0x0a, 0xb9, 0x33, 0x19, 0x8b, 0x7e, 0xb4, 0x4d, \
        0xd0, 0x0d, 0xf3, 0x9e, 0xaf, 0x38, 0x93, 0x2a, 0xe0, 0x45, 0x46, 0xef, 0x13, 0xd0, 0x4c, \
        0xf5, 0xc0, 0xdb, 0xc8, 0x97, 0xc2, 0xaa, 0xd0, 0x7f, 0xf6, 0xac, 0xb7, 0xa7, 0x83, 0xcb, \
        0x0c, 0x15, 0x9d, 0xfd, 0xc9, 0x3f, 0xa2, 0x1a, 0x51, 0xd9, 0x0d, 0x96, 0xb8, 0xbf, 0xb5, \
        0x66, 0x13, 0x00, 0x13, 0x87, 0xfd, 0x29, 0x20, 0x4a, 0xea, 0xe3, 0x16, 0xea, 0xa8, 0x6c, \
        0xb0, 0x81, 0x1c, 0x30, 0x47, 0x8d, 0x7e, 0x2e, 0xc1, 0x3d, 0x61, 0x79, 0x7d, 0x8e, 0xb2, \
        0x07, 0x2d, 0xa1,}
#define LIBSPDM_RSA4096_REQ_E     {0x01, 0x00, 0x01,}
#define LIBSPDM_RSA4096_REQ_D     { \
        0x0f, 0x1e, 0xd0, 0x50, 0x66, 0x25, 0x3f, 0x61, 0xb2, 0xff, 0x83, 0xb7, 0xce, 0x54, 0x0b, \
        0x14, 0x2d, 0x8b, 0x96, 0x24, 0xcd, 0xb7, 0x93, 0x02, 0x4b, 0x8b, 0x3e, 0x5f, 0x1a, 0x66, \
        0xbf, 0xfa, 0x0d, 0xf1, 0x5f, 0x9f, 0xda, 0xeb, 0x9e, 0x16, 0xa4, 0x36, 0x0a, 0x6f, 0xe2, \
        0x5e, 0x30, 0xef, 0xbd, 0xdc, 0x47, 0xc8, 0x92, 0x4f, 0x8b, 0x43, 0x2c, 0xf7, 0x1a, 0x0b, \
        0xa5, 0xe8, 0x16, 0xa3, 0x21, 0xab, 0xbe, 0x05, 0x14, 0xca, 0x8f, 0x0f, 0xf0, 0x9d, 0xca, \
        0xad, 0x8e, 0x47, 0x07, 0x28, 0x1a, 0x7a, 0x86, 0x78, 0xc4, 0xa9, 0x57, 0x03, 0x5e, 0x54, \
        0x58, 0x36, 0x6c, 0x43, 0x16, 0x22, 0x51, 0x3b, 0x28, 0x9b, 0x13, 0x3e, 0xb8, 0x6a, 0x98, \
        0x2b, 0xa7, 0x44, 0x2a, 0x79, 0xc9, 0x39, 0x74, 0x59, 0xf0, 0x32, 0x59, 0x32, 0x88, 0x82, \
        0x66, 0x7d, 0xfa, 0xa1, 0xbf, 0x67, 0xfd, 0x8f, 0xf0, 0xf3, 0xf4, 0x46, 0x74, 0xc6, 0x02, \
        0x0d, 0x7d, 0x52, 0xa5, 0x58, 0x33, 0xc2, 0x4c, 0x18, 0x44, 0x89, 0xd2, 0xe7, 0x52, 0xf7, \
        0x69, 0xea, 0x56, 0x2c, 0x55, 0x98, 0x8c, 0x1c, 0xcb, 0x26, 0x7d, 0x55, 0x20, 0xc3, 0xe0, \
        0xb0, 0xe7, 0xb9, 0xdd, 0xf9, 0xe1, 0x17, 0x69, 0xfc, 0x2d, 0xd3, 0x3e, 0xd7, 0xd5, 0xa3, \
        0xef, 0xbe, 0x1d, 0xe9, 0x88, 0x86, 0x3f, 0xee, 0x66, 0xcb, 0xd9, 0xb8, 0xbe, 0x4e, 0x1e, \
        0x3c, 0x1f, 0x26, 0x44, 0x9a, 0xb7, 0x5c, 0x0c, 0xba, 0x66, 0xaa, 0x74, 0x27, 0x0f, 0xc3, \
        0x0d, 0x9f, 0x91, 0x48, 0x63, 0x94, 0x89, 0xb4, 0xa0, 0x86, 0x82, 0x6c, 0xb1, 0x94, 0x28, \
        0xf8, 0x2e, 0x43, 0x1f, 0xfa, 0x73, 0xbd, 0x25, 0x36, 0xe8, 0xb7, 0x1a, 0x74, 0x6a, 0xa0, \
        0x30, 0x24, 0x7f, 0x62, 0xb2, 0x79, 0xbe, 0x0f, 0x8c, 0xfa, 0xb5, 0xc3, 0xc0, 0x0d, 0xaa, \
        0x98, 0x56, 0xe1, 0xb2, 0xbc, 0x49, 0xa6, 0x7c, 0xd1, 0xa9, 0x0e, 0x0f, 0x72, 0x06, 0x5d, \
        0x6c, 0x0c, 0x41, 0x4e, 0xa2, 0x8f, 0xbe, 0xf0, 0x66, 0x2e, 0x9c, 0x5b, 0x66, 0x9f, 0xbf, \
        0x6c, 0x11, 0x39, 0x03, 0x6f, 0xd1, 0x4f, 0xd5, 0xcf, 0xa3, 0xf8, 0x9e, 0xf0, 0xe7, 0xf0, \
        0xbf, 0xa0, 0xef, 0x2e, 0x84, 0xaf, 0xd6, 0x01, 0x0e, 0x84, 0xb7, 0xb8, 0xed, 0x5f, 0xc1, \
        0xb6, 0x69, 0x30, 0x1a, 0x61, 0xae, 0x1d, 0xab, 0x64, 0x20, 0x44, 0x01, 0x22, 0xef, 0x02, \
        0x4b, 0xf7, 0xcb, 0x3f, 0x43, 0xe8, 0x5f, 0xca, 0x44, 0x51, 0xe5, 0xa4, 0x95, 0x22, 0xc6, \
        0xe3, 0x27, 0xc9, 0x52, 0x66, 0x23, 0x0b, 0xf6, 0xaa, 0xe7, 0x76, 0x5b, 0xef, 0x4e, 0xe7, \
        0x50, 0xba, 0x0c, 0x90, 0x1e, 0x48, 0x37, 0xf8, 0xe8, 0x2d, 0x3c, 0xc6, 0x08, 0xa9, 0xf7, \
        0x0d, 0x0b, 0xe7, 0x60, 0xc3, 0x1f, 0xfb, 0xc3, 0x45, 0x1e, 0xf8, 0xbc, 0x8b, 0x15, 0xa7, \
        0xa9, 0x0a, 0x9e, 0x66, 0xed, 0xef, 0x5a, 0xab, 0x3f, 0xe7, 0x55, 0xba, 0x79, 0x4c, 0x86, \
        0x59, 0x2d, 0x2b, 0x57, 0xc6, 0x64, 0xd5, 0x0f, 0x4d, 0x77, 0x8a, 0xd3, 0xb5, 0x23, 0x87, \
        0xa6, 0xf4, 0x4b, 0x33, 0x88, 0x31, 0xcb, 0xf3, 0xd0, 0x91, 0x7d, 0xbb, 0x52, 0x7c, 0x6a, \
        0x17, 0x6c, 0xcc, 0xe7, 0x20, 0x46, 0x5d, 0xa5, 0xe0, 0xf3, 0xd5, 0xd9, 0x3e, 0x18, 0xaa, \
        0x4b, 0xa6, 0x8f, 0x45, 0x54, 0x2b, 0xe6, 0xa2, 0xd8, 0xf9, 0x54, 0x8b, 0x35, 0xe8, 0x5e, \
        0x8e, 0xbe, 0x99, 0x08, 0xb5, 0x2a, 0x10, 0x8d, 0x5b, 0x86, 0x23, 0x18, 0xc4, 0xb7, 0x34, \
        0x09, 0xeb, 0x32, 0x5a, 0x9c, 0x60, 0xfd, 0x00, 0x64, 0x4a, 0x34, 0xfd, 0xbe, 0xb6, 0xec, \
        0x56, 0xfb, 0xba, 0x10, 0x8a, 0xe6, 0x53, 0xfb, 0x1c, 0xb8, 0x53, 0xd0, 0x7a, 0xca, 0xe5, \
        0x12, 0x61,}
#endif /* (LIBSPDM_RSA_SSA_SUPPORT) || (LIBSPDM_RSA_PSS_SUPPORT) */

#endif /*RAW_DATA_KEY_H*/
