// Implementation file for parser generated by fsyacc
module internal FSharp.Compiler.Parser
#nowarn "64";; // turn off warnings that type variables used in production annotations are instantiated to concrete type
open FSharp.Compiler
open FSharp.Compiler.Syntax
open FSharp.Compiler.Text
open Internal.Utilities.Text.Lexing
open Internal.Utilities.Text.Parsing.ParseHelpers
//# 3 "src/Compiler/pars.fsy"


#nowarn "1182"  // generated code has lots of unused "parseState"
#nowarn "3261"  // the generated code would need to properly annotate nulls, e.g. changing System.Object to `obj|null`

open System

open Internal.Utilities
open Internal.Utilities.Text.Parsing
open Internal.Utilities.Library
open Internal.Utilities.Library.Extras

open FSharp.Compiler
open FSharp.Compiler.AbstractIL
open FSharp.Compiler.AbstractIL
open FSharp.Compiler.DiagnosticsLogger
open FSharp.Compiler.Features
open FSharp.Compiler.LexerStore
open FSharp.Compiler.ParseHelpers
open FSharp.Compiler.Syntax
open FSharp.Compiler.SyntaxTrivia
open FSharp.Compiler.Syntax.PrettyNaming
open FSharp.Compiler.SyntaxTreeOps
open FSharp.Compiler.Text
open FSharp.Compiler.Text.Position
open FSharp.Compiler.Text.Range
open FSharp.Compiler.Xml

// This function is called by the generated parser code. Returning initiates error recovery
// It must be called precisely "parse_error_rich"
let parse_error_rich = Some(fun (ctxt: ParseErrorContext<_>) ->
    errorR(SyntaxError(box ctxt, ctxt.ParseState.LexBuffer.LexemeRange)))


//# 44 "pars.fs"
// This type is the type of tokens accepted by the parser
type token = 
  | HASH_IF of (range * string * ParseHelpers.LexerContinuation)
  | HASH_ELSE of (range * string * ParseHelpers.LexerContinuation)
  | HASH_ENDIF of (range * string * ParseHelpers.LexerContinuation)
  | COMMENT of (ParseHelpers.LexerContinuation)
  | WHITESPACE of (ParseHelpers.LexerContinuation)
  | HASH_LINE of (ParseHelpers.LexerContinuation)
  | HASH_LIGHT of (ParseHelpers.LexerContinuation)
  | INACTIVECODE of (ParseHelpers.LexerContinuation)
  | LINE_COMMENT of (ParseHelpers.LexerContinuation)
  | STRING_TEXT of (ParseHelpers.LexerContinuation)
  | EOF of (ParseHelpers.LexerContinuation)
  | LEX_FAILURE of (string)
  | ODUMMY of (token)
  | FIXED
  | OINTERFACE_MEMBER
  | OBLOCKEND_COMING_SOON
  | OBLOCKEND_IS_HERE
  | OBLOCKEND of (range)
  | ORIGHT_BLOCK_END of (range)
  | ODECLEND of (range)
  | OEND
  | OBLOCKSEP
  | OBLOCKBEGIN
  | ORESET
  | OFUN
  | OFUNCTION
  | OWITH
  | OELSE
  | OTHEN
  | ODO_BANG
  | ODO
  | OAND_BANG of (bool)
  | OBINDER of (string)
  | OLET of (bool)
  | HIGH_PRECEDENCE_TYAPP
  | HIGH_PRECEDENCE_PAREN_APP
  | HIGH_PRECEDENCE_BRACK_APP
  | TYPE_COMING_SOON
  | TYPE_IS_HERE
  | MODULE_COMING_SOON
  | MODULE_IS_HERE
  | BAR_JUST_BEFORE_NULL
  | EXTERN
  | VOID
  | PUBLIC
  | PRIVATE
  | INTERNAL
  | GLOBAL
  | STATIC
  | MEMBER
  | CLASS
  | ABSTRACT
  | OVERRIDE
  | DEFAULT
  | CONSTRUCTOR
  | INHERIT
  | GREATER_RBRACK
  | STRUCT
  | SIG
  | BAR
  | RBRACK
  | RBRACE_COMING_SOON
  | RBRACE_IS_HERE
  | MINUS
  | DOLLAR
  | BAR_RBRACK
  | BAR_RBRACE
  | UNDERSCORE
  | SEMICOLON_SEMICOLON
  | LARROW
  | EQUALS
  | LBRACK
  | LBRACK_BAR
  | LBRACE_BAR
  | LBRACK_LESS
  | QMARK
  | QMARK_QMARK
  | DOT
  | COLON
  | COLON_COLON
  | COLON_GREATER
  | COLON_QMARK_GREATER
  | COLON_QMARK
  | COLON_EQUALS
  | SEMICOLON
  | WHEN
  | WHILE
  | WHILE_BANG
  | WITH
  | HASH
  | AMP
  | AMP_AMP
  | QUOTE
  | LPAREN
  | RPAREN
  | RPAREN_COMING_SOON
  | RPAREN_IS_HERE
  | STAR
  | COMMA
  | RARROW
  | GREATER_BAR_RBRACK
  | LPAREN_STAR_RPAREN
  | OPEN
  | OR
  | REC
  | THEN
  | TO
  | TRUE
  | TRY
  | TYPE
  | VAL
  | INLINE
  | INTERFACE
  | INSTANCE
  | CONST
  | LAZY
  | OLAZY
  | MATCH
  | MATCH_BANG
  | MUTABLE
  | NEW
  | OF
  | EXCEPTION
  | FALSE
  | FOR
  | FUN
  | FUNCTION
  | IF
  | IN
  | JOIN_IN
  | FINALLY
  | DO_BANG
  | AND
  | AS
  | ASSERT
  | OASSERT
  | ASR
  | BEGIN
  | DO
  | DONE
  | DOWNTO
  | ELSE
  | ELIF
  | END
  | DOT_DOT
  | DOT_DOT_HAT
  | BAR_BAR
  | UPCAST
  | DOWNCAST
  | NULL
  | RESERVED
  | MODULE
  | NAMESPACE
  | DELEGATE
  | CONSTRAINT
  | BASE
  | LQUOTE of (string * bool)
  | RQUOTE of (string * bool)
  | RQUOTE_DOT of (string * bool)
  | PERCENT_OP of (string)
  | BINDER of (string)
  | LESS of (bool)
  | GREATER of (bool)
  | LET of (bool)
  | YIELD of (bool)
  | YIELD_BANG of (bool)
  | AND_BANG of (bool)
  | BIGNUM of ((string * string))
  | DECIMAL of (System.Decimal)
  | CHAR of (char)
  | IEEE64 of (double)
  | IEEE32 of (single)
  | UNATIVEINT of (uint64)
  | UINT64 of (uint64)
  | UINT32 of (uint32)
  | UINT16 of (uint16)
  | UINT8 of (byte)
  | NATIVEINT of (int64 * bool)
  | INT64 of (int64 * bool)
  | INT32 of (int32 * bool)
  | INT32_DOT_DOT of (int32 * bool)
  | INT16 of (int16 * bool)
  | INT8 of (sbyte * bool)
  | FUNKY_OPERATOR_NAME of (string)
  | ADJACENT_PREFIX_OP of (string)
  | PLUS_MINUS_OP of (string)
  | INFIX_AMP_OP of (string)
  | INFIX_STAR_DIV_MOD_OP of (string)
  | PREFIX_OP of (string)
  | INFIX_BAR_OP of (string)
  | INFIX_AT_HAT_OP of (string)
  | INFIX_COMPARE_OP of (string)
  | INFIX_STAR_STAR_OP of (string)
  | HASH_IDENT of (string)
  | IDENT of (string)
  | KEYWORD_STRING of (string * string)
  | LBRACE of (ParseHelpers.LexerContinuation)
  | RBRACE of (ParseHelpers.LexerContinuation)
  | INTERP_STRING_END of (string * ParseHelpers.LexerContinuation)
  | INTERP_STRING_PART of (string * ParseHelpers.LexerContinuation)
  | INTERP_STRING_BEGIN_PART of (string * SynStringKind * ParseHelpers.LexerContinuation)
  | INTERP_STRING_BEGIN_END of (string * SynStringKind * ParseHelpers.LexerContinuation)
  | STRING of (string * SynStringKind * ParseHelpers.LexerContinuation)
  | BYTEARRAY of (byte[] * SynByteStringKind * ParseHelpers.LexerContinuation)
// This type is used to give symbolic names to token indexes, useful for error messages
type tokenId = 
    | TOKEN_HASH_IF
    | TOKEN_HASH_ELSE
    | TOKEN_HASH_ENDIF
    | TOKEN_COMMENT
    | TOKEN_WHITESPACE
    | TOKEN_HASH_LINE
    | TOKEN_HASH_LIGHT
    | TOKEN_INACTIVECODE
    | TOKEN_LINE_COMMENT
    | TOKEN_STRING_TEXT
    | TOKEN_EOF
    | TOKEN_LEX_FAILURE
    | TOKEN_ODUMMY
    | TOKEN_FIXED
    | TOKEN_OINTERFACE_MEMBER
    | TOKEN_OBLOCKEND_COMING_SOON
    | TOKEN_OBLOCKEND_IS_HERE
    | TOKEN_OBLOCKEND
    | TOKEN_ORIGHT_BLOCK_END
    | TOKEN_ODECLEND
    | TOKEN_OEND
    | TOKEN_OBLOCKSEP
    | TOKEN_OBLOCKBEGIN
    | TOKEN_ORESET
    | TOKEN_OFUN
    | TOKEN_OFUNCTION
    | TOKEN_OWITH
    | TOKEN_OELSE
    | TOKEN_OTHEN
    | TOKEN_ODO_BANG
    | TOKEN_ODO
    | TOKEN_OAND_BANG
    | TOKEN_OBINDER
    | TOKEN_OLET
    | TOKEN_HIGH_PRECEDENCE_TYAPP
    | TOKEN_HIGH_PRECEDENCE_PAREN_APP
    | TOKEN_HIGH_PRECEDENCE_BRACK_APP
    | TOKEN_TYPE_COMING_SOON
    | TOKEN_TYPE_IS_HERE
    | TOKEN_MODULE_COMING_SOON
    | TOKEN_MODULE_IS_HERE
    | TOKEN_BAR_JUST_BEFORE_NULL
    | TOKEN_EXTERN
    | TOKEN_VOID
    | TOKEN_PUBLIC
    | TOKEN_PRIVATE
    | TOKEN_INTERNAL
    | TOKEN_GLOBAL
    | TOKEN_STATIC
    | TOKEN_MEMBER
    | TOKEN_CLASS
    | TOKEN_ABSTRACT
    | TOKEN_OVERRIDE
    | TOKEN_DEFAULT
    | TOKEN_CONSTRUCTOR
    | TOKEN_INHERIT
    | TOKEN_GREATER_RBRACK
    | TOKEN_STRUCT
    | TOKEN_SIG
    | TOKEN_BAR
    | TOKEN_RBRACK
    | TOKEN_RBRACE_COMING_SOON
    | TOKEN_RBRACE_IS_HERE
    | TOKEN_MINUS
    | TOKEN_DOLLAR
    | TOKEN_BAR_RBRACK
    | TOKEN_BAR_RBRACE
    | TOKEN_UNDERSCORE
    | TOKEN_SEMICOLON_SEMICOLON
    | TOKEN_LARROW
    | TOKEN_EQUALS
    | TOKEN_LBRACK
    | TOKEN_LBRACK_BAR
    | TOKEN_LBRACE_BAR
    | TOKEN_LBRACK_LESS
    | TOKEN_QMARK
    | TOKEN_QMARK_QMARK
    | TOKEN_DOT
    | TOKEN_COLON
    | TOKEN_COLON_COLON
    | TOKEN_COLON_GREATER
    | TOKEN_COLON_QMARK_GREATER
    | TOKEN_COLON_QMARK
    | TOKEN_COLON_EQUALS
    | TOKEN_SEMICOLON
    | TOKEN_WHEN
    | TOKEN_WHILE
    | TOKEN_WHILE_BANG
    | TOKEN_WITH
    | TOKEN_HASH
    | TOKEN_AMP
    | TOKEN_AMP_AMP
    | TOKEN_QUOTE
    | TOKEN_LPAREN
    | TOKEN_RPAREN
    | TOKEN_RPAREN_COMING_SOON
    | TOKEN_RPAREN_IS_HERE
    | TOKEN_STAR
    | TOKEN_COMMA
    | TOKEN_RARROW
    | TOKEN_GREATER_BAR_RBRACK
    | TOKEN_LPAREN_STAR_RPAREN
    | TOKEN_OPEN
    | TOKEN_OR
    | TOKEN_REC
    | TOKEN_THEN
    | TOKEN_TO
    | TOKEN_TRUE
    | TOKEN_TRY
    | TOKEN_TYPE
    | TOKEN_VAL
    | TOKEN_INLINE
    | TOKEN_INTERFACE
    | TOKEN_INSTANCE
    | TOKEN_CONST
    | TOKEN_LAZY
    | TOKEN_OLAZY
    | TOKEN_MATCH
    | TOKEN_MATCH_BANG
    | TOKEN_MUTABLE
    | TOKEN_NEW
    | TOKEN_OF
    | TOKEN_EXCEPTION
    | TOKEN_FALSE
    | TOKEN_FOR
    | TOKEN_FUN
    | TOKEN_FUNCTION
    | TOKEN_IF
    | TOKEN_IN
    | TOKEN_JOIN_IN
    | TOKEN_FINALLY
    | TOKEN_DO_BANG
    | TOKEN_AND
    | TOKEN_AS
    | TOKEN_ASSERT
    | TOKEN_OASSERT
    | TOKEN_ASR
    | TOKEN_BEGIN
    | TOKEN_DO
    | TOKEN_DONE
    | TOKEN_DOWNTO
    | TOKEN_ELSE
    | TOKEN_ELIF
    | TOKEN_END
    | TOKEN_DOT_DOT
    | TOKEN_DOT_DOT_HAT
    | TOKEN_BAR_BAR
    | TOKEN_UPCAST
    | TOKEN_DOWNCAST
    | TOKEN_NULL
    | TOKEN_RESERVED
    | TOKEN_MODULE
    | TOKEN_NAMESPACE
    | TOKEN_DELEGATE
    | TOKEN_CONSTRAINT
    | TOKEN_BASE
    | TOKEN_LQUOTE
    | TOKEN_RQUOTE
    | TOKEN_RQUOTE_DOT
    | TOKEN_PERCENT_OP
    | TOKEN_BINDER
    | TOKEN_LESS
    | TOKEN_GREATER
    | TOKEN_LET
    | TOKEN_YIELD
    | TOKEN_YIELD_BANG
    | TOKEN_AND_BANG
    | TOKEN_BIGNUM
    | TOKEN_DECIMAL
    | TOKEN_CHAR
    | TOKEN_IEEE64
    | TOKEN_IEEE32
    | TOKEN_UNATIVEINT
    | TOKEN_UINT64
    | TOKEN_UINT32
    | TOKEN_UINT16
    | TOKEN_UINT8
    | TOKEN_NATIVEINT
    | TOKEN_INT64
    | TOKEN_INT32
    | TOKEN_INT32_DOT_DOT
    | TOKEN_INT16
    | TOKEN_INT8
    | TOKEN_FUNKY_OPERATOR_NAME
    | TOKEN_ADJACENT_PREFIX_OP
    | TOKEN_PLUS_MINUS_OP
    | TOKEN_INFIX_AMP_OP
    | TOKEN_INFIX_STAR_DIV_MOD_OP
    | TOKEN_PREFIX_OP
    | TOKEN_INFIX_BAR_OP
    | TOKEN_INFIX_AT_HAT_OP
    | TOKEN_INFIX_COMPARE_OP
    | TOKEN_INFIX_STAR_STAR_OP
    | TOKEN_HASH_IDENT
    | TOKEN_IDENT
    | TOKEN_KEYWORD_STRING
    | TOKEN_LBRACE
    | TOKEN_RBRACE
    | TOKEN_INTERP_STRING_END
    | TOKEN_INTERP_STRING_PART
    | TOKEN_INTERP_STRING_BEGIN_PART
    | TOKEN_INTERP_STRING_BEGIN_END
    | TOKEN_STRING
    | TOKEN_BYTEARRAY
    | TOKEN_end_of_input
    | TOKEN_error
// This type is used to give symbolic names to token indexes, useful for error messages
type nonTerminalId = 
    | NONTERM__startsignatureFile
    | NONTERM__startimplementationFile
    | NONTERM__startinteraction
    | NONTERM__starttypedSequentialExprEOF
    | NONTERM__starttypEOF
    | NONTERM_interaction
    | NONTERM_interactiveTerminator
    | NONTERM_interactiveItemsTerminator
    | NONTERM_interactiveDefns
    | NONTERM_interactiveExpr
    | NONTERM_interactiveHash
    | NONTERM_interactiveSeparators
    | NONTERM_interactiveSeparator
    | NONTERM_hashDirective
    | NONTERM_hashDirectiveArgs
    | NONTERM_hashDirectiveArg
    | NONTERM_signatureFile
    | NONTERM_moduleIntro
    | NONTERM_namespaceIntro
    | NONTERM_fileNamespaceSpecs
    | NONTERM_fileNamespaceSpecList
    | NONTERM_fileNamespaceSpec
    | NONTERM_fileModuleSpec
    | NONTERM_moduleSpfnsPossiblyEmptyBlock
    | NONTERM_moduleSpfnsPossiblyEmpty
    | NONTERM_moduleSpfns
    | NONTERM_moduleSpfn
    | NONTERM_valSpfn
    | NONTERM_optLiteralValueSpfn
    | NONTERM_moduleSpecBlock
    | NONTERM_tyconSpfnList
    | NONTERM_tyconSpfn
    | NONTERM_tyconSpfnRhsBlock
    | NONTERM_tyconSpfnRhs
    | NONTERM_tyconClassSpfn
    | NONTERM_classSpfnBlockKindUnspecified
    | NONTERM_classSpfnBlock
    | NONTERM_classSpfnMembers
    | NONTERM_classSpfnMembersAtLeastOne
    | NONTERM_classMemberSpfn
    | NONTERM_classMemberSpfnGetSet
    | NONTERM_classMemberSpfnGetSetElements
    | NONTERM_memberSpecFlags
    | NONTERM_exconSpfn
    | NONTERM_opt_classSpfn
    | NONTERM_implementationFile
    | NONTERM_fileNamespaceImpls
    | NONTERM_fileNamespaceImplList
    | NONTERM_fileNamespaceImpl
    | NONTERM_fileModuleImpl
    | NONTERM_moduleDefnsOrExprPossiblyEmptyOrBlock
    | NONTERM_moduleDefnsOrExprPossiblyEmpty
    | NONTERM_moduleDefnsOrExpr
    | NONTERM_moduleDefns
    | NONTERM_moduleDefnOrDirective
    | NONTERM_moduleDefn
    | NONTERM_openDecl
    | NONTERM_namedModuleAbbrevBlock
    | NONTERM_namedModuleDefnBlock
    | NONTERM_wrappedNamedModuleDefn
    | NONTERM_tyconDefnAugmentation
    | NONTERM_opt_attributes
    | NONTERM_attributes
    | NONTERM_attributeList
    | NONTERM_attributeListElements
    | NONTERM_attribute
    | NONTERM_attributeTarget
    | NONTERM_memberFlags
    | NONTERM_typeNameInfo
    | NONTERM_tyconDefnList
    | NONTERM_tyconDefn
    | NONTERM_tyconDefnRhsBlock
    | NONTERM_tyconDefnRhs
    | NONTERM_tyconClassDefn
    | NONTERM_classDefnBlockKindUnspecified
    | NONTERM_classDefnBlock
    | NONTERM_classDefnMembers
    | NONTERM_classDefnMembersAtLeastOne
    | NONTERM_classDefnMemberGetSet
    | NONTERM_classDefnMemberGetSetElements
    | NONTERM_classDefnMemberGetSetElement
    | NONTERM_memberCore
    | NONTERM_abstractMemberFlags
    | NONTERM_classDefnMember
    | NONTERM_valDefnDecl
    | NONTERM_autoPropsDefnDecl
    | NONTERM_opt_typ
    | NONTERM_atomicPatternLongIdent
    | NONTERM_opt_access
    | NONTERM_access
    | NONTERM_opt_interfaceImplDefn
    | NONTERM_opt_classDefn
    | NONTERM_inheritsDefn
    | NONTERM_optAsSpec
    | NONTERM_asSpec
    | NONTERM_optBaseSpec
    | NONTERM_baseSpec
    | NONTERM_objectImplementationBlock
    | NONTERM_objectImplementationMembers
    | NONTERM_objectImplementationMember
    | NONTERM_staticMemberOrMemberOrOverride
    | NONTERM_tyconDefnOrSpfnSimpleRepr
    | NONTERM_braceFieldDeclList
    | NONTERM_anonRecdType
    | NONTERM_braceBarFieldDeclListCore
    | NONTERM_classOrInterfaceOrStruct
    | NONTERM_interfaceMember
    | NONTERM_tyconNameAndTyparDecls
    | NONTERM_prefixTyparDecls
    | NONTERM_typarDeclList
    | NONTERM_typarDecl
    | NONTERM_postfixTyparDecls
    | NONTERM_explicitValTyparDeclsCore
    | NONTERM_explicitValTyparDecls
    | NONTERM_opt_explicitValTyparDecls
    | NONTERM_hashConstraint
    | NONTERM_opt_typeConstraints
    | NONTERM_typeConstraints
    | NONTERM_intersectionConstraints
    | NONTERM_typeConstraint
    | NONTERM_typeAlts
    | NONTERM_unionTypeRepr
    | NONTERM_barAndgrabXmlDoc
    | NONTERM_attrUnionCaseDecls
    | NONTERM_attrUnionCaseDecl
    | NONTERM_unionCaseName
    | NONTERM_firstUnionCaseDeclOfMany
    | NONTERM_firstUnionCaseDecl
    | NONTERM_unionCaseReprElements
    | NONTERM_unionCaseReprElement
    | NONTERM_unionCaseRepr
    | NONTERM_recdFieldDeclList
    | NONTERM_recdFieldDecl
    | NONTERM_fieldDecl
    | NONTERM_exconDefn
    | NONTERM_exconCore
    | NONTERM_exconIntro
    | NONTERM_exconRepr
    | NONTERM_defnBindings
    | NONTERM_doBinding
    | NONTERM_hardwhiteLetBindings
    | NONTERM_hardwhiteDoBinding
    | NONTERM_classDefnBindings
    | NONTERM_hardwhiteDefnBindingsTerminator
    | NONTERM_cPrototype
    | NONTERM_externArgs
    | NONTERM_externMoreArgs
    | NONTERM_externArg
    | NONTERM_cType
    | NONTERM_cRetType
    | NONTERM_localBindings
    | NONTERM_moreLocalBindings
    | NONTERM_attr_localBinding
    | NONTERM_localBinding
    | NONTERM_typedExprWithStaticOptimizationsBlock
    | NONTERM_typedExprWithStaticOptimizations
    | NONTERM_opt_staticOptimizations
    | NONTERM_staticOptimization
    | NONTERM_staticOptimizationConditions
    | NONTERM_staticOptimizationCondition
    | NONTERM_rawConstant
    | NONTERM_rationalConstant
    | NONTERM_atomicUnsignedRationalConstant
    | NONTERM_atomicRationalConstant
    | NONTERM_constant
    | NONTERM_bindingPattern
    | NONTERM_opt_simplePatterns
    | NONTERM_simplePatterns
    | NONTERM_barCanBeRightBeforeNull
    | NONTERM_headBindingPattern
    | NONTERM_tuplePatternElements
    | NONTERM_conjPatternElements
    | NONTERM_namePatPairs
    | NONTERM_namePatPair
    | NONTERM_constrPattern
    | NONTERM_atomicPatsOrNamePatPairs
    | NONTERM_atomicPatterns
    | NONTERM_atomicPattern
    | NONTERM_parenPatternBody
    | NONTERM_parenPattern
    | NONTERM_tupleParenPatternElements
    | NONTERM_conjParenPatternElements
    | NONTERM_recordPatternElementsAux
    | NONTERM_recordPatternElement
    | NONTERM_listPatternElements
    | NONTERM_typedSequentialExprBlock
    | NONTERM_declExprBlock
    | NONTERM_typedSequentialExprBlockR
    | NONTERM_typedSequentialExpr
    | NONTERM_typedSequentialExprEOF
    | NONTERM_sequentialExpr
    | NONTERM_recover
    | NONTERM_moreBinders
    | NONTERM_declExpr
    | NONTERM_whileExprCore
    | NONTERM_dynamicArg
    | NONTERM_withClauses
    | NONTERM_withPatternClauses
    | NONTERM_patternAndGuard
    | NONTERM_patternClauses
    | NONTERM_patternGuard
    | NONTERM_patternResult
    | NONTERM_ifExprCases
    | NONTERM_ifExprThen
    | NONTERM_ifExprElifs
    | NONTERM_tupleExpr
    | NONTERM_minusExpr
    | NONTERM_appExpr
    | NONTERM_argExpr
    | NONTERM_atomicExpr
    | NONTERM_atomicExprQualification
    | NONTERM_atomicExprAfterType
    | NONTERM_beginEndExpr
    | NONTERM_quoteExpr
    | NONTERM_arrayExpr
    | NONTERM_parenExpr
    | NONTERM_parenExprBody
    | NONTERM_typars
    | NONTERM_typarAlts
    | NONTERM_braceExpr
    | NONTERM_braceExprBody
    | NONTERM_listExprElements
    | NONTERM_arrayExprElements
    | NONTERM_computationExpr
    | NONTERM_arrowThenExprR
    | NONTERM_forLoopBinder
    | NONTERM_forLoopRange
    | NONTERM_forLoopDirection
    | NONTERM_inlineAssemblyExpr
    | NONTERM_optCurriedArgExprs
    | NONTERM_opt_atomicExprAfterType
    | NONTERM_opt_inlineAssemblyTypeArg
    | NONTERM_optInlineAssemblyReturnTypes
    | NONTERM_recdExpr
    | NONTERM_recdExprCore
    | NONTERM_opt_seps_recd
    | NONTERM_seps_recd
    | NONTERM_pathOrUnderscore
    | NONTERM_recdExprBindings
    | NONTERM_recdBinding
    | NONTERM_objExpr
    | NONTERM_objExprBaseCall
    | NONTERM_opt_objExprBindings
    | NONTERM_objExprBindings
    | NONTERM_objExprInterfaces
    | NONTERM_opt_objExprInterfaces
    | NONTERM_objExprInterface
    | NONTERM_braceBarExpr
    | NONTERM_braceBarExprCore
    | NONTERM_anonLambdaExpr
    | NONTERM_anonMatchingExpr
    | NONTERM_typeWithTypeConstraints
    | NONTERM_topTypeWithTypeConstraints
    | NONTERM_opt_topReturnTypeWithTypeConstraints
    | NONTERM_topType
    | NONTERM_topTupleType
    | NONTERM_topTupleTypeElements
    | NONTERM_topAppType
    | NONTERM_invalidUseOfAppTypeFunction
    | NONTERM_typ
    | NONTERM_typEOF
    | NONTERM_tupleType
    | NONTERM_tupleOrQuotTypeElements
    | NONTERM_intersectionType
    | NONTERM_appTypeCon
    | NONTERM_appTypeConPower
    | NONTERM_appTypeCanBeNullable
    | NONTERM_appTypeNullableInParens
    | NONTERM_appTypeWithoutNull
    | NONTERM_arrayTypeSuffix
    | NONTERM_appTypePrefixArguments
    | NONTERM_typeArgListElements
    | NONTERM_powerType
    | NONTERM_atomTypeNonAtomicDeprecated
    | NONTERM_atomTypeOrAnonRecdType
    | NONTERM_atomType
    | NONTERM_typeArgsNoHpaDeprecated
    | NONTERM_typeArgsActual
    | NONTERM_typeArgActual
    | NONTERM_typeArgActualOrDummyIfEmpty
    | NONTERM_dummyTypeArg
    | NONTERM_measureTypeArg
    | NONTERM_measureTypeAtom
    | NONTERM_measureTypePower
    | NONTERM_measureTypeSeq
    | NONTERM_measureTypeExpr
    | NONTERM_typar
    | NONTERM_ident
    | NONTERM_path
    | NONTERM_opName
    | NONTERM_operatorName
    | NONTERM_activePatternCaseName
    | NONTERM_activePatternCaseNames
    | NONTERM_identOrOp
    | NONTERM_pathOp
    | NONTERM_nameop
    | NONTERM_identExpr
    | NONTERM_topSeparator
    | NONTERM_topSeparators
    | NONTERM_opt_topSeparators
    | NONTERM_seps
    | NONTERM_declEnd
    | NONTERM_opt_declEnd
    | NONTERM_opt_ODECLEND
    | NONTERM_deprecated_opt_equals
    | NONTERM_opt_OBLOCKSEP
    | NONTERM_opt_seps
    | NONTERM_opt_rec
    | NONTERM_opt_inline
    | NONTERM_opt_mutable
    | NONTERM_doToken
    | NONTERM_doneDeclEnd
    | NONTERM_structOrBegin
    | NONTERM_sigOrBegin
    | NONTERM_colonOrEquals
    | NONTERM_string
    | NONTERM_sourceIdentifier
    | NONTERM_interpolatedStringFill
    | NONTERM_interpolatedStringParts
    | NONTERM_interpolatedString
    | NONTERM_opt_HIGH_PRECEDENCE_APP
    | NONTERM_opt_HIGH_PRECEDENCE_TYAPP
    | NONTERM_typeKeyword
    | NONTERM_moduleKeyword
    | NONTERM_rbrace
    | NONTERM_bar_rbrace
    | NONTERM_rparen
    | NONTERM_oblockend
    | NONTERM_ends_other_than_rparen_coming_soon_or_recover
    | NONTERM_ends_coming_soon_or_recover

// This function maps tokens to integer indexes
let tagOfToken (t:token) = 
  match t with
  | HASH_IF _ -> 0 
  | HASH_ELSE _ -> 1 
  | HASH_ENDIF _ -> 2 
  | COMMENT _ -> 3 
  | WHITESPACE _ -> 4 
  | HASH_LINE _ -> 5 
  | HASH_LIGHT _ -> 6 
  | INACTIVECODE _ -> 7 
  | LINE_COMMENT _ -> 8 
  | STRING_TEXT _ -> 9 
  | EOF _ -> 10 
  | LEX_FAILURE _ -> 11 
  | ODUMMY _ -> 12 
  | FIXED  -> 13 
  | OINTERFACE_MEMBER  -> 14 
  | OBLOCKEND_COMING_SOON  -> 15 
  | OBLOCKEND_IS_HERE  -> 16 
  | OBLOCKEND _ -> 17 
  | ORIGHT_BLOCK_END _ -> 18 
  | ODECLEND _ -> 19 
  | OEND  -> 20 
  | OBLOCKSEP  -> 21 
  | OBLOCKBEGIN  -> 22 
  | ORESET  -> 23 
  | OFUN  -> 24 
  | OFUNCTION  -> 25 
  | OWITH  -> 26 
  | OELSE  -> 27 
  | OTHEN  -> 28 
  | ODO_BANG  -> 29 
  | ODO  -> 30 
  | OAND_BANG _ -> 31 
  | OBINDER _ -> 32 
  | OLET _ -> 33 
  | HIGH_PRECEDENCE_TYAPP  -> 34 
  | HIGH_PRECEDENCE_PAREN_APP  -> 35 
  | HIGH_PRECEDENCE_BRACK_APP  -> 36 
  | TYPE_COMING_SOON  -> 37 
  | TYPE_IS_HERE  -> 38 
  | MODULE_COMING_SOON  -> 39 
  | MODULE_IS_HERE  -> 40 
  | BAR_JUST_BEFORE_NULL  -> 41 
  | EXTERN  -> 42 
  | VOID  -> 43 
  | PUBLIC  -> 44 
  | PRIVATE  -> 45 
  | INTERNAL  -> 46 
  | GLOBAL  -> 47 
  | STATIC  -> 48 
  | MEMBER  -> 49 
  | CLASS  -> 50 
  | ABSTRACT  -> 51 
  | OVERRIDE  -> 52 
  | DEFAULT  -> 53 
  | CONSTRUCTOR  -> 54 
  | INHERIT  -> 55 
  | GREATER_RBRACK  -> 56 
  | STRUCT  -> 57 
  | SIG  -> 58 
  | BAR  -> 59 
  | RBRACK  -> 60 
  | RBRACE_COMING_SOON  -> 61 
  | RBRACE_IS_HERE  -> 62 
  | MINUS  -> 63 
  | DOLLAR  -> 64 
  | BAR_RBRACK  -> 65 
  | BAR_RBRACE  -> 66 
  | UNDERSCORE  -> 67 
  | SEMICOLON_SEMICOLON  -> 68 
  | LARROW  -> 69 
  | EQUALS  -> 70 
  | LBRACK  -> 71 
  | LBRACK_BAR  -> 72 
  | LBRACE_BAR  -> 73 
  | LBRACK_LESS  -> 74 
  | QMARK  -> 75 
  | QMARK_QMARK  -> 76 
  | DOT  -> 77 
  | COLON  -> 78 
  | COLON_COLON  -> 79 
  | COLON_GREATER  -> 80 
  | COLON_QMARK_GREATER  -> 81 
  | COLON_QMARK  -> 82 
  | COLON_EQUALS  -> 83 
  | SEMICOLON  -> 84 
  | WHEN  -> 85 
  | WHILE  -> 86 
  | WHILE_BANG  -> 87 
  | WITH  -> 88 
  | HASH  -> 89 
  | AMP  -> 90 
  | AMP_AMP  -> 91 
  | QUOTE  -> 92 
  | LPAREN  -> 93 
  | RPAREN  -> 94 
  | RPAREN_COMING_SOON  -> 95 
  | RPAREN_IS_HERE  -> 96 
  | STAR  -> 97 
  | COMMA  -> 98 
  | RARROW  -> 99 
  | GREATER_BAR_RBRACK  -> 100 
  | LPAREN_STAR_RPAREN  -> 101 
  | OPEN  -> 102 
  | OR  -> 103 
  | REC  -> 104 
  | THEN  -> 105 
  | TO  -> 106 
  | TRUE  -> 107 
  | TRY  -> 108 
  | TYPE  -> 109 
  | VAL  -> 110 
  | INLINE  -> 111 
  | INTERFACE  -> 112 
  | INSTANCE  -> 113 
  | CONST  -> 114 
  | LAZY  -> 115 
  | OLAZY  -> 116 
  | MATCH  -> 117 
  | MATCH_BANG  -> 118 
  | MUTABLE  -> 119 
  | NEW  -> 120 
  | OF  -> 121 
  | EXCEPTION  -> 122 
  | FALSE  -> 123 
  | FOR  -> 124 
  | FUN  -> 125 
  | FUNCTION  -> 126 
  | IF  -> 127 
  | IN  -> 128 
  | JOIN_IN  -> 129 
  | FINALLY  -> 130 
  | DO_BANG  -> 131 
  | AND  -> 132 
  | AS  -> 133 
  | ASSERT  -> 134 
  | OASSERT  -> 135 
  | ASR  -> 136 
  | BEGIN  -> 137 
  | DO  -> 138 
  | DONE  -> 139 
  | DOWNTO  -> 140 
  | ELSE  -> 141 
  | ELIF  -> 142 
  | END  -> 143 
  | DOT_DOT  -> 144 
  | DOT_DOT_HAT  -> 145 
  | BAR_BAR  -> 146 
  | UPCAST  -> 147 
  | DOWNCAST  -> 148 
  | NULL  -> 149 
  | RESERVED  -> 150 
  | MODULE  -> 151 
  | NAMESPACE  -> 152 
  | DELEGATE  -> 153 
  | CONSTRAINT  -> 154 
  | BASE  -> 155 
  | LQUOTE _ -> 156 
  | RQUOTE _ -> 157 
  | RQUOTE_DOT _ -> 158 
  | PERCENT_OP _ -> 159 
  | BINDER _ -> 160 
  | LESS _ -> 161 
  | GREATER _ -> 162 
  | LET _ -> 163 
  | YIELD _ -> 164 
  | YIELD_BANG _ -> 165 
  | AND_BANG _ -> 166 
  | BIGNUM _ -> 167 
  | DECIMAL _ -> 168 
  | CHAR _ -> 169 
  | IEEE64 _ -> 170 
  | IEEE32 _ -> 171 
  | UNATIVEINT _ -> 172 
  | UINT64 _ -> 173 
  | UINT32 _ -> 174 
  | UINT16 _ -> 175 
  | UINT8 _ -> 176 
  | NATIVEINT _ -> 177 
  | INT64 _ -> 178 
  | INT32 _ -> 179 
  | INT32_DOT_DOT _ -> 180 
  | INT16 _ -> 181 
  | INT8 _ -> 182 
  | FUNKY_OPERATOR_NAME _ -> 183 
  | ADJACENT_PREFIX_OP _ -> 184 
  | PLUS_MINUS_OP _ -> 185 
  | INFIX_AMP_OP _ -> 186 
  | INFIX_STAR_DIV_MOD_OP _ -> 187 
  | PREFIX_OP _ -> 188 
  | INFIX_BAR_OP _ -> 189 
  | INFIX_AT_HAT_OP _ -> 190 
  | INFIX_COMPARE_OP _ -> 191 
  | INFIX_STAR_STAR_OP _ -> 192 
  | HASH_IDENT _ -> 193 
  | IDENT _ -> 194 
  | KEYWORD_STRING _ -> 195 
  | LBRACE _ -> 196 
  | RBRACE _ -> 197 
  | INTERP_STRING_END _ -> 198 
  | INTERP_STRING_PART _ -> 199 
  | INTERP_STRING_BEGIN_PART _ -> 200 
  | INTERP_STRING_BEGIN_END _ -> 201 
  | STRING _ -> 202 
  | BYTEARRAY _ -> 203 

// This function maps integer indexes to symbolic token ids
let tokenTagToTokenId (tokenIdx:int) = 
  match tokenIdx with
  | 0 -> TOKEN_HASH_IF 
  | 1 -> TOKEN_HASH_ELSE 
  | 2 -> TOKEN_HASH_ENDIF 
  | 3 -> TOKEN_COMMENT 
  | 4 -> TOKEN_WHITESPACE 
  | 5 -> TOKEN_HASH_LINE 
  | 6 -> TOKEN_HASH_LIGHT 
  | 7 -> TOKEN_INACTIVECODE 
  | 8 -> TOKEN_LINE_COMMENT 
  | 9 -> TOKEN_STRING_TEXT 
  | 10 -> TOKEN_EOF 
  | 11 -> TOKEN_LEX_FAILURE 
  | 12 -> TOKEN_ODUMMY 
  | 13 -> TOKEN_FIXED 
  | 14 -> TOKEN_OINTERFACE_MEMBER 
  | 15 -> TOKEN_OBLOCKEND_COMING_SOON 
  | 16 -> TOKEN_OBLOCKEND_IS_HERE 
  | 17 -> TOKEN_OBLOCKEND 
  | 18 -> TOKEN_ORIGHT_BLOCK_END 
  | 19 -> TOKEN_ODECLEND 
  | 20 -> TOKEN_OEND 
  | 21 -> TOKEN_OBLOCKSEP 
  | 22 -> TOKEN_OBLOCKBEGIN 
  | 23 -> TOKEN_ORESET 
  | 24 -> TOKEN_OFUN 
  | 25 -> TOKEN_OFUNCTION 
  | 26 -> TOKEN_OWITH 
  | 27 -> TOKEN_OELSE 
  | 28 -> TOKEN_OTHEN 
  | 29 -> TOKEN_ODO_BANG 
  | 30 -> TOKEN_ODO 
  | 31 -> TOKEN_OAND_BANG 
  | 32 -> TOKEN_OBINDER 
  | 33 -> TOKEN_OLET 
  | 34 -> TOKEN_HIGH_PRECEDENCE_TYAPP 
  | 35 -> TOKEN_HIGH_PRECEDENCE_PAREN_APP 
  | 36 -> TOKEN_HIGH_PRECEDENCE_BRACK_APP 
  | 37 -> TOKEN_TYPE_COMING_SOON 
  | 38 -> TOKEN_TYPE_IS_HERE 
  | 39 -> TOKEN_MODULE_COMING_SOON 
  | 40 -> TOKEN_MODULE_IS_HERE 
  | 41 -> TOKEN_BAR_JUST_BEFORE_NULL 
  | 42 -> TOKEN_EXTERN 
  | 43 -> TOKEN_VOID 
  | 44 -> TOKEN_PUBLIC 
  | 45 -> TOKEN_PRIVATE 
  | 46 -> TOKEN_INTERNAL 
  | 47 -> TOKEN_GLOBAL 
  | 48 -> TOKEN_STATIC 
  | 49 -> TOKEN_MEMBER 
  | 50 -> TOKEN_CLASS 
  | 51 -> TOKEN_ABSTRACT 
  | 52 -> TOKEN_OVERRIDE 
  | 53 -> TOKEN_DEFAULT 
  | 54 -> TOKEN_CONSTRUCTOR 
  | 55 -> TOKEN_INHERIT 
  | 56 -> TOKEN_GREATER_RBRACK 
  | 57 -> TOKEN_STRUCT 
  | 58 -> TOKEN_SIG 
  | 59 -> TOKEN_BAR 
  | 60 -> TOKEN_RBRACK 
  | 61 -> TOKEN_RBRACE_COMING_SOON 
  | 62 -> TOKEN_RBRACE_IS_HERE 
  | 63 -> TOKEN_MINUS 
  | 64 -> TOKEN_DOLLAR 
  | 65 -> TOKEN_BAR_RBRACK 
  | 66 -> TOKEN_BAR_RBRACE 
  | 67 -> TOKEN_UNDERSCORE 
  | 68 -> TOKEN_SEMICOLON_SEMICOLON 
  | 69 -> TOKEN_LARROW 
  | 70 -> TOKEN_EQUALS 
  | 71 -> TOKEN_LBRACK 
  | 72 -> TOKEN_LBRACK_BAR 
  | 73 -> TOKEN_LBRACE_BAR 
  | 74 -> TOKEN_LBRACK_LESS 
  | 75 -> TOKEN_QMARK 
  | 76 -> TOKEN_QMARK_QMARK 
  | 77 -> TOKEN_DOT 
  | 78 -> TOKEN_COLON 
  | 79 -> TOKEN_COLON_COLON 
  | 80 -> TOKEN_COLON_GREATER 
  | 81 -> TOKEN_COLON_QMARK_GREATER 
  | 82 -> TOKEN_COLON_QMARK 
  | 83 -> TOKEN_COLON_EQUALS 
  | 84 -> TOKEN_SEMICOLON 
  | 85 -> TOKEN_WHEN 
  | 86 -> TOKEN_WHILE 
  | 87 -> TOKEN_WHILE_BANG 
  | 88 -> TOKEN_WITH 
  | 89 -> TOKEN_HASH 
  | 90 -> TOKEN_AMP 
  | 91 -> TOKEN_AMP_AMP 
  | 92 -> TOKEN_QUOTE 
  | 93 -> TOKEN_LPAREN 
  | 94 -> TOKEN_RPAREN 
  | 95 -> TOKEN_RPAREN_COMING_SOON 
  | 96 -> TOKEN_RPAREN_IS_HERE 
  | 97 -> TOKEN_STAR 
  | 98 -> TOKEN_COMMA 
  | 99 -> TOKEN_RARROW 
  | 100 -> TOKEN_GREATER_BAR_RBRACK 
  | 101 -> TOKEN_LPAREN_STAR_RPAREN 
  | 102 -> TOKEN_OPEN 
  | 103 -> TOKEN_OR 
  | 104 -> TOKEN_REC 
  | 105 -> TOKEN_THEN 
  | 106 -> TOKEN_TO 
  | 107 -> TOKEN_TRUE 
  | 108 -> TOKEN_TRY 
  | 109 -> TOKEN_TYPE 
  | 110 -> TOKEN_VAL 
  | 111 -> TOKEN_INLINE 
  | 112 -> TOKEN_INTERFACE 
  | 113 -> TOKEN_INSTANCE 
  | 114 -> TOKEN_CONST 
  | 115 -> TOKEN_LAZY 
  | 116 -> TOKEN_OLAZY 
  | 117 -> TOKEN_MATCH 
  | 118 -> TOKEN_MATCH_BANG 
  | 119 -> TOKEN_MUTABLE 
  | 120 -> TOKEN_NEW 
  | 121 -> TOKEN_OF 
  | 122 -> TOKEN_EXCEPTION 
  | 123 -> TOKEN_FALSE 
  | 124 -> TOKEN_FOR 
  | 125 -> TOKEN_FUN 
  | 126 -> TOKEN_FUNCTION 
  | 127 -> TOKEN_IF 
  | 128 -> TOKEN_IN 
  | 129 -> TOKEN_JOIN_IN 
  | 130 -> TOKEN_FINALLY 
  | 131 -> TOKEN_DO_BANG 
  | 132 -> TOKEN_AND 
  | 133 -> TOKEN_AS 
  | 134 -> TOKEN_ASSERT 
  | 135 -> TOKEN_OASSERT 
  | 136 -> TOKEN_ASR 
  | 137 -> TOKEN_BEGIN 
  | 138 -> TOKEN_DO 
  | 139 -> TOKEN_DONE 
  | 140 -> TOKEN_DOWNTO 
  | 141 -> TOKEN_ELSE 
  | 142 -> TOKEN_ELIF 
  | 143 -> TOKEN_END 
  | 144 -> TOKEN_DOT_DOT 
  | 145 -> TOKEN_DOT_DOT_HAT 
  | 146 -> TOKEN_BAR_BAR 
  | 147 -> TOKEN_UPCAST 
  | 148 -> TOKEN_DOWNCAST 
  | 149 -> TOKEN_NULL 
  | 150 -> TOKEN_RESERVED 
  | 151 -> TOKEN_MODULE 
  | 152 -> TOKEN_NAMESPACE 
  | 153 -> TOKEN_DELEGATE 
  | 154 -> TOKEN_CONSTRAINT 
  | 155 -> TOKEN_BASE 
  | 156 -> TOKEN_LQUOTE 
  | 157 -> TOKEN_RQUOTE 
  | 158 -> TOKEN_RQUOTE_DOT 
  | 159 -> TOKEN_PERCENT_OP 
  | 160 -> TOKEN_BINDER 
  | 161 -> TOKEN_LESS 
  | 162 -> TOKEN_GREATER 
  | 163 -> TOKEN_LET 
  | 164 -> TOKEN_YIELD 
  | 165 -> TOKEN_YIELD_BANG 
  | 166 -> TOKEN_AND_BANG 
  | 167 -> TOKEN_BIGNUM 
  | 168 -> TOKEN_DECIMAL 
  | 169 -> TOKEN_CHAR 
  | 170 -> TOKEN_IEEE64 
  | 171 -> TOKEN_IEEE32 
  | 172 -> TOKEN_UNATIVEINT 
  | 173 -> TOKEN_UINT64 
  | 174 -> TOKEN_UINT32 
  | 175 -> TOKEN_UINT16 
  | 176 -> TOKEN_UINT8 
  | 177 -> TOKEN_NATIVEINT 
  | 178 -> TOKEN_INT64 
  | 179 -> TOKEN_INT32 
  | 180 -> TOKEN_INT32_DOT_DOT 
  | 181 -> TOKEN_INT16 
  | 182 -> TOKEN_INT8 
  | 183 -> TOKEN_FUNKY_OPERATOR_NAME 
  | 184 -> TOKEN_ADJACENT_PREFIX_OP 
  | 185 -> TOKEN_PLUS_MINUS_OP 
  | 186 -> TOKEN_INFIX_AMP_OP 
  | 187 -> TOKEN_INFIX_STAR_DIV_MOD_OP 
  | 188 -> TOKEN_PREFIX_OP 
  | 189 -> TOKEN_INFIX_BAR_OP 
  | 190 -> TOKEN_INFIX_AT_HAT_OP 
  | 191 -> TOKEN_INFIX_COMPARE_OP 
  | 192 -> TOKEN_INFIX_STAR_STAR_OP 
  | 193 -> TOKEN_HASH_IDENT 
  | 194 -> TOKEN_IDENT 
  | 195 -> TOKEN_KEYWORD_STRING 
  | 196 -> TOKEN_LBRACE 
  | 197 -> TOKEN_RBRACE 
  | 198 -> TOKEN_INTERP_STRING_END 
  | 199 -> TOKEN_INTERP_STRING_PART 
  | 200 -> TOKEN_INTERP_STRING_BEGIN_PART 
  | 201 -> TOKEN_INTERP_STRING_BEGIN_END 
  | 202 -> TOKEN_STRING 
  | 203 -> TOKEN_BYTEARRAY 
  | 206 -> TOKEN_end_of_input
  | 204 -> TOKEN_error
  | _ -> failwith "tokenTagToTokenId: bad token"

/// This function maps production indexes returned in syntax errors to strings representing the non terminal that would be produced by that production
let prodIdxToNonTerminal (prodIdx:int) = 
  match prodIdx with
    | 0 -> NONTERM__startsignatureFile 
    | 1 -> NONTERM__startimplementationFile 
    | 2 -> NONTERM__startinteraction 
    | 3 -> NONTERM__starttypedSequentialExprEOF 
    | 4 -> NONTERM__starttypEOF 
    | 5 -> NONTERM_interaction 
    | 6 -> NONTERM_interaction 
    | 7 -> NONTERM_interaction 
    | 8 -> NONTERM_interactiveTerminator 
    | 9 -> NONTERM_interactiveTerminator 
    | 10 -> NONTERM_interactiveItemsTerminator 
    | 11 -> NONTERM_interactiveItemsTerminator 
    | 12 -> NONTERM_interactiveItemsTerminator 
    | 13 -> NONTERM_interactiveItemsTerminator 
    | 14 -> NONTERM_interactiveItemsTerminator 
    | 15 -> NONTERM_interactiveItemsTerminator 
    | 16 -> NONTERM_interactiveItemsTerminator 
    | 17 -> NONTERM_interactiveDefns 
    | 18 -> NONTERM_interactiveDefns 
    | 19 -> NONTERM_interactiveExpr 
    | 20 -> NONTERM_interactiveHash 
    | 21 -> NONTERM_interactiveSeparators 
    | 22 -> NONTERM_interactiveSeparators 
    | 23 -> NONTERM_interactiveSeparator 
    | 24 -> NONTERM_interactiveSeparator 
    | 25 -> NONTERM_hashDirective 
    | 26 -> NONTERM_hashDirectiveArgs 
    | 27 -> NONTERM_hashDirectiveArgs 
    | 28 -> NONTERM_hashDirectiveArg 
    | 29 -> NONTERM_hashDirectiveArg 
    | 30 -> NONTERM_hashDirectiveArg 
    | 31 -> NONTERM_hashDirectiveArg 
    | 32 -> NONTERM_hashDirectiveArg 
    | 33 -> NONTERM_signatureFile 
    | 34 -> NONTERM_signatureFile 
    | 35 -> NONTERM_signatureFile 
    | 36 -> NONTERM_moduleIntro 
    | 37 -> NONTERM_moduleIntro 
    | 38 -> NONTERM_moduleIntro 
    | 39 -> NONTERM_namespaceIntro 
    | 40 -> NONTERM_namespaceIntro 
    | 41 -> NONTERM_fileNamespaceSpecs 
    | 42 -> NONTERM_fileNamespaceSpecs 
    | 43 -> NONTERM_fileNamespaceSpecList 
    | 44 -> NONTERM_fileNamespaceSpecList 
    | 45 -> NONTERM_fileNamespaceSpec 
    | 46 -> NONTERM_fileModuleSpec 
    | 47 -> NONTERM_fileModuleSpec 
    | 48 -> NONTERM_moduleSpfnsPossiblyEmptyBlock 
    | 49 -> NONTERM_moduleSpfnsPossiblyEmptyBlock 
    | 50 -> NONTERM_moduleSpfnsPossiblyEmptyBlock 
    | 51 -> NONTERM_moduleSpfnsPossiblyEmptyBlock 
    | 52 -> NONTERM_moduleSpfnsPossiblyEmpty 
    | 53 -> NONTERM_moduleSpfnsPossiblyEmpty 
    | 54 -> NONTERM_moduleSpfnsPossiblyEmpty 
    | 55 -> NONTERM_moduleSpfns 
    | 56 -> NONTERM_moduleSpfns 
    | 57 -> NONTERM_moduleSpfns 
    | 58 -> NONTERM_moduleSpfn 
    | 59 -> NONTERM_moduleSpfn 
    | 60 -> NONTERM_moduleSpfn 
    | 61 -> NONTERM_moduleSpfn 
    | 62 -> NONTERM_moduleSpfn 
    | 63 -> NONTERM_moduleSpfn 
    | 64 -> NONTERM_moduleSpfn 
    | 65 -> NONTERM_moduleSpfn 
    | 66 -> NONTERM_valSpfn 
    | 67 -> NONTERM_optLiteralValueSpfn 
    | 68 -> NONTERM_optLiteralValueSpfn 
    | 69 -> NONTERM_optLiteralValueSpfn 
    | 70 -> NONTERM_moduleSpecBlock 
    | 71 -> NONTERM_moduleSpecBlock 
    | 72 -> NONTERM_moduleSpecBlock 
    | 73 -> NONTERM_tyconSpfnList 
    | 74 -> NONTERM_tyconSpfnList 
    | 75 -> NONTERM_tyconSpfn 
    | 76 -> NONTERM_tyconSpfn 
    | 77 -> NONTERM_tyconSpfnRhsBlock 
    | 78 -> NONTERM_tyconSpfnRhsBlock 
    | 79 -> NONTERM_tyconSpfnRhs 
    | 80 -> NONTERM_tyconSpfnRhs 
    | 81 -> NONTERM_tyconSpfnRhs 
    | 82 -> NONTERM_tyconClassSpfn 
    | 83 -> NONTERM_tyconClassSpfn 
    | 84 -> NONTERM_tyconClassSpfn 
    | 85 -> NONTERM_tyconClassSpfn 
    | 86 -> NONTERM_classSpfnBlockKindUnspecified 
    | 87 -> NONTERM_classSpfnBlockKindUnspecified 
    | 88 -> NONTERM_classSpfnBlockKindUnspecified 
    | 89 -> NONTERM_classSpfnBlockKindUnspecified 
    | 90 -> NONTERM_classSpfnBlock 
    | 91 -> NONTERM_classSpfnBlock 
    | 92 -> NONTERM_classSpfnBlock 
    | 93 -> NONTERM_classSpfnMembers 
    | 94 -> NONTERM_classSpfnMembers 
    | 95 -> NONTERM_classSpfnMembersAtLeastOne 
    | 96 -> NONTERM_classMemberSpfn 
    | 97 -> NONTERM_classMemberSpfn 
    | 98 -> NONTERM_classMemberSpfn 
    | 99 -> NONTERM_classMemberSpfn 
    | 100 -> NONTERM_classMemberSpfn 
    | 101 -> NONTERM_classMemberSpfn 
    | 102 -> NONTERM_classMemberSpfn 
    | 103 -> NONTERM_classMemberSpfn 
    | 104 -> NONTERM_classMemberSpfnGetSet 
    | 105 -> NONTERM_classMemberSpfnGetSet 
    | 106 -> NONTERM_classMemberSpfnGetSet 
    | 107 -> NONTERM_classMemberSpfnGetSet 
    | 108 -> NONTERM_classMemberSpfnGetSetElements 
    | 109 -> NONTERM_classMemberSpfnGetSetElements 
    | 110 -> NONTERM_classMemberSpfnGetSetElements 
    | 111 -> NONTERM_classMemberSpfnGetSetElements 
    | 112 -> NONTERM_memberSpecFlags 
    | 113 -> NONTERM_memberSpecFlags 
    | 114 -> NONTERM_exconSpfn 
    | 115 -> NONTERM_opt_classSpfn 
    | 116 -> NONTERM_opt_classSpfn 
    | 117 -> NONTERM_implementationFile 
    | 118 -> NONTERM_implementationFile 
    | 119 -> NONTERM_implementationFile 
    | 120 -> NONTERM_fileNamespaceImpls 
    | 121 -> NONTERM_fileNamespaceImpls 
    | 122 -> NONTERM_fileNamespaceImplList 
    | 123 -> NONTERM_fileNamespaceImplList 
    | 124 -> NONTERM_fileNamespaceImpl 
    | 125 -> NONTERM_fileModuleImpl 
    | 126 -> NONTERM_fileModuleImpl 
    | 127 -> NONTERM_moduleDefnsOrExprPossiblyEmptyOrBlock 
    | 128 -> NONTERM_moduleDefnsOrExprPossiblyEmptyOrBlock 
    | 129 -> NONTERM_moduleDefnsOrExprPossiblyEmptyOrBlock 
    | 130 -> NONTERM_moduleDefnsOrExprPossiblyEmptyOrBlock 
    | 131 -> NONTERM_moduleDefnsOrExprPossiblyEmpty 
    | 132 -> NONTERM_moduleDefnsOrExprPossiblyEmpty 
    | 133 -> NONTERM_moduleDefnsOrExpr 
    | 134 -> NONTERM_moduleDefnsOrExpr 
    | 135 -> NONTERM_moduleDefnsOrExpr 
    | 136 -> NONTERM_moduleDefnsOrExpr 
    | 137 -> NONTERM_moduleDefnsOrExpr 
    | 138 -> NONTERM_moduleDefns 
    | 139 -> NONTERM_moduleDefns 
    | 140 -> NONTERM_moduleDefns 
    | 141 -> NONTERM_moduleDefns 
    | 142 -> NONTERM_moduleDefns 
    | 143 -> NONTERM_moduleDefnOrDirective 
    | 144 -> NONTERM_moduleDefnOrDirective 
    | 145 -> NONTERM_moduleDefn 
    | 146 -> NONTERM_moduleDefn 
    | 147 -> NONTERM_moduleDefn 
    | 148 -> NONTERM_moduleDefn 
    | 149 -> NONTERM_moduleDefn 
    | 150 -> NONTERM_moduleDefn 
    | 151 -> NONTERM_moduleDefn 
    | 152 -> NONTERM_moduleDefn 
    | 153 -> NONTERM_moduleDefn 
    | 154 -> NONTERM_openDecl 
    | 155 -> NONTERM_openDecl 
    | 156 -> NONTERM_openDecl 
    | 157 -> NONTERM_openDecl 
    | 158 -> NONTERM_namedModuleAbbrevBlock 
    | 159 -> NONTERM_namedModuleAbbrevBlock 
    | 160 -> NONTERM_namedModuleDefnBlock 
    | 161 -> NONTERM_namedModuleDefnBlock 
    | 162 -> NONTERM_namedModuleDefnBlock 
    | 163 -> NONTERM_namedModuleDefnBlock 
    | 164 -> NONTERM_namedModuleDefnBlock 
    | 165 -> NONTERM_namedModuleDefnBlock 
    | 166 -> NONTERM_namedModuleDefnBlock 
    | 167 -> NONTERM_wrappedNamedModuleDefn 
    | 168 -> NONTERM_wrappedNamedModuleDefn 
    | 169 -> NONTERM_wrappedNamedModuleDefn 
    | 170 -> NONTERM_tyconDefnAugmentation 
    | 171 -> NONTERM_opt_attributes 
    | 172 -> NONTERM_opt_attributes 
    | 173 -> NONTERM_attributes 
    | 174 -> NONTERM_attributes 
    | 175 -> NONTERM_attributeList 
    | 176 -> NONTERM_attributeList 
    | 177 -> NONTERM_attributeList 
    | 178 -> NONTERM_attributeList 
    | 179 -> NONTERM_attributeListElements 
    | 180 -> NONTERM_attributeListElements 
    | 181 -> NONTERM_attribute 
    | 182 -> NONTERM_attribute 
    | 183 -> NONTERM_attribute 
    | 184 -> NONTERM_attributeTarget 
    | 185 -> NONTERM_attributeTarget 
    | 186 -> NONTERM_attributeTarget 
    | 187 -> NONTERM_attributeTarget 
    | 188 -> NONTERM_memberFlags 
    | 189 -> NONTERM_memberFlags 
    | 190 -> NONTERM_memberFlags 
    | 191 -> NONTERM_memberFlags 
    | 192 -> NONTERM_memberFlags 
    | 193 -> NONTERM_typeNameInfo 
    | 194 -> NONTERM_tyconDefnList 
    | 195 -> NONTERM_tyconDefnList 
    | 196 -> NONTERM_tyconDefn 
    | 197 -> NONTERM_tyconDefn 
    | 198 -> NONTERM_tyconDefn 
    | 199 -> NONTERM_tyconDefn 
    | 200 -> NONTERM_tyconDefnRhsBlock 
    | 201 -> NONTERM_tyconDefnRhsBlock 
    | 202 -> NONTERM_tyconDefnRhsBlock 
    | 203 -> NONTERM_tyconDefnRhsBlock 
    | 204 -> NONTERM_tyconDefnRhs 
    | 205 -> NONTERM_tyconDefnRhs 
    | 206 -> NONTERM_tyconDefnRhs 
    | 207 -> NONTERM_tyconClassDefn 
    | 208 -> NONTERM_tyconClassDefn 
    | 209 -> NONTERM_tyconClassDefn 
    | 210 -> NONTERM_tyconClassDefn 
    | 211 -> NONTERM_classDefnBlockKindUnspecified 
    | 212 -> NONTERM_classDefnBlockKindUnspecified 
    | 213 -> NONTERM_classDefnBlock 
    | 214 -> NONTERM_classDefnBlock 
    | 215 -> NONTERM_classDefnBlock 
    | 216 -> NONTERM_classDefnMembers 
    | 217 -> NONTERM_classDefnMembers 
    | 218 -> NONTERM_classDefnMembers 
    | 219 -> NONTERM_classDefnMembersAtLeastOne 
    | 220 -> NONTERM_classDefnMemberGetSet 
    | 221 -> NONTERM_classDefnMemberGetSet 
    | 222 -> NONTERM_classDefnMemberGetSet 
    | 223 -> NONTERM_classDefnMemberGetSetElements 
    | 224 -> NONTERM_classDefnMemberGetSetElements 
    | 225 -> NONTERM_classDefnMemberGetSetElement 
    | 226 -> NONTERM_memberCore 
    | 227 -> NONTERM_memberCore 
    | 228 -> NONTERM_memberCore 
    | 229 -> NONTERM_memberCore 
    | 230 -> NONTERM_abstractMemberFlags 
    | 231 -> NONTERM_abstractMemberFlags 
    | 232 -> NONTERM_abstractMemberFlags 
    | 233 -> NONTERM_abstractMemberFlags 
    | 234 -> NONTERM_classDefnMember 
    | 235 -> NONTERM_classDefnMember 
    | 236 -> NONTERM_classDefnMember 
    | 237 -> NONTERM_classDefnMember 
    | 238 -> NONTERM_classDefnMember 
    | 239 -> NONTERM_classDefnMember 
    | 240 -> NONTERM_classDefnMember 
    | 241 -> NONTERM_classDefnMember 
    | 242 -> NONTERM_classDefnMember 
    | 243 -> NONTERM_classDefnMember 
    | 244 -> NONTERM_classDefnMember 
    | 245 -> NONTERM_classDefnMember 
    | 246 -> NONTERM_classDefnMember 
    | 247 -> NONTERM_classDefnMember 
    | 248 -> NONTERM_classDefnMember 
    | 249 -> NONTERM_classDefnMember 
    | 250 -> NONTERM_valDefnDecl 
    | 251 -> NONTERM_valDefnDecl 
    | 252 -> NONTERM_valDefnDecl 
    | 253 -> NONTERM_valDefnDecl 
    | 254 -> NONTERM_autoPropsDefnDecl 
    | 255 -> NONTERM_autoPropsDefnDecl 
    | 256 -> NONTERM_autoPropsDefnDecl 
    | 257 -> NONTERM_autoPropsDefnDecl 
    | 258 -> NONTERM_opt_typ 
    | 259 -> NONTERM_opt_typ 
    | 260 -> NONTERM_opt_typ 
    | 261 -> NONTERM_atomicPatternLongIdent 
    | 262 -> NONTERM_atomicPatternLongIdent 
    | 263 -> NONTERM_atomicPatternLongIdent 
    | 264 -> NONTERM_atomicPatternLongIdent 
    | 265 -> NONTERM_atomicPatternLongIdent 
    | 266 -> NONTERM_opt_access 
    | 267 -> NONTERM_opt_access 
    | 268 -> NONTERM_access 
    | 269 -> NONTERM_access 
    | 270 -> NONTERM_access 
    | 271 -> NONTERM_opt_interfaceImplDefn 
    | 272 -> NONTERM_opt_interfaceImplDefn 
    | 273 -> NONTERM_opt_interfaceImplDefn 
    | 274 -> NONTERM_opt_classDefn 
    | 275 -> NONTERM_opt_classDefn 
    | 276 -> NONTERM_inheritsDefn 
    | 277 -> NONTERM_inheritsDefn 
    | 278 -> NONTERM_inheritsDefn 
    | 279 -> NONTERM_optAsSpec 
    | 280 -> NONTERM_optAsSpec 
    | 281 -> NONTERM_asSpec 
    | 282 -> NONTERM_asSpec 
    | 283 -> NONTERM_optBaseSpec 
    | 284 -> NONTERM_optBaseSpec 
    | 285 -> NONTERM_baseSpec 
    | 286 -> NONTERM_baseSpec 
    | 287 -> NONTERM_objectImplementationBlock 
    | 288 -> NONTERM_objectImplementationBlock 
    | 289 -> NONTERM_objectImplementationBlock 
    | 290 -> NONTERM_objectImplementationMembers 
    | 291 -> NONTERM_objectImplementationMembers 
    | 292 -> NONTERM_objectImplementationMember 
    | 293 -> NONTERM_objectImplementationMember 
    | 294 -> NONTERM_objectImplementationMember 
    | 295 -> NONTERM_objectImplementationMember 
    | 296 -> NONTERM_staticMemberOrMemberOrOverride 
    | 297 -> NONTERM_staticMemberOrMemberOrOverride 
    | 298 -> NONTERM_staticMemberOrMemberOrOverride 
    | 299 -> NONTERM_tyconDefnOrSpfnSimpleRepr 
    | 300 -> NONTERM_tyconDefnOrSpfnSimpleRepr 
    | 301 -> NONTERM_tyconDefnOrSpfnSimpleRepr 
    | 302 -> NONTERM_tyconDefnOrSpfnSimpleRepr 
    | 303 -> NONTERM_tyconDefnOrSpfnSimpleRepr 
    | 304 -> NONTERM_braceFieldDeclList 
    | 305 -> NONTERM_braceFieldDeclList 
    | 306 -> NONTERM_braceFieldDeclList 
    | 307 -> NONTERM_braceFieldDeclList 
    | 308 -> NONTERM_anonRecdType 
    | 309 -> NONTERM_anonRecdType 
    | 310 -> NONTERM_braceBarFieldDeclListCore 
    | 311 -> NONTERM_braceBarFieldDeclListCore 
    | 312 -> NONTERM_braceBarFieldDeclListCore 
    | 313 -> NONTERM_classOrInterfaceOrStruct 
    | 314 -> NONTERM_classOrInterfaceOrStruct 
    | 315 -> NONTERM_classOrInterfaceOrStruct 
    | 316 -> NONTERM_interfaceMember 
    | 317 -> NONTERM_interfaceMember 
    | 318 -> NONTERM_tyconNameAndTyparDecls 
    | 319 -> NONTERM_tyconNameAndTyparDecls 
    | 320 -> NONTERM_tyconNameAndTyparDecls 
    | 321 -> NONTERM_tyconNameAndTyparDecls 
    | 322 -> NONTERM_prefixTyparDecls 
    | 323 -> NONTERM_prefixTyparDecls 
    | 324 -> NONTERM_typarDeclList 
    | 325 -> NONTERM_typarDeclList 
    | 326 -> NONTERM_typarDecl 
    | 327 -> NONTERM_typarDecl 
    | 328 -> NONTERM_postfixTyparDecls 
    | 329 -> NONTERM_explicitValTyparDeclsCore 
    | 330 -> NONTERM_explicitValTyparDeclsCore 
    | 331 -> NONTERM_explicitValTyparDeclsCore 
    | 332 -> NONTERM_explicitValTyparDecls 
    | 333 -> NONTERM_opt_explicitValTyparDecls 
    | 334 -> NONTERM_opt_explicitValTyparDecls 
    | 335 -> NONTERM_hashConstraint 
    | 336 -> NONTERM_opt_typeConstraints 
    | 337 -> NONTERM_opt_typeConstraints 
    | 338 -> NONTERM_typeConstraints 
    | 339 -> NONTERM_typeConstraints 
    | 340 -> NONTERM_intersectionConstraints 
    | 341 -> NONTERM_intersectionConstraints 
    | 342 -> NONTERM_intersectionConstraints 
    | 343 -> NONTERM_intersectionConstraints 
    | 344 -> NONTERM_typeConstraint 
    | 345 -> NONTERM_typeConstraint 
    | 346 -> NONTERM_typeConstraint 
    | 347 -> NONTERM_typeConstraint 
    | 348 -> NONTERM_typeConstraint 
    | 349 -> NONTERM_typeConstraint 
    | 350 -> NONTERM_typeConstraint 
    | 351 -> NONTERM_typeConstraint 
    | 352 -> NONTERM_typeConstraint 
    | 353 -> NONTERM_typeConstraint 
    | 354 -> NONTERM_typeConstraint 
    | 355 -> NONTERM_typeConstraint 
    | 356 -> NONTERM_typeAlts 
    | 357 -> NONTERM_typeAlts 
    | 358 -> NONTERM_unionTypeRepr 
    | 359 -> NONTERM_unionTypeRepr 
    | 360 -> NONTERM_unionTypeRepr 
    | 361 -> NONTERM_barAndgrabXmlDoc 
    | 362 -> NONTERM_attrUnionCaseDecls 
    | 363 -> NONTERM_attrUnionCaseDecls 
    | 364 -> NONTERM_attrUnionCaseDecl 
    | 365 -> NONTERM_attrUnionCaseDecl 
    | 366 -> NONTERM_attrUnionCaseDecl 
    | 367 -> NONTERM_attrUnionCaseDecl 
    | 368 -> NONTERM_attrUnionCaseDecl 
    | 369 -> NONTERM_attrUnionCaseDecl 
    | 370 -> NONTERM_attrUnionCaseDecl 
    | 371 -> NONTERM_attrUnionCaseDecl 
    | 372 -> NONTERM_attrUnionCaseDecl 
    | 373 -> NONTERM_attrUnionCaseDecl 
    | 374 -> NONTERM_unionCaseName 
    | 375 -> NONTERM_unionCaseName 
    | 376 -> NONTERM_unionCaseName 
    | 377 -> NONTERM_firstUnionCaseDeclOfMany 
    | 378 -> NONTERM_firstUnionCaseDeclOfMany 
    | 379 -> NONTERM_firstUnionCaseDeclOfMany 
    | 380 -> NONTERM_firstUnionCaseDeclOfMany 
    | 381 -> NONTERM_firstUnionCaseDecl 
    | 382 -> NONTERM_firstUnionCaseDecl 
    | 383 -> NONTERM_firstUnionCaseDecl 
    | 384 -> NONTERM_firstUnionCaseDecl 
    | 385 -> NONTERM_firstUnionCaseDecl 
    | 386 -> NONTERM_firstUnionCaseDecl 
    | 387 -> NONTERM_unionCaseReprElements 
    | 388 -> NONTERM_unionCaseReprElements 
    | 389 -> NONTERM_unionCaseReprElements 
    | 390 -> NONTERM_unionCaseReprElements 
    | 391 -> NONTERM_unionCaseReprElement 
    | 392 -> NONTERM_unionCaseReprElement 
    | 393 -> NONTERM_unionCaseReprElement 
    | 394 -> NONTERM_unionCaseReprElement 
    | 395 -> NONTERM_unionCaseReprElement 
    | 396 -> NONTERM_unionCaseRepr 
    | 397 -> NONTERM_unionCaseRepr 
    | 398 -> NONTERM_recdFieldDeclList 
    | 399 -> NONTERM_recdFieldDeclList 
    | 400 -> NONTERM_recdFieldDecl 
    | 401 -> NONTERM_fieldDecl 
    | 402 -> NONTERM_fieldDecl 
    | 403 -> NONTERM_fieldDecl 
    | 404 -> NONTERM_fieldDecl 
    | 405 -> NONTERM_exconDefn 
    | 406 -> NONTERM_exconCore 
    | 407 -> NONTERM_exconCore 
    | 408 -> NONTERM_exconIntro 
    | 409 -> NONTERM_exconIntro 
    | 410 -> NONTERM_exconIntro 
    | 411 -> NONTERM_exconRepr 
    | 412 -> NONTERM_exconRepr 
    | 413 -> NONTERM_defnBindings 
    | 414 -> NONTERM_defnBindings 
    | 415 -> NONTERM_doBinding 
    | 416 -> NONTERM_hardwhiteLetBindings 
    | 417 -> NONTERM_hardwhiteDoBinding 
    | 418 -> NONTERM_hardwhiteDoBinding 
    | 419 -> NONTERM_classDefnBindings 
    | 420 -> NONTERM_classDefnBindings 
    | 421 -> NONTERM_classDefnBindings 
    | 422 -> NONTERM_classDefnBindings 
    | 423 -> NONTERM_hardwhiteDefnBindingsTerminator 
    | 424 -> NONTERM_hardwhiteDefnBindingsTerminator 
    | 425 -> NONTERM_cPrototype 
    | 426 -> NONTERM_externArgs 
    | 427 -> NONTERM_externArgs 
    | 428 -> NONTERM_externArgs 
    | 429 -> NONTERM_externMoreArgs 
    | 430 -> NONTERM_externMoreArgs 
    | 431 -> NONTERM_externArg 
    | 432 -> NONTERM_externArg 
    | 433 -> NONTERM_cType 
    | 434 -> NONTERM_cType 
    | 435 -> NONTERM_cType 
    | 436 -> NONTERM_cType 
    | 437 -> NONTERM_cType 
    | 438 -> NONTERM_cType 
    | 439 -> NONTERM_cRetType 
    | 440 -> NONTERM_cRetType 
    | 441 -> NONTERM_localBindings 
    | 442 -> NONTERM_moreLocalBindings 
    | 443 -> NONTERM_moreLocalBindings 
    | 444 -> NONTERM_attr_localBinding 
    | 445 -> NONTERM_attr_localBinding 
    | 446 -> NONTERM_localBinding 
    | 447 -> NONTERM_localBinding 
    | 448 -> NONTERM_localBinding 
    | 449 -> NONTERM_typedExprWithStaticOptimizationsBlock 
    | 450 -> NONTERM_typedExprWithStaticOptimizationsBlock 
    | 451 -> NONTERM_typedExprWithStaticOptimizationsBlock 
    | 452 -> NONTERM_typedExprWithStaticOptimizations 
    | 453 -> NONTERM_opt_staticOptimizations 
    | 454 -> NONTERM_opt_staticOptimizations 
    | 455 -> NONTERM_staticOptimization 
    | 456 -> NONTERM_staticOptimizationConditions 
    | 457 -> NONTERM_staticOptimizationConditions 
    | 458 -> NONTERM_staticOptimizationCondition 
    | 459 -> NONTERM_staticOptimizationCondition 
    | 460 -> NONTERM_rawConstant 
    | 461 -> NONTERM_rawConstant 
    | 462 -> NONTERM_rawConstant 
    | 463 -> NONTERM_rawConstant 
    | 464 -> NONTERM_rawConstant 
    | 465 -> NONTERM_rawConstant 
    | 466 -> NONTERM_rawConstant 
    | 467 -> NONTERM_rawConstant 
    | 468 -> NONTERM_rawConstant 
    | 469 -> NONTERM_rawConstant 
    | 470 -> NONTERM_rawConstant 
    | 471 -> NONTERM_rawConstant 
    | 472 -> NONTERM_rawConstant 
    | 473 -> NONTERM_rawConstant 
    | 474 -> NONTERM_rawConstant 
    | 475 -> NONTERM_rawConstant 
    | 476 -> NONTERM_rawConstant 
    | 477 -> NONTERM_rawConstant 
    | 478 -> NONTERM_rationalConstant 
    | 479 -> NONTERM_rationalConstant 
    | 480 -> NONTERM_rationalConstant 
    | 481 -> NONTERM_rationalConstant 
    | 482 -> NONTERM_atomicUnsignedRationalConstant 
    | 483 -> NONTERM_atomicUnsignedRationalConstant 
    | 484 -> NONTERM_atomicRationalConstant 
    | 485 -> NONTERM_atomicRationalConstant 
    | 486 -> NONTERM_constant 
    | 487 -> NONTERM_constant 
    | 488 -> NONTERM_bindingPattern 
    | 489 -> NONTERM_opt_simplePatterns 
    | 490 -> NONTERM_opt_simplePatterns 
    | 491 -> NONTERM_simplePatterns 
    | 492 -> NONTERM_simplePatterns 
    | 493 -> NONTERM_barCanBeRightBeforeNull 
    | 494 -> NONTERM_barCanBeRightBeforeNull 
    | 495 -> NONTERM_headBindingPattern 
    | 496 -> NONTERM_headBindingPattern 
    | 497 -> NONTERM_headBindingPattern 
    | 498 -> NONTERM_headBindingPattern 
    | 499 -> NONTERM_headBindingPattern 
    | 500 -> NONTERM_headBindingPattern 
    | 501 -> NONTERM_headBindingPattern 
    | 502 -> NONTERM_headBindingPattern 
    | 503 -> NONTERM_headBindingPattern 
    | 504 -> NONTERM_headBindingPattern 
    | 505 -> NONTERM_tuplePatternElements 
    | 506 -> NONTERM_tuplePatternElements 
    | 507 -> NONTERM_tuplePatternElements 
    | 508 -> NONTERM_tuplePatternElements 
    | 509 -> NONTERM_tuplePatternElements 
    | 510 -> NONTERM_tuplePatternElements 
    | 511 -> NONTERM_conjPatternElements 
    | 512 -> NONTERM_conjPatternElements 
    | 513 -> NONTERM_namePatPairs 
    | 514 -> NONTERM_namePatPairs 
    | 515 -> NONTERM_namePatPairs 
    | 516 -> NONTERM_namePatPair 
    | 517 -> NONTERM_namePatPair 
    | 518 -> NONTERM_namePatPair 
    | 519 -> NONTERM_constrPattern 
    | 520 -> NONTERM_constrPattern 
    | 521 -> NONTERM_constrPattern 
    | 522 -> NONTERM_constrPattern 
    | 523 -> NONTERM_constrPattern 
    | 524 -> NONTERM_constrPattern 
    | 525 -> NONTERM_constrPattern 
    | 526 -> NONTERM_constrPattern 
    | 527 -> NONTERM_constrPattern 
    | 528 -> NONTERM_constrPattern 
    | 529 -> NONTERM_constrPattern 
    | 530 -> NONTERM_atomicPatsOrNamePatPairs 
    | 531 -> NONTERM_atomicPatsOrNamePatPairs 
    | 532 -> NONTERM_atomicPatterns 
    | 533 -> NONTERM_atomicPatterns 
    | 534 -> NONTERM_atomicPatterns 
    | 535 -> NONTERM_atomicPatterns 
    | 536 -> NONTERM_atomicPattern 
    | 537 -> NONTERM_atomicPattern 
    | 538 -> NONTERM_atomicPattern 
    | 539 -> NONTERM_atomicPattern 
    | 540 -> NONTERM_atomicPattern 
    | 541 -> NONTERM_atomicPattern 
    | 542 -> NONTERM_atomicPattern 
    | 543 -> NONTERM_atomicPattern 
    | 544 -> NONTERM_atomicPattern 
    | 545 -> NONTERM_atomicPattern 
    | 546 -> NONTERM_atomicPattern 
    | 547 -> NONTERM_atomicPattern 
    | 548 -> NONTERM_atomicPattern 
    | 549 -> NONTERM_atomicPattern 
    | 550 -> NONTERM_atomicPattern 
    | 551 -> NONTERM_atomicPattern 
    | 552 -> NONTERM_atomicPattern 
    | 553 -> NONTERM_atomicPattern 
    | 554 -> NONTERM_atomicPattern 
    | 555 -> NONTERM_atomicPattern 
    | 556 -> NONTERM_parenPatternBody 
    | 557 -> NONTERM_parenPatternBody 
    | 558 -> NONTERM_parenPattern 
    | 559 -> NONTERM_parenPattern 
    | 560 -> NONTERM_parenPattern 
    | 561 -> NONTERM_parenPattern 
    | 562 -> NONTERM_parenPattern 
    | 563 -> NONTERM_parenPattern 
    | 564 -> NONTERM_parenPattern 
    | 565 -> NONTERM_parenPattern 
    | 566 -> NONTERM_parenPattern 
    | 567 -> NONTERM_parenPattern 
    | 568 -> NONTERM_parenPattern 
    | 569 -> NONTERM_parenPattern 
    | 570 -> NONTERM_parenPattern 
    | 571 -> NONTERM_tupleParenPatternElements 
    | 572 -> NONTERM_tupleParenPatternElements 
    | 573 -> NONTERM_tupleParenPatternElements 
    | 574 -> NONTERM_tupleParenPatternElements 
    | 575 -> NONTERM_tupleParenPatternElements 
    | 576 -> NONTERM_tupleParenPatternElements 
    | 577 -> NONTERM_conjParenPatternElements 
    | 578 -> NONTERM_conjParenPatternElements 
    | 579 -> NONTERM_recordPatternElementsAux 
    | 580 -> NONTERM_recordPatternElementsAux 
    | 581 -> NONTERM_recordPatternElement 
    | 582 -> NONTERM_recordPatternElement 
    | 583 -> NONTERM_recordPatternElement 
    | 584 -> NONTERM_listPatternElements 
    | 585 -> NONTERM_listPatternElements 
    | 586 -> NONTERM_listPatternElements 
    | 587 -> NONTERM_typedSequentialExprBlock 
    | 588 -> NONTERM_typedSequentialExprBlock 
    | 589 -> NONTERM_typedSequentialExprBlock 
    | 590 -> NONTERM_typedSequentialExprBlock 
    | 591 -> NONTERM_declExprBlock 
    | 592 -> NONTERM_declExprBlock 
    | 593 -> NONTERM_declExprBlock 
    | 594 -> NONTERM_typedSequentialExprBlockR 
    | 595 -> NONTERM_typedSequentialExprBlockR 
    | 596 -> NONTERM_typedSequentialExprBlockR 
    | 597 -> NONTERM_typedSequentialExpr 
    | 598 -> NONTERM_typedSequentialExpr 
    | 599 -> NONTERM_typedSequentialExpr 
    | 600 -> NONTERM_typedSequentialExprEOF 
    | 601 -> NONTERM_sequentialExpr 
    | 602 -> NONTERM_sequentialExpr 
    | 603 -> NONTERM_sequentialExpr 
    | 604 -> NONTERM_sequentialExpr 
    | 605 -> NONTERM_sequentialExpr 
    | 606 -> NONTERM_sequentialExpr 
    | 607 -> NONTERM_recover 
    | 608 -> NONTERM_recover 
    | 609 -> NONTERM_moreBinders 
    | 610 -> NONTERM_moreBinders 
    | 611 -> NONTERM_moreBinders 
    | 612 -> NONTERM_declExpr 
    | 613 -> NONTERM_declExpr 
    | 614 -> NONTERM_declExpr 
    | 615 -> NONTERM_declExpr 
    | 616 -> NONTERM_declExpr 
    | 617 -> NONTERM_declExpr 
    | 618 -> NONTERM_declExpr 
    | 619 -> NONTERM_declExpr 
    | 620 -> NONTERM_declExpr 
    | 621 -> NONTERM_declExpr 
    | 622 -> NONTERM_declExpr 
    | 623 -> NONTERM_declExpr 
    | 624 -> NONTERM_declExpr 
    | 625 -> NONTERM_declExpr 
    | 626 -> NONTERM_declExpr 
    | 627 -> NONTERM_declExpr 
    | 628 -> NONTERM_declExpr 
    | 629 -> NONTERM_declExpr 
    | 630 -> NONTERM_declExpr 
    | 631 -> NONTERM_declExpr 
    | 632 -> NONTERM_declExpr 
    | 633 -> NONTERM_declExpr 
    | 634 -> NONTERM_declExpr 
    | 635 -> NONTERM_declExpr 
    | 636 -> NONTERM_declExpr 
    | 637 -> NONTERM_declExpr 
    | 638 -> NONTERM_declExpr 
    | 639 -> NONTERM_declExpr 
    | 640 -> NONTERM_declExpr 
    | 641 -> NONTERM_declExpr 
    | 642 -> NONTERM_declExpr 
    | 643 -> NONTERM_declExpr 
    | 644 -> NONTERM_declExpr 
    | 645 -> NONTERM_declExpr 
    | 646 -> NONTERM_declExpr 
    | 647 -> NONTERM_declExpr 
    | 648 -> NONTERM_declExpr 
    | 649 -> NONTERM_declExpr 
    | 650 -> NONTERM_declExpr 
    | 651 -> NONTERM_declExpr 
    | 652 -> NONTERM_declExpr 
    | 653 -> NONTERM_declExpr 
    | 654 -> NONTERM_declExpr 
    | 655 -> NONTERM_declExpr 
    | 656 -> NONTERM_declExpr 
    | 657 -> NONTERM_declExpr 
    | 658 -> NONTERM_declExpr 
    | 659 -> NONTERM_declExpr 
    | 660 -> NONTERM_declExpr 
    | 661 -> NONTERM_declExpr 
    | 662 -> NONTERM_declExpr 
    | 663 -> NONTERM_declExpr 
    | 664 -> NONTERM_declExpr 
    | 665 -> NONTERM_declExpr 
    | 666 -> NONTERM_declExpr 
    | 667 -> NONTERM_declExpr 
    | 668 -> NONTERM_declExpr 
    | 669 -> NONTERM_declExpr 
    | 670 -> NONTERM_declExpr 
    | 671 -> NONTERM_declExpr 
    | 672 -> NONTERM_declExpr 
    | 673 -> NONTERM_declExpr 
    | 674 -> NONTERM_declExpr 
    | 675 -> NONTERM_declExpr 
    | 676 -> NONTERM_declExpr 
    | 677 -> NONTERM_declExpr 
    | 678 -> NONTERM_declExpr 
    | 679 -> NONTERM_declExpr 
    | 680 -> NONTERM_declExpr 
    | 681 -> NONTERM_declExpr 
    | 682 -> NONTERM_declExpr 
    | 683 -> NONTERM_declExpr 
    | 684 -> NONTERM_declExpr 
    | 685 -> NONTERM_declExpr 
    | 686 -> NONTERM_declExpr 
    | 687 -> NONTERM_declExpr 
    | 688 -> NONTERM_declExpr 
    | 689 -> NONTERM_declExpr 
    | 690 -> NONTERM_declExpr 
    | 691 -> NONTERM_declExpr 
    | 692 -> NONTERM_declExpr 
    | 693 -> NONTERM_declExpr 
    | 694 -> NONTERM_declExpr 
    | 695 -> NONTERM_declExpr 
    | 696 -> NONTERM_declExpr 
    | 697 -> NONTERM_declExpr 
    | 698 -> NONTERM_declExpr 
    | 699 -> NONTERM_declExpr 
    | 700 -> NONTERM_declExpr 
    | 701 -> NONTERM_declExpr 
    | 702 -> NONTERM_declExpr 
    | 703 -> NONTERM_declExpr 
    | 704 -> NONTERM_declExpr 
    | 705 -> NONTERM_declExpr 
    | 706 -> NONTERM_declExpr 
    | 707 -> NONTERM_declExpr 
    | 708 -> NONTERM_declExpr 
    | 709 -> NONTERM_declExpr 
    | 710 -> NONTERM_declExpr 
    | 711 -> NONTERM_declExpr 
    | 712 -> NONTERM_declExpr 
    | 713 -> NONTERM_declExpr 
    | 714 -> NONTERM_declExpr 
    | 715 -> NONTERM_declExpr 
    | 716 -> NONTERM_declExpr 
    | 717 -> NONTERM_declExpr 
    | 718 -> NONTERM_declExpr 
    | 719 -> NONTERM_declExpr 
    | 720 -> NONTERM_declExpr 
    | 721 -> NONTERM_whileExprCore 
    | 722 -> NONTERM_whileExprCore 
    | 723 -> NONTERM_whileExprCore 
    | 724 -> NONTERM_whileExprCore 
    | 725 -> NONTERM_whileExprCore 
    | 726 -> NONTERM_whileExprCore 
    | 727 -> NONTERM_dynamicArg 
    | 728 -> NONTERM_dynamicArg 
    | 729 -> NONTERM_withClauses 
    | 730 -> NONTERM_withClauses 
    | 731 -> NONTERM_withClauses 
    | 732 -> NONTERM_withClauses 
    | 733 -> NONTERM_withPatternClauses 
    | 734 -> NONTERM_withPatternClauses 
    | 735 -> NONTERM_withPatternClauses 
    | 736 -> NONTERM_withPatternClauses 
    | 737 -> NONTERM_withPatternClauses 
    | 738 -> NONTERM_patternAndGuard 
    | 739 -> NONTERM_patternClauses 
    | 740 -> NONTERM_patternClauses 
    | 741 -> NONTERM_patternClauses 
    | 742 -> NONTERM_patternClauses 
    | 743 -> NONTERM_patternClauses 
    | 744 -> NONTERM_patternClauses 
    | 745 -> NONTERM_patternClauses 
    | 746 -> NONTERM_patternGuard 
    | 747 -> NONTERM_patternGuard 
    | 748 -> NONTERM_patternResult 
    | 749 -> NONTERM_ifExprCases 
    | 750 -> NONTERM_ifExprThen 
    | 751 -> NONTERM_ifExprThen 
    | 752 -> NONTERM_ifExprThen 
    | 753 -> NONTERM_ifExprThen 
    | 754 -> NONTERM_ifExprElifs 
    | 755 -> NONTERM_ifExprElifs 
    | 756 -> NONTERM_ifExprElifs 
    | 757 -> NONTERM_ifExprElifs 
    | 758 -> NONTERM_ifExprElifs 
    | 759 -> NONTERM_tupleExpr 
    | 760 -> NONTERM_tupleExpr 
    | 761 -> NONTERM_tupleExpr 
    | 762 -> NONTERM_tupleExpr 
    | 763 -> NONTERM_tupleExpr 
    | 764 -> NONTERM_tupleExpr 
    | 765 -> NONTERM_tupleExpr 
    | 766 -> NONTERM_tupleExpr 
    | 767 -> NONTERM_minusExpr 
    | 768 -> NONTERM_minusExpr 
    | 769 -> NONTERM_minusExpr 
    | 770 -> NONTERM_minusExpr 
    | 771 -> NONTERM_minusExpr 
    | 772 -> NONTERM_minusExpr 
    | 773 -> NONTERM_minusExpr 
    | 774 -> NONTERM_minusExpr 
    | 775 -> NONTERM_minusExpr 
    | 776 -> NONTERM_minusExpr 
    | 777 -> NONTERM_minusExpr 
    | 778 -> NONTERM_minusExpr 
    | 779 -> NONTERM_minusExpr 
    | 780 -> NONTERM_minusExpr 
    | 781 -> NONTERM_appExpr 
    | 782 -> NONTERM_appExpr 
    | 783 -> NONTERM_argExpr 
    | 784 -> NONTERM_argExpr 
    | 785 -> NONTERM_atomicExpr 
    | 786 -> NONTERM_atomicExpr 
    | 787 -> NONTERM_atomicExpr 
    | 788 -> NONTERM_atomicExpr 
    | 789 -> NONTERM_atomicExpr 
    | 790 -> NONTERM_atomicExpr 
    | 791 -> NONTERM_atomicExpr 
    | 792 -> NONTERM_atomicExpr 
    | 793 -> NONTERM_atomicExpr 
    | 794 -> NONTERM_atomicExpr 
    | 795 -> NONTERM_atomicExpr 
    | 796 -> NONTERM_atomicExpr 
    | 797 -> NONTERM_atomicExpr 
    | 798 -> NONTERM_atomicExpr 
    | 799 -> NONTERM_atomicExpr 
    | 800 -> NONTERM_atomicExpr 
    | 801 -> NONTERM_atomicExpr 
    | 802 -> NONTERM_atomicExpr 
    | 803 -> NONTERM_atomicExpr 
    | 804 -> NONTERM_atomicExpr 
    | 805 -> NONTERM_atomicExpr 
    | 806 -> NONTERM_atomicExpr 
    | 807 -> NONTERM_atomicExprQualification 
    | 808 -> NONTERM_atomicExprQualification 
    | 809 -> NONTERM_atomicExprQualification 
    | 810 -> NONTERM_atomicExprQualification 
    | 811 -> NONTERM_atomicExprQualification 
    | 812 -> NONTERM_atomicExprQualification 
    | 813 -> NONTERM_atomicExprQualification 
    | 814 -> NONTERM_atomicExprQualification 
    | 815 -> NONTERM_atomicExprQualification 
    | 816 -> NONTERM_atomicExprQualification 
    | 817 -> NONTERM_atomicExprAfterType 
    | 818 -> NONTERM_atomicExprAfterType 
    | 819 -> NONTERM_atomicExprAfterType 
    | 820 -> NONTERM_atomicExprAfterType 
    | 821 -> NONTERM_atomicExprAfterType 
    | 822 -> NONTERM_atomicExprAfterType 
    | 823 -> NONTERM_atomicExprAfterType 
    | 824 -> NONTERM_atomicExprAfterType 
    | 825 -> NONTERM_atomicExprAfterType 
    | 826 -> NONTERM_atomicExprAfterType 
    | 827 -> NONTERM_atomicExprAfterType 
    | 828 -> NONTERM_beginEndExpr 
    | 829 -> NONTERM_beginEndExpr 
    | 830 -> NONTERM_beginEndExpr 
    | 831 -> NONTERM_beginEndExpr 
    | 832 -> NONTERM_quoteExpr 
    | 833 -> NONTERM_quoteExpr 
    | 834 -> NONTERM_quoteExpr 
    | 835 -> NONTERM_quoteExpr 
    | 836 -> NONTERM_arrayExpr 
    | 837 -> NONTERM_arrayExpr 
    | 838 -> NONTERM_arrayExpr 
    | 839 -> NONTERM_arrayExpr 
    | 840 -> NONTERM_parenExpr 
    | 841 -> NONTERM_parenExpr 
    | 842 -> NONTERM_parenExpr 
    | 843 -> NONTERM_parenExpr 
    | 844 -> NONTERM_parenExpr 
    | 845 -> NONTERM_parenExpr 
    | 846 -> NONTERM_parenExpr 
    | 847 -> NONTERM_parenExpr 
    | 848 -> NONTERM_parenExpr 
    | 849 -> NONTERM_parenExpr 
    | 850 -> NONTERM_parenExprBody 
    | 851 -> NONTERM_parenExprBody 
    | 852 -> NONTERM_parenExprBody 
    | 853 -> NONTERM_typars 
    | 854 -> NONTERM_typars 
    | 855 -> NONTERM_typarAlts 
    | 856 -> NONTERM_typarAlts 
    | 857 -> NONTERM_braceExpr 
    | 858 -> NONTERM_braceExpr 
    | 859 -> NONTERM_braceExpr 
    | 860 -> NONTERM_braceExpr 
    | 861 -> NONTERM_braceExpr 
    | 862 -> NONTERM_braceExprBody 
    | 863 -> NONTERM_braceExprBody 
    | 864 -> NONTERM_braceExprBody 
    | 865 -> NONTERM_listExprElements 
    | 866 -> NONTERM_listExprElements 
    | 867 -> NONTERM_arrayExprElements 
    | 868 -> NONTERM_arrayExprElements 
    | 869 -> NONTERM_computationExpr 
    | 870 -> NONTERM_arrowThenExprR 
    | 871 -> NONTERM_forLoopBinder 
    | 872 -> NONTERM_forLoopBinder 
    | 873 -> NONTERM_forLoopBinder 
    | 874 -> NONTERM_forLoopRange 
    | 875 -> NONTERM_forLoopDirection 
    | 876 -> NONTERM_forLoopDirection 
    | 877 -> NONTERM_inlineAssemblyExpr 
    | 878 -> NONTERM_optCurriedArgExprs 
    | 879 -> NONTERM_optCurriedArgExprs 
    | 880 -> NONTERM_opt_atomicExprAfterType 
    | 881 -> NONTERM_opt_atomicExprAfterType 
    | 882 -> NONTERM_opt_inlineAssemblyTypeArg 
    | 883 -> NONTERM_opt_inlineAssemblyTypeArg 
    | 884 -> NONTERM_optInlineAssemblyReturnTypes 
    | 885 -> NONTERM_optInlineAssemblyReturnTypes 
    | 886 -> NONTERM_optInlineAssemblyReturnTypes 
    | 887 -> NONTERM_recdExpr 
    | 888 -> NONTERM_recdExpr 
    | 889 -> NONTERM_recdExprCore 
    | 890 -> NONTERM_recdExprCore 
    | 891 -> NONTERM_recdExprCore 
    | 892 -> NONTERM_recdExprCore 
    | 893 -> NONTERM_recdExprCore 
    | 894 -> NONTERM_recdExprCore 
    | 895 -> NONTERM_recdExprCore 
    | 896 -> NONTERM_recdExprCore 
    | 897 -> NONTERM_recdExprCore 
    | 898 -> NONTERM_opt_seps_recd 
    | 899 -> NONTERM_opt_seps_recd 
    | 900 -> NONTERM_seps_recd 
    | 901 -> NONTERM_seps_recd 
    | 902 -> NONTERM_seps_recd 
    | 903 -> NONTERM_seps_recd 
    | 904 -> NONTERM_pathOrUnderscore 
    | 905 -> NONTERM_pathOrUnderscore 
    | 906 -> NONTERM_recdExprBindings 
    | 907 -> NONTERM_recdExprBindings 
    | 908 -> NONTERM_recdBinding 
    | 909 -> NONTERM_recdBinding 
    | 910 -> NONTERM_recdBinding 
    | 911 -> NONTERM_recdBinding 
    | 912 -> NONTERM_recdBinding 
    | 913 -> NONTERM_objExpr 
    | 914 -> NONTERM_objExpr 
    | 915 -> NONTERM_objExpr 
    | 916 -> NONTERM_objExprBaseCall 
    | 917 -> NONTERM_objExprBaseCall 
    | 918 -> NONTERM_objExprBaseCall 
    | 919 -> NONTERM_opt_objExprBindings 
    | 920 -> NONTERM_opt_objExprBindings 
    | 921 -> NONTERM_objExprBindings 
    | 922 -> NONTERM_objExprBindings 
    | 923 -> NONTERM_objExprBindings 
    | 924 -> NONTERM_objExprInterfaces 
    | 925 -> NONTERM_opt_objExprInterfaces 
    | 926 -> NONTERM_opt_objExprInterfaces 
    | 927 -> NONTERM_opt_objExprInterfaces 
    | 928 -> NONTERM_objExprInterface 
    | 929 -> NONTERM_braceBarExpr 
    | 930 -> NONTERM_braceBarExpr 
    | 931 -> NONTERM_braceBarExprCore 
    | 932 -> NONTERM_braceBarExprCore 
    | 933 -> NONTERM_braceBarExprCore 
    | 934 -> NONTERM_braceBarExprCore 
    | 935 -> NONTERM_braceBarExprCore 
    | 936 -> NONTERM_anonLambdaExpr 
    | 937 -> NONTERM_anonLambdaExpr 
    | 938 -> NONTERM_anonLambdaExpr 
    | 939 -> NONTERM_anonLambdaExpr 
    | 940 -> NONTERM_anonLambdaExpr 
    | 941 -> NONTERM_anonLambdaExpr 
    | 942 -> NONTERM_anonLambdaExpr 
    | 943 -> NONTERM_anonLambdaExpr 
    | 944 -> NONTERM_anonMatchingExpr 
    | 945 -> NONTERM_anonMatchingExpr 
    | 946 -> NONTERM_typeWithTypeConstraints 
    | 947 -> NONTERM_typeWithTypeConstraints 
    | 948 -> NONTERM_topTypeWithTypeConstraints 
    | 949 -> NONTERM_topTypeWithTypeConstraints 
    | 950 -> NONTERM_opt_topReturnTypeWithTypeConstraints 
    | 951 -> NONTERM_opt_topReturnTypeWithTypeConstraints 
    | 952 -> NONTERM_opt_topReturnTypeWithTypeConstraints 
    | 953 -> NONTERM_topType 
    | 954 -> NONTERM_topType 
    | 955 -> NONTERM_topType 
    | 956 -> NONTERM_topTupleType 
    | 957 -> NONTERM_topTupleType 
    | 958 -> NONTERM_topTupleType 
    | 959 -> NONTERM_topTupleType 
    | 960 -> NONTERM_topTupleTypeElements 
    | 961 -> NONTERM_topTupleTypeElements 
    | 962 -> NONTERM_topTupleTypeElements 
    | 963 -> NONTERM_topTupleTypeElements 
    | 964 -> NONTERM_topAppType 
    | 965 -> NONTERM_topAppType 
    | 966 -> NONTERM_topAppType 
    | 967 -> NONTERM_topAppType 
    | 968 -> NONTERM_topAppType 
    | 969 -> NONTERM_topAppType 
    | 970 -> NONTERM_topAppType 
    | 971 -> NONTERM_topAppType 
    | 972 -> NONTERM_topAppType 
    | 973 -> NONTERM_topAppType 
    | 974 -> NONTERM_invalidUseOfAppTypeFunction 
    | 975 -> NONTERM_invalidUseOfAppTypeFunction 
    | 976 -> NONTERM_invalidUseOfAppTypeFunction 
    | 977 -> NONTERM_invalidUseOfAppTypeFunction 
    | 978 -> NONTERM_typ 
    | 979 -> NONTERM_typ 
    | 980 -> NONTERM_typ 
    | 981 -> NONTERM_typ 
    | 982 -> NONTERM_typEOF 
    | 983 -> NONTERM_tupleType 
    | 984 -> NONTERM_tupleType 
    | 985 -> NONTERM_tupleType 
    | 986 -> NONTERM_tupleType 
    | 987 -> NONTERM_tupleType 
    | 988 -> NONTERM_tupleType 
    | 989 -> NONTERM_tupleType 
    | 990 -> NONTERM_tupleType 
    | 991 -> NONTERM_tupleOrQuotTypeElements 
    | 992 -> NONTERM_tupleOrQuotTypeElements 
    | 993 -> NONTERM_tupleOrQuotTypeElements 
    | 994 -> NONTERM_tupleOrQuotTypeElements 
    | 995 -> NONTERM_tupleOrQuotTypeElements 
    | 996 -> NONTERM_tupleOrQuotTypeElements 
    | 997 -> NONTERM_tupleOrQuotTypeElements 
    | 998 -> NONTERM_intersectionType 
    | 999 -> NONTERM_intersectionType 
    | 1000 -> NONTERM_appTypeCon 
    | 1001 -> NONTERM_appTypeCon 
    | 1002 -> NONTERM_appTypeConPower 
    | 1003 -> NONTERM_appTypeConPower 
    | 1004 -> NONTERM_appTypeCanBeNullable 
    | 1005 -> NONTERM_appTypeCanBeNullable 
    | 1006 -> NONTERM_appTypeNullableInParens 
    | 1007 -> NONTERM_appTypeNullableInParens 
    | 1008 -> NONTERM_appTypeWithoutNull 
    | 1009 -> NONTERM_appTypeWithoutNull 
    | 1010 -> NONTERM_appTypeWithoutNull 
    | 1011 -> NONTERM_appTypeWithoutNull 
    | 1012 -> NONTERM_appTypeWithoutNull 
    | 1013 -> NONTERM_appTypeWithoutNull 
    | 1014 -> NONTERM_appTypeWithoutNull 
    | 1015 -> NONTERM_appTypeWithoutNull 
    | 1016 -> NONTERM_arrayTypeSuffix 
    | 1017 -> NONTERM_arrayTypeSuffix 
    | 1018 -> NONTERM_arrayTypeSuffix 
    | 1019 -> NONTERM_arrayTypeSuffix 
    | 1020 -> NONTERM_arrayTypeSuffix 
    | 1021 -> NONTERM_arrayTypeSuffix 
    | 1022 -> NONTERM_arrayTypeSuffix 
    | 1023 -> NONTERM_arrayTypeSuffix 
    | 1024 -> NONTERM_arrayTypeSuffix 
    | 1025 -> NONTERM_arrayTypeSuffix 
    | 1026 -> NONTERM_arrayTypeSuffix 
    | 1027 -> NONTERM_arrayTypeSuffix 
    | 1028 -> NONTERM_arrayTypeSuffix 
    | 1029 -> NONTERM_arrayTypeSuffix 
    | 1030 -> NONTERM_arrayTypeSuffix 
    | 1031 -> NONTERM_arrayTypeSuffix 
    | 1032 -> NONTERM_arrayTypeSuffix 
    | 1033 -> NONTERM_arrayTypeSuffix 
    | 1034 -> NONTERM_arrayTypeSuffix 
    | 1035 -> NONTERM_arrayTypeSuffix 
    | 1036 -> NONTERM_arrayTypeSuffix 
    | 1037 -> NONTERM_arrayTypeSuffix 
    | 1038 -> NONTERM_arrayTypeSuffix 
    | 1039 -> NONTERM_arrayTypeSuffix 
    | 1040 -> NONTERM_arrayTypeSuffix 
    | 1041 -> NONTERM_arrayTypeSuffix 
    | 1042 -> NONTERM_arrayTypeSuffix 
    | 1043 -> NONTERM_arrayTypeSuffix 
    | 1044 -> NONTERM_arrayTypeSuffix 
    | 1045 -> NONTERM_arrayTypeSuffix 
    | 1046 -> NONTERM_arrayTypeSuffix 
    | 1047 -> NONTERM_arrayTypeSuffix 
    | 1048 -> NONTERM_appTypePrefixArguments 
    | 1049 -> NONTERM_typeArgListElements 
    | 1050 -> NONTERM_typeArgListElements 
    | 1051 -> NONTERM_typeArgListElements 
    | 1052 -> NONTERM_powerType 
    | 1053 -> NONTERM_powerType 
    | 1054 -> NONTERM_atomTypeNonAtomicDeprecated 
    | 1055 -> NONTERM_atomTypeNonAtomicDeprecated 
    | 1056 -> NONTERM_atomTypeOrAnonRecdType 
    | 1057 -> NONTERM_atomTypeOrAnonRecdType 
    | 1058 -> NONTERM_atomType 
    | 1059 -> NONTERM_atomType 
    | 1060 -> NONTERM_atomType 
    | 1061 -> NONTERM_atomType 
    | 1062 -> NONTERM_atomType 
    | 1063 -> NONTERM_atomType 
    | 1064 -> NONTERM_atomType 
    | 1065 -> NONTERM_atomType 
    | 1066 -> NONTERM_atomType 
    | 1067 -> NONTERM_atomType 
    | 1068 -> NONTERM_atomType 
    | 1069 -> NONTERM_atomType 
    | 1070 -> NONTERM_atomType 
    | 1071 -> NONTERM_atomType 
    | 1072 -> NONTERM_atomType 
    | 1073 -> NONTERM_atomType 
    | 1074 -> NONTERM_atomType 
    | 1075 -> NONTERM_atomType 
    | 1076 -> NONTERM_atomType 
    | 1077 -> NONTERM_atomType 
    | 1078 -> NONTERM_typeArgsNoHpaDeprecated 
    | 1079 -> NONTERM_typeArgsNoHpaDeprecated 
    | 1080 -> NONTERM_typeArgsActual 
    | 1081 -> NONTERM_typeArgsActual 
    | 1082 -> NONTERM_typeArgsActual 
    | 1083 -> NONTERM_typeArgsActual 
    | 1084 -> NONTERM_typeArgsActual 
    | 1085 -> NONTERM_typeArgsActual 
    | 1086 -> NONTERM_typeArgsActual 
    | 1087 -> NONTERM_typeArgActual 
    | 1088 -> NONTERM_typeArgActual 
    | 1089 -> NONTERM_typeArgActual 
    | 1090 -> NONTERM_typeArgActualOrDummyIfEmpty 
    | 1091 -> NONTERM_typeArgActualOrDummyIfEmpty 
    | 1092 -> NONTERM_dummyTypeArg 
    | 1093 -> NONTERM_measureTypeArg 
    | 1094 -> NONTERM_measureTypeArg 
    | 1095 -> NONTERM_measureTypeAtom 
    | 1096 -> NONTERM_measureTypeAtom 
    | 1097 -> NONTERM_measureTypeAtom 
    | 1098 -> NONTERM_measureTypePower 
    | 1099 -> NONTERM_measureTypePower 
    | 1100 -> NONTERM_measureTypePower 
    | 1101 -> NONTERM_measureTypeSeq 
    | 1102 -> NONTERM_measureTypeSeq 
    | 1103 -> NONTERM_measureTypeExpr 
    | 1104 -> NONTERM_measureTypeExpr 
    | 1105 -> NONTERM_measureTypeExpr 
    | 1106 -> NONTERM_measureTypeExpr 
    | 1107 -> NONTERM_typar 
    | 1108 -> NONTERM_typar 
    | 1109 -> NONTERM_ident 
    | 1110 -> NONTERM_path 
    | 1111 -> NONTERM_path 
    | 1112 -> NONTERM_path 
    | 1113 -> NONTERM_path 
    | 1114 -> NONTERM_opName 
    | 1115 -> NONTERM_opName 
    | 1116 -> NONTERM_opName 
    | 1117 -> NONTERM_opName 
    | 1118 -> NONTERM_opName 
    | 1119 -> NONTERM_operatorName 
    | 1120 -> NONTERM_operatorName 
    | 1121 -> NONTERM_operatorName 
    | 1122 -> NONTERM_operatorName 
    | 1123 -> NONTERM_operatorName 
    | 1124 -> NONTERM_operatorName 
    | 1125 -> NONTERM_operatorName 
    | 1126 -> NONTERM_operatorName 
    | 1127 -> NONTERM_operatorName 
    | 1128 -> NONTERM_operatorName 
    | 1129 -> NONTERM_operatorName 
    | 1130 -> NONTERM_operatorName 
    | 1131 -> NONTERM_operatorName 
    | 1132 -> NONTERM_operatorName 
    | 1133 -> NONTERM_operatorName 
    | 1134 -> NONTERM_operatorName 
    | 1135 -> NONTERM_operatorName 
    | 1136 -> NONTERM_operatorName 
    | 1137 -> NONTERM_operatorName 
    | 1138 -> NONTERM_operatorName 
    | 1139 -> NONTERM_operatorName 
    | 1140 -> NONTERM_operatorName 
    | 1141 -> NONTERM_operatorName 
    | 1142 -> NONTERM_operatorName 
    | 1143 -> NONTERM_operatorName 
    | 1144 -> NONTERM_operatorName 
    | 1145 -> NONTERM_activePatternCaseName 
    | 1146 -> NONTERM_activePatternCaseNames 
    | 1147 -> NONTERM_activePatternCaseNames 
    | 1148 -> NONTERM_identOrOp 
    | 1149 -> NONTERM_identOrOp 
    | 1150 -> NONTERM_pathOp 
    | 1151 -> NONTERM_pathOp 
    | 1152 -> NONTERM_pathOp 
    | 1153 -> NONTERM_pathOp 
    | 1154 -> NONTERM_nameop 
    | 1155 -> NONTERM_identExpr 
    | 1156 -> NONTERM_identExpr 
    | 1157 -> NONTERM_topSeparator 
    | 1158 -> NONTERM_topSeparator 
    | 1159 -> NONTERM_topSeparator 
    | 1160 -> NONTERM_topSeparators 
    | 1161 -> NONTERM_topSeparators 
    | 1162 -> NONTERM_opt_topSeparators 
    | 1163 -> NONTERM_opt_topSeparators 
    | 1164 -> NONTERM_seps 
    | 1165 -> NONTERM_seps 
    | 1166 -> NONTERM_seps 
    | 1167 -> NONTERM_seps 
    | 1168 -> NONTERM_declEnd 
    | 1169 -> NONTERM_declEnd 
    | 1170 -> NONTERM_declEnd 
    | 1171 -> NONTERM_opt_declEnd 
    | 1172 -> NONTERM_opt_declEnd 
    | 1173 -> NONTERM_opt_declEnd 
    | 1174 -> NONTERM_opt_declEnd 
    | 1175 -> NONTERM_opt_ODECLEND 
    | 1176 -> NONTERM_opt_ODECLEND 
    | 1177 -> NONTERM_deprecated_opt_equals 
    | 1178 -> NONTERM_deprecated_opt_equals 
    | 1179 -> NONTERM_opt_OBLOCKSEP 
    | 1180 -> NONTERM_opt_OBLOCKSEP 
    | 1181 -> NONTERM_opt_seps 
    | 1182 -> NONTERM_opt_seps 
    | 1183 -> NONTERM_opt_rec 
    | 1184 -> NONTERM_opt_rec 
    | 1185 -> NONTERM_opt_inline 
    | 1186 -> NONTERM_opt_inline 
    | 1187 -> NONTERM_opt_mutable 
    | 1188 -> NONTERM_opt_mutable 
    | 1189 -> NONTERM_doToken 
    | 1190 -> NONTERM_doToken 
    | 1191 -> NONTERM_doneDeclEnd 
    | 1192 -> NONTERM_doneDeclEnd 
    | 1193 -> NONTERM_structOrBegin 
    | 1194 -> NONTERM_structOrBegin 
    | 1195 -> NONTERM_sigOrBegin 
    | 1196 -> NONTERM_sigOrBegin 
    | 1197 -> NONTERM_colonOrEquals 
    | 1198 -> NONTERM_colonOrEquals 
    | 1199 -> NONTERM_string 
    | 1200 -> NONTERM_sourceIdentifier 
    | 1201 -> NONTERM_interpolatedStringFill 
    | 1202 -> NONTERM_interpolatedStringFill 
    | 1203 -> NONTERM_interpolatedStringParts 
    | 1204 -> NONTERM_interpolatedStringParts 
    | 1205 -> NONTERM_interpolatedStringParts 
    | 1206 -> NONTERM_interpolatedString 
    | 1207 -> NONTERM_interpolatedString 
    | 1208 -> NONTERM_interpolatedString 
    | 1209 -> NONTERM_opt_HIGH_PRECEDENCE_APP 
    | 1210 -> NONTERM_opt_HIGH_PRECEDENCE_APP 
    | 1211 -> NONTERM_opt_HIGH_PRECEDENCE_APP 
    | 1212 -> NONTERM_opt_HIGH_PRECEDENCE_TYAPP 
    | 1213 -> NONTERM_opt_HIGH_PRECEDENCE_TYAPP 
    | 1214 -> NONTERM_typeKeyword 
    | 1215 -> NONTERM_typeKeyword 
    | 1216 -> NONTERM_typeKeyword 
    | 1217 -> NONTERM_moduleKeyword 
    | 1218 -> NONTERM_moduleKeyword 
    | 1219 -> NONTERM_moduleKeyword 
    | 1220 -> NONTERM_rbrace 
    | 1221 -> NONTERM_rbrace 
    | 1222 -> NONTERM_rbrace 
    | 1223 -> NONTERM_bar_rbrace 
    | 1224 -> NONTERM_rparen 
    | 1225 -> NONTERM_rparen 
    | 1226 -> NONTERM_rparen 
    | 1227 -> NONTERM_oblockend 
    | 1228 -> NONTERM_oblockend 
    | 1229 -> NONTERM_oblockend 
    | 1230 -> NONTERM_ends_other_than_rparen_coming_soon_or_recover 
    | 1231 -> NONTERM_ends_other_than_rparen_coming_soon_or_recover 
    | 1232 -> NONTERM_ends_other_than_rparen_coming_soon_or_recover 
    | 1233 -> NONTERM_ends_other_than_rparen_coming_soon_or_recover 
    | 1234 -> NONTERM_ends_other_than_rparen_coming_soon_or_recover 
    | 1235 -> NONTERM_ends_coming_soon_or_recover 
    | 1236 -> NONTERM_ends_coming_soon_or_recover 
    | 1237 -> NONTERM_ends_coming_soon_or_recover 
    | 1238 -> NONTERM_ends_coming_soon_or_recover 
    | 1239 -> NONTERM_ends_coming_soon_or_recover 
    | 1240 -> NONTERM_ends_coming_soon_or_recover 
    | _ -> failwith "prodIdxToNonTerminal: bad production index"

let _fsyacc_endOfInputTag = 206 
let _fsyacc_tagOfErrorTerminal = 204

// This function gets the name of a token as a string
let token_to_string (t:token) = 
  match t with 
  | HASH_IF _ -> "HASH_IF" 
  | HASH_ELSE _ -> "HASH_ELSE" 
  | HASH_ENDIF _ -> "HASH_ENDIF" 
  | COMMENT _ -> "COMMENT" 
  | WHITESPACE _ -> "WHITESPACE" 
  | HASH_LINE _ -> "HASH_LINE" 
  | HASH_LIGHT _ -> "HASH_LIGHT" 
  | INACTIVECODE _ -> "INACTIVECODE" 
  | LINE_COMMENT _ -> "LINE_COMMENT" 
  | STRING_TEXT _ -> "STRING_TEXT" 
  | EOF _ -> "EOF" 
  | LEX_FAILURE _ -> "LEX_FAILURE" 
  | ODUMMY _ -> "ODUMMY" 
  | FIXED  -> "FIXED" 
  | OINTERFACE_MEMBER  -> "OINTERFACE_MEMBER" 
  | OBLOCKEND_COMING_SOON  -> "OBLOCKEND_COMING_SOON" 
  | OBLOCKEND_IS_HERE  -> "OBLOCKEND_IS_HERE" 
  | OBLOCKEND _ -> "OBLOCKEND" 
  | ORIGHT_BLOCK_END _ -> "ORIGHT_BLOCK_END" 
  | ODECLEND _ -> "ODECLEND" 
  | OEND  -> "OEND" 
  | OBLOCKSEP  -> "OBLOCKSEP" 
  | OBLOCKBEGIN  -> "OBLOCKBEGIN" 
  | ORESET  -> "ORESET" 
  | OFUN  -> "OFUN" 
  | OFUNCTION  -> "OFUNCTION" 
  | OWITH  -> "OWITH" 
  | OELSE  -> "OELSE" 
  | OTHEN  -> "OTHEN" 
  | ODO_BANG  -> "ODO_BANG" 
  | ODO  -> "ODO" 
  | OAND_BANG _ -> "OAND_BANG" 
  | OBINDER _ -> "OBINDER" 
  | OLET _ -> "OLET" 
  | HIGH_PRECEDENCE_TYAPP  -> "HIGH_PRECEDENCE_TYAPP" 
  | HIGH_PRECEDENCE_PAREN_APP  -> "HIGH_PRECEDENCE_PAREN_APP" 
  | HIGH_PRECEDENCE_BRACK_APP  -> "HIGH_PRECEDENCE_BRACK_APP" 
  | TYPE_COMING_SOON  -> "TYPE_COMING_SOON" 
  | TYPE_IS_HERE  -> "TYPE_IS_HERE" 
  | MODULE_COMING_SOON  -> "MODULE_COMING_SOON" 
  | MODULE_IS_HERE  -> "MODULE_IS_HERE" 
  | BAR_JUST_BEFORE_NULL  -> "BAR_JUST_BEFORE_NULL" 
  | EXTERN  -> "EXTERN" 
  | VOID  -> "VOID" 
  | PUBLIC  -> "PUBLIC" 
  | PRIVATE  -> "PRIVATE" 
  | INTERNAL  -> "INTERNAL" 
  | GLOBAL  -> "GLOBAL" 
  | STATIC  -> "STATIC" 
  | MEMBER  -> "MEMBER" 
  | CLASS  -> "CLASS" 
  | ABSTRACT  -> "ABSTRACT" 
  | OVERRIDE  -> "OVERRIDE" 
  | DEFAULT  -> "DEFAULT" 
  | CONSTRUCTOR  -> "CONSTRUCTOR" 
  | INHERIT  -> "INHERIT" 
  | GREATER_RBRACK  -> "GREATER_RBRACK" 
  | STRUCT  -> "STRUCT" 
  | SIG  -> "SIG" 
  | BAR  -> "BAR" 
  | RBRACK  -> "RBRACK" 
  | RBRACE_COMING_SOON  -> "RBRACE_COMING_SOON" 
  | RBRACE_IS_HERE  -> "RBRACE_IS_HERE" 
  | MINUS  -> "MINUS" 
  | DOLLAR  -> "DOLLAR" 
  | BAR_RBRACK  -> "BAR_RBRACK" 
  | BAR_RBRACE  -> "BAR_RBRACE" 
  | UNDERSCORE  -> "UNDERSCORE" 
  | SEMICOLON_SEMICOLON  -> "SEMICOLON_SEMICOLON" 
  | LARROW  -> "LARROW" 
  | EQUALS  -> "EQUALS" 
  | LBRACK  -> "LBRACK" 
  | LBRACK_BAR  -> "LBRACK_BAR" 
  | LBRACE_BAR  -> "LBRACE_BAR" 
  | LBRACK_LESS  -> "LBRACK_LESS" 
  | QMARK  -> "QMARK" 
  | QMARK_QMARK  -> "QMARK_QMARK" 
  | DOT  -> "DOT" 
  | COLON  -> "COLON" 
  | COLON_COLON  -> "COLON_COLON" 
  | COLON_GREATER  -> "COLON_GREATER" 
  | COLON_QMARK_GREATER  -> "COLON_QMARK_GREATER" 
  | COLON_QMARK  -> "COLON_QMARK" 
  | COLON_EQUALS  -> "COLON_EQUALS" 
  | SEMICOLON  -> "SEMICOLON" 
  | WHEN  -> "WHEN" 
  | WHILE  -> "WHILE" 
  | WHILE_BANG  -> "WHILE_BANG" 
  | WITH  -> "WITH" 
  | HASH  -> "HASH" 
  | AMP  -> "AMP" 
  | AMP_AMP  -> "AMP_AMP" 
  | QUOTE  -> "QUOTE" 
  | LPAREN  -> "LPAREN" 
  | RPAREN  -> "RPAREN" 
  | RPAREN_COMING_SOON  -> "RPAREN_COMING_SOON" 
  | RPAREN_IS_HERE  -> "RPAREN_IS_HERE" 
  | STAR  -> "STAR" 
  | COMMA  -> "COMMA" 
  | RARROW  -> "RARROW" 
  | GREATER_BAR_RBRACK  -> "GREATER_BAR_RBRACK" 
  | LPAREN_STAR_RPAREN  -> "LPAREN_STAR_RPAREN" 
  | OPEN  -> "OPEN" 
  | OR  -> "OR" 
  | REC  -> "REC" 
  | THEN  -> "THEN" 
  | TO  -> "TO" 
  | TRUE  -> "TRUE" 
  | TRY  -> "TRY" 
  | TYPE  -> "TYPE" 
  | VAL  -> "VAL" 
  | INLINE  -> "INLINE" 
  | INTERFACE  -> "INTERFACE" 
  | INSTANCE  -> "INSTANCE" 
  | CONST  -> "CONST" 
  | LAZY  -> "LAZY" 
  | OLAZY  -> "OLAZY" 
  | MATCH  -> "MATCH" 
  | MATCH_BANG  -> "MATCH_BANG" 
  | MUTABLE  -> "MUTABLE" 
  | NEW  -> "NEW" 
  | OF  -> "OF" 
  | EXCEPTION  -> "EXCEPTION" 
  | FALSE  -> "FALSE" 
  | FOR  -> "FOR" 
  | FUN  -> "FUN" 
  | FUNCTION  -> "FUNCTION" 
  | IF  -> "IF" 
  | IN  -> "IN" 
  | JOIN_IN  -> "JOIN_IN" 
  | FINALLY  -> "FINALLY" 
  | DO_BANG  -> "DO_BANG" 
  | AND  -> "AND" 
  | AS  -> "AS" 
  | ASSERT  -> "ASSERT" 
  | OASSERT  -> "OASSERT" 
  | ASR  -> "ASR" 
  | BEGIN  -> "BEGIN" 
  | DO  -> "DO" 
  | DONE  -> "DONE" 
  | DOWNTO  -> "DOWNTO" 
  | ELSE  -> "ELSE" 
  | ELIF  -> "ELIF" 
  | END  -> "END" 
  | DOT_DOT  -> "DOT_DOT" 
  | DOT_DOT_HAT  -> "DOT_DOT_HAT" 
  | BAR_BAR  -> "BAR_BAR" 
  | UPCAST  -> "UPCAST" 
  | DOWNCAST  -> "DOWNCAST" 
  | NULL  -> "NULL" 
  | RESERVED  -> "RESERVED" 
  | MODULE  -> "MODULE" 
  | NAMESPACE  -> "NAMESPACE" 
  | DELEGATE  -> "DELEGATE" 
  | CONSTRAINT  -> "CONSTRAINT" 
  | BASE  -> "BASE" 
  | LQUOTE _ -> "LQUOTE" 
  | RQUOTE _ -> "RQUOTE" 
  | RQUOTE_DOT _ -> "RQUOTE_DOT" 
  | PERCENT_OP _ -> "PERCENT_OP" 
  | BINDER _ -> "BINDER" 
  | LESS _ -> "LESS" 
  | GREATER _ -> "GREATER" 
  | LET _ -> "LET" 
  | YIELD _ -> "YIELD" 
  | YIELD_BANG _ -> "YIELD_BANG" 
  | AND_BANG _ -> "AND_BANG" 
  | BIGNUM _ -> "BIGNUM" 
  | DECIMAL _ -> "DECIMAL" 
  | CHAR _ -> "CHAR" 
  | IEEE64 _ -> "IEEE64" 
  | IEEE32 _ -> "IEEE32" 
  | UNATIVEINT _ -> "UNATIVEINT" 
  | UINT64 _ -> "UINT64" 
  | UINT32 _ -> "UINT32" 
  | UINT16 _ -> "UINT16" 
  | UINT8 _ -> "UINT8" 
  | NATIVEINT _ -> "NATIVEINT" 
  | INT64 _ -> "INT64" 
  | INT32 _ -> "INT32" 
  | INT32_DOT_DOT _ -> "INT32_DOT_DOT" 
  | INT16 _ -> "INT16" 
  | INT8 _ -> "INT8" 
  | FUNKY_OPERATOR_NAME _ -> "FUNKY_OPERATOR_NAME" 
  | ADJACENT_PREFIX_OP _ -> "ADJACENT_PREFIX_OP" 
  | PLUS_MINUS_OP _ -> "PLUS_MINUS_OP" 
  | INFIX_AMP_OP _ -> "INFIX_AMP_OP" 
  | INFIX_STAR_DIV_MOD_OP _ -> "INFIX_STAR_DIV_MOD_OP" 
  | PREFIX_OP _ -> "PREFIX_OP" 
  | INFIX_BAR_OP _ -> "INFIX_BAR_OP" 
  | INFIX_AT_HAT_OP _ -> "INFIX_AT_HAT_OP" 
  | INFIX_COMPARE_OP _ -> "INFIX_COMPARE_OP" 
  | INFIX_STAR_STAR_OP _ -> "INFIX_STAR_STAR_OP" 
  | HASH_IDENT _ -> "HASH_IDENT" 
  | IDENT _ -> "IDENT" 
  | KEYWORD_STRING _ -> "KEYWORD_STRING" 
  | LBRACE _ -> "LBRACE" 
  | RBRACE _ -> "RBRACE" 
  | INTERP_STRING_END _ -> "INTERP_STRING_END" 
  | INTERP_STRING_PART _ -> "INTERP_STRING_PART" 
  | INTERP_STRING_BEGIN_PART _ -> "INTERP_STRING_BEGIN_PART" 
  | INTERP_STRING_BEGIN_END _ -> "INTERP_STRING_BEGIN_END" 
  | STRING _ -> "STRING" 
  | BYTEARRAY _ -> "BYTEARRAY" 

// This function gets the data carried by a token as an object
let _fsyacc_dataOfToken (t:token) = 
  match t with 
  | HASH_IF _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | HASH_ELSE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | HASH_ENDIF _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | COMMENT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | WHITESPACE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | HASH_LINE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | HASH_LIGHT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INACTIVECODE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | LINE_COMMENT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | STRING_TEXT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | EOF _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | LEX_FAILURE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | ODUMMY _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | FIXED  -> (null : System.Object) 
  | OINTERFACE_MEMBER  -> (null : System.Object) 
  | OBLOCKEND_COMING_SOON  -> (null : System.Object) 
  | OBLOCKEND_IS_HERE  -> (null : System.Object) 
  | OBLOCKEND _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | ORIGHT_BLOCK_END _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | ODECLEND _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | OEND  -> (null : System.Object) 
  | OBLOCKSEP  -> (null : System.Object) 
  | OBLOCKBEGIN  -> (null : System.Object) 
  | ORESET  -> (null : System.Object) 
  | OFUN  -> (null : System.Object) 
  | OFUNCTION  -> (null : System.Object) 
  | OWITH  -> (null : System.Object) 
  | OELSE  -> (null : System.Object) 
  | OTHEN  -> (null : System.Object) 
  | ODO_BANG  -> (null : System.Object) 
  | ODO  -> (null : System.Object) 
  | OAND_BANG _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | OBINDER _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | OLET _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | HIGH_PRECEDENCE_TYAPP  -> (null : System.Object) 
  | HIGH_PRECEDENCE_PAREN_APP  -> (null : System.Object) 
  | HIGH_PRECEDENCE_BRACK_APP  -> (null : System.Object) 
  | TYPE_COMING_SOON  -> (null : System.Object) 
  | TYPE_IS_HERE  -> (null : System.Object) 
  | MODULE_COMING_SOON  -> (null : System.Object) 
  | MODULE_IS_HERE  -> (null : System.Object) 
  | BAR_JUST_BEFORE_NULL  -> (null : System.Object) 
  | EXTERN  -> (null : System.Object) 
  | VOID  -> (null : System.Object) 
  | PUBLIC  -> (null : System.Object) 
  | PRIVATE  -> (null : System.Object) 
  | INTERNAL  -> (null : System.Object) 
  | GLOBAL  -> (null : System.Object) 
  | STATIC  -> (null : System.Object) 
  | MEMBER  -> (null : System.Object) 
  | CLASS  -> (null : System.Object) 
  | ABSTRACT  -> (null : System.Object) 
  | OVERRIDE  -> (null : System.Object) 
  | DEFAULT  -> (null : System.Object) 
  | CONSTRUCTOR  -> (null : System.Object) 
  | INHERIT  -> (null : System.Object) 
  | GREATER_RBRACK  -> (null : System.Object) 
  | STRUCT  -> (null : System.Object) 
  | SIG  -> (null : System.Object) 
  | BAR  -> (null : System.Object) 
  | RBRACK  -> (null : System.Object) 
  | RBRACE_COMING_SOON  -> (null : System.Object) 
  | RBRACE_IS_HERE  -> (null : System.Object) 
  | MINUS  -> (null : System.Object) 
  | DOLLAR  -> (null : System.Object) 
  | BAR_RBRACK  -> (null : System.Object) 
  | BAR_RBRACE  -> (null : System.Object) 
  | UNDERSCORE  -> (null : System.Object) 
  | SEMICOLON_SEMICOLON  -> (null : System.Object) 
  | LARROW  -> (null : System.Object) 
  | EQUALS  -> (null : System.Object) 
  | LBRACK  -> (null : System.Object) 
  | LBRACK_BAR  -> (null : System.Object) 
  | LBRACE_BAR  -> (null : System.Object) 
  | LBRACK_LESS  -> (null : System.Object) 
  | QMARK  -> (null : System.Object) 
  | QMARK_QMARK  -> (null : System.Object) 
  | DOT  -> (null : System.Object) 
  | COLON  -> (null : System.Object) 
  | COLON_COLON  -> (null : System.Object) 
  | COLON_GREATER  -> (null : System.Object) 
  | COLON_QMARK_GREATER  -> (null : System.Object) 
  | COLON_QMARK  -> (null : System.Object) 
  | COLON_EQUALS  -> (null : System.Object) 
  | SEMICOLON  -> (null : System.Object) 
  | WHEN  -> (null : System.Object) 
  | WHILE  -> (null : System.Object) 
  | WHILE_BANG  -> (null : System.Object) 
  | WITH  -> (null : System.Object) 
  | HASH  -> (null : System.Object) 
  | AMP  -> (null : System.Object) 
  | AMP_AMP  -> (null : System.Object) 
  | QUOTE  -> (null : System.Object) 
  | LPAREN  -> (null : System.Object) 
  | RPAREN  -> (null : System.Object) 
  | RPAREN_COMING_SOON  -> (null : System.Object) 
  | RPAREN_IS_HERE  -> (null : System.Object) 
  | STAR  -> (null : System.Object) 
  | COMMA  -> (null : System.Object) 
  | RARROW  -> (null : System.Object) 
  | GREATER_BAR_RBRACK  -> (null : System.Object) 
  | LPAREN_STAR_RPAREN  -> (null : System.Object) 
  | OPEN  -> (null : System.Object) 
  | OR  -> (null : System.Object) 
  | REC  -> (null : System.Object) 
  | THEN  -> (null : System.Object) 
  | TO  -> (null : System.Object) 
  | TRUE  -> (null : System.Object) 
  | TRY  -> (null : System.Object) 
  | TYPE  -> (null : System.Object) 
  | VAL  -> (null : System.Object) 
  | INLINE  -> (null : System.Object) 
  | INTERFACE  -> (null : System.Object) 
  | INSTANCE  -> (null : System.Object) 
  | CONST  -> (null : System.Object) 
  | LAZY  -> (null : System.Object) 
  | OLAZY  -> (null : System.Object) 
  | MATCH  -> (null : System.Object) 
  | MATCH_BANG  -> (null : System.Object) 
  | MUTABLE  -> (null : System.Object) 
  | NEW  -> (null : System.Object) 
  | OF  -> (null : System.Object) 
  | EXCEPTION  -> (null : System.Object) 
  | FALSE  -> (null : System.Object) 
  | FOR  -> (null : System.Object) 
  | FUN  -> (null : System.Object) 
  | FUNCTION  -> (null : System.Object) 
  | IF  -> (null : System.Object) 
  | IN  -> (null : System.Object) 
  | JOIN_IN  -> (null : System.Object) 
  | FINALLY  -> (null : System.Object) 
  | DO_BANG  -> (null : System.Object) 
  | AND  -> (null : System.Object) 
  | AS  -> (null : System.Object) 
  | ASSERT  -> (null : System.Object) 
  | OASSERT  -> (null : System.Object) 
  | ASR  -> (null : System.Object) 
  | BEGIN  -> (null : System.Object) 
  | DO  -> (null : System.Object) 
  | DONE  -> (null : System.Object) 
  | DOWNTO  -> (null : System.Object) 
  | ELSE  -> (null : System.Object) 
  | ELIF  -> (null : System.Object) 
  | END  -> (null : System.Object) 
  | DOT_DOT  -> (null : System.Object) 
  | DOT_DOT_HAT  -> (null : System.Object) 
  | BAR_BAR  -> (null : System.Object) 
  | UPCAST  -> (null : System.Object) 
  | DOWNCAST  -> (null : System.Object) 
  | NULL  -> (null : System.Object) 
  | RESERVED  -> (null : System.Object) 
  | MODULE  -> (null : System.Object) 
  | NAMESPACE  -> (null : System.Object) 
  | DELEGATE  -> (null : System.Object) 
  | CONSTRAINT  -> (null : System.Object) 
  | BASE  -> (null : System.Object) 
  | LQUOTE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | RQUOTE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | RQUOTE_DOT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | PERCENT_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | BINDER _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | LESS _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | GREATER _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | LET _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | YIELD _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | YIELD_BANG _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | AND_BANG _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | BIGNUM _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | DECIMAL _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | CHAR _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | IEEE64 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | IEEE32 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | UNATIVEINT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | UINT64 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | UINT32 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | UINT16 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | UINT8 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | NATIVEINT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT64 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT32 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT32_DOT_DOT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT16 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT8 _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | FUNKY_OPERATOR_NAME _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | ADJACENT_PREFIX_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | PLUS_MINUS_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INFIX_AMP_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INFIX_STAR_DIV_MOD_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | PREFIX_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INFIX_BAR_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INFIX_AT_HAT_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INFIX_COMPARE_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INFIX_STAR_STAR_OP _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | HASH_IDENT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | IDENT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | KEYWORD_STRING _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | LBRACE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | RBRACE _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INTERP_STRING_END _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INTERP_STRING_PART _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INTERP_STRING_BEGIN_PART _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INTERP_STRING_BEGIN_END _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | STRING _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | BYTEARRAY _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
let _fsyacc_gotos = [| 0us;65535us;0us;65535us;0us;65535us;0us;65535us;0us;65535us;1us;65535us;4us;5us;7us;65535us;4us;15us;16us;17us;18us;19us;20us;21us;22us;15us;24us;15us;26us;15us;4us;65535us;4us;10us;22us;23us;24us;25us;26us;27us;5us;65535us;4us;16us;22us;16us;24us;16us;26us;16us;28us;29us;4us;65535us;4us;18us;22us;18us;24us;18us;26us;18us;4us;65535us;4us;20us;22us;20us;24us;20us;26us;20us;4us;65535us;16us;22us;18us;24us;20us;26us;34us;35us;4us;65535us;16us;34us;18us;34us;20us;34us;34us;34us;23us;65535us;0us;93us;2us;273us;4us;33us;22us;33us;24us;33us;26us;33us;69us;93us;73us;93us;77us;93us;88us;93us;91us;93us;123us;93us;126us;93us;130us;93us;239us;273us;243us;273us;246us;273us;258us;273us;262us;273us;264us;273us;270us;273us;301us;273us;311us;273us;1us;65535us;39us;40us;1us;65535us;40us;41us;1us;65535us;0us;1us;6us;65535us;31us;285us;72us;73us;96us;97us;242us;243us;256us;285us;275us;285us;4us;65535us;64us;68us;66us;68us;234us;238us;236us;238us;1us;65535us;0us;47us;2us;65535us;64us;65us;66us;67us;2us;65535us;64us;66us;66us;66us;2us;65535us;0us;64us;69us;70us;3us;65535us;0us;75us;69us;75us;73us;74us;6us;65535us;0us;76us;69us;76us;73us;76us;77us;78us;126us;127us;130us;131us;9us;65535us;0us;84us;69us;84us;73us;84us;77us;84us;88us;89us;91us;92us;123us;124us;126us;84us;130us;84us;9us;65535us;0us;87us;69us;87us;73us;87us;77us;87us;88us;87us;91us;87us;123us;87us;126us;87us;130us;87us;9us;65535us;0us;94us;69us;94us;73us;94us;77us;94us;88us;94us;91us;94us;123us;94us;126us;94us;130us;94us;2us;65535us;115us;116us;189us;190us;1us;65535us;98us;100us;2us;65535us;103us;104us;134us;135us;3us;65535us;102us;103us;133us;134us;201us;202us;1us;65535us;137us;138us;2us;65535us;137us;147us;140us;141us;2us;65535us;137us;150us;140us;150us;2us;65535us;137us;154us;140us;154us;3us;65535us;155us;156us;165us;166us;225us;226us;8us;65535us;140us;162us;142us;143us;155us;173us;161us;162us;165us;173us;169us;170us;176us;177us;225us;173us;8us;65535us;140us;174us;142us;174us;155us;174us;161us;174us;165us;174us;169us;174us;176us;174us;225us;174us;11us;65535us;140us;175us;142us;175us;155us;175us;161us;175us;165us;175us;169us;175us;176us;175us;225us;175us;661us;662us;668us;669us;1528us;1529us;3us;65535us;188us;189us;461us;462us;498us;499us;2us;65535us;206us;207us;208us;209us;2us;65535us;180us;182us;181us;182us;2us;65535us;72us;105us;96us;105us;5us;65535us;136us;139us;143us;144us;145us;146us;147us;148us;223us;224us;1us;65535us;2us;3us;1us;65535us;2us;228us;2us;65535us;234us;235us;236us;237us;2us;65535us;234us;236us;236us;236us;2us;65535us;2us;234us;239us;240us;3us;65535us;2us;245us;239us;245us;243us;244us;5us;65535us;2us;253us;239us;253us;243us;253us;246us;247us;311us;312us;9us;65535us;2us;254us;239us;254us;243us;254us;246us;254us;258us;259us;264us;265us;270us;271us;301us;305us;311us;254us;10us;65535us;2us;260us;239us;260us;243us;260us;246us;260us;258us;260us;262us;263us;264us;260us;270us;260us;301us;260us;311us;260us;10us;65535us;2us;262us;239us;262us;243us;262us;246us;262us;258us;262us;262us;262us;264us;262us;270us;262us;301us;262us;311us;262us;15us;65535us;2us;272us;4us;28us;22us;28us;24us;28us;26us;28us;28us;28us;239us;272us;243us;272us;246us;272us;258us;272us;262us;272us;264us;272us;270us;272us;301us;272us;311us;272us;24us;65535us;0us;106us;2us;291us;4us;291us;22us;291us;24us;291us;26us;291us;28us;291us;69us;106us;73us;106us;77us;106us;88us;106us;91us;106us;123us;106us;126us;106us;130us;106us;239us;291us;243us;291us;246us;291us;258us;291us;262us;291us;264us;291us;270us;291us;301us;291us;311us;291us;1us;65535us;98us;99us;1us;65535us;286us;287us;2us;65535us;286us;309us;301us;302us;1us;65535us;366us;367us;81us;65535us;0us;71us;2us;241us;4us;30us;22us;30us;24us;30us;26us;30us;28us;274us;53us;54us;69us;71us;73us;95us;77us;95us;88us;95us;91us;95us;102us;360us;107us;108us;123us;95us;126us;95us;130us;95us;133us;360us;137us;566us;140us;179us;142us;178us;155us;178us;161us;178us;165us;178us;169us;178us;176us;178us;201us;360us;225us;178us;239us;241us;243us;255us;246us;255us;258us;255us;262us;274us;264us;255us;270us;255us;281us;360us;301us;255us;311us;255us;316us;441us;363us;360us;366us;368us;373us;566us;376us;442us;378us;441us;393us;441us;397us;441us;399us;441us;403us;441us;409us;441us;412us;441us;423us;424us;481us;360us;522us;551us;525us;441us;543us;551us;549us;551us;580us;746us;590us;746us;608us;617us;613us;617us;614us;617us;622us;617us;627us;617us;661us;178us;668us;178us;678us;688us;681us;688us;686us;688us;743us;746us;758us;759us;771us;825us;777us;825us;790us;819us;795us;804us;800us;804us;802us;804us;822us;825us;1528us;178us;1627us;552us;1629us;825us;123us;65535us;0us;319us;2us;289us;4us;289us;22us;289us;24us;289us;26us;289us;28us;289us;53us;319us;69us;319us;73us;319us;77us;319us;88us;319us;91us;319us;102us;319us;107us;319us;114us;1700us;123us;319us;126us;319us;130us;319us;133us;319us;137us;319us;140us;319us;142us;319us;152us;1700us;155us;319us;161us;319us;165us;319us;169us;319us;176us;319us;187us;1700us;201us;319us;204us;1700us;225us;319us;239us;289us;243us;289us;246us;289us;258us;289us;262us;289us;264us;289us;270us;289us;281us;319us;301us;289us;311us;289us;316us;319us;320us;321us;363us;319us;366us;319us;373us;319us;376us;319us;378us;319us;390us;1700us;393us;319us;397us;319us;399us;319us;403us;319us;409us;319us;412us;319us;423us;319us;460us;1700us;481us;319us;522us;319us;525us;319us;543us;319us;549us;319us;580us;319us;590us;319us;608us;319us;613us;319us;614us;319us;622us;319us;627us;319us;661us;319us;668us;319us;678us;319us;681us;319us;686us;319us;699us;1700us;722us;1700us;743us;319us;758us;319us;771us;319us;777us;319us;790us;319us;795us;319us;800us;319us;802us;319us;822us;319us;892us;1024us;936us;1024us;956us;1024us;972us;1024us;975us;1024us;986us;1024us;994us;1024us;1018us;1024us;1024us;1024us;1025us;1024us;1028us;1024us;1029us;1024us;1032us;1024us;1034us;1024us;1035us;1024us;1041us;1024us;1045us;1024us;1152us;1024us;1322us;1024us;1324us;1024us;1330us;1024us;1332us;1024us;1339us;1024us;1341us;1024us;1343us;1024us;1528us;319us;1627us;319us;1629us;319us;1672us;1024us;1674us;1024us;1681us;1700us;1685us;1700us;1689us;1700us;1692us;1700us;1695us;1700us;1698us;1700us;123us;65535us;0us;320us;2us;320us;4us;320us;22us;320us;24us;320us;26us;320us;28us;320us;53us;320us;69us;320us;73us;320us;77us;320us;88us;320us;91us;320us;102us;320us;107us;320us;114us;320us;123us;320us;126us;320us;130us;320us;133us;320us;137us;320us;140us;320us;142us;320us;152us;320us;155us;320us;161us;320us;165us;320us;169us;320us;176us;320us;187us;320us;201us;320us;204us;320us;225us;320us;239us;320us;243us;320us;246us;320us;258us;320us;262us;320us;264us;320us;270us;320us;281us;320us;301us;320us;311us;320us;316us;320us;320us;320us;363us;320us;366us;320us;373us;320us;376us;320us;378us;320us;390us;320us;393us;320us;397us;320us;399us;320us;403us;320us;409us;320us;412us;320us;423us;320us;460us;320us;481us;320us;522us;320us;525us;320us;543us;320us;549us;320us;580us;320us;590us;320us;608us;320us;613us;320us;614us;320us;622us;320us;627us;320us;661us;320us;668us;320us;678us;320us;681us;320us;686us;320us;699us;320us;722us;320us;743us;320us;758us;320us;771us;320us;777us;320us;790us;320us;795us;320us;800us;320us;802us;320us;822us;320us;892us;320us;936us;320us;956us;320us;972us;320us;975us;320us;986us;320us;994us;320us;1018us;320us;1024us;320us;1025us;320us;1028us;320us;1029us;320us;1032us;320us;1034us;320us;1035us;320us;1041us;320us;1045us;320us;1152us;320us;1322us;320us;1324us;320us;1330us;320us;1332us;320us;1339us;320us;1341us;320us;1343us;320us;1528us;320us;1627us;320us;1629us;320us;1672us;320us;1674us;320us;1681us;320us;1685us;320us;1689us;320us;1692us;320us;1695us;320us;1698us;320us;1us;65535us;322us;323us;2us;65535us;322us;332us;333us;334us;2us;65535us;322us;338us;333us;338us;4us;65535us;180us;221us;181us;221us;443us;447us;444us;447us;6us;65535us;102us;136us;133us;136us;201us;136us;281us;366us;363us;366us;481us;366us;2us;65535us;282us;283us;364us;365us;3us;65535us;281us;282us;363us;364us;481us;482us;1us;65535us;373us;374us;2us;65535us;373us;385us;376us;377us;2us;65535us;373us;388us;376us;388us;2us;65535us;373us;392us;376us;392us;3us;65535us;316us;317us;393us;394us;525us;526us;8us;65535us;316us;407us;378us;379us;393us;407us;397us;410us;403us;404us;409us;410us;412us;413us;525us;407us;10us;65535us;316us;408us;376us;400us;378us;408us;393us;408us;397us;408us;399us;400us;403us;408us;409us;408us;412us;408us;525us;408us;1us;65535us;431us;436us;2us;65535us;414us;415us;416us;417us;3us;65535us;414us;420us;416us;420us;421us;422us;3us;65535us;447us;448us;553us;554us;559us;560us;4us;65535us;180us;222us;181us;222us;443us;455us;444us;455us;10us;65535us;316us;411us;376us;411us;378us;411us;393us;411us;397us;411us;399us;411us;403us;411us;409us;411us;412us;411us;525us;411us;3us;65535us;355us;467us;443us;465us;444us;465us;2us;65535us;447us;469us;553us;556us;1us;65535us;495us;496us;55us;65535us;424us;940us;429us;940us;471us;981us;829us;940us;892us;940us;911us;940us;914us;940us;915us;940us;920us;940us;921us;940us;924us;940us;926us;940us;927us;940us;936us;940us;940us;981us;941us;981us;943us;981us;945us;981us;948us;981us;950us;981us;956us;940us;960us;981us;962us;981us;964us;981us;972us;940us;975us;940us;986us;940us;994us;940us;1015us;940us;1018us;940us;1024us;940us;1025us;940us;1028us;940us;1029us;940us;1032us;940us;1034us;940us;1035us;940us;1041us;940us;1045us;940us;1095us;940us;1100us;940us;1152us;940us;1183us;940us;1190us;940us;1322us;940us;1324us;940us;1330us;940us;1332us;940us;1339us;940us;1341us;940us;1343us;940us;1655us;981us;1660us;981us;1672us;940us;1674us;940us;26us;65535us;30us;31us;54us;55us;71us;72us;95us;96us;110us;111us;178us;180us;179us;181us;183us;184us;206us;212us;208us;212us;214us;215us;241us;242us;255us;256us;274us;275us;360us;601us;368us;369us;441us;443us;442us;444us;455us;456us;484us;485us;493us;494us;566us;567us;688us;689us;748us;749us;759us;760us;791us;792us;81us;65535us;30us;518us;54us;518us;71us;518us;95us;518us;110us;518us;178us;518us;179us;518us;183us;518us;206us;518us;208us;518us;214us;518us;241us;518us;255us;518us;274us;518us;360us;518us;368us;518us;424us;513us;429us;513us;441us;518us;442us;518us;455us;518us;471us;513us;484us;518us;493us;518us;566us;518us;688us;518us;748us;518us;759us;518us;791us;518us;829us;513us;892us;513us;911us;513us;914us;513us;915us;513us;920us;513us;921us;513us;924us;513us;926us;513us;927us;513us;936us;513us;940us;513us;941us;513us;943us;513us;945us;513us;948us;513us;950us;513us;956us;513us;960us;513us;962us;513us;964us;513us;972us;513us;975us;513us;986us;513us;994us;513us;1015us;513us;1018us;513us;1024us;513us;1025us;513us;1028us;513us;1029us;513us;1032us;513us;1034us;513us;1035us;513us;1041us;513us;1045us;513us;1095us;513us;1100us;513us;1152us;513us;1183us;513us;1190us;513us;1322us;513us;1324us;513us;1330us;513us;1332us;513us;1339us;513us;1341us;513us;1343us;513us;1655us;513us;1660us;513us;1672us;513us;1674us;513us;1us;65535us;452us;453us;4us;65535us;379us;380us;381us;382us;385us;386us;756us;757us;2us;65535us;443us;464us;444us;464us;2us;65535us;371us;372us;472us;473us;2us;65535us;371us;535us;472us;535us;2us;65535us;529us;530us;532us;533us;3us;65535us;529us;539us;532us;539us;1402us;1625us;2us;65535us;522us;523us;1627us;1632us;4us;65535us;522us;547us;543us;544us;549us;550us;1627us;547us;4us;65535us;522us;548us;543us;548us;549us;548us;1627us;548us;2us;65535us;551us;553us;552us;553us;4us;65535us;137us;149us;140us;149us;373us;387us;376us;387us;9us;65535us;181us;574us;444us;574us;567us;574us;690us;740us;692us;740us;695us;740us;719us;740us;725us;740us;765us;740us;87us;65535us;8us;1872us;114us;1872us;152us;1872us;181us;1872us;187us;1872us;191us;1872us;193us;1872us;204us;1872us;295us;1872us;390us;1872us;444us;1872us;451us;1872us;460us;1872us;487us;1872us;503us;1872us;567us;1872us;575us;1872us;634us;1872us;638us;1872us;650us;1872us;653us;1872us;664us;1872us;675us;1872us;690us;1872us;692us;1872us;695us;1872us;699us;1872us;719us;1872us;722us;1872us;725us;1872us;728us;1872us;731us;1872us;734us;1872us;751us;1872us;765us;1872us;852us;1872us;952us;1872us;1021us;1872us;1063us;1872us;1248us;1872us;1251us;1872us;1254us;1872us;1538us;1872us;1571us;1872us;1574us;1872us;1576us;1872us;1640us;1872us;1678us;1872us;1680us;1872us;1681us;1872us;1685us;1872us;1689us;1872us;1692us;1872us;1695us;1872us;1698us;1872us;1700us;1872us;1702us;1872us;1707us;1872us;1711us;1872us;1716us;1872us;1722us;1872us;1725us;1872us;1728us;1872us;1731us;1872us;1737us;1872us;1740us;1872us;1741us;1872us;1743us;1872us;1744us;1872us;1747us;1872us;1751us;1872us;1754us;1872us;1756us;1872us;1759us;1872us;1774us;1872us;1780us;1872us;1786us;1872us;1789us;1872us;1856us;1872us;1860us;1872us;1866us;1872us;1876us;1872us;1882us;1872us;1884us;1872us;1909us;1872us;1911us;1872us;1922us;1872us;88us;65535us;8us;589us;114us;589us;152us;589us;181us;589us;187us;589us;191us;589us;193us;589us;204us;589us;295us;589us;390us;589us;444us;589us;451us;589us;460us;589us;487us;589us;503us;589us;567us;589us;575us;589us;587us;588us;634us;589us;638us;589us;650us;589us;653us;589us;664us;589us;675us;589us;690us;589us;692us;589us;695us;589us;699us;589us;719us;589us;722us;589us;725us;589us;728us;589us;731us;589us;734us;589us;751us;589us;765us;589us;852us;589us;952us;589us;1021us;589us;1063us;589us;1248us;589us;1251us;589us;1254us;589us;1538us;589us;1571us;589us;1574us;589us;1576us;589us;1640us;589us;1678us;589us;1680us;589us;1681us;589us;1685us;589us;1689us;589us;1692us;589us;1695us;589us;1698us;589us;1700us;589us;1702us;589us;1707us;589us;1711us;589us;1716us;589us;1722us;589us;1725us;589us;1728us;589us;1731us;589us;1737us;589us;1740us;589us;1741us;589us;1743us;589us;1744us;589us;1747us;589us;1751us;589us;1754us;589us;1756us;589us;1759us;589us;1774us;589us;1780us;589us;1786us;589us;1789us;589us;1856us;589us;1860us;589us;1866us;589us;1876us;589us;1882us;589us;1884us;589us;1909us;589us;1911us;589us;1922us;589us;4us;65535us;137us;155us;140us;155us;373us;393us;376us;393us;9us;65535us;180us;191us;181us;191us;443us;451us;444us;451us;1621us;1640us;1623us;1640us;1634us;1640us;1636us;1640us;1638us;1640us;1us;65535us;360us;361us;1us;65535us;601us;603us;3us;65535us;608us;609us;622us;611us;627us;612us;5us;65535us;608us;616us;613us;615us;614us;615us;622us;616us;627us;616us;1us;65535us;602us;605us;1us;65535us;627us;628us;4us;65535us;112us;631us;185us;631us;458us;631us;940us;941us;3us;65535us;112us;113us;185us;186us;458us;459us;97us;65535us;8us;1763us;114us;1763us;152us;1763us;181us;1763us;187us;1763us;191us;1763us;193us;1763us;204us;1763us;295us;1763us;390us;1763us;444us;1763us;451us;1763us;460us;1763us;487us;1763us;503us;1763us;528us;1873us;567us;1763us;575us;1763us;576us;1873us;619us;646us;632us;1873us;634us;1763us;638us;1763us;643us;644us;650us;1763us;653us;1763us;664us;1763us;675us;1763us;690us;1763us;692us;1763us;695us;1763us;699us;1763us;719us;1763us;722us;1763us;725us;1763us;728us;1763us;731us;1763us;734us;1763us;751us;1763us;765us;1763us;852us;1763us;952us;1873us;1021us;1763us;1063us;1763us;1248us;1763us;1251us;1763us;1254us;1763us;1395us;1873us;1396us;1873us;1538us;1763us;1571us;1763us;1574us;1763us;1576us;1763us;1578us;1873us;1640us;1763us;1678us;1763us;1680us;1763us;1681us;1763us;1685us;1763us;1689us;1763us;1692us;1763us;1695us;1763us;1698us;1763us;1700us;1763us;1702us;1763us;1707us;1763us;1711us;1763us;1716us;1763us;1722us;1763us;1725us;1763us;1728us;1763us;1731us;1763us;1737us;1763us;1740us;1763us;1741us;1763us;1743us;1763us;1744us;1763us;1747us;1763us;1751us;1763us;1754us;1763us;1756us;1763us;1759us;1763us;1762us;646us;1764us;646us;1774us;1763us;1780us;1763us;1786us;1763us;1789us;1763us;1856us;1763us;1860us;1763us;1866us;1763us;1876us;1763us;1882us;1763us;1884us;1763us;1909us;1763us;1911us;1763us;1922us;1763us;3us;65535us;361us;362us;611us;623us;628us;629us;3us;65535us;634us;635us;1678us;636us;1680us;637us;3us;65535us;619us;620us;1762us;641us;1764us;642us;4us;65535us;634us;640us;638us;639us;1678us;640us;1680us;640us;1us;65535us;664us;665us;3us;65535us;181us;573us;444us;573us;567us;573us;5us;65535us;181us;678us;444us;678us;567us;678us;680us;681us;685us;686us;3us;65535us;678us;679us;681us;682us;686us;687us;3us;65535us;678us;685us;681us;685us;686us;685us;4us;65535us;181us;721us;444us;721us;567us;721us;689us;690us;3us;65535us;181us;680us;444us;680us;567us;680us;3us;65535us;181us;683us;444us;683us;567us;683us;8us;65535us;690us;741us;692us;741us;695us;741us;719us;741us;725us;741us;728us;729us;731us;732us;765us;741us;8us;65535us;690us;727us;692us;727us;695us;727us;719us;727us;725us;727us;728us;727us;731us;727us;765us;727us;6us;65535us;690us;694us;692us;693us;695us;696us;719us;720us;725us;726us;765us;766us;3us;65535us;580us;581us;590us;591us;743us;744us;3us;65535us;580us;742us;590us;742us;743us;742us;3us;65535us;196us;197us;199us;200us;746us;747us;4us;65535us;31us;284us;242us;284us;256us;284us;275us;284us;6us;65535us;31us;756us;72us;223us;96us;223us;242us;756us;256us;756us;275us;756us;1us;65535us;760us;761us;1us;65535us;761us;762us;120us;65535us;6us;1106us;31us;277us;117us;1106us;119us;1106us;242us;277us;256us;277us;275us;276us;279us;1106us;355us;784us;427us;1106us;432us;1106us;443us;784us;444us;784us;474us;1106us;497us;1106us;774us;1106us;780us;1106us;832us;1106us;836us;1106us;846us;1106us;1047us;1106us;1053us;1106us;1069us;1106us;1071us;1106us;1074us;1106us;1077us;1106us;1096us;1106us;1101us;1106us;1107us;1106us;1110us;1106us;1113us;1106us;1119us;1106us;1123us;1106us;1127us;1106us;1133us;1106us;1135us;1106us;1140us;1106us;1142us;1106us;1144us;1106us;1146us;1106us;1148us;1106us;1150us;1106us;1154us;1106us;1164us;1106us;1171us;1106us;1177us;1106us;1179us;1106us;1184us;1106us;1188us;1106us;1191us;1106us;1195us;1106us;1198us;1106us;1201us;1106us;1203us;1106us;1206us;1106us;1208us;1106us;1257us;1106us;1259us;1106us;1263us;1106us;1265us;1106us;1267us;1106us;1269us;1106us;1271us;1106us;1273us;1106us;1275us;1106us;1277us;1106us;1279us;1106us;1281us;1106us;1283us;1106us;1285us;1106us;1287us;1106us;1289us;1106us;1291us;1106us;1293us;1106us;1295us;1106us;1297us;1106us;1299us;1106us;1301us;1106us;1303us;1106us;1304us;1106us;1305us;1106us;1306us;1106us;1309us;1106us;1319us;1106us;1348us;1106us;1349us;1106us;1353us;1106us;1355us;1106us;1358us;1106us;1359us;1106us;1361us;1106us;1364us;1106us;1366us;1106us;1368us;1106us;1370us;1106us;1452us;1106us;1459us;1106us;1466us;1106us;1473us;1106us;1490us;1106us;1497us;1106us;1498us;1106us;1504us;1106us;1510us;1106us;1511us;1106us;1512us;1106us;1524us;1106us;1530us;1106us;1540us;1106us;1553us;1106us;1555us;1106us;1558us;1106us;1559us;1106us;1585us;1106us;1590us;1106us;1615us;1106us;1657us;1106us;1662us;1106us;2053us;1106us;2057us;1106us;7us;65535us;31us;280us;242us;280us;256us;280us;275us;280us;355us;785us;443us;785us;444us;785us;120us;65535us;6us;1077us;31us;279us;117us;1110us;119us;1110us;242us;279us;256us;279us;275us;278us;279us;1077us;355us;786us;427us;1077us;432us;1077us;443us;786us;444us;786us;474us;1077us;497us;1077us;774us;1077us;780us;1077us;832us;1077us;836us;1077us;846us;1077us;1047us;1077us;1053us;1077us;1069us;1077us;1071us;1077us;1074us;1077us;1077us;1077us;1096us;1077us;1101us;1077us;1107us;1077us;1110us;1077us;1113us;1077us;1119us;1077us;1123us;1077us;1127us;1077us;1133us;1077us;1135us;1110us;1140us;1110us;1142us;1110us;1144us;1110us;1146us;1110us;1148us;1110us;1150us;1110us;1154us;1077us;1164us;1077us;1171us;1077us;1177us;1110us;1179us;1110us;1184us;1077us;1188us;1077us;1191us;1077us;1195us;1077us;1198us;1077us;1201us;1077us;1203us;1077us;1206us;1110us;1208us;1077us;1257us;1110us;1259us;1110us;1263us;1110us;1265us;1110us;1267us;1110us;1269us;1110us;1271us;1110us;1273us;1110us;1275us;1110us;1277us;1110us;1279us;1110us;1281us;1110us;1283us;1110us;1285us;1110us;1287us;1110us;1289us;1110us;1291us;1110us;1293us;1110us;1295us;1110us;1297us;1110us;1299us;1110us;1301us;1110us;1303us;1110us;1304us;1110us;1305us;1110us;1306us;1110us;1309us;1077us;1319us;1077us;1348us;1110us;1349us;1077us;1353us;1110us;1355us;1077us;1358us;1110us;1359us;1077us;1361us;1110us;1364us;1110us;1366us;1110us;1368us;1110us;1370us;1110us;1452us;1077us;1459us;1110us;1466us;1077us;1473us;1077us;1490us;1077us;1497us;1077us;1498us;1077us;1504us;1077us;1510us;1077us;1511us;1077us;1512us;1077us;1524us;1110us;1530us;1077us;1540us;1077us;1553us;1077us;1555us;1110us;1558us;1110us;1559us;1110us;1585us;1110us;1590us;1110us;1615us;1110us;1657us;1077us;1662us;1077us;2053us;1110us;2057us;1110us;119us;65535us;6us;1116us;31us;1116us;117us;1116us;119us;1116us;242us;1116us;256us;1116us;279us;1116us;355us;787us;427us;1116us;432us;1116us;443us;787us;444us;787us;474us;1116us;497us;1116us;774us;1116us;780us;1116us;832us;1116us;836us;1116us;846us;1116us;1047us;1116us;1053us;1116us;1069us;1116us;1071us;1116us;1074us;1116us;1077us;1116us;1096us;1116us;1101us;1116us;1107us;1116us;1110us;1116us;1113us;1116us;1119us;1116us;1123us;1116us;1127us;1116us;1133us;1116us;1135us;1116us;1140us;1116us;1142us;1116us;1144us;1116us;1146us;1116us;1148us;1116us;1150us;1116us;1154us;1116us;1164us;1116us;1171us;1116us;1177us;1116us;1179us;1116us;1184us;1116us;1188us;1116us;1191us;1116us;1195us;1116us;1198us;1116us;1201us;1116us;1203us;1116us;1206us;1116us;1208us;1116us;1257us;1116us;1259us;1116us;1263us;1116us;1265us;1116us;1267us;1116us;1269us;1116us;1271us;1116us;1273us;1116us;1275us;1116us;1277us;1116us;1279us;1116us;1281us;1116us;1283us;1116us;1285us;1116us;1287us;1116us;1289us;1116us;1291us;1116us;1293us;1116us;1295us;1116us;1297us;1116us;1299us;1116us;1301us;1116us;1303us;1116us;1304us;1116us;1305us;1116us;1306us;1116us;1309us;1116us;1319us;1116us;1348us;1116us;1349us;1116us;1353us;1116us;1355us;1116us;1358us;1116us;1359us;1116us;1361us;1116us;1364us;1116us;1366us;1116us;1368us;1116us;1370us;1116us;1452us;1116us;1459us;1116us;1466us;1116us;1473us;1116us;1490us;1116us;1497us;1116us;1498us;1116us;1504us;1116us;1510us;1116us;1511us;1116us;1512us;1116us;1524us;1116us;1530us;1116us;1540us;1116us;1553us;1116us;1555us;1116us;1558us;1116us;1559us;1116us;1585us;1116us;1590us;1116us;1615us;1116us;1657us;1116us;1662us;1116us;2053us;1116us;2057us;1116us;3us;65535us;355us;446us;443us;445us;444us;445us;5us;65535us;778us;779us;781us;782us;1102us;1103us;1192us;1193us;1204us;1205us;120us;65535us;6us;773us;31us;773us;117us;773us;119us;773us;242us;773us;256us;773us;275us;773us;279us;773us;355us;773us;427us;773us;432us;773us;443us;773us;444us;773us;474us;773us;497us;773us;774us;773us;780us;773us;832us;773us;836us;773us;846us;773us;1047us;773us;1053us;773us;1069us;773us;1071us;773us;1074us;773us;1077us;773us;1096us;773us;1101us;773us;1107us;773us;1110us;773us;1113us;773us;1119us;773us;1123us;773us;1127us;773us;1133us;773us;1135us;773us;1140us;773us;1142us;773us;1144us;773us;1146us;773us;1148us;773us;1150us;773us;1154us;773us;1164us;773us;1171us;773us;1177us;773us;1179us;773us;1184us;773us;1188us;773us;1191us;773us;1195us;773us;1198us;773us;1201us;773us;1203us;773us;1206us;773us;1208us;773us;1257us;773us;1259us;773us;1263us;773us;1265us;773us;1267us;773us;1269us;773us;1271us;773us;1273us;773us;1275us;773us;1277us;773us;1279us;773us;1281us;773us;1283us;773us;1285us;773us;1287us;773us;1289us;773us;1291us;773us;1293us;773us;1295us;773us;1297us;773us;1299us;773us;1301us;773us;1303us;773us;1304us;773us;1305us;773us;1306us;773us;1309us;773us;1319us;773us;1348us;773us;1349us;773us;1353us;773us;1355us;773us;1358us;773us;1359us;773us;1361us;773us;1364us;773us;1366us;773us;1368us;773us;1370us;773us;1452us;773us;1459us;773us;1466us;773us;1473us;773us;1490us;773us;1497us;773us;1498us;773us;1504us;773us;1510us;773us;1511us;773us;1512us;773us;1524us;773us;1530us;773us;1540us;773us;1553us;773us;1555us;773us;1558us;773us;1559us;773us;1585us;773us;1590us;773us;1615us;773us;1657us;773us;1662us;773us;2053us;773us;2057us;773us;1us;65535us;795us;796us;1us;65535us;795us;798us;3us;65535us;795us;799us;800us;801us;802us;803us;2us;65535us;804us;805us;819us;808us;1us;65535us;790us;791us;4us;65535us;771us;772us;777us;778us;1627us;1628us;1629us;1630us;2us;65535us;820us;821us;823us;824us;5us;65535us;771us;820us;777us;820us;822us;823us;1627us;820us;1629us;820us;2us;65535us;552us;826us;825us;826us;1us;65535us;832us;833us;2us;65535us;832us;840us;836us;837us;1us;65535us;841us;842us;1us;65535us;842us;843us;1us;65535us;844us;845us;2us;65535us;844us;850us;848us;849us;307us;65535us;6us;887us;8us;1891us;31us;887us;114us;1891us;117us;887us;119us;887us;152us;1891us;181us;1891us;187us;1891us;191us;1891us;193us;1891us;204us;1891us;242us;887us;256us;887us;279us;887us;295us;1891us;336us;887us;340us;887us;345us;887us;390us;1891us;424us;887us;427us;887us;429us;887us;432us;887us;444us;1891us;451us;1891us;460us;1891us;471us;887us;474us;887us;487us;1891us;497us;887us;503us;1891us;528us;1891us;531us;887us;567us;1891us;575us;1891us;576us;1891us;619us;1891us;632us;1891us;634us;1891us;638us;1891us;643us;1891us;650us;1891us;653us;1891us;664us;1891us;675us;1891us;690us;1891us;692us;1891us;695us;1891us;699us;1891us;701us;887us;713us;887us;719us;1891us;722us;1891us;725us;1891us;728us;1891us;731us;1891us;734us;1891us;751us;1891us;765us;1891us;774us;887us;780us;887us;829us;887us;832us;887us;836us;887us;846us;887us;852us;1891us;892us;887us;911us;887us;914us;887us;915us;887us;920us;887us;921us;887us;924us;887us;926us;887us;927us;887us;936us;887us;940us;887us;941us;887us;943us;887us;945us;887us;948us;887us;950us;887us;952us;1891us;956us;887us;960us;887us;962us;887us;964us;887us;972us;887us;975us;887us;986us;887us;994us;887us;1015us;887us;1018us;887us;1021us;1891us;1024us;887us;1025us;887us;1028us;887us;1029us;887us;1032us;887us;1034us;887us;1035us;887us;1041us;887us;1045us;887us;1047us;887us;1053us;887us;1063us;1891us;1069us;887us;1071us;887us;1074us;887us;1077us;887us;1095us;887us;1096us;887us;1100us;887us;1101us;887us;1107us;887us;1110us;887us;1113us;887us;1119us;887us;1123us;887us;1127us;887us;1133us;887us;1135us;887us;1140us;887us;1142us;887us;1144us;887us;1146us;887us;1148us;887us;1150us;887us;1152us;887us;1154us;887us;1164us;887us;1171us;887us;1177us;887us;1179us;887us;1183us;887us;1184us;887us;1188us;887us;1190us;887us;1191us;887us;1195us;887us;1198us;887us;1201us;887us;1203us;887us;1206us;887us;1208us;887us;1248us;1891us;1251us;1891us;1254us;1891us;1257us;887us;1259us;887us;1263us;887us;1265us;887us;1267us;887us;1269us;887us;1271us;887us;1273us;887us;1275us;887us;1277us;887us;1279us;887us;1281us;887us;1283us;887us;1285us;887us;1287us;887us;1289us;887us;1291us;887us;1293us;887us;1295us;887us;1297us;887us;1299us;887us;1301us;887us;1303us;887us;1304us;887us;1305us;887us;1306us;887us;1309us;887us;1319us;887us;1322us;887us;1324us;887us;1330us;887us;1332us;887us;1339us;887us;1341us;887us;1343us;887us;1348us;887us;1349us;887us;1353us;887us;1355us;887us;1358us;887us;1359us;887us;1361us;887us;1364us;887us;1366us;887us;1368us;887us;1370us;887us;1372us;887us;1373us;887us;1374us;887us;1375us;887us;1377us;887us;1378us;887us;1380us;887us;1381us;887us;1383us;887us;1384us;887us;1386us;887us;1387us;887us;1389us;887us;1390us;887us;1392us;887us;1393us;887us;1395us;1891us;1396us;1891us;1399us;887us;1400us;887us;1407us;887us;1409us;887us;1411us;887us;1412us;887us;1413us;887us;1416us;887us;1421us;887us;1429us;887us;1430us;887us;1433us;887us;1434us;887us;1452us;887us;1459us;887us;1466us;887us;1473us;887us;1490us;887us;1497us;887us;1498us;887us;1504us;887us;1510us;887us;1511us;887us;1512us;887us;1524us;887us;1530us;887us;1538us;1891us;1540us;887us;1553us;887us;1555us;887us;1558us;887us;1559us;887us;1565us;887us;1571us;1891us;1574us;1891us;1576us;1891us;1578us;1891us;1580us;887us;1585us;887us;1590us;887us;1615us;887us;1640us;1891us;1648us;887us;1655us;887us;1657us;887us;1660us;887us;1662us;887us;1672us;887us;1674us;887us;1678us;1891us;1680us;1891us;1681us;1891us;1685us;1891us;1689us;1891us;1692us;1891us;1695us;1891us;1698us;1891us;1700us;1891us;1702us;1891us;1707us;1891us;1711us;1891us;1716us;1891us;1722us;1891us;1725us;1891us;1728us;1891us;1731us;1891us;1737us;1891us;1740us;1891us;1741us;1891us;1743us;1891us;1744us;1891us;1747us;1891us;1751us;1891us;1754us;1891us;1756us;1891us;1759us;1891us;1762us;1891us;1764us;1891us;1774us;1891us;1780us;1891us;1786us;1891us;1789us;1891us;1856us;1891us;1860us;1891us;1866us;1891us;1876us;1891us;1882us;1891us;1884us;1891us;1893us;887us;1909us;1891us;1911us;1891us;1922us;1891us;2053us;887us;2057us;887us;1us;65535us;881us;882us;4us;65535us;885us;886us;1769us;884us;1864us;884us;1937us;884us;3us;65535us;1769us;1770us;1864us;1865us;1937us;1938us;210us;65535us;6us;1479us;31us;1479us;117us;1479us;119us;1479us;242us;1479us;256us;1479us;279us;1479us;336us;1479us;340us;1479us;345us;1479us;424us;982us;427us;1479us;429us;982us;432us;1479us;471us;982us;474us;1479us;497us;1479us;531us;1479us;701us;1479us;713us;1479us;774us;1479us;780us;1479us;829us;982us;832us;1479us;836us;1479us;846us;1479us;892us;982us;911us;982us;914us;982us;915us;982us;920us;982us;921us;982us;924us;982us;926us;982us;927us;982us;936us;982us;940us;982us;941us;982us;943us;982us;945us;982us;948us;982us;950us;982us;956us;982us;960us;982us;962us;982us;964us;982us;972us;982us;975us;982us;986us;982us;994us;982us;1015us;982us;1018us;982us;1024us;982us;1025us;982us;1028us;982us;1029us;982us;1032us;982us;1034us;982us;1035us;982us;1041us;982us;1045us;982us;1047us;1479us;1053us;1479us;1069us;1479us;1071us;1479us;1074us;1479us;1077us;1479us;1095us;982us;1096us;1479us;1100us;982us;1101us;1479us;1107us;1479us;1110us;1479us;1113us;1479us;1119us;1479us;1123us;1479us;1127us;1479us;1133us;1479us;1135us;1479us;1140us;1479us;1142us;1479us;1144us;1479us;1146us;1479us;1148us;1479us;1150us;1479us;1152us;982us;1154us;1479us;1164us;1479us;1171us;1479us;1177us;1479us;1179us;1479us;1183us;982us;1184us;1479us;1188us;1479us;1190us;982us;1191us;1479us;1195us;1479us;1198us;1479us;1201us;1479us;1203us;1479us;1206us;1479us;1208us;1479us;1257us;1479us;1259us;1479us;1263us;1479us;1265us;1479us;1267us;1479us;1269us;1479us;1271us;1479us;1273us;1479us;1275us;1479us;1277us;1479us;1279us;1479us;1281us;1479us;1283us;1479us;1285us;1479us;1287us;1479us;1289us;1479us;1291us;1479us;1293us;1479us;1295us;1479us;1297us;1479us;1299us;1479us;1301us;1479us;1303us;1479us;1304us;1479us;1305us;1479us;1306us;1479us;1309us;1479us;1319us;1479us;1322us;982us;1324us;982us;1330us;982us;1332us;982us;1339us;982us;1341us;982us;1343us;982us;1348us;1479us;1349us;1479us;1353us;1479us;1355us;1479us;1358us;1479us;1359us;1479us;1361us;1479us;1364us;1479us;1366us;1479us;1368us;1479us;1370us;1479us;1372us;1479us;1373us;1479us;1374us;1479us;1375us;1479us;1377us;1479us;1378us;1479us;1380us;1479us;1381us;1479us;1383us;1479us;1384us;1479us;1386us;1479us;1387us;1479us;1389us;1479us;1390us;1479us;1392us;1479us;1393us;1479us;1399us;1479us;1400us;1479us;1407us;1479us;1409us;1479us;1411us;1479us;1412us;1479us;1413us;1479us;1416us;1479us;1421us;1479us;1429us;1479us;1430us;1479us;1433us;1479us;1434us;1479us;1452us;1479us;1459us;1479us;1466us;1479us;1473us;1479us;1490us;1479us;1497us;1479us;1498us;1479us;1504us;1479us;1510us;1479us;1511us;1479us;1512us;1479us;1524us;1479us;1530us;1479us;1540us;1479us;1553us;1479us;1555us;1479us;1558us;1479us;1559us;1479us;1565us;1479us;1580us;1479us;1585us;1479us;1590us;1479us;1615us;1479us;1648us;1479us;1655us;982us;1657us;1479us;1660us;982us;1662us;1479us;1672us;982us;1674us;982us;1893us;1479us;2053us;1479us;2057us;1479us;3us;65535us;424us;425us;429us;430us;829us;830us;1us;65535us;370us;371us;1us;65535us;370us;891us;36us;65535us;890us;914us;893us;1018us;897us;1332us;898us;1341us;900us;914us;901us;914us;902us;914us;903us;914us;904us;914us;905us;914us;906us;914us;907us;914us;908us;914us;909us;914us;910us;914us;937us;1018us;1001us;1018us;1002us;1018us;1003us;1018us;1004us;1018us;1005us;1018us;1006us;1018us;1007us;1018us;1008us;1018us;1009us;1018us;1010us;1018us;1011us;1018us;1012us;1018us;1013us;1018us;1014us;1018us;1085us;1343us;1322us;1330us;1324us;1330us;1338us;1339us;1672us;1330us;1674us;1330us;14us;65535us;424us;890us;429us;890us;829us;890us;914us;900us;915us;901us;920us;902us;921us;903us;924us;904us;926us;905us;927us;906us;1095us;907us;1100us;908us;1183us;909us;1190us;910us;14us;65535us;424us;917us;429us;917us;829us;917us;914us;917us;915us;917us;920us;917us;921us;917us;924us;917us;926us;917us;927us;917us;1095us;917us;1100us;917us;1183us;917us;1190us;917us;14us;65535us;424us;918us;429us;918us;829us;918us;914us;918us;915us;918us;920us;918us;921us;918us;924us;918us;926us;918us;927us;918us;1095us;918us;1100us;918us;1183us;918us;1190us;918us;3us;65535us;930us;931us;932us;933us;956us;957us;3us;65535us;930us;928us;932us;928us;956us;928us;43us;65535us;424us;919us;429us;919us;829us;919us;892us;1027us;911us;912us;914us;919us;915us;919us;920us;919us;921us;919us;924us;919us;926us;919us;927us;919us;936us;1027us;956us;1027us;972us;1027us;975us;1027us;986us;1027us;994us;1027us;1015us;1016us;1018us;1027us;1024us;1027us;1025us;1027us;1028us;1027us;1029us;1027us;1032us;1027us;1034us;1027us;1035us;1027us;1041us;1027us;1045us;1027us;1095us;919us;1100us;919us;1152us;1027us;1183us;919us;1190us;919us;1322us;1027us;1324us;1027us;1330us;1027us;1332us;1027us;1339us;1027us;1341us;1027us;1343us;1027us;1672us;1027us;1674us;1027us;6us;65535us;940us;947us;941us;942us;943us;944us;945us;946us;948us;949us;950us;951us;11us;65535us;940us;959us;941us;959us;943us;959us;945us;959us;948us;959us;950us;959us;960us;961us;962us;963us;964us;965us;1655us;1656us;1660us;1661us;55us;65535us;424us;955us;429us;955us;471us;472us;829us;955us;892us;955us;911us;955us;914us;955us;915us;955us;920us;955us;921us;955us;924us;955us;926us;955us;927us;955us;936us;955us;940us;960us;941us;960us;943us;960us;945us;960us;948us;960us;950us;960us;956us;955us;960us;960us;962us;960us;964us;960us;972us;955us;975us;955us;986us;955us;994us;955us;1015us;955us;1018us;955us;1024us;955us;1025us;955us;1028us;955us;1029us;955us;1032us;955us;1034us;955us;1035us;955us;1041us;955us;1045us;955us;1095us;955us;1100us;955us;1152us;955us;1183us;955us;1190us;955us;1322us;955us;1324us;955us;1330us;955us;1332us;955us;1339us;955us;1341us;955us;1343us;955us;1655us;960us;1660us;960us;1672us;955us;1674us;955us;2us;65535us;956us;987us;986us;987us;27us;65535us;892us;893us;936us;937us;956us;1001us;972us;1012us;975us;1012us;986us;1001us;994us;1009us;1018us;1002us;1024us;1003us;1025us;1004us;1028us;1005us;1029us;1006us;1032us;1007us;1034us;1008us;1035us;1010us;1041us;1011us;1045us;1012us;1152us;1013us;1322us;1014us;1324us;1014us;1330us;1014us;1332us;1014us;1339us;1014us;1341us;1014us;1343us;1014us;1672us;1014us;1674us;1014us;27us;65535us;892us;1019us;936us;1019us;956us;1019us;972us;1019us;975us;1019us;986us;1019us;994us;995us;1018us;1019us;1024us;1019us;1025us;1019us;1028us;1019us;1029us;1019us;1032us;1019us;1034us;1019us;1035us;1019us;1041us;1019us;1045us;1019us;1152us;1019us;1322us;1019us;1324us;1019us;1330us;1019us;1332us;1019us;1339us;1019us;1341us;1019us;1343us;1019us;1672us;1019us;1674us;1019us;27us;65535us;892us;1020us;936us;1020us;956us;1020us;972us;1020us;975us;1020us;986us;1020us;994us;1020us;1018us;1020us;1024us;1020us;1025us;1020us;1028us;1020us;1029us;1020us;1032us;1020us;1034us;1020us;1035us;1020us;1041us;1020us;1045us;1020us;1152us;1020us;1322us;1020us;1324us;1020us;1330us;1020us;1332us;1020us;1339us;1020us;1341us;1020us;1343us;1020us;1672us;1020us;1674us;1020us;2us;65535us;967us;968us;1038us;1039us;2us;65535us;967us;1036us;1038us;1036us;3us;65535us;972us;973us;975us;976us;1045us;1046us;27us;65535us;279us;1111us;427us;428us;432us;433us;474us;475us;497us;498us;774us;775us;780us;781us;846us;847us;1077us;1111us;1096us;1097us;1101us;1102us;1110us;1111us;1113us;1114us;1133us;1134us;1154us;1155us;1164us;1165us;1171us;1172us;1184us;1185us;1188us;1189us;1191us;1192us;1195us;1196us;1201us;1202us;1203us;1204us;1309us;1310us;1355us;1356us;1359us;1360us;1657us;1658us;6us;65535us;1144us;1145us;1146us;1147us;1259us;1260us;1585us;1586us;1590us;1591us;1615us;1616us;5us;65535us;1127us;1128us;1208us;1209us;1349us;1350us;1553us;1554us;1662us;1663us;52us;65535us;6us;1066us;279us;1052us;427us;1052us;432us;1052us;474us;1052us;497us;1052us;774us;1052us;780us;1052us;832us;841us;836us;841us;846us;1052us;1047us;1048us;1053us;1054us;1074us;1075us;1077us;1052us;1096us;1052us;1101us;1052us;1107us;1108us;1110us;1052us;1113us;1052us;1119us;1120us;1123us;1124us;1127us;1058us;1133us;1052us;1154us;1052us;1164us;1052us;1171us;1052us;1184us;1052us;1188us;1052us;1191us;1052us;1195us;1052us;1198us;1199us;1201us;1052us;1203us;1052us;1208us;1058us;1309us;1052us;1319us;1320us;1349us;1058us;1355us;1052us;1359us;1052us;1466us;1471us;1473us;1474us;1490us;1491us;1497us;1499us;1498us;1499us;1510us;1532us;1511us;1532us;1512us;1532us;1530us;1531us;1553us;1058us;1657us;1052us;1662us;1058us;1us;65535us;6us;7us;57us;65535us;6us;1062us;279us;1062us;427us;1062us;432us;1062us;474us;1062us;497us;1062us;774us;1062us;780us;1062us;832us;1062us;836us;1062us;846us;1062us;1047us;1062us;1053us;1062us;1069us;1070us;1071us;1072us;1074us;1062us;1077us;1062us;1096us;1062us;1101us;1062us;1107us;1062us;1110us;1062us;1113us;1062us;1119us;1062us;1123us;1062us;1127us;1062us;1133us;1062us;1154us;1062us;1164us;1062us;1171us;1062us;1184us;1062us;1188us;1062us;1191us;1062us;1195us;1062us;1198us;1062us;1201us;1062us;1203us;1062us;1208us;1062us;1309us;1062us;1319us;1062us;1349us;1062us;1355us;1062us;1359us;1062us;1452us;1550us;1466us;1062us;1473us;1062us;1490us;1062us;1497us;1062us;1498us;1062us;1504us;1551us;1510us;1062us;1511us;1062us;1512us;1062us;1530us;1062us;1540us;1552us;1553us;1062us;1657us;1062us;1662us;1062us;204us;65535us;56us;59us;61us;63us;78us;81us;156us;158us;162us;164us;166us;168us;170us;172us;193us;195us;214us;217us;247us;250us;289us;290us;292us;294us;295us;297us;302us;304us;305us;307us;312us;314us;322us;2098us;324us;2098us;372us;375us;380us;383us;394us;2098us;400us;401us;404us;405us;431us;2098us;447us;450us;451us;454us;471us;479us;473us;2098us;485us;491us;486us;490us;487us;489us;494us;502us;496us;2098us;503us;505us;528us;2098us;536us;538us;544us;546us;553us;558us;570us;571us;581us;583us;591us;593us;601us;606us;689us;691us;692us;698us;695us;697us;701us;703us;713us;716us;719us;724us;728us;730us;734us;736us;749us;755us;750us;754us;751us;753us;760us;763us;765us;767us;778us;789us;781us;789us;831us;835us;837us;839us;911us;913us;915us;2098us;920us;2098us;921us;2098us;924us;2098us;934us;939us;935us;939us;936us;938us;952us;954us;956us;992us;986us;992us;987us;989us;994us;1000us;995us;997us;1013us;1176us;1015us;1017us;1021us;1023us;1025us;1026us;1028us;2098us;1029us;2098us;1032us;2098us;1040us;1043us;1041us;1042us;1048us;1050us;1063us;1065us;1102us;789us;1120us;1122us;1124us;1126us;1127us;1060us;1128us;1130us;1135us;1139us;1136us;1138us;1148us;1316us;1150us;1316us;1152us;2098us;1153us;2098us;1154us;2098us;1155us;2098us;1163us;1170us;1164us;1169us;1165us;1167us;1177us;1181us;1179us;1182us;1192us;789us;1204us;789us;1208us;1060us;1233us;1315us;1237us;1363us;1248us;1250us;1251us;1253us;1254us;1256us;1262us;1461us;1263us;2098us;1265us;2098us;1267us;2098us;1269us;2098us;1271us;2098us;1273us;2098us;1275us;2098us;1277us;2098us;1279us;2098us;1281us;2098us;1283us;2098us;1285us;2098us;1287us;2098us;1289us;2098us;1291us;2098us;1293us;2098us;1295us;2098us;1297us;2098us;1299us;2098us;1301us;2098us;1310us;1312us;1324us;1328us;1325us;1327us;1337us;1347us;1338us;1346us;1339us;1345us;1349us;1060us;1353us;1354us;1355us;1357us;1364us;2098us;1366us;2098us;1368us;2098us;1370us;2098us;1403us;1465us;1419us;1424us;1420us;1424us;1421us;1423us;1440us;1465us;1443us;1465us;1452us;1457us;1453us;1455us;1473us;1478us;1474us;1476us;1491us;1493us;1497us;1503us;1498us;1503us;1499us;1501us;1504us;1509us;1505us;1507us;1510us;1523us;1511us;1523us;1512us;1523us;1514us;2092us;1540us;1545us;1541us;1543us;1553us;1060us;1555us;2098us;1585us;1589us;1614us;2098us;1615us;2098us;1648us;1653us;1649us;1651us;1662us;1061us;1663us;1665us;1681us;1683us;1685us;1687us;1689us;1691us;1695us;1697us;1702us;1704us;1707us;1709us;1711us;1713us;1716us;1718us;1722us;1724us;1728us;1730us;1737us;1739us;1743us;1746us;1744us;1746us;1747us;1749us;1751us;1753us;1756us;1758us;1859us;1914us;1877us;1880us;1878us;1880us;1882us;1890us;1883us;1889us;1884us;1888us;1885us;1887us;1904us;2098us;1909us;1920us;1911us;2098us;1916us;2098us;1958us;2098us;2008us;2098us;4us;65535us;1098us;1099us;1104us;1105us;1187us;1188us;1194us;1195us;116us;65535us;6us;1068us;31us;32us;117us;118us;119us;120us;242us;257us;256us;257us;279us;1068us;427us;1068us;432us;1068us;474us;1068us;497us;1068us;774us;1068us;780us;1068us;832us;1068us;836us;1068us;846us;1068us;1047us;1068us;1053us;1068us;1069us;1068us;1071us;1068us;1074us;1068us;1077us;1068us;1096us;1068us;1101us;1068us;1107us;1068us;1110us;1068us;1113us;1068us;1119us;1068us;1123us;1068us;1127us;1068us;1133us;1068us;1135us;1136us;1140us;1141us;1142us;1143us;1144us;1057us;1146us;1057us;1148us;1233us;1150us;1233us;1154us;1068us;1164us;1068us;1171us;1068us;1177us;1178us;1179us;1180us;1184us;1068us;1188us;1068us;1191us;1068us;1195us;1068us;1198us;1068us;1201us;1068us;1203us;1068us;1206us;1207us;1208us;1068us;1257us;1210us;1259us;1057us;1263us;1211us;1265us;1212us;1267us;1213us;1269us;1214us;1271us;1215us;1273us;1216us;1275us;1217us;1277us;1218us;1279us;1219us;1281us;1220us;1283us;1221us;1285us;1222us;1287us;1223us;1289us;1224us;1291us;1225us;1293us;1226us;1295us;1227us;1297us;1228us;1299us;1229us;1301us;1230us;1303us;1231us;1304us;1232us;1305us;1232us;1306us;1232us;1309us;1068us;1319us;1068us;1348us;1234us;1349us;1068us;1353us;1235us;1355us;1068us;1358us;1236us;1359us;1068us;1361us;1237us;1364us;1238us;1366us;1239us;1368us;1240us;1370us;1242us;1452us;1068us;1459us;1241us;1466us;1068us;1473us;1068us;1490us;1068us;1497us;1068us;1498us;1068us;1504us;1068us;1510us;1068us;1511us;1068us;1512us;1068us;1524us;1243us;1530us;1068us;1540us;1068us;1553us;1068us;1555us;1244us;1558us;1245us;1559us;1246us;1585us;1057us;1590us;1057us;1615us;1057us;1657us;1068us;1662us;1068us;2053us;1247us;2057us;1247us;2us;65535us;1148us;1149us;1150us;1151us;1us;65535us;1448us;1449us;4us;65535us;1120us;1121us;1124us;1125us;1128us;1129us;1131us;1132us;4us;65535us;1322us;1323us;1324us;1325us;1672us;1673us;1674us;1675us;9us;65535us;1322us;1337us;1324us;1337us;1330us;1337us;1332us;1337us;1339us;1337us;1341us;1337us;1343us;1337us;1672us;1337us;1674us;1337us;9us;65535us;1322us;1329us;1324us;1329us;1330us;1331us;1332us;1333us;1339us;1340us;1341us;1342us;1343us;1344us;1672us;1329us;1674us;1329us;1us;65535us;1014us;1336us;1us;65535us;1337us;1338us;2us;65535us;1136us;1137us;1237us;1362us;2us;65535us;1136us;1351us;1237us;1351us;1us;65535us;1351us;1352us;116us;65535us;6us;1261us;31us;1261us;117us;1261us;119us;1261us;242us;1261us;256us;1261us;279us;1261us;427us;1261us;432us;1261us;474us;1261us;497us;1261us;774us;1261us;780us;1261us;832us;1261us;836us;1261us;846us;1261us;1047us;1261us;1053us;1261us;1069us;1261us;1071us;1261us;1074us;1261us;1077us;1261us;1096us;1261us;1101us;1261us;1107us;1261us;1110us;1261us;1113us;1261us;1119us;1261us;1123us;1261us;1127us;1261us;1133us;1261us;1135us;1261us;1140us;1261us;1142us;1261us;1144us;1261us;1146us;1261us;1148us;1261us;1150us;1261us;1154us;1261us;1164us;1261us;1171us;1261us;1177us;1261us;1179us;1261us;1184us;1261us;1188us;1261us;1191us;1261us;1195us;1261us;1198us;1261us;1201us;1261us;1203us;1261us;1206us;1261us;1208us;1261us;1257us;1261us;1259us;1261us;1263us;1261us;1265us;1261us;1267us;1261us;1269us;1261us;1271us;1261us;1273us;1261us;1275us;1261us;1277us;1261us;1279us;1261us;1281us;1261us;1283us;1261us;1285us;1261us;1287us;1261us;1289us;1261us;1291us;1261us;1293us;1261us;1295us;1261us;1297us;1261us;1299us;1261us;1301us;1261us;1303us;1261us;1304us;1261us;1305us;1261us;1306us;1261us;1309us;1261us;1319us;1261us;1348us;1261us;1349us;1261us;1353us;1261us;1355us;1261us;1358us;1261us;1359us;1261us;1361us;1261us;1364us;1261us;1366us;1261us;1368us;1261us;1370us;1261us;1452us;1261us;1459us;1262us;1466us;1261us;1473us;1261us;1490us;1261us;1497us;1261us;1498us;1261us;1504us;1261us;1510us;1261us;1511us;1261us;1512us;1261us;1524us;1261us;1530us;1261us;1540us;1261us;1553us;1261us;1555us;1261us;1558us;1261us;1559us;1261us;1585us;1261us;1590us;1261us;1615us;1261us;1657us;1261us;1662us;1261us;2053us;1261us;2057us;1261us;134us;65535us;6us;1258us;31us;1258us;117us;1258us;119us;1258us;242us;1258us;256us;1258us;279us;1258us;427us;1258us;432us;1258us;474us;1258us;497us;1258us;774us;1258us;780us;1258us;832us;1258us;836us;1258us;846us;1258us;1047us;1258us;1053us;1258us;1069us;1258us;1071us;1258us;1074us;1258us;1077us;1258us;1096us;1258us;1101us;1258us;1107us;1258us;1110us;1258us;1113us;1258us;1119us;1258us;1123us;1258us;1127us;1258us;1133us;1258us;1135us;1258us;1140us;1258us;1142us;1258us;1144us;1258us;1146us;1258us;1148us;1258us;1150us;1258us;1154us;1258us;1164us;1258us;1171us;1258us;1177us;1258us;1179us;1258us;1184us;1258us;1188us;1258us;1191us;1258us;1195us;1258us;1198us;1258us;1201us;1258us;1203us;1258us;1206us;1258us;1208us;1258us;1257us;1258us;1259us;1258us;1263us;1258us;1265us;1258us;1267us;1258us;1269us;1258us;1271us;1258us;1273us;1258us;1275us;1258us;1277us;1258us;1279us;1258us;1281us;1258us;1283us;1258us;1285us;1258us;1287us;1258us;1289us;1258us;1291us;1258us;1293us;1258us;1295us;1258us;1297us;1258us;1299us;1258us;1301us;1258us;1303us;1258us;1304us;1258us;1305us;1258us;1306us;1258us;1309us;1258us;1319us;1258us;1348us;1258us;1349us;1258us;1353us;1258us;1355us;1258us;1358us;1258us;1359us;1258us;1361us;1258us;1364us;1258us;1366us;1258us;1368us;1258us;1370us;1258us;1372us;1376us;1373us;1376us;1374us;1376us;1375us;1376us;1377us;1379us;1378us;1379us;1380us;1382us;1381us;1382us;1383us;1385us;1384us;1385us;1386us;1388us;1387us;1388us;1389us;1391us;1390us;1391us;1392us;1394us;1393us;1394us;1407us;1408us;1409us;1410us;1452us;1258us;1459us;1258us;1466us;1258us;1473us;1258us;1490us;1258us;1497us;1258us;1498us;1258us;1504us;1258us;1510us;1258us;1511us;1258us;1512us;1258us;1524us;1258us;1530us;1258us;1540us;1258us;1553us;1258us;1555us;1258us;1558us;1258us;1559us;1258us;1585us;1258us;1590us;1258us;1615us;1258us;1657us;1258us;1662us;1258us;2053us;1258us;2057us;1258us;135us;65535us;6us;1411us;31us;1411us;117us;1411us;119us;1411us;242us;1411us;256us;1411us;279us;1411us;427us;1411us;432us;1411us;474us;1411us;497us;1411us;774us;1411us;780us;1411us;832us;1411us;836us;1411us;846us;1411us;1047us;1411us;1053us;1411us;1069us;1411us;1071us;1411us;1074us;1411us;1077us;1411us;1096us;1411us;1101us;1411us;1107us;1411us;1110us;1411us;1113us;1411us;1119us;1411us;1123us;1411us;1127us;1411us;1133us;1411us;1135us;1411us;1140us;1411us;1142us;1411us;1144us;1411us;1146us;1411us;1148us;1411us;1150us;1411us;1154us;1411us;1164us;1411us;1171us;1411us;1177us;1411us;1179us;1411us;1184us;1411us;1188us;1411us;1191us;1411us;1195us;1411us;1198us;1411us;1201us;1411us;1203us;1411us;1206us;1411us;1208us;1411us;1257us;1411us;1259us;1411us;1263us;1411us;1265us;1411us;1267us;1411us;1269us;1411us;1271us;1411us;1273us;1411us;1275us;1411us;1277us;1411us;1279us;1411us;1281us;1411us;1283us;1411us;1285us;1411us;1287us;1411us;1289us;1411us;1291us;1411us;1293us;1411us;1295us;1411us;1297us;1411us;1299us;1411us;1301us;1411us;1303us;1411us;1304us;1411us;1305us;1411us;1306us;1411us;1309us;1411us;1319us;1411us;1348us;1411us;1349us;1411us;1353us;1411us;1355us;1411us;1358us;1411us;1359us;1411us;1361us;1411us;1364us;1411us;1366us;1411us;1368us;1411us;1370us;1411us;1372us;1411us;1373us;1411us;1374us;1411us;1375us;1411us;1377us;1411us;1378us;1411us;1380us;1411us;1381us;1411us;1383us;1411us;1384us;1411us;1386us;1411us;1387us;1411us;1389us;1411us;1390us;1411us;1392us;1411us;1393us;1411us;1407us;1411us;1409us;1411us;1452us;1411us;1459us;1411us;1466us;1411us;1473us;1411us;1490us;1411us;1497us;1411us;1498us;1411us;1504us;1411us;1510us;1411us;1511us;1411us;1512us;1411us;1524us;1411us;1530us;1411us;1540us;1412us;1553us;1411us;1555us;1411us;1558us;1411us;1559us;1411us;1585us;1411us;1590us;1411us;1615us;1411us;1648us;1413us;1657us;1411us;1662us;1411us;2053us;1411us;2057us;1411us;4us;65535us;1411us;1414us;1412us;1414us;1413us;1414us;1565us;1568us;148us;65535us;6us;1415us;31us;1415us;117us;1415us;119us;1415us;242us;1415us;256us;1415us;279us;1415us;427us;1415us;432us;1415us;474us;1415us;497us;1415us;701us;702us;713us;714us;774us;1415us;780us;1415us;832us;1415us;836us;1415us;846us;1415us;1047us;1415us;1053us;1415us;1069us;1415us;1071us;1415us;1074us;1415us;1077us;1415us;1096us;1415us;1101us;1415us;1107us;1415us;1110us;1415us;1113us;1415us;1119us;1415us;1123us;1415us;1127us;1415us;1133us;1415us;1135us;1415us;1140us;1415us;1142us;1415us;1144us;1415us;1146us;1415us;1148us;1415us;1150us;1415us;1154us;1415us;1164us;1415us;1171us;1415us;1177us;1415us;1179us;1415us;1184us;1415us;1188us;1415us;1191us;1415us;1195us;1415us;1198us;1415us;1201us;1415us;1203us;1415us;1206us;1415us;1208us;1415us;1257us;1415us;1259us;1415us;1263us;1415us;1265us;1415us;1267us;1415us;1269us;1415us;1271us;1415us;1273us;1415us;1275us;1415us;1277us;1415us;1279us;1415us;1281us;1415us;1283us;1415us;1285us;1415us;1287us;1415us;1289us;1415us;1291us;1415us;1293us;1415us;1295us;1415us;1297us;1415us;1299us;1415us;1301us;1415us;1303us;1415us;1304us;1415us;1305us;1415us;1306us;1415us;1309us;1415us;1319us;1415us;1348us;1415us;1349us;1415us;1353us;1415us;1355us;1415us;1358us;1415us;1359us;1415us;1361us;1415us;1364us;1415us;1366us;1415us;1368us;1415us;1370us;1415us;1372us;1415us;1373us;1415us;1374us;1415us;1375us;1415us;1377us;1415us;1378us;1415us;1380us;1415us;1381us;1415us;1383us;1415us;1384us;1415us;1386us;1415us;1387us;1415us;1389us;1415us;1390us;1415us;1392us;1415us;1393us;1415us;1407us;1415us;1409us;1415us;1411us;1418us;1412us;1418us;1413us;1418us;1416us;1417us;1421us;1422us;1429us;1425us;1430us;1426us;1433us;1427us;1434us;1427us;1452us;1415us;1459us;1415us;1466us;1415us;1473us;1415us;1490us;1415us;1497us;1415us;1498us;1415us;1504us;1415us;1510us;1415us;1511us;1415us;1512us;1415us;1524us;1415us;1530us;1415us;1540us;1415us;1553us;1415us;1555us;1415us;1558us;1415us;1559us;1415us;1565us;1418us;1585us;1415us;1590us;1415us;1615us;1415us;1648us;1415us;1657us;1415us;1662us;1415us;1893us;1428us;2053us;1415us;2057us;1415us;3us;65535us;1403us;1404us;1440us;1441us;1443us;1444us;155us;65535us;6us;1462us;31us;1462us;117us;1462us;119us;1462us;242us;1462us;256us;1462us;279us;1462us;336us;1569us;340us;1569us;345us;1569us;427us;1462us;432us;1462us;474us;1462us;497us;1462us;531us;532us;701us;1462us;713us;1462us;774us;1462us;780us;1462us;832us;1462us;836us;1462us;846us;1462us;1047us;1462us;1053us;1462us;1069us;1462us;1071us;1462us;1074us;1462us;1077us;1462us;1096us;1462us;1101us;1462us;1107us;1462us;1110us;1462us;1113us;1462us;1119us;1462us;1123us;1462us;1127us;1462us;1133us;1462us;1135us;1462us;1140us;1462us;1142us;1462us;1144us;1462us;1146us;1462us;1148us;1462us;1150us;1462us;1154us;1462us;1164us;1462us;1171us;1462us;1177us;1462us;1179us;1462us;1184us;1462us;1188us;1462us;1191us;1462us;1195us;1462us;1198us;1462us;1201us;1462us;1203us;1462us;1206us;1462us;1208us;1462us;1257us;1462us;1259us;1462us;1263us;1462us;1265us;1462us;1267us;1462us;1269us;1462us;1271us;1462us;1273us;1462us;1275us;1462us;1277us;1462us;1279us;1462us;1281us;1462us;1283us;1462us;1285us;1462us;1287us;1462us;1289us;1462us;1291us;1462us;1293us;1462us;1295us;1462us;1297us;1462us;1299us;1462us;1301us;1462us;1303us;1462us;1304us;1462us;1305us;1462us;1306us;1462us;1309us;1462us;1319us;1462us;1348us;1462us;1349us;1462us;1353us;1462us;1355us;1462us;1358us;1462us;1359us;1462us;1361us;1462us;1364us;1462us;1366us;1462us;1368us;1462us;1370us;1462us;1372us;1462us;1373us;1462us;1374us;1462us;1375us;1462us;1377us;1462us;1378us;1462us;1380us;1462us;1381us;1462us;1383us;1462us;1384us;1462us;1386us;1462us;1387us;1462us;1389us;1462us;1390us;1462us;1392us;1462us;1393us;1462us;1399us;1401us;1400us;1402us;1407us;1462us;1409us;1462us;1411us;1462us;1412us;1462us;1413us;1462us;1416us;1462us;1421us;1462us;1429us;1462us;1430us;1462us;1433us;1462us;1434us;1462us;1452us;1462us;1459us;1462us;1466us;1462us;1473us;1462us;1490us;1462us;1497us;1462us;1498us;1462us;1504us;1462us;1510us;1462us;1511us;1462us;1512us;1462us;1524us;1462us;1530us;1462us;1540us;1462us;1553us;1462us;1555us;1462us;1558us;1462us;1559us;1462us;1565us;1462us;1580us;1569us;1585us;1462us;1590us;1462us;1615us;1462us;1648us;1462us;1657us;1462us;1662us;1462us;1893us;1462us;2053us;1462us;2057us;1462us;155us;65535us;6us;1489us;31us;1489us;117us;1489us;119us;1489us;242us;1489us;256us;1489us;279us;1489us;336us;1489us;340us;1489us;345us;1489us;427us;1489us;432us;1489us;474us;1489us;497us;1489us;531us;1489us;701us;1489us;713us;1489us;774us;1489us;780us;1489us;832us;1489us;836us;1489us;846us;1489us;1047us;1489us;1053us;1489us;1069us;1489us;1071us;1489us;1074us;1489us;1077us;1489us;1096us;1489us;1101us;1489us;1107us;1489us;1110us;1489us;1113us;1489us;1119us;1489us;1123us;1489us;1127us;1489us;1133us;1489us;1135us;1489us;1140us;1489us;1142us;1489us;1144us;1489us;1146us;1489us;1148us;1489us;1150us;1489us;1154us;1489us;1164us;1489us;1171us;1489us;1177us;1489us;1179us;1489us;1184us;1489us;1188us;1489us;1191us;1489us;1195us;1489us;1198us;1489us;1201us;1489us;1203us;1489us;1206us;1489us;1208us;1489us;1257us;1489us;1259us;1489us;1263us;1489us;1265us;1489us;1267us;1489us;1269us;1489us;1271us;1489us;1273us;1489us;1275us;1489us;1277us;1489us;1279us;1489us;1281us;1489us;1283us;1489us;1285us;1489us;1287us;1489us;1289us;1489us;1291us;1489us;1293us;1489us;1295us;1489us;1297us;1489us;1299us;1489us;1301us;1489us;1303us;1489us;1304us;1489us;1305us;1489us;1306us;1489us;1309us;1489us;1319us;1489us;1348us;1489us;1349us;1489us;1353us;1489us;1355us;1489us;1358us;1489us;1359us;1489us;1361us;1489us;1364us;1489us;1366us;1489us;1368us;1489us;1370us;1489us;1372us;1489us;1373us;1489us;1374us;1489us;1375us;1489us;1377us;1489us;1378us;1489us;1380us;1489us;1381us;1489us;1383us;1489us;1384us;1489us;1386us;1489us;1387us;1489us;1389us;1489us;1390us;1489us;1392us;1489us;1393us;1489us;1399us;1489us;1400us;1489us;1407us;1489us;1409us;1489us;1411us;1489us;1412us;1489us;1413us;1489us;1416us;1489us;1421us;1489us;1429us;1489us;1430us;1489us;1433us;1489us;1434us;1489us;1452us;1489us;1459us;1489us;1466us;1489us;1473us;1489us;1490us;1489us;1497us;1489us;1498us;1489us;1504us;1489us;1510us;1489us;1511us;1489us;1512us;1489us;1524us;1489us;1530us;1489us;1540us;1489us;1553us;1489us;1555us;1489us;1558us;1489us;1559us;1489us;1565us;1489us;1580us;1489us;1585us;1489us;1590us;1489us;1615us;1489us;1648us;1489us;1657us;1489us;1662us;1489us;1893us;1489us;2053us;1489us;2057us;1489us;210us;65535us;6us;1487us;31us;1487us;117us;1487us;119us;1487us;242us;1487us;256us;1487us;279us;1487us;336us;1487us;340us;1487us;345us;1487us;424us;966us;427us;1487us;429us;966us;432us;1487us;471us;966us;474us;1487us;497us;1487us;531us;1487us;701us;1487us;713us;1487us;774us;1487us;780us;1487us;829us;966us;832us;1487us;836us;1487us;846us;1487us;892us;966us;911us;966us;914us;966us;915us;966us;920us;966us;921us;966us;924us;966us;926us;966us;927us;966us;936us;966us;940us;966us;941us;966us;943us;966us;945us;966us;948us;966us;950us;966us;956us;966us;960us;966us;962us;966us;964us;966us;972us;966us;975us;966us;986us;966us;994us;966us;1015us;966us;1018us;966us;1024us;966us;1025us;966us;1028us;966us;1029us;966us;1032us;966us;1034us;966us;1035us;966us;1041us;966us;1045us;966us;1047us;1487us;1053us;1487us;1069us;1487us;1071us;1487us;1074us;1487us;1077us;1487us;1095us;966us;1096us;1487us;1100us;966us;1101us;1487us;1107us;1487us;1110us;1487us;1113us;1487us;1119us;1487us;1123us;1487us;1127us;1487us;1133us;1487us;1135us;1487us;1140us;1487us;1142us;1487us;1144us;1487us;1146us;1487us;1148us;1487us;1150us;1487us;1152us;966us;1154us;1487us;1164us;1487us;1171us;1487us;1177us;1487us;1179us;1487us;1183us;966us;1184us;1487us;1188us;1487us;1190us;966us;1191us;1487us;1195us;1487us;1198us;1487us;1201us;1487us;1203us;1487us;1206us;1487us;1208us;1487us;1257us;1487us;1259us;1487us;1263us;1487us;1265us;1487us;1267us;1487us;1269us;1487us;1271us;1487us;1273us;1487us;1275us;1487us;1277us;1487us;1279us;1487us;1281us;1487us;1283us;1487us;1285us;1487us;1287us;1487us;1289us;1487us;1291us;1487us;1293us;1487us;1295us;1487us;1297us;1487us;1299us;1487us;1301us;1487us;1303us;1487us;1304us;1487us;1305us;1487us;1306us;1487us;1309us;1487us;1319us;1487us;1322us;966us;1324us;966us;1330us;966us;1332us;966us;1339us;966us;1341us;966us;1343us;966us;1348us;1487us;1349us;1487us;1353us;1487us;1355us;1487us;1358us;1487us;1359us;1487us;1361us;1487us;1364us;1487us;1366us;1487us;1368us;1487us;1370us;1487us;1372us;1487us;1373us;1487us;1374us;1487us;1375us;1487us;1377us;1487us;1378us;1487us;1380us;1487us;1381us;1487us;1383us;1487us;1384us;1487us;1386us;1487us;1387us;1487us;1389us;1487us;1390us;1487us;1392us;1487us;1393us;1487us;1399us;1487us;1400us;1487us;1407us;1487us;1409us;1487us;1411us;1487us;1412us;1487us;1413us;1487us;1416us;1487us;1421us;1487us;1429us;1487us;1430us;1487us;1433us;1487us;1434us;1487us;1452us;1487us;1459us;1487us;1466us;1487us;1473us;1487us;1490us;1487us;1497us;1487us;1498us;1487us;1504us;1487us;1510us;1487us;1511us;1487us;1512us;1487us;1524us;1487us;1530us;1487us;1540us;1487us;1553us;1487us;1555us;1487us;1558us;1487us;1559us;1487us;1565us;1487us;1580us;1487us;1585us;1487us;1590us;1487us;1615us;1487us;1648us;1487us;1655us;966us;1657us;1487us;1660us;966us;1662us;1487us;1672us;966us;1674us;966us;1893us;1487us;2053us;1487us;2057us;1487us;155us;65535us;6us;1488us;31us;1488us;117us;1488us;119us;1488us;242us;1488us;256us;1488us;279us;1488us;336us;1488us;340us;1488us;345us;1488us;427us;1488us;432us;1488us;474us;1488us;497us;1488us;531us;1488us;701us;1488us;713us;1488us;774us;1488us;780us;1488us;832us;1488us;836us;1488us;846us;1488us;1047us;1488us;1053us;1488us;1069us;1488us;1071us;1488us;1074us;1488us;1077us;1488us;1096us;1488us;1101us;1488us;1107us;1488us;1110us;1488us;1113us;1488us;1119us;1488us;1123us;1488us;1127us;1488us;1133us;1488us;1135us;1488us;1140us;1488us;1142us;1488us;1144us;1488us;1146us;1488us;1148us;1488us;1150us;1488us;1154us;1488us;1164us;1488us;1171us;1488us;1177us;1488us;1179us;1488us;1184us;1488us;1188us;1488us;1191us;1488us;1195us;1488us;1198us;1488us;1201us;1488us;1203us;1488us;1206us;1488us;1208us;1488us;1257us;1488us;1259us;1488us;1263us;1488us;1265us;1488us;1267us;1488us;1269us;1488us;1271us;1488us;1273us;1488us;1275us;1488us;1277us;1488us;1279us;1488us;1281us;1488us;1283us;1488us;1285us;1488us;1287us;1488us;1289us;1488us;1291us;1488us;1293us;1488us;1295us;1488us;1297us;1488us;1299us;1488us;1301us;1488us;1303us;1488us;1304us;1488us;1305us;1488us;1306us;1488us;1309us;1488us;1319us;1488us;1348us;1488us;1349us;1488us;1353us;1488us;1355us;1488us;1358us;1488us;1359us;1488us;1361us;1488us;1364us;1488us;1366us;1488us;1368us;1488us;1370us;1488us;1372us;1488us;1373us;1488us;1374us;1488us;1375us;1488us;1377us;1488us;1378us;1488us;1380us;1488us;1381us;1488us;1383us;1488us;1384us;1488us;1386us;1488us;1387us;1488us;1389us;1488us;1390us;1488us;1392us;1488us;1393us;1488us;1399us;1488us;1400us;1488us;1407us;1488us;1409us;1488us;1411us;1488us;1412us;1488us;1413us;1488us;1416us;1488us;1421us;1488us;1429us;1488us;1430us;1488us;1433us;1488us;1434us;1488us;1452us;1488us;1459us;1488us;1466us;1488us;1473us;1488us;1490us;1488us;1497us;1488us;1498us;1488us;1504us;1488us;1510us;1488us;1511us;1488us;1512us;1488us;1524us;1488us;1530us;1488us;1540us;1488us;1553us;1488us;1555us;1488us;1558us;1488us;1559us;1488us;1565us;1488us;1580us;1488us;1585us;1488us;1590us;1488us;1615us;1488us;1648us;1488us;1657us;1488us;1662us;1488us;1893us;1488us;2053us;1488us;2057us;1488us;155us;65535us;6us;1480us;31us;1480us;117us;1480us;119us;1480us;242us;1480us;256us;1480us;279us;1480us;336us;1480us;340us;1480us;345us;1480us;427us;1480us;432us;1480us;474us;1480us;497us;1480us;531us;1480us;701us;1480us;713us;1480us;774us;1480us;780us;1480us;832us;1480us;836us;1480us;846us;1480us;1047us;1480us;1053us;1480us;1069us;1480us;1071us;1480us;1074us;1480us;1077us;1480us;1096us;1480us;1101us;1480us;1107us;1480us;1110us;1480us;1113us;1480us;1119us;1480us;1123us;1480us;1127us;1480us;1133us;1480us;1135us;1480us;1140us;1480us;1142us;1480us;1144us;1480us;1146us;1480us;1148us;1480us;1150us;1480us;1154us;1480us;1164us;1480us;1171us;1480us;1177us;1480us;1179us;1480us;1184us;1480us;1188us;1480us;1191us;1480us;1195us;1480us;1198us;1480us;1201us;1480us;1203us;1480us;1206us;1480us;1208us;1480us;1257us;1480us;1259us;1480us;1263us;1480us;1265us;1480us;1267us;1480us;1269us;1480us;1271us;1480us;1273us;1480us;1275us;1480us;1277us;1480us;1279us;1480us;1281us;1480us;1283us;1480us;1285us;1480us;1287us;1480us;1289us;1480us;1291us;1480us;1293us;1480us;1295us;1480us;1297us;1480us;1299us;1480us;1301us;1480us;1303us;1480us;1304us;1480us;1305us;1480us;1306us;1480us;1309us;1480us;1319us;1480us;1348us;1480us;1349us;1480us;1353us;1480us;1355us;1480us;1358us;1480us;1359us;1480us;1361us;1480us;1364us;1480us;1366us;1480us;1368us;1480us;1370us;1480us;1372us;1480us;1373us;1480us;1374us;1480us;1375us;1480us;1377us;1480us;1378us;1480us;1380us;1480us;1381us;1480us;1383us;1480us;1384us;1480us;1386us;1480us;1387us;1480us;1389us;1480us;1390us;1480us;1392us;1480us;1393us;1480us;1399us;1480us;1400us;1480us;1407us;1480us;1409us;1480us;1411us;1480us;1412us;1480us;1413us;1480us;1416us;1480us;1421us;1480us;1429us;1480us;1430us;1480us;1433us;1480us;1434us;1480us;1452us;1480us;1459us;1480us;1466us;1480us;1473us;1480us;1490us;1480us;1497us;1480us;1498us;1480us;1504us;1480us;1510us;1480us;1511us;1480us;1512us;1480us;1524us;1480us;1530us;1480us;1540us;1480us;1553us;1480us;1555us;1480us;1558us;1480us;1559us;1480us;1565us;1480us;1580us;1480us;1585us;1480us;1590us;1480us;1615us;1480us;1648us;1480us;1657us;1480us;1662us;1480us;1893us;1480us;2053us;1480us;2057us;1480us;3us;65535us;1510us;1514us;1511us;1514us;1512us;1514us;3us;65535us;1510us;1526us;1511us;1526us;1512us;1526us;1us;65535us;1511us;1536us;155us;65535us;6us;1481us;31us;1481us;117us;1481us;119us;1481us;242us;1481us;256us;1481us;279us;1481us;336us;1481us;340us;1481us;345us;1481us;427us;1481us;432us;1481us;474us;1481us;497us;1481us;531us;1481us;701us;1481us;713us;1481us;774us;1481us;780us;1481us;832us;1481us;836us;1481us;846us;1481us;1047us;1481us;1053us;1481us;1069us;1481us;1071us;1481us;1074us;1481us;1077us;1481us;1096us;1481us;1101us;1481us;1107us;1481us;1110us;1481us;1113us;1481us;1119us;1481us;1123us;1481us;1127us;1481us;1133us;1481us;1135us;1481us;1140us;1481us;1142us;1481us;1144us;1481us;1146us;1481us;1148us;1481us;1150us;1481us;1154us;1481us;1164us;1481us;1171us;1481us;1177us;1481us;1179us;1481us;1184us;1481us;1188us;1481us;1191us;1481us;1195us;1481us;1198us;1481us;1201us;1481us;1203us;1481us;1206us;1481us;1208us;1481us;1257us;1481us;1259us;1481us;1263us;1481us;1265us;1481us;1267us;1481us;1269us;1481us;1271us;1481us;1273us;1481us;1275us;1481us;1277us;1481us;1279us;1481us;1281us;1481us;1283us;1481us;1285us;1481us;1287us;1481us;1289us;1481us;1291us;1481us;1293us;1481us;1295us;1481us;1297us;1481us;1299us;1481us;1301us;1481us;1303us;1481us;1304us;1481us;1305us;1481us;1306us;1481us;1309us;1481us;1319us;1481us;1348us;1481us;1349us;1481us;1353us;1481us;1355us;1481us;1358us;1481us;1359us;1481us;1361us;1481us;1364us;1481us;1366us;1481us;1368us;1481us;1370us;1481us;1372us;1481us;1373us;1481us;1374us;1481us;1375us;1481us;1377us;1481us;1378us;1481us;1380us;1481us;1381us;1481us;1383us;1481us;1384us;1481us;1386us;1481us;1387us;1481us;1389us;1481us;1390us;1481us;1392us;1481us;1393us;1481us;1399us;1481us;1400us;1481us;1407us;1481us;1409us;1481us;1411us;1481us;1412us;1481us;1413us;1481us;1416us;1481us;1421us;1481us;1429us;1481us;1430us;1481us;1433us;1481us;1434us;1481us;1452us;1481us;1459us;1481us;1466us;1481us;1473us;1481us;1490us;1481us;1497us;1481us;1498us;1481us;1504us;1481us;1510us;1481us;1511us;1481us;1512us;1481us;1524us;1481us;1530us;1481us;1540us;1481us;1553us;1481us;1555us;1481us;1558us;1481us;1559us;1481us;1565us;1481us;1580us;1481us;1585us;1481us;1590us;1481us;1615us;1481us;1648us;1481us;1657us;1481us;1662us;1481us;1893us;1481us;2053us;1481us;2057us;1481us;1us;65535us;1540us;1541us;1us;65535us;1452us;1453us;1us;65535us;1504us;1505us;1us;65535us;1540us;1549us;1us;65535us;1161us;1162us;1us;65535us;1152us;1153us;1us;65535us;1152us;1163us;1us;65535us;1245us;1559us;3us;65535us;1510us;1533us;1511us;1533us;1512us;1533us;1us;65535us;1564us;1565us;4us;65535us;336us;337us;340us;341us;345us;346us;1580us;1581us;1us;65535us;1563us;1564us;1us;65535us;1565us;1566us;1us;65535us;1540us;1547us;2us;65535us;1540us;1584us;1648us;1649us;6us;65535us;1582us;1583us;1587us;1588us;1592us;1593us;1596us;1597us;1598us;1599us;1602us;1603us;6us;65535us;1582us;1606us;1587us;1606us;1592us;1606us;1596us;1606us;1598us;1605us;1602us;1606us;3us;65535us;1594us;1614us;1598us;1614us;1606us;1614us;5us;65535us;1581us;1582us;1586us;1587us;1591us;1592us;1595us;1596us;1601us;1602us;3us;65535us;1594us;1595us;1598us;1601us;1606us;1613us;1us;65535us;1540us;1548us;1us;65535us;1540us;1619us;1us;65535us;1641us;1642us;2us;65535us;1619us;1620us;1641us;1626us;1us;65535us;1623us;1624us;4us;65535us;1621us;1622us;1634us;1635us;1636us;1637us;1638us;1639us;5us;65535us;1621us;1636us;1623us;1634us;1634us;1636us;1636us;1636us;1638us;1636us;155us;65535us;6us;1482us;31us;1482us;117us;1482us;119us;1482us;242us;1482us;256us;1482us;279us;1482us;336us;1482us;340us;1482us;345us;1482us;427us;1482us;432us;1482us;474us;1482us;497us;1482us;531us;1482us;701us;1482us;713us;1482us;774us;1482us;780us;1482us;832us;1482us;836us;1482us;846us;1482us;1047us;1482us;1053us;1482us;1069us;1482us;1071us;1482us;1074us;1482us;1077us;1482us;1096us;1482us;1101us;1482us;1107us;1482us;1110us;1482us;1113us;1482us;1119us;1482us;1123us;1482us;1127us;1482us;1133us;1482us;1135us;1482us;1140us;1482us;1142us;1482us;1144us;1482us;1146us;1482us;1148us;1482us;1150us;1482us;1154us;1482us;1164us;1482us;1171us;1482us;1177us;1482us;1179us;1482us;1184us;1482us;1188us;1482us;1191us;1482us;1195us;1482us;1198us;1482us;1201us;1482us;1203us;1482us;1206us;1482us;1208us;1482us;1257us;1482us;1259us;1482us;1263us;1482us;1265us;1482us;1267us;1482us;1269us;1482us;1271us;1482us;1273us;1482us;1275us;1482us;1277us;1482us;1279us;1482us;1281us;1482us;1283us;1482us;1285us;1482us;1287us;1482us;1289us;1482us;1291us;1482us;1293us;1482us;1295us;1482us;1297us;1482us;1299us;1482us;1301us;1482us;1303us;1482us;1304us;1482us;1305us;1482us;1306us;1482us;1309us;1482us;1319us;1482us;1348us;1482us;1349us;1482us;1353us;1482us;1355us;1482us;1358us;1482us;1359us;1482us;1361us;1482us;1364us;1482us;1366us;1482us;1368us;1482us;1370us;1482us;1372us;1482us;1373us;1482us;1374us;1482us;1375us;1482us;1377us;1482us;1378us;1482us;1380us;1482us;1381us;1482us;1383us;1482us;1384us;1482us;1386us;1482us;1387us;1482us;1389us;1482us;1390us;1482us;1392us;1482us;1393us;1482us;1399us;1482us;1400us;1482us;1407us;1482us;1409us;1482us;1411us;1482us;1412us;1482us;1413us;1482us;1416us;1482us;1421us;1482us;1429us;1482us;1430us;1482us;1433us;1482us;1434us;1482us;1452us;1482us;1459us;1482us;1466us;1482us;1473us;1482us;1490us;1482us;1497us;1482us;1498us;1482us;1504us;1482us;1510us;1482us;1511us;1482us;1512us;1482us;1524us;1482us;1530us;1482us;1540us;1482us;1553us;1482us;1555us;1482us;1558us;1482us;1559us;1482us;1565us;1482us;1580us;1482us;1585us;1482us;1590us;1482us;1615us;1482us;1648us;1482us;1657us;1482us;1662us;1482us;1893us;1482us;2053us;1482us;2057us;1482us;157us;65535us;6us;1647us;31us;1647us;117us;1647us;119us;1647us;242us;1647us;256us;1647us;279us;1647us;336us;1647us;340us;1647us;345us;1647us;427us;1647us;432us;1647us;474us;1647us;497us;1647us;531us;1647us;701us;1647us;713us;1647us;774us;1647us;780us;1647us;832us;1647us;836us;1647us;846us;1647us;1047us;1647us;1053us;1647us;1069us;1647us;1071us;1647us;1074us;1647us;1077us;1647us;1096us;1647us;1101us;1647us;1107us;1647us;1110us;1647us;1113us;1647us;1119us;1647us;1123us;1647us;1127us;1647us;1133us;1647us;1135us;1647us;1140us;1647us;1142us;1647us;1144us;1647us;1146us;1647us;1148us;1647us;1150us;1647us;1154us;1647us;1164us;1647us;1171us;1647us;1177us;1647us;1179us;1647us;1184us;1647us;1188us;1647us;1191us;1647us;1195us;1647us;1198us;1647us;1201us;1647us;1203us;1647us;1206us;1647us;1208us;1647us;1257us;1647us;1259us;1647us;1263us;1647us;1265us;1647us;1267us;1647us;1269us;1647us;1271us;1647us;1273us;1647us;1275us;1647us;1277us;1647us;1279us;1647us;1281us;1647us;1283us;1647us;1285us;1647us;1287us;1647us;1289us;1647us;1291us;1647us;1293us;1647us;1295us;1647us;1297us;1647us;1299us;1647us;1301us;1647us;1303us;1647us;1304us;1647us;1305us;1647us;1306us;1647us;1309us;1647us;1319us;1647us;1348us;1647us;1349us;1647us;1353us;1647us;1355us;1647us;1358us;1647us;1359us;1647us;1361us;1647us;1364us;1647us;1366us;1647us;1368us;1647us;1370us;1647us;1372us;1647us;1373us;1647us;1374us;1647us;1375us;1647us;1377us;1647us;1378us;1647us;1380us;1647us;1381us;1647us;1383us;1647us;1384us;1647us;1386us;1647us;1387us;1647us;1389us;1647us;1390us;1647us;1392us;1647us;1393us;1647us;1399us;1647us;1400us;1647us;1407us;1647us;1409us;1647us;1411us;1647us;1412us;1647us;1413us;1647us;1416us;1647us;1421us;1647us;1429us;1647us;1430us;1647us;1433us;1647us;1434us;1647us;1452us;1647us;1458us;1646us;1459us;1647us;1466us;1647us;1473us;1647us;1490us;1647us;1497us;1647us;1498us;1647us;1504us;1647us;1510us;1647us;1511us;1647us;1512us;1647us;1524us;1647us;1530us;1647us;1540us;1647us;1553us;1647us;1555us;1647us;1558us;1647us;1559us;1647us;1565us;1647us;1580us;1647us;1585us;1647us;1590us;1647us;1615us;1647us;1645us;1646us;1648us;1647us;1657us;1647us;1662us;1647us;1893us;1647us;2053us;1647us;2057us;1647us;116us;65535us;6us;1118us;31us;1118us;117us;1118us;119us;1118us;242us;1118us;256us;1118us;279us;1118us;427us;1118us;432us;1118us;474us;1118us;497us;1118us;774us;1118us;780us;1118us;832us;1118us;836us;1118us;846us;1118us;1047us;1118us;1053us;1118us;1069us;1118us;1071us;1118us;1074us;1118us;1077us;1118us;1096us;1118us;1101us;1118us;1107us;1118us;1110us;1118us;1113us;1118us;1119us;1118us;1123us;1118us;1127us;1118us;1133us;1118us;1135us;1118us;1140us;1118us;1142us;1118us;1144us;1118us;1146us;1118us;1148us;1118us;1150us;1118us;1154us;1118us;1164us;1118us;1171us;1118us;1177us;1118us;1179us;1118us;1184us;1118us;1188us;1118us;1191us;1118us;1195us;1118us;1198us;1118us;1201us;1118us;1203us;1118us;1206us;1118us;1208us;1118us;1257us;1118us;1259us;1118us;1263us;1118us;1265us;1118us;1267us;1118us;1269us;1118us;1271us;1118us;1273us;1118us;1275us;1118us;1277us;1118us;1279us;1118us;1281us;1118us;1283us;1118us;1285us;1118us;1287us;1118us;1289us;1118us;1291us;1118us;1293us;1118us;1295us;1118us;1297us;1118us;1299us;1118us;1301us;1118us;1303us;1118us;1304us;1118us;1305us;1118us;1306us;1118us;1309us;1118us;1319us;1118us;1348us;1118us;1349us;1118us;1353us;1118us;1355us;1118us;1358us;1118us;1359us;1118us;1361us;1118us;1364us;1118us;1366us;1118us;1368us;1118us;1370us;1118us;1452us;1118us;1459us;1118us;1466us;1118us;1473us;1118us;1490us;1118us;1497us;1118us;1498us;1118us;1504us;1118us;1510us;1118us;1511us;1118us;1512us;1118us;1524us;1118us;1530us;1118us;1540us;1118us;1553us;1118us;1555us;1118us;1558us;1118us;1559us;1118us;1585us;1118us;1590us;1118us;1615us;1118us;1657us;1118us;1662us;1118us;2053us;1118us;2057us;1118us;116us;65535us;6us;1117us;31us;1117us;117us;1117us;119us;1117us;242us;1117us;256us;1117us;279us;1117us;427us;1117us;432us;1117us;474us;1117us;497us;1117us;774us;1117us;780us;1117us;832us;1117us;836us;1117us;846us;1117us;1047us;1117us;1053us;1117us;1069us;1117us;1071us;1117us;1074us;1117us;1077us;1117us;1096us;1117us;1101us;1117us;1107us;1117us;1110us;1117us;1113us;1117us;1119us;1117us;1123us;1117us;1127us;1117us;1133us;1117us;1135us;1117us;1140us;1117us;1142us;1117us;1144us;1117us;1146us;1117us;1148us;1117us;1150us;1117us;1154us;1117us;1164us;1117us;1171us;1117us;1177us;1117us;1179us;1117us;1184us;1117us;1188us;1117us;1191us;1117us;1195us;1117us;1198us;1117us;1201us;1117us;1203us;1117us;1206us;1117us;1208us;1117us;1257us;1117us;1259us;1117us;1263us;1117us;1265us;1117us;1267us;1117us;1269us;1117us;1271us;1117us;1273us;1117us;1275us;1117us;1277us;1117us;1279us;1117us;1281us;1117us;1283us;1117us;1285us;1117us;1287us;1117us;1289us;1117us;1291us;1117us;1293us;1117us;1295us;1117us;1297us;1117us;1299us;1117us;1301us;1117us;1303us;1117us;1304us;1117us;1305us;1117us;1306us;1117us;1309us;1117us;1319us;1117us;1348us;1117us;1349us;1117us;1353us;1117us;1355us;1117us;1358us;1117us;1359us;1117us;1361us;1117us;1364us;1117us;1366us;1117us;1368us;1117us;1370us;1117us;1452us;1117us;1459us;1117us;1466us;1117us;1473us;1117us;1490us;1117us;1497us;1117us;1498us;1117us;1504us;1117us;1510us;1117us;1511us;1117us;1512us;1117us;1524us;1117us;1530us;1117us;1540us;1117us;1553us;1117us;1555us;1117us;1558us;1117us;1559us;1117us;1585us;1117us;1590us;1117us;1615us;1117us;1657us;1117us;1662us;1117us;2053us;1117us;2057us;1117us;2us;65535us;1021us;1022us;1063us;1064us;5us;65535us;114us;115us;187us;188us;204us;205us;460us;461us;1681us;1682us;3us;65535us;425us;426us;430us;431us;830us;831us;10us;65535us;114us;1679us;152us;153us;187us;1679us;204us;1679us;390us;391us;460us;1679us;699us;700us;722us;723us;1681us;1679us;1685us;1686us;10us;65535us;114us;1684us;152us;1684us;187us;1684us;204us;1684us;390us;1684us;460us;1684us;699us;1684us;722us;1684us;1681us;1684us;1685us;1684us;4us;65535us;1689us;1690us;1692us;1693us;1695us;1696us;1698us;1699us;14us;65535us;114us;1688us;152us;1688us;187us;1688us;204us;1688us;390us;1688us;460us;1688us;699us;1688us;722us;1688us;1681us;1688us;1685us;1688us;1689us;1694us;1692us;1694us;1695us;1694us;1698us;1694us;11us;65535us;690us;739us;692us;739us;695us;739us;719us;739us;725us;739us;728us;739us;731us;739us;734us;738us;765us;739us;1722us;1723us;1725us;1726us;33us;65535us;8us;1733us;181us;572us;444us;572us;487us;488us;503us;504us;567us;572us;575us;1878us;650us;651us;653us;654us;664us;1878us;751us;752us;852us;853us;1021us;1677us;1063us;1677us;1248us;1249us;1251us;1252us;1254us;1255us;1571us;1572us;1574us;1575us;1576us;1878us;1728us;1729us;1731us;1732us;1774us;1878us;1780us;1878us;1786us;1787us;1789us;1790us;1856us;1921us;1860us;1921us;1866us;1878us;1876us;1877us;1909us;1921us;1911us;1921us;1922us;1923us;1us;65535us;8us;9us;33us;65535us;8us;1727us;181us;1727us;444us;1727us;487us;1727us;503us;1727us;567us;1727us;575us;1727us;650us;1727us;653us;1727us;664us;1727us;751us;1727us;852us;1727us;1021us;1727us;1063us;1727us;1248us;1727us;1251us;1727us;1254us;1727us;1571us;1727us;1574us;1727us;1576us;1727us;1728us;1727us;1731us;1727us;1774us;1727us;1780us;1727us;1786us;1727us;1789us;1727us;1856us;1727us;1860us;1727us;1866us;1727us;1876us;1727us;1909us;1727us;1911us;1727us;1922us;1727us;11us;65535us;1737us;1738us;1740us;1742us;1741us;1742us;1743us;1745us;1744us;1745us;1747us;1748us;1751us;1752us;1754us;1755us;1756us;1757us;1759us;1760us;1884us;1885us;86us;65535us;8us;1785us;114us;1785us;152us;1785us;181us;1785us;187us;1785us;191us;1785us;193us;1785us;204us;1785us;295us;1785us;390us;1785us;444us;1785us;451us;1785us;460us;1785us;487us;1785us;503us;1785us;567us;1785us;575us;1785us;634us;1785us;638us;1785us;650us;1785us;653us;1785us;664us;1785us;675us;1785us;690us;1785us;692us;1785us;695us;1785us;699us;1785us;719us;1785us;722us;1785us;725us;1785us;728us;1785us;731us;1785us;734us;1785us;751us;1785us;765us;1785us;852us;1785us;1021us;1785us;1063us;1785us;1248us;1785us;1251us;1785us;1254us;1785us;1538us;1785us;1571us;1785us;1574us;1785us;1576us;1785us;1640us;1785us;1678us;1785us;1680us;1785us;1681us;1785us;1685us;1785us;1689us;1785us;1692us;1785us;1695us;1785us;1698us;1785us;1700us;1785us;1702us;1785us;1707us;1785us;1711us;1785us;1716us;1785us;1722us;1785us;1725us;1785us;1728us;1785us;1731us;1785us;1737us;1785us;1740us;1785us;1741us;1785us;1743us;1785us;1744us;1785us;1747us;1785us;1751us;1785us;1754us;1785us;1756us;1785us;1759us;1785us;1774us;1785us;1780us;1785us;1786us;1785us;1789us;1785us;1856us;1785us;1860us;1785us;1866us;1785us;1876us;1785us;1882us;1785us;1884us;1785us;1909us;1785us;1911us;1785us;1922us;1785us;111us;65535us;8us;1768us;114us;1768us;152us;1768us;181us;1768us;187us;1768us;191us;1768us;192us;1767us;193us;1768us;194us;1767us;204us;1768us;295us;1768us;296us;1767us;390us;1768us;444us;1768us;451us;1768us;452us;1767us;460us;1768us;487us;1768us;503us;1768us;528us;1768us;567us;1768us;575us;1768us;576us;1768us;619us;1768us;632us;1768us;634us;1768us;638us;1768us;643us;1768us;650us;1768us;653us;1768us;664us;1768us;674us;1767us;675us;1768us;676us;1767us;677us;1767us;690us;1768us;692us;1768us;695us;1768us;699us;1768us;719us;1768us;722us;1768us;725us;1768us;728us;1768us;731us;1768us;734us;1768us;751us;1768us;765us;1768us;852us;1768us;952us;1768us;1021us;1768us;1063us;1768us;1248us;1768us;1251us;1768us;1254us;1768us;1395us;1768us;1396us;1768us;1538us;1768us;1571us;1768us;1574us;1768us;1576us;1768us;1578us;1768us;1640us;1768us;1641us;1767us;1678us;1768us;1680us;1768us;1681us;1768us;1685us;1768us;1689us;1768us;1692us;1768us;1695us;1768us;1698us;1768us;1700us;1768us;1702us;1768us;1707us;1768us;1711us;1768us;1716us;1768us;1719us;1767us;1720us;1767us;1721us;1767us;1722us;1768us;1725us;1768us;1728us;1768us;1731us;1768us;1737us;1768us;1740us;1768us;1741us;1768us;1743us;1768us;1744us;1768us;1747us;1768us;1751us;1768us;1754us;1768us;1756us;1768us;1759us;1768us;1762us;1768us;1764us;1768us;1771us;1767us;1774us;1768us;1780us;1768us;1782us;1767us;1786us;1768us;1789us;1768us;1856us;1768us;1860us;1768us;1866us;1768us;1868us;1767us;1876us;1768us;1882us;1768us;1884us;1768us;1909us;1768us;1911us;1768us;1922us;1768us;111us;65535us;8us;1874us;114us;1874us;152us;1874us;181us;1874us;187us;1874us;191us;1874us;192us;1779us;193us;1874us;194us;1779us;204us;1874us;295us;1874us;296us;1779us;390us;1874us;444us;1874us;451us;1874us;452us;1779us;460us;1874us;487us;1874us;503us;1874us;528us;1874us;567us;1874us;575us;1874us;576us;1874us;619us;1874us;632us;1874us;634us;1874us;638us;1874us;643us;1874us;650us;1874us;653us;1874us;664us;1874us;674us;1779us;675us;1874us;676us;1779us;677us;1779us;690us;1874us;692us;1874us;695us;1874us;699us;1874us;719us;1874us;722us;1874us;725us;1874us;728us;1874us;731us;1874us;734us;1874us;751us;1874us;765us;1874us;852us;1874us;952us;1874us;1021us;1874us;1063us;1874us;1248us;1874us;1251us;1874us;1254us;1874us;1395us;1874us;1396us;1874us;1538us;1874us;1571us;1874us;1574us;1874us;1576us;1874us;1578us;1874us;1640us;1874us;1641us;1779us;1678us;1874us;1680us;1874us;1681us;1874us;1685us;1874us;1689us;1874us;1692us;1874us;1695us;1874us;1698us;1874us;1700us;1874us;1702us;1874us;1707us;1874us;1711us;1874us;1716us;1874us;1719us;1779us;1720us;1779us;1721us;1779us;1722us;1874us;1725us;1874us;1728us;1874us;1731us;1874us;1737us;1874us;1740us;1874us;1741us;1874us;1743us;1874us;1744us;1874us;1747us;1874us;1751us;1874us;1754us;1874us;1756us;1874us;1759us;1874us;1762us;1874us;1764us;1874us;1771us;1779us;1774us;1874us;1780us;1874us;1782us;1783us;1786us;1874us;1789us;1874us;1856us;1874us;1860us;1874us;1866us;1874us;1868us;1869us;1876us;1874us;1882us;1874us;1884us;1874us;1909us;1874us;1911us;1874us;1922us;1874us;65us;65535us;8us;1735us;114us;1710us;152us;1710us;181us;1735us;187us;1710us;204us;1710us;390us;1710us;444us;1735us;460us;1710us;487us;1735us;503us;1735us;567us;1735us;575us;1735us;650us;1735us;653us;1735us;664us;1735us;699us;1710us;722us;1710us;751us;1735us;852us;1735us;1021us;1735us;1063us;1735us;1248us;1735us;1251us;1735us;1254us;1735us;1538us;1539us;1571us;1735us;1574us;1735us;1576us;1735us;1681us;1710us;1685us;1710us;1689us;1710us;1692us;1710us;1695us;1710us;1698us;1710us;1700us;1701us;1702us;1703us;1707us;1708us;1711us;1712us;1716us;1717us;1728us;1735us;1731us;1735us;1737us;1750us;1740us;1750us;1741us;1750us;1743us;1750us;1744us;1750us;1747us;1750us;1751us;1750us;1754us;1750us;1756us;1750us;1759us;1750us;1774us;1736us;1780us;1735us;1786us;1735us;1789us;1735us;1856us;1735us;1860us;1735us;1866us;1735us;1876us;1735us;1882us;1883us;1884us;1750us;1909us;1735us;1911us;1735us;1922us;1735us;9us;65535us;690us;737us;692us;737us;695us;737us;719us;737us;725us;737us;728us;737us;731us;737us;734us;735us;765us;737us;86us;65535us;8us;1771us;114us;1771us;152us;1771us;181us;1771us;187us;1771us;191us;192us;193us;194us;204us;1771us;295us;296us;390us;1771us;444us;1771us;451us;452us;460us;1771us;487us;1771us;503us;1771us;567us;1771us;575us;1771us;634us;674us;638us;674us;650us;1771us;653us;1771us;664us;677us;675us;676us;690us;1720us;692us;1720us;695us;1720us;699us;1771us;719us;1720us;722us;1771us;725us;1720us;728us;1720us;731us;1720us;734us;1720us;751us;1771us;765us;1720us;852us;1771us;1021us;1771us;1063us;1771us;1248us;1771us;1251us;1771us;1254us;1771us;1538us;1771us;1571us;1771us;1574us;1771us;1576us;1771us;1640us;1641us;1678us;674us;1680us;674us;1681us;1771us;1685us;1771us;1689us;1771us;1692us;1771us;1695us;1771us;1698us;1771us;1700us;1771us;1702us;1771us;1707us;1771us;1711us;1771us;1716us;1771us;1722us;1719us;1725us;1721us;1728us;1771us;1731us;1771us;1737us;1771us;1740us;1771us;1741us;1771us;1743us;1771us;1744us;1771us;1747us;1771us;1751us;1771us;1754us;1771us;1756us;1771us;1759us;1771us;1774us;1771us;1780us;1771us;1786us;1771us;1789us;1771us;1856us;1771us;1860us;1771us;1866us;1771us;1876us;1771us;1882us;1771us;1884us;1771us;1909us;1771us;1911us;1771us;1922us;1771us;13us;65535us;192us;1776us;194us;1776us;296us;1776us;452us;1776us;674us;1776us;676us;1776us;677us;1776us;1641us;1776us;1719us;1776us;1720us;1776us;1721us;1776us;1771us;1776us;1777us;1778us;6us;65535us;575us;1781us;664us;1781us;1576us;1781us;1774us;1781us;1780us;1781us;1866us;1867us;2us;65535us;1857us;1858us;1912us;1859us;86us;65535us;8us;1784us;114us;1784us;152us;1784us;181us;1784us;187us;1784us;191us;1784us;193us;1784us;204us;1784us;295us;1784us;390us;1784us;444us;1784us;451us;1784us;460us;1784us;487us;1784us;503us;1784us;567us;1784us;575us;1784us;634us;1784us;638us;1784us;650us;1784us;653us;1784us;664us;1784us;675us;1784us;690us;1784us;692us;1784us;695us;1784us;699us;1784us;719us;1784us;722us;1784us;725us;1784us;728us;1784us;731us;1784us;734us;1784us;751us;1784us;765us;1784us;852us;1784us;1021us;1784us;1063us;1784us;1248us;1784us;1251us;1784us;1254us;1784us;1538us;1784us;1571us;1784us;1574us;1784us;1576us;1784us;1640us;1784us;1678us;1784us;1680us;1784us;1681us;1784us;1685us;1784us;1689us;1784us;1692us;1784us;1695us;1784us;1698us;1784us;1700us;1784us;1702us;1784us;1707us;1784us;1711us;1784us;1716us;1784us;1722us;1784us;1725us;1784us;1728us;1784us;1731us;1784us;1737us;1784us;1740us;1784us;1741us;1784us;1743us;1784us;1744us;1784us;1747us;1784us;1751us;1784us;1754us;1784us;1756us;1784us;1759us;1784us;1774us;1784us;1780us;1784us;1786us;1784us;1789us;1784us;1856us;1784us;1860us;1784us;1866us;1784us;1876us;1784us;1882us;1784us;1884us;1784us;1909us;1784us;1911us;1784us;1922us;1784us;4us;65535us;528us;529us;1395us;1397us;1396us;1398us;1578us;1579us;87us;65535us;8us;1863us;114us;1863us;152us;1863us;181us;1863us;187us;1863us;191us;1863us;193us;1863us;204us;1863us;295us;1863us;390us;1863us;444us;1863us;451us;1863us;460us;1863us;487us;1863us;503us;1863us;567us;1863us;575us;1863us;634us;1863us;638us;1863us;650us;1863us;653us;1863us;664us;1863us;675us;1863us;690us;1863us;692us;1863us;695us;1863us;699us;1863us;719us;1863us;722us;1863us;725us;1863us;728us;1863us;731us;1863us;734us;1863us;751us;1863us;765us;1863us;852us;1863us;952us;953us;1021us;1863us;1063us;1863us;1248us;1863us;1251us;1863us;1254us;1863us;1538us;1863us;1571us;1863us;1574us;1863us;1576us;1863us;1640us;1863us;1678us;1863us;1680us;1863us;1681us;1863us;1685us;1863us;1689us;1863us;1692us;1863us;1695us;1863us;1698us;1863us;1700us;1863us;1702us;1863us;1707us;1863us;1711us;1863us;1716us;1863us;1722us;1863us;1725us;1863us;1728us;1863us;1731us;1863us;1737us;1863us;1740us;1863us;1741us;1863us;1743us;1863us;1744us;1863us;1747us;1863us;1751us;1863us;1754us;1863us;1756us;1863us;1759us;1863us;1774us;1863us;1780us;1863us;1786us;1863us;1789us;1863us;1856us;1863us;1860us;1863us;1866us;1863us;1876us;1863us;1882us;1863us;1884us;1863us;1909us;1863us;1911us;1863us;1922us;1863us;97us;65535us;8us;1871us;114us;1871us;152us;1871us;181us;1871us;187us;1871us;191us;1871us;193us;1871us;204us;1871us;295us;1871us;390us;1871us;444us;1871us;451us;1871us;460us;1871us;487us;1871us;503us;1871us;528us;1870us;567us;1871us;575us;1871us;576us;633us;619us;647us;632us;633us;634us;1871us;638us;1871us;643us;645us;650us;1871us;653us;1871us;664us;1871us;675us;1871us;690us;1871us;692us;1871us;695us;1871us;699us;1871us;719us;1871us;722us;1871us;725us;1871us;728us;1871us;731us;1871us;734us;1871us;751us;1871us;765us;1871us;852us;1871us;952us;1871us;1021us;1871us;1063us;1871us;1248us;1871us;1251us;1871us;1254us;1871us;1395us;1870us;1396us;1870us;1538us;1871us;1571us;1871us;1574us;1871us;1576us;1871us;1578us;1870us;1640us;1871us;1678us;1871us;1680us;1871us;1681us;1871us;1685us;1871us;1689us;1871us;1692us;1871us;1695us;1871us;1698us;1871us;1700us;1871us;1702us;1871us;1707us;1871us;1711us;1871us;1716us;1871us;1722us;1871us;1725us;1871us;1728us;1871us;1731us;1871us;1737us;1871us;1740us;1871us;1741us;1871us;1743us;1871us;1744us;1871us;1747us;1871us;1751us;1871us;1754us;1871us;1756us;1871us;1759us;1871us;1762us;647us;1764us;647us;1774us;1871us;1780us;1871us;1786us;1871us;1789us;1871us;1856us;1871us;1860us;1871us;1866us;1871us;1876us;1871us;1882us;1871us;1884us;1871us;1909us;1871us;1911us;1871us;1922us;1871us;4us;65535us;657us;673us;671us;672us;1768us;1900us;1902us;1903us;6us;65535us;657us;1906us;671us;1906us;1431us;1432us;1768us;1906us;1902us;1906us;1907us;1908us;10us;65535us;575us;1855us;664us;1855us;1576us;1855us;1774us;1855us;1780us;1855us;1856us;1857us;1860us;1861us;1866us;1855us;1909us;1916us;1911us;1924us;2us;65535us;1909us;1910us;1911us;1912us;3us;65535us;1860us;1862us;1909us;1925us;1911us;1925us;1us;65535us;888us;889us;6us;65535us;1926us;1936us;1933us;1936us;1940us;1936us;1946us;1936us;1947us;1936us;1948us;1936us;6us;65535us;1926us;1940us;1933us;1940us;1940us;1940us;1946us;1940us;1947us;1940us;1948us;1940us;6us;65535us;1926us;1942us;1933us;1942us;1940us;1941us;1946us;1942us;1947us;1942us;1948us;1942us;5us;65535us;1926us;1927us;1933us;1934us;1946us;1943us;1947us;1944us;1948us;1945us;125us;65535us;8us;1761us;114us;1761us;152us;1761us;181us;1761us;187us;1761us;191us;1761us;192us;1766us;193us;1761us;194us;1766us;204us;1761us;295us;1761us;296us;1766us;390us;1761us;444us;1761us;451us;1761us;452us;1766us;460us;1761us;487us;1761us;503us;1761us;528us;1766us;567us;1761us;575us;1761us;576us;1766us;601us;607us;617us;618us;619us;1766us;632us;1766us;634us;652us;638us;652us;643us;1766us;648us;649us;650us;1761us;653us;1761us;664us;1761us;674us;1766us;675us;1761us;676us;1766us;677us;1766us;690us;1761us;692us;1761us;695us;1761us;699us;1761us;719us;1761us;722us;1761us;725us;1761us;728us;1761us;731us;1761us;734us;1761us;751us;1761us;765us;1761us;844us;851us;848us;851us;852us;1761us;952us;1766us;1021us;1761us;1063us;1761us;1248us;1761us;1251us;1761us;1254us;1761us;1395us;1766us;1396us;1766us;1510us;1534us;1511us;1535us;1512us;1534us;1538us;1761us;1571us;1761us;1574us;1761us;1576us;1761us;1578us;1766us;1640us;1761us;1641us;1766us;1678us;652us;1680us;652us;1681us;1761us;1685us;1761us;1689us;1761us;1692us;1761us;1695us;1761us;1698us;1761us;1700us;1761us;1702us;1761us;1707us;1761us;1711us;1761us;1716us;1761us;1719us;1766us;1720us;1766us;1721us;1766us;1722us;1761us;1725us;1761us;1728us;1761us;1731us;1761us;1737us;1761us;1740us;1761us;1741us;1761us;1743us;1761us;1744us;1761us;1747us;1761us;1751us;1761us;1754us;1761us;1756us;1761us;1759us;1761us;1762us;1766us;1764us;1766us;1771us;1766us;1774us;1761us;1780us;1761us;1782us;1766us;1786us;1761us;1789us;1761us;1856us;1761us;1860us;1761us;1866us;1761us;1868us;1766us;1876us;1761us;1882us;1761us;1884us;1761us;1909us;1761us;1911us;1761us;1922us;1761us;1926us;1932us;1933us;1932us;1940us;1932us;1946us;1932us;1947us;1932us;1948us;1932us;379us;65535us;6us;2012us;8us;1957us;31us;2012us;40us;2006us;56us;1957us;61us;1957us;98us;1957us;111us;2004us;114us;1957us;117us;2012us;119us;2012us;123us;1957us;152us;1957us;181us;711us;184us;2004us;187us;1957us;191us;1957us;192us;1957us;193us;1957us;194us;1957us;204us;1957us;212us;2004us;215us;2004us;242us;2012us;256us;2012us;279us;2012us;286us;1957us;292us;1957us;295us;1957us;296us;1957us;322us;351us;333us;351us;338us;1957us;342us;1957us;390us;1957us;424us;2006us;427us;2012us;429us;2006us;432us;2012us;444us;711us;451us;1957us;452us;1957us;457us;2004us;460us;1957us;471us;2006us;474us;2012us;485us;486us;487us;1957us;494us;495us;497us;2012us;503us;1957us;507us;2006us;510us;2006us;513us;2006us;515us;2006us;528us;1957us;536us;537us;540us;541us;567us;711us;575us;1957us;576us;1957us;601us;1957us;603us;1957us;619us;1957us;632us;1957us;634us;1957us;638us;1957us;643us;1957us;650us;1957us;653us;1957us;664us;1957us;674us;1957us;675us;1957us;676us;1957us;677us;1957us;689us;2004us;690us;733us;692us;733us;695us;733us;699us;1957us;701us;2012us;713us;2012us;719us;733us;722us;1957us;725us;733us;728us;733us;731us;733us;734us;1957us;749us;750us;751us;1957us;760us;764us;765us;733us;768us;1957us;774us;2012us;780us;2012us;792us;793us;804us;1957us;805us;806us;819us;1957us;829us;2006us;832us;2012us;836us;2012us;846us;2012us;852us;1957us;892us;2006us;911us;2006us;914us;2006us;915us;2006us;920us;2006us;921us;2006us;924us;2006us;926us;2006us;927us;2006us;930us;934us;932us;934us;936us;2006us;940us;2006us;941us;2006us;943us;2006us;945us;2006us;948us;2006us;950us;2006us;952us;1957us;956us;935us;960us;2006us;962us;2006us;964us;2006us;967us;1957us;972us;2006us;975us;2006us;978us;980us;979us;980us;986us;2006us;994us;2006us;1015us;2006us;1018us;2006us;1021us;1957us;1024us;2006us;1025us;2006us;1028us;2006us;1029us;2006us;1032us;2006us;1034us;2006us;1035us;2006us;1038us;1957us;1041us;2006us;1045us;2006us;1047us;2012us;1053us;2012us;1063us;1957us;1069us;2012us;1071us;2012us;1074us;2012us;1077us;2012us;1095us;2006us;1096us;2012us;1100us;2006us;1101us;2012us;1107us;2012us;1110us;2012us;1113us;2012us;1119us;2012us;1123us;2012us;1127us;2012us;1133us;2012us;1135us;2012us;1140us;2012us;1142us;2012us;1144us;2012us;1146us;2012us;1148us;2012us;1150us;2012us;1152us;2006us;1154us;2012us;1164us;2012us;1171us;2012us;1177us;2012us;1179us;2012us;1183us;2006us;1184us;2012us;1188us;2012us;1190us;2006us;1191us;2012us;1195us;2012us;1198us;2012us;1201us;2012us;1203us;2012us;1206us;2012us;1208us;2012us;1248us;1957us;1251us;1957us;1254us;1957us;1257us;2012us;1259us;2012us;1263us;2012us;1265us;2012us;1267us;2012us;1269us;2012us;1271us;2012us;1273us;2012us;1275us;2012us;1277us;2012us;1279us;2012us;1281us;2012us;1283us;2012us;1285us;2012us;1287us;2012us;1289us;2012us;1291us;2012us;1293us;2012us;1295us;2012us;1297us;2012us;1299us;2012us;1301us;2012us;1303us;2012us;1304us;2012us;1305us;2012us;1306us;2012us;1309us;2012us;1319us;2012us;1322us;2006us;1324us;2006us;1330us;2006us;1332us;2006us;1339us;2006us;1341us;2006us;1343us;2006us;1348us;2012us;1349us;2012us;1353us;2012us;1355us;2012us;1358us;2012us;1359us;2012us;1361us;2012us;1364us;2012us;1366us;2012us;1368us;2012us;1370us;2012us;1372us;2012us;1373us;1954us;1374us;1954us;1375us;2012us;1377us;2012us;1378us;2012us;1380us;2012us;1381us;2012us;1383us;2012us;1384us;2012us;1386us;2012us;1387us;2012us;1389us;2012us;1390us;2012us;1392us;2012us;1393us;2012us;1395us;1957us;1396us;1957us;1403us;2004us;1407us;2012us;1409us;2012us;1411us;2012us;1412us;2012us;1413us;2012us;1416us;2012us;1421us;2012us;1429us;2012us;1430us;2012us;1433us;2012us;1434us;2012us;1435us;1437us;1436us;1438us;1440us;2004us;1443us;2004us;1445us;2004us;1446us;2004us;1452us;2012us;1459us;2012us;1466us;2012us;1473us;2012us;1490us;2012us;1497us;2012us;1498us;2012us;1504us;2012us;1510us;2012us;1511us;2012us;1512us;2012us;1524us;2012us;1530us;2012us;1538us;1957us;1540us;2012us;1553us;2012us;1555us;2012us;1558us;2012us;1559us;2012us;1565us;2012us;1571us;1957us;1574us;1957us;1576us;1957us;1578us;1957us;1585us;2012us;1590us;2012us;1594us;1957us;1598us;1957us;1606us;1957us;1615us;2012us;1640us;1957us;1641us;1957us;1648us;2012us;1655us;2006us;1657us;2012us;1660us;2006us;1662us;2012us;1672us;2006us;1674us;2006us;1678us;1957us;1680us;1957us;1681us;1957us;1685us;1957us;1689us;1957us;1692us;1957us;1695us;1957us;1698us;1957us;1700us;1957us;1702us;1957us;1705us;1706us;1707us;1957us;1711us;1957us;1714us;1715us;1716us;1957us;1719us;1957us;1720us;1957us;1721us;1957us;1722us;1957us;1725us;1957us;1728us;1957us;1731us;1957us;1737us;1957us;1740us;1957us;1741us;1957us;1743us;1957us;1744us;1957us;1747us;1957us;1751us;1957us;1754us;1957us;1756us;1957us;1759us;1957us;1762us;1957us;1764us;1957us;1771us;1957us;1774us;1957us;1780us;1957us;1782us;1957us;1786us;1957us;1789us;1957us;1856us;1957us;1860us;1957us;1866us;1957us;1868us;1957us;1876us;1957us;1882us;1957us;1884us;1957us;1893us;2012us;1901us;1957us;1909us;1957us;1911us;1957us;1922us;1957us;1926us;1957us;1933us;1957us;1940us;1957us;1946us;1957us;1947us;1957us;1948us;1957us;1949us;1950us;1951us;1953us;1952us;1953us;1958us;1959us;2008us;2006us;2050us;2051us;2053us;2012us;2057us;2012us;138us;65535us;8us;1765us;56us;57us;61us;62us;98us;300us;114us;1765us;123us;298us;152us;1765us;181us;568us;187us;1765us;191us;1765us;192us;1765us;193us;1765us;194us;1765us;204us;1765us;286us;310us;292us;293us;295us;1765us;296us;1765us;322us;335us;333us;335us;338us;339us;342us;343us;390us;1765us;444us;568us;451us;1765us;452us;1765us;460us;1765us;487us;1765us;503us;1765us;528us;1765us;567us;568us;575us;1765us;576us;1765us;601us;602us;603us;604us;619us;1765us;632us;1765us;634us;1765us;638us;1765us;643us;1765us;650us;1765us;653us;1765us;664us;1765us;674us;1765us;675us;1765us;676us;1765us;677us;1765us;690us;1765us;692us;1765us;695us;1765us;699us;1765us;719us;1765us;722us;1765us;725us;1765us;728us;1765us;731us;1765us;734us;1765us;751us;1765us;765us;1765us;768us;769us;804us;807us;819us;807us;852us;1765us;952us;1765us;967us;1040us;1021us;1765us;1038us;1040us;1063us;1765us;1248us;1765us;1251us;1765us;1254us;1765us;1395us;1765us;1396us;1765us;1538us;1765us;1571us;1765us;1574us;1765us;1576us;1765us;1578us;1765us;1594us;1611us;1598us;1611us;1606us;1611us;1640us;1765us;1641us;1765us;1678us;1765us;1680us;1765us;1681us;1765us;1685us;1765us;1689us;1765us;1692us;1765us;1695us;1765us;1698us;1765us;1700us;1765us;1702us;1765us;1707us;1765us;1711us;1765us;1716us;1765us;1719us;1765us;1720us;1765us;1721us;1765us;1722us;1765us;1725us;1765us;1728us;1765us;1731us;1765us;1737us;1765us;1740us;1765us;1741us;1765us;1743us;1765us;1744us;1765us;1747us;1765us;1751us;1765us;1754us;1765us;1756us;1765us;1759us;1765us;1762us;1765us;1764us;1765us;1771us;1765us;1774us;1765us;1780us;1765us;1782us;1765us;1786us;1765us;1789us;1765us;1856us;1765us;1860us;1765us;1866us;1765us;1868us;1765us;1876us;1765us;1882us;1765us;1884us;1765us;1901us;1902us;1909us;1765us;1911us;1765us;1922us;1765us;1926us;1931us;1933us;1931us;1940us;1931us;1946us;1931us;1947us;1931us;1948us;1931us;223us;65535us;6us;2013us;31us;2013us;40us;2007us;111us;2005us;117us;2013us;119us;2013us;181us;2005us;184us;2005us;212us;2005us;215us;2005us;242us;2013us;256us;2013us;279us;2013us;424us;2007us;427us;2013us;429us;2007us;432us;2013us;444us;2005us;457us;2005us;471us;2007us;474us;2013us;497us;2013us;507us;2007us;510us;2007us;513us;2007us;515us;2007us;567us;2005us;689us;2005us;701us;2013us;713us;2013us;774us;2013us;780us;2013us;829us;2007us;832us;2013us;836us;2013us;846us;2013us;892us;2007us;911us;2007us;914us;2007us;915us;2007us;920us;2007us;921us;2007us;924us;2007us;926us;2007us;927us;2007us;936us;2007us;940us;2007us;941us;2007us;943us;2007us;945us;2007us;948us;2007us;950us;2007us;956us;2007us;960us;2007us;962us;2007us;964us;2007us;972us;2007us;975us;2007us;986us;2007us;994us;2007us;1015us;2007us;1018us;2007us;1024us;2007us;1025us;2007us;1028us;2007us;1029us;2007us;1032us;2007us;1034us;2007us;1035us;2007us;1041us;2007us;1045us;2007us;1047us;2013us;1053us;2013us;1069us;2013us;1071us;2013us;1074us;2013us;1077us;2013us;1095us;2007us;1096us;2013us;1100us;2007us;1101us;2013us;1107us;2013us;1110us;2013us;1113us;2013us;1119us;2013us;1123us;2013us;1127us;2013us;1133us;2013us;1135us;2013us;1140us;2013us;1142us;2013us;1144us;2013us;1146us;2013us;1148us;2013us;1150us;2013us;1152us;2007us;1154us;2013us;1164us;2013us;1171us;2013us;1177us;2013us;1179us;2013us;1183us;2007us;1184us;2013us;1188us;2013us;1190us;2007us;1191us;2013us;1195us;2013us;1198us;2013us;1201us;2013us;1203us;2013us;1206us;2013us;1208us;2013us;1257us;2013us;1259us;2013us;1263us;2013us;1265us;2013us;1267us;2013us;1269us;2013us;1271us;2013us;1273us;2013us;1275us;2013us;1277us;2013us;1279us;2013us;1281us;2013us;1283us;2013us;1285us;2013us;1287us;2013us;1289us;2013us;1291us;2013us;1293us;2013us;1295us;2013us;1297us;2013us;1299us;2013us;1301us;2013us;1303us;2013us;1304us;2013us;1305us;2013us;1306us;2013us;1309us;2013us;1319us;2013us;1322us;2007us;1324us;2007us;1330us;2007us;1332us;2007us;1339us;2007us;1341us;2007us;1343us;2007us;1348us;2013us;1349us;2013us;1353us;2013us;1355us;2013us;1358us;2013us;1359us;2013us;1361us;2013us;1364us;2013us;1366us;2013us;1368us;2013us;1370us;2013us;1372us;2013us;1373us;2013us;1374us;2013us;1375us;2013us;1377us;2013us;1378us;2013us;1380us;2013us;1381us;2013us;1383us;2013us;1384us;2013us;1386us;2013us;1387us;2013us;1389us;2013us;1390us;2013us;1392us;2013us;1393us;2013us;1403us;2005us;1407us;2013us;1409us;2013us;1411us;2013us;1412us;2013us;1413us;2013us;1416us;2013us;1421us;2013us;1429us;2013us;1430us;2013us;1433us;2013us;1434us;2013us;1440us;2005us;1443us;2005us;1445us;2005us;1446us;2005us;1452us;2013us;1459us;2013us;1466us;2013us;1473us;2013us;1490us;2013us;1497us;2013us;1498us;2013us;1504us;2013us;1510us;2013us;1511us;2013us;1512us;2013us;1524us;2013us;1530us;2013us;1540us;2013us;1553us;2013us;1555us;2013us;1558us;2013us;1559us;2013us;1565us;2013us;1585us;2013us;1590us;2013us;1615us;2013us;1648us;2013us;1655us;2007us;1657us;2013us;1660us;2007us;1662us;2013us;1672us;2007us;1674us;2007us;1893us;2013us;2008us;2007us;2053us;2013us;2057us;2013us;8us;65535us;575us;1962us;705us;1962us;956us;1962us;986us;1962us;1466us;1962us;1511us;1962us;1512us;1962us;1961us;1962us;2us;65535us;1968us;2003us;2001us;2002us;8us;65535us;575us;1967us;705us;1967us;956us;1967us;986us;1967us;1466us;1967us;1511us;1967us;1512us;1967us;1961us;1967us;14us;65535us;111us;2011us;181us;2011us;184us;2011us;212us;2011us;215us;2011us;444us;2011us;457us;2011us;567us;2011us;689us;2011us;1403us;1463us;1440us;1463us;1443us;1463us;1445us;2011us;1446us;2011us;61us;65535us;40us;45us;424us;512us;429us;512us;471us;512us;507us;508us;510us;511us;513us;517us;515us;516us;829us;512us;892us;512us;911us;512us;914us;512us;915us;512us;920us;512us;921us;512us;924us;512us;926us;512us;927us;512us;936us;512us;940us;512us;941us;512us;943us;512us;945us;512us;948us;512us;950us;512us;956us;512us;960us;512us;962us;512us;964us;512us;972us;512us;975us;512us;986us;512us;994us;512us;1015us;512us;1018us;512us;1024us;512us;1025us;512us;1028us;512us;1029us;512us;1032us;512us;1034us;512us;1035us;512us;1041us;512us;1045us;512us;1095us;512us;1100us;512us;1152us;512us;1183us;512us;1190us;512us;1322us;512us;1324us;512us;1330us;512us;1332us;512us;1339us;512us;1341us;512us;1343us;512us;1655us;512us;1660us;512us;1672us;512us;1674us;512us;2008us;2009us;11us;65535us;111us;112us;181us;704us;184us;185us;212us;213us;215us;216us;444us;704us;457us;458us;567us;704us;689us;704us;1445us;1447us;1446us;1447us;148us;65535us;6us;1451us;31us;1451us;117us;1451us;119us;1451us;242us;1451us;256us;1451us;279us;1451us;427us;1451us;432us;1451us;474us;1451us;497us;1451us;701us;1451us;713us;1451us;774us;1451us;780us;1451us;832us;1451us;836us;1451us;846us;1451us;1047us;1451us;1053us;1451us;1069us;1451us;1071us;1451us;1074us;1451us;1077us;1451us;1096us;1451us;1101us;1451us;1107us;1451us;1110us;1451us;1113us;1451us;1119us;1451us;1123us;1451us;1127us;1451us;1133us;1451us;1135us;1451us;1140us;1451us;1142us;1451us;1144us;1451us;1146us;1451us;1148us;1451us;1150us;1451us;1154us;1451us;1164us;1451us;1171us;1451us;1177us;1451us;1179us;1451us;1184us;1451us;1188us;1451us;1191us;1451us;1195us;1451us;1198us;1451us;1201us;1451us;1203us;1451us;1206us;1451us;1208us;1451us;1257us;1451us;1259us;1451us;1263us;1451us;1265us;1451us;1267us;1451us;1269us;1451us;1271us;1451us;1273us;1451us;1275us;1451us;1277us;1451us;1279us;1451us;1281us;1451us;1283us;1451us;1285us;1451us;1287us;1451us;1289us;1451us;1291us;1451us;1293us;1451us;1295us;1451us;1297us;1451us;1299us;1451us;1301us;1451us;1303us;1451us;1304us;1451us;1305us;1451us;1306us;1451us;1309us;1451us;1319us;1451us;1348us;1451us;1349us;1451us;1353us;1451us;1355us;1451us;1358us;1451us;1359us;1451us;1361us;1451us;1364us;1451us;1366us;1451us;1368us;1451us;1370us;1451us;1372us;1451us;1373us;1451us;1374us;1451us;1375us;1451us;1377us;1451us;1378us;1451us;1380us;1451us;1381us;1451us;1383us;1451us;1384us;1451us;1386us;1451us;1387us;1451us;1389us;1451us;1390us;1451us;1392us;1451us;1393us;1451us;1407us;1451us;1409us;1451us;1411us;1451us;1412us;1451us;1413us;1451us;1416us;1451us;1421us;1451us;1429us;1451us;1430us;1451us;1433us;1451us;1434us;1451us;1452us;1451us;1459us;1451us;1466us;1451us;1473us;1451us;1490us;1451us;1497us;1451us;1498us;1451us;1504us;1451us;1510us;1451us;1511us;1451us;1512us;1451us;1524us;1451us;1530us;1451us;1540us;1451us;1553us;1451us;1555us;1451us;1558us;1451us;1559us;1451us;1565us;1451us;1585us;1451us;1590us;1451us;1615us;1451us;1648us;1451us;1657us;1451us;1662us;1451us;1893us;1451us;2053us;1451us;2057us;1451us;16us;65535us;51us;2017us;82us;2017us;85us;2017us;86us;2017us;87us;2019us;90us;2017us;232us;2017us;251us;2017us;257us;2017us;262us;2017us;266us;2017us;267us;2017us;268us;2017us;269us;2017us;2017us;2017us;2019us;2019us;14us;65535us;51us;91us;82us;91us;85us;91us;86us;91us;90us;91us;232us;270us;251us;270us;257us;258us;262us;264us;266us;270us;267us;270us;268us;270us;269us;270us;2017us;2018us;2us;65535us;87us;88us;2019us;2020us;10us;65535us;175us;2034us;323us;333us;411us;2034us;548us;2034us;742us;743us;928us;930us;930us;932us;1012us;1045us;1036us;1038us;1068us;1069us;4us;65535us;226us;227us;317us;318us;523us;524us;526us;527us;2us;65535us;1632us;1633us;1642us;1643us;10us;65535us;121us;122us;448us;449us;462us;463us;465us;466us;467us;468us;469us;470us;475us;476us;554us;555us;556us;557us;560us;561us;2us;65535us;68us;69us;238us;239us;19us;65535us;79us;80us;141us;142us;248us;249us;325us;326us;328us;329us;377us;378us;479us;480us;683us;718us;711us;712us;714us;715us;716us;717us;1103us;1104us;1153us;1161us;1186us;1187us;1193us;1194us;1200us;1201us;1619us;1623us;1620us;1621us;1643us;1644us;8us;65535us;175us;176us;323us;324us;411us;412us;548us;549us;742us;745us;928us;929us;1012us;1044us;1036us;1037us;4us;65535us;55us;56us;60us;61us;770us;771us;776us;777us;11us;65535us;108us;109us;182us;183us;414us;423us;416us;423us;421us;423us;447us;429us;456us;457us;552us;828us;553us;429us;559us;429us;825us;828us;7us;65535us;109us;110us;196us;748us;199us;748us;483us;484us;492us;493us;746us;748us;828us;829us;4us;65535us;1081us;1171us;1153us;1154us;1163us;1164us;1233us;1309us;9us;65535us;1079us;1158us;1080us;1168us;1082us;1175us;1083us;1317us;1155us;1156us;1165us;1166us;1172us;1173us;1310us;1311us;1313us;1314us;2us;65535us;286us;311us;301us;311us;2us;65535us;98us;130us;123us;126us;2us;65535us;73us;98us;97us;98us;309us;65535us;6us;870us;8us;870us;31us;870us;40us;42us;114us;870us;117us;870us;119us;870us;152us;870us;181us;870us;187us;870us;191us;870us;193us;870us;204us;870us;242us;870us;256us;870us;279us;870us;295us;870us;336us;870us;340us;870us;345us;870us;390us;870us;424us;870us;427us;870us;429us;870us;432us;870us;444us;870us;451us;870us;460us;870us;471us;870us;474us;870us;487us;870us;497us;870us;503us;870us;528us;870us;531us;870us;567us;870us;575us;870us;576us;577us;619us;870us;632us;870us;634us;870us;638us;870us;643us;870us;650us;870us;653us;870us;664us;870us;675us;870us;690us;870us;692us;870us;695us;870us;699us;870us;701us;870us;713us;870us;719us;870us;722us;870us;725us;870us;728us;870us;731us;870us;734us;870us;751us;870us;765us;870us;774us;870us;780us;870us;829us;870us;832us;870us;836us;870us;846us;870us;852us;870us;892us;870us;911us;870us;914us;870us;915us;870us;920us;870us;921us;870us;924us;870us;926us;870us;927us;870us;936us;870us;940us;870us;941us;870us;943us;870us;945us;870us;948us;870us;950us;870us;952us;870us;956us;870us;960us;870us;962us;870us;964us;870us;972us;870us;975us;870us;986us;870us;994us;870us;1015us;870us;1018us;870us;1021us;870us;1024us;870us;1025us;870us;1028us;870us;1029us;870us;1032us;870us;1034us;870us;1035us;870us;1041us;870us;1045us;870us;1047us;870us;1053us;870us;1063us;870us;1069us;870us;1071us;870us;1074us;870us;1077us;870us;1095us;870us;1096us;870us;1100us;870us;1101us;870us;1107us;870us;1110us;870us;1113us;870us;1119us;870us;1123us;870us;1127us;870us;1133us;870us;1135us;870us;1140us;870us;1142us;870us;1144us;870us;1146us;870us;1148us;870us;1150us;870us;1152us;870us;1154us;870us;1164us;870us;1171us;870us;1177us;870us;1179us;870us;1183us;870us;1184us;870us;1188us;870us;1190us;870us;1191us;870us;1195us;870us;1198us;870us;1201us;870us;1203us;870us;1206us;870us;1208us;870us;1248us;870us;1251us;870us;1254us;870us;1257us;870us;1259us;870us;1263us;870us;1265us;870us;1267us;870us;1269us;870us;1271us;870us;1273us;870us;1275us;870us;1277us;870us;1279us;870us;1281us;870us;1283us;870us;1285us;870us;1287us;870us;1289us;870us;1291us;870us;1293us;870us;1295us;870us;1297us;870us;1299us;870us;1301us;870us;1303us;870us;1304us;870us;1305us;870us;1306us;870us;1309us;870us;1319us;870us;1322us;870us;1324us;870us;1330us;870us;1332us;870us;1339us;870us;1341us;870us;1343us;870us;1348us;870us;1349us;870us;1353us;870us;1355us;870us;1358us;870us;1359us;870us;1361us;870us;1364us;870us;1366us;870us;1368us;870us;1370us;870us;1372us;870us;1373us;870us;1374us;870us;1375us;870us;1377us;870us;1378us;870us;1380us;870us;1381us;870us;1383us;870us;1384us;870us;1386us;870us;1387us;870us;1389us;870us;1390us;870us;1392us;870us;1393us;870us;1395us;870us;1396us;870us;1399us;870us;1400us;870us;1407us;870us;1409us;870us;1411us;870us;1412us;870us;1413us;870us;1416us;870us;1421us;870us;1429us;870us;1430us;870us;1433us;870us;1434us;870us;1452us;870us;1459us;870us;1466us;870us;1473us;870us;1490us;870us;1497us;870us;1498us;870us;1504us;870us;1510us;870us;1511us;870us;1512us;870us;1524us;870us;1530us;870us;1538us;870us;1540us;870us;1553us;870us;1555us;870us;1558us;870us;1559us;870us;1562us;1563us;1565us;870us;1571us;870us;1574us;870us;1576us;870us;1578us;870us;1580us;870us;1585us;870us;1590us;870us;1615us;870us;1640us;870us;1648us;870us;1655us;870us;1657us;870us;1660us;870us;1662us;870us;1672us;870us;1674us;870us;1678us;870us;1680us;870us;1681us;870us;1685us;870us;1689us;870us;1692us;870us;1695us;870us;1698us;870us;1700us;870us;1702us;870us;1707us;870us;1711us;870us;1716us;870us;1722us;870us;1725us;870us;1728us;870us;1731us;870us;1737us;870us;1740us;870us;1741us;870us;1743us;870us;1744us;870us;1747us;870us;1751us;870us;1754us;870us;1756us;870us;1759us;870us;1762us;870us;1764us;870us;1774us;870us;1780us;870us;1786us;870us;1789us;870us;1856us;870us;1860us;870us;1866us;870us;1876us;870us;1882us;870us;1884us;870us;1893us;870us;1909us;870us;1911us;870us;1922us;870us;2053us;870us;2057us;870us;308us;65535us;6us;871us;8us;871us;31us;871us;40us;46us;114us;871us;117us;871us;119us;871us;152us;871us;181us;871us;187us;871us;191us;871us;193us;871us;204us;871us;242us;871us;256us;871us;279us;871us;295us;871us;336us;871us;340us;871us;345us;871us;390us;871us;424us;871us;427us;871us;429us;871us;432us;871us;444us;871us;451us;871us;460us;871us;471us;871us;474us;871us;487us;871us;497us;871us;503us;871us;528us;871us;531us;871us;567us;871us;575us;871us;576us;871us;619us;871us;632us;871us;634us;871us;638us;871us;643us;871us;650us;871us;653us;871us;664us;871us;675us;871us;690us;871us;692us;871us;695us;871us;699us;871us;701us;871us;713us;871us;719us;871us;722us;871us;725us;871us;728us;871us;731us;871us;734us;871us;751us;871us;765us;871us;774us;871us;780us;871us;829us;871us;832us;871us;836us;871us;846us;871us;852us;871us;892us;871us;911us;871us;914us;871us;915us;871us;920us;871us;921us;871us;924us;871us;926us;871us;927us;871us;936us;871us;940us;871us;941us;871us;943us;871us;945us;871us;948us;871us;950us;871us;952us;871us;956us;871us;960us;871us;962us;871us;964us;871us;972us;871us;975us;871us;986us;871us;994us;871us;1015us;871us;1018us;871us;1021us;871us;1024us;871us;1025us;871us;1028us;871us;1029us;871us;1032us;871us;1034us;871us;1035us;871us;1041us;871us;1045us;871us;1047us;871us;1053us;871us;1063us;871us;1069us;871us;1071us;871us;1074us;871us;1077us;871us;1095us;871us;1096us;871us;1100us;871us;1101us;871us;1107us;871us;1110us;871us;1113us;871us;1119us;871us;1123us;871us;1127us;871us;1133us;871us;1135us;871us;1140us;871us;1142us;871us;1144us;871us;1146us;871us;1148us;871us;1150us;871us;1152us;871us;1154us;871us;1164us;871us;1171us;871us;1177us;871us;1179us;871us;1183us;871us;1184us;871us;1188us;871us;1190us;871us;1191us;871us;1195us;871us;1198us;871us;1201us;871us;1203us;871us;1206us;871us;1208us;871us;1248us;871us;1251us;871us;1254us;871us;1257us;871us;1259us;871us;1263us;871us;1265us;871us;1267us;871us;1269us;871us;1271us;871us;1273us;871us;1275us;871us;1277us;871us;1279us;871us;1281us;871us;1283us;871us;1285us;871us;1287us;871us;1289us;871us;1291us;871us;1293us;871us;1295us;871us;1297us;871us;1299us;871us;1301us;871us;1303us;871us;1304us;871us;1305us;871us;1306us;871us;1309us;871us;1319us;871us;1322us;871us;1324us;871us;1330us;871us;1332us;871us;1339us;871us;1341us;871us;1343us;871us;1348us;871us;1349us;871us;1353us;871us;1355us;871us;1358us;871us;1359us;871us;1361us;871us;1364us;871us;1366us;871us;1368us;871us;1370us;871us;1372us;871us;1373us;871us;1374us;871us;1375us;871us;1377us;871us;1378us;871us;1380us;871us;1381us;871us;1383us;871us;1384us;871us;1386us;871us;1387us;871us;1389us;871us;1390us;871us;1392us;871us;1393us;871us;1395us;871us;1396us;871us;1399us;871us;1400us;871us;1407us;871us;1409us;871us;1411us;871us;1412us;871us;1413us;871us;1416us;871us;1421us;871us;1429us;871us;1430us;871us;1433us;871us;1434us;871us;1452us;871us;1459us;871us;1466us;871us;1473us;871us;1490us;871us;1497us;871us;1498us;871us;1504us;871us;1510us;871us;1511us;871us;1512us;871us;1524us;871us;1530us;871us;1538us;871us;1540us;871us;1553us;871us;1555us;871us;1558us;871us;1559us;871us;1565us;871us;1571us;871us;1574us;871us;1576us;871us;1578us;871us;1580us;871us;1585us;871us;1590us;871us;1615us;871us;1640us;871us;1648us;871us;1655us;871us;1657us;871us;1660us;871us;1662us;871us;1672us;871us;1674us;871us;1678us;871us;1680us;871us;1681us;871us;1685us;871us;1689us;871us;1692us;871us;1695us;871us;1698us;871us;1700us;871us;1702us;871us;1707us;871us;1711us;871us;1716us;871us;1722us;871us;1725us;871us;1728us;871us;1731us;871us;1737us;871us;1740us;871us;1741us;871us;1743us;871us;1744us;871us;1747us;871us;1751us;871us;1754us;871us;1756us;871us;1759us;871us;1762us;871us;1764us;871us;1774us;871us;1780us;871us;1786us;871us;1789us;871us;1856us;871us;1860us;871us;1866us;871us;1876us;871us;1882us;871us;1884us;871us;1893us;871us;1909us;871us;1911us;871us;1922us;871us;2053us;871us;2057us;871us;2us;65535us;2053us;2054us;2057us;2058us;4us;65535us;2053us;2056us;2054us;2055us;2057us;2061us;2058us;2059us;155us;65535us;6us;1483us;31us;1483us;117us;1483us;119us;1483us;242us;1483us;256us;1483us;279us;1483us;336us;1483us;340us;1483us;345us;1483us;427us;1483us;432us;1483us;474us;1483us;497us;1483us;531us;1483us;701us;1483us;713us;1483us;774us;1483us;780us;1483us;832us;1483us;836us;1483us;846us;1483us;1047us;1483us;1053us;1483us;1069us;1483us;1071us;1483us;1074us;1483us;1077us;1483us;1096us;1483us;1101us;1483us;1107us;1483us;1110us;1483us;1113us;1483us;1119us;1483us;1123us;1483us;1127us;1483us;1133us;1483us;1135us;1483us;1140us;1483us;1142us;1483us;1144us;1483us;1146us;1483us;1148us;1483us;1150us;1483us;1154us;1483us;1164us;1483us;1171us;1483us;1177us;1483us;1179us;1483us;1184us;1483us;1188us;1483us;1191us;1483us;1195us;1483us;1198us;1483us;1201us;1483us;1203us;1483us;1206us;1483us;1208us;1483us;1257us;1483us;1259us;1483us;1263us;1483us;1265us;1483us;1267us;1483us;1269us;1483us;1271us;1483us;1273us;1483us;1275us;1483us;1277us;1483us;1279us;1483us;1281us;1483us;1283us;1483us;1285us;1483us;1287us;1483us;1289us;1483us;1291us;1483us;1293us;1483us;1295us;1483us;1297us;1483us;1299us;1483us;1301us;1483us;1303us;1483us;1304us;1483us;1305us;1483us;1306us;1483us;1309us;1483us;1319us;1483us;1348us;1483us;1349us;1483us;1353us;1483us;1355us;1483us;1358us;1483us;1359us;1483us;1361us;1483us;1364us;1483us;1366us;1483us;1368us;1483us;1370us;1483us;1372us;1483us;1373us;1483us;1374us;1483us;1375us;1483us;1377us;1483us;1378us;1483us;1380us;1483us;1381us;1483us;1383us;1483us;1384us;1483us;1386us;1483us;1387us;1483us;1389us;1483us;1390us;1483us;1392us;1483us;1393us;1483us;1399us;1483us;1400us;1483us;1407us;1483us;1409us;1483us;1411us;1483us;1412us;1483us;1413us;1483us;1416us;1483us;1421us;1483us;1429us;1483us;1430us;1483us;1433us;1483us;1434us;1483us;1452us;1483us;1459us;1483us;1466us;1483us;1473us;1483us;1490us;1483us;1497us;1483us;1498us;1483us;1504us;1483us;1510us;1483us;1511us;1483us;1512us;1483us;1524us;1483us;1530us;1483us;1540us;1483us;1553us;1483us;1555us;1483us;1558us;1483us;1559us;1483us;1565us;1483us;1580us;1483us;1585us;1483us;1590us;1483us;1615us;1483us;1648us;1483us;1657us;1483us;1662us;1483us;1893us;1483us;2053us;1483us;2057us;1483us;11us;65535us;335us;336us;339us;340us;344us;345us;369us;370us;529us;531us;793us;794us;805us;809us;808us;809us;1397us;1399us;1398us;1400us;1579us;1580us;5us;65535us;112us;626us;185us;626us;458us;626us;602us;621us;940us;626us;14us;65535us;31us;281us;72us;102us;96us;102us;198us;201us;242us;281us;256us;281us;275us;281us;292us;295us;322us;349us;333us;349us;355us;481us;1563us;1570us;2065us;2067us;2066us;2067us;10us;65535us;31us;53us;72us;53us;96us;53us;242us;53us;256us;53us;275us;53us;322us;347us;333us;347us;2070us;2072us;2071us;2072us;9us;65535us;580us;586us;581us;582us;584us;585us;968us;969us;970us;971us;1092us;1544us;1540us;1546us;1541us;1542us;2075us;2076us;5us;65535us;591us;592us;594us;595us;1093us;1652us;1648us;1654us;1649us;1650us;45us;65535us;578us;579us;609us;610us;662us;663us;665us;666us;669us;670us;706us;707us;709us;710us;796us;797us;882us;883us;892us;895us;893us;894us;957us;958us;987us;988us;990us;991us;995us;996us;998us;999us;1090us;1517us;1091us;1518us;1243us;1525us;1262us;1460us;1320us;1321us;1467us;1468us;1471us;1472us;1510us;1513us;1511us;1513us;1512us;1513us;1514us;1515us;1529us;1530us;1536us;1537us;1572us;1573us;1576us;1577us;1736us;1775us;1781us;1782us;1867us;1868us;1877us;1879us;1878us;1879us;1885us;1886us;1896us;1898us;1897us;1899us;1934us;1935us;1962us;1963us;1964us;1965us;1968us;1969us;1971us;1972us;2080us;2081us;28us;65535us;78us;79us;82us;83us;120us;121us;124us;125us;128us;129us;144us;145us;162us;163us;170us;171us;218us;219us;247us;248us;251us;252us;268us;308us;298us;299us;302us;303us;305us;306us;343us;344us;376us;384us;380us;381us;400us;402us;404us;406us;544us;545us;837us;838us;1047us;1051us;1048us;1049us;1053us;1056us;1054us;1055us;1075us;1076us;2084us;2085us;1us;65535us;1514us;1516us;51us;65535us;322us;331us;324us;330us;394us;396us;431us;435us;473us;477us;496us;500us;528us;534us;915us;916us;920us;922us;921us;923us;924us;925us;1013us;1557us;1028us;1030us;1029us;1031us;1032us;1033us;1152us;1174us;1153us;1160us;1154us;1159us;1155us;1157us;1263us;1264us;1265us;1266us;1267us;1268us;1269us;1270us;1271us;1272us;1273us;1274us;1275us;1276us;1277us;1278us;1279us;1280us;1281us;1282us;1283us;1284us;1285us;1286us;1287us;1288us;1289us;1290us;1291us;1292us;1293us;1294us;1295us;1296us;1297us;1298us;1299us;1300us;1301us;1302us;1364us;1365us;1366us;1367us;1368us;1369us;1370us;1371us;1555us;1556us;1614us;1618us;1615us;1617us;1904us;1905us;1911us;1915us;1916us;1918us;1958us;1960us;2008us;2010us;|]
let _fsyacc_sparseGotoTableRowOffsets = [|0us;1us;2us;3us;4us;5us;7us;15us;20us;26us;31us;36us;41us;46us;70us;72us;74us;76us;83us;88us;90us;93us;96us;99us;103us;110us;120us;130us;140us;143us;145us;148us;152us;154us;157us;160us;163us;167us;176us;185us;197us;201us;204us;207us;210us;216us;218us;220us;223us;226us;229us;233us;239us;249us;260us;271us;287us;312us;314us;316us;319us;321us;403us;527us;651us;653us;656us;659us;664us;671us;674us;678us;680us;683us;686us;689us;693us;702us;713us;715us;718us;722us;726us;731us;742us;746us;749us;751us;807us;834us;916us;918us;923us;926us;929us;932us;935us;939us;942us;947us;952us;955us;960us;970us;1058us;1147us;1152us;1162us;1164us;1166us;1170us;1176us;1178us;1180us;1185us;1189us;1287us;1291us;1295us;1299us;1304us;1306us;1310us;1316us;1320us;1324us;1329us;1333us;1337us;1346us;1355us;1362us;1366us;1370us;1374us;1379us;1386us;1388us;1390us;1511us;1519us;1640us;1760us;1764us;1770us;1891us;1893us;1895us;1899us;1902us;1904us;1909us;1912us;1918us;1921us;1923us;1926us;1928us;1930us;1932us;1935us;2243us;2245us;2250us;2254us;2465us;2469us;2471us;2473us;2510us;2525us;2540us;2555us;2559us;2563us;2607us;2614us;2626us;2682us;2685us;2713us;2741us;2769us;2772us;2775us;2779us;2807us;2814us;2820us;2873us;2875us;2933us;3138us;3143us;3260us;3263us;3265us;3270us;3275us;3285us;3295us;3297us;3299us;3302us;3305us;3307us;3424us;3559us;3695us;3700us;3849us;3853us;4009us;4165us;4376us;4532us;4688us;4692us;4696us;4698us;4854us;4856us;4858us;4860us;4862us;4864us;4866us;4868us;4870us;4874us;4876us;4881us;4883us;4885us;4887us;4890us;4897us;4904us;4908us;4914us;4918us;4920us;4922us;4924us;4927us;4929us;4934us;4940us;5096us;5254us;5371us;5488us;5491us;5497us;5501us;5512us;5523us;5528us;5543us;5555us;5589us;5591us;5625us;5637us;5724us;5836us;5948us;6014us;6024us;6111us;6125us;6132us;6135us;6222us;6227us;6315us;6413us;6418us;6425us;6436us;6439us;6443us;6445us;6452us;6459us;6466us;6472us;6598us;6978us;7117us;7341us;7350us;7353us;7362us;7377us;7439us;7451us;7600us;7617us;7632us;7635us;7646us;7651us;7654us;7665us;7668us;7688us;7697us;7702us;7714us;7722us;7727us;7737us;7740us;7743us;7746us;8056us;8365us;8368us;8373us;8529us;8541us;8547us;8562us;8573us;8583us;8589us;8635us;8664us;8666us;|]
let _fsyacc_stateToProdIdxsTableElements = [| 1us;0us;1us;0us;1us;1us;1us;1us;1us;2us;1us;2us;1us;3us;1us;3us;1us;4us;1us;4us;1us;5us;1us;6us;1us;7us;1us;8us;1us;9us;1us;10us;2us;11us;14us;1us;11us;2us;12us;15us;1us;12us;2us;13us;16us;1us;13us;1us;14us;1us;14us;1us;15us;1us;15us;1us;16us;1us;16us;2us;17us;18us;1us;18us;8us;19us;145us;146us;147us;148us;149us;150us;151us;8us;19us;145us;146us;147us;148us;149us;150us;151us;54us;19us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;1us;20us;2us;21us;22us;1us;22us;1us;23us;1us;24us;1us;25us;1us;25us;2us;25us;27us;1us;27us;1us;28us;1us;29us;2us;30us;1109us;1us;31us;1us;32us;2us;33us;34us;1us;33us;1us;34us;1us;34us;3us;35us;53us;56us;1us;35us;3us;36us;37us;38us;3us;36us;37us;38us;3us;36us;37us;38us;3us;36us;37us;38us;3us;36us;1112us;1113us;1us;37us;1us;38us;2us;39us;40us;2us;39us;40us;3us;39us;1112us;1113us;1us;40us;2us;41us;42us;1us;42us;2us;43us;44us;1us;43us;1us;45us;1us;45us;1us;45us;7us;46us;60us;61us;62us;63us;64us;66us;7us;46us;60us;61us;62us;63us;64us;66us;4us;46us;60us;61us;62us;1us;46us;1us;47us;1us;48us;3us;49us;50us;51us;2us;49us;50us;1us;49us;1us;49us;1us;50us;3us;51us;53us;56us;1us;51us;1us;52us;2us;53us;56us;3us;53us;56us;62us;2us;55us;57us;2us;55us;57us;1us;55us;1us;56us;1us;56us;1us;56us;1us;58us;1us;59us;6us;60us;61us;62us;63us;64us;66us;6us;60us;61us;62us;63us;64us;66us;3us;60us;61us;62us;2us;60us;61us;1us;60us;1us;61us;1us;62us;1us;63us;1us;63us;1us;63us;1us;64us;1us;65us;1us;66us;1us;66us;1us;66us;1us;66us;1us;66us;1us;66us;1us;66us;1us;66us;1us;66us;1us;66us;2us;68us;69us;54us;68us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;1us;69us;54us;69us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;1us;69us;1us;69us;3us;70us;71us;158us;1us;70us;1us;70us;1us;71us;1us;71us;1us;71us;1us;71us;1us;72us;1us;72us;1us;72us;1us;73us;1us;73us;1us;73us;2us;75us;76us;1us;75us;1us;75us;1us;76us;3us;77us;86us;87us;1us;77us;1us;77us;1us;77us;1us;77us;1us;77us;1us;77us;1us;78us;1us;78us;1us;79us;1us;80us;1us;81us;1us;81us;1us;81us;1us;82us;3us;83us;84us;85us;2us;83us;84us;1us;83us;1us;84us;1us;85us;1us;85us;2us;86us;87us;2us;86us;87us;1us;86us;1us;87us;2us;88us;89us;2us;88us;89us;1us;88us;1us;89us;2us;90us;91us;2us;90us;91us;1us;90us;1us;91us;1us;92us;1us;93us;1us;95us;1us;95us;1us;95us;8us;96us;97us;98us;99us;100us;101us;102us;103us;13us;96us;97us;98us;99us;100us;101us;102us;103us;299us;300us;301us;302us;303us;8us;96us;97us;98us;99us;100us;101us;102us;103us;13us;96us;97us;98us;99us;100us;101us;102us;103us;299us;300us;301us;302us;303us;1us;96us;1us;96us;1us;96us;1us;96us;1us;96us;1us;96us;1us;96us;1us;96us;1us;96us;1us;97us;4us;97us;1008us;1009us;1010us;2us;98us;99us;4us;98us;1008us;1009us;1010us;1us;99us;1us;100us;1us;100us;6us;101us;102us;188us;189us;232us;233us;1us;101us;1us;101us;1us;102us;1us;102us;1us;103us;1us;103us;1us;103us;1us;105us;1us;105us;2us;106us;107us;2us;106us;107us;1us;106us;1us;107us;3us;108us;109us;110us;3us;108us;109us;110us;2us;109us;110us;1us;109us;1us;109us;1us;110us;1us;111us;1us;111us;1us;111us;1us;112us;1us;113us;1us;114us;1us;114us;1us;115us;1us;115us;1us;115us;2us;117us;118us;1us;117us;1us;118us;1us;118us;2us;119us;142us;1us;119us;2us;120us;121us;1us;121us;2us;122us;123us;1us;122us;1us;124us;1us;124us;1us;124us;12us;125us;133us;134us;135us;137us;145us;146us;147us;148us;149us;150us;151us;11us;125us;133us;134us;135us;145us;146us;147us;148us;149us;150us;151us;3us;125us;150us;151us;1us;125us;1us;126us;3us;127us;128us;129us;2us;127us;128us;1us;127us;1us;127us;1us;128us;2us;129us;142us;1us;129us;1us;130us;1us;131us;11us;133us;134us;135us;137us;145us;146us;147us;148us;149us;150us;151us;10us;133us;134us;135us;145us;146us;147us;148us;149us;150us;151us;56us;133us;134us;135us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;2us;133us;134us;1us;133us;1us;136us;1us;137us;4us;138us;139us;140us;141us;1us;138us;2us;139us;141us;1us;139us;1us;142us;2us;142us;151us;2us;142us;164us;2us;142us;169us;1us;142us;1us;142us;1us;143us;1us;144us;7us;145us;146us;147us;148us;149us;150us;151us;7us;145us;146us;147us;148us;149us;150us;151us;1us;145us;3us;145us;612us;613us;1us;146us;5us;146us;614us;615us;616us;617us;1us;147us;1us;148us;1us;148us;1us;148us;1us;149us;2us;150us;151us;1us;150us;1us;150us;1us;151us;2us;152us;171us;1us;152us;1us;153us;4us;154us;155us;156us;157us;3us;154us;1112us;1113us;1us;155us;2us;156us;157us;4us;156us;1008us;1009us;1010us;1us;157us;3us;158us;1112us;1113us;1us;158us;3us;159us;1112us;1113us;5us;160us;161us;162us;163us;164us;2us;160us;161us;1us;160us;1us;161us;2us;162us;163us;1us;162us;1us;163us;1us;164us;1us;165us;3us;166us;1112us;1113us;3us;167us;168us;169us;2us;167us;168us;1us;167us;1us;168us;1us;169us;1us;170us;1us;170us;1us;170us;1us;171us;2us;173us;174us;1us;174us;4us;175us;176us;177us;178us;3us;175us;177us;180us;2us;175us;177us;1us;175us;1us;175us;2us;176us;607us;1us;176us;1us;176us;1us;177us;1us;178us;1us;179us;2us;180us;1181us;1us;180us;3us;181us;1112us;1113us;1us;181us;1us;181us;2us;182us;183us;3us;182us;1112us;1113us;1us;182us;1us;182us;1us;183us;3us;183us;1112us;1113us;1us;183us;1us;183us;1us;183us;1us;184us;1us;184us;1us;185us;1us;185us;2us;186us;1111us;1us;186us;1us;187us;1us;187us;7us;188us;189us;232us;233us;235us;243us;249us;1us;188us;1us;190us;1us;191us;1us;192us;1us;193us;1us;193us;1us;193us;1us;194us;1us;194us;1us;194us;4us;196us;197us;198us;199us;1us;197us;2us;198us;199us;2us;198us;199us;2us;198us;199us;2us;198us;199us;2us;198us;199us;1us;198us;1us;198us;1us;199us;5us;200us;201us;202us;211us;212us;2us;200us;201us;2us;200us;201us;2us;200us;201us;2us;200us;201us;1us;200us;1us;200us;1us;201us;1us;202us;1us;203us;1us;203us;1us;204us;1us;205us;1us;206us;1us;206us;1us;206us;1us;207us;3us;208us;209us;210us;2us;208us;209us;1us;208us;1us;209us;2us;210us;217us;1us;210us;2us;211us;212us;2us;211us;212us;1us;211us;1us;212us;2us;213us;214us;2us;213us;214us;1us;213us;1us;214us;1us;215us;1us;216us;1us;217us;1us;217us;1us;219us;1us;219us;1us;219us;1us;220us;1us;220us;2us;221us;222us;2us;221us;222us;1us;221us;1us;222us;2us;223us;224us;1us;224us;1us;224us;1us;225us;1us;225us;1us;225us;1us;225us;1us;225us;1us;225us;4us;226us;227us;228us;229us;4us;226us;227us;228us;229us;4us;226us;227us;228us;229us;1us;226us;1us;226us;1us;227us;1us;228us;1us;229us;2us;230us;231us;1us;231us;2us;232us;233us;1us;233us;16us;234us;235us;236us;237us;238us;239us;240us;241us;242us;243us;244us;245us;246us;247us;248us;249us;21us;234us;235us;236us;237us;238us;239us;240us;241us;242us;243us;244us;245us;246us;247us;248us;249us;299us;300us;301us;302us;303us;16us;234us;235us;236us;237us;238us;239us;240us;241us;242us;243us;244us;245us;246us;247us;248us;249us;21us;234us;235us;236us;237us;238us;239us;240us;241us;242us;243us;244us;245us;246us;247us;248us;249us;299us;300us;301us;302us;303us;1us;234us;1us;235us;3us;236us;237us;244us;1us;236us;1us;236us;1us;237us;2us;238us;239us;4us;238us;1008us;1009us;1010us;1us;238us;1us;239us;1us;240us;1us;240us;1us;240us;1us;240us;1us;240us;1us;240us;1us;240us;1us;240us;1us;240us;1us;241us;1us;242us;1us;242us;1us;243us;1us;243us;1us;244us;1us;244us;4us;245us;246us;247us;248us;3us;245us;246us;247us;3us;245us;246us;247us;1us;245us;1us;245us;1us;245us;1us;246us;1us;247us;1us;248us;1us;248us;1us;249us;1us;249us;4us;250us;251us;252us;253us;4us;250us;251us;252us;253us;4us;250us;251us;252us;253us;3us;250us;251us;252us;2us;250us;251us;1us;250us;1us;251us;1us;252us;1us;253us;4us;254us;255us;256us;257us;4us;254us;255us;256us;257us;4us;254us;255us;256us;257us;3us;254us;255us;256us;3us;254us;255us;256us;1us;254us;1us;254us;1us;254us;1us;255us;1us;256us;1us;257us;2us;259us;260us;1us;259us;1us;260us;2us;261us;541us;1us;261us;1us;261us;1us;262us;1us;262us;1us;262us;1us;263us;2us;264us;265us;1us;264us;1us;264us;1us;264us;1us;265us;1us;267us;1us;268us;1us;269us;1us;270us;2us;271us;272us;1us;271us;1us;271us;1us;274us;1us;274us;1us;274us;3us;276us;277us;278us;2us;276us;277us;1us;276us;1us;277us;1us;277us;1us;277us;1us;278us;1us;279us;2us;281us;282us;1us;281us;1us;282us;1us;283us;2us;285us;286us;1us;285us;1us;286us;2us;287us;288us;2us;287us;288us;1us;287us;1us;288us;1us;289us;2us;290us;291us;2us;290us;291us;1us;290us;4us;292us;293us;294us;295us;5us;292us;293us;294us;295us;444us;3us;292us;293us;294us;1us;292us;1us;292us;1us;293us;1us;293us;1us;294us;1us;295us;1us;295us;1us;295us;1us;296us;1us;296us;1us;297us;1us;298us;5us;299us;300us;301us;302us;303us;5us;299us;300us;301us;302us;303us;4us;299us;1000us;1112us;1113us;1us;299us;1us;299us;1us;299us;1us;300us;1us;301us;1us;302us;11us;303us;375us;376us;1011us;1061us;1062us;1073us;1114us;1115us;1117us;1118us;2us;303us;335us;2us;303us;475us;1us;303us;1us;303us;4us;304us;305us;306us;307us;2us;304us;305us;1us;304us;1us;305us;1us;306us;1us;306us;1us;307us;6us;308us;1063us;1064us;1065us;1066us;1067us;1us;308us;1us;309us;3us;310us;311us;312us;2us;310us;311us;1us;310us;1us;311us;1us;312us;1us;312us;1us;313us;1us;314us;1us;315us;1us;316us;1us;317us;4us;318us;319us;320us;321us;4us;318us;320us;1112us;1113us;1us;319us;3us;319us;1112us;1113us;1us;320us;1us;321us;1us;322us;1us;323us;2us;323us;324us;1us;323us;2us;324us;328us;3us;324us;329us;330us;1us;324us;2us;324us;329us;1us;324us;1us;325us;2us;326us;327us;2us;326us;327us;1us;327us;3us;327us;340us;341us;1us;328us;1us;328us;1us;328us;1us;328us;1us;329us;1us;332us;1us;332us;1us;332us;1us;332us;1us;332us;1us;333us;1us;335us;3us;335us;1075us;1076us;1us;337us;2us;337us;338us;2us;338us;947us;2us;338us;949us;1us;338us;1us;338us;1us;339us;3us;340us;341us;998us;3us;340us;341us;999us;2us;340us;341us;2us;340us;1058us;3us;341us;1075us;1076us;2us;342us;1058us;3us;343us;1075us;1076us;1us;344us;1us;344us;1us;344us;1us;344us;12us;345us;346us;347us;348us;349us;350us;352us;353us;354us;998us;1001us;1014us;2us;345us;1014us;2us;345us;1014us;8us;346us;347us;348us;349us;350us;352us;353us;354us;1us;346us;4us;347us;349us;353us;354us;1us;347us;1us;348us;1us;349us;1us;350us;1us;350us;1us;350us;5us;351us;1011us;1061us;1062us;1073us;2us;351us;356us;1us;351us;1us;351us;1us;351us;1us;351us;1us;351us;1us;352us;1us;352us;1us;353us;4us;355us;1008us;1009us;1010us;1us;356us;4us;356us;1008us;1009us;1010us;6us;357us;1004us;1005us;1008us;1009us;1010us;1us;358us;1us;358us;1us;359us;1us;359us;1us;359us;2us;360us;380us;1us;361us;2us;362us;363us;1us;362us;1us;362us;10us;364us;365us;366us;367us;368us;369us;370us;371us;372us;373us;10us;364us;365us;366us;367us;368us;369us;370us;371us;372us;373us;7us;364us;366us;367us;370us;371us;372us;373us;1us;365us;2us;366us;370us;1us;366us;1us;367us;2us;368us;369us;1us;368us;1us;369us;1us;370us;1us;371us;1us;371us;2us;372us;373us;6us;372us;788us;789us;790us;794us;797us;1us;373us;1us;374us;6us;375us;376us;1114us;1115us;1117us;1118us;1us;375us;1us;375us;1us;376us;1us;376us;1us;376us;9us;377us;378us;379us;381us;383us;385us;386us;1111us;1148us;1us;377us;4us;378us;379us;385us;386us;7us;378us;385us;788us;789us;790us;794us;797us;2us;378us;385us;2us;379us;386us;2us;379us;386us;1us;380us;2us;381us;383us;1us;381us;1us;382us;1us;382us;1us;382us;1us;383us;1us;384us;1us;384us;3us;387us;388us;390us;2us;387us;388us;1us;387us;1us;388us;1us;389us;1us;389us;4us;391us;392us;394us;1111us;3us;391us;392us;394us;1us;391us;1us;392us;1us;393us;1us;394us;1us;395us;1us;396us;1us;397us;2us;398us;399us;2us;398us;1181us;1us;398us;1us;399us;1us;400us;1us;400us;4us;401us;402us;403us;404us;4us;401us;402us;403us;404us;3us;401us;402us;403us;2us;401us;402us;1us;401us;1us;402us;1us;403us;1us;404us;1us;405us;1us;405us;2us;406us;407us;2us;406us;407us;2us;406us;407us;1us;406us;1us;406us;1us;407us;3us;408us;409us;410us;2us;409us;410us;1us;409us;1us;410us;1us;412us;3us;412us;1112us;1113us;1us;413us;1us;413us;1us;413us;1us;414us;1us;415us;1us;415us;1us;416us;1us;416us;1us;416us;1us;416us;2us;417us;418us;1us;417us;1us;417us;1us;418us;1us;419us;1us;420us;1us;421us;1us;422us;1us;423us;1us;424us;1us;425us;1us;425us;1us;425us;1us;425us;1us;425us;1us;425us;1us;425us;1us;425us;2us;426us;429us;2us;427us;430us;1us;429us;1us;429us;1us;430us;1us;430us;2us;431us;432us;6us;431us;432us;434us;435us;436us;437us;1us;432us;3us;433us;1112us;1113us;5us;434us;435us;436us;437us;439us;1us;434us;1us;434us;1us;434us;1us;435us;1us;436us;1us;436us;1us;437us;1us;438us;2us;438us;440us;1us;438us;2us;439us;440us;1us;441us;1us;441us;1us;442us;1us;442us;1us;442us;1us;444us;1us;444us;1us;445us;3us;446us;447us;448us;3us;446us;447us;448us;3us;446us;447us;448us;3us;446us;447us;448us;2us;446us;447us;1us;446us;1us;447us;1us;448us;2us;449us;450us;2us;449us;450us;1us;449us;1us;450us;1us;451us;1us;452us;2us;452us;453us;1us;453us;1us;455us;2us;455us;456us;1us;455us;1us;455us;1us;456us;1us;456us;1us;457us;2us;458us;459us;1us;458us;1us;458us;1us;459us;1us;460us;1us;461us;1us;462us;1us;463us;1us;464us;1us;465us;1us;466us;1us;467us;1us;468us;1us;469us;1us;470us;1us;471us;1us;472us;1us;473us;1us;474us;1us;475us;1us;476us;1us;477us;2us;478us;480us;1us;478us;1us;478us;2us;479us;481us;2us;479us;481us;1us;479us;1us;479us;1us;482us;1us;483us;1us;483us;1us;483us;1us;484us;1us;485us;1us;485us;2us;486us;487us;1us;487us;1us;487us;11us;488us;495us;496us;497us;498us;499us;500us;501us;506us;508us;512us;1us;489us;2us;491us;492us;13us;491us;558us;559us;560us;561us;564us;565us;567us;568us;569us;572us;574us;578us;1us;491us;1us;492us;1us;493us;2us;493us;735us;2us;493us;741us;1us;494us;11us;495us;496us;497us;498us;498us;499us;500us;501us;506us;508us;512us;11us;495us;496us;497us;498us;499us;499us;500us;501us;506us;508us;512us;11us;495us;496us;497us;498us;499us;500us;501us;505us;506us;508us;512us;11us;495us;496us;497us;498us;499us;500us;501us;506us;506us;508us;512us;11us;495us;496us;497us;498us;499us;500us;501us;506us;508us;509us;512us;11us;495us;496us;497us;498us;499us;500us;501us;506us;508us;511us;512us;11us;495us;496us;497us;498us;499us;500us;501us;506us;508us;512us;512us;11us;495us;496us;497us;498us;499us;500us;501us;506us;508us;512us;609us;11us;495us;496us;497us;498us;499us;500us;501us;506us;508us;512us;610us;11us;495us;496us;497us;498us;499us;500us;501us;506us;508us;512us;660us;12us;495us;496us;497us;498us;499us;500us;501us;506us;508us;512us;661us;662us;3us;495us;496us;497us;1us;495us;1us;496us;1us;498us;3us;499us;500us;501us;1us;500us;3us;502us;505us;507us;2us;503us;511us;1us;504us;2us;505us;507us;2us;506us;508us;1us;507us;1us;508us;2us;509us;510us;1us;510us;1us;511us;1us;512us;3us;513us;514us;515us;1us;513us;3us;514us;515us;1181us;1us;514us;1us;515us;1us;515us;3us;516us;517us;518us;6us;516us;517us;518us;1150us;1152us;1153us;2us;516us;517us;13us;516us;558us;559us;560us;561us;564us;565us;567us;568us;569us;572us;574us;578us;1us;517us;1us;518us;8us;519us;520us;521us;522us;523us;524us;525us;543us;4us;519us;520us;521us;522us;1us;520us;1us;521us;1us;521us;1us;522us;1us;522us;1us;523us;1us;524us;1us;524us;1us;525us;1us;525us;3us;526us;527us;528us;1us;526us;1us;527us;1us;529us;9us;530us;548us;549us;550us;551us;1114us;1115us;1117us;1118us;1us;530us;1us;530us;1us;531us;4us;532us;533us;534us;535us;1us;532us;1us;533us;1us;533us;1us;534us;1us;534us;1us;536us;2us;537us;538us;1us;537us;1us;537us;1us;538us;1us;538us;1us;539us;1us;539us;1us;539us;1us;540us;1us;540us;1us;540us;1us;542us;2us;542us;1135us;1us;542us;1us;543us;1us;544us;1us;545us;1us;546us;1us;547us;8us;548us;549us;550us;551us;1114us;1115us;1117us;1118us;2us;548us;549us;1us;548us;1us;549us;3us;550us;607us;1115us;2us;550us;1115us;1us;551us;4us;552us;553us;554us;555us;4us;552us;553us;554us;555us;5us;552us;553us;562us;571us;573us;1us;552us;1us;553us;2us;554us;607us;1us;554us;1us;555us;13us;556us;558us;559us;560us;561us;564us;565us;567us;568us;569us;572us;574us;578us;13us;558us;559us;560us;561us;561us;564us;565us;567us;568us;569us;572us;574us;578us;13us;558us;559us;560us;561us;564us;565us;566us;567us;568us;569us;572us;574us;578us;13us;558us;559us;560us;561us;564us;565us;567us;567us;568us;569us;572us;574us;578us;13us;558us;559us;560us;561us;564us;565us;567us;568us;569us;571us;572us;574us;578us;13us;558us;559us;560us;561us;564us;565us;567us;568us;569us;572us;572us;574us;578us;13us;558us;559us;560us;561us;564us;565us;567us;568us;569us;572us;574us;575us;578us;13us;558us;559us;560us;561us;564us;565us;567us;568us;569us;572us;574us;577us;578us;12us;558us;559us;560us;561us;564us;565us;567us;568us;569us;572us;574us;578us;13us;558us;559us;560us;561us;564us;565us;567us;568us;569us;572us;574us;578us;578us;13us;558us;559us;560us;561us;564us;565us;567us;568us;569us;572us;574us;578us;581us;14us;558us;559us;560us;561us;564us;565us;567us;568us;569us;572us;574us;578us;585us;586us;18us;558us;559us;560us;561us;564us;565us;567us;568us;569us;572us;574us;578us;654us;655us;871us;872us;873us;874us;13us;558us;559us;560us;561us;564us;565us;567us;568us;569us;572us;574us;578us;738us;3us;558us;559us;560us;1us;558us;1us;559us;1us;561us;3us;562us;571us;573us;2us;563us;577us;2us;564us;565us;1us;564us;1us;565us;1us;566us;3us;567us;568us;569us;1us;568us;1us;570us;2us;571us;573us;2us;572us;574us;1us;573us;1us;574us;2us;575us;576us;1us;576us;1us;577us;1us;578us;2us;579us;580us;1us;579us;2us;580us;1181us;1us;580us;5us;581us;582us;583us;1112us;1113us;2us;581us;582us;1us;582us;1us;583us;1us;585us;2us;586us;1181us;1us;586us;3us;587us;588us;589us;2us;587us;588us;1us;587us;1us;588us;1us;589us;1us;590us;2us;591us;592us;1us;591us;1us;591us;1us;592us;54us;593us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;2us;594us;595us;1us;594us;1us;596us;2us;596us;941us;3us;597us;598us;599us;2us;597us;598us;1us;597us;1us;598us;1us;600us;1us;600us;58us;601us;602us;603us;604us;605us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;2us;601us;602us;1us;601us;1us;604us;1us;604us;1us;605us;1us;605us;1us;605us;1us;605us;5us;606us;614us;615us;616us;617us;1us;607us;2us;607us;643us;2us;607us;649us;2us;607us;652us;2us;607us;654us;2us;607us;726us;2us;607us;737us;2us;607us;742us;2us;607us;802us;2us;607us;815us;2us;607us;834us;2us;607us;838us;2us;607us;843us;3us;607us;843us;1115us;2us;607us;859us;2us;607us;933us;1us;608us;1us;609us;1us;609us;1us;609us;1us;609us;1us;609us;1us;610us;1us;610us;1us;610us;1us;610us;1us;610us;1us;610us;2us;612us;613us;2us;612us;613us;1us;612us;1us;613us;4us;614us;615us;616us;617us;1us;614us;1us;615us;2us;616us;617us;1us;616us;1us;617us;1us;618us;1us;619us;1us;620us;2us;621us;622us;2us;621us;622us;1us;621us;1us;622us;2us;623us;624us;2us;623us;624us;1us;623us;1us;624us;5us;625us;626us;627us;628us;629us;3us;625us;626us;629us;1us;625us;1us;626us;2us;627us;628us;1us;628us;1us;629us;1us;629us;3us;630us;631us;632us;55us;630us;631us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;1us;630us;1us;631us;1us;632us;1us;633us;54us;633us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;2us;634us;635us;54us;634us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;1us;636us;1us;636us;2us;637us;638us;1us;637us;1us;639us;1us;639us;1us;640us;1us;640us;15us;641us;642us;643us;644us;645us;646us;647us;648us;649us;650us;651us;652us;653us;654us;655us;6us;641us;642us;643us;644us;645us;646us;4us;641us;642us;643us;644us;2us;641us;642us;1us;641us;1us;642us;1us;643us;1us;644us;1us;645us;1us;646us;1us;646us;5us;647us;648us;649us;650us;651us;4us;647us;648us;649us;650us;2us;647us;648us;1us;647us;1us;648us;1us;649us;1us;650us;1us;651us;1us;652us;1us;652us;1us;652us;1us;653us;1us;654us;2us;655us;1240us;2us;656us;658us;54us;656us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;2us;657us;659us;54us;657us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;1us;658us;1us;659us;1us;660us;1us;660us;1us;660us;1us;660us;1us;660us;1us;660us;1us;660us;2us;661us;662us;2us;661us;662us;2us;661us;662us;2us;661us;662us;2us;661us;662us;1us;661us;1us;661us;1us;662us;1us;663us;1us;663us;1us;663us;1us;663us;1us;663us;1us;664us;1us;664us;1us;664us;1us;665us;54us;665us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;1us;666us;1us;666us;54us;667us;668us;669us;670us;671us;672us;673us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;718us;763us;764us;765us;766us;57us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;721us;722us;723us;724us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;746us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;750us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;755us;763us;764us;765us;766us;55us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;757us;758us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;759us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;761us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;764us;765us;766us;53us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;766us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;849us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;871us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;874us;54us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;874us;55us;667us;668us;669us;670us;671us;672us;673us;676us;677us;678us;679us;680us;681us;682us;683us;684us;685us;686us;687us;688us;689us;690us;691us;692us;693us;694us;695us;696us;697us;698us;699us;700us;701us;702us;703us;704us;705us;706us;707us;708us;709us;710us;711us;712us;713us;714us;715us;716us;717us;763us;764us;765us;766us;1201us;1202us;2us;667us;668us;1us;667us;1us;668us;2us;669us;670us;1us;669us;1us;670us;2us;671us;672us;1us;671us;1us;672us;1us;673us;2us;674us;720us;1us;674us;1us;674us;5us;675us;759us;760us;761us;762us;7us;675us;759us;760us;761us;762us;804us;805us;2us;676us;677us;1us;677us;2us;678us;679us;1us;679us;2us;680us;681us;1us;681us;2us;682us;683us;1us;683us;2us;684us;685us;1us;685us;2us;686us;687us;1us;687us;2us;688us;689us;1us;689us;2us;690us;691us;1us;691us;2us;692us;693us;1us;693us;2us;694us;695us;1us;695us;2us;696us;697us;1us;697us;2us;698us;699us;1us;699us;2us;700us;701us;1us;701us;2us;702us;703us;1us;703us;2us;704us;705us;1us;705us;2us;706us;707us;1us;707us;2us;708us;709us;1us;709us;2us;710us;711us;1us;711us;2us;712us;713us;1us;713us;2us;714us;715us;1us;715us;2us;716us;717us;1us;718us;3us;718us;1142us;1143us;2us;718us;1143us;1us;719us;2us;719us;1130us;3us;721us;722us;723us;2us;721us;722us;1us;721us;1us;722us;1us;723us;1us;723us;1us;724us;1us;725us;1us;726us;1us;727us;1us;728us;1us;728us;1us;728us;1us;729us;1us;729us;3us;730us;731us;732us;2us;730us;731us;1us;730us;1us;731us;1us;732us;1us;733us;2us;734us;736us;1us;734us;1us;735us;1us;735us;1us;736us;1us;737us;1us;738us;7us;739us;740us;741us;742us;743us;744us;745us;5us;739us;740us;741us;743us;744us;2us;740us;743us;1us;740us;1us;741us;1us;741us;1us;742us;1us;742us;1us;743us;1us;744us;1us;745us;1us;746us;1us;748us;1us;748us;1us;749us;1us;749us;2us;750us;751us;1us;751us;2us;752us;753us;1us;752us;1us;753us;1us;755us;1us;756us;1us;756us;2us;757us;758us;1us;757us;1us;758us;4us;759us;760us;761us;762us;1us;760us;2us;761us;762us;1us;762us;4us;763us;764us;765us;766us;1us;763us;2us;765us;766us;1us;765us;1us;767us;2us;767us;1108us;3us;767us;1108us;1122us;2us;767us;1122us;1us;767us;1us;768us;2us;768us;1129us;1us;768us;1us;769us;2us;769us;1125us;1us;769us;1us;770us;2us;770us;1128us;1us;770us;1us;771us;2us;771us;1141us;1us;771us;1us;772us;2us;772us;1136us;1us;772us;1us;773us;2us;773us;1137us;1us;773us;4us;774us;775us;776us;777us;8us;774us;775us;776us;777us;915us;916us;917us;918us;3us;774us;775us;776us;7us;774us;775us;776us;915us;916us;917us;918us;3us;774us;775us;776us;5us;774us;775us;776us;916us;917us;2us;774us;775us;4us;774us;775us;916us;917us;1us;774us;1us;774us;1us;776us;1us;777us;1us;778us;1us;778us;1us;779us;1us;779us;2us;780us;781us;8us;780us;781us;889us;890us;891us;895us;896us;897us;7us;781us;889us;890us;891us;895us;896us;897us;1us;781us;6us;782us;788us;789us;790us;794us;797us;1us;783us;6us;783us;788us;789us;790us;794us;797us;6us;784us;788us;789us;790us;794us;797us;3us;785us;786us;787us;6us;785us;786us;787us;892us;893us;894us;2us;785us;786us;6us;785us;788us;789us;790us;794us;797us;1us;786us;1us;787us;6us;788us;788us;789us;790us;794us;797us;6us;788us;789us;789us;790us;794us;797us;6us;788us;789us;790us;791us;794us;797us;6us;788us;789us;790us;794us;797us;1070us;1us;788us;1us;789us;1us;790us;1us;790us;1us;791us;2us;791us;1119us;1us;792us;2us;792us;1107us;1us;792us;2us;792us;1107us;1us;793us;1us;794us;1us;794us;1us;795us;1us;795us;1us;795us;1us;796us;2us;796us;1135us;1us;796us;1us;797us;1us;797us;1us;798us;1us;799us;4us;800us;801us;802us;803us;2us;800us;801us;1us;800us;1us;801us;1us;802us;1us;803us;3us;804us;805us;929us;2us;804us;805us;1us;804us;1us;805us;1us;806us;1us;807us;1us;808us;1us;810us;6us;811us;812us;1114us;1115us;1117us;1118us;1us;811us;1us;811us;1us;811us;1us;811us;1us;812us;1us;812us;4us;813us;814us;815us;816us;2us;813us;814us;1us;813us;1us;814us;1us;815us;1us;816us;1us;817us;1us;818us;1us;819us;1us;820us;1us;821us;1us;822us;1us;823us;1us;824us;1us;825us;1us;826us;1us;827us;4us;828us;829us;830us;831us;2us;828us;829us;1us;828us;1us;829us;1us;830us;1us;830us;1us;831us;4us;832us;833us;834us;835us;5us;832us;833us;834us;835us;1144us;2us;832us;833us;1us;832us;1us;833us;1us;834us;1us;835us;4us;836us;837us;838us;839us;2us;836us;837us;1us;836us;1us;837us;1us;838us;1us;839us;10us;840us;841us;842us;843us;844us;845us;846us;847us;848us;849us;15us;840us;841us;842us;843us;844us;845us;846us;847us;848us;849us;854us;1114us;1115us;1117us;1118us;14us;840us;841us;842us;843us;844us;845us;846us;847us;848us;849us;1114us;1115us;1117us;1118us;1us;840us;2us;841us;842us;1us;841us;1us;842us;1us;843us;2us;843us;1115us;1us;844us;1us;845us;1us;846us;1us;847us;1us;848us;1us;849us;1us;849us;1us;850us;1us;850us;1us;850us;1us;850us;1us;850us;1us;850us;1us;851us;1us;852us;1us;853us;2us;853us;856us;2us;854us;855us;1us;854us;1us;855us;1us;855us;5us;857us;858us;859us;860us;861us;2us;857us;858us;1us;857us;1us;858us;1us;859us;1us;860us;1us;861us;1us;862us;1us;863us;1us;864us;1us;865us;1us;867us;1us;869us;1us;870us;1us;870us;2us;871us;872us;1us;872us;1us;873us;1us;874us;1us;874us;1us;875us;1us;876us;1us;877us;1us;877us;1us;877us;2us;877us;878us;1us;877us;1us;877us;1us;878us;1us;881us;1us;883us;1us;883us;1us;883us;1us;883us;2us;885us;886us;1us;885us;5us;886us;1011us;1061us;1062us;1073us;1us;886us;1us;887us;1us;887us;1us;887us;1us;887us;2us;887us;906us;1us;887us;1us;888us;2us;889us;890us;1us;889us;2us;889us;906us;1us;889us;1us;890us;2us;893us;894us;1us;894us;2us;894us;906us;1us;894us;1us;895us;1us;895us;2us;895us;906us;1us;895us;2us;896us;897us;1us;896us;1us;896us;1us;897us;2us;897us;906us;1us;897us;1us;897us;1us;898us;2us;898us;906us;2us;900us;903us;2us;901us;902us;1us;902us;1us;903us;3us;904us;1112us;1113us;1us;905us;1us;906us;5us;908us;909us;910us;911us;912us;3us;908us;909us;910us;1us;908us;1us;910us;1us;912us;2us;913us;914us;1us;913us;1us;913us;1us;913us;1us;914us;1us;914us;1us;916us;1us;919us;2us;921us;923us;1us;921us;1us;922us;1us;922us;1us;922us;1us;923us;1us;923us;1us;924us;1us;924us;1us;926us;1us;926us;1us;927us;1us;927us;1us;928us;4us;928us;1008us;1009us;1010us;1us;928us;1us;928us;1us;928us;1us;929us;1us;929us;1us;930us;5us;931us;932us;933us;934us;935us;2us;931us;932us;1us;931us;1us;932us;1us;933us;1us;934us;1us;935us;2us;936us;937us;2us;936us;937us;2us;936us;937us;1us;936us;1us;937us;6us;938us;939us;940us;941us;942us;943us;5us;938us;939us;940us;941us;942us;4us;938us;939us;940us;941us;2us;938us;939us;1us;938us;1us;939us;1us;940us;1us;940us;1us;942us;1us;942us;1us;943us;1us;943us;1us;944us;1us;944us;1us;945us;1us;945us;1us;945us;2us;946us;947us;1us;947us;2us;948us;949us;1us;949us;2us;951us;952us;1us;951us;1us;952us;3us;953us;954us;955us;2us;953us;954us;1us;953us;1us;954us;3us;956us;957us;959us;2us;956us;957us;1us;956us;1us;957us;1us;958us;1us;958us;3us;960us;961us;963us;2us;960us;961us;1us;960us;1us;961us;1us;962us;1us;962us;5us;964us;965us;966us;967us;968us;3us;964us;965us;968us;2us;964us;965us;1us;964us;1us;965us;2us;966us;967us;2us;966us;967us;2us;966us;967us;1us;966us;1us;967us;3us;969us;970us;973us;2us;969us;970us;1us;969us;1us;970us;2us;971us;972us;2us;971us;972us;2us;971us;972us;1us;971us;1us;972us;8us;974us;975us;976us;977us;977us;1008us;1009us;1010us;8us;974us;975us;976us;977us;1006us;1008us;1009us;1010us;7us;974us;975us;976us;977us;1008us;1009us;1010us;4us;974us;975us;976us;977us;1us;974us;1us;975us;1us;976us;1us;976us;4us;978us;979us;980us;981us;3us;978us;979us;980us;1us;978us;1us;979us;1us;980us;1us;980us;1us;982us;1us;982us;5us;983us;984us;988us;989us;990us;6us;983us;984us;988us;989us;990us;1007us;2us;983us;984us;1us;983us;1us;984us;1us;985us;2us;985us;1130us;1us;985us;2us;986us;987us;3us;986us;987us;1126us;1us;986us;1us;987us;2us;988us;989us;1us;988us;1us;989us;5us;991us;992us;994us;995us;997us;2us;991us;992us;1us;991us;1us;992us;1us;993us;1us;993us;2us;994us;995us;1us;994us;1us;995us;1us;996us;1us;996us;3us;998us;1001us;1014us;1us;998us;2us;999us;1058us;1us;999us;3us;1000us;1112us;1113us;1us;1001us;2us;1002us;1003us;4us;1002us;1003us;1074us;1077us;1us;1002us;1us;1002us;5us;1004us;1005us;1008us;1009us;1010us;1us;1004us;1us;1004us;5us;1007us;1011us;1061us;1062us;1073us;1us;1007us;1us;1008us;1us;1009us;1us;1009us;1us;1010us;4us;1011us;1061us;1062us;1073us;1us;1011us;1us;1011us;1us;1011us;1us;1012us;1us;1013us;1us;1014us;1us;1014us;2us;1015us;1060us;1us;1015us;1us;1015us;32us;1016us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1025us;1026us;1027us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1016us;31us;1017us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1025us;1026us;1027us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1017us;30us;1018us;1019us;1020us;1021us;1022us;1023us;1024us;1025us;1026us;1027us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1018us;29us;1019us;1020us;1021us;1022us;1023us;1024us;1025us;1026us;1027us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1019us;28us;1020us;1021us;1022us;1023us;1024us;1025us;1026us;1027us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1020us;27us;1021us;1022us;1023us;1024us;1025us;1026us;1027us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1021us;26us;1022us;1023us;1024us;1025us;1026us;1027us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1022us;25us;1023us;1024us;1025us;1026us;1027us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1023us;24us;1024us;1025us;1026us;1027us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1024us;23us;1025us;1026us;1027us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1025us;22us;1026us;1027us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1026us;21us;1027us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1027us;20us;1028us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1028us;19us;1029us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1029us;18us;1030us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1030us;17us;1031us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1031us;16us;1032us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1032us;15us;1033us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1033us;14us;1034us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1034us;13us;1035us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1035us;12us;1036us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1036us;11us;1037us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1037us;10us;1038us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1038us;9us;1039us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1039us;8us;1040us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1040us;7us;1041us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1041us;6us;1042us;1043us;1044us;1045us;1046us;1047us;1us;1042us;5us;1043us;1044us;1045us;1046us;1047us;1us;1043us;4us;1044us;1045us;1046us;1047us;1us;1044us;3us;1045us;1046us;1047us;1us;1045us;2us;1046us;1047us;1us;1046us;1us;1047us;1us;1047us;1us;1048us;1us;1048us;1us;1048us;3us;1048us;1049us;1050us;4us;1049us;1050us;1080us;1081us;2us;1049us;1050us;1us;1049us;1us;1050us;2us;1052us;1053us;1us;1053us;1us;1053us;4us;1054us;1061us;1062us;1073us;1us;1054us;1us;1054us;1us;1054us;3us;1055us;1075us;1076us;3us;1056us;1075us;1076us;1us;1057us;1us;1058us;1us;1059us;1us;1060us;3us;1061us;1062us;1073us;2us;1061us;1062us;5us;1061us;1062us;1087us;1088us;1089us;1us;1061us;1us;1062us;5us;1063us;1064us;1065us;1066us;1067us;5us;1063us;1064us;1065us;1066us;1067us;4us;1063us;1064us;1065us;1066us;3us;1063us;1064us;1065us;2us;1063us;1064us;1us;1063us;1us;1064us;1us;1065us;1us;1066us;1us;1067us;1us;1068us;1us;1069us;1us;1070us;1us;1071us;1us;1072us;1us;1073us;2us;1073us;1115us;1us;1073us;2us;1073us;1115us;1us;1074us;2us;1075us;1076us;4us;1075us;1076us;1112us;1113us;1us;1076us;1us;1077us;1us;1077us;1us;1078us;1us;1079us;1us;1079us;7us;1080us;1081us;1082us;1083us;1084us;1085us;1086us;3us;1080us;1081us;1082us;3us;1080us;1081us;1082us;2us;1080us;1081us;1us;1080us;1us;1081us;1us;1082us;3us;1083us;1084us;1090us;1us;1083us;1us;1084us;1us;1085us;1us;1086us;3us;1087us;1088us;1089us;2us;1088us;1089us;1us;1088us;1us;1090us;1us;1091us;2us;1093us;1094us;3us;1093us;1104us;1105us;1us;1093us;1us;1094us;1us;1094us;3us;1095us;1112us;1113us;1us;1096us;1us;1097us;3us;1097us;1104us;1105us;1us;1097us;2us;1098us;1099us;1us;1099us;1us;1099us;1us;1100us;2us;1101us;1102us;1us;1102us;1us;1103us;3us;1104us;1104us;1105us;3us;1104us;1105us;1105us;3us;1104us;1105us;1106us;1us;1104us;1us;1105us;1us;1106us;1us;1107us;1us;1107us;1us;1108us;2us;1108us;1122us;1us;1108us;2us;1108us;1155us;1us;1109us;1us;1110us;1us;1111us;2us;1112us;1113us;1us;1112us;1us;1113us;4us;1114us;1115us;1117us;1118us;1us;1114us;1us;1114us;1us;1115us;1us;1115us;1us;1116us;3us;1117us;1118us;1147us;3us;1117us;1118us;1147us;1us;1117us;1us;1118us;1us;1118us;1us;1118us;1us;1119us;1us;1120us;1us;1121us;1us;1122us;1us;1123us;1us;1124us;1us;1125us;1us;1126us;1us;1127us;1us;1128us;1us;1129us;1us;1130us;1us;1131us;1us;1132us;1us;1133us;1us;1134us;1us;1135us;1us;1136us;1us;1137us;1us;1138us;1us;1139us;1us;1140us;1us;1141us;2us;1142us;1143us;1us;1143us;1us;1144us;1us;1144us;1us;1145us;1us;1146us;1us;1146us;1us;1147us;1us;1148us;1us;1149us;3us;1150us;1152us;1153us;1us;1151us;2us;1152us;1153us;1us;1152us;1us;1153us;1us;1154us;1us;1155us;1us;1156us;1us;1157us;1us;1158us;1us;1159us;2us;1160us;1161us;1us;1161us;1us;1162us;1us;1162us;2us;1164us;1166us;2us;1165us;1167us;1us;1166us;1us;1167us;1us;1168us;1us;1169us;1us;1170us;1us;1171us;1us;1172us;1us;1173us;1us;1175us;1us;1177us;1us;1179us;1us;1181us;1us;1183us;1us;1185us;1us;1187us;1us;1189us;1us;1190us;1us;1191us;1us;1192us;1us;1193us;1us;1194us;1us;1195us;1us;1196us;1us;1197us;1us;1198us;1us;1199us;1us;1200us;1us;1202us;1us;1202us;1us;1203us;2us;1204us;1205us;1us;1204us;1us;1204us;1us;1205us;2us;1206us;1208us;1us;1206us;1us;1206us;1us;1207us;1us;1208us;1us;1209us;1us;1210us;1us;1212us;1us;1214us;2us;1214us;1235us;1us;1214us;1us;1215us;1us;1216us;1us;1217us;2us;1217us;1236us;1us;1217us;1us;1218us;1us;1219us;1us;1220us;1us;1220us;1us;1221us;1us;1222us;1us;1223us;1us;1224us;1us;1224us;1us;1225us;1us;1226us;1us;1227us;1us;1227us;1us;1228us;1us;1229us;1us;1230us;1us;1231us;1us;1232us;1us;1233us;1us;1234us;1us;1235us;1us;1236us;1us;1237us;1us;1238us;1us;1239us;1us;1240us;|]
let _fsyacc_stateToProdIdxsTableRowOffsets = [|0us;2us;4us;6us;8us;10us;12us;14us;16us;18us;20us;22us;24us;26us;28us;30us;32us;35us;37us;40us;42us;45us;47us;49us;51us;53us;55us;57us;59us;62us;64us;73us;82us;137us;139us;142us;144us;146us;148us;150us;152us;155us;157us;159us;161us;164us;166us;168us;171us;173us;175us;177us;181us;183us;187us;191us;195us;199us;203us;205us;207us;210us;213us;217us;219us;222us;224us;227us;229us;231us;233us;235us;243us;251us;256us;258us;260us;262us;266us;269us;271us;273us;275us;279us;281us;283us;286us;290us;293us;296us;298us;300us;302us;304us;306us;308us;315us;322us;326us;329us;331us;333us;335us;337us;339us;341us;343us;345us;347us;349us;351us;353us;355us;357us;359us;361us;363us;365us;368us;423us;425us;480us;482us;484us;488us;490us;492us;494us;496us;498us;500us;502us;504us;506us;508us;510us;512us;515us;517us;519us;521us;525us;527us;529us;531us;533us;535us;537us;539us;541us;543us;545us;547us;549us;551us;553us;557us;560us;562us;564us;566us;568us;571us;574us;576us;578us;581us;584us;586us;588us;591us;594us;596us;598us;600us;602us;604us;606us;608us;617us;631us;640us;654us;656us;658us;660us;662us;664us;666us;668us;670us;672us;674us;679us;682us;687us;689us;691us;693us;700us;702us;704us;706us;708us;710us;712us;714us;716us;718us;721us;724us;726us;728us;732us;736us;739us;741us;743us;745us;747us;749us;751us;753us;755us;757us;759us;761us;763us;765us;768us;770us;772us;774us;777us;779us;782us;784us;787us;789us;791us;793us;795us;808us;820us;824us;826us;828us;832us;835us;837us;839us;841us;844us;846us;848us;850us;862us;873us;930us;933us;935us;937us;939us;944us;946us;949us;951us;953us;956us;959us;962us;964us;966us;968us;970us;978us;986us;988us;992us;994us;1000us;1002us;1004us;1006us;1008us;1010us;1013us;1015us;1017us;1019us;1022us;1024us;1026us;1031us;1035us;1037us;1040us;1045us;1047us;1051us;1053us;1057us;1063us;1066us;1068us;1070us;1073us;1075us;1077us;1079us;1081us;1085us;1089us;1092us;1094us;1096us;1098us;1100us;1102us;1104us;1106us;1109us;1111us;1116us;1120us;1123us;1125us;1127us;1130us;1132us;1134us;1136us;1138us;1140us;1143us;1145us;1149us;1151us;1153us;1156us;1160us;1162us;1164us;1166us;1170us;1172us;1174us;1176us;1178us;1180us;1182us;1184us;1187us;1189us;1191us;1193us;1201us;1203us;1205us;1207us;1209us;1211us;1213us;1215us;1217us;1219us;1221us;1226us;1228us;1231us;1234us;1237us;1240us;1243us;1245us;1247us;1249us;1255us;1258us;1261us;1264us;1267us;1269us;1271us;1273us;1275us;1277us;1279us;1281us;1283us;1285us;1287us;1289us;1291us;1295us;1298us;1300us;1302us;1305us;1307us;1310us;1313us;1315us;1317us;1320us;1323us;1325us;1327us;1329us;1331us;1333us;1335us;1337us;1339us;1341us;1343us;1345us;1348us;1351us;1353us;1355us;1358us;1360us;1362us;1364us;1366us;1368us;1370us;1372us;1374us;1379us;1384us;1389us;1391us;1393us;1395us;1397us;1399us;1402us;1404us;1407us;1409us;1426us;1448us;1465us;1487us;1489us;1491us;1495us;1497us;1499us;1501us;1504us;1509us;1511us;1513us;1515us;1517us;1519us;1521us;1523us;1525us;1527us;1529us;1531us;1533us;1535us;1537us;1539us;1541us;1543us;1545us;1550us;1554us;1558us;1560us;1562us;1564us;1566us;1568us;1570us;1572us;1574us;1576us;1581us;1586us;1591us;1595us;1598us;1600us;1602us;1604us;1606us;1611us;1616us;1621us;1625us;1629us;1631us;1633us;1635us;1637us;1639us;1641us;1644us;1646us;1648us;1651us;1653us;1655us;1657us;1659us;1661us;1663us;1666us;1668us;1670us;1672us;1674us;1676us;1678us;1680us;1682us;1685us;1687us;1689us;1691us;1693us;1695us;1699us;1702us;1704us;1706us;1708us;1710us;1712us;1714us;1717us;1719us;1721us;1723us;1726us;1728us;1730us;1733us;1736us;1738us;1740us;1742us;1745us;1748us;1750us;1755us;1761us;1765us;1767us;1769us;1771us;1773us;1775us;1777us;1779us;1781us;1783us;1785us;1787us;1789us;1795us;1801us;1806us;1808us;1810us;1812us;1814us;1816us;1818us;1830us;1833us;1836us;1838us;1840us;1845us;1848us;1850us;1852us;1854us;1856us;1858us;1865us;1867us;1869us;1873us;1876us;1878us;1880us;1882us;1884us;1886us;1888us;1890us;1892us;1894us;1899us;1904us;1906us;1910us;1912us;1914us;1916us;1918us;1921us;1923us;1926us;1930us;1932us;1935us;1937us;1939us;1942us;1945us;1947us;1951us;1953us;1955us;1957us;1959us;1961us;1963us;1965us;1967us;1969us;1971us;1973us;1975us;1979us;1981us;1984us;1987us;1990us;1992us;1994us;1996us;2000us;2004us;2007us;2010us;2014us;2017us;2021us;2023us;2025us;2027us;2029us;2042us;2045us;2048us;2057us;2059us;2064us;2066us;2068us;2070us;2072us;2074us;2076us;2082us;2085us;2087us;2089us;2091us;2093us;2095us;2097us;2099us;2101us;2106us;2108us;2113us;2120us;2122us;2124us;2126us;2128us;2130us;2133us;2135us;2138us;2140us;2142us;2153us;2164us;2172us;2174us;2177us;2179us;2181us;2184us;2186us;2188us;2190us;2192us;2194us;2197us;2204us;2206us;2208us;2215us;2217us;2219us;2221us;2223us;2225us;2235us;2237us;2242us;2250us;2253us;2256us;2259us;2261us;2264us;2266us;2268us;2270us;2272us;2274us;2276us;2278us;2282us;2285us;2287us;2289us;2291us;2293us;2298us;2302us;2304us;2306us;2308us;2310us;2312us;2314us;2316us;2319us;2322us;2324us;2326us;2328us;2330us;2335us;2340us;2344us;2347us;2349us;2351us;2353us;2355us;2357us;2359us;2362us;2365us;2368us;2370us;2372us;2374us;2378us;2381us;2383us;2385us;2387us;2391us;2393us;2395us;2397us;2399us;2401us;2403us;2405us;2407us;2409us;2411us;2414us;2416us;2418us;2420us;2422us;2424us;2426us;2428us;2430us;2432us;2434us;2436us;2438us;2440us;2442us;2444us;2446us;2448us;2451us;2454us;2456us;2458us;2460us;2462us;2465us;2472us;2474us;2478us;2484us;2486us;2488us;2490us;2492us;2494us;2496us;2498us;2500us;2503us;2505us;2508us;2510us;2512us;2514us;2516us;2518us;2520us;2522us;2524us;2528us;2532us;2536us;2540us;2543us;2545us;2547us;2549us;2552us;2555us;2557us;2559us;2561us;2563us;2566us;2568us;2570us;2573us;2575us;2577us;2579us;2581us;2583us;2586us;2588us;2590us;2592us;2594us;2596us;2598us;2600us;2602us;2604us;2606us;2608us;2610us;2612us;2614us;2616us;2618us;2620us;2622us;2624us;2626us;2628us;2631us;2633us;2635us;2638us;2641us;2643us;2645us;2647us;2649us;2651us;2653us;2655us;2657us;2659us;2662us;2664us;2666us;2678us;2680us;2683us;2697us;2699us;2701us;2703us;2706us;2709us;2711us;2723us;2735us;2747us;2759us;2771us;2783us;2795us;2807us;2819us;2831us;2844us;2848us;2850us;2852us;2854us;2858us;2860us;2864us;2867us;2869us;2872us;2875us;2877us;2879us;2882us;2884us;2886us;2888us;2892us;2894us;2898us;2900us;2902us;2904us;2908us;2915us;2918us;2932us;2934us;2936us;2945us;2950us;2952us;2954us;2956us;2958us;2960us;2962us;2964us;2966us;2968us;2970us;2974us;2976us;2978us;2980us;2990us;2992us;2994us;2996us;3001us;3003us;3005us;3007us;3009us;3011us;3013us;3016us;3018us;3020us;3022us;3024us;3026us;3028us;3030us;3032us;3034us;3036us;3038us;3041us;3043us;3045us;3047us;3049us;3051us;3053us;3062us;3065us;3067us;3069us;3073us;3076us;3078us;3083us;3088us;3094us;3096us;3098us;3101us;3103us;3105us;3119us;3133us;3147us;3161us;3175us;3189us;3203us;3217us;3230us;3244us;3258us;3273us;3292us;3306us;3310us;3312us;3314us;3316us;3320us;3323us;3326us;3328us;3330us;3332us;3336us;3338us;3340us;3343us;3346us;3348us;3350us;3353us;3355us;3357us;3359us;3362us;3364us;3367us;3369us;3375us;3378us;3380us;3382us;3384us;3387us;3389us;3393us;3396us;3398us;3400us;3402us;3404us;3407us;3409us;3411us;3413us;3468us;3471us;3473us;3475us;3478us;3482us;3485us;3487us;3489us;3491us;3493us;3552us;3555us;3557us;3559us;3561us;3563us;3565us;3567us;3569us;3575us;3577us;3580us;3583us;3586us;3589us;3592us;3595us;3598us;3601us;3604us;3607us;3610us;3613us;3617us;3620us;3623us;3625us;3627us;3629us;3631us;3633us;3635us;3637us;3639us;3641us;3643us;3645us;3647us;3650us;3653us;3655us;3657us;3662us;3664us;3666us;3669us;3671us;3673us;3675us;3677us;3679us;3682us;3685us;3687us;3689us;3692us;3695us;3697us;3699us;3705us;3709us;3711us;3713us;3716us;3718us;3720us;3722us;3726us;3782us;3784us;3786us;3788us;3790us;3845us;3848us;3903us;3905us;3907us;3910us;3912us;3914us;3916us;3918us;3920us;3936us;3943us;3948us;3951us;3953us;3955us;3957us;3959us;3961us;3963us;3965us;3971us;3976us;3979us;3981us;3983us;3985us;3987us;3989us;3991us;3993us;3995us;3997us;3999us;4002us;4005us;4060us;4063us;4118us;4120us;4122us;4124us;4126us;4128us;4130us;4132us;4134us;4136us;4139us;4142us;4145us;4148us;4151us;4153us;4155us;4157us;4159us;4161us;4163us;4165us;4167us;4169us;4171us;4173us;4175us;4230us;4232us;4234us;4289us;4344us;4399us;4454us;4509us;4564us;4619us;4674us;4729us;4784us;4839us;4894us;4949us;5004us;5059us;5114us;5169us;5224us;5279us;5334us;5389us;5444us;5499us;5557us;5612us;5667us;5722us;5778us;5833us;5888us;5943us;5997us;6052us;6107us;6162us;6217us;6272us;6328us;6331us;6333us;6335us;6338us;6340us;6342us;6345us;6347us;6349us;6351us;6354us;6356us;6358us;6364us;6372us;6375us;6377us;6380us;6382us;6385us;6387us;6390us;6392us;6395us;6397us;6400us;6402us;6405us;6407us;6410us;6412us;6415us;6417us;6420us;6422us;6425us;6427us;6430us;6432us;6435us;6437us;6440us;6442us;6445us;6447us;6450us;6452us;6455us;6457us;6460us;6462us;6465us;6467us;6470us;6472us;6475us;6477us;6481us;6484us;6486us;6489us;6493us;6496us;6498us;6500us;6502us;6504us;6506us;6508us;6510us;6512us;6514us;6516us;6518us;6520us;6522us;6526us;6529us;6531us;6533us;6535us;6537us;6540us;6542us;6544us;6546us;6548us;6550us;6552us;6560us;6566us;6569us;6571us;6573us;6575us;6577us;6579us;6581us;6583us;6585us;6587us;6589us;6591us;6593us;6595us;6598us;6600us;6603us;6605us;6607us;6609us;6611us;6613us;6616us;6618us;6620us;6625us;6627us;6630us;6632us;6637us;6639us;6642us;6644us;6646us;6649us;6653us;6656us;6658us;6660us;6663us;6665us;6667us;6670us;6672us;6674us;6677us;6679us;6681us;6684us;6686us;6688us;6691us;6693us;6695us;6698us;6700us;6705us;6714us;6718us;6726us;6730us;6736us;6739us;6744us;6746us;6748us;6750us;6752us;6754us;6756us;6758us;6760us;6763us;6772us;6780us;6782us;6789us;6791us;6798us;6805us;6809us;6816us;6819us;6826us;6828us;6830us;6837us;6844us;6851us;6858us;6860us;6862us;6864us;6866us;6868us;6871us;6873us;6876us;6878us;6881us;6883us;6885us;6887us;6889us;6891us;6893us;6895us;6898us;6900us;6902us;6904us;6906us;6908us;6913us;6916us;6918us;6920us;6922us;6924us;6928us;6931us;6933us;6935us;6937us;6939us;6941us;6943us;6950us;6952us;6954us;6956us;6958us;6960us;6962us;6967us;6970us;6972us;6974us;6976us;6978us;6980us;6982us;6984us;6986us;6988us;6990us;6992us;6994us;6996us;6998us;7000us;7005us;7008us;7010us;7012us;7014us;7016us;7018us;7023us;7029us;7032us;7034us;7036us;7038us;7040us;7045us;7048us;7050us;7052us;7054us;7056us;7067us;7083us;7098us;7100us;7103us;7105us;7107us;7109us;7112us;7114us;7116us;7118us;7120us;7122us;7124us;7126us;7128us;7130us;7132us;7134us;7136us;7138us;7140us;7142us;7144us;7147us;7150us;7152us;7154us;7156us;7162us;7165us;7167us;7169us;7171us;7173us;7175us;7177us;7179us;7181us;7183us;7185us;7187us;7189us;7191us;7194us;7196us;7198us;7200us;7202us;7204us;7206us;7208us;7210us;7212us;7215us;7217us;7219us;7221us;7223us;7225us;7227us;7229us;7231us;7234us;7236us;7242us;7244us;7246us;7248us;7250us;7252us;7255us;7257us;7259us;7262us;7264us;7267us;7269us;7271us;7274us;7276us;7279us;7281us;7283us;7285us;7288us;7290us;7293us;7295us;7297us;7299us;7302us;7304us;7306us;7308us;7311us;7314us;7317us;7319us;7321us;7325us;7327us;7329us;7335us;7339us;7341us;7343us;7345us;7348us;7350us;7352us;7354us;7356us;7358us;7360us;7362us;7365us;7367us;7369us;7371us;7373us;7375us;7377us;7379us;7381us;7383us;7385us;7387us;7389us;7391us;7396us;7398us;7400us;7402us;7404us;7406us;7408us;7414us;7417us;7419us;7421us;7423us;7425us;7427us;7430us;7433us;7436us;7438us;7440us;7447us;7453us;7458us;7461us;7463us;7465us;7467us;7469us;7471us;7473us;7475us;7477us;7479us;7481us;7483us;7485us;7487us;7490us;7492us;7495us;7497us;7500us;7502us;7504us;7508us;7511us;7513us;7515us;7519us;7522us;7524us;7526us;7528us;7530us;7534us;7537us;7539us;7541us;7543us;7545us;7551us;7555us;7558us;7560us;7562us;7565us;7568us;7571us;7573us;7575us;7579us;7582us;7584us;7586us;7589us;7592us;7595us;7597us;7599us;7608us;7617us;7625us;7630us;7632us;7634us;7636us;7638us;7643us;7647us;7649us;7651us;7653us;7655us;7657us;7659us;7665us;7672us;7675us;7677us;7679us;7681us;7684us;7686us;7689us;7693us;7695us;7697us;7700us;7702us;7704us;7710us;7713us;7715us;7717us;7719us;7721us;7724us;7726us;7728us;7730us;7732us;7736us;7738us;7741us;7743us;7747us;7749us;7752us;7757us;7759us;7761us;7767us;7769us;7771us;7777us;7779us;7781us;7783us;7785us;7787us;7792us;7794us;7796us;7798us;7800us;7802us;7804us;7806us;7809us;7811us;7813us;7846us;7848us;7880us;7882us;7913us;7915us;7945us;7947us;7976us;7978us;8006us;8008us;8035us;8037us;8063us;8065us;8090us;8092us;8116us;8118us;8141us;8143us;8165us;8167us;8188us;8190us;8210us;8212us;8231us;8233us;8251us;8253us;8270us;8272us;8288us;8290us;8305us;8307us;8321us;8323us;8336us;8338us;8350us;8352us;8363us;8365us;8375us;8377us;8386us;8388us;8396us;8398us;8405us;8407us;8413us;8415us;8420us;8422us;8426us;8428us;8431us;8433us;8435us;8437us;8439us;8441us;8443us;8447us;8452us;8455us;8457us;8459us;8462us;8464us;8466us;8471us;8473us;8475us;8477us;8481us;8485us;8487us;8489us;8491us;8493us;8497us;8500us;8506us;8508us;8510us;8516us;8522us;8527us;8531us;8534us;8536us;8538us;8540us;8542us;8544us;8546us;8548us;8550us;8552us;8554us;8556us;8559us;8561us;8564us;8566us;8569us;8574us;8576us;8578us;8580us;8582us;8584us;8586us;8594us;8598us;8602us;8605us;8607us;8609us;8611us;8615us;8617us;8619us;8621us;8623us;8627us;8630us;8632us;8634us;8636us;8639us;8643us;8645us;8647us;8649us;8653us;8655us;8657us;8661us;8663us;8666us;8668us;8670us;8672us;8675us;8677us;8679us;8683us;8687us;8691us;8693us;8695us;8697us;8699us;8701us;8703us;8706us;8708us;8711us;8713us;8715us;8717us;8720us;8722us;8724us;8729us;8731us;8733us;8735us;8737us;8739us;8743us;8747us;8749us;8751us;8753us;8755us;8757us;8759us;8761us;8763us;8765us;8767us;8769us;8771us;8773us;8775us;8777us;8779us;8781us;8783us;8785us;8787us;8789us;8791us;8793us;8795us;8797us;8799us;8801us;8804us;8806us;8808us;8810us;8812us;8814us;8816us;8818us;8820us;8822us;8826us;8828us;8831us;8833us;8835us;8837us;8839us;8841us;8843us;8845us;8847us;8850us;8852us;8854us;8856us;8859us;8862us;8864us;8866us;8868us;8870us;8872us;8874us;8876us;8878us;8880us;8882us;8884us;8886us;8888us;8890us;8892us;8894us;8896us;8898us;8900us;8902us;8904us;8906us;8908us;8910us;8912us;8914us;8916us;8918us;8920us;8922us;8925us;8927us;8929us;8931us;8934us;8936us;8938us;8940us;8942us;8944us;8946us;8948us;8950us;8953us;8955us;8957us;8959us;8961us;8964us;8966us;8968us;8970us;8972us;8974us;8976us;8978us;8980us;8982us;8984us;8986us;8988us;8990us;8992us;8994us;8996us;8998us;9000us;9002us;9004us;9006us;9008us;9010us;9012us;9014us;9016us;|]
let _fsyacc_action_rows = 2099
let _fsyacc_actionTableElements = [|16us;16438us;22us;77us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;44us;16556us;45us;16556us;46us;16556us;74us;322us;89us;38us;102us;292us;109us;16556us;110us;16556us;122us;16556us;151us;16556us;204us;51us;0us;49152us;95us;16516us;13us;16556us;22us;246us;24us;16556us;25us;16556us;29us;16556us;30us;16556us;32us;16556us;33us;16556us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;42us;16556us;44us;16556us;45us;16556us;46us;16556us;47us;16556us;57us;16556us;63us;16556us;67us;16556us;71us;16556us;72us;16556us;73us;16556us;74us;322us;75us;16556us;86us;16556us;87us;16556us;89us;38us;90us;16556us;91us;16556us;92us;16556us;93us;16556us;97us;16556us;99us;16556us;101us;16556us;102us;292us;107us;16556us;108us;16556us;109us;16556us;115us;16556us;116us;16556us;117us;16556us;118us;16556us;120us;16556us;122us;16556us;123us;16556us;124us;16556us;125us;16556us;126us;16556us;127us;16556us;131us;16556us;134us;16556us;135us;16556us;137us;16556us;138us;16556us;144us;16556us;147us;16556us;148us;16556us;149us;16556us;150us;16556us;151us;16556us;155us;16556us;156us;16556us;159us;16556us;160us;16556us;163us;16556us;164us;16556us;165us;16556us;167us;16556us;168us;16556us;169us;16556us;170us;16556us;171us;16556us;172us;16556us;173us;16556us;174us;16556us;175us;16556us;176us;16556us;177us;16556us;178us;16556us;179us;16556us;181us;16556us;182us;16556us;184us;16556us;185us;16556us;188us;16556us;190us;16556us;194us;16556us;195us;16556us;196us;16556us;200us;16556us;201us;16556us;202us;16556us;203us;16556us;204us;232us;0us;49152us;7us;16556us;10us;14us;21us;12us;68us;13us;74us;322us;84us;11us;89us;38us;102us;292us;0us;49152us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;49152us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;49152us;0us;16389us;0us;16390us;0us;16391us;0us;16392us;0us;16393us;0us;16394us;4us;32768us;10us;14us;21us;37us;68us;13us;84us;36us;0us;16395us;4us;32768us;10us;14us;21us;37us;68us;13us;84us;36us;0us;16396us;4us;32768us;10us;14us;21us;37us;68us;13us;84us;36us;0us;16397us;5us;16556us;10us;14us;68us;13us;74us;322us;89us;38us;102us;292us;0us;16398us;5us;16556us;10us;14us;68us;13us;74us;322us;89us;38us;102us;292us;0us;16399us;5us;16556us;10us;14us;68us;13us;74us;322us;89us;38us;102us;292us;0us;16400us;16us;16401us;33us;16556us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;42us;16556us;44us;16556us;45us;16556us;46us;16556us;74us;322us;102us;292us;109us;16556us;122us;16556us;138us;16556us;151us;16556us;163us;16556us;0us;16402us;3us;16650us;44us;520us;45us;519us;46us;521us;87us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2065us;38us;2068us;39us;2070us;40us;2073us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;109us;2069us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;122us;758us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;138us;774us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;151us;2074us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;26us;16403us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;0us;16404us;2us;16405us;21us;37us;84us;36us;0us;16406us;0us;16407us;0us;16408us;1us;32768us;194us;39us;0us;16410us;6us;16409us;93us;1961us;101us;1966us;179us;43us;194us;44us;195us;2049us;202us;2048us;0us;16411us;0us;16412us;0us;16413us;1us;16414us;77us;17493us;0us;16415us;0us;16416us;2us;32768us;10us;48us;204us;49us;0us;16417us;1us;32768us;10us;50us;0us;16418us;4us;16437us;10us;52us;21us;2016us;68us;2015us;84us;2014us;0us;16419us;1us;16556us;74us;322us;3us;16650us;44us;520us;45us;519us;46us;521us;1us;17568us;104us;2035us;5us;32768us;10us;1094us;21us;58us;47us;1956us;194us;1955us;204us;1078us;1us;16420us;77us;1958us;0us;16421us;0us;16422us;1us;17568us;104us;2035us;4us;32768us;10us;1094us;47us;1956us;194us;1955us;204us;1078us;1us;16423us;77us;1958us;0us;16424us;1us;16425us;152us;60us;0us;16426us;1us;16428us;152us;60us;0us;16427us;1us;17562us;70us;2032us;16us;16438us;22us;77us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;44us;16556us;45us;16556us;46us;16556us;74us;322us;89us;38us;102us;292us;109us;16556us;110us;16556us;122us;16556us;151us;16556us;204us;85us;0us;16429us;3us;16650us;44us;520us;45us;519us;46us;521us;8us;32768us;37us;2065us;38us;2068us;39us;2070us;40us;2073us;109us;2069us;110us;107us;122us;758us;151us;2074us;18us;16438us;22us;77us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;44us;16556us;45us;16556us;46us;16556us;70us;2047us;74us;322us;78us;2046us;89us;38us;102us;292us;109us;16556us;110us;16556us;122us;16556us;151us;16556us;204us;86us;0us;16430us;0us;16431us;0us;16432us;15us;16438us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;44us;16556us;45us;16556us;46us;16556us;74us;322us;89us;38us;102us;292us;109us;16556us;110us;16556us;122us;16556us;151us;16556us;204us;82us;5us;32768us;10us;1094us;15us;2084us;16us;2086us;17us;2087us;204us;1078us;1us;17564us;21us;2033us;0us;16433us;0us;16434us;6us;16437us;15us;2084us;16us;2086us;17us;2087us;21us;2016us;68us;2015us;84us;2014us;0us;16435us;0us;16436us;3us;16437us;21us;2016us;68us;2015us;84us;2014us;17us;16437us;21us;2016us;37us;16446us;38us;16446us;39us;16446us;40us;16446us;44us;16446us;45us;16446us;46us;16446us;68us;2015us;74us;16446us;84us;2014us;89us;16446us;102us;16446us;109us;16446us;110us;16446us;122us;16446us;151us;16446us;3us;17547us;21us;2016us;68us;2015us;84us;2014us;15us;16441us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;44us;16556us;45us;16556us;46us;16556us;74us;322us;89us;38us;102us;292us;109us;16556us;110us;16556us;122us;16556us;151us;16556us;204us;90us;0us;16439us;3us;32768us;21us;2016us;68us;2015us;84us;2014us;4us;16556us;74us;322us;89us;38us;102us;292us;204us;90us;0us;16440us;0us;16442us;0us;16443us;3us;16650us;44us;520us;45us;519us;46us;521us;8us;32768us;37us;2065us;38us;2068us;39us;2070us;40us;2073us;109us;2069us;110us;107us;122us;758us;151us;2074us;3us;32768us;70us;2047us;78us;2046us;204us;101us;5us;32768us;22us;123us;47us;1956us;58us;2044us;137us;2045us;194us;1955us;0us;16444us;0us;16445us;0us;16446us;1us;16556us;74us;322us;1us;16458us;132us;133us;0us;16447us;0us;16448us;0us;16449us;1us;16556us;74us;322us;1us;17570us;111us;2036us;1us;17572us;119us;2037us;3us;16650us;44us;520us;45us;519us;46us;521us;3us;32768us;93us;1961us;101us;1966us;194us;1955us;2us;16718us;34us;2064us;161us;17597us;1us;32768us;78us;114us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1692us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;1us;16451us;70us;117us;0us;16450us;80us;32768us;13us;1206us;22us;119us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;26us;16452us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;29us;32768us;15us;2084us;16us;2086us;17us;2087us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;1us;17560us;19us;2031us;0us;16453us;8us;16556us;47us;1956us;58us;2044us;74us;322us;89us;38us;102us;292us;137us;2045us;194us;1955us;204us;90us;3us;32768us;15us;2084us;16us;2086us;17us;2087us;0us;16454us;15us;16438us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;44us;16556us;45us;16556us;46us;16556us;74us;322us;89us;38us;102us;292us;109us;16556us;110us;16556us;122us;16556us;151us;16556us;204us;85us;1us;32768us;143us;128us;3us;32768us;15us;2084us;16us;2086us;17us;2087us;0us;16455us;15us;16438us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;44us;16556us;45us;16556us;46us;16556us;74us;322us;89us;38us;102us;292us;109us;16556us;110us;16556us;122us;16556us;151us;16556us;204us;85us;1us;32768us;143us;132us;0us;16456us;1us;16556us;74us;322us;1us;16458us;132us;133us;0us;16457us;2us;16500us;70us;137us;88us;225us;7us;16556us;22us;140us;50us;596us;57us;598us;74us;322us;112us;597us;137us;165us;153us;151us;0us;16459us;0us;16460us;55us;16478us;14us;16556us;22us;161us;44us;16556us;45us;16556us;46us;16556us;47us;16556us;48us;16556us;49us;16556us;50us;596us;51us;16556us;52us;16556us;53us;16556us;55us;16556us;57us;598us;59us;16556us;67us;16556us;73us;16556us;74us;322us;89us;16556us;92us;16556us;93us;16556us;97us;16556us;101us;16556us;107us;16556us;110us;16556us;112us;597us;114us;16556us;120us;16556us;121us;16556us;123us;16556us;137us;165us;149us;16556us;153us;151us;167us;16556us;168us;16556us;169us;16556us;170us;16556us;171us;16556us;172us;16556us;173us;16556us;174us;16556us;175us;16556us;176us;16556us;177us;16556us;178us;16556us;179us;16556us;181us;16556us;182us;16556us;187us;16556us;190us;16556us;194us;16556us;195us;16556us;196us;16556us;202us;16556us;203us;16556us;1us;17564us;21us;2033us;14us;16478us;14us;16556us;44us;16556us;45us;16556us;46us;16556us;48us;16556us;49us;16556us;51us;16556us;52us;16556us;53us;16556us;55us;16556us;74us;322us;110us;16556us;112us;16556us;120us;16556us;1us;16500us;88us;225us;3us;32768us;15us;2084us;16us;2086us;17us;2087us;1us;16500us;88us;225us;0us;16461us;1us;16500us;88us;225us;0us;16462us;0us;16463us;0us;16464us;1us;32768us;121us;152us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1692us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;16465us;0us;16466us;16us;16478us;14us;16556us;22us;169us;44us;16556us;45us;16556us;46us;16556us;48us;16556us;49us;16556us;51us;16556us;52us;16556us;53us;16556us;55us;16556us;74us;322us;110us;16556us;112us;16556us;120us;16556us;204us;159us;3us;32768us;10us;1094us;143us;157us;204us;1078us;0us;16467us;0us;16468us;1us;32768us;143us;160us;0us;16469us;14us;16478us;14us;16556us;44us;16556us;45us;16556us;46us;16556us;48us;16556us;49us;16556us;51us;16556us;52us;16556us;53us;16556us;55us;16556us;74us;322us;110us;16556us;112us;16556us;120us;16556us;5us;32768us;10us;1094us;15us;2084us;16us;2086us;17us;2087us;204us;1078us;0us;16470us;0us;16471us;15us;16478us;14us;16556us;22us;169us;44us;16556us;45us;16556us;46us;16556us;48us;16556us;49us;16556us;51us;16556us;52us;16556us;53us;16556us;55us;16556us;74us;322us;110us;16556us;112us;16556us;120us;16556us;3us;32768us;10us;1094us;143us;167us;204us;1078us;0us;16472us;0us;16473us;14us;16478us;14us;16556us;44us;16556us;45us;16556us;46us;16556us;48us;16556us;49us;16556us;51us;16556us;52us;16556us;53us;16556us;55us;16556us;74us;322us;110us;16556us;112us;16556us;120us;16556us;5us;32768us;10us;1094us;15us;2084us;16us;2086us;17us;2087us;204us;1078us;0us;16474us;0us;16475us;0us;16476us;0us;16477us;2us;17566us;21us;2021us;84us;2022us;14us;16478us;14us;16556us;44us;16556us;45us;16556us;46us;16556us;48us;16556us;49us;16556us;51us;16556us;52us;16556us;53us;16556us;55us;16556us;74us;322us;110us;16556us;112us;16556us;120us;16556us;0us;16479us;3us;16650us;44us;520us;45us;519us;46us;521us;3us;16650us;44us;520us;45us;519us;46us;521us;10us;32768us;14us;600us;48us;198us;49us;357us;51us;437us;52us;358us;53us;359us;55us;193us;110us;196us;112us;599us;120us;203us;47us;32768us;14us;600us;47us;1956us;48us;198us;49us;357us;51us;437us;52us;358us;53us;359us;55us;193us;57us;587us;59us;684us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;575us;97us;1740us;101us;1966us;107us;1895us;110us;196us;112us;599us;114us;1893us;120us;203us;121us;725us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;196us;580us;202us;2048us;203us;872us;1us;17570us;111us;2036us;3us;16650us;44us;520us;45us;519us;46us;521us;3us;32768us;93us;1961us;101us;1966us;194us;1955us;2us;16718us;34us;2064us;161us;17597us;1us;32768us;78us;187us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1692us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;2us;16488us;26us;208us;88us;206us;1us;16451us;70us;117us;0us;16480us;31us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;6us;16481us;36us;1777us;47us;1956us;71us;1791us;92us;1949us;190us;1951us;194us;1955us;33us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;6us;16482us;36us;1777us;47us;1956us;71us;1791us;92us;1949us;190us;1951us;194us;1955us;0us;16483us;1us;17572us;119us;2037us;0us;16484us;6us;16573us;37us;2065us;38us;2068us;49us;356us;51us;439us;109us;2069us;110us;199us;1us;17572us;119us;2037us;0us;16485us;1us;16556us;74us;322us;0us;16486us;1us;32768us;78us;204us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1692us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;16487us;4us;16650us;22us;218us;44us;520us;45us;519us;46us;521us;0us;16489us;4us;16650us;22us;218us;44us;520us;45us;519us;46us;521us;2us;32768us;20us;210us;204us;211us;0us;16490us;0us;16491us;3us;32768us;93us;1961us;101us;1966us;194us;1955us;1us;16492us;98us;214us;5us;16650us;10us;1094us;44us;520us;45us;519us;46us;521us;204us;1078us;3us;32768us;93us;1961us;101us;1966us;194us;1955us;0us;16493us;0us;16494us;3us;32768us;15us;2084us;16us;2086us;17us;2087us;1us;32768us;19us;220us;0us;16495us;0us;16496us;0us;16497us;1us;16500us;88us;225us;0us;16498us;15us;16478us;14us;16556us;22us;169us;44us;16556us;45us;16556us;46us;16556us;48us;16556us;49us;16556us;51us;16556us;52us;16556us;53us;16556us;55us;16556us;74us;322us;110us;16556us;112us;16556us;120us;16556us;3us;32768us;19us;2025us;20us;2026us;143us;2027us;0us;16499us;2us;32768us;10us;229us;204us;230us;0us;16501us;1us;32768us;10us;231us;0us;16502us;4us;32768us;10us;233us;21us;2016us;68us;2015us;84us;2014us;0us;16503us;1us;16504us;152us;60us;0us;16505us;1us;16507us;152us;60us;0us;16506us;1us;17562us;70us;2032us;95us;16516us;13us;16556us;22us;246us;24us;16556us;25us;16556us;29us;16556us;30us;16556us;32us;16556us;33us;16556us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;42us;16556us;44us;16556us;45us;16556us;46us;16556us;47us;16556us;57us;16556us;63us;16556us;67us;16556us;71us;16556us;72us;16556us;73us;16556us;74us;322us;75us;16556us;86us;16556us;87us;16556us;89us;38us;90us;16556us;91us;16556us;92us;16556us;93us;16556us;97us;16556us;99us;16556us;101us;16556us;102us;292us;107us;16556us;108us;16556us;109us;16556us;115us;16556us;116us;16556us;117us;16556us;118us;16556us;120us;16556us;122us;16556us;123us;16556us;124us;16556us;125us;16556us;126us;16556us;127us;16556us;131us;16556us;134us;16556us;135us;16556us;137us;16556us;138us;16556us;144us;16556us;147us;16556us;148us;16556us;149us;16556us;150us;16556us;151us;16556us;155us;16556us;156us;16556us;159us;16556us;160us;16556us;163us;16556us;164us;16556us;165us;16556us;167us;16556us;168us;16556us;169us;16556us;170us;16556us;171us;16556us;172us;16556us;173us;16556us;174us;16556us;175us;16556us;176us;16556us;177us;16556us;178us;16556us;179us;16556us;181us;16556us;182us;16556us;184us;16556us;185us;16556us;188us;16556us;190us;16556us;194us;16556us;195us;16556us;196us;16556us;200us;16556us;201us;16556us;202us;16556us;203us;16556us;204us;266us;0us;16508us;4us;16650us;44us;520us;45us;519us;46us;521us;204us;261us;87us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2065us;38us;2068us;39us;2070us;40us;2073us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;109us;2069us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;122us;758us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;138us;774us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;151us;2074us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;96us;16516us;13us;16556us;22us;246us;24us;16556us;25us;16556us;29us;16556us;30us;16556us;32us;16556us;33us;16556us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;42us;16556us;44us;16556us;45us;16556us;46us;16556us;47us;16556us;57us;16556us;63us;16556us;67us;16556us;70us;286us;71us;16556us;72us;16556us;73us;16556us;74us;322us;75us;16556us;86us;16556us;87us;16556us;89us;38us;90us;16556us;91us;16556us;92us;16556us;93us;16556us;97us;16556us;99us;16556us;101us;16556us;102us;292us;107us;16556us;108us;16556us;109us;16556us;115us;16556us;116us;16556us;117us;16556us;118us;16556us;120us;16556us;122us;16556us;123us;16556us;124us;16556us;125us;16556us;126us;16556us;127us;16556us;131us;16556us;134us;16556us;135us;16556us;137us;16556us;138us;16556us;144us;16556us;147us;16556us;148us;16556us;149us;16556us;150us;16556us;151us;16556us;155us;16556us;156us;16556us;159us;16556us;160us;16556us;163us;16556us;164us;16556us;165us;16556us;167us;16556us;168us;16556us;169us;16556us;170us;16556us;171us;16556us;172us;16556us;173us;16556us;174us;16556us;175us;16556us;176us;16556us;177us;16556us;178us;16556us;179us;16556us;181us;16556us;182us;16556us;184us;16556us;185us;16556us;188us;16556us;190us;16556us;194us;16556us;195us;16556us;196us;16556us;200us;16556us;201us;16556us;202us;16556us;203us;16556us;204us;267us;0us;16509us;0us;16510us;94us;16516us;13us;16556us;24us;16556us;25us;16556us;29us;16556us;30us;16556us;32us;16556us;33us;16556us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;42us;16556us;44us;16556us;45us;16556us;46us;16556us;47us;16556us;57us;16556us;63us;16556us;67us;16556us;71us;16556us;72us;16556us;73us;16556us;74us;322us;75us;16556us;86us;16556us;87us;16556us;89us;38us;90us;16556us;91us;16556us;92us;16556us;93us;16556us;97us;16556us;99us;16556us;101us;16556us;102us;292us;107us;16556us;108us;16556us;109us;16556us;115us;16556us;116us;16556us;117us;16556us;118us;16556us;120us;16556us;122us;16556us;123us;16556us;124us;16556us;125us;16556us;126us;16556us;127us;16556us;131us;16556us;134us;16556us;135us;16556us;137us;16556us;138us;16556us;144us;16556us;147us;16556us;148us;16556us;149us;16556us;150us;16556us;151us;16556us;155us;16556us;156us;16556us;159us;16556us;160us;16556us;163us;16556us;164us;16556us;165us;16556us;167us;16556us;168us;16556us;169us;16556us;170us;16556us;171us;16556us;172us;16556us;173us;16556us;174us;16556us;175us;16556us;176us;16556us;177us;16556us;178us;16556us;179us;16556us;181us;16556us;182us;16556us;184us;16556us;185us;16556us;188us;16556us;190us;16556us;194us;16556us;195us;16556us;196us;16556us;200us;16556us;201us;16556us;202us;16556us;203us;16556us;204us;251us;5us;32768us;10us;1094us;15us;2084us;16us;2086us;17us;2087us;204us;1078us;1us;17564us;21us;2033us;0us;16511us;0us;16512us;6us;32768us;15us;2084us;16us;2086us;17us;2087us;21us;2016us;68us;2015us;84us;2014us;0us;16513us;0us;16514us;0us;16515us;4us;16650us;44us;520us;45us;519us;46us;521us;204us;261us;87us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2065us;38us;2068us;39us;2070us;40us;2073us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;109us;2069us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;122us;758us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;138us;774us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;151us;2074us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;29us;16519us;21us;2016us;63us;1295us;64us;1281us;68us;2015us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;84us;2014us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;94us;16518us;13us;16556us;24us;16556us;25us;16556us;29us;16556us;30us;16556us;32us;16556us;33us;16556us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;42us;16556us;44us;16556us;45us;16556us;46us;16556us;47us;16556us;57us;16556us;63us;16556us;67us;16556us;71us;16556us;72us;16556us;73us;16556us;74us;322us;75us;16556us;86us;16556us;87us;16556us;89us;38us;90us;16556us;91us;16556us;92us;16556us;93us;16556us;97us;16556us;99us;16556us;101us;16556us;102us;292us;107us;16556us;108us;16556us;109us;16556us;115us;16556us;116us;16556us;117us;16556us;118us;16556us;120us;16556us;122us;16556us;123us;16556us;124us;16556us;125us;16556us;126us;16556us;127us;16556us;131us;16556us;134us;16556us;135us;16556us;137us;16556us;138us;16556us;144us;16556us;147us;16556us;148us;16556us;149us;16556us;150us;16556us;151us;16556us;155us;16556us;156us;16556us;159us;16556us;160us;16556us;163us;16556us;164us;16556us;165us;16556us;167us;16556us;168us;16556us;169us;16556us;170us;16556us;171us;16556us;172us;16556us;173us;16556us;174us;16556us;175us;16556us;176us;16556us;177us;16556us;178us;16556us;179us;16556us;181us;16556us;182us;16556us;184us;16556us;185us;16556us;188us;16556us;190us;16556us;194us;16556us;195us;16556us;196us;16556us;200us;16556us;201us;16556us;202us;16556us;203us;16556us;204us;266us;0us;16517us;0us;16520us;0us;16521us;21us;16524us;21us;2016us;33us;16556us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;42us;16556us;44us;16556us;45us;16556us;46us;16556us;68us;2015us;74us;322us;84us;2014us;89us;38us;102us;292us;109us;16556us;122us;16556us;138us;16556us;151us;16556us;163us;16556us;204us;266us;0us;16522us;94us;16525us;13us;16556us;24us;16556us;25us;16556us;29us;16556us;30us;16556us;32us;16556us;33us;16556us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;42us;16556us;44us;16556us;45us;16556us;46us;16556us;47us;16556us;57us;16556us;63us;16556us;67us;16556us;71us;16556us;72us;16556us;73us;16556us;74us;322us;75us;16556us;86us;16556us;87us;16556us;89us;38us;90us;16556us;91us;16556us;92us;16556us;93us;16556us;97us;16556us;99us;16556us;101us;16556us;102us;292us;107us;16556us;108us;16556us;109us;16556us;115us;16556us;116us;16556us;117us;16556us;118us;16556us;120us;16556us;122us;16556us;123us;16556us;124us;16556us;125us;16556us;126us;16556us;127us;16556us;131us;16556us;134us;16556us;135us;16556us;137us;16556us;138us;16556us;144us;16556us;147us;16556us;148us;16556us;149us;16556us;150us;16556us;151us;16556us;155us;16556us;156us;16556us;159us;16556us;160us;16556us;163us;16556us;164us;16556us;165us;16556us;167us;16556us;168us;16556us;169us;16556us;170us;16556us;171us;16556us;172us;16556us;173us;16556us;174us;16556us;175us;16556us;176us;16556us;177us;16556us;178us;16556us;179us;16556us;181us;16556us;182us;16556us;184us;16556us;185us;16556us;188us;16556us;190us;16556us;194us;16556us;195us;16556us;196us;16556us;200us;16556us;201us;16556us;202us;16556us;203us;16556us;204us;266us;0us;16523us;3us;32768us;21us;2016us;68us;2015us;84us;2014us;3us;16535us;21us;2016us;68us;2015us;84us;2014us;6us;32768us;15us;2084us;16us;2086us;17us;2087us;21us;2016us;68us;2015us;84us;2014us;4us;32768us;21us;2016us;68us;2015us;84us;2014us;143us;315us;4us;16556us;74us;322us;89us;38us;102us;292us;204us;266us;0us;16526us;0us;16527us;0us;16528us;3us;16650us;44us;520us;45us;519us;46us;521us;11us;32768us;33us;776us;37us;2065us;38us;2068us;39us;2070us;40us;2073us;42us;790us;109us;2069us;122us;758us;138us;774us;151us;2074us;163us;770us;0us;16529us;1us;16529us;128us;1107us;0us;16530us;80us;16530us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1112us;0us;16531us;1us;16556us;74us;322us;1us;16579us;132us;363us;0us;16532us;0us;16533us;2us;32768us;70us;286us;204us;288us;5us;32768us;22us;301us;47us;1956us;57us;2042us;137us;2043us;194us;1955us;0us;16534us;0us;16535us;2us;16555us;10us;1094us;204us;1078us;0us;16536us;0us;16537us;7us;32768us;10us;1094us;37us;2065us;38us;2068us;47us;1956us;109us;2069us;194us;1955us;204us;1078us;1us;16538us;77us;1958us;0us;16539us;33us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;6us;16540us;36us;1777us;47us;1956us;71us;1791us;92us;1949us;190us;1951us;194us;1955us;0us;16541us;4us;32768us;15us;2084us;16us;2086us;17us;2087us;77us;1958us;0us;16542us;1us;16543us;77us;1958us;6us;16556us;57us;2042us;74us;322us;89us;38us;102us;292us;137us;2043us;204us;268us;5us;32768us;10us;1094us;15us;2084us;16us;2086us;17us;2087us;204us;1078us;0us;16544us;0us;16545us;5us;32768us;10us;1094us;15us;2084us;16us;2086us;17us;2087us;204us;1078us;0us;16546us;0us;16547us;0us;16548us;0us;16549us;1us;16550us;77us;1958us;94us;16516us;13us;16556us;24us;16556us;25us;16556us;29us;16556us;30us;16556us;32us;16556us;33us;16556us;37us;16556us;38us;16556us;39us;16556us;40us;16556us;42us;16556us;44us;16556us;45us;16556us;46us;16556us;47us;16556us;57us;16556us;63us;16556us;67us;16556us;71us;16556us;72us;16556us;73us;16556us;74us;322us;75us;16556us;86us;16556us;87us;16556us;89us;38us;90us;16556us;91us;16556us;92us;16556us;93us;16556us;97us;16556us;99us;16556us;101us;16556us;102us;292us;107us;16556us;108us;16556us;109us;16556us;115us;16556us;116us;16556us;117us;16556us;118us;16556us;120us;16556us;122us;16556us;123us;16556us;124us;16556us;125us;16556us;126us;16556us;127us;16556us;131us;16556us;134us;16556us;135us;16556us;137us;16556us;138us;16556us;144us;16556us;147us;16556us;148us;16556us;149us;16556us;150us;16556us;151us;16556us;155us;16556us;156us;16556us;159us;16556us;160us;16556us;163us;16556us;164us;16556us;165us;16556us;167us;16556us;168us;16556us;169us;16556us;170us;16556us;171us;16556us;172us;16556us;173us;16556us;174us;16556us;175us;16556us;176us;16556us;177us;16556us;178us;16556us;179us;16556us;181us;16556us;182us;16556us;184us;16556us;185us;16556us;188us;16556us;190us;16556us;194us;16556us;195us;16556us;196us;16556us;200us;16556us;201us;16556us;202us;16556us;203us;16556us;204us;269us;3us;32768us;10us;1094us;143us;313us;204us;1078us;0us;16551us;0us;16552us;0us;16553us;6us;16556us;19us;16602us;20us;16602us;22us;403us;74us;322us;143us;16602us;204us;409us;3us;32768us;19us;2025us;20us;2026us;143us;2027us;0us;16554us;0us;16555us;1us;16557us;74us;322us;0us;16558us;14us;32768us;10us;1094us;15us;2097us;37us;2066us;38us;2068us;39us;2071us;40us;2073us;47us;1956us;61us;2095us;95us;2096us;109us;2069us;151us;2074us;164us;353us;194us;1955us;204us;327us;2us;17566us;21us;2021us;84us;2022us;8us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;56us;325us;61us;2095us;95us;2096us;204us;1078us;1us;17564us;21us;2033us;0us;16559us;1us;16991us;56us;328us;1us;17564us;21us;2033us;0us;16560us;0us;16561us;0us;16562us;0us;16563us;9us;17565us;37us;2065us;38us;2068us;39us;2070us;40us;2073us;47us;1956us;109us;2069us;151us;2074us;164us;353us;194us;1955us;0us;16564us;3us;17595us;35us;2063us;36us;2062us;77us;1958us;30us;17264us;57us;1645us;72us;1504us;73us;1648us;93us;1510us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;16565us;3us;32768us;22us;342us;47us;1956us;194us;1955us;3us;17595us;35us;2063us;36us;2062us;77us;1958us;30us;17264us;57us;1645us;72us;1504us;73us;1648us;93us;1510us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;16566us;2us;32768us;47us;1956us;194us;1955us;4us;32768us;15us;2084us;16us;2086us;17us;2087us;77us;1958us;2us;17595us;35us;2063us;36us;2062us;30us;17264us;57us;1645us;72us;1504us;73us;1648us;93us;1510us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;16567us;1us;32768us;78us;348us;0us;16568us;1us;32768us;78us;350us;0us;16569us;1us;17495us;78us;352us;0us;16570us;1us;32768us;78us;354us;0us;16571us;11us;16573us;30us;780us;33us;776us;37us;2065us;38us;2068us;42us;790us;49us;356us;51us;439us;109us;2069us;110us;483us;138us;774us;163us;770us;0us;16572us;0us;16574us;0us;16575us;0us;16576us;3us;16650us;44us;520us;45us;519us;46us;521us;1us;16720us;85us;634us;0us;16577us;1us;16556us;74us;322us;1us;16579us;132us;363us;0us;16578us;39us;16556us;14us;16580us;15us;16580us;16us;16580us;17us;16580us;19us;16580us;20us;16580us;21us;16580us;30us;16580us;33us;16580us;37us;16580us;38us;16580us;39us;16580us;40us;16580us;42us;16580us;48us;16580us;49us;16580us;51us;16580us;52us;16580us;53us;16580us;55us;16580us;61us;16580us;68us;16580us;74us;322us;84us;16580us;88us;316us;89us;16580us;95us;16580us;102us;16580us;109us;16580us;110us;16580us;112us;16580us;120us;16580us;122us;16580us;132us;16580us;138us;16580us;143us;16580us;151us;16580us;152us;16580us;163us;16580us;0us;16581us;3us;16650us;44us;520us;45us;519us;46us;521us;2us;17595us;35us;2063us;36us;2062us;1us;16874us;93us;892us;1us;16664us;133us;536us;3us;32768us;10us;1094us;70us;373us;204us;1078us;6us;16556us;22us;376us;50us;596us;57us;598us;74us;322us;112us;597us;153us;389us;0us;16582us;0us;16583us;9us;16556us;15us;2084us;16us;2086us;17us;2087us;22us;399us;50us;596us;57us;598us;74us;322us;112us;597us;153us;389us;1us;17564us;21us;2033us;7us;16556us;10us;16602us;15us;16602us;16us;16602us;17us;16602us;74us;322us;88us;16602us;204us;409us;1us;16659us;88us;525us;5us;32768us;10us;1094us;15us;2084us;16us;2086us;17us;2087us;204us;1078us;1us;16659us;88us;525us;0us;16584us;0us;16585us;0us;16586us;1us;16659us;88us;525us;0us;16587us;0us;16588us;0us;16589us;1us;32768us;121us;390us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1692us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;16590us;0us;16591us;10us;16556us;10us;16602us;15us;16602us;22us;403us;37us;16602us;39us;16602us;61us;16602us;74us;322us;95us;16602us;143us;16602us;204us;397us;8us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;61us;2095us;95us;2096us;143us;395us;204us;1078us;0us;16592us;0us;16593us;9us;16556us;10us;16602us;15us;16602us;37us;16602us;39us;16602us;61us;16602us;74us;322us;95us;16602us;143us;398us;204us;409us;0us;16594us;1us;16556us;74us;322us;5us;32768us;10us;1094us;15us;2084us;16us;2086us;17us;2087us;204us;1078us;0us;16595us;0us;16596us;6us;16556us;10us;16602us;15us;16602us;16us;16602us;17us;16602us;74us;322us;204us;409us;5us;32768us;10us;1094us;15us;2084us;16us;2086us;17us;2087us;204us;1078us;0us;16597us;0us;16598us;0us;16599us;0us;16600us;14us;16556us;10us;16602us;15us;16602us;16us;16602us;17us;16602us;19us;16602us;20us;16602us;37us;16602us;39us;16602us;61us;16602us;74us;322us;88us;16602us;95us;16602us;143us;16602us;204us;409us;0us;16601us;2us;17566us;21us;2021us;84us;2022us;14us;16556us;10us;16602us;15us;16602us;16us;16602us;17us;16602us;19us;16602us;20us;16602us;37us;16602us;39us;16602us;61us;16602us;74us;322us;88us;16602us;95us;16602us;143us;16602us;204us;409us;0us;16603us;1us;17570us;111us;2036us;0us;16604us;1us;17570us;111us;2036us;2us;32768us;20us;418us;204us;419us;0us;16605us;0us;16606us;1us;16607us;132us;421us;1us;17570us;111us;2036us;0us;16608us;1us;16556us;74us;322us;37us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;1us;17334us;78us;1681us;1us;32768us;70us;427us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;16609us;37us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;1us;17334us;78us;1681us;11us;32768us;10us;1094us;15us;2097us;21us;434us;26us;416us;37us;2093us;39us;2094us;61us;2095us;70us;432us;88us;414us;95us;2096us;204us;1078us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;16610us;0us;16611us;0us;16612us;0us;16613us;1us;16614us;49us;438us;0us;16615us;1us;16616us;49us;440us;0us;16617us;3us;16650us;44us;520us;45us;519us;46us;521us;3us;16650us;44us;520us;45us;519us;46us;521us;15us;32768us;14us;600us;30us;780us;33us;776us;42us;790us;48us;355us;49us;357us;51us;437us;52us;358us;53us;359us;55us;528us;110us;483us;112us;599us;120us;471us;138us;774us;163us;770us;52us;32768us;14us;600us;30us;780us;33us;776us;42us;790us;47us;1956us;48us;355us;49us;357us;51us;437us;52us;358us;53us;359us;55us;528us;57us;587us;59us;684us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;575us;97us;1740us;101us;1966us;107us;1895us;110us;483us;112us;599us;114us;1893us;120us;471us;121us;725us;123us;1894us;138us;774us;149us;1892us;163us;770us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;196us;580us;202us;2048us;203us;872us;0us;16618us;0us;16619us;4us;17570us;10us;1094us;110us;492us;111us;2036us;204us;1078us;1us;17560us;19us;2031us;0us;16620us;0us;16621us;33us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;7us;16657us;36us;1777us;47us;1956us;71us;1791us;88us;522us;92us;1949us;190us;1951us;194us;1955us;0us;16622us;0us;16623us;3us;16650us;44us;520us;45us;519us;46us;521us;1us;17570us;111us;2036us;3us;32768us;93us;1961us;101us;1966us;194us;1955us;2us;16718us;34us;2064us;161us;17597us;1us;32768us;78us;460us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1692us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;2us;16488us;26us;208us;88us;206us;1us;17560us;19us;2031us;0us;16624us;0us;16625us;1us;17560us;19us;2031us;0us;16626us;1us;17560us;19us;2031us;0us;16627us;1us;17560us;19us;2031us;0us;16628us;37us;32768us;10us;1094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;93us;986us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;1us;16664us;133us;536us;9us;32768us;10us;1094us;15us;2097us;21us;478us;37us;2093us;39us;2094us;61us;2095us;70us;474us;95us;2096us;204us;1078us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;1us;17560us;19us;2031us;0us;16629us;0us;16630us;0us;16631us;1us;17564us;21us;2033us;0us;16632us;1us;16556us;74us;322us;0us;16633us;1us;17572us;119us;2037us;3us;16650us;44us;520us;45us;519us;46us;521us;3us;32768us;10us;1094us;194us;1955us;204us;1078us;3us;32768us;10us;1094us;78us;487us;204us;1078us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;16634us;0us;16635us;0us;16636us;0us;16637us;1us;17572us;119us;2037us;3us;16650us;44us;520us;45us;519us;46us;521us;3us;32768us;10us;1094us;194us;1955us;204us;1078us;1us;16642us;78us;503us;9us;32768us;10us;1094us;15us;2097us;21us;501us;37us;2093us;39us;2094us;61us;2095us;70us;497us;95us;2096us;204us;1078us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;2us;16488us;26us;208us;88us;206us;0us;16638us;0us;16639us;0us;16640us;0us;16641us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;16643us;0us;16644us;1us;16925us;77us;507us;3us;32768us;93us;1961us;101us;1966us;194us;1955us;0us;16645us;1us;32768us;77us;510us;3us;32768us;93us;1961us;101us;1966us;194us;1955us;0us;16646us;0us;16647us;4us;32768us;67us;514us;93us;1961us;101us;1966us;194us;1955us;1us;32768us;77us;515us;3us;32768us;93us;1961us;101us;1966us;194us;1955us;0us;16648us;0us;16649us;0us;16651us;0us;16652us;0us;16653us;0us;16654us;31us;16556us;10us;16656us;14us;16656us;15us;16656us;16us;16656us;17us;16656us;19us;16656us;20us;16656us;21us;16656us;22us;543us;30us;16656us;33us;16656us;37us;16656us;39us;16656us;42us;16656us;44us;16656us;45us;16656us;46us;16656us;51us;16656us;53us;16656us;55us;16656us;61us;16656us;74us;322us;84us;16656us;88us;16656us;95us;16656us;110us;16656us;112us;16656us;120us;16656us;138us;16656us;143us;16656us;163us;16656us;3us;32768us;19us;2025us;20us;2026us;143us;2027us;0us;16655us;6us;16556us;19us;16602us;20us;16602us;22us;403us;74us;322us;143us;16602us;204us;409us;3us;32768us;19us;2025us;20us;2026us;143us;2027us;0us;16658us;37us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;47us;1956us;57us;1881us;61us;2095us;67us;1875us;89us;632us;92us;1949us;93us;1866us;95us;2096us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;33us;16668us;35us;2063us;36us;2062us;57us;17595us;72us;17595us;73us;17595us;93us;17595us;107us;17595us;123us;17595us;133us;540us;137us;17595us;149us;17595us;156us;17595us;167us;17595us;168us;17595us;169us;17595us;170us;17595us;171us;17595us;172us;17595us;173us;17595us;174us;17595us;175us;17595us;176us;17595us;177us;17595us;178us;17595us;179us;17595us;181us;17595us;182us;17595us;195us;17595us;196us;17595us;200us;17595us;201us;17595us;202us;17595us;203us;17595us;0us;16660us;30us;32768us;57us;1645us;72us;1504us;73us;1648us;93us;1510us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;1us;16668us;133us;540us;0us;16661us;0us;16662us;0us;16663us;3us;32768us;10us;1094us;194us;1955us;204us;1078us;0us;16665us;0us;16666us;0us;16667us;2us;32768us;155us;542us;194us;1955us;0us;16669us;0us;16670us;1us;16556us;74us;322us;5us;32768us;10us;1094us;15us;2084us;16us;2086us;17us;2087us;204us;1078us;0us;16671us;0us;16672us;0us;16673us;2us;17566us;21us;2021us;84us;2022us;14us;16556us;10us;16675us;14us;16675us;15us;16675us;16us;16675us;17us;16675us;19us;16675us;20us;16675us;21us;16675us;61us;16675us;62us;16675us;74us;322us;112us;16675us;143us;16675us;197us;16675us;0us;16674us;4us;32768us;48us;562us;49us;564us;52us;565us;204us;559us;5us;17570us;48us;562us;49us;564us;52us;565us;111us;2036us;204us;559us;4us;17570us;10us;1094us;110us;492us;111us;2036us;204us;1078us;1us;17560us;19us;2031us;0us;16676us;1us;17560us;19us;2031us;0us;16677us;0us;16678us;1us;17570us;111us;2036us;1us;17560us;19us;2031us;0us;16679us;1us;32768us;49us;563us;0us;16680us;0us;16681us;0us;16682us;3us;16650us;44us;520us;45us;519us;46us;521us;37us;32768us;47us;1956us;57us;587us;59us;684us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;575us;97us;1740us;101us;1966us;107us;1895us;114us;1893us;121us;725us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;196us;580us;202us;2048us;203us;872us;2us;17384us;77us;1958us;156us;569us;1us;32768us;202us;570us;2us;32768us;10us;1094us;204us;1078us;0us;16683us;0us;16684us;0us;16685us;0us;16686us;59us;32768us;47us;1956us;57us;587us;59us;2001us;63us;1983us;64us;1981us;67us;1788us;70us;1985us;71us;708us;73us;590us;75us;1989us;79us;706us;83us;1993us;89us;576us;90us;1990us;91us;1991us;92us;1949us;93us;1780us;97us;1741us;103us;1986us;107us;1895us;114us;1893us;123us;1894us;144us;1996us;146us;1992us;149us;1892us;156us;1998us;159us;1995us;161us;1987us;162us;1988us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;183us;1994us;184us;1982us;185us;1979us;186us;1978us;187us;1744us;188us;1973us;189us;1977us;190us;1952us;191us;1975us;192us;1974us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1897us;30us;32768us;47us;1956us;57us;1881us;67us;1875us;89us;632us;92us;1949us;93us;1876us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;1us;16859us;89us;578us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;16687us;5us;16556us;61us;2075us;62us;2077us;74us;322us;197us;2078us;204us;584us;5us;32768us;10us;1094us;61us;2075us;62us;2077us;197us;2078us;204us;1078us;0us;16688us;0us;16689us;3us;32768us;61us;2075us;62us;2077us;197us;2078us;0us;16690us;0us;16691us;2us;32768us;73us;590us;93us;1882us;0us;16692us;0us;16693us;2us;16556us;74us;322us;204us;594us;3us;32768us;10us;1094us;66us;2079us;204us;1078us;0us;16694us;0us;16695us;1us;32768us;66us;2079us;0us;16696us;0us;16697us;0us;16698us;0us;16699us;0us;16700us;0us;16701us;7us;32768us;10us;1094us;47us;1956us;92us;1949us;93us;608us;190us;1951us;194us;1955us;204us;1078us;3us;16702us;34us;2064us;77us;1958us;161us;17597us;2us;32768us;47us;1956us;194us;1955us;1us;16703us;77us;1958us;0us;16704us;0us;16705us;0us;16706us;1us;16556us;74us;322us;4us;32768us;94us;2083us;95us;2080us;96us;2082us;98us;613us;0us;16707us;2us;16720us;85us;634us;98us;613us;1us;16714us;98us;614us;1us;16556us;74us;322us;2us;16556us;74us;322us;144us;625us;0us;16708us;0us;16709us;2us;32768us;92us;1949us;190us;1951us;1us;16710us;90us;619us;30us;32768us;47us;1956us;57us;1881us;67us;1875us;89us;632us;92us;1949us;93us;1876us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;1us;16711us;90us;643us;1us;32768us;161us;622us;1us;16556us;74us;322us;1us;32768us;162us;624us;0us;16712us;0us;16713us;1us;32768us;161us;627us;3us;16556us;74us;322us;85us;16715us;162us;16715us;1us;16720us;85us;634us;1us;32768us;162us;630us;0us;16716us;0us;16717us;30us;32768us;47us;1956us;57us;1881us;67us;1875us;89us;632us;92us;1949us;93us;1876us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;1us;16719us;77us;1901us;32us;32768us;47us;1956us;53us;648us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;664us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;1us;16721us;132us;638us;1us;17331us;132us;638us;1us;17333us;132us;638us;32us;32768us;47us;1956us;53us;648us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;664us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;16722us;0us;16723us;1us;17382us;90us;643us;1us;17383us;90us;643us;30us;32768us;47us;1956us;57us;1881us;67us;1875us;89us;632us;92us;1949us;93us;1876us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;1us;16724us;77us;17442us;1us;16725us;77us;1901us;1us;16726us;77us;17442us;1us;16727us;77us;1901us;2us;32768us;92us;1949us;190us;1951us;1us;32768us;78us;650us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;16728us;3us;17385us;78us;655us;80us;653us;90us;1762us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;4us;16729us;47us;17398us;71us;17398us;92us;17398us;194us;17398us;5us;32768us;57us;656us;93us;661us;149us;659us;153us;671us;194us;657us;0us;16730us;4us;16738us;34us;1907us;57us;658us;149us;660us;161us;1909us;0us;16731us;0us;16732us;0us;16733us;1us;16556us;74us;322us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;16734us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1896us;4us;32768us;94us;2083us;95us;2080us;96us;2082us;103us;675us;1us;32768us;78us;667us;1us;32768us;93us;668us;1us;16556us;74us;322us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;16735us;2us;32768us;34us;1907us;161us;1909us;0us;16736us;0us;16737us;6us;16739us;36us;1777us;47us;1956us;71us;1791us;92us;1949us;190us;1951us;194us;1955us;31us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;6us;16740us;36us;1777us;47us;1956us;71us;1791us;92us;1949us;190us;1951us;194us;1955us;14us;16741us;10us;17389us;36us;1777us;41us;1772us;47us;1956us;70us;17389us;71us;1791us;92us;1949us;97us;17389us;98us;17389us;99us;17389us;187us;17389us;190us;1951us;194us;1955us;204us;17389us;1us;16556us;74us;322us;0us;16742us;1us;32768us;59us;684us;1us;16556us;74us;322us;0us;16743us;2us;16744us;21us;2033us;59us;17564us;0us;16745us;1us;16747us;59us;684us;1us;16556us;74us;322us;0us;16746us;3us;16650us;44us;520us;45us;519us;46us;521us;6us;32768us;10us;1094us;93us;705us;101us;1966us;121us;695us;194us;1955us;204us;1078us;36us;16748us;47us;1956us;57us;587us;67us;1788us;70us;701us;73us;590us;78us;699us;89us;632us;92us;1949us;93us;1774us;97us;731us;107us;1895us;114us;1893us;121us;692us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;196us;580us;202us;2048us;203us;872us;0us;16749us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1774us;97us;731us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;196us;580us;202us;2048us;203us;872us;204us;1078us;0us;16750us;0us;16751us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1774us;97us;731us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;196us;580us;202us;2048us;203us;872us;204us;1078us;0us;16752us;0us;16753us;0us;16754us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1692us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;16755us;42us;32768us;10us;1094us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;5us;16756us;34us;1431us;35us;1430us;36us;1429us;75us;1448us;77us;1440us;0us;16757us;0us;16758us;29us;32768us;59us;2001us;63us;1983us;64us;1981us;70us;1985us;71us;708us;75us;1989us;79us;706us;83us;1993us;90us;1990us;91us;1991us;97us;1984us;103us;1986us;144us;1996us;146us;1992us;156us;1998us;159us;1995us;161us;1987us;162us;1988us;183us;1994us;184us;1982us;185us;1979us;186us;1978us;187us;1980us;188us;1973us;189us;1977us;190us;1976us;191us;1975us;192us;1974us;204us;1964us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;16759us;1us;32768us;60us;709us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;16760us;5us;17495us;21us;2033us;59us;17564us;70us;713us;78us;17532us;121us;719us;0us;16761us;42us;32768us;10us;1094us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;6us;17564us;21us;2033us;34us;1431us;35us;1430us;36us;1429us;75us;1448us;77us;1440us;46us;16762us;10us;16769us;14us;16769us;15us;16769us;16us;16769us;17us;16769us;19us;16769us;20us;16769us;21us;16769us;30us;16769us;33us;16769us;37us;16769us;38us;16769us;39us;16769us;40us;16769us;42us;16769us;44us;16769us;45us;16769us;46us;16769us;48us;16769us;49us;16769us;51us;16769us;52us;16769us;53us;16769us;55us;16769us;61us;16769us;68us;16769us;74us;16769us;84us;16769us;88us;16769us;89us;16769us;94us;16769us;95us;16769us;96us;16769us;102us;16769us;109us;16769us;110us;16769us;112us;16769us;120us;16769us;122us;16769us;132us;16769us;138us;16769us;143us;16769us;151us;16769us;152us;16769us;163us;16769us;204us;16769us;1us;17564us;21us;2033us;46us;16763us;10us;16770us;14us;16770us;15us;16770us;16us;16770us;17us;16770us;19us;16770us;20us;16770us;21us;16770us;30us;16770us;33us;16770us;37us;16770us;38us;16770us;39us;16770us;40us;16770us;42us;16770us;44us;16770us;45us;16770us;46us;16770us;48us;16770us;49us;16770us;51us;16770us;52us;16770us;53us;16770us;55us;16770us;61us;16770us;68us;16770us;74us;16770us;84us;16770us;88us;16770us;89us;16770us;94us;16770us;95us;16770us;96us;16770us;102us;16770us;109us;16770us;110us;16770us;112us;16770us;120us;16770us;122us;16770us;132us;16770us;138us;16770us;143us;16770us;151us;16770us;152us;16770us;163us;16770us;204us;16770us;0us;16764us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1774us;97us;731us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;196us;580us;202us;2048us;203us;872us;204us;1078us;0us;16765us;1us;32768us;78us;722us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1692us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;16766us;0us;16767us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1774us;97us;731us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;196us;580us;202us;2048us;203us;872us;0us;16768us;1us;16774us;97us;728us;34us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1774us;97us;731us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;16771us;0us;16772us;32us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1774us;97us;731us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;16773us;1us;17495us;78us;734us;33us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1774us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;16775us;0us;16776us;0us;16777us;0us;16778us;0us;16779us;0us;16780us;0us;16781us;2us;17566us;21us;2021us;84us;2022us;5us;16556us;61us;17565us;62us;17565us;66us;17565us;74us;322us;197us;17565us;0us;16782us;0us;16783us;1us;17572us;119us;2037us;0us;16784us;3us;16650us;44us;520us;45us;519us;46us;521us;3us;32768us;10us;1094us;194us;1955us;204us;1078us;3us;32768us;10us;1094us;78us;751us;204us;1078us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;16785us;0us;16786us;0us;16787us;0us;16788us;1us;16659us;88us;525us;0us;16789us;1us;16556us;74us;322us;3us;16650us;44us;520us;45us;519us;46us;521us;3us;32768us;10us;1094us;194us;1955us;204us;1078us;1us;16795us;70us;768us;0us;16790us;0us;16791us;1us;16792us;121us;765us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1774us;97us;731us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;196us;580us;202us;2048us;203us;872us;204us;1078us;0us;16793us;0us;16794us;2us;32768us;47us;1956us;194us;1955us;1us;16796us;77us;1958us;1us;17568us;104us;2035us;2us;16556us;74us;322us;204us;827us;0us;16797us;0us;16798us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;16799us;1us;17568us;104us;2035us;2us;16556us;74us;322us;204us;827us;3us;32768us;10us;1094us;19us;788us;204us;1078us;0us;16800us;81us;32768us;13us;1206us;19us;783us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;3us;32768us;10us;1094us;19us;788us;204us;1078us;0us;16801us;0us;16802us;0us;16803us;0us;16804us;0us;16805us;0us;16806us;0us;16807us;0us;16808us;1us;16556us;74us;322us;3us;16650us;44us;520us;45us;519us;46us;521us;1us;32768us;194us;1955us;2us;17595us;35us;2063us;36us;2062us;1us;32768us;93us;795us;4us;16556us;74us;322us;94us;16812us;95us;16812us;96us;16812us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;16809us;1us;16810us;98us;800us;1us;16811us;98us;802us;1us;16556us;74us;322us;0us;16813us;1us;16556us;74us;322us;0us;16814us;3us;32768us;43us;816us;47us;1956us;194us;1955us;7us;16815us;35us;2063us;36us;2062us;41us;813us;71us;17595us;90us;815us;97us;812us;194us;1955us;0us;16816us;1us;16817us;77us;1958us;6us;16823us;35us;2063us;36us;2062us;41us;813us;71us;17595us;90us;815us;97us;812us;1us;32768us;71us;810us;1us;32768us;60us;811us;0us;16818us;0us;16819us;1us;32768us;149us;814us;0us;16820us;0us;16821us;1us;32768us;97us;818us;1us;16824us;97us;818us;0us;16822us;3us;32768us;43us;817us;47us;1956us;194us;1955us;1us;16827us;132us;822us;0us;16825us;2us;16556us;74us;322us;204us;827us;1us;16827us;132us;822us;0us;16826us;1us;17570us;111us;2036us;0us;16828us;0us;16829us;1us;17572us;119us;2037us;37us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;1us;17334us;78us;1681us;3us;32768us;10us;1094us;70us;832us;204us;1078us;81us;32768us;13us;1206us;22us;836us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;834us;0us;16830us;0us;16831us;0us;16832us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;5us;32768us;10us;1094us;15us;2084us;16us;2086us;17us;2087us;204us;1078us;0us;16833us;0us;16834us;0us;16835us;0us;16838us;1us;16836us;85us;844us;0us;16837us;2us;32768us;92us;1949us;190us;1951us;2us;32768us;70us;846us;132us;848us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;16839us;2us;32768us;92us;1949us;190us;1951us;0us;16840us;0us;16841us;2us;32768us;57us;854us;78us;852us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;16842us;0us;16843us;0us;16844us;0us;16845us;0us;16846us;0us;16847us;0us;16848us;0us;16849us;0us;16850us;0us;16851us;0us;16852us;0us;16853us;0us;16854us;0us;16855us;0us;16856us;0us;16857us;0us;16858us;0us;16859us;0us;16860us;0us;16861us;1us;16864us;187us;874us;1us;32768us;179us;875us;0us;16862us;1us;32768us;179us;877us;1us;16865us;187us;878us;1us;32768us;179us;879us;0us;16863us;0us;16866us;2us;32768us;63us;876us;179us;873us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;16867us;0us;16868us;2us;32768us;93us;881us;179us;880us;0us;16869us;1us;16870us;34us;888us;1us;32768us;161us;1926us;0us;16871us;6us;16872us;41us;899us;59us;896us;79us;915us;90us;927us;98us;921us;133us;911us;0us;16873us;41us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;94us;2083us;95us;2080us;96us;2082us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;10us;32768us;41us;899us;59us;896us;78us;1021us;79us;1025us;90us;1035us;94us;2083us;95us;2080us;96us;2082us;98us;1029us;133us;1015us;0us;16875us;0us;16876us;0us;16877us;2us;16877us;41us;899us;59us;896us;2us;16877us;41us;899us;59us;896us;0us;16878us;3us;16882us;79us;915us;90us;927us;98us;921us;1us;16883us;79us;915us;2us;16889us;79us;915us;90us;927us;2us;16890us;79us;915us;90us;927us;2us;16893us;79us;915us;90us;927us;1us;16895us;79us;915us;1us;16896us;79us;915us;7us;32768us;41us;899us;59us;896us;70us;1096us;79us;915us;90us;927us;98us;921us;133us;911us;7us;32768us;41us;899us;59us;896us;70us;1101us;79us;915us;90us;927us;98us;921us;133us;911us;7us;32768us;41us;899us;59us;896us;70us;1184us;79us;915us;90us;927us;98us;921us;133us;911us;7us;32768us;41us;899us;59us;896us;70us;1191us;79us;915us;90us;927us;98us;921us;133us;911us;38us;16881us;10us;1094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;0us;16879us;0us;16880us;37us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;42us;16885us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;61us;2095us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;0us;16884us;1us;16886us;98us;920us;0us;16887us;0us;16888us;44us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;61us;2095us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;95us;2096us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;44us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;61us;2095us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;95us;2096us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;0us;16891us;0us;16892us;44us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;61us;2095us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;95us;2096us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;0us;16894us;37us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;37us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;2us;17566us;21us;2021us;84us;2022us;0us;16897us;3us;17565us;21us;2021us;84us;2022us;194us;1955us;0us;16898us;1us;32768us;194us;1955us;0us;16899us;3us;32768us;10us;1094us;70us;936us;204us;1078us;4us;17534us;10us;1094us;70us;936us;77us;2008us;204us;1078us;40us;32768us;10us;1094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;7us;16900us;41us;899us;59us;896us;78us;1021us;79us;1025us;90us;1035us;98us;1029us;133us;1015us;0us;16901us;0us;16902us;39us;16927us;34us;2064us;35us;948us;36us;950us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;93us;956us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;161us;17597us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;37us;16903us;35us;943us;36us;945us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;93us;956us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;0us;16904us;35us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;93us;956us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;0us;16905us;35us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;93us;956us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;0us;16906us;0us;16907us;35us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;93us;956us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;0us;16908us;35us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;93us;956us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;0us;16909us;33us;16912us;10us;1094us;47us;1956us;57us;587us;67us;1875us;73us;590us;89us;632us;92us;1949us;93us;1876us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;16910us;0us;16911us;0us;16913us;64us;16941us;10us;1094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;59us;2001us;63us;1983us;64us;1981us;67us;506us;70us;1985us;71us;972us;72us;975us;74us;322us;75us;979us;82us;952us;83us;1993us;90us;1990us;91us;1991us;93us;986us;97us;1984us;98us;1032us;101us;1966us;103us;1986us;107us;984us;123us;983us;144us;1996us;146us;1992us;149us;985us;156us;1498us;159us;1995us;161us;1987us;162us;1988us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;183us;1994us;184us;1982us;185us;1979us;186us;1978us;187us;1980us;188us;1973us;189us;1977us;190us;1976us;191us;1975us;192us;1974us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;990us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;16914us;0us;16915us;37us;16919us;35us;964us;36us;962us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;93us;986us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;0us;16916us;35us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;93us;986us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;0us;16917us;35us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;93us;986us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;0us;16918us;0us;16920us;3us;32768us;47us;1956us;194us;1955us;204us;970us;3us;32768us;61us;2075us;62us;2077us;197us;2078us;0us;16921us;3us;32768us;61us;2075us;62us;2077us;197us;2078us;0us;16922us;38us;16968us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;1us;32768us;60us;974us;0us;16923us;38us;16968us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;1us;32768us;65us;977us;0us;16924us;1us;32768us;194us;1955us;1us;17519us;194us;1955us;0us;16926us;0us;16927us;0us;16928us;0us;16929us;0us;16930us;0us;16931us;64us;16941us;10us;1094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;59us;2001us;63us;1983us;64us;1981us;67us;506us;70us;1985us;71us;972us;72us;975us;74us;322us;75us;979us;82us;952us;83us;1993us;90us;1990us;91us;1991us;93us;986us;97us;1984us;98us;1032us;101us;1966us;103us;1986us;107us;984us;123us;983us;144us;1996us;146us;1992us;149us;985us;156us;1498us;159us;1995us;161us;1987us;162us;1988us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;183us;1994us;184us;1982us;185us;1979us;186us;1978us;187us;1980us;188us;1973us;189us;1977us;190us;1976us;191us;1975us;192us;1974us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;990us;5us;32768us;10us;1094us;94us;2083us;95us;2080us;96us;2082us;204us;1078us;0us;16932us;0us;16933us;3us;16991us;94us;2083us;95us;2080us;96us;2082us;2us;16934us;34us;17499us;161us;17499us;0us;16935us;1us;32768us;93us;994us;40us;32768us;10us;1094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;998us;6us;16946us;10us;1094us;94us;2083us;95us;2080us;96us;2082us;98us;1028us;204us;1078us;0us;16936us;0us;16937us;3us;16991us;94us;2083us;95us;2080us;96us;2082us;0us;16938us;0us;16939us;7us;16940us;41us;899us;59us;896us;78us;1021us;79us;1025us;90us;1035us;98us;1029us;133us;1015us;4us;16945us;78us;1021us;79us;1025us;90us;1035us;98us;1029us;3us;16950us;78us;1021us;79us;1025us;90us;1035us;2us;16951us;78us;1021us;79us;1025us;3us;16955us;78us;1021us;79us;1025us;90us;1035us;3us;16956us;78us;1021us;79us;1025us;90us;1035us;3us;16959us;78us;1021us;79us;1025us;90us;1035us;2us;16961us;78us;1021us;79us;1025us;7us;32768us;41us;899us;59us;896us;78us;1021us;79us;1025us;90us;1035us;98us;1029us;133us;1015us;2us;16962us;78us;1021us;79us;1025us;7us;16965us;41us;899us;59us;896us;78us;1021us;79us;1025us;90us;1035us;98us;1029us;133us;1015us;9us;17566us;21us;2021us;41us;899us;59us;896us;78us;1021us;79us;1025us;84us;2022us;90us;1035us;98us;1029us;133us;1015us;16us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;41us;899us;59us;896us;61us;2095us;70us;1558us;78us;1021us;79us;1025us;90us;1035us;95us;2096us;98us;1029us;128us;1555us;133us;1015us;204us;1082us;8us;17131us;41us;899us;59us;896us;78us;1021us;79us;1025us;85us;1348us;90us;1035us;98us;1029us;133us;1015us;38us;16944us;10us;1094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;0us;16942us;0us;16943us;38us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;1us;16946us;98us;1028us;1us;16947us;90us;1034us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;16948us;0us;16949us;38us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;39us;16953us;10us;1094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;0us;16952us;0us;16954us;45us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;61us;2095us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;95us;2096us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;45us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;61us;2095us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;95us;2096us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;0us;16957us;0us;16958us;45us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;61us;2095us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;95us;2096us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;0us;16960us;38us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;38us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;2us;17566us;21us;2021us;84us;2022us;0us;16963us;2us;17565us;47us;1956us;194us;1955us;0us;16964us;4us;32768us;10us;1094us;70us;1041us;77us;1958us;204us;1078us;40us;32768us;10us;1094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;0us;16966us;0us;16967us;0us;16969us;38us;16968us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;0us;16970us;82us;32768us;13us;1206us;15us;2084us;16us;2086us;17us;2087us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;5us;32768us;10us;1094us;15us;2084us;16us;2086us;17us;2087us;204us;1078us;0us;16971us;0us;16972us;0us;16973us;0us;16974us;82us;32768us;13us;1206us;15us;2084us;16us;2086us;17us;2087us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;3us;32768us;15us;2084us;16us;2086us;17us;2087us;0us;16975us;0us;16976us;26us;16977us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;1us;16979us;18us;1059us;0us;16978us;0us;16980us;94us;16980us;14us;17325us;15us;17325us;16us;17325us;17us;17325us;18us;17325us;19us;17325us;21us;17325us;26us;17325us;27us;17325us;28us;17325us;30us;17325us;33us;17325us;37us;17325us;38us;17325us;39us;17325us;40us;17325us;41us;17325us;42us;17325us;44us;17325us;45us;17325us;46us;17325us;48us;17325us;49us;17325us;51us;17325us;52us;17325us;53us;17325us;55us;17325us;59us;17325us;60us;17325us;61us;17325us;62us;17325us;63us;17325us;64us;17325us;65us;17325us;66us;17325us;68us;17325us;70us;17325us;74us;17325us;78us;17325us;79us;17325us;80us;17325us;81us;17325us;82us;17325us;83us;17325us;84us;17325us;85us;17325us;88us;17325us;89us;17325us;90us;17325us;91us;17325us;94us;17325us;95us;17325us;96us;17325us;97us;17325us;98us;17325us;99us;17325us;102us;17325us;103us;17325us;105us;17325us;106us;17325us;109us;17325us;110us;17325us;112us;17325us;120us;17325us;122us;17325us;128us;17325us;129us;17325us;130us;17325us;132us;17325us;138us;17325us;139us;17325us;140us;17325us;141us;17325us;142us;17325us;143us;17325us;144us;17325us;146us;17325us;151us;17325us;152us;17325us;157us;17325us;159us;17325us;161us;17325us;162us;17325us;163us;17325us;185us;17325us;186us;17325us;187us;17325us;189us;17325us;190us;17325us;191us;17325us;192us;17325us;197us;17325us;198us;17325us;199us;17325us;1us;16983us;78us;1063us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;16981us;0us;16982us;1us;32768us;10us;1067us;0us;16984us;30us;16987us;21us;2021us;28us;1073us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;84us;2022us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;105us;1071us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;79us;16986us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;16985us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;16988us;1us;32768us;22us;1074us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;3us;32768us;15us;2084us;16us;2086us;17us;2087us;0us;16989us;82us;16990us;13us;1206us;21us;1113us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1112us;0us;16991us;2us;16991us;19us;2041us;139us;2040us;2us;16991us;19us;2041us;139us;2040us;2us;16991us;30us;2039us;138us;2038us;2us;16991us;19us;2041us;139us;2040us;2us;16991us;19us;2041us;139us;2040us;0us;16991us;2us;16991us;41us;899us;59us;896us;1us;16991us;60us;1456us;1us;16991us;60us;1477us;1us;16991us;157us;1502us;1us;16991us;65us;1508us;3us;16991us;94us;2083us;95us;2080us;96us;2082us;3us;16991us;94us;2083us;95us;2080us;96us;2082us;3us;16991us;61us;2075us;62us;2077us;197us;2078us;1us;16991us;66us;2079us;0us;16992us;37us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;1us;32768us;128us;1098us;2us;16995us;31us;1100us;166us;1095us;0us;16993us;37us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;3us;32768us;10us;1094us;19us;788us;204us;1078us;1us;17564us;21us;2033us;2us;16995us;31us;1100us;166us;1095us;0us;16994us;1us;32768us;128us;1107us;80us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1109us;0us;16996us;0us;16997us;82us;32768us;13us;1206us;21us;1113us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1112us;0us;16998us;0us;16999us;81us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1115us;0us;17000us;0us;17001us;0us;17002us;0us;17003us;0us;17004us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;4us;32768us;10us;1094us;26us;1324us;88us;1322us;204us;1078us;0us;17005us;0us;17006us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;4us;32768us;10us;1094us;26us;1324us;88us;1322us;204us;1078us;0us;17007us;0us;17008us;82us;32768us;10us;1094us;13us;1206us;18us;1131us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;5us;32768us;10us;1094us;26us;1324us;88us;1322us;130us;1133us;204us;1078us;0us;17009us;0us;17010us;2us;17011us;26us;1324us;88us;1322us;0us;17012us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17013us;81us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;30us;32768us;10us;1094us;28us;1355us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;105us;1353us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;204us;1078us;0us;17014us;0us;17015us;0us;17016us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17017us;68us;17019us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;160us;1183us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17018us;80us;32768us;13us;1206us;22us;1053us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17020us;69us;17022us;13us;1206us;22us;1053us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;160us;1183us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17021us;81us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1083us;0us;17023us;81us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1083us;0us;17024us;45us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;61us;2095us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;95us;2096us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1081us;10us;17564us;10us;1094us;15us;2097us;21us;2033us;30us;2039us;37us;2093us;39us;2094us;61us;2095us;95us;2096us;138us;2038us;204us;1078us;87us;32768us;10us;1094us;13us;1206us;15us;2097us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1079us;9us;32768us;10us;1094us;15us;2097us;19us;2041us;37us;2093us;39us;2094us;61us;2095us;95us;2096us;139us;2040us;204us;1078us;0us;17025us;0us;17026us;0us;17027us;0us;17028us;0us;17029us;1us;32768us;99us;1553us;0us;17030us;4us;32768us;10us;1094us;30us;2039us;138us;2038us;204us;1078us;82us;32768us;10us;1094us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1080us;4us;32768us;10us;1094us;19us;2041us;139us;2040us;204us;1078us;0us;17031us;0us;17032us;0us;17033us;0us;17034us;0us;17035us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;2us;32768us;19us;2041us;139us;2040us;0us;17036us;0us;17037us;0us;17038us;0us;17039us;81us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;26us;17040us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;81us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;26us;17041us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;0us;17042us;0us;17043us;37us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;1us;32768us;128us;1186us;1us;17564us;21us;2033us;2us;16995us;31us;1100us;166us;1095us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17044us;37us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;82us;952us;93us;986us;98us;924us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;3us;32768us;10us;1094us;19us;788us;204us;1078us;1us;17564us;21us;2033us;3us;16995us;31us;1100us;166us;1095us;204us;1197us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17045us;0us;17046us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;1us;32768us;128us;1200us;1us;17564us;21us;2033us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17047us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;3us;32768us;10us;1094us;19us;788us;204us;1078us;0us;17048us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;26us;17049us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;81us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17050us;26us;17057us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;20us;17060us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;90us;1271us;91us;1273us;97us;1297us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;20us;17062us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;90us;1271us;91us;1273us;97us;1297us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;9us;17064us;63us;1295us;79us;1291us;82us;1248us;97us;1297us;159us;1289us;185us;1293us;187us;1299us;190us;1287us;192us;1301us;20us;17066us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;90us;1271us;91us;1273us;97us;1297us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;18us;17068us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;97us;1297us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;18us;17070us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;97us;1297us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;9us;17072us;63us;1295us;79us;1291us;82us;1248us;97us;1297us;159us;1289us;185us;1293us;187us;1299us;190us;1287us;192us;1301us;9us;17074us;63us;1295us;79us;1291us;82us;1248us;97us;1297us;159us;1289us;185us;1293us;187us;1299us;190us;1287us;192us;1301us;9us;17076us;63us;1295us;79us;1291us;82us;1248us;97us;1297us;159us;1289us;185us;1293us;187us;1299us;190us;1287us;192us;1301us;9us;17078us;63us;1295us;79us;1291us;82us;1248us;97us;1297us;159us;1289us;185us;1293us;187us;1299us;190us;1287us;192us;1301us;9us;17080us;63us;1295us;79us;1291us;82us;1248us;97us;1297us;159us;1289us;185us;1293us;187us;1299us;190us;1287us;192us;1301us;9us;17082us;63us;1295us;79us;1291us;82us;1248us;97us;1297us;159us;1289us;185us;1293us;187us;1299us;190us;1287us;192us;1301us;9us;17084us;63us;1295us;79us;1291us;82us;1248us;97us;1297us;159us;1289us;185us;1293us;187us;1299us;190us;1287us;192us;1301us;1us;17086us;192us;1301us;8us;17088us;63us;1295us;79us;1291us;82us;1248us;97us;1297us;159us;1289us;185us;1293us;187us;1299us;192us;1301us;4us;17090us;97us;1297us;159us;1289us;187us;1299us;192us;1301us;4us;17092us;97us;1297us;159us;1289us;187us;1299us;192us;1301us;1us;17094us;192us;1301us;1us;17096us;192us;1301us;1us;17098us;192us;1301us;23us;17100us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;90us;1271us;91us;1273us;97us;1297us;103us;1269us;129us;1263us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;24us;17102us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;90us;1271us;91us;1273us;97us;1297us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;30us;32768us;10us;1094us;30us;2039us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;138us;2038us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;204us;1078us;26us;17130us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;26us;17134us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;26us;17139us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;30us;32768us;10us;1094us;28us;1355us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;105us;1353us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;204us;1078us;24us;17143us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;90us;1271us;91us;1273us;97us;1297us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;24us;17145us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;90us;1271us;91us;1273us;97us;1297us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;24us;17148us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;90us;1271us;91us;1273us;97us;1297us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;26us;32768us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;24us;17150us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;90us;1271us;91us;1273us;97us;1297us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;29us;32768us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;94us;2083us;95us;2080us;96us;2082us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;26us;17255us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;28us;32768us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;106us;1560us;129us;1263us;140us;1561us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;26us;17258us;63us;1295us;64us;1281us;70us;1277us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;27us;17585us;63us;1295us;64us;1281us;70us;1277us;78us;2050us;79us;1291us;80us;1251us;81us;1254us;82us;1248us;83us;1257us;90us;1271us;91us;1273us;97us;1297us;98us;1368us;103us;1269us;129us;1263us;144us;1303us;146us;1265us;159us;1289us;161us;1283us;162us;1285us;185us;1293us;186us;1275us;187us;1299us;189us;1267us;190us;1287us;191us;1279us;192us;1301us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17051us;0us;17052us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17053us;0us;17054us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17055us;0us;17056us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;1us;17104us;69us;1259us;80us;32768us;13us;1206us;22us;1053us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17058us;1us;17059us;98us;1364us;6us;17059us;10us;1094us;94us;2083us;95us;2080us;96us;2082us;98us;1364us;204us;1078us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17061us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17063us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17065us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17067us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17069us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17071us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17073us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17075us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17077us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17079us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17081us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17083us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17085us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17087us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17089us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17091us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17093us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17095us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17097us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17099us;76us;17101us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;79us;17526us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1306us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;79us;17527us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17103us;0us;17103us;81us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1313us;4us;32768us;10us;1094us;19us;2041us;139us;2040us;204us;1078us;0us;17105us;0us;17106us;2us;32768us;19us;2041us;139us;2040us;0us;17107us;0us;17108us;0us;17109us;0us;17110us;0us;17111us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;17112us;41us;32768us;41us;899us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;59us;897us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1335us;0us;17113us;42us;32768us;10us;1094us;41us;899us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;59us;897us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1084us;3us;32768us;10us;1094us;20us;1326us;204us;1078us;0us;17114us;0us;17115us;0us;17116us;0us;17117us;39us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1334us;0us;17118us;38us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;0us;17119us;0us;17120us;0us;17121us;0us;17122us;3us;32768us;10us;1094us;99us;1349us;204us;1085us;4us;17123us;10us;1094us;41us;899us;59us;898us;204us;1078us;40us;32768us;10us;1094us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1078us;0us;17124us;38us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;0us;17125us;38us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;0us;17126us;0us;17127us;0us;17128us;0us;17129us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;81us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17132us;3us;17138us;27us;1359us;141us;1358us;142us;1361us;0us;17133us;81us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17135us;82us;32768us;10us;1094us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17136us;0us;17137us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;80us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17140us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17141us;0us;17142us;87us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;98us;1366us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17144us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17146us;87us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;98us;1370us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17147us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17149us;50us;32768us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;50us;32768us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;50us;17506us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;50us;17506us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17151us;50us;32768us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;50us;17513us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17152us;50us;32768us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;50us;17509us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17153us;50us;32768us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;50us;17512us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17154us;50us;32768us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;50us;17525us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17155us;50us;32768us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;50us;17520us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17156us;50us;32768us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;50us;17521us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17157us;31us;32768us;47us;1956us;57us;1881us;67us;1875us;89us;632us;92us;1949us;93us;1866us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1406us;31us;32768us;47us;1956us;57us;1881us;67us;1875us;89us;632us;92us;1949us;93us;1866us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1406us;2us;17595us;35us;2063us;36us;2062us;37us;17299us;14us;17302us;21us;17302us;26us;17302us;35us;2063us;36us;2062us;57us;17595us;72us;17595us;73us;17595us;88us;17302us;93us;17595us;107us;17595us;112us;17302us;123us;17595us;137us;17595us;149us;17595us;156us;17595us;167us;17595us;168us;17595us;169us;17595us;170us;17595us;171us;17595us;172us;17595us;173us;17595us;174us;17595us;175us;17595us;176us;17595us;177us;17595us;178us;17595us;179us;17595us;181us;17595us;182us;17595us;195us;17595us;196us;17595us;200us;17595us;201us;17595us;202us;17595us;203us;17595us;31us;32768us;57us;1645us;72us;1504us;73us;1648us;93us;1510us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1405us;31us;32768us;57us;1645us;72us;1504us;73us;1648us;93us;1510us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1405us;1us;17159us;77us;1403us;6us;17159us;14us;17301us;26us;17301us;77us;1403us;88us;17301us;112us;17301us;133us;540us;7us;17193us;10us;1094us;47us;1464us;71us;1473us;93us;1466us;101us;1966us;194us;1955us;204us;1078us;0us;17158us;0us;17160us;0us;17161us;50us;32768us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17162us;50us;32768us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;120us;1395us;123us;1485us;137us;1490us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17163us;41us;17164us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1416us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;44us;17164us;26us;1598us;47us;1450us;57us;1458us;67us;1419us;70us;1585us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;88us;1594us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1416us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;44us;17275us;26us;1598us;47us;1450us;57us;1458us;67us;1419us;70us;1585us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;88us;1594us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1416us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17165us;5us;17166us;34us;1431us;35us;1430us;36us;1429us;75us;1448us;77us;1440us;40us;32768us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;5us;17167us;34us;1431us;35us;1430us;36us;1429us;75us;1448us;77us;1440us;5us;17168us;34us;1431us;35us;1430us;36us;1429us;75us;1448us;77us;1440us;3us;32768us;10us;1094us;77us;1421us;204us;1078us;4us;17276us;10us;1094us;70us;1590us;77us;1421us;204us;1078us;42us;32768us;10us;1094us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;5us;17169us;34us;1431us;35us;1430us;36us;1429us;75us;1448us;77us;1440us;0us;17170us;0us;17171us;2us;17172us;34us;1431us;35us;1430us;1us;17173us;34us;1431us;5us;17175us;34us;1431us;35us;1430us;36us;1429us;75us;1448us;77us;1440us;5us;17454us;34us;1431us;35us;1430us;36us;1429us;75us;1448us;77us;1440us;40us;32768us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;40us;32768us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;1us;32768us;161us;1909us;0us;17174us;40us;32768us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;40us;17503us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;1us;32768us;194us;1955us;1us;32768us;194us;1955us;0us;17176us;0us;17176us;0us;17177us;7us;17193us;10us;1094us;47us;1464us;71us;1473us;93us;1466us;101us;1966us;194us;1955us;204us;1078us;0us;17178us;1us;32768us;77us;1443us;7us;17193us;10us;1094us;47us;1464us;71us;1473us;93us;1466us;101us;1966us;194us;1955us;204us;1078us;0us;17179us;3us;32768us;93us;1961us;101us;1966us;194us;1955us;3us;17519us;93us;1961us;101us;1966us;194us;1955us;0us;17180us;2us;32768us;93us;1319us;194us;1318us;0us;17181us;0us;17182us;0us;17183us;81us;17250us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1086us;3us;32768us;10us;1094us;60us;1454us;204us;1078us;0us;17184us;0us;17185us;0us;17186us;0us;17187us;2us;32768us;73us;1648us;93us;1459us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17188us;0us;17189us;0us;17190us;0us;17191us;0us;17192us;0us;17194us;95us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;59us;2001us;63us;1378us;64us;1981us;67us;1419us;70us;1985us;71us;1452us;72us;1504us;73us;1648us;75us;1446us;79us;1467us;83us;1993us;86us;1148us;87us;1150us;90us;1390us;91us;1393us;92us;1435us;93us;1512us;97us;1308us;99us;1208us;101us;1966us;103us;1986us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1305us;146us;1992us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1498us;159us;1387us;160us;1183us;161us;1987us;162us;1988us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;183us;1994us;184us;1384us;185us;1381us;186us;1978us;187us;1980us;188us;1434us;189us;1977us;190us;1375us;191us;1975us;192us;1974us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1964us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;1us;32768us;77us;1469us;1us;32768us;179us;1470us;0us;17195us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;17196us;81us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1087us;3us;32768us;10us;1094us;60us;1475us;204us;1078us;0us;17197us;0us;17198us;0us;17199us;0us;17200us;0us;17201us;0us;17202us;0us;17203us;0us;17204us;0us;17205us;0us;17206us;0us;17207us;0us;17208us;0us;17209us;0us;17210us;0us;17211us;81us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;143us;1496us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1494us;3us;32768us;10us;1094us;143us;1492us;204us;1078us;0us;17212us;0us;17213us;1us;32768us;143us;1495us;0us;17214us;0us;17215us;81us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1088us;82us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;157us;1999us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1088us;3us;32768us;10us;1094us;157us;1500us;204us;1078us;0us;17216us;0us;17217us;0us;17218us;0us;17219us;81us;17252us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1089us;3us;32768us;10us;1094us;65us;1506us;204us;1078us;0us;17220us;0us;17221us;0us;17222us;0us;17223us;90us;32768us;10us;1094us;13us;1206us;15us;1522us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;1519us;39us;1520us;42us;790us;47us;1450us;57us;1458us;61us;1521us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;89us;1562us;90us;1389us;91us;1392us;92us;1436us;93us;1511us;94us;2083us;95us;2080us;96us;2082us;97us;1307us;98us;1524us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1373us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1090us;104us;32768us;10us;1094us;13us;1206us;15us;1522us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;1519us;39us;1520us;42us;790us;47us;1450us;57us;1458us;59us;2001us;61us;1521us;63us;1378us;64us;1981us;67us;1419us;70us;1985us;71us;1452us;72us;1504us;73us;1648us;75us;1446us;83us;1993us;86us;1148us;87us;1150us;89us;1562us;90us;1390us;91us;1393us;92us;1436us;93us;1511us;94us;2083us;95us;2080us;96us;2082us;97us;1308us;98us;1524us;99us;1208us;101us;1966us;103us;1986us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1305us;146us;1992us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1498us;159us;1387us;160us;1183us;161us;1987us;162us;1988us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;183us;1994us;184us;1384us;185us;1381us;186us;1978us;187us;1980us;188us;1434us;189us;1977us;190us;1374us;191us;1975us;192us;1974us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1091us;104us;32768us;10us;1094us;13us;1206us;15us;1522us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;1519us;39us;1520us;42us;790us;47us;1450us;57us;1458us;59us;2001us;61us;1521us;63us;1378us;64us;1981us;67us;1419us;70us;1985us;71us;1452us;72us;1504us;73us;1648us;75us;1446us;83us;1993us;86us;1148us;87us;1150us;89us;1562us;90us;1390us;91us;1393us;92us;1436us;93us;1511us;94us;2083us;95us;2080us;96us;2082us;97us;1308us;98us;1524us;99us;1208us;101us;1966us;103us;1986us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1305us;146us;1992us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1498us;159us;1387us;160us;1183us;161us;1987us;162us;1988us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;183us;1994us;184us;1384us;185us;1381us;186us;1978us;187us;1980us;188us;1434us;189us;1977us;190us;1374us;191us;1975us;192us;1974us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1091us;0us;17224us;9us;32768us;10us;1094us;15us;2091us;37us;2088us;39us;2089us;61us;2090us;94us;2083us;95us;2080us;96us;2082us;204us;1078us;0us;17225us;0us;17226us;0us;17227us;0us;17227us;0us;17228us;0us;17229us;0us;17230us;0us;17231us;0us;17232us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17233us;1us;32768us;78us;1527us;1us;32768us;93us;1528us;1us;16556us;74us;322us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17234us;0us;17235us;0us;17236us;0us;17237us;4us;17237us;94us;17240us;95us;17240us;96us;17240us;103us;17240us;4us;32768us;94us;2083us;95us;2080us;96us;2082us;103us;1538us;0us;17238us;31us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17239us;85us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;55us;1578us;57us;1458us;61us;2075us;62us;2077us;63us;1377us;67us;1420us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1396us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;197us;2078us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1092us;5us;32768us;10us;1094us;61us;2075us;62us;2077us;197us;2078us;204us;1078us;0us;17241us;0us;17242us;0us;17243us;0us;17244us;0us;17245us;0us;17246us;0us;17247us;0us;17248us;0us;17249us;0us;17251us;0us;17253us;81us;32768us;10us;1094us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17254us;86us;32768us;10us;1094us;13us;1206us;15us;2097us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17256us;0us;17257us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;79us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17259us;0us;17260us;1us;32768us;202us;2048us;3us;17266us;37us;2065us;38us;2068us;109us;2069us;0us;17263us;42us;17268us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;78us;1574us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1416us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;1us;32768us;89us;1567us;0us;17261us;0us;17262us;0us;17265us;1us;32768us;93us;1571us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;17267us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1576us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17269us;37us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;94us;2083us;95us;2080us;96us;2082us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1896us;0us;17270us;30us;32768us;47us;1956us;57us;1881us;67us;1875us;89us;632us;92us;1949us;93us;1866us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;2us;17595us;35us;2063us;36us;2062us;30us;17264us;57us;1645us;72us;1504us;73us;1648us;93us;1510us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17291us;2us;17283us;21us;1607us;84us;1608us;0us;17271us;0us;17272us;82us;32768us;10us;1094us;13us;1206us;22us;1053us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17291us;2us;17283us;21us;1607us;84us;1608us;0us;17273us;0us;17274us;80us;17277us;13us;1206us;22us;1053us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17291us;2us;17283us;21us;1607us;84us;1608us;0us;17278us;3us;32768us;47us;1956us;67us;1612us;194us;1955us;0us;17291us;2us;17283us;21us;1607us;84us;1608us;0us;17279us;5us;17283us;21us;1607us;47us;1956us;67us;1612us;84us;1608us;194us;1955us;1us;32768us;20us;1600us;0us;17280us;0us;17291us;2us;17283us;21us;1607us;84us;1608us;1us;32768us;20us;1604us;0us;17281us;0us;17282us;3us;17282us;47us;1956us;67us;1612us;194us;1955us;1us;17284us;84us;1610us;1us;17285us;21us;1609us;0us;17286us;0us;17287us;1us;17288us;77us;1958us;0us;17289us;0us;17290us;8us;17295us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;61us;2095us;70us;1615us;95us;2096us;204us;1078us;87us;17293us;10us;1094us;13us;1206us;15us;2097us;22us;1053us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;37us;2093us;39us;2094us;42us;790us;47us;1450us;57us;1458us;61us;2095us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;95us;2096us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;0us;17292us;0us;17294us;0us;17296us;3us;17564us;21us;2033us;26us;1629us;88us;1627us;1us;17564us;21us;2033us;3us;17309us;14us;600us;112us;599us;204us;1638us;0us;17297us;2us;32768us;14us;600us;112us;599us;0us;17298us;0us;17300us;0us;17303us;3us;16556us;22us;543us;74us;322us;204us;827us;0us;17305us;2us;16556us;74us;322us;204us;827us;1us;32768us;20us;1631us;0us;17306us;3us;17558us;19us;2028us;20us;2029us;143us;2030us;0us;17307us;3us;17309us;14us;600us;112us;599us;204us;1638us;0us;17308us;3us;17309us;14us;600us;112us;599us;204us;1638us;0us;17310us;3us;17309us;14us;600us;112us;599us;204us;1638us;0us;17311us;31us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;8us;17304us;26us;1629us;36us;1777us;47us;1956us;71us;1791us;88us;1627us;92us;1949us;190us;1951us;194us;1955us;3us;17558us;19us;2028us;20us;2029us;143us;2030us;1us;17564us;21us;2033us;0us;17312us;1us;32768us;73us;1648us;0us;17313us;0us;17314us;43us;32768us;10us;1094us;47us;1450us;57us;1458us;66us;2079us;67us;1420us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1093us;3us;32768us;10us;1094us;66us;2079us;204us;1078us;0us;17315us;0us;17316us;0us;17317us;0us;17318us;0us;17319us;35us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;93us;986us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;1us;32768us;99us;1657us;81us;32768us;13us;1206us;22us;1047us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1659us;0us;17320us;0us;17321us;36us;32768us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;67us;506us;71us;972us;72us;975us;75us;978us;93us;986us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1670us;2us;32768us;99us;1662us;204us;1668us;82us;32768us;10us;1094us;13us;1206us;18us;1666us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;204us;1078us;3us;32768us;10us;1094us;20us;1664us;204us;1078us;0us;17322us;0us;17323us;1us;32768us;20us;1667us;0us;17324us;1us;32768us;20us;1669us;0us;17326us;1us;32768us;20us;1671us;0us;17327us;41us;32768us;41us;899us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;59us;897us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1335us;0us;17328us;41us;32768us;41us;899us;44us;520us;45us;519us;46us;521us;47us;509us;57us;993us;59us;897us;67us;506us;71us;972us;72us;975us;74us;322us;75us;978us;82us;952us;93us;986us;98us;1032us;101us;1966us;107us;984us;123us;983us;149us;985us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;194us;1955us;195us;2049us;196us;967us;202us;2048us;203us;872us;204us;1335us;1us;32768us;20us;1676us;0us;17329us;1us;17330us;85us;1678us;32us;32768us;47us;1956us;53us;648us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;664us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;1us;17332us;85us;1680us;32us;32768us;47us;1956us;53us;648us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;664us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;36us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1692us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17335us;0us;17336us;1us;17339us;99us;1685us;36us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1692us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17337us;0us;17338us;1us;17343us;97us;1689us;36us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1698us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17340us;0us;17341us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1698us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17342us;1us;17347us;97us;1695us;36us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1698us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17344us;0us;17345us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;74us;322us;75us;1714us;89us;632us;92us;1949us;93us;1780us;97us;1698us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17346us;32us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;75us;1705us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;1us;17352us;78us;1702us;33us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17348us;0us;17349us;1us;32768us;194us;1955us;1us;32768us;78us;1707us;33us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17350us;0us;17351us;1us;17357us;78us;1711us;33us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17353us;0us;17354us;1us;32768us;194us;1955us;1us;32768us;78us;1716us;33us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17355us;0us;17356us;7us;17361us;36us;1777us;47us;1956us;71us;1791us;92us;1949us;99us;1722us;190us;1951us;194us;1955us;7us;17390us;36us;1777us;47us;1956us;71us;1791us;92us;1949us;99us;1722us;190us;1951us;194us;1955us;7us;32768us;36us;1777us;47us;1956us;71us;1791us;92us;1949us;99us;1722us;190us;1951us;194us;1955us;34us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;99us;1725us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17358us;0us;17359us;31us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17360us;1us;17365us;99us;1728us;36us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;99us;1731us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17362us;0us;17363us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17364us;1us;32768us;10us;1734us;0us;17366us;2us;17374us;97us;1737us;187us;1747us;2us;17374us;97us;1737us;187us;1747us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1754us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1759us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17367us;0us;17368us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1754us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1759us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;33us;17514us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1754us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1759us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17369us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1754us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1759us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;35us;17510us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1754us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1759us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17370us;0us;17371us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1754us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1759us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17372us;0us;17373us;2us;17381us;97us;1751us;187us;1756us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1754us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1759us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17375us;0us;17376us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1754us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1759us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17377us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1754us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1759us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17378us;0us;17379us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1754us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1759us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17380us;2us;17385us;80us;1786us;90us;1762us;30us;32768us;47us;1956us;57us;1881us;67us;1875us;89us;632us;92us;1949us;93us;1876us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;1us;17442us;90us;1764us;30us;32768us;47us;1956us;57us;1881us;67us;1875us;89us;632us;92us;1949us;93us;1876us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;1us;17384us;77us;1958us;0us;17385us;1us;17387us;190us;1769us;4us;17387us;34us;1907us;77us;1904us;161us;1909us;190us;1769us;3us;32768us;63us;885us;93us;881us;179us;880us;0us;17386us;7us;17389us;36us;1777us;41us;1772us;47us;1956us;71us;1791us;92us;1949us;190us;1951us;194us;1955us;1us;32768us;149us;1773us;0us;17388us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1896us;0us;17391us;0us;17392us;1us;32768us;71us;1791us;0us;17393us;0us;17394us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1896us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;4us;32768us;47us;1956us;92us;1949us;190us;1951us;194us;1955us;0us;17395us;0us;17396us;0us;17397us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17398us;1us;17444us;80us;1789us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17399us;2us;32768us;60us;1792us;98us;1793us;0us;17400us;2us;32768us;60us;1794us;98us;1795us;0us;17401us;2us;32768us;60us;1796us;98us;1797us;0us;17402us;2us;32768us;60us;1798us;98us;1799us;0us;17403us;2us;32768us;60us;1800us;98us;1801us;0us;17404us;2us;32768us;60us;1802us;98us;1803us;0us;17405us;2us;32768us;60us;1804us;98us;1805us;0us;17406us;2us;32768us;60us;1806us;98us;1807us;0us;17407us;2us;32768us;60us;1808us;98us;1809us;0us;17408us;2us;32768us;60us;1810us;98us;1811us;0us;17409us;2us;32768us;60us;1812us;98us;1813us;0us;17410us;2us;32768us;60us;1814us;98us;1815us;0us;17411us;2us;32768us;60us;1816us;98us;1817us;0us;17412us;2us;32768us;60us;1818us;98us;1819us;0us;17413us;2us;32768us;60us;1820us;98us;1821us;0us;17414us;2us;32768us;60us;1822us;98us;1823us;0us;17415us;2us;32768us;60us;1824us;98us;1825us;0us;17416us;2us;32768us;60us;1826us;98us;1827us;0us;17417us;2us;32768us;60us;1828us;98us;1829us;0us;17418us;2us;32768us;60us;1830us;98us;1831us;0us;17419us;2us;32768us;60us;1832us;98us;1833us;0us;17420us;2us;32768us;60us;1834us;98us;1835us;0us;17421us;2us;32768us;60us;1836us;98us;1837us;0us;17422us;2us;32768us;60us;1838us;98us;1839us;0us;17423us;2us;32768us;60us;1840us;98us;1841us;0us;17424us;2us;32768us;60us;1842us;98us;1843us;0us;17425us;2us;32768us;60us;1844us;98us;1845us;0us;17426us;2us;32768us;60us;1846us;98us;1847us;0us;17427us;2us;32768us;60us;1848us;98us;1849us;0us;17428us;2us;32768us;60us;1850us;98us;1851us;0us;17429us;2us;32768us;60us;1852us;98us;1853us;0us;17430us;1us;32768us;60us;1854us;0us;17431us;1us;32768us;98us;1856us;33us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17435us;1us;17432us;98us;1860us;4us;32768us;10us;1094us;98us;1860us;162us;1913us;204us;1078us;33us;17476us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17433us;0us;17434us;1us;17436us;190us;1864us;3us;32768us;63us;885us;93us;881us;179us;880us;0us;17437us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1896us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;4us;32768us;47us;1956us;92us;1949us;190us;1951us;194us;1955us;0us;17438us;1us;17439us;77us;1901us;1us;17440us;77us;1901us;0us;17441us;0us;17442us;0us;17443us;0us;17444us;34us;32768us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1896us;5us;32768us;10us;1094us;94us;2083us;95us;2080us;96us;2082us;204us;1078us;6us;17471us;10us;1094us;70us;1922us;94us;2083us;95us;2080us;96us;2082us;204us;1078us;0us;17445us;0us;17446us;1us;32768us;93us;1882us;33us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;3us;32768us;10us;1094us;97us;1884us;204us;1078us;35us;32768us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1754us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1759us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;5us;32768us;10us;1094us;94us;2083us;95us;2080us;96us;2082us;204us;1078us;0us;17447us;0us;17448us;0us;17449us;0us;17450us;0us;17451us;0us;17452us;0us;17453us;40us;32768us;47us;1450us;57us;1458us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;92us;1435us;93us;1512us;101us;1966us;107us;1486us;123us;1485us;137us;1490us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;188us;1433us;194us;1955us;195us;2049us;196us;1540us;200us;2057us;201us;2060us;202us;2048us;203us;872us;0us;17455us;0us;17456us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;17457us;1us;17457us;78us;17499us;0us;17458us;2us;32768us;47us;1956us;194us;1955us;3us;17459us;34us;1907us;77us;1958us;161us;1909us;0us;17460us;7us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;61us;2095us;95us;2096us;204us;1078us;0us;17461us;0us;17462us;1us;32768us;161us;1909us;0us;17463us;36us;17476us;10us;1094us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;162us;1919us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;1us;32768us;98us;1911us;40us;17476us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;47us;1956us;57us;587us;61us;2095us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;95us;2096us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;204us;1078us;0us;17435us;0us;17464us;0us;17465us;0us;17466us;8us;17474us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;61us;2095us;95us;2096us;162us;1917us;204us;1078us;0us;17467us;0us;17468us;0us;17469us;0us;17470us;1us;17471us;70us;1922us;33us;17473us;47us;1956us;57us;587us;67us;1788us;73us;590us;89us;632us;92us;1949us;93us;1780us;97us;1740us;107us;1895us;114us;1893us;123us;1894us;149us;1892us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;187us;1743us;190us;1951us;194us;1955us;195us;2049us;202us;2048us;203us;872us;0us;17472us;0us;17474us;0us;17475us;8us;32768us;47us;1956us;67us;1929us;92us;1949us;93us;1933us;179us;1939us;187us;1948us;190us;1951us;194us;1955us;3us;32768us;97us;1946us;162us;1928us;187us;1947us;0us;17477us;1us;32768us;162us;1930us;0us;17478us;1us;17479us;77us;1958us;0us;17480us;7us;32768us;47us;1956us;92us;1949us;93us;1933us;179us;1939us;187us;1948us;190us;1951us;194us;1955us;5us;32768us;94us;2083us;95us;2080us;96us;2082us;97us;1946us;187us;1947us;0us;17481us;1us;17482us;190us;1937us;3us;32768us;63us;885us;93us;881us;179us;880us;0us;17483us;0us;17484us;6us;17485us;47us;1956us;92us;1949us;93us;1933us;179us;1939us;190us;1951us;194us;1955us;0us;17486us;0us;17487us;0us;17488us;0us;17489us;0us;17490us;7us;32768us;47us;1956us;92us;1949us;93us;1933us;179us;1939us;187us;1948us;190us;1951us;194us;1955us;7us;32768us;47us;1956us;92us;1949us;93us;1933us;179us;1939us;187us;1948us;190us;1951us;194us;1955us;7us;32768us;47us;1956us;92us;1949us;93us;1933us;179us;1939us;187us;1948us;190us;1951us;194us;1955us;1us;32768us;194us;1955us;0us;17491us;1us;32768us;194us;1955us;1us;17506us;194us;1955us;0us;17492us;81us;17492us;10us;17539us;15us;17539us;21us;17539us;28us;17539us;34us;17539us;35us;17539us;36us;17539us;37us;17539us;39us;17539us;47us;17539us;57us;17539us;61us;17539us;63us;17539us;64us;17539us;67us;17539us;69us;17539us;70us;17539us;71us;17539us;72us;17539us;73us;17539us;75us;17539us;77us;17539us;79us;17539us;80us;17539us;81us;17539us;82us;17539us;83us;17539us;84us;17539us;90us;17539us;91us;17539us;92us;17539us;93us;17539us;97us;17539us;98us;17539us;101us;17539us;105us;17539us;107us;17539us;123us;17539us;129us;17539us;137us;17539us;144us;17539us;146us;17539us;149us;17539us;150us;17539us;155us;17539us;156us;17539us;159us;17539us;161us;17539us;162us;17539us;167us;17539us;168us;17539us;169us;17539us;170us;17539us;171us;17539us;172us;17539us;173us;17539us;174us;17539us;175us;17539us;176us;17539us;177us;17539us;178us;17539us;179us;17539us;181us;17539us;182us;17539us;184us;17539us;185us;17539us;186us;17539us;187us;17539us;188us;17539us;189us;17539us;190us;17539us;191us;17539us;192us;17539us;194us;17539us;195us;17539us;196us;17539us;200us;17539us;201us;17539us;202us;17539us;203us;17539us;204us;17539us;0us;17493us;0us;17494us;0us;17495us;8us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;61us;2095us;95us;2096us;194us;1955us;204us;1078us;0us;17496us;0us;17497us;27us;32768us;59us;2001us;63us;1983us;64us;1981us;70us;1985us;75us;1989us;83us;1993us;90us;1990us;91us;1991us;97us;1984us;103us;1986us;144us;1996us;146us;1992us;156us;1998us;159us;1995us;161us;1987us;162us;1988us;183us;1994us;184us;1982us;185us;1979us;186us;1978us;187us;1980us;188us;1973us;189us;1977us;190us;1976us;191us;1975us;192us;1974us;204us;1964us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;17498us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;17499us;0us;17500us;1us;32768us;59us;1968us;5us;32768us;67us;1970us;94us;2083us;95us;2080us;96us;2082us;194us;2000us;0us;17501us;1us;32768us;59us;1971us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;17502us;0us;17503us;0us;17504us;0us;17505us;0us;17506us;0us;17507us;0us;17508us;0us;17509us;0us;17510us;0us;17511us;0us;17512us;0us;17513us;0us;17514us;0us;17515us;0us;17516us;0us;17517us;0us;17518us;0us;17519us;0us;17520us;0us;17521us;0us;17522us;0us;17523us;0us;17524us;0us;17525us;1us;17526us;144us;1997us;0us;17527us;1us;32768us;157us;1999us;0us;17528us;0us;17529us;1us;32768us;194us;2000us;0us;17530us;0us;17531us;0us;17532us;0us;17533us;1us;17534us;77us;2008us;0us;17535us;10us;32768us;10us;1094us;15us;2097us;37us;2093us;39us;2094us;61us;2095us;93us;1961us;95us;2096us;101us;1966us;194us;1955us;204us;1078us;0us;17536us;0us;17537us;0us;17538us;0us;17539us;0us;17540us;0us;17541us;0us;17542us;0us;17543us;3us;17544us;21us;2016us;68us;2015us;84us;2014us;0us;17545us;3us;17547us;21us;2016us;68us;2015us;84us;2014us;0us;17546us;1us;17548us;84us;2023us;1us;17549us;21us;2024us;0us;17550us;0us;17551us;0us;17552us;0us;17553us;0us;17554us;0us;17555us;0us;17556us;0us;17557us;0us;17559us;0us;17561us;0us;17563us;0us;17565us;0us;17567us;0us;17569us;0us;17571us;0us;17573us;0us;17574us;0us;17575us;0us;17576us;0us;17577us;0us;17578us;0us;17579us;0us;17580us;0us;17581us;0us;17582us;0us;17583us;0us;17584us;1us;32768us;194us;1955us;0us;17586us;0us;17587us;81us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;198us;2052us;199us;2053us;200us;2057us;201us;2060us;202us;2048us;203us;872us;2us;32768us;198us;2052us;199us;2053us;0us;17588us;0us;17589us;81us;32768us;13us;1206us;24us;1660us;25us;1674us;29us;1203us;30us;780us;32us;1190us;33us;776us;42us;790us;47us;1450us;57us;1458us;63us;1377us;67us;1419us;71us;1452us;72us;1504us;73us;1648us;75us;1445us;86us;1148us;87us;1150us;90us;1389us;91us;1392us;92us;1435us;93us;1512us;97us;1307us;99us;1208us;101us;1966us;107us;1486us;108us;1127us;115us;1140us;116us;1144us;117us;1119us;118us;1123us;120us;1395us;123us;1485us;124us;1152us;125us;1655us;126us;1672us;127us;1135us;131us;1198us;134us;1142us;135us;1146us;137us;1490us;144us;1304us;147us;1407us;148us;1409us;149us;1484us;150us;1439us;155us;1442us;156us;1497us;159us;1386us;160us;1183us;163us;770us;164us;1177us;165us;1179us;167us;869us;168us;868us;169us;867us;170us;866us;171us;865us;172us;864us;173us;862us;174us;860us;175us;858us;176us;856us;177us;863us;178us;861us;179us;859us;181us;857us;182us;855us;184us;1383us;185us;1380us;188us;1433us;190us;1372us;194us;1955us;195us;2049us;196us;1540us;198us;2052us;199us;2053us;200us;2057us;201us;2060us;202us;2048us;203us;872us;2us;32768us;198us;2052us;199us;2053us;0us;17590us;0us;17591us;0us;17592us;0us;17593us;0us;17594us;0us;17596us;3us;32768us;37us;2065us;38us;2068us;109us;2069us;3us;17619us;37us;2065us;38us;2068us;109us;2069us;0us;17598us;0us;17599us;0us;17600us;3us;32768us;39us;2070us;40us;2073us;151us;2074us;3us;17620us;39us;2070us;40us;2073us;151us;2074us;0us;17601us;0us;17602us;0us;17603us;3us;32768us;61us;2075us;62us;2077us;197us;2078us;0us;17604us;0us;17605us;0us;17606us;0us;17607us;3us;32768us;94us;2083us;95us;2080us;96us;2082us;0us;17608us;0us;17609us;0us;17610us;3us;32768us;15us;2084us;16us;2086us;17us;2087us;0us;17611us;0us;17612us;0us;17613us;0us;17614us;0us;17615us;0us;17616us;0us;17617us;0us;17618us;0us;17619us;0us;17620us;0us;17621us;0us;17622us;0us;17623us;0us;17624us;|]
let _fsyacc_actionTableRowOffsets = [|0us;17us;18us;114us;115us;123us;124us;204us;205us;239us;240us;241us;242us;243us;244us;245us;246us;251us;252us;257us;258us;263us;264us;270us;271us;277us;278us;284us;285us;302us;303us;307us;395us;422us;423us;426us;427us;428us;429us;431us;432us;439us;440us;441us;442us;444us;445us;446us;449us;450us;452us;453us;458us;459us;461us;465us;467us;473us;475us;476us;477us;479us;484us;486us;487us;489us;490us;492us;493us;495us;512us;513us;517us;526us;545us;546us;547us;548us;564us;570us;572us;573us;574us;581us;582us;583us;587us;605us;609us;625us;626us;630us;635us;636us;637us;638us;642us;651us;655us;661us;662us;663us;664us;666us;668us;669us;670us;671us;673us;675us;677us;681us;685us;688us;690us;725us;727us;728us;809us;836us;916us;946us;948us;949us;958us;962us;963us;979us;981us;985us;986us;1002us;1004us;1005us;1007us;1009us;1010us;1013us;1021us;1022us;1023us;1079us;1081us;1096us;1098us;1102us;1104us;1105us;1107us;1108us;1109us;1110us;1112us;1147us;1148us;1149us;1166us;1170us;1171us;1172us;1174us;1175us;1190us;1196us;1197us;1198us;1214us;1218us;1219us;1220us;1235us;1241us;1242us;1243us;1244us;1245us;1248us;1263us;1264us;1268us;1272us;1283us;1331us;1333us;1337us;1341us;1344us;1346us;1381us;1384us;1386us;1387us;1419us;1426us;1460us;1467us;1468us;1470us;1471us;1478us;1480us;1481us;1483us;1484us;1486us;1521us;1522us;1527us;1528us;1533us;1536us;1537us;1538us;1542us;1544us;1550us;1554us;1555us;1556us;1560us;1562us;1563us;1564us;1565us;1567us;1568us;1584us;1588us;1589us;1592us;1593us;1595us;1596us;1601us;1602us;1604us;1605us;1607us;1608us;1610us;1706us;1707us;1712us;1800us;1897us;1898us;1899us;1994us;2000us;2002us;2003us;2004us;2011us;2012us;2013us;2014us;2019us;2107us;2137us;2232us;2233us;2234us;2235us;2257us;2258us;2353us;2354us;2358us;2362us;2369us;2374us;2379us;2380us;2381us;2382us;2386us;2398us;2399us;2401us;2402us;2483us;2484us;2486us;2488us;2489us;2490us;2493us;2499us;2500us;2501us;2504us;2505us;2506us;2514us;2516us;2517us;2551us;2558us;2559us;2564us;2565us;2567us;2574us;2580us;2581us;2582us;2588us;2589us;2590us;2591us;2592us;2594us;2689us;2693us;2694us;2695us;2696us;2703us;2707us;2708us;2709us;2711us;2712us;2727us;2730us;2739us;2741us;2742us;2744us;2746us;2747us;2748us;2749us;2750us;2760us;2761us;2765us;2796us;2797us;2801us;2805us;2836us;2837us;2840us;2845us;2848us;2879us;2880us;2882us;2883us;2885us;2886us;2888us;2889us;2891us;2892us;2904us;2905us;2906us;2907us;2908us;2912us;2914us;2915us;2917us;2919us;2920us;2960us;2961us;2965us;2968us;2970us;2972us;2976us;2983us;2984us;2985us;2995us;2997us;3005us;3007us;3013us;3015us;3016us;3017us;3018us;3020us;3021us;3022us;3023us;3025us;3060us;3061us;3062us;3073us;3082us;3083us;3084us;3094us;3095us;3097us;3103us;3104us;3105us;3112us;3118us;3119us;3120us;3121us;3122us;3137us;3138us;3141us;3156us;3157us;3159us;3160us;3162us;3165us;3166us;3167us;3169us;3171us;3172us;3174us;3212us;3214us;3216us;3297us;3298us;3336us;3338us;3350us;3431us;3432us;3433us;3434us;3435us;3437us;3438us;3440us;3441us;3445us;3449us;3465us;3518us;3519us;3520us;3525us;3527us;3528us;3529us;3563us;3571us;3572us;3573us;3577us;3579us;3583us;3586us;3588us;3623us;3626us;3628us;3629us;3630us;3632us;3633us;3635us;3636us;3638us;3639us;3677us;3679us;3689us;3770us;3772us;3773us;3774us;3775us;3777us;3778us;3780us;3781us;3783us;3787us;3791us;3795us;3831us;3832us;3833us;3834us;3835us;3837us;3841us;3845us;3847us;3857us;3938us;3941us;3942us;3943us;3944us;3945us;3981us;3982us;3983us;3985us;3989us;3990us;3992us;3996us;3997us;3998us;4003us;4005us;4009us;4010us;4011us;4012us;4013us;4014us;4015us;4047us;4051us;4052us;4059us;4063us;4064us;4102us;4136us;4137us;4168us;4170us;4171us;4172us;4173us;4177us;4178us;4179us;4180us;4183us;4184us;4185us;4187us;4193us;4194us;4195us;4196us;4199us;4214us;4215us;4220us;4226us;4231us;4233us;4234us;4236us;4237us;4238us;4240us;4242us;4243us;4245us;4246us;4247us;4248us;4252us;4290us;4293us;4295us;4298us;4299us;4300us;4301us;4302us;4362us;4393us;4395us;4399us;4400us;4406us;4412us;4413us;4414us;4418us;4419us;4420us;4423us;4424us;4425us;4428us;4432us;4433us;4434us;4436us;4437us;4438us;4439us;4440us;4441us;4442us;4450us;4454us;4457us;4459us;4460us;4461us;4462us;4464us;4469us;4470us;4473us;4475us;4477us;4480us;4481us;4482us;4485us;4487us;4518us;4520us;4522us;4524us;4526us;4527us;4528us;4530us;4534us;4536us;4538us;4539us;4540us;4571us;4573us;4606us;4608us;4610us;4612us;4645us;4646us;4647us;4649us;4651us;4682us;4684us;4686us;4688us;4690us;4693us;4695us;4729us;4730us;4734us;4768us;4773us;4779us;4780us;4785us;4786us;4787us;4788us;4790us;4794us;4795us;4830us;4835us;4837us;4839us;4841us;4845us;4846us;4849us;4850us;4851us;4858us;4890us;4897us;4912us;4914us;4915us;4917us;4919us;4920us;4923us;4924us;4926us;4928us;4929us;4933us;4940us;4977us;4978us;5014us;5015us;5016us;5052us;5053us;5054us;5055us;5090us;5091us;5134us;5140us;5141us;5142us;5172us;5176us;5177us;5179us;5183us;5184us;5190us;5191us;5234us;5241us;5288us;5290us;5337us;5338us;5374us;5375us;5377us;5412us;5413us;5414us;5448us;5449us;5451us;5486us;5487us;5488us;5521us;5522us;5524us;5558us;5559us;5560us;5561us;5562us;5563us;5564us;5565us;5568us;5574us;5575us;5576us;5578us;5579us;5583us;5587us;5591us;5627us;5628us;5629us;5630us;5631us;5633us;5634us;5636us;5640us;5644us;5646us;5647us;5648us;5650us;5686us;5687us;5688us;5691us;5693us;5695us;5698us;5699us;5700us;5781us;5782us;5784us;5787us;5791us;5792us;5874us;5878us;5879us;5880us;5881us;5882us;5883us;5884us;5885us;5886us;5888us;5892us;5894us;5897us;5899us;5904us;5908us;5909us;5911us;5913us;5915us;5916us;5918us;5919us;5923us;5931us;5932us;5934us;5941us;5943us;5945us;5946us;5947us;5949us;5950us;5951us;5953us;5955us;5956us;5960us;5962us;5963us;5966us;5968us;5969us;5971us;5972us;5973us;5975us;6013us;6015us;6019us;6101us;6102us;6103us;6104us;6184us;6190us;6191us;6192us;6193us;6194us;6196us;6197us;6200us;6203us;6284us;6285us;6288us;6289us;6290us;6293us;6327us;6328us;6329us;6330us;6331us;6332us;6333us;6334us;6335us;6336us;6337us;6338us;6339us;6340us;6341us;6342us;6343us;6344us;6345us;6346us;6347us;6349us;6351us;6352us;6354us;6356us;6358us;6359us;6360us;6363us;6367us;6368us;6369us;6372us;6373us;6375us;6377us;6378us;6385us;6386us;6428us;6439us;6440us;6441us;6442us;6445us;6448us;6449us;6453us;6455us;6458us;6461us;6464us;6466us;6468us;6476us;6484us;6492us;6500us;6539us;6540us;6541us;6579us;6622us;6623us;6625us;6626us;6627us;6672us;6717us;6718us;6719us;6764us;6765us;6803us;6841us;6844us;6845us;6849us;6850us;6852us;6853us;6857us;6862us;6903us;6911us;6912us;6913us;6953us;6991us;6992us;7028us;7029us;7065us;7066us;7067us;7103us;7104us;7140us;7141us;7175us;7176us;7177us;7178us;7243us;7247us;7248us;7249us;7287us;7288us;7324us;7325us;7361us;7362us;7363us;7367us;7371us;7372us;7376us;7377us;7416us;7418us;7419us;7458us;7460us;7461us;7463us;7465us;7466us;7467us;7468us;7469us;7470us;7471us;7536us;7542us;7543us;7544us;7548us;7551us;7552us;7554us;7595us;7602us;7603us;7604us;7608us;7609us;7610us;7618us;7623us;7627us;7630us;7634us;7638us;7642us;7645us;7653us;7656us;7664us;7674us;7691us;7700us;7739us;7740us;7741us;7780us;7782us;7784us;7820us;7821us;7822us;7861us;7901us;7902us;7903us;7949us;7995us;7996us;7997us;8043us;8044us;8083us;8122us;8125us;8126us;8129us;8130us;8135us;8176us;8177us;8178us;8179us;8218us;8219us;8302us;8308us;8309us;8310us;8311us;8312us;8395us;8399us;8400us;8401us;8428us;8430us;8431us;8432us;8527us;8529us;8565us;8566us;8567us;8569us;8570us;8601us;8681us;8682us;8762us;8763us;8765us;8845us;8849us;8850us;8933us;8934us;8937us;8940us;8943us;8946us;8949us;8950us;8953us;8955us;8957us;8959us;8961us;8965us;8969us;8973us;8975us;8976us;9014us;9095us;9097us;9100us;9101us;9139us;9220us;9224us;9226us;9229us;9230us;9232us;9313us;9314us;9315us;9398us;9399us;9400us;9482us;9483us;9484us;9485us;9486us;9487us;9567us;9572us;9573us;9574us;9654us;9659us;9660us;9661us;9744us;9750us;9751us;9752us;9755us;9756us;9837us;9838us;9920us;9951us;9952us;9953us;9954us;10034us;10035us;10104us;10105us;10186us;10187us;10257us;10258us;10340us;10341us;10423us;10424us;10470us;10481us;10569us;10579us;10580us;10581us;10582us;10583us;10584us;10586us;10587us;10592us;10675us;10680us;10681us;10682us;10683us;10684us;10685us;10766us;10769us;10770us;10771us;10772us;10773us;10855us;10882us;10964us;10991us;10992us;10993us;11031us;11112us;11114us;11116us;11119us;11200us;11201us;11239us;11320us;11324us;11326us;11330us;11411us;11412us;11413us;11493us;11495us;11497us;11578us;11579us;11660us;11664us;11665us;11745us;11772us;11854us;11855us;11882us;11903us;11924us;11934us;11955us;11974us;11993us;12003us;12013us;12023us;12033us;12043us;12053us;12063us;12065us;12074us;12079us;12084us;12086us;12088us;12090us;12114us;12139us;12170us;12197us;12224us;12251us;12282us;12307us;12332us;12357us;12384us;12409us;12439us;12466us;12495us;12522us;12550us;12586us;12587us;12588us;12624us;12625us;12626us;12662us;12663us;12664us;12744us;12746us;12827us;12828us;12830us;12837us;12924us;12925us;13012us;13013us;13100us;13101us;13188us;13189us;13276us;13277us;13364us;13365us;13452us;13453us;13540us;13541us;13628us;13629us;13716us;13717us;13804us;13805us;13892us;13893us;13980us;13981us;14068us;14069us;14156us;14157us;14244us;14245us;14332us;14333us;14420us;14421us;14508us;14509us;14596us;14597us;14674us;14754us;14834us;14914us;14915us;14916us;14998us;15003us;15004us;15005us;15008us;15009us;15010us;15011us;15012us;15013us;15093us;15097us;15098us;15140us;15141us;15184us;15188us;15189us;15190us;15191us;15192us;15232us;15233us;15272us;15273us;15274us;15275us;15276us;15280us;15285us;15326us;15327us;15366us;15367us;15406us;15407us;15408us;15409us;15410us;15490us;15572us;15573us;15577us;15578us;15660us;15661us;15744us;15745us;15746us;15826us;15907us;15908us;15988us;15989us;15990us;16078us;16079us;16166us;16167us;16255us;16256us;16343us;16344us;16395us;16446us;16497us;16548us;16549us;16600us;16651us;16652us;16703us;16754us;16755us;16806us;16857us;16858us;16909us;16960us;16961us;17012us;17063us;17064us;17115us;17166us;17167us;17199us;17231us;17234us;17272us;17304us;17336us;17338us;17345us;17353us;17354us;17355us;17356us;17407us;17408us;17459us;17460us;17502us;17547us;17592us;17593us;17599us;17640us;17646us;17652us;17656us;17661us;17704us;17710us;17711us;17712us;17715us;17717us;17723us;17729us;17770us;17811us;17813us;17814us;17855us;17896us;17898us;17900us;17901us;17902us;17903us;17911us;17912us;17914us;17922us;17923us;17927us;17931us;17932us;17935us;17936us;17937us;17938us;18020us;18024us;18025us;18026us;18027us;18028us;18031us;18111us;18112us;18113us;18114us;18115us;18116us;18117us;18213us;18217us;18219us;18221us;18222us;18226us;18227us;18309us;18313us;18314us;18315us;18316us;18317us;18318us;18319us;18320us;18321us;18322us;18323us;18324us;18325us;18326us;18327us;18328us;18410us;18414us;18415us;18416us;18418us;18419us;18420us;18502us;18585us;18589us;18590us;18591us;18592us;18593us;18675us;18679us;18680us;18681us;18682us;18683us;18774us;18879us;18984us;18985us;18995us;18996us;18997us;18998us;18999us;19000us;19001us;19002us;19003us;19004us;19084us;19085us;19087us;19089us;19091us;19095us;19175us;19176us;19177us;19178us;19179us;19184us;19189us;19190us;19222us;19223us;19309us;19315us;19316us;19317us;19318us;19319us;19320us;19321us;19322us;19323us;19324us;19325us;19326us;19408us;19409us;19496us;19497us;19498us;19578us;19658us;19659us;19660us;19662us;19666us;19667us;19710us;19712us;19713us;19714us;19715us;19717us;19751us;19755us;19756us;19790us;19791us;19829us;19830us;19861us;19864us;19895us;19896us;19899us;19900us;19901us;19984us;19985us;19988us;19989us;19990us;20071us;20072us;20075us;20076us;20080us;20081us;20084us;20085us;20091us;20093us;20094us;20095us;20098us;20100us;20101us;20102us;20106us;20108us;20110us;20111us;20112us;20114us;20115us;20116us;20125us;20213us;20214us;20215us;20216us;20220us;20222us;20226us;20227us;20230us;20231us;20232us;20233us;20237us;20238us;20241us;20243us;20244us;20248us;20249us;20253us;20254us;20258us;20259us;20263us;20264us;20296us;20305us;20309us;20311us;20312us;20314us;20315us;20316us;20360us;20364us;20365us;20366us;20367us;20368us;20369us;20405us;20407us;20489us;20490us;20491us;20528us;20531us;20614us;20618us;20619us;20620us;20622us;20623us;20625us;20626us;20628us;20629us;20671us;20672us;20714us;20716us;20717us;20719us;20752us;20754us;20787us;20824us;20825us;20826us;20828us;20865us;20866us;20867us;20869us;20906us;20907us;20908us;20943us;20944us;20946us;20983us;20984us;20985us;21020us;21021us;21054us;21056us;21090us;21091us;21092us;21094us;21096us;21130us;21131us;21132us;21134us;21168us;21169us;21170us;21172us;21174us;21208us;21209us;21210us;21218us;21226us;21234us;21269us;21270us;21271us;21303us;21304us;21306us;21343us;21344us;21345us;21379us;21380us;21382us;21383us;21386us;21389us;21425us;21426us;21427us;21461us;21495us;21496us;21532us;21568us;21569us;21570us;21606us;21607us;21608us;21611us;21647us;21648us;21649us;21683us;21684us;21720us;21721us;21722us;21756us;21757us;21760us;21791us;21793us;21824us;21826us;21827us;21829us;21834us;21838us;21839us;21847us;21849us;21850us;21885us;21886us;21887us;21889us;21890us;21891us;21926us;21930us;21935us;21936us;21937us;21938us;21972us;21973us;21975us;22009us;22010us;22013us;22014us;22017us;22018us;22021us;22022us;22025us;22026us;22029us;22030us;22033us;22034us;22037us;22038us;22041us;22042us;22045us;22046us;22049us;22050us;22053us;22054us;22057us;22058us;22061us;22062us;22065us;22066us;22069us;22070us;22073us;22074us;22077us;22078us;22081us;22082us;22085us;22086us;22089us;22090us;22093us;22094us;22097us;22098us;22101us;22102us;22105us;22106us;22109us;22110us;22113us;22114us;22117us;22118us;22121us;22122us;22125us;22126us;22129us;22130us;22133us;22134us;22136us;22137us;22139us;22173us;22174us;22176us;22181us;22215us;22216us;22217us;22219us;22223us;22224us;22259us;22263us;22268us;22269us;22271us;22273us;22274us;22275us;22276us;22277us;22312us;22318us;22325us;22326us;22327us;22329us;22363us;22367us;22403us;22409us;22410us;22411us;22412us;22413us;22414us;22415us;22416us;22457us;22458us;22459us;22463us;22467us;22468us;22470us;22471us;22474us;22478us;22479us;22487us;22488us;22489us;22491us;22492us;22529us;22531us;22572us;22573us;22574us;22575us;22576us;22585us;22586us;22587us;22588us;22589us;22591us;22625us;22626us;22627us;22628us;22637us;22641us;22642us;22644us;22645us;22647us;22648us;22656us;22662us;22663us;22665us;22669us;22670us;22671us;22678us;22679us;22680us;22681us;22682us;22683us;22691us;22699us;22707us;22709us;22710us;22712us;22714us;22715us;22797us;22798us;22799us;22800us;22809us;22810us;22811us;22839us;22843us;22844us;22848us;22849us;22850us;22852us;22858us;22859us;22861us;22865us;22866us;22867us;22868us;22869us;22870us;22871us;22872us;22873us;22874us;22875us;22876us;22877us;22878us;22879us;22880us;22881us;22882us;22883us;22884us;22885us;22886us;22887us;22888us;22889us;22891us;22892us;22894us;22895us;22896us;22898us;22899us;22900us;22901us;22902us;22904us;22905us;22916us;22917us;22918us;22919us;22920us;22921us;22922us;22923us;22924us;22928us;22929us;22933us;22934us;22936us;22938us;22939us;22940us;22941us;22942us;22943us;22944us;22945us;22946us;22947us;22948us;22949us;22950us;22951us;22952us;22953us;22954us;22955us;22956us;22957us;22958us;22959us;22960us;22961us;22962us;22963us;22964us;22965us;22967us;22968us;22969us;23051us;23054us;23055us;23056us;23138us;23141us;23142us;23143us;23144us;23145us;23146us;23147us;23151us;23155us;23156us;23157us;23158us;23162us;23166us;23167us;23168us;23169us;23173us;23174us;23175us;23176us;23177us;23181us;23182us;23183us;23184us;23188us;23189us;23190us;23191us;23192us;23193us;23194us;23195us;23196us;23197us;23198us;23199us;23200us;23201us;|]
let _fsyacc_reductionSymbolCounts = [|1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;2us;2us;2us;3us;3us;3us;1us;2us;3us;1us;1us;2us;1us;1us;3us;0us;2us;1us;1us;1us;1us;1us;2us;3us;2us;5us;5us;5us;3us;3us;1us;2us;2us;1us;3us;4us;1us;1us;4us;3us;3us;1us;1us;0us;3us;3us;2us;1us;1us;5us;5us;4us;5us;3us;1us;12us;0us;2us;5us;3us;5us;3us;3us;0us;3us;2us;7us;2us;1us;1us;3us;1us;3us;3us;3us;3us;3us;3us;3us;3us;3us;1us;1us;0us;3us;11us;4us;4us;4us;4us;5us;5us;5us;0us;2us;3us;3us;2us;5us;4us;3us;1us;1us;2us;3us;0us;2us;3us;2us;1us;2us;2us;1us;3us;4us;1us;4us;3us;3us;1us;1us;0us;5us;4us;3us;1us;2us;2us;3us;1us;2us;3us;1us;1us;3us;3us;3us;5us;3us;5us;4us;2us;1us;2us;2us;3us;3us;3us;1us;3us;3us;3us;3us;3us;1us;1us;3us;3us;3us;3us;1us;0us;1us;2us;5us;4us;4us;2us;1us;3us;3us;4us;6us;2us;2us;2us;2us;2us;1us;1us;1us;1us;3us;3us;0us;1us;2us;8us;7us;7us;6us;2us;2us;1us;1us;3us;1us;3us;3us;3us;3us;3us;3us;3us;1us;1us;2us;0us;3us;2us;3us;3us;1us;3us;6us;5us;4us;4us;4us;1us;2us;2us;3us;3us;4us;5us;4us;5us;4us;11us;3us;4us;5us;5us;8us;6us;6us;5us;5us;6us;6us;5us;4us;8us;6us;6us;4us;0us;2us;2us;3us;3us;1us;4us;2us;0us;1us;1us;1us;1us;3us;1us;0us;3us;0us;3us;5us;2us;1us;0us;2us;2us;1us;0us;2us;2us;3us;3us;1us;3us;2us;4us;4us;3us;4us;2us;1us;1us;6us;3us;3us;3us;7us;3us;3us;3us;2us;2us;1us;3us;3us;3us;1us;1us;1us;1us;1us;2us;3us;3us;2us;1us;3us;3us;1us;2us;4us;5us;3us;1us;0us;5us;1us;0us;2us;0us;2us;3us;1us;3us;3us;1us;1us;4us;3us;3us;4us;3us;4us;5us;7us;4us;4us;3us;1us;3us;1us;2us;3us;1us;1us;3us;1us;3us;3us;5us;4us;4us;4us;5us;5us;5us;5us;1us;3us;4us;2us;4us;4us;2us;3us;3us;3us;2us;4us;4us;3us;3us;2us;1us;3us;3us;1us;3us;1us;1us;1us;3us;2us;2us;5us;5us;4us;3us;2us;5us;4us;1us;3us;3us;0us;2us;3us;1us;2us;4us;3us;2us;1us;1us;1us;1us;1us;1us;8us;1us;1us;0us;3us;3us;2us;3us;1us;4us;2us;3us;2us;2us;2us;2us;2us;3us;0us;2us;1us;6us;6us;5us;3us;3us;1us;2us;2us;0us;4us;3us;1us;3us;2us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;3us;4us;1us;2us;1us;3us;1us;2us;1us;3us;1us;1us;0us;3us;2us;1us;1us;3us;3us;2us;3us;3us;3us;2us;1us;1us;1us;3us;3us;3us;3us;2us;2us;3us;3us;2us;3us;4us;3us;3us;2us;2us;3us;4us;4us;2us;3us;3us;2us;2us;1us;1us;3us;1us;2us;3us;3us;1us;1us;3us;3us;3us;3us;1us;2us;1us;1us;1us;1us;1us;3us;3us;3us;2us;4us;4us;4us;3us;1us;0us;3us;3us;2us;3us;1us;1us;3us;3us;2us;3us;3us;2us;1us;3us;3us;3us;3us;2us;2us;3us;3us;2us;3us;3us;3us;2us;0us;2us;3us;3us;3us;2us;1us;3us;2us;1us;2us;1us;1us;3us;3us;1us;2us;3us;2us;1us;3us;5us;1us;1us;1us;6us;7us;0us;3us;3us;2us;2us;3us;3us;1us;1us;1us;3us;3us;3us;3us;3us;3us;2us;3us;4us;3us;3us;2us;2us;2us;1us;2us;2us;1us;2us;2us;5us;5us;5us;4us;3us;4us;5us;5us;5us;4us;3us;5us;2us;4us;3us;2us;2us;2us;2us;8us;8us;7us;5us;3us;2us;2us;3us;3us;3us;3us;3us;3us;3us;3us;1us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;3us;2us;2us;1us;1us;4us;4us;4us;2us;1us;2us;1us;3us;2us;3us;3us;2us;1us;2us;3us;2us;1us;2us;2us;4us;5us;4us;4us;3us;2us;2us;0us;2us;2us;2us;2us;2us;2us;0us;2us;2us;3us;3us;3us;3us;4us;4us;3us;3us;4us;4us;2us;2us;2us;2us;2us;2us;2us;6us;4us;4us;2us;2us;2us;1us;2us;1us;2us;1us;3us;3us;2us;3us;3us;3us;2us;2us;1us;3us;3us;2us;3us;1us;1us;3us;3us;3us;2us;4us;4us;1us;1us;1us;0us;1us;5us;3us;3us;3us;3us;2us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;3us;3us;3us;2us;3us;3us;3us;2us;3us;3us;3us;2us;2us;3us;3us;3us;2us;2us;2us;2us;2us;4us;6us;1us;1us;1us;3us;3us;1us;3us;3us;3us;2us;2us;1us;1us;1us;1us;0us;1us;0us;1us;2us;3us;3us;2us;5us;1us;1us;6us;2us;0us;0us;1us;0us;4us;0us;2us;3us;6us;1us;5us;3us;1us;1us;2us;5us;5us;4us;6us;1us;0us;1us;1us;2us;2us;1us;1us;3us;0us;3us;2us;3us;1us;2us;4us;3us;2us;5us;4us;2us;1us;0us;2us;3us;3us;2us;0us;2us;2us;5us;2us;1us;3us;3us;3us;2us;2us;4us;4us;5us;5us;5us;4us;4us;3us;2us;3us;1us;3us;1us;3us;0us;2us;2us;3us;3us;1us;3us;3us;2us;1us;3us;3us;2us;1us;4us;4us;5us;5us;2us;3us;3us;4us;4us;1us;3us;3us;4us;3us;3us;3us;4us;1us;2us;3us;3us;2us;2us;2us;3us;3us;1us;3us;3us;2us;3us;3us;2us;1us;3us;3us;1us;1us;3us;1us;3us;1us;1us;3us;2us;3us;2us;4us;1us;1us;3us;3us;2us;3us;4us;5us;6us;7us;8us;9us;10us;11us;12us;13us;14us;15us;16us;17us;18us;19us;20us;21us;22us;23us;24us;25us;26us;27us;28us;29us;30us;31us;32us;33us;4us;3us;3us;0us;1us;3us;4us;1us;1us;1us;1us;1us;1us;3us;3us;6us;6us;5us;4us;3us;1us;1us;2us;1us;1us;3us;2us;3us;4us;3us;1us;2us;6us;6us;4us;3us;3us;2us;2us;1us;3us;2us;1us;1us;0us;3us;3us;1us;1us;3us;1us;3us;1us;1us;2us;1us;3us;3us;2us;2us;2us;1us;1us;1us;3us;3us;3us;3us;1us;4us;6us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;2us;2us;1us;2us;3us;1us;1us;1us;1us;3us;3us;1us;1us;1us;1us;1us;1us;1us;2us;2us;0us;1us;1us;2us;2us;1us;1us;1us;1us;1us;1us;0us;1us;0us;1us;0us;1us;0us;1us;0us;1us;0us;1us;0us;1us;0us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;3us;1us;3us;2us;3us;1us;2us;1us;1us;0us;1us;0us;2us;1us;1us;2us;1us;1us;2us;1us;1us;1us;2us;1us;1us;2us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;1us;|]
let _fsyacc_productionToNonTerminalTable = [|0us;1us;2us;3us;4us;5us;5us;5us;6us;6us;7us;7us;7us;7us;7us;7us;7us;8us;8us;9us;10us;11us;11us;12us;12us;13us;14us;14us;15us;15us;15us;15us;15us;16us;16us;16us;17us;17us;17us;18us;18us;19us;19us;20us;20us;21us;22us;22us;23us;23us;23us;23us;24us;24us;24us;25us;25us;25us;26us;26us;26us;26us;26us;26us;26us;26us;27us;28us;28us;28us;29us;29us;29us;30us;30us;31us;31us;32us;32us;33us;33us;33us;34us;34us;34us;34us;35us;35us;35us;35us;36us;36us;36us;37us;37us;38us;39us;39us;39us;39us;39us;39us;39us;39us;40us;40us;40us;40us;41us;41us;41us;41us;42us;42us;43us;44us;44us;45us;45us;45us;46us;46us;47us;47us;48us;49us;49us;50us;50us;50us;50us;51us;51us;52us;52us;52us;52us;52us;53us;53us;53us;53us;53us;54us;54us;55us;55us;55us;55us;55us;55us;55us;55us;55us;56us;56us;56us;56us;57us;57us;58us;58us;58us;58us;58us;58us;58us;59us;59us;59us;60us;61us;61us;62us;62us;63us;63us;63us;63us;64us;64us;65us;65us;65us;66us;66us;66us;66us;67us;67us;67us;67us;67us;68us;69us;69us;70us;70us;70us;70us;71us;71us;71us;71us;72us;72us;72us;73us;73us;73us;73us;74us;74us;75us;75us;75us;76us;76us;76us;77us;78us;78us;78us;79us;79us;80us;81us;81us;81us;81us;82us;82us;82us;82us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;83us;84us;84us;84us;84us;85us;85us;85us;85us;86us;86us;86us;87us;87us;87us;87us;87us;88us;88us;89us;89us;89us;90us;90us;90us;91us;91us;92us;92us;92us;93us;93us;94us;94us;95us;95us;96us;96us;97us;97us;97us;98us;98us;99us;99us;99us;99us;100us;100us;100us;101us;101us;101us;101us;101us;102us;102us;102us;102us;103us;103us;104us;104us;104us;105us;105us;105us;106us;106us;107us;107us;107us;107us;108us;108us;109us;109us;110us;110us;111us;112us;112us;112us;113us;114us;114us;115us;116us;116us;117us;117us;118us;118us;118us;118us;119us;119us;119us;119us;119us;119us;119us;119us;119us;119us;119us;119us;120us;120us;121us;121us;121us;122us;123us;123us;124us;124us;124us;124us;124us;124us;124us;124us;124us;124us;125us;125us;125us;126us;126us;126us;126us;127us;127us;127us;127us;127us;127us;128us;128us;128us;128us;129us;129us;129us;129us;129us;130us;130us;131us;131us;132us;133us;133us;133us;133us;134us;135us;135us;136us;136us;136us;137us;137us;138us;138us;139us;140us;141us;141us;142us;142us;142us;142us;143us;143us;144us;145us;145us;145us;146us;146us;147us;147us;148us;148us;148us;148us;148us;148us;149us;149us;150us;151us;151us;152us;152us;153us;153us;153us;154us;154us;154us;155us;156us;156us;157us;158us;158us;159us;159us;160us;160us;160us;160us;160us;160us;160us;160us;160us;160us;160us;160us;160us;160us;160us;160us;160us;160us;161us;161us;161us;161us;162us;162us;163us;163us;164us;164us;165us;166us;166us;167us;167us;168us;168us;169us;169us;169us;169us;169us;169us;169us;169us;169us;169us;170us;170us;170us;170us;170us;170us;171us;171us;172us;172us;172us;173us;173us;173us;174us;174us;174us;174us;174us;174us;174us;174us;174us;174us;174us;175us;175us;176us;176us;176us;176us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;177us;178us;178us;179us;179us;179us;179us;179us;179us;179us;179us;179us;179us;179us;179us;179us;180us;180us;180us;180us;180us;180us;181us;181us;182us;182us;183us;183us;183us;184us;184us;184us;185us;185us;185us;185us;186us;186us;186us;187us;187us;187us;188us;188us;188us;189us;190us;190us;190us;190us;190us;190us;191us;191us;192us;192us;192us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;193us;194us;194us;194us;194us;194us;194us;195us;195us;196us;196us;196us;196us;197us;197us;197us;197us;197us;198us;199us;199us;199us;199us;199us;199us;199us;200us;200us;201us;202us;203us;203us;203us;203us;204us;204us;204us;204us;204us;205us;205us;205us;205us;205us;205us;205us;205us;206us;206us;206us;206us;206us;206us;206us;206us;206us;206us;206us;206us;206us;206us;207us;207us;208us;208us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;209us;210us;210us;210us;210us;210us;210us;210us;210us;210us;210us;211us;211us;211us;211us;211us;211us;211us;211us;211us;211us;211us;212us;212us;212us;212us;213us;213us;213us;213us;214us;214us;214us;214us;215us;215us;215us;215us;215us;215us;215us;215us;215us;215us;216us;216us;216us;217us;217us;218us;218us;219us;219us;219us;219us;219us;220us;220us;220us;221us;221us;222us;222us;223us;224us;225us;225us;225us;226us;227us;227us;228us;229us;229us;230us;230us;231us;231us;232us;232us;232us;233us;233us;234us;234us;234us;234us;234us;234us;234us;234us;234us;235us;235us;236us;236us;236us;236us;237us;237us;238us;238us;239us;239us;239us;239us;239us;240us;240us;240us;241us;241us;241us;242us;242us;243us;243us;243us;244us;245us;245us;245us;246us;247us;247us;248us;248us;248us;248us;248us;249us;249us;249us;249us;249us;249us;249us;249us;250us;250us;251us;251us;252us;252us;253us;253us;253us;254us;254us;254us;255us;255us;255us;255us;256us;256us;256us;256us;257us;257us;257us;257us;257us;257us;257us;257us;257us;257us;258us;258us;258us;258us;259us;259us;259us;259us;260us;261us;261us;261us;261us;261us;261us;261us;261us;262us;262us;262us;262us;262us;262us;262us;263us;263us;264us;264us;265us;265us;266us;266us;267us;267us;268us;268us;268us;268us;268us;268us;268us;268us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;269us;270us;271us;271us;271us;272us;272us;273us;273us;274us;274us;275us;275us;275us;275us;275us;275us;275us;275us;275us;275us;275us;275us;275us;275us;275us;275us;275us;275us;275us;275us;276us;276us;277us;277us;277us;277us;277us;277us;277us;278us;278us;278us;279us;279us;280us;281us;281us;282us;282us;282us;283us;283us;283us;284us;284us;285us;285us;285us;285us;286us;286us;287us;288us;288us;288us;288us;289us;289us;289us;289us;289us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;290us;291us;292us;292us;293us;293us;294us;294us;294us;294us;295us;296us;296us;297us;297us;297us;298us;298us;299us;299us;300us;300us;300us;300us;301us;301us;301us;302us;302us;302us;302us;303us;303us;304us;304us;305us;305us;306us;306us;307us;307us;308us;308us;309us;309us;310us;310us;311us;311us;312us;312us;313us;313us;314us;314us;315us;316us;317us;317us;318us;318us;318us;319us;319us;319us;320us;320us;320us;321us;321us;322us;322us;322us;323us;323us;323us;324us;324us;324us;325us;326us;326us;326us;327us;327us;327us;328us;328us;328us;328us;328us;329us;329us;329us;329us;329us;329us;|]
let _fsyacc_immediateActions = [|65535us;49152us;65535us;49152us;65535us;49152us;65535us;49152us;65535us;49152us;16389us;16390us;16391us;16392us;16393us;16394us;65535us;16395us;65535us;16396us;65535us;16397us;65535us;16398us;65535us;16399us;65535us;16400us;65535us;16402us;65535us;65535us;65535us;16404us;65535us;16406us;16407us;16408us;65535us;65535us;65535us;16411us;16412us;16413us;65535us;16415us;16416us;65535us;16417us;65535us;16418us;65535us;16419us;65535us;65535us;65535us;65535us;65535us;16421us;16422us;65535us;65535us;65535us;16424us;65535us;16426us;65535us;16427us;65535us;65535us;16429us;65535us;65535us;65535us;16430us;16431us;16432us;65535us;65535us;65535us;16433us;16434us;65535us;16435us;16436us;65535us;65535us;65535us;65535us;16439us;65535us;65535us;16440us;16442us;16443us;65535us;65535us;65535us;65535us;16444us;16445us;16446us;65535us;65535us;16447us;16448us;16449us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16450us;65535us;65535us;65535us;65535us;65535us;16453us;65535us;65535us;16454us;65535us;65535us;65535us;16455us;65535us;65535us;16456us;65535us;65535us;16457us;65535us;65535us;16459us;16460us;65535us;65535us;65535us;65535us;65535us;65535us;16461us;65535us;16462us;16463us;16464us;65535us;65535us;16465us;16466us;65535us;65535us;16467us;16468us;65535us;16469us;65535us;65535us;16470us;16471us;65535us;65535us;16472us;16473us;65535us;65535us;16474us;16475us;16476us;16477us;65535us;65535us;16479us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16480us;65535us;65535us;65535us;65535us;16483us;65535us;16484us;65535us;65535us;16485us;65535us;16486us;65535us;65535us;16487us;65535us;16489us;65535us;65535us;16490us;16491us;65535us;65535us;65535us;65535us;16493us;16494us;65535us;65535us;16495us;16496us;16497us;65535us;16498us;65535us;65535us;16499us;65535us;16501us;65535us;16502us;65535us;16503us;65535us;16505us;65535us;16506us;65535us;65535us;16508us;65535us;65535us;65535us;16509us;16510us;65535us;65535us;65535us;16511us;16512us;65535us;16513us;16514us;16515us;65535us;65535us;65535us;65535us;16517us;16520us;16521us;65535us;16522us;65535us;16523us;65535us;65535us;65535us;65535us;65535us;16526us;16527us;16528us;65535us;65535us;16529us;65535us;16530us;65535us;16531us;65535us;65535us;16532us;16533us;65535us;65535us;16534us;16535us;65535us;16536us;16537us;65535us;65535us;16539us;65535us;65535us;16541us;65535us;16542us;65535us;65535us;65535us;16544us;16545us;65535us;16546us;16547us;16548us;16549us;65535us;65535us;65535us;16551us;16552us;16553us;65535us;65535us;16554us;16555us;65535us;16558us;65535us;65535us;65535us;65535us;16559us;65535us;65535us;16560us;16561us;16562us;16563us;65535us;16564us;65535us;65535us;16565us;65535us;65535us;65535us;16566us;65535us;65535us;65535us;65535us;16567us;65535us;16568us;65535us;16569us;65535us;16570us;65535us;16571us;65535us;16572us;16574us;16575us;16576us;65535us;65535us;16577us;65535us;65535us;16578us;65535us;16581us;65535us;65535us;65535us;65535us;65535us;65535us;16582us;16583us;65535us;65535us;65535us;65535us;65535us;65535us;16584us;16585us;16586us;65535us;16587us;16588us;16589us;65535us;65535us;16590us;16591us;65535us;65535us;16592us;16593us;65535us;16594us;65535us;65535us;16595us;16596us;65535us;65535us;16597us;16598us;16599us;16600us;65535us;16601us;65535us;65535us;16603us;65535us;16604us;65535us;65535us;16605us;16606us;65535us;65535us;16608us;65535us;65535us;65535us;65535us;65535us;16609us;65535us;65535us;65535us;65535us;16610us;16611us;16612us;16613us;65535us;16615us;65535us;16617us;65535us;65535us;65535us;65535us;16618us;16619us;65535us;65535us;16620us;16621us;65535us;65535us;16622us;16623us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16624us;16625us;65535us;16626us;65535us;16627us;65535us;16628us;65535us;65535us;65535us;65535us;65535us;16629us;16630us;16631us;65535us;16632us;65535us;16633us;65535us;65535us;65535us;65535us;65535us;16634us;16635us;16636us;16637us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16638us;16639us;16640us;16641us;65535us;16643us;16644us;65535us;65535us;16645us;65535us;65535us;16646us;16647us;65535us;65535us;65535us;16648us;16649us;16651us;16652us;16653us;16654us;65535us;65535us;16655us;65535us;65535us;16658us;65535us;65535us;16660us;65535us;65535us;16661us;16662us;16663us;65535us;16665us;16666us;16667us;65535us;16669us;16670us;65535us;65535us;16671us;16672us;16673us;65535us;65535us;16674us;65535us;65535us;65535us;65535us;16676us;65535us;16677us;16678us;65535us;65535us;16679us;65535us;16680us;16681us;16682us;65535us;65535us;65535us;65535us;65535us;16683us;16684us;16685us;16686us;65535us;65535us;65535us;65535us;16687us;65535us;65535us;16688us;16689us;65535us;16690us;16691us;65535us;16692us;16693us;65535us;65535us;16694us;16695us;65535us;16696us;16697us;16698us;16699us;16700us;16701us;65535us;65535us;65535us;65535us;16704us;16705us;16706us;65535us;65535us;16707us;65535us;65535us;65535us;65535us;16708us;16709us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16712us;16713us;65535us;65535us;65535us;65535us;16716us;16717us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16722us;16723us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16728us;65535us;65535us;65535us;65535us;16730us;65535us;16731us;16732us;16733us;65535us;65535us;16734us;65535us;65535us;65535us;65535us;65535us;65535us;16735us;65535us;16736us;16737us;65535us;65535us;65535us;65535us;65535us;16742us;65535us;65535us;16743us;65535us;16745us;65535us;65535us;16746us;65535us;65535us;65535us;16749us;65535us;16750us;16751us;65535us;16752us;16753us;16754us;65535us;16755us;65535us;65535us;16757us;16758us;65535us;65535us;16759us;65535us;65535us;16760us;65535us;16761us;65535us;65535us;65535us;65535us;65535us;16764us;65535us;16765us;65535us;65535us;16766us;16767us;65535us;16768us;65535us;65535us;16771us;16772us;65535us;16773us;65535us;65535us;16775us;16776us;16777us;16778us;16779us;16780us;16781us;65535us;65535us;16782us;16783us;65535us;16784us;65535us;65535us;65535us;65535us;16785us;16786us;16787us;16788us;65535us;16789us;65535us;65535us;65535us;65535us;16790us;16791us;65535us;65535us;16793us;16794us;65535us;65535us;65535us;65535us;16797us;16798us;65535us;16799us;65535us;65535us;65535us;16800us;65535us;65535us;16801us;16802us;16803us;16804us;16805us;16806us;16807us;16808us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16809us;65535us;65535us;65535us;16813us;65535us;16814us;65535us;65535us;16816us;65535us;65535us;65535us;65535us;16818us;16819us;65535us;16820us;16821us;65535us;65535us;16822us;65535us;65535us;16825us;65535us;65535us;16826us;65535us;16828us;16829us;65535us;65535us;65535us;65535us;65535us;16830us;16831us;16832us;65535us;65535us;16833us;16834us;16835us;65535us;65535us;16837us;65535us;65535us;65535us;16839us;65535us;16840us;16841us;65535us;65535us;16842us;16843us;16844us;16845us;16846us;16847us;16848us;16849us;16850us;16851us;16852us;16853us;16854us;16855us;16856us;16857us;16858us;16859us;16860us;16861us;65535us;65535us;16862us;65535us;65535us;65535us;16863us;16866us;65535us;65535us;16867us;16868us;65535us;16869us;65535us;65535us;16871us;65535us;16873us;65535us;65535us;16875us;16876us;16877us;65535us;65535us;16878us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16879us;16880us;65535us;65535us;16884us;65535us;65535us;16888us;65535us;65535us;16891us;16892us;65535us;16894us;65535us;65535us;65535us;16897us;65535us;16898us;65535us;16899us;65535us;65535us;65535us;65535us;16901us;16902us;65535us;65535us;16904us;65535us;16905us;65535us;16906us;16907us;65535us;16908us;65535us;16909us;65535us;16910us;16911us;16913us;65535us;65535us;16914us;16915us;65535us;16916us;65535us;16917us;65535us;16918us;16920us;65535us;65535us;16921us;65535us;16922us;65535us;65535us;16923us;65535us;65535us;16924us;65535us;65535us;16926us;16927us;16928us;16929us;16930us;16931us;65535us;65535us;16932us;16933us;65535us;65535us;16935us;65535us;65535us;65535us;16936us;16937us;65535us;16938us;16939us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16942us;16943us;65535us;65535us;65535us;65535us;16948us;16949us;65535us;65535us;16952us;16954us;65535us;65535us;16957us;16958us;65535us;16960us;65535us;65535us;65535us;16963us;65535us;16964us;65535us;65535us;16966us;16967us;16969us;65535us;16970us;65535us;65535us;16971us;16972us;16973us;16974us;65535us;65535us;16975us;16976us;65535us;65535us;16978us;16980us;65535us;65535us;65535us;16981us;16982us;65535us;16984us;65535us;65535us;16985us;65535us;16988us;65535us;65535us;65535us;16989us;65535us;16991us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;16992us;65535us;65535us;65535us;65535us;16993us;65535us;65535us;65535us;65535us;65535us;16994us;65535us;65535us;16996us;16997us;65535us;16998us;16999us;65535us;17000us;17001us;17002us;17003us;17004us;65535us;65535us;17005us;17006us;65535us;65535us;17007us;17008us;65535us;65535us;17009us;17010us;65535us;17012us;65535us;17013us;65535us;65535us;17014us;17015us;17016us;65535us;65535us;65535us;65535us;65535us;17020us;65535us;17021us;65535us;17023us;65535us;17024us;65535us;65535us;65535us;65535us;17025us;17026us;17027us;17028us;17029us;65535us;17030us;65535us;65535us;65535us;17031us;17032us;17033us;17034us;17035us;65535us;65535us;17036us;17037us;17038us;65535us;65535us;65535us;65535us;65535us;17042us;17043us;65535us;65535us;65535us;65535us;65535us;65535us;17044us;65535us;65535us;65535us;65535us;65535us;65535us;17045us;17046us;65535us;65535us;65535us;65535us;17047us;65535us;65535us;17048us;65535us;65535us;65535us;17050us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;17051us;17052us;65535us;17053us;17054us;65535us;17055us;17056us;65535us;65535us;65535us;17058us;65535us;65535us;65535us;17061us;65535us;17063us;65535us;17065us;65535us;17067us;65535us;17069us;65535us;17071us;65535us;17073us;65535us;17075us;65535us;17077us;65535us;17079us;65535us;17081us;65535us;17083us;65535us;17085us;65535us;17087us;65535us;17089us;65535us;17091us;65535us;17093us;65535us;17095us;65535us;17097us;65535us;17099us;65535us;65535us;65535us;65535us;17103us;65535us;65535us;65535us;17105us;17106us;65535us;17107us;17108us;17109us;17110us;17111us;65535us;65535us;17112us;65535us;17113us;65535us;65535us;17114us;17115us;17116us;17117us;65535us;17118us;65535us;17119us;17120us;17121us;17122us;65535us;65535us;65535us;17124us;65535us;17125us;65535us;17126us;17127us;17128us;17129us;65535us;65535us;17132us;65535us;17133us;65535us;17135us;65535us;17136us;17137us;65535us;65535us;17140us;65535us;17141us;17142us;65535us;17144us;65535us;17146us;65535us;17147us;65535us;17149us;65535us;65535us;65535us;65535us;17151us;65535us;65535us;17152us;65535us;65535us;17153us;65535us;65535us;17154us;65535us;65535us;17155us;65535us;65535us;17156us;65535us;65535us;17157us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;17158us;17160us;17161us;65535us;17162us;65535us;17163us;65535us;65535us;65535us;17165us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;17170us;17171us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;17174us;65535us;65535us;65535us;65535us;17176us;65535us;17177us;65535us;17178us;65535us;65535us;17179us;65535us;65535us;17180us;65535us;17181us;17182us;17183us;65535us;65535us;17184us;17185us;17186us;17187us;65535us;65535us;17188us;17189us;17190us;17191us;17192us;17194us;65535us;65535us;65535us;65535us;17195us;65535us;17196us;65535us;65535us;17197us;17198us;17199us;17200us;17201us;17202us;17203us;17204us;17205us;17206us;17207us;17208us;17209us;17210us;17211us;65535us;65535us;17212us;17213us;65535us;17214us;17215us;65535us;65535us;65535us;17216us;17217us;17218us;17219us;65535us;65535us;17220us;17221us;17222us;17223us;65535us;65535us;65535us;17224us;65535us;17225us;17226us;17227us;65535us;17228us;17229us;17230us;17231us;17232us;65535us;17233us;65535us;65535us;65535us;65535us;65535us;17234us;17235us;17236us;17237us;65535us;65535us;17238us;65535us;17239us;65535us;65535us;17241us;17242us;17243us;17244us;17245us;17246us;17247us;17248us;17249us;17251us;17253us;65535us;17254us;65535us;17256us;17257us;65535us;65535us;17259us;17260us;65535us;65535us;65535us;65535us;65535us;17261us;17262us;17265us;65535us;65535us;65535us;17267us;65535us;17269us;65535us;17270us;65535us;65535us;65535us;65535us;65535us;17271us;17272us;65535us;65535us;65535us;17273us;17274us;65535us;65535us;65535us;17278us;65535us;65535us;65535us;17279us;65535us;65535us;17280us;65535us;65535us;65535us;17281us;17282us;65535us;65535us;65535us;17286us;17287us;65535us;17289us;17290us;65535us;65535us;17292us;17294us;17296us;65535us;65535us;65535us;17297us;65535us;17298us;17300us;17303us;65535us;17305us;65535us;65535us;17306us;65535us;17307us;65535us;17308us;65535us;17310us;65535us;17311us;65535us;65535us;65535us;65535us;17312us;65535us;17313us;17314us;65535us;65535us;17315us;17316us;17317us;17318us;17319us;65535us;65535us;65535us;17320us;17321us;65535us;65535us;65535us;65535us;17322us;17323us;65535us;17324us;65535us;17326us;65535us;17327us;65535us;17328us;65535us;65535us;17329us;65535us;65535us;65535us;65535us;65535us;17335us;17336us;65535us;65535us;17337us;17338us;65535us;65535us;17340us;17341us;65535us;17342us;65535us;65535us;17344us;17345us;65535us;17346us;65535us;65535us;65535us;17348us;17349us;65535us;65535us;65535us;17350us;17351us;65535us;65535us;17353us;17354us;65535us;65535us;65535us;17355us;17356us;65535us;65535us;65535us;65535us;17358us;17359us;65535us;17360us;65535us;65535us;17362us;17363us;65535us;17364us;65535us;17366us;65535us;65535us;65535us;17367us;17368us;65535us;65535us;17369us;65535us;65535us;17370us;17371us;65535us;17372us;17373us;65535us;65535us;17375us;17376us;65535us;17377us;65535us;17378us;17379us;65535us;17380us;65535us;65535us;65535us;65535us;65535us;17385us;65535us;65535us;65535us;17386us;65535us;65535us;17388us;65535us;17391us;17392us;65535us;17393us;17394us;65535us;65535us;65535us;17395us;17396us;17397us;65535us;17398us;65535us;65535us;17399us;65535us;17400us;65535us;17401us;65535us;17402us;65535us;17403us;65535us;17404us;65535us;17405us;65535us;17406us;65535us;17407us;65535us;17408us;65535us;17409us;65535us;17410us;65535us;17411us;65535us;17412us;65535us;17413us;65535us;17414us;65535us;17415us;65535us;17416us;65535us;17417us;65535us;17418us;65535us;17419us;65535us;17420us;65535us;17421us;65535us;17422us;65535us;17423us;65535us;17424us;65535us;17425us;65535us;17426us;65535us;17427us;65535us;17428us;65535us;17429us;65535us;17430us;65535us;17431us;65535us;65535us;65535us;65535us;65535us;65535us;17433us;17434us;65535us;65535us;17437us;65535us;65535us;65535us;17438us;65535us;65535us;17441us;17442us;17443us;17444us;65535us;65535us;65535us;17445us;17446us;65535us;65535us;65535us;65535us;65535us;17447us;17448us;17449us;17450us;17451us;17452us;17453us;65535us;17455us;17456us;65535us;65535us;17457us;65535us;17458us;65535us;65535us;17460us;65535us;17461us;17462us;65535us;17463us;65535us;65535us;65535us;65535us;17464us;17465us;17466us;65535us;17467us;17468us;17469us;17470us;65535us;65535us;17472us;17474us;17475us;65535us;65535us;17477us;65535us;17478us;65535us;17480us;65535us;65535us;17481us;65535us;65535us;17483us;17484us;65535us;17486us;17487us;65535us;65535us;65535us;65535us;65535us;65535us;65535us;17491us;65535us;65535us;17492us;65535us;17493us;17494us;17495us;65535us;17496us;17497us;65535us;65535us;17498us;65535us;17499us;17500us;65535us;65535us;17501us;65535us;65535us;17502us;17503us;17504us;17505us;17506us;17507us;17508us;17509us;17510us;17511us;17512us;17513us;17514us;17515us;17516us;17517us;17518us;17519us;17520us;17521us;17522us;17523us;17524us;17525us;65535us;17527us;65535us;17528us;17529us;65535us;17530us;17531us;17532us;17533us;65535us;17535us;65535us;17536us;17537us;17538us;17539us;17540us;17541us;17542us;17543us;65535us;17545us;65535us;17546us;65535us;65535us;17550us;17551us;17552us;17553us;17554us;17555us;17556us;17557us;17559us;17561us;17563us;17565us;17567us;17569us;17571us;17573us;17574us;17575us;17576us;17577us;17578us;17579us;17580us;17581us;17582us;17583us;17584us;65535us;17586us;17587us;65535us;65535us;17588us;17589us;65535us;65535us;17590us;17591us;17592us;17593us;17594us;17596us;65535us;65535us;17598us;17599us;17600us;65535us;65535us;17601us;17602us;17603us;65535us;17604us;17605us;17606us;17607us;65535us;17608us;17609us;17610us;65535us;17611us;17612us;17613us;17614us;17615us;17616us;17617us;17618us;17619us;17620us;17621us;17622us;17623us;17624us;|]
let _fsyacc_reductions = lazy [|
//# 2886 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParsedSigFile in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Internal.Utilities.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : 'gentype__startsignatureFile));
//# 2895 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParsedImplFile in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Internal.Utilities.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : 'gentype__startimplementationFile));
//# 2904 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParsedScriptInteraction in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Internal.Utilities.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : 'gentype__startinteraction));
//# 2913 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Internal.Utilities.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : 'gentype__starttypedSequentialExprEOF));
//# 2922 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Internal.Utilities.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : 'gentype__starttypEOF));
//# 2931 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveItemsTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 395 "src/Compiler/pars.fsy"
                            ParsedScriptInteraction.Definitions(_1, lhs parseState) 
                   )
//# 395 "src/Compiler/pars.fsy"
                 : ParsedScriptInteraction));
//# 2942 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 398 "src/Compiler/pars.fsy"
                            warning(Error(FSComp.SR.parsUnexpectedSemicolon(), rhs parseState 1))
                            ParsedScriptInteraction.Definitions([], lhs parseState) 
                   )
//# 398 "src/Compiler/pars.fsy"
                 : ParsedScriptInteraction));
//# 2953 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 402 "src/Compiler/pars.fsy"
                            ParsedScriptInteraction.Definitions([], lhs parseState) 
                   )
//# 402 "src/Compiler/pars.fsy"
                 : ParsedScriptInteraction));
//# 2963 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 406 "src/Compiler/pars.fsy"
                                              
                   )
//# 406 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveTerminator));
//# 2973 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 407 "src/Compiler/pars.fsy"
                               checkEndOfFileError _1 
                   )
//# 407 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveTerminator));
//# 2984 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 421 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 421 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 2995 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveDefns in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 424 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 424 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 3007 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveExpr in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 427 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 427 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 3019 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveHash in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 430 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 430 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 3031 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveDefns in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_interactiveItemsTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 433 "src/Compiler/pars.fsy"
                            _1 @ _3 
                   )
//# 433 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 3044 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveExpr in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_interactiveItemsTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 436 "src/Compiler/pars.fsy"
                            _1 @ _3 
                   )
//# 436 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 3057 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveHash in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_interactiveItemsTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 439 "src/Compiler/pars.fsy"
                            _1 @ _3 
                   )
//# 439 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveItemsTerminator));
//# 3070 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 445 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 445 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveDefns));
//# 3081 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefn in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveDefns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 448 "src/Compiler/pars.fsy"
                             _1 @ _2 
                   )
//# 448 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveDefns));
//# 3093 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 454 "src/Compiler/pars.fsy"
                             match _2 with
                             | Some vis -> errorR(Error(FSComp.SR.parsUnexpectedVisibilityDeclaration(vis.ToString()), rhs parseState 3))
                             | _ -> ()
                             let attrDecls = if not (isNil _1) then [ SynModuleDecl.Attributes(_1, rangeOfNonNilAttrs _1) ] else []
                             attrDecls @ [ mkSynExprDecl _3 ] 
                   )
//# 454 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveExpr));
//# 3110 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hashDirective in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 463 "src/Compiler/pars.fsy"
                             [SynModuleDecl.HashDirective(_1, rhs parseState 1)] 
                   )
//# 463 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveHash));
//# 3121 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveSeparator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 467 "src/Compiler/pars.fsy"
                                                
                   )
//# 467 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveSeparators));
//# 3132 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_interactiveSeparator in
            let _2 = parseState.GetInput(2) :?> 'gentype_interactiveSeparators in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 469 "src/Compiler/pars.fsy"
                                                                      
                   )
//# 469 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveSeparators));
//# 3144 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 473 "src/Compiler/pars.fsy"
                                     
                   )
//# 473 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveSeparator));
//# 3154 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 474 "src/Compiler/pars.fsy"
                                     
                   )
//# 474 "src/Compiler/pars.fsy"
                 : 'gentype_interactiveSeparator));
//# 3164 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> string in
            let _3 = parseState.GetInput(3) :?> 'gentype_hashDirectiveArgs in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 483 "src/Compiler/pars.fsy"
                            let m = match _3 with [] -> rhs2  parseState 1 2 | _ -> rhs2  parseState 1 3
                            ParsedHashDirective(_2, _3, m) 
                   )
//# 483 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirective));
//# 3177 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 490 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 490 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirectiveArgs));
//# 3187 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hashDirectiveArgs in
            let _2 = parseState.GetInput(2) :?> 'gentype_hashDirectiveArg in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 493 "src/Compiler/pars.fsy"
                            _1 @ [_2] 
                   )
//# 493 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirectiveArgs));
//# 3199 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 499 "src/Compiler/pars.fsy"
                             let s, kind = _1
                             ParsedHashDirectiveArgument.String(s, kind, lhs parseState) 
                   )
//# 499 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirectiveArg));
//# 3211 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 502 "src/Compiler/pars.fsy"
                             let n, _ = _1
                             ParsedHashDirectiveArgument.Int32(n, lhs parseState) 
                   )
//# 502 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirectiveArg));
//# 3223 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 505 "src/Compiler/pars.fsy"
                             let m = rhs parseState 1
                             ParsedHashDirectiveArgument.Ident(Ident(_1, m), lhs parseState) 
                   )
//# 505 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirectiveArg));
//# 3235 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 508 "src/Compiler/pars.fsy"
                             let path = _1
                             ParsedHashDirectiveArgument.LongIdent(path, lhs parseState) 
                   )
//# 508 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirectiveArg));
//# 3247 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_sourceIdentifier in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 511 "src/Compiler/pars.fsy"
                             let c, v = _1
                             ParsedHashDirectiveArgument.SourceIdentifier(c, v, lhs parseState) 
                   )
//# 511 "src/Compiler/pars.fsy"
                 : 'gentype_hashDirectiveArg));
//# 3259 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceSpecs in
            let _2 = parseState.GetInput(2) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 521 "src/Compiler/pars.fsy"
                            checkEndOfFileError _2; _1 
                   )
//# 521 "src/Compiler/pars.fsy"
                 : ParsedSigFile));
//# 3271 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceSpecs in
            let _3 = parseState.GetInput(3) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 524 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 524 "src/Compiler/pars.fsy"
                 : ParsedSigFile));
//# 3283 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 530 "src/Compiler/pars.fsy"
                            let emptySigFileFrag = ParsedSigFileFragment.AnonModule([], rhs parseState 1)
                            ParsedSigFile([], [emptySigFileFrag]) 
                   )
//# 530 "src/Compiler/pars.fsy"
                 : ParsedSigFile));
//# 3295 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleKeyword in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_rec in
            let _5 = parseState.GetInput(5) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 537 "src/Compiler/pars.fsy"
                             if not (isNil _2) then
                                 parseState.LexBuffer.CheckLanguageFeatureAndRecover LanguageFeature.AttributesToRightOfModuleKeyword (rhs parseState 4)
                             let mModule = rhs parseState 1
                             mModule, _4, _5.LongIdent, _3, _2 
                   )
//# 537 "src/Compiler/pars.fsy"
                 : 'gentype_moduleIntro));
//# 3313 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleKeyword in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_rec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 543 "src/Compiler/pars.fsy"
                             if not (isNil _2) then
                                 parseState.LexBuffer.CheckLanguageFeatureAndRecover LanguageFeature.AttributesToRightOfModuleKeyword (rhs parseState 4)
                             let mModule = rhs parseState 1
                             mModule, _4, [], _3, _2 
                   )
//# 543 "src/Compiler/pars.fsy"
                 : 'gentype_moduleIntro));
//# 3330 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleKeyword in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_rec in
            let _5 = parseState.GetInput(5) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 549 "src/Compiler/pars.fsy"
                             if not (isNil _2) then
                                 parseState.LexBuffer.CheckLanguageFeatureAndRecover LanguageFeature.AttributesToRightOfModuleKeyword (rhs parseState 4)
                             let mModule = rhs parseState 1
                             mModule, _4, [], _3, _2 
                   )
//# 549 "src/Compiler/pars.fsy"
                 : 'gentype_moduleIntro));
//# 3348 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_rec in
            let _3 = parseState.GetInput(3) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 557 "src/Compiler/pars.fsy"
                             let mNamespace = rhs parseState 1
                             mNamespace, _2, _3.LongIdent, grabXmlDoc(parseState, [], 1) 
                   )
//# 557 "src/Compiler/pars.fsy"
                 : 'gentype_namespaceIntro));
//# 3361 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_rec in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 561 "src/Compiler/pars.fsy"
                             let mNamespace = rhs parseState 1
                             mNamespace, _2, [], grabXmlDoc(parseState, [], 1) 
                   )
//# 561 "src/Compiler/pars.fsy"
                 : 'gentype_namespaceIntro));
//# 3374 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileModuleSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 568 "src/Compiler/pars.fsy"
                             ParsedSigFile([], [ (_1 (None, false, [], PreXmlDoc.Empty)) ]) 
                   )
//# 568 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceSpecs));
//# 3385 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileModuleSpec in
            let _2 = parseState.GetInput(2) :?> 'gentype_fileNamespaceSpecList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 571 "src/Compiler/pars.fsy"
                             // If there are namespaces, the first fileModuleImpl may only contain # directives
                             let decls =
                                 match (_1 (None, false, [], PreXmlDoc.Empty)) with
                                 | ParsedSigFileFragment.AnonModule(decls, m) -> decls
                                 | ParsedSigFileFragment.NamespaceFragment(decls = decls) -> decls
                                 | ParsedSigFileFragment.NamedModule(SynModuleOrNamespaceSig(range = m)) ->
                                     raiseParseErrorAt m (FSComp.SR.parsOnlyHashDirectivesAllowed())
                             let decls =
                                 decls |> List.collect (function
                                     | (SynModuleSigDecl.HashDirective(hd, _)) -> [hd]
                                     | d ->
                                          reportParseErrorAt d.Range (FSComp.SR.parsOnlyHashDirectivesAllowed())
                                          [])
                             ParsedSigFile(decls, _2) 
                   )
//# 571 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceSpecs));
//# 3410 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceSpec in
            let _2 = parseState.GetInput(2) :?> 'gentype_fileNamespaceSpecList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 589 "src/Compiler/pars.fsy"
                            _1 :: _2 
                   )
//# 589 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceSpecList));
//# 3422 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 592 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 592 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceSpecList));
//# 3433 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_namespaceIntro in
            let _2 = parseState.GetInput(2) :?> 'gentype_deprecated_opt_equals in
            let _3 = parseState.GetInput(3) :?> 'gentype_fileModuleSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 596 "src/Compiler/pars.fsy"
                            let mNamespace, isRec, path, xml = _1
                            _3 (Some mNamespace, isRec, path, xml) 
                   )
//# 596 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceSpec));
//# 3447 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            let _4 = parseState.GetInput(4) :?> 'gentype_moduleSpfnsPossiblyEmptyBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 603 "src/Compiler/pars.fsy"
                           if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                           let m2 = rhs parseState 3
                           let mDeclsAndAttrs = (List.map (fun (a: SynAttributeList) -> a.Range) _1) @ (List.map (fun (d: SynModuleSigDecl) -> d.Range) _4)
                           let mModule, isRec, path2, vis, attribs2 = _3
                           let xmlDoc = grabXmlDoc(parseState, _1, 1)
                           let m = (m2, mDeclsAndAttrs) ||> unionRangeWithListBy id |> unionRangeWithXmlDoc xmlDoc
                           (fun (mNamespaceOpt, isRec2, path, _) ->
                             if not (isNil path) then errorR(Error(FSComp.SR.parsNamespaceOrModuleNotBoth(), m2))
                             let lid = path@path2
                             let trivia: SynModuleOrNamespaceSigTrivia = { LeadingKeyword = SynModuleOrNamespaceLeadingKeyword.Module mModule }
                             ParsedSigFileFragment.NamedModule(SynModuleOrNamespaceSig(lid, (isRec || isRec2), SynModuleOrNamespaceKind.NamedModule, _4, xmlDoc, _1 @ attribs2, vis, m, trivia))) 
                   )
//# 603 "src/Compiler/pars.fsy"
                 : 'gentype_fileModuleSpec));
//# 3471 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleSpfnsPossiblyEmptyBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 616 "src/Compiler/pars.fsy"
                           let m = (rhs parseState 1)
                           (fun (mNamespaceOpt, isRec, path, xml) ->
                             match path with
                             | [] -> ParsedSigFileFragment.AnonModule(_1, m)
                             | _ ->
                                 let lastDeclRange = List.tryLast _1 |> Option.map (fun decl -> decl.Range) |> Option.defaultValue (rhs parseState 1)
                                 let m = withStart (lhs parseState).Start lastDeclRange
                                 xml.MarkAsInvalid()
                                 let trivia: SynModuleOrNamespaceSigTrivia =
                                     match mNamespaceOpt with
                                     | None -> { LeadingKeyword = SynModuleOrNamespaceLeadingKeyword.None }
                                     | Some mNamespace -> { LeadingKeyword = SynModuleOrNamespaceLeadingKeyword.Namespace mNamespace }
                                 ParsedSigFileFragment.NamespaceFragment(path, isRec, SynModuleOrNamespaceKind.DeclaredNamespace, _1, PreXmlDoc.Empty, [], m, trivia)) 
                   )
//# 616 "src/Compiler/pars.fsy"
                 : 'gentype_fileModuleSpec));
//# 3494 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleSpfnsPossiblyEmpty in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 633 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 633 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmptyBlock));
//# 3505 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleSpfnsPossiblyEmpty in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 636 "src/Compiler/pars.fsy"
                             _2 
                   )
//# 636 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmptyBlock));
//# 3518 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleSpfnsPossiblyEmpty in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 639 "src/Compiler/pars.fsy"
                              // The lex filter ensures we can only get a mismatch in OBLOCKBEGIN/OBLOCKEND tokens if there was some other kind of error, hence we don't need to report this error
                              // reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnClosedBlockInHashLight())
                              _2
                            
                   )
//# 639 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmptyBlock));
//# 3533 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 645 "src/Compiler/pars.fsy"
                              [] 
                   )
//# 645 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmptyBlock));
//# 3544 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleSpfns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 650 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 650 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmpty));
//# 3555 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 653 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 653 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmpty));
//# 3565 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 656 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 656 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfnsPossiblyEmpty));
//# 3575 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleSpfn in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_topSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleSpfns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 661 "src/Compiler/pars.fsy"
                            _1 :: _3 
                   )
//# 661 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfns));
//# 3588 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_topSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleSpfns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 664 "src/Compiler/pars.fsy"
                            (* silent recovery *) _3 
                   )
//# 664 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfns));
//# 3600 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleSpfn in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_topSeparators in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 667 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 667 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfns));
//# 3612 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hashDirective in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 672 "src/Compiler/pars.fsy"
                             SynModuleSigDecl.HashDirective(_1, rhs2 parseState 1 1) 
                   )
//# 672 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3623 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_valSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 675 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 675 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3634 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            let _4 = parseState.GetInput(4) :?> 'gentype_colonOrEquals in
            let _5 = parseState.GetInput(5) :?> 'gentype_namedModuleAbbrevBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 678 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let mModule, isRec, path, vis, attribs2 = _3
                             if isRec then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsInvalidUseOfRec())
                             if not (isSingleton path) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsModuleAbbreviationMustBeSimpleName())
                             if not (isNil _1) then raiseParseErrorAt (rhs parseState 1) (FSComp.SR.parsIgnoreAttributesOnModuleAbbreviation())
                             if not (isNil attribs2) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsIgnoreAttributesOnModuleAbbreviation())
                             match vis with
                             | Some vis -> raiseParseErrorAt (rhs parseState 1) (FSComp.SR.parsIgnoreVisibilityOnModuleAbbreviationAlwaysPrivate(vis.ToString()))
                             | _ ->
                                 let lid: SynLongIdent = _5
                                 let m = unionRanges mModule lid.Range
                                 SynModuleSigDecl.ModuleAbbrev(List.head path, lid.LongIdent, m) 
                   )
//# 678 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3660 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            let _4 = parseState.GetInput(4) :?> 'gentype_colonOrEquals in
            let _5 = parseState.GetInput(5) :?> 'gentype_moduleSpecBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 692 "src/Compiler/pars.fsy"
                             let mModule, isRec, path, vis, attribs2 = _3
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             if not (isSingleton path) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsModuleDefnMustBeSimpleName())
                             if isRec then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsInvalidUseOfRec())
                             let info = SynComponentInfo(_1 @ attribs2, None, [], path, xmlDoc, false, vis, rhs parseState 3)
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let decls, mOptEnd = _5
                             let m = (rhs2 parseState 1 4, decls)
                                     ||> unionRangeWithListBy (fun (d: SynModuleSigDecl) -> d.Range)
                                     |> unionRangeWithXmlDoc xmlDoc
                             let m = match mOptEnd with | None -> m | Some mEnd -> unionRanges m mEnd
                             let trivia: SynModuleSigDeclNestedModuleTrivia = { ModuleKeyword = Some mModule; EqualsRange = _4 }
                             SynModuleSigDecl.NestedModule(info, isRec, decls, m, trivia) 
                   )
//# 692 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3687 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 707 "src/Compiler/pars.fsy"
                             let mModule, isRec, path, vis, attribs2 = _3
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             if not (isSingleton path) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsModuleDefnMustBeSimpleName())
                             if isRec then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsInvalidUseOfRec())
                             let info = SynComponentInfo(_1 @ attribs2, None, [], path, xmlDoc, false, vis, rhs parseState 3)
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let mWhole = rhs2 parseState 1 3 |> unionRangeWithXmlDoc xmlDoc
                             let trivia: SynModuleSigDeclNestedModuleTrivia = { ModuleKeyword = Some mModule; EqualsRange = None }
                             SynModuleSigDecl.NestedModule(info, isRec, [], mWhole, trivia) 
                   )
//# 707 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3708 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_typeKeyword in
            let _4 = parseState.GetInput(4) :?> 'gentype_tyconSpfn in
            let _5 = parseState.GetInput(5) :?> SynTypeDefnSig list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 718 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR (Error (FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                             let leadingKeyword = SynTypeDefnLeadingKeyword.Type(rhs parseState 3)
                             let (SynTypeDefnSig (SynComponentInfo (cas, a, cs, b, _xmlDoc, d, d2, d3), typeRepr, members, range, trivia)) = _4 leadingKeyword
                             _xmlDoc.MarkAsInvalid()
                             let attrs = _1 @ cas
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             let mDefn =
                                 (d3, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                 |> unionRanges range
                                 |> unionRangeWithXmlDoc xmlDoc
                             let tc = (SynTypeDefnSig(SynComponentInfo(attrs, a, cs, b, xmlDoc, d, d2, d3), typeRepr, members, mDefn, trivia))
                             let m = (mDefn, _5) ||> unionRangeWithListBy (fun (a: SynTypeDefnSig) -> a.Range) |> unionRanges (rhs parseState 3)
                             SynModuleSigDecl.Types(tc :: _5, m) 
                   )
//# 718 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3735 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_exconSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 733 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let (SynExceptionSig(SynExceptionDefnRepr(cas, a, b, c, d, d2), withKeyword, members, range)) = _3
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             let mDefnReprWithAttributes = (d2, _1) ||> unionRangeWithListBy (fun a -> a.Range) |> unionRangeWithXmlDoc xmlDoc
                             let mWhole = (mDefnReprWithAttributes, members) ||> unionRangeWithListBy (fun (m: SynMemberSig) -> m.Range)
                             let synExnDefn = SynExceptionSig(SynExceptionDefnRepr(_1@cas, a, b, xmlDoc, d, mDefnReprWithAttributes), withKeyword, members, mWhole)
                             SynModuleSigDecl.Exception(synExnDefn, mWhole) 
                   )
//# 733 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3754 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_openDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 742 "src/Compiler/pars.fsy"
                             SynModuleSigDecl.Open _1 
                   )
//# 742 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpfn));
//# 3765 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_attributes in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_inline in
            let _6 = parseState.GetInput(6) :?> 'gentype_opt_mutable in
            let _7 = parseState.GetInput(7) :?> 'gentype_opt_access in
            let _8 = parseState.GetInput(8) :?> 'gentype_nameop in
            let _9 = parseState.GetInput(9) :?> 'gentype_opt_explicitValTyparDecls in
            let _11 = parseState.GetInput(11) :?> 'gentype_topTypeWithTypeConstraints in
            let _12 = parseState.GetInput(12) :?> 'gentype_optLiteralValueSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 746 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let attr1, attr2, isInline, isMutable, vis2, id, doc, explicitValTyparDecls, (ty, arity), (mEquals, konst: SynExpr option) = (_1), (_4), (Option.isSome _5), (Option.isSome _6), (_7), (_8), grabXmlDoc(parseState, _1, 1), (_9), (_11), (_12)
                             let vis2 = SynValSigAccess.Single(vis2)
                             if not (isNil attr2) then errorR(Deprecated(FSComp.SR.parsAttributesMustComeBeforeVal(), rhs parseState 4))
                             let m =
                                 rhs2 parseState 1 11
                                 |> unionRangeWithXmlDoc doc
                                 |> fun m ->
                                     match konst with
                                     | None -> m
                                     | Some e -> unionRanges m e.Range
                             let mVal = rhs parseState 3
                             let trivia: SynValSigTrivia = { LeadingKeyword = SynLeadingKeyword.Val mVal; InlineKeyword = _5; WithKeyword = None; EqualsRange = mEquals }
                             let valSpfn = SynValSig((attr1@attr2), id, explicitValTyparDecls, ty, arity, isInline, isMutable, doc, vis2, konst, m, trivia)
                             SynModuleSigDecl.Val(valSpfn, m)
                           
                   )
//# 746 "src/Compiler/pars.fsy"
                 : 'gentype_valSpfn));
//# 3800 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 766 "src/Compiler/pars.fsy"
                             None, None 
                   )
//# 766 "src/Compiler/pars.fsy"
                 : 'gentype_optLiteralValueSpfn));
//# 3810 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 769 "src/Compiler/pars.fsy"
                             let mEquals = rhs parseState 1
                             Some(mEquals), Some(_2) 
                   )
//# 769 "src/Compiler/pars.fsy"
                 : 'gentype_optLiteralValueSpfn));
//# 3822 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> SynExpr in
            let _4 = parseState.GetInput(4) :?> 'gentype_oblockend in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 773 "src/Compiler/pars.fsy"
                             let mEquals = rhs parseState 1
                             Some(mEquals), Some(_3) 
                   )
//# 773 "src/Compiler/pars.fsy"
                 : 'gentype_optLiteralValueSpfn));
//# 3836 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleSpfns in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 782 "src/Compiler/pars.fsy"
                             _2, None 
                   )
//# 782 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpecBlock));
//# 3848 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_sigOrBegin in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleSpfnsPossiblyEmpty in
            let _5 = parseState.GetInput(5) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 786 "src/Compiler/pars.fsy"
                             let mEnd = rhs parseState 4
                             _3, Some mEnd 
                   )
//# 786 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpecBlock));
//# 3862 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_sigOrBegin in
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleSpfnsPossiblyEmpty in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 791 "src/Compiler/pars.fsy"
                             let mEnd = rhs parseState 3
                             _2, Some mEnd 
                   )
//# 791 "src/Compiler/pars.fsy"
                 : 'gentype_moduleSpecBlock));
//# 3875 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_tyconSpfn in
            let _3 = parseState.GetInput(3) :?> SynTypeDefnSig list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 797 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc(parseState, [], 1)
                            let tyconSpfn =
                                let leadingKeyword = SynTypeDefnLeadingKeyword.And(rhs parseState 1)
                                let (SynTypeDefnSig(componentInfo, typeRepr, members, range, trivia) as typeDefnSig) = _2 leadingKeyword
                                let (SynComponentInfo(a, typars, c, lid, _xmlDoc, fixity, vis, mLongId)) = componentInfo
                                if xmlDoc.IsEmpty then
                                    if _xmlDoc.IsEmpty then typeDefnSig else
                                    let range = unionRangeWithXmlDoc _xmlDoc range
                                    SynTypeDefnSig(componentInfo, typeRepr, members, range, trivia)
                                else
                                    _xmlDoc.MarkAsInvalid()
                                    let range = unionRangeWithXmlDoc xmlDoc range
                                    let componentInfo = SynComponentInfo (a, typars, c, lid, xmlDoc, fixity, vis, mLongId)
                                    SynTypeDefnSig(componentInfo, typeRepr, members, range, trivia)
                            tyconSpfn :: _3 
                   )
//# 797 "src/Compiler/pars.fsy"
                 : SynTypeDefnSig list));
//# 3901 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 815 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 815 "src/Compiler/pars.fsy"
                 : SynTypeDefnSig list));
//# 3911 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeNameInfo in
            let _3 = parseState.GetInput(3) :?> 'gentype_tyconSpfnRhsBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 821 "src/Compiler/pars.fsy"
                             let mLhs = rhs parseState 1
                             let mEquals = rhs parseState 2
                             fun leadingKeyword -> _3 leadingKeyword mLhs _1 (Some mEquals) 
                   )
//# 821 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfn));
//# 3925 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeNameInfo in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_classSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 825 "src/Compiler/pars.fsy"
                             let mWithKwd, members = _2
                             let (SynComponentInfo(range = range)) = _1
                             let m =
                                 match members with
                                 | [] ->
                                     match mWithKwd with
                                     | None -> range
                                     | Some mWithKwd -> unionRanges range mWithKwd
                                 | decls ->
                                     (range, decls) ||> unionRangeWithListBy (fun (s: SynMemberSig) -> s.Range)
                             fun leadingKeyword ->
                                 let trivia: SynTypeDefnSigTrivia = { LeadingKeyword = leadingKeyword; EqualsRange = None; WithKeyword = mWithKwd }
                                 SynTypeDefnSig(_1, SynTypeDefnSigRepr.Simple(SynTypeDefnSimpleRepr.None m, m), members, m, trivia) 
                   )
//# 825 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfn));
//# 3949 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_tyconSpfnRhs in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_OBLOCKSEP in
            let _4 = parseState.GetInput(4) :?> 'gentype_classSpfnMembers in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_classSpfn in
            let _6 = parseState.GetInput(6) :?> 'gentype_oblockend in
            let _7 = parseState.GetInput(7) :?> 'gentype_opt_classSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 851 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            (fun leadingKeyword mLhs nameInfo mEquals ->
                                let members = _4 @ (snd _5)
                                _2 leadingKeyword mLhs nameInfo mEquals (checkForMultipleAugmentations m members (snd _7))) 
                   )
//# 851 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfnRhsBlock));
//# 3968 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tyconSpfnRhs in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_classSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 857 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            (fun leadingKeyword mLhs nameInfo mEquals ->
                                let _, members = _2
                                _1 leadingKeyword mLhs nameInfo mEquals members) 
                   )
//# 857 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfnRhsBlock));
//# 3983 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypeDefnSimpleRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 866 "src/Compiler/pars.fsy"
                            (fun leadingKeyword mLhs nameInfo mEquals augmentation ->
                                let declRange = unionRanges mLhs _1.Range
                                let mWhole = (declRange, augmentation) ||> unionRangeWithListBy (fun (mem: SynMemberSig) -> mem.Range)
                                let trivia: SynTypeDefnSigTrivia = { LeadingKeyword = leadingKeyword; WithKeyword = None; EqualsRange = mEquals }
                                SynTypeDefnSig(nameInfo, SynTypeDefnSigRepr.Simple(_1, _1.Range), augmentation, mWhole, trivia)) 
                   )
//# 866 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfnRhs));
//# 3998 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tyconClassSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 873 "src/Compiler/pars.fsy"
                            let needsCheck, (kind, decls) = _1
                            let objectModelRange =
                                match decls with
                                | [] -> lhs parseState
                                | decls ->
                                    let start = mkSynRange parseState.ResultStartPosition parseState.ResultStartPosition
                                    (start, decls) ||> unionRangeWithListBy (fun (s: SynMemberSig) -> s.Range)
                            (fun leadingKeyword nameRange nameInfo mEquals augmentation ->
                                if needsCheck && isNil decls then
                                   reportParseErrorAt nameRange (FSComp.SR.parsEmptyTypeDefinition())
                                let declRange = unionRanges nameRange objectModelRange
                                let mWhole = (declRange, augmentation) ||> unionRangeWithListBy (fun (mem: SynMemberSig) -> mem.Range)
                                let trivia: SynTypeDefnSigTrivia = { LeadingKeyword = leadingKeyword; WithKeyword = None; EqualsRange = mEquals }
                                SynTypeDefnSig(nameInfo, SynTypeDefnSigRepr.ObjectModel(kind, decls, objectModelRange), augmentation, mWhole, trivia)) 
                   )
//# 873 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfnRhs));
//# 4022 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_topType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 891 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            let ty, arity = _3
                            let flags = AbstractMemberFlags true SynMemberKind.Member
                            let vis2 = SynValSigAccess.Single(None)
                            let valSig = SynValSig([], (SynIdent(mkSynId m "Invoke", None)), inferredTyparDecls, ty, arity, false, false, PreXmlDoc.Empty, vis2, None, m, SynValSigTrivia.Zero)
                            let invoke = SynMemberSig.Member(valSig, flags, m, SynMemberSigMemberTrivia.Zero)
                            (fun leadingKeyword nameRange nameInfo mEquals augmentation ->
                                if not (isNil augmentation) then raiseParseErrorAt m (FSComp.SR.parsAugmentationsIllegalOnDelegateType())
                                let mWhole = unionRanges nameRange m
                                let trivia: SynTypeDefnSigTrivia = { LeadingKeyword = leadingKeyword; WithKeyword = None; EqualsRange = mEquals }
                                SynTypeDefnSig(nameInfo, SynTypeDefnSigRepr.ObjectModel(SynTypeDefnKind.Delegate(ty, arity), [invoke], m), [], mWhole, trivia)) 
                   )
//# 891 "src/Compiler/pars.fsy"
                 : 'gentype_tyconSpfnRhs));
//# 4043 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classSpfnBlockKindUnspecified in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 908 "src/Compiler/pars.fsy"
                            let needsCheck, decls = _1
                            needsCheck, (SynTypeDefnKind.Unspecified, decls) 
                   )
//# 908 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassSpfn));
//# 4055 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classOrInterfaceOrStruct in
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 912 "src/Compiler/pars.fsy"
                            false, (_1, _2) 
                   )
//# 912 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassSpfn));
//# 4067 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classOrInterfaceOrStruct in
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 915 "src/Compiler/pars.fsy"
                            reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedClassInterfaceOrStruct())
                            false, (_1, _2) 
                   )
//# 915 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassSpfn));
//# 4081 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classOrInterfaceOrStruct in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 919 "src/Compiler/pars.fsy"
                            // silent recovery
                            false, (_1, []) 
                   )
//# 919 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassSpfn));
//# 4093 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 926 "src/Compiler/pars.fsy"
                            true, _2 
                   )
//# 926 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlockKindUnspecified));
//# 4105 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 929 "src/Compiler/pars.fsy"
                            if not _3 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedEndOfFileTypeSignature())
                            false, _2 
                   )
//# 929 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlockKindUnspecified));
//# 4118 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 934 "src/Compiler/pars.fsy"
                            false, _2 
                   )
//# 934 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlockKindUnspecified));
//# 4129 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 937 "src/Compiler/pars.fsy"
                            false, _2 
                   )
//# 937 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlockKindUnspecified));
//# 4141 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 943 "src/Compiler/pars.fsy"
                             _2 
                   )
//# 943 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlock));
//# 4153 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 946 "src/Compiler/pars.fsy"
                             if not _3 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedEndOfFileTypeSignature())
                             _2 
                   )
//# 946 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlock));
//# 4166 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classSpfnMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 949 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 949 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnBlock));
//# 4177 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classSpfnMembersAtLeastOne in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 954 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 954 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnMembers));
//# 4188 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 957 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 957 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnMembers));
//# 4198 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classMemberSpfn in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_classSpfnMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 963 "src/Compiler/pars.fsy"
                            _1 :: _3 
                   )
//# 963 "src/Compiler/pars.fsy"
                 : 'gentype_classSpfnMembersAtLeastOne));
//# 4211 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_memberSpecFlags in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_inline in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_access in
            let _6 = parseState.GetInput(6) :?> 'gentype_nameop in
            let _7 = parseState.GetInput(7) :?> 'gentype_opt_explicitValTyparDecls in
            let _9 = parseState.GetInput(9) :?> 'gentype_topTypeWithTypeConstraints in
            let _10 = parseState.GetInput(10) :?> 'gentype_classMemberSpfnGetSet in
            let _11 = parseState.GetInput(11) :?> 'gentype_optLiteralValueSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 969 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            let isInline, doc, vis2, id, explicitValTyparDecls, (ty, arity), (mEquals, optLiteralValue) = (Option.isSome _4), grabXmlDoc(parseState, _1, 1), _5, _6, _7, _9, _11
                            let mWith, (getSet, getSetRangeOpt, getterAccess, setterAccess) = _10
                            let vis2 =
                                match getterAccess, setterAccess with
                                | None, None -> SynValSigAccess.Single(vis2) 
                                | _ -> SynValSigAccess.GetSet(vis2, getterAccess, setterAccess)
                            let getSetAdjuster arity = match arity, getSet with SynValInfo([], _), SynMemberKind.Member -> SynMemberKind.PropertyGet | _ -> getSet
                            let mWhole =
                                let m = rhs parseState 3
                                match getSetRangeOpt with
                                | None -> unionRanges m ty.Range
                                | Some gs -> unionRanges m (gs: GetSetKeywords).Range
                                |> fun m -> (m, _1) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                |> unionRangeWithXmlDoc doc
                                |> fun m ->
                                    match optLiteralValue with
                                    | None -> m
                                    | Some e -> unionRanges m e.Range
                             
                            let flags, leadingKeyword = _3
                            if leadingKeywordIsAbstract leadingKeyword then 
                             [ _2; _5; getterAccess; setterAccess ]
                             |> List.iter (function None -> () | Some access -> errorR(Error(FSComp.SR.parsAccessibilityModsIllegalForAbstract(), access.Range)))
                            let flags = flags (getSetAdjuster arity)
                            let trivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _4; WithKeyword = mWith; EqualsRange = mEquals }
                            let valSpfn = SynValSig(_1, id, explicitValTyparDecls, ty, arity, isInline, false, doc, vis2, optLiteralValue, mWhole, trivia)
                            let trivia: SynMemberSigMemberTrivia = { GetSetKeywords = getSetRangeOpt }
                            SynMemberSig.Member(valSpfn, flags, mWhole, trivia) 
                   )
//# 969 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4259 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_interfaceMember in
            let _4 = parseState.GetInput(4) :?> 'gentype_appTypeWithoutNull in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1002 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            SynMemberSig.Interface(_4, unionRanges (rhs parseState 3) (_4).Range) 
                   )
//# 1002 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4274 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_appTypeWithoutNull in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1006 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR (Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                            SynMemberSig.Inherit(_4, unionRanges (rhs parseState 1) _4.Range) 
                   )
//# 1006 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4288 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1010 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR (Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                            let mInherit = rhs parseState 3
                            let ty = SynType.FromParseError(mInherit.EndRange)
                            SynMemberSig.Inherit(ty, unionRanges (rhs parseState 1) mInherit) 
                   )
//# 1010 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4304 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_fieldDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1016 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then
                                errorR (Error (FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                            let mStart = rhs parseState 1
                            let mVal = rhs parseState 3
                            let leadingKeyword = Some(SynLeadingKeyword.Val mVal)
                            let (SynField(xmlDoc = xmlDoc; range = range)) as field = _4 _1 None mStart leadingKeyword
                            SynMemberSig.ValField(field, range) 
                   )
//# 1016 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4323 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _5 = parseState.GetInput(5) :?> 'gentype_fieldDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1025 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then
                                errorR (Error (FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                            let mStart = rhs parseState 1
                            let mStatic = rhs parseState 3
                            let mVal = rhs parseState 4
                            let leadingKeyword = Some(SynLeadingKeyword.StaticVal(mStatic, mVal))
                            let (SynField(xmlDoc = xmlDoc; range = range)) as field = _5 _1 (Some mStatic) mStart leadingKeyword
                            SynMemberSig.ValField(field, range) 
                   )
//# 1025 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4343 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_typeKeyword in
            let _5 = parseState.GetInput(5) :?> 'gentype_tyconSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1035 "src/Compiler/pars.fsy"
                            let leadingKeyword = SynTypeDefnLeadingKeyword.StaticType(rhs parseState 3, rhs parseState 4)
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            SynMemberSig.NestedType(_5 leadingKeyword, rhs2 parseState 1 5) 
                   )
//# 1035 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4359 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _5 = parseState.GetInput(5) :?> 'gentype_topTypeWithTypeConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1040 "src/Compiler/pars.fsy"
                            let vis, doc, (ty, valSynInfo) = _2, grabXmlDoc(parseState, _1, 1), _5
                            let vis2 = SynValSigAccess.Single(vis)
                            let mNew = rhs parseState 3
                            let m = unionRanges (rhs parseState 1) ty.Range |> unionRangeWithXmlDoc doc
                            let isInline = false
                            let trivia: SynValSigTrivia = { LeadingKeyword = SynLeadingKeyword.New mNew; InlineKeyword = None; WithKeyword = None; EqualsRange = None }
                            let valSpfn = SynValSig (_1, (SynIdent(mkSynId (rhs parseState 3) "new", None)), noInferredTypars, ty, valSynInfo, isInline, false, doc, vis2, None, m, trivia)
                            SynMemberSig.Member(valSpfn, CtorMemberFlags, m, SynMemberSigMemberTrivia.Zero) 
                   )
//# 1040 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfn));
//# 4379 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1053 "src/Compiler/pars.fsy"
                           None, (SynMemberKind.Member, None, None, None) 
                   )
//# 1053 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSet));
//# 4389 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classMemberSpfnGetSetElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1056 "src/Compiler/pars.fsy"
                           let mWith = rhs parseState 1
                           Some mWith, _2 
                   )
//# 1056 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSet));
//# 4401 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classMemberSpfnGetSetElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1060 "src/Compiler/pars.fsy"
                           let mWith = rhs parseState 1
                           Some mWith, _2 
                   )
//# 1060 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSet));
//# 4413 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classMemberSpfnGetSetElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1064 "src/Compiler/pars.fsy"
                           let mWith = rhs parseState 1
                           reportParseErrorAt mWith (FSComp.SR.parsUnmatchedWith())
                           Some mWith, _2 
                   )
//# 1064 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSet));
//# 4426 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_access in
            let _2 = parseState.GetInput(2) :?> 'gentype_nameop in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1072 "src/Compiler/pars.fsy"
                           (let (SynIdent(id:Ident, _)) = _2
                            if id.idText = "get" then
                                SynMemberKind.PropertyGet, Some(GetSetKeywords.Get id.idRange), _1, None
                            else if id.idText = "set" then
                                SynMemberKind.PropertySet, Some(GetSetKeywords.Set id.idRange), None, _1
                            else
                                raiseParseErrorAt (rhs parseState 1) (FSComp.SR.parsGetOrSetRequired())) 
                   )
//# 1072 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSetElements));
//# 4444 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_access in
            let _2 = parseState.GetInput(2) :?> 'gentype_nameop in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_access in
            let _5 = parseState.GetInput(5) :?> 'gentype_nameop in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1081 "src/Compiler/pars.fsy"
                           let (SynIdent(id, _)) = _2
                           let (SynIdent(id2, _)) = _5
                           if not ((id.idText = "get" && id2.idText = "set") ||
                                   (id.idText = "set" && id2.idText = "get")) then
                              raiseParseErrorAt (rhs2 parseState 1 3) (FSComp.SR.parsGetOrSetRequired())
                           if id.idText = "get" then
                               SynMemberKind.PropertyGetSet, Some(GetSetKeywords.GetSet(id.idRange, id2.idRange)), _1, _4
                           else
                               SynMemberKind.PropertyGetSet, Some(GetSetKeywords.GetSet(id2.idRange, id.idRange)), _4, _1 
                   )
//# 1081 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSetElements));
//# 4466 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_access in
            let _2 = parseState.GetInput(2) :?> 'gentype_nameop in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1093 "src/Compiler/pars.fsy"
                           (let (SynIdent(id:Ident, _)) = _2
                            if id.idText = "get" then
                                SynMemberKind.PropertyGet, Some(GetSetKeywords.Get id.idRange), _1, None
                            else if id.idText = "set" then
                                SynMemberKind.PropertySet, Some(GetSetKeywords.Set id.idRange), None, _1
                            else
                                raiseParseErrorAt (rhs parseState 2) (FSComp.SR.parsGetOrSetRequired())) 
                   )
//# 1093 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSetElements));
//# 4485 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_oblockend in
            let _3 = parseState.GetInput(3) :?> range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1102 "src/Compiler/pars.fsy"
                           reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsIdentifierExpected())
                           SynMemberKind.Member, None, None, None 
                   )
//# 1102 "src/Compiler/pars.fsy"
                 : 'gentype_classMemberSpfnGetSetElements));
//# 4498 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_memberFlags in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1106 "src/Compiler/pars.fsy"
                                       _1 
                   )
//# 1106 "src/Compiler/pars.fsy"
                 : 'gentype_memberSpecFlags));
//# 4509 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_abstractMemberFlags in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1107 "src/Compiler/pars.fsy"
                                               _1 
                   )
//# 1107 "src/Compiler/pars.fsy"
                 : 'gentype_memberSpecFlags));
//# 4520 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynExceptionDefnRepr in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_classSpfn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1113 "src/Compiler/pars.fsy"
                            let mWithKwd, members = _2
                            SynExceptionSig(_1, mWithKwd, members, lhs parseState) 
                   )
//# 1113 "src/Compiler/pars.fsy"
                 : 'gentype_exconSpfn));
//# 4533 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classSpfnBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_declEnd in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1120 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            (Some mWithKwd), _2 
                   )
//# 1120 "src/Compiler/pars.fsy"
                 : 'gentype_opt_classSpfn));
//# 4546 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1124 "src/Compiler/pars.fsy"
                            None, [] 
                   )
//# 1124 "src/Compiler/pars.fsy"
                 : 'gentype_opt_classSpfn));
//# 4556 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceImpls in
            let _2 = parseState.GetInput(2) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1133 "src/Compiler/pars.fsy"
                            checkEndOfFileError _2; _1 
                   )
//# 1133 "src/Compiler/pars.fsy"
                 : ParsedImplFile));
//# 4568 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceImpls in
            let _3 = parseState.GetInput(3) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1136 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 1136 "src/Compiler/pars.fsy"
                 : ParsedImplFile));
//# 4580 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1142 "src/Compiler/pars.fsy"
                            let emptyImplFileFrag = ParsedImplFileFragment.AnonModule([], rhs parseState 1)
                            ParsedImplFile ([], [emptyImplFileFrag]) 
                   )
//# 1142 "src/Compiler/pars.fsy"
                 : ParsedImplFile));
//# 4592 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileModuleImpl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1149 "src/Compiler/pars.fsy"
                             ParsedImplFile ([], [ (_1 (None, false, [], PreXmlDoc.Empty)) ]) 
                   )
//# 1149 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceImpls));
//# 4603 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileModuleImpl in
            let _2 = parseState.GetInput(2) :?> 'gentype_fileNamespaceImplList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1152 "src/Compiler/pars.fsy"
                             // If there are namespaces, the first fileModuleImpl may only contain # directives
                             let decls =
                                 match (_1 (None, false, [], PreXmlDoc.Empty)) with
                                 | ParsedImplFileFragment.AnonModule(decls, m) -> decls
                                 | ParsedImplFileFragment.NamespaceFragment(decls = decls) -> decls
                                 | ParsedImplFileFragment.NamedModule(SynModuleOrNamespace(range = m)) ->
                                     raiseParseErrorAt m (FSComp.SR.parsOnlyHashDirectivesAllowed())
                             let decls =
                                 decls |> List.collect (function
                                     | (SynModuleDecl.HashDirective(hd, _)) -> [hd]
                                     | d ->
                                          reportParseErrorAt d.Range (FSComp.SR.parsOnlyHashDirectivesAllowed())
                                          [])
                             ParsedImplFile (decls, _2) 
                   )
//# 1152 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceImpls));
//# 4628 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceImpl in
            let _2 = parseState.GetInput(2) :?> 'gentype_fileNamespaceImplList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1171 "src/Compiler/pars.fsy"
                            _1 :: _2 
                   )
//# 1171 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceImplList));
//# 4640 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_fileNamespaceImpl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1174 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 1174 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceImplList));
//# 4651 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_namespaceIntro in
            let _2 = parseState.GetInput(2) :?> 'gentype_deprecated_opt_equals in
            let _3 = parseState.GetInput(3) :?> 'gentype_fileModuleImpl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1180 "src/Compiler/pars.fsy"
                            let mNamespace, isRec, path, xml = _1
                            _3 (Some mNamespace, isRec, path, xml) 
                   )
//# 1180 "src/Compiler/pars.fsy"
                 : 'gentype_fileNamespaceImpl));
//# 4665 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            let _4 = parseState.GetInput(4) :?> SynModuleDecl list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1187 "src/Compiler/pars.fsy"
                           if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                           let m2 = rhs parseState 3
                           let mDeclsAndAttrs = (List.map (fun (a: SynAttributeList) -> a.Range) _1) @ (List.map (fun (d: SynModuleDecl) -> d.Range) _4)
                           let xmlDoc = grabXmlDoc(parseState, _1, 1)
                           let m = (m2, mDeclsAndAttrs) ||> unionRangeWithListBy id |> unionRangeWithXmlDoc xmlDoc
                           let mModule, isRec2, path2, vis, attribs2 = _3
                           (fun (mNamespaceOpt, isRec, path, _) ->
                             if not (isNil path) then errorR(Error(FSComp.SR.parsNamespaceOrModuleNotBoth(), m2))
                             let lid = path@path2
                             let trivia: SynModuleOrNamespaceTrivia = { LeadingKeyword = SynModuleOrNamespaceLeadingKeyword.Module mModule }
                             ParsedImplFileFragment.NamedModule(SynModuleOrNamespace(lid, (isRec || isRec2), SynModuleOrNamespaceKind.NamedModule, _4, xmlDoc, _1@attribs2, vis, m, trivia))) 
                   )
//# 1187 "src/Compiler/pars.fsy"
                 : 'gentype_fileModuleImpl));
//# 4689 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynModuleDecl list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1200 "src/Compiler/pars.fsy"
                           let m = (rhs parseState 1)
                           (fun (mNamespaceOpt, isRec, path, xml) ->
                             match path, mNamespaceOpt with
                             | [], None -> ParsedImplFileFragment.AnonModule(_1, m)
                             | _ ->
                                 let lastDeclRange = List.tryLast _1 |> Option.map (fun decl -> decl.Range) |> Option.defaultValue (rhs parseState 1)
                                 let m = withStart (lhs parseState).Start lastDeclRange
                                 xml.MarkAsInvalid()
                                 let trivia: SynModuleOrNamespaceTrivia =
                                     match mNamespaceOpt with
                                      | None -> { LeadingKeyword = SynModuleOrNamespaceLeadingKeyword.None }
                                      | Some mNamespace -> { LeadingKeyword = SynModuleOrNamespaceLeadingKeyword.Namespace mNamespace }
                                 ParsedImplFileFragment.NamespaceFragment(path, isRec, SynModuleOrNamespaceKind.DeclaredNamespace, _1, PreXmlDoc.Empty, [], m, trivia)) 
                   )
//# 1200 "src/Compiler/pars.fsy"
                 : 'gentype_fileModuleImpl));
//# 4712 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefnsOrExprPossiblyEmpty in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1218 "src/Compiler/pars.fsy"
                            _2 
                   )
//# 1218 "src/Compiler/pars.fsy"
                 : SynModuleDecl list));
//# 4725 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefnsOrExprPossiblyEmpty in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1221 "src/Compiler/pars.fsy"
                            // The lex filter ensures we can only get a mismatch in OBLOCKBEGIN/OBLOCKEND tokens if there was some other kind of error, hence we don't need to report this error
                            // reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnClosedBlockInHashLight())
                            _2 
                   )
//# 1221 "src/Compiler/pars.fsy"
                 : SynModuleDecl list));
//# 4739 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1226 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 1226 "src/Compiler/pars.fsy"
                 : SynModuleDecl list));
//# 4750 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefnsOrExprPossiblyEmpty in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1229 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 1229 "src/Compiler/pars.fsy"
                 : SynModuleDecl list));
//# 4761 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefnsOrExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1235 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 1235 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExprPossiblyEmpty));
//# 4772 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1238 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 1238 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExprPossiblyEmpty));
//# 4782 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynExpr in
            let _4 = parseState.GetInput(4) :?> 'gentype_topSeparators in
            let _5 = parseState.GetInput(5) :?> 'gentype_moduleDefnsOrExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1245 "src/Compiler/pars.fsy"
                             match _2 with
                             | Some vis -> errorR(Error(FSComp.SR.parsUnexpectedVisibilityDeclaration(vis.ToString()), rhs parseState 3))
                             | _ -> ()
                             let attrDecls = if not (isNil _1) then [ SynModuleDecl.Attributes(_1, rangeOfNonNilAttrs _1) ] else []
                             attrDecls @ mkSynExprDecl _3 :: _5 
                   )
//# 1245 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExpr));
//# 4801 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynExpr in
            let _4 = parseState.GetInput(4) :?> 'gentype_topSeparators in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1252 "src/Compiler/pars.fsy"
                             match _2 with
                             | Some vis -> errorR(Error(FSComp.SR.parsUnexpectedVisibilityDeclaration(vis.ToString()), rhs parseState 3))
                             | _ -> ()
                             let attrDecls = if not (isNil _1) then [ SynModuleDecl.Attributes(_1, rangeOfNonNilAttrs _1) ] else []
                             attrDecls @ [ mkSynExprDecl _3 ] 
                   )
//# 1252 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExpr));
//# 4819 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1259 "src/Compiler/pars.fsy"
                             match _2 with
                             | Some vis -> errorR(Error(FSComp.SR.parsUnexpectedVisibilityDeclaration(vis.ToString()), rhs parseState 3))
                             | _ -> ()
                             let attrDecls = if not (isNil _1) then [ SynModuleDecl.Attributes(_1, rangeOfNonNilAttrs _1) ] else []
                             attrDecls @ [ mkSynExprDecl _3 ] 
                   )
//# 1259 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExpr));
//# 4836 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1266 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 1266 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExpr));
//# 4847 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1269 "src/Compiler/pars.fsy"
                            if not (isNil _1) then [ SynModuleDecl.Attributes(_1, rangeOfNonNilAttrs _1) ] else [] 
                   )
//# 1269 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnsOrExpr));
//# 4858 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefnOrDirective in
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1275 "src/Compiler/pars.fsy"
                             _1 @ _2 
                   )
//# 1275 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefns));
//# 4870 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefnOrDirective in
            let _2 = parseState.GetInput(2) :?> 'gentype_topSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleDefnsOrExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1278 "src/Compiler/pars.fsy"
                             _1 @ _3 
                   )
//# 1278 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefns));
//# 4883 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefnOrDirective in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1281 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 1281 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefns));
//# 4894 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefnOrDirective in
            let _2 = parseState.GetInput(2) :?> 'gentype_topSeparators in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1284 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 1284 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefns));
//# 4906 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_topSeparators in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleDefnsOrExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1287 "src/Compiler/pars.fsy"
                             _3 
                   )
//# 1287 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefns));
//# 4918 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1293 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 1293 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnOrDirective));
//# 4929 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hashDirective in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1296 "src/Compiler/pars.fsy"
                             [ SynModuleDecl.HashDirective(_1, rhs2 parseState 1 1) ] 
                   )
//# 1296 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefnOrDirective));
//# 4940 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_defnBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1305 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             (getSynArgNameGenerator parseState.LexBuffer).Reset()
                             let (BindingSetPreAttrs(_, _, _, _, mWhole)) = _3
                             mkDefnBindings (mWhole, _3, _1, _2, mWhole) 
                   )
//# 1305 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 4956 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_hardwhiteLetBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1312 "src/Compiler/pars.fsy"
                             let hwlb, m, _ = _3
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             (getSynArgNameGenerator parseState.LexBuffer).Reset()
                             mkDefnBindings (m, hwlb, _1, _2, m) 
                   )
//# 1312 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 4972 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_doBinding in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1319 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let mWhole = rhs parseState 3
                             mkDefnBindings (mWhole, _3, _1, _2, mWhole) 
                   )
//# 1319 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 4987 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_typeKeyword in
            let _4 = parseState.GetInput(4) :?> 'gentype_tyconDefn in
            let _5 = parseState.GetInput(5) :?> 'gentype_tyconDefnList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1325 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             let leadingKeyword = SynTypeDefnLeadingKeyword.Type(rhs parseState 3)
                             let (SynTypeDefn(SynComponentInfo(cas, a, cs, b, _xmlDoc, d, d2, d3), e, f, g, h, trivia)) = _4 leadingKeyword
                             _xmlDoc.MarkAsInvalid()
                             let attrs = _1@cas
                             let mDefn = (h, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range) |> unionRangeWithXmlDoc xmlDoc
                             let tc = SynTypeDefn(SynComponentInfo(attrs, a, cs, b, xmlDoc, d, d2, d3), e, f, g, mDefn, trivia)
                             let types = tc :: _5
                             [ SynModuleDecl.Types(types, (rhs parseState 3, types) ||> unionRangeWithListBy (fun t -> t.Range)) ] 
                   )
//# 1325 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 5011 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynExceptionDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1338 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let (SynExceptionDefn(SynExceptionDefnRepr(cas, a, b, c, d, d2), withKeyword, e, f)) = _3
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             let defnReprRange = (d2, _1) ||> unionRangeWithListBy (fun a -> a.Range) |> unionRangeWithXmlDoc xmlDoc
                             let mWhole = (f, _1) ||> unionRangeWithListBy (fun a -> a.Range) |> unionRangeWithXmlDoc xmlDoc
                             let synExnDefn = SynExceptionDefn(SynExceptionDefnRepr(_1@cas, a, b, xmlDoc, d, defnReprRange), withKeyword, e, mWhole)
                             [ SynModuleDecl.Exception(synExnDefn, mWhole) ] 
                   )
//# 1338 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 5030 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            let _5 = parseState.GetInput(5) :?> 'gentype_namedModuleDefnBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1348 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                             let attribs, (mModule, isRec, path, vis, attribs2) = _1, _3
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             match _5 with
                             | Choice1Of2 eqn ->
                                 if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                                 if isRec then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsInvalidUseOfRec())
                                 if not (isSingleton path) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsModuleAbbreviationMustBeSimpleName())
                                 if not (isNil attribs) then raiseParseErrorAt (rhs parseState 1) (FSComp.SR.parsIgnoreAttributesOnModuleAbbreviation())
                                 if not (isNil attribs2) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsIgnoreAttributesOnModuleAbbreviation())
                                 match vis with
                                 | Some vis -> raiseParseErrorAt (rhs parseState 1) (FSComp.SR.parsIgnoreAttributesOnModuleAbbreviationAlwaysPrivate(vis.ToString()))
                                 | None -> ()
                                 [ SynModuleDecl.ModuleAbbrev(List.head path, eqn, (rhs parseState 3, eqn) ||> unionRangeWithListBy (fun id -> id.idRange)) ]
                             | Choice2Of2 (def, mEndOpt) ->
                                 if not (isSingleton path) then raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsModuleAbbreviationMustBeSimpleName())
                                 let info = SynComponentInfo(attribs @ attribs2, None, [], path, xmlDoc, false, vis, rhs parseState 3)
                                 let mEquals = rhs parseState 4
                                 let trivia: SynModuleDeclNestedModuleTrivia = { ModuleKeyword = Some mModule; EqualsRange = Some mEquals }
                                 let m =
                                     (rhs2 parseState 1 4, def)
                                     ||> unionRangeWithListBy (fun (d: SynModuleDecl) -> d.Range)
                                     |> unionRangeWithXmlDoc xmlDoc
                                 let m = match mEndOpt with | None -> m | Some mEnd -> unionRanges m mEnd
                                 [ SynModuleDecl.NestedModule(info, isRec, def, false, m, trivia) ] 
                   )
//# 1348 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 5068 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_moduleIntro in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1376 "src/Compiler/pars.fsy"
                             let xmlDoc = grabXmlDoc(parseState, _1, 1)
                             let mWhole = rhs2 parseState 1 3 |> unionRangeWithXmlDoc xmlDoc
                             let attribs, (mModule, isRec, path, vis, attribs2) = _1, _3
                             let info = SynComponentInfo(attribs @ attribs2, None, [], path, xmlDoc, false, vis, rhs parseState 3)
                             let trivia: SynModuleDeclNestedModuleTrivia = { ModuleKeyword = Some mModule; EqualsRange = None }
                             [ SynModuleDecl.NestedModule(info, isRec, [], false, mWhole, trivia) ] 
                   )
//# 1376 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 5086 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1385 "src/Compiler/pars.fsy"
                             errorR(Error(FSComp.SR.parsAttributeOnIncompleteCode(), rhs parseState 1))
                             [ SynModuleDecl.Attributes(_1, rhs parseState 1) ] 
                   )
//# 1385 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 5099 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_openDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1390 "src/Compiler/pars.fsy"
                             [ SynModuleDecl.Open _1 ] 
                   )
//# 1390 "src/Compiler/pars.fsy"
                 : 'gentype_moduleDefn));
//# 5110 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1394 "src/Compiler/pars.fsy"
                             let mOpen = rhs parseState 1
                             let mPath = _2.Range
                             SynOpenDeclTarget.ModuleOrNamespace(_2, mPath), unionRanges mOpen mPath 
                   )
//# 1394 "src/Compiler/pars.fsy"
                 : 'gentype_openDecl));
//# 5123 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1399 "src/Compiler/pars.fsy"
                             let mOpen = rhs parseState 1
                             SynOpenDeclTarget.ModuleOrNamespace(SynLongIdent([], [], []), mOpen.EndRange), mOpen 
                   )
//# 1399 "src/Compiler/pars.fsy"
                 : 'gentype_openDecl));
//# 5135 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typeKeyword in
            let _3 = parseState.GetInput(3) :?> 'gentype_appTypeWithoutNull in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1403 "src/Compiler/pars.fsy"
                             let mOpen = rhs parseState 1
                             let mPath = _3.Range
                             SynOpenDeclTarget.Type(_3, mPath), unionRanges mOpen mPath 
                   )
//# 1403 "src/Compiler/pars.fsy"
                 : 'gentype_openDecl));
//# 5149 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typeKeyword in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1408 "src/Compiler/pars.fsy"
                             let m = rhs2 parseState 1 2
                             SynOpenDeclTarget.ModuleOrNamespace(SynLongIdent([], [], []), m.EndRange), m 
                   )
//# 1408 "src/Compiler/pars.fsy"
                 : 'gentype_openDecl));
//# 5162 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1416 "src/Compiler/pars.fsy"
                            _2 
                   )
//# 1416 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleAbbrevBlock));
//# 5174 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1419 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 1419 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleAbbrevBlock));
//# 5185 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_wrappedNamedModuleDefn in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1425 "src/Compiler/pars.fsy"
                            Choice2Of2 _2 
                   )
//# 1425 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5197 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_wrappedNamedModuleDefn in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1428 "src/Compiler/pars.fsy"
                            // The lex filter ensures we can only get a mismatch in OBLOCKBEGIN/OBLOCKEND tokens if there was some other kind of error, hence we don't need to report this error
                            Choice2Of2 _2 
                   )
//# 1428 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5210 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefnsOrExpr in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1432 "src/Compiler/pars.fsy"
                              // There is an ambiguity here
                              // In particular, consider the following two:
                              //
                              // module M2 =
                              //    System.DateTime.Now
                              // module M2 =
                              //    Microsoft.FSharp.Core.List
                              // The second is a module abbreviation, the first a module containing a single expression.
                              // The resolution is in favour of the module abbreviation, i.e. anything of the form
                              //    module M2 = ID.ID.ID.ID
                              // will be taken as a module abbreviation, regardless of the identifiers themselves.
                              //
                              // This is similar to the ambiguity between
                              //    type X = int
                              // and
                              //    type X = OneValue
                              // However in that case we do use type name lookup to make the resolution.
                              match _2 with
                              | [ SynModuleDecl.Expr(LongOrSingleIdent(false, SynLongIdent(path, _, _), None, _), _) ] ->
                                  Choice1Of2  path
                              | _ ->
                                  Choice2Of2 (_2, None)
                            
                   )
//# 1432 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5244 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefnsOrExpr in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1458 "src/Compiler/pars.fsy"
                            // The lex filter ensures we can only get a mismatch in OBLOCKBEGIN/OBLOCKEND tokens if there was some other kind of error, hence we don't need to report this error
                            // reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnClosedBlockInHashLight())
                            Choice2Of2 (_2, None) 
                   )
//# 1458 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5258 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1463 "src/Compiler/pars.fsy"
                            let mEnd = rhs parseState 3
                            Choice2Of2 ([], Some mEnd) 
                   )
//# 1463 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5270 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_wrappedNamedModuleDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1467 "src/Compiler/pars.fsy"
                            Choice2Of2 _1 
                   )
//# 1467 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5281 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1470 "src/Compiler/pars.fsy"
                            Choice1Of2 _1.LongIdent 
                   )
//# 1470 "src/Compiler/pars.fsy"
                 : 'gentype_namedModuleDefnBlock));
//# 5292 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_structOrBegin in
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefnsOrExprPossiblyEmpty in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1476 "src/Compiler/pars.fsy"
                            let mEnd = rhs parseState 3
                            _2, Some mEnd 
                   )
//# 1476 "src/Compiler/pars.fsy"
                 : 'gentype_wrappedNamedModuleDefn));
//# 5305 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_structOrBegin in
            let _2 = parseState.GetInput(2) :?> 'gentype_moduleDefnsOrExprPossiblyEmpty in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1480 "src/Compiler/pars.fsy"
                            reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedBeginOrStruct())
                            _2, None 
                   )
//# 1480 "src/Compiler/pars.fsy"
                 : 'gentype_wrappedNamedModuleDefn));
//# 5319 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_structOrBegin in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1484 "src/Compiler/pars.fsy"
                            let mEnd = rhs parseState 3
                            [], Some mEnd 
                   )
//# 1484 "src/Compiler/pars.fsy"
                 : 'gentype_wrappedNamedModuleDefn));
//# 5331 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_declEnd in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1490 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            mWithKwd, _2 
                   )
//# 1490 "src/Compiler/pars.fsy"
                 : range * SynMemberDefns));
//# 5344 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributes in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1497 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 1497 "src/Compiler/pars.fsy"
                 : 'gentype_opt_attributes));
//# 5355 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1500 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 1500 "src/Compiler/pars.fsy"
                 : 'gentype_opt_attributes));
//# 5365 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributeList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1505 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 1505 "src/Compiler/pars.fsy"
                 : 'gentype_attributes));
//# 5376 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributeList in
            let _2 = parseState.GetInput(2) :?> 'gentype_attributes in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1508 "src/Compiler/pars.fsy"
                            _1 @ _2 
                   )
//# 1508 "src/Compiler/pars.fsy"
                 : 'gentype_attributes));
//# 5388 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_attributeListElements in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_seps in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1514 "src/Compiler/pars.fsy"
                             mkAttributeList _2 (rhs2 parseState 1 4) 
                   )
//# 1514 "src/Compiler/pars.fsy"
                 : 'gentype_attributeList));
//# 5401 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1517 "src/Compiler/pars.fsy"
                             mkAttributeList [] (rhs2 parseState 1 3) 
                   )
//# 1517 "src/Compiler/pars.fsy"
                 : 'gentype_attributeList));
//# 5412 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_attributeListElements in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_seps in
            let _4 = parseState.GetInput(4) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1520 "src/Compiler/pars.fsy"
                             if not _4 then reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedLBrackLess())
                             mkAttributeList _2 (rhs2 parseState 1 2) 
                   )
//# 1520 "src/Compiler/pars.fsy"
                 : 'gentype_attributeList));
//# 5426 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1524 "src/Compiler/pars.fsy"
                             if not _2 then reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedLBrackLess())
                             mkAttributeList [] (rhs parseState 1) 
                   )
//# 1524 "src/Compiler/pars.fsy"
                 : 'gentype_attributeList));
//# 5438 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attribute in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1531 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 1531 "src/Compiler/pars.fsy"
                 : 'gentype_attributeListElements));
//# 5449 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributeListElements in
            let _2 = parseState.GetInput(2) :?> 'gentype_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_attribute in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1534 "src/Compiler/pars.fsy"
                            _1 @ [_3] 
                   )
//# 1534 "src/Compiler/pars.fsy"
                 : 'gentype_attributeListElements));
//# 5462 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongIdent in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_atomicExprAfterType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1541 "src/Compiler/pars.fsy"
                            let arg = match _3 with None -> mkSynUnit _1.Range | Some e -> e
                            let m = unionRanges _1.Range arg.Range
                            ({ TypeName = _1; ArgExpr = arg; Target = None; AppliesToGetterAndSetter = false; Range = m }: SynAttribute) 
                   )
//# 1541 "src/Compiler/pars.fsy"
                 : 'gentype_attribute));
//# 5477 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributeTarget in
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_atomicExprAfterType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1547 "src/Compiler/pars.fsy"
                            let arg = match _4 with None -> mkSynUnit _2.Range | Some e -> e
                            let startRange = match _1 with Some(ident:Ident) -> ident.idRange | None -> _2.Range
                            let m = unionRanges startRange arg.Range
                            ({ TypeName = _2; ArgExpr = arg; Target = _1; AppliesToGetterAndSetter = false; Range = m }: SynAttribute) 
                   )
//# 1547 "src/Compiler/pars.fsy"
                 : 'gentype_attribute));
//# 5494 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attributeTarget in
            let _3 = parseState.GetInput(3) :?> SynLongIdent in
            let _4 = parseState.GetInput(4) :?> 'gentype_oblockend in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _6 = parseState.GetInput(6) :?> 'gentype_opt_atomicExprAfterType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1554 "src/Compiler/pars.fsy"
                            let arg = match _6 with None -> mkSynUnit _3.Range | Some e -> e
                            let startRange = match _1 with Some ident -> ident.idRange | None -> _3.Range
                            let m = unionRanges startRange arg.Range
                            ({ TypeName = _3; ArgExpr = arg; Target = _1; AppliesToGetterAndSetter = false; Range = m }: SynAttribute) 
                   )
//# 1554 "src/Compiler/pars.fsy"
                 : 'gentype_attribute));
//# 5512 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_moduleKeyword in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1563 "src/Compiler/pars.fsy"
                             Some(ident("module", (rhs parseState 1))) 
                   )
//# 1563 "src/Compiler/pars.fsy"
                 : 'gentype_attributeTarget));
//# 5523 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeKeyword in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1566 "src/Compiler/pars.fsy"
                             Some(ident("type", (rhs parseState 1))) 
                   )
//# 1566 "src/Compiler/pars.fsy"
                 : 'gentype_attributeTarget));
//# 5534 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1568 "src/Compiler/pars.fsy"
                                       Some(_1) 
                   )
//# 1568 "src/Compiler/pars.fsy"
                 : 'gentype_attributeTarget));
//# 5545 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1572 "src/Compiler/pars.fsy"
                             if _1 then reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsSyntaxError())
                             Some(ident("return", (rhs parseState 1))) 
                   )
//# 1572 "src/Compiler/pars.fsy"
                 : 'gentype_attributeTarget));
//# 5557 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1578 "src/Compiler/pars.fsy"
                             let mStatic = rhs parseState 1
                             let mMember = rhs parseState 2
                             StaticMemberFlags, SynLeadingKeyword.StaticMember(mStatic, mMember) 
                   )
//# 1578 "src/Compiler/pars.fsy"
                 : 'gentype_memberFlags));
//# 5569 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1583 "src/Compiler/pars.fsy"
                             let mStatic = rhs parseState 1
                             // todo: it should be possible to make it work better for both `abstract` and `member` in the type checker
                             StaticMemberFlags, SynLeadingKeyword.Static(mStatic) 
                   )
//# 1583 "src/Compiler/pars.fsy"
                 : 'gentype_memberFlags));
//# 5581 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1588 "src/Compiler/pars.fsy"
                             let mMember = rhs parseState 1
                             NonVirtualMemberFlags, SynLeadingKeyword.Member mMember 
                   )
//# 1588 "src/Compiler/pars.fsy"
                 : 'gentype_memberFlags));
//# 5592 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1592 "src/Compiler/pars.fsy"
                             let mOverride = rhs parseState 1
                             OverrideMemberFlags, SynLeadingKeyword.Override mOverride 
                   )
//# 1592 "src/Compiler/pars.fsy"
                 : 'gentype_memberFlags));
//# 5603 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1596 "src/Compiler/pars.fsy"
                             let mDefault = rhs parseState 1
                             OverrideMemberFlags, SynLeadingKeyword.Default mDefault 
                   )
//# 1596 "src/Compiler/pars.fsy"
                 : 'gentype_memberFlags));
//# 5614 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_tyconNameAndTyparDecls in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_typeConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1602 "src/Compiler/pars.fsy"
                            let typars, lid, fixity, vis = _2
                            let xmlDoc = grabXmlDoc(parseState, _1, 1)
                            let m = match lid with [] -> rhs parseState 2 | _ -> rangeOfLid lid
                            SynComponentInfo (_1, typars, _3, lid, xmlDoc, fixity, vis, m) 
                   )
//# 1602 "src/Compiler/pars.fsy"
                 : 'gentype_typeNameInfo));
//# 5630 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_tyconDefn in
            let _3 = parseState.GetInput(3) :?> 'gentype_tyconDefnList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1610 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc(parseState, [], 1)
                            let tyconDefn =
                                let leadingKeyword = SynTypeDefnLeadingKeyword.And(rhs parseState 1)
                                let (SynTypeDefn(componentInfo, typeRepr, members, implicitConstructor, range, trivia) as typeDefn) = _2 leadingKeyword
                                let (SynComponentInfo(a, typars, c, lid, _xmlDoc, fixity, vis, mLongId)) = componentInfo
                                if xmlDoc.IsEmpty then
                                    if _xmlDoc.IsEmpty then typeDefn else
                                    let range = unionRangeWithXmlDoc _xmlDoc range
                                    SynTypeDefn(componentInfo, typeRepr, members, implicitConstructor, range, trivia)
                                else
                                    _xmlDoc.MarkAsInvalid()
                                    let range = unionRangeWithXmlDoc xmlDoc range
                                    let componentInfo = SynComponentInfo (a, typars, c, lid, xmlDoc, fixity, vis, mLongId)
                                    SynTypeDefn(componentInfo, typeRepr, members, implicitConstructor, range, trivia)
                            tyconDefn :: _3 
                   )
//# 1610 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnList));
//# 5656 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1627 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 1627 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnList));
//# 5666 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeNameInfo in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1632 "src/Compiler/pars.fsy"
                            fun leadingKeyword ->
                                let trivia: SynTypeDefnTrivia = { LeadingKeyword = leadingKeyword; EqualsRange = None; WithKeyword = None }
                                SynTypeDefn(_1, SynTypeDefnRepr.Simple(SynTypeDefnSimpleRepr.None(_1.Range), _1.Range), [], None, _1.Range, trivia) 
                   )
//# 1632 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefn));
//# 5679 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeNameInfo in
            let _2 = parseState.GetInput(2) :?> range * SynMemberDefns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1637 "src/Compiler/pars.fsy"
                            let mWithKwd, classDefns = _2
                            let m = (rhs parseState 1, classDefns) ||> unionRangeWithListBy (fun mem -> mem.Range)
                            fun leadingKeyword ->
                                let trivia: SynTypeDefnTrivia = { LeadingKeyword = leadingKeyword; EqualsRange = None; WithKeyword = None }
                                SynTypeDefn(_1, SynTypeDefnRepr.ObjectModel(SynTypeDefnKind.Augmentation mWithKwd, [], m), classDefns, None, m, trivia) 
                   )
//# 1637 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefn));
//# 5695 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeNameInfo in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_simplePatterns in
            let _6 = parseState.GetInput(6) :?> 'gentype_optAsSpec in
            let _8 = parseState.GetInput(8) :?> 'gentype_tyconDefnRhsBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1644 "src/Compiler/pars.fsy"
                            let vis, pat, az = _3, _5, _6
                            let nameRange = rhs parseState 1
                            let (tcDefRepr, mWith, members) = _8 nameRange
                            let (SynComponentInfo(_, _, _, lid, _, _, _, _)) = _1
                            let mEquals = rhs parseState 7
                            // Gets the XML doc comments prior to the implicit constructor
                            let xmlDoc = grabXmlDoc (parseState, _2, 2)
                            let m = match lid with [] -> rhs parseState 1 | _ -> rangeOfLid lid
                            let memberCtorPattern =
                                pat |> Option.map (fun pat ->
                                    SynMemberDefn.ImplicitCtor(vis, _2, pat, Option.bind snd az, xmlDoc, m, { AsKeyword = Option.map fst az })
                                )
                            let tcDefRepr =
                              match tcDefRepr, memberCtorPattern with
                              | SynTypeDefnRepr.Simple(SynTypeDefnSimpleRepr.None _, m), Some ctor ->
                                  reportParseErrorAt m (FSComp.SR.parsEmptyTypeDefinition())
                                  SynTypeDefnRepr.ObjectModel(SynTypeDefnKind.Unspecified, [ctor], unionRanges m mEquals)
                              | SynTypeDefnRepr.Simple(SynTypeDefnSimpleRepr.None mName, m), _ ->
                                  reportParseErrorAt m (FSComp.SR.parsEmptyTypeDefinition())
                                  tcDefRepr
                              | SynTypeDefnRepr.ObjectModel(k, cspec, m), Some ctor ->
                                  SynTypeDefnRepr.ObjectModel(k, ctor :: cspec, m)
                              | _, Some ctor ->
                                  reportParseErrorAt (rhs2 parseState 1 5) (FSComp.SR.parsOnlyClassCanTakeValueArguments ())
                                  tcDefRepr
                              | _ ->
                                  match az with
                                  | Some(_, Some id) ->
                                      reportParseErrorAt (rhs parseState 6) (FSComp.SR.tcLetAndDoRequiresImplicitConstructionSequence ())
                                  | _ -> ()
                                  tcDefRepr
                            let declRange = unionRanges (rhs parseState 1) tcDefRepr.Range
                            let mWhole = (declRange, members)
                                         ||> unionRangeWithListBy (fun (mem: SynMemberDefn) -> mem.Range)
                                         |> unionRangeWithXmlDoc xmlDoc
                            fun leadingKeyword ->
                                let trivia: SynTypeDefnTrivia = { LeadingKeyword = leadingKeyword; EqualsRange = Some mEquals; WithKeyword = mWith }
                                SynTypeDefn(_1, tcDefRepr, members, memberCtorPattern, mWhole, trivia) 
                   )
//# 1644 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefn));
//# 5749 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeNameInfo in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_simplePatterns in
            let _6 = parseState.GetInput(6) :?> 'gentype_optAsSpec in
            let _7 = parseState.GetInput(7) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1689 "src/Compiler/pars.fsy"
                            let vis, pat, az = _3, _5, _6
                            let (SynComponentInfo(longId = lid)) = _1
                            // Gets the XML doc comments prior to the implicit constructor
                            let xmlDoc = grabXmlDoc (parseState, _2, 2)
                            let m = match lid with [] -> rhs parseState 1 | _ -> rangeOfLid lid
                            let mName = _1.Range
                            let members, mWhole =
                                match pat, vis, az with
                                | Some pat, _, _ ->
                                    let memberCtorPattern = SynMemberDefn.ImplicitCtor(vis, _2, pat, Option.bind snd az, xmlDoc, m, { AsKeyword = Option.map fst az })
                                    [memberCtorPattern], unionRanges mName memberCtorPattern.Range
                                | _, _, Some(mAs, asId) ->
                                    let mAs =
                                        asId |> Option.map (fun id ->
                                            reportParseErrorAt (rhs parseState 6) (FSComp.SR.tcLetAndDoRequiresImplicitConstructionSequence ())
                                            id.idRange
                                        )
                                        |> Option.defaultValue mAs
                                    [], unionRanges mName mAs
                                | _, Some vis, _ ->
                                    [], unionRanges mName vis.Range
                                | _ ->
                                    [], mName
                            fun leadingKeyword ->
                                let trivia = { SynTypeDefnTrivia.Zero with LeadingKeyword = leadingKeyword }
                                SynTypeDefn(_1, SynTypeDefnRepr.Simple(SynTypeDefnSimpleRepr.None(mName), mName), members, None, mWhole, trivia) 
                   )
//# 1689 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefn));
//# 5791 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_tyconDefnRhs in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_OBLOCKSEP in
            let _4 = parseState.GetInput(4) :?> 'gentype_classDefnMembers in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_classDefn in
            let _6 = parseState.GetInput(6) :?> 'gentype_oblockend in
            let _7 = parseState.GetInput(7) :?> 'gentype_opt_classDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1728 "src/Compiler/pars.fsy"
                            let mWith, optClassDefn = _5
                            let mWith2, optClassDefn2 = _7
                            let m = unionRanges (rhs parseState 1) (match optClassDefn2 with [] -> (match optClassDefn with [] -> (rhs parseState 4) | _ -> (rhs parseState 5)) | _ -> (rhs parseState 7))
                            (fun nameRange ->
                                let tcDefRepr, members = _2 nameRange (checkForMultipleAugmentations m (_4 @ optClassDefn) optClassDefn2)
                                let mWith = Option.orElse mWith2 mWith
                                tcDefRepr, mWith, members) 
                   )
//# 1728 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhsBlock));
//# 5813 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_tyconDefnRhs in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_OBLOCKSEP in
            let _4 = parseState.GetInput(4) :?> 'gentype_classDefnMembers in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_classDefn in
            let _6 = parseState.GetInput(6) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1737 "src/Compiler/pars.fsy"
                            if not _6 then reportParseErrorAt (rhs parseState 6) (FSComp.SR.parsUnexpectedEndOfFileTypeDefinition())
                            let mWith, optClassDefn = _5
                            let m = unionRanges (rhs parseState 1) (match optClassDefn with [] -> (rhs parseState 4) | _ -> (rhs parseState 5))
                            (fun nameRange ->
                                let tcDefRepr, members = _2 nameRange (checkForMultipleAugmentations m (_4 @ optClassDefn) [])
                                tcDefRepr, mWith, members) 
                   )
//# 1737 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhsBlock));
//# 5833 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1745 "src/Compiler/pars.fsy"
                            fun mName ->
                                SynTypeDefnRepr.Simple(SynTypeDefnSimpleRepr.None mName, mName), None, [] 
                   )
//# 1745 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhsBlock));
//# 5845 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tyconDefnRhs in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_classDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1749 "src/Compiler/pars.fsy"
                            let m = rhs parseState 1
                            let mWith, optClassDefn = _2
                            (fun nameRange ->
                                let tcDefRepr, members = _1 nameRange optClassDefn
                                tcDefRepr, mWith, members) 
                   )
//# 1749 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhsBlock));
//# 5861 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypeDefnSimpleRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1761 "src/Compiler/pars.fsy"
                            let m = _1.Range
                            (fun nameRange augmentation -> SynTypeDefnRepr.Simple(_1, m), augmentation) 
                   )
//# 1761 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhs));
//# 5873 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tyconClassDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1766 "src/Compiler/pars.fsy"
                            let needsCheck, (kind, decls), mopt = _1
                            let m = match mopt with
                                    | None -> (lhs parseState).StartRange // create a zero-width range
                                    | Some m -> m
                            (fun nameRange augmentation ->
                                if needsCheck && isNil decls then
                                    reportParseErrorAt nameRange (FSComp.SR.parsEmptyTypeDefinition())
                                SynTypeDefnRepr.ObjectModel(kind, decls, m), augmentation) 
                   )
//# 1766 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhs));
//# 5891 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_topType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1777 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            let ty, arity = _3
                            (fun nameRange augmentation ->
                                let vis2 = SynValSigAccess.Single(None)
                                let valSig = SynValSig([], (SynIdent(mkSynId m "Invoke", None)), inferredTyparDecls, ty, arity, false, false, PreXmlDoc.Empty, vis2, None, m, SynValSigTrivia.Zero)
                                let flags = AbstractMemberFlags true SynMemberKind.Member
                                let invoke = SynMemberDefn.AbstractSlot(valSig, flags, m, SynMemberDefnAbstractSlotTrivia.Zero)
                                if not (isNil augmentation) then raiseParseErrorAt m (FSComp.SR.parsAugmentationsIllegalOnDelegateType())
                                SynTypeDefnRepr.ObjectModel(SynTypeDefnKind.Delegate(ty, arity), [invoke], m), []) 
                   )
//# 1777 "src/Compiler/pars.fsy"
                 : 'gentype_tyconDefnRhs));
//# 5910 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classDefnBlockKindUnspecified in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1791 "src/Compiler/pars.fsy"
                            let needsCheck, decls, mopt = _1
                            needsCheck, (SynTypeDefnKind.Unspecified, decls), mopt 
                   )
//# 1791 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassDefn));
//# 5922 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classOrInterfaceOrStruct in
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1795 "src/Compiler/pars.fsy"
                            false, (_1, _2), Some(rhs2 parseState 1 3) 
                   )
//# 1795 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassDefn));
//# 5934 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classOrInterfaceOrStruct in
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1798 "src/Compiler/pars.fsy"
                            reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedClassInterfaceOrStruct())
                            let m = (rhs parseState 1, _2) ||> unionRangeWithListBy (fun (d: SynMemberDefn) -> d.Range)
                            false, (_1, _2), Some(m) 
                   )
//# 1798 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassDefn));
//# 5949 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classOrInterfaceOrStruct in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1803 "src/Compiler/pars.fsy"
                            // silent recovery
                            false, (_1, []), Some(rhs2 parseState 1 3) 
                   )
//# 1803 "src/Compiler/pars.fsy"
                 : 'gentype_tyconClassDefn));
//# 5961 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMembersAtLeastOne in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1810 "src/Compiler/pars.fsy"
                            if not _3 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedEndOfFileTypeDefinition())
                            let mopt =
                                match _2 with
                                | _ :: _ -> Some((rhs parseState 1, _2) ||> unionRangeWithListBy (fun (d: SynMemberDefn) -> d.Range))
                                | _ -> None
                            false, _2, mopt 
                   )
//# 1810 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBlockKindUnspecified));
//# 5978 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMembersAtLeastOne in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1818 "src/Compiler/pars.fsy"
                            let mopt =
                                match _2 with
                                | _ :: _ -> Some((rhs parseState 1, _2) ||> unionRangeWithListBy (fun (d: SynMemberDefn) -> d.Range))
                                | _ -> None
                            true, _2, mopt 
                   )
//# 1818 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBlockKindUnspecified));
//# 5994 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1828 "src/Compiler/pars.fsy"
                             if not _3 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedEndOfFileTypeDefinition())
                             _2 
                   )
//# 1828 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBlock));
//# 6007 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1832 "src/Compiler/pars.fsy"
                             _2 
                   )
//# 1832 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBlock));
//# 6019 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classDefnMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1835 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 1835 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBlock));
//# 6030 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classDefnMembersAtLeastOne in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1841 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 1841 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMembers));
//# 6041 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1845 "src/Compiler/pars.fsy"
                            _2 
                   )
//# 1845 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMembers));
//# 6052 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1848 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 1848 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMembers));
//# 6062 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classDefnMember in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_classDefnMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1854 "src/Compiler/pars.fsy"
                            match _1, _3 with
                            | [ SynMemberDefn.Interface(members=Some []; range=m) ], nextMember :: _ ->
                                let strictIndentation = parseState.LexBuffer.SupportsFeature LanguageFeature.StrictIndentation
                                let warnF = if strictIndentation then errorR else warning 
                                warnF(IndentationProblem(FSComp.SR.lexfltTokenIsOffsideOfContextStartedEarlier(warningStringOfPos m.Start), nextMember.Range))
                            | _ -> ()
                            _1 @ _3 
                   )
//# 1854 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMembersAtLeastOne));
//# 6081 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMemberGetSetElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1866 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            mWithKwd, _2 
                   )
//# 1866 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMemberGetSet));
//# 6093 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMemberGetSetElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1870 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            mWithKwd, _2 
                   )
//# 1870 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMemberGetSet));
//# 6105 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnMemberGetSetElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1874 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedWith())
                            mWithKwd, _2 
                   )
//# 1874 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMemberGetSet));
//# 6118 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classDefnMemberGetSetElement in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1881 "src/Compiler/pars.fsy"
                            [_1], None 
                   )
//# 1881 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMemberGetSetElements));
//# 6129 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_classDefnMemberGetSetElement in
            let _3 = parseState.GetInput(3) :?> 'gentype_classDefnMemberGetSetElement in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1884 "src/Compiler/pars.fsy"
                            let mAnd = rhs parseState 2
                            [_1;_3], Some mAnd 
                   )
//# 1884 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMemberGetSetElements));
//# 6142 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_bindingPattern in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            let _6 = parseState.GetInput(6) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1889 "src/Compiler/pars.fsy"
                            let mEquals = rhs parseState 5
                            let mRhs = (_6: SynExpr).Range
                            (_1, _2, _3, _4, Some mEquals, _6, mRhs) 
                   )
//# 1889 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMemberGetSetElement));
//# 6159 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_bindingPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            let _5 = parseState.GetInput(5) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1898 "src/Compiler/pars.fsy"
                            let mRhs = _5.Range
                            let optReturnType = _3
                            let mEquals = rhs parseState 4
                            let bindingPat, mBindLhs = _2
                            (fun vis flagsBuilderAndLeadingKeyword attrs rangeStart ->
                                 let xmlDoc = grabXmlDocAtRangeStart(parseState, attrs, rangeStart)
                                 let memFlagsBuilder, leadingKeyword = flagsBuilderAndLeadingKeyword
                                 let memberFlags = memFlagsBuilder SynMemberKind.Member
                                 let mWholeBindLhs = (mBindLhs, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                 let trivia: SynBindingTrivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _1; EqualsRange = Some mEquals }
                                 let binding = mkSynBinding (xmlDoc, bindingPat) (vis, (Option.isSome _1), false, mWholeBindLhs, DebugPointAtBinding.NoneAtInvisible, optReturnType, _5, mRhs, [], attrs, Some memberFlags, trivia)
                                 let memberRange = unionRanges rangeStart mRhs |> unionRangeWithXmlDoc xmlDoc
                                 [ SynMemberDefn.Member(binding, memberRange) ]) 
                   )
//# 1898 "src/Compiler/pars.fsy"
                 : 'gentype_memberCore));
//# 6185 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_bindingPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1913 "src/Compiler/pars.fsy"
                            let optReturnType = _3
                            let bindingPat, mBindLhs = _2
                            let mEnd =
                                match optReturnType with
                                | Some(_, ty) -> ty.Range.EndRange
                                | _ -> bindingPat.Range.EndRange
                            let expr = arbExpr ("memberCore1", mEnd)
                            errorR (Error(FSComp.SR.parsMissingMemberBody(), rhs parseState 4))
                            fun vis flagsBuilderAndLeadingKeyword attrs rangeStart ->
                                let xmlDoc = grabXmlDocAtRangeStart(parseState, attrs, rangeStart)
                                let memFlagsBuilder, leadingKeyword = flagsBuilderAndLeadingKeyword
                                let memberFlags = memFlagsBuilder SynMemberKind.Member
                                let mWholeBindLhs = (mBindLhs, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                let trivia: SynBindingTrivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _1; EqualsRange = None }
                                let binding = mkSynBinding (xmlDoc, bindingPat) (vis, (Option.isSome _1), false, mWholeBindLhs, DebugPointAtBinding.NoneAtInvisible, optReturnType, expr, mEnd, [], attrs, Some memberFlags, trivia)
                                let memberRange = unionRanges rangeStart mEnd |> unionRangeWithXmlDoc xmlDoc
                                [ SynMemberDefn.Member (binding, memberRange) ] 
                   )
//# 1913 "src/Compiler/pars.fsy"
                 : 'gentype_memberCore));
//# 6214 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_bindingPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            let _4 = parseState.GetInput(4) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1933 "src/Compiler/pars.fsy"
                            let optReturnType = _3
                            let bindingPat, mBindLhs = _2
                            let mEnd =
                                match optReturnType with
                                | Some(_, ty) -> ty.Range.EndRange
                                | _ -> bindingPat.Range.EndRange
                            let expr = arbExpr ("memberCore2", mEnd)
                            errorR (Error(FSComp.SR.parsMissingMemberBody(), rhs parseState 4))
                            fun vis flagsBuilderAndLeadingKeyword attrs rangeStart ->
                                let xmlDoc = grabXmlDocAtRangeStart(parseState, attrs, rangeStart)
                                let memFlagsBuilder, leadingKeyword = flagsBuilderAndLeadingKeyword
                                let memberFlags = memFlagsBuilder SynMemberKind.Member
                                let mWholeBindLhs = (mBindLhs, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                let trivia: SynBindingTrivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _1; EqualsRange = None }
                                let binding = mkSynBinding (xmlDoc, bindingPat) (vis, (Option.isSome _1), false, mWholeBindLhs, DebugPointAtBinding.NoneAtInvisible, optReturnType, expr, mEnd, [], attrs, Some memberFlags, trivia)
                                let memberRange = unionRanges rangeStart mEnd |> unionRangeWithXmlDoc xmlDoc
                                [ SynMemberDefn.Member (binding, memberRange) ] 
                   )
//# 1933 "src/Compiler/pars.fsy"
                 : 'gentype_memberCore));
//# 6244 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_bindingPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            let _4 = parseState.GetInput(4) :?> 'gentype_classDefnMemberGetSet in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1954 "src/Compiler/pars.fsy"
                            let mWith, (classDefnMemberGetSetElements, mAnd) = _4
                            let mWhole = (rhs parseState 2, classDefnMemberGetSetElements) ||> unionRangeWithListBy (fun (_, _, _, _, _, _, m2) -> m2)
                            let propertyNameBindingPat, _ = _2
                            let optPropertyType = _3
                            mkSynMemberDefnGetSet
                                parseState
                                _1
                                mWith
                                classDefnMemberGetSetElements
                                mAnd
                                mWhole
                                propertyNameBindingPat
                                optPropertyType 
                   )
//# 1954 "src/Compiler/pars.fsy"
                 : 'gentype_memberCore));
//# 6270 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1971 "src/Compiler/pars.fsy"
                             let mAbstract = rhs parseState 1
                             AbstractMemberFlags true, SynLeadingKeyword.Abstract mAbstract 
                   )
//# 1971 "src/Compiler/pars.fsy"
                 : 'gentype_abstractMemberFlags));
//# 6281 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1975 "src/Compiler/pars.fsy"
                             let mAbstract = rhs parseState 1
                             let mMember = rhs parseState 2
                             AbstractMemberFlags true, SynLeadingKeyword.AbstractMember(mAbstract, mMember) 
                   )
//# 1975 "src/Compiler/pars.fsy"
                 : 'gentype_abstractMemberFlags));
//# 6293 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1980 "src/Compiler/pars.fsy"
                             let mWhole = rhs2 parseState 1 2
                             parseState.LexBuffer.CheckLanguageFeatureAndRecover LanguageFeature.InterfacesWithAbstractStaticMembers mWhole
                             if parseState.LexBuffer.SupportsFeature LanguageFeature.InterfacesWithAbstractStaticMembers then
                                 warning(Error(FSComp.SR.tcUsingInterfacesWithStaticAbstractMethods(), mWhole))
                             let mStatic = rhs parseState 1
                             let mAbstract = rhs parseState 2
                             AbstractMemberFlags false, SynLeadingKeyword.StaticAbstract(mStatic, mAbstract) 
                   )
//# 1980 "src/Compiler/pars.fsy"
                 : 'gentype_abstractMemberFlags));
//# 6309 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 1989 "src/Compiler/pars.fsy"
                             let mWhole = rhs2 parseState 1 2
                             parseState.LexBuffer.CheckLanguageFeatureAndRecover LanguageFeature.InterfacesWithAbstractStaticMembers mWhole
                             if parseState.LexBuffer.SupportsFeature LanguageFeature.InterfacesWithAbstractStaticMembers then
                                 warning(Error(FSComp.SR.tcUsingInterfacesWithStaticAbstractMethods(), mWhole))
                             let mStatic = rhs parseState 1
                             let mAbstract = rhs parseState 2
                             let mMember = rhs parseState 3
                             AbstractMemberFlags false, SynLeadingKeyword.StaticAbstractMember(mStatic, mAbstract, mMember) 
                   )
//# 1989 "src/Compiler/pars.fsy"
                 : 'gentype_abstractMemberFlags));
//# 6326 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_classDefnBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2001 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            [mkClassMemberLocalBindings(false, None, _1, _2, _3)] 
                   )
//# 2001 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6340 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_classDefnBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2005 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            [mkClassMemberLocalBindings(true, Some(rhs parseState 3), _1, _2, _4)] 
                   )
//# 2005 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6354 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_memberFlags in
            let _4 = parseState.GetInput(4) :?> 'gentype_memberCore in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2009 "src/Compiler/pars.fsy"
                            let rangeStart = rhs parseState 1
                            if Option.isSome _2 then
                                errorR (Error (FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                            let flags = _3
                            match flags with
                            | _, SynLeadingKeyword.Static(mStatic) -> errorR (Error (FSComp.SR.parsStaticMemberImcompleteSyntax (), mStatic))
                            | _ -> ()
                            _4 _2 flags _1 rangeStart 
                   )
//# 2009 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6376 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_memberFlags in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2019 "src/Compiler/pars.fsy"
                             let rangeStart = rhs parseState 1
                             if Option.isSome _2 then
                                 errorR (Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier (), rhs parseState 2))
                             let memFlagsBuilder, leadingKeyword = _3
                             let flags = Some(memFlagsBuilder SynMemberKind.Member)
                             let xmlDoc = grabXmlDocAtRangeStart (parseState, _1, rangeStart)
                             let trivia = { LeadingKeyword = leadingKeyword; InlineKeyword = None; EqualsRange = None }
                             let mMember = rhs parseState 3
                             let mEnd = mMember.EndRange
                             let bindingPat = patFromParseError (SynPat.Wild(mEnd))
                             let expr = arbExpr ("classDefnMember1", mEnd)
                             let mWhole = rhs2 parseState 1 3
                             let binding =
                                 mkSynBinding
                                     (xmlDoc, bindingPat)
                                     (_2, (Option.isSome _2), false, mWhole, DebugPointAtBinding.NoneAtInvisible, None, expr, mEnd, [], _1, flags, trivia)
                             [SynMemberDefn.Member(binding, mWhole)] 
                   )
//# 2019 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6406 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_interfaceMember in
            let _4 = parseState.GetInput(4) :?> 'gentype_appTypeWithoutNull in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_interfaceImplDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2039 "src/Compiler/pars.fsy"
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesAreNotPermittedOnInterfaceImplementations(), rhs parseState 1))
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsInterfacesHaveSameVisibilityAsEnclosingType(), rhs parseState 3))
                            let mWithKwd, members, mWhole =
                                match _5 with
                                | None -> None, None, rhs2 parseState 1 4
                                | Some(mWithKwd, members, m) -> Some mWithKwd, Some members, unionRanges (rhs2 parseState 1 4) m
                            [ SynMemberDefn.Interface(_4, mWithKwd, members, mWhole) ] 
                   )
//# 2039 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6427 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_interfaceMember in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2048 "src/Compiler/pars.fsy"
                            let mInterface = rhs parseState 3
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesAreNotPermittedOnInterfaceImplementations(), rhs parseState 1))
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsInterfacesHaveSameVisibilityAsEnclosingType(), mInterface))
                            let ty = SynType.FromParseError(mInterface.EndRange)
                            [ SynMemberDefn.Interface(ty, None, None, rhs2 parseState 1 3) ] 
                   )
//# 2048 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6445 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_abstractMemberFlags in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_access in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_inline in
            let _6 = parseState.GetInput(6) :?> 'gentype_nameop in
            let _7 = parseState.GetInput(7) :?> 'gentype_opt_explicitValTyparDecls in
            let _9 = parseState.GetInput(9) :?> 'gentype_topTypeWithTypeConstraints in
            let _10 = parseState.GetInput(10) :?> 'gentype_classMemberSpfnGetSet in
            let _11 = parseState.GetInput(11) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2055 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            let ty, arity = _9
                            let isInline, doc, id, explicitValTyparDecls = (Option.isSome _5), grabXmlDoc(parseState, _1, 1), _6, _7
                            let mWith, (getSet, getSetRangeOpt, getterAccess, setterAccess) = _10
                            let getSetAdjuster arity = match arity, getSet with SynValInfo([], _), SynMemberKind.Member -> SynMemberKind.PropertyGet | _ -> getSet
                            let mWhole =
                                let m = rhs parseState 1
                                match getSetRangeOpt with
                                | None -> unionRanges m ty.Range
                                | Some gs -> unionRanges m gs.Range
                                |> unionRangeWithXmlDoc doc
                            [ _2; _4; getterAccess; setterAccess ]
                            |> List.iter (function None -> () | Some access -> errorR(Error(FSComp.SR.parsAccessibilityModsIllegalForAbstract(), access.Range)))
                            let mkFlags, leadingKeyword = _3
                            let trivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _5; WithKeyword = mWith; EqualsRange = None }
                            let vis2 = SynValSigAccess.Single(None)
                            let valSpfn = SynValSig(_1, id, explicitValTyparDecls, ty, arity, isInline, false, doc, vis2, None, mWhole, trivia)
                            let trivia: SynMemberDefnAbstractSlotTrivia = { GetSetKeywords = getSetRangeOpt }
                            [ SynMemberDefn.AbstractSlot(valSpfn, mkFlags (getSetAdjuster arity), mWhole, trivia) ] 
                   )
//# 2055 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6483 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_inheritsDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2078 "src/Compiler/pars.fsy"
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesIllegalOnInherit(), rhs parseState 1))
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityIllegalOnInherit(), rhs parseState 1))
                            [ _3 ] 
                   )
//# 2078 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6498 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_valDefnDecl in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2083 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            let rangeStart = rhs parseState 1
                            _3 rangeStart _1 None 
                   )
//# 2083 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6514 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_valDefnDecl in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2088 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            let mStatic = rhs parseState 3
                            let rangeStart = rhs parseState 1
                            _4 rangeStart _1 (Some mStatic) 
                   )
//# 2088 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6531 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_memberFlags in
            let _4 = parseState.GetInput(4) :?> 'gentype_autoPropsDefnDecl in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2094 "src/Compiler/pars.fsy"
                            let rangeStart = rhs parseState 1
                            if Option.isSome _2 then
                                errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            let flags = _3
                            _4 _1 flags rangeStart 
                   )
//# 2094 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6550 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_atomicPattern in
            let _5 = parseState.GetInput(5) :?> 'gentype_optAsSpec in
            let _7 = parseState.GetInput(7) :?> SynExpr in
            let _8 = parseState.GetInput(8) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2101 "src/Compiler/pars.fsy"
                            let mWholeBindLhs = rhs2 parseState 1 (if Option.isSome _5 then 5 else 4)
                            let mNew = rhs parseState 3
                            let xmlDoc = grabXmlDoc(parseState, _1, 1)
                            let m = unionRanges mWholeBindLhs _7.Range |> unionRangeWithXmlDoc xmlDoc
                            let mEquals = rhs parseState 6
                            let expr = _7
                            let valSynData = SynValData (Some CtorMemberFlags, SynValInfo([SynInfo.InferSynArgInfoFromPat _4], SynInfo.unnamedRetVal), Option.bind snd _5)
                            let vis = _2
                            let declPat = SynPat.LongIdent(SynLongIdent([mkSynId (rhs parseState 3) "new"], [], [None]), None, Some noInferredTypars, SynArgPats.Pats [_4], vis, rhs parseState 3)
                            // Check that 'SynPatForConstructorDecl' matches this correctly
                            assert (match declPat with SynPatForConstructorDecl _ -> true | _ -> false)
                            let synBindingTrivia: SynBindingTrivia = { LeadingKeyword = SynLeadingKeyword.New mNew; InlineKeyword = None; EqualsRange = Some mEquals }
                            [ SynMemberDefn.Member(SynBinding (None, SynBindingKind.Normal, false, false, _1, xmlDoc, valSynData, declPat, None, expr, mWholeBindLhs, DebugPointAtBinding.NoneAtInvisible, synBindingTrivia), m) ] 
                   )
//# 2101 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6578 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_atomicPattern in
            let _5 = parseState.GetInput(5) :?> 'gentype_optAsSpec in
            let _6 = parseState.GetInput(6) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2116 "src/Compiler/pars.fsy"
                            if not _6 then reportParseErrorAt (rhs parseState 6) (FSComp.SR.parsMissingMemberBody ())
                            let mNew = rhs parseState 3
                            let mAs = _5 |> Option.map (fun (mAs, id) -> id |> Option.map (fun id -> id.idRange) |> Option.defaultValue mAs)
                            let mEnd = mAs |> Option.defaultValue _4.Range
                            let xmlDoc = grabXmlDoc (parseState, _1, 1)
                            let m = unionRanges (rhs parseState 1) mEnd |> unionRangeWithXmlDoc xmlDoc
                            let expr = arbExpr ("new1", mEnd.EndRange)
                            let valSynData = SynValData (Some CtorMemberFlags, SynValInfo([SynInfo.InferSynArgInfoFromPat _4], SynInfo.unnamedRetVal), Option.bind snd _5)
                            let declPat = SynPat.LongIdent(SynLongIdent([mkSynId (rhs parseState 3) "new"], [], [None]), None, Some noInferredTypars, SynArgPats.Pats [_4], _2, rhs parseState 3)
                            assert (match declPat with SynPatForConstructorDecl _ -> true | _ -> false)
                            let synBindingTrivia: SynBindingTrivia = { LeadingKeyword = SynLeadingKeyword.New mNew; InlineKeyword = None; EqualsRange = None }
                            [ SynMemberDefn.Member(SynBinding(None, SynBindingKind.Normal, false, false, _1, xmlDoc, valSynData, declPat, None, expr, m, DebugPointAtBinding.NoneAtInvisible, synBindingTrivia), m) ] 
                   )
//# 2116 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6604 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_atomicPattern in
            let _5 = parseState.GetInput(5) :?> 'gentype_optAsSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2130 "src/Compiler/pars.fsy"
                            reportParseErrorAt (rhs parseState 5) (FSComp.SR.parsMissingMemberBody ())
                            let mNew = rhs parseState 3
                            let mAs = _5 |> Option.map (fun (mAs, id) -> id |> Option.map (fun id -> id.idRange) |> Option.defaultValue mAs)
                            let mEnd = mAs |> Option.defaultValue _4.Range
                            let xmlDoc = grabXmlDoc (parseState, _1, 1)
                            let m = unionRanges (rhs parseState 1) mEnd |> unionRangeWithXmlDoc xmlDoc
                            let expr = arbExpr ("new2", mEnd.EndRange)
                            let valSynData = SynValData(Some CtorMemberFlags, SynValInfo([SynInfo.InferSynArgInfoFromPat _4], SynInfo.unnamedRetVal), Option.bind snd _5)
                            let declPat = SynPat.LongIdent(SynLongIdent([mkSynId (rhs parseState 3) "new"], [], [None]), None, Some noInferredTypars, SynArgPats.Pats [_4], _2, rhs parseState 3)
                            assert (match declPat with SynPatForConstructorDecl _ -> true | _ -> false)
                            let synBindingTrivia: SynBindingTrivia = { LeadingKeyword = SynLeadingKeyword.New mNew; InlineKeyword = None; EqualsRange = None }
                            [ SynMemberDefn.Member(SynBinding (None, SynBindingKind.Normal, false, false, _1, xmlDoc, valSynData, declPat, None, expr, m, DebugPointAtBinding.NoneAtInvisible, synBindingTrivia), m) ] 
                   )
//# 2130 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6629 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2144 "src/Compiler/pars.fsy"
                            let m = rhs2 parseState 1 3
                            let mNew = rhs parseState 3
                            let xmlDoc = grabXmlDoc (parseState, _1, 1)
                            let pat = patFromParseError (SynPat.Wild(mNew.EndRange))
                            let expr = arbExpr ("new3", mNew.EndRange)
                            let valSynData = SynValData(Some CtorMemberFlags, SynValInfo([SynInfo.InferSynArgInfoFromPat pat], SynInfo.unnamedRetVal), None)
                            let vis = _2
                            let declPat = SynPat.LongIdent(SynLongIdent([mkSynId (rhs parseState 3) "new"], [], [None]), None, Some noInferredTypars, SynArgPats.Pats [pat], vis, rhs parseState 3)
                            let synBindingTrivia: SynBindingTrivia = { LeadingKeyword = SynLeadingKeyword.New mNew; InlineKeyword = None; EqualsRange = None }
                            [ SynMemberDefn.Member(SynBinding(None, SynBindingKind.Normal, false, false, _1, xmlDoc, valSynData, declPat, None, expr, m, DebugPointAtBinding.NoneAtInvisible, synBindingTrivia), m) ] 
                   )
//# 2144 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6652 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_typeKeyword in
            let _5 = parseState.GetInput(5) :?> 'gentype_tyconDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2156 "src/Compiler/pars.fsy"
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsVisibilityDeclarationsShouldComePriorToIdentifier(), rhs parseState 2))
                            let leadingKeyword = SynTypeDefnLeadingKeyword.StaticType(rhs parseState 3, rhs parseState 4)
                            [ SynMemberDefn.NestedType(_5 leadingKeyword, None, rhs2 parseState 1 5) ] 
                   )
//# 2156 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnMember));
//# 6668 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _6 = parseState.GetInput(6) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2164 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            fun rangeStart attribs mStaticOpt ->
                                [ mkValField parseState mVal _2 _3 (Some _4) (Some _6) rangeStart attribs mStaticOpt ] 
                   )
//# 2164 "src/Compiler/pars.fsy"
                 : 'gentype_valDefnDecl));
//# 6684 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _6 = parseState.GetInput(6) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2169 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            let mColon = rhs parseState 5
                            let ty = SynType.FromParseError(mColon.EndRange)
                            fun rangeStart attribs mStaticOpt ->
                                [ mkValField parseState mVal _2 _3 (Some _4) (Some ty) rangeStart attribs mStaticOpt ] 
                   )
//# 2169 "src/Compiler/pars.fsy"
                 : 'gentype_valDefnDecl));
//# 6702 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _5 = parseState.GetInput(5) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2176 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            let ty = SynType.FromParseError(_4.idRange.EndRange)
                            fun rangeStart attribs mStaticOpt ->
                                [ mkValField parseState mVal _2 _3 (Some _4) (Some ty) rangeStart attribs mStaticOpt ] 
                   )
//# 2176 "src/Compiler/pars.fsy"
                 : 'gentype_valDefnDecl));
//# 6719 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2182 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            fun rangeStart attribs mStaticOpt ->
                                [ mkValField parseState mVal _2 _3 None None rangeStart attribs mStaticOpt ] 
                   )
//# 2182 "src/Compiler/pars.fsy"
                 : 'gentype_valDefnDecl));
//# 6734 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_typ in
            let _7 = parseState.GetInput(7) :?> SynExpr in
            let _8 = parseState.GetInput(8) :?> 'gentype_classMemberSpfnGetSet in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2190 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            let mEquals = rhs parseState 6
                            if Option.isSome _2 then
                                errorR (Error(FSComp.SR.parsMutableOnAutoPropertyShouldBeGetSet (), rhs parseState 2))
                            fun attribs flags rangeStart ->
                                let xmlDoc = grabXmlDocAtRangeStart (parseState, attribs, rangeStart)
                                [ mkAutoPropDefn mVal _3 _4 _5 (Some mEquals) _7 _8 xmlDoc attribs flags rangeStart ] 
                   )
//# 2190 "src/Compiler/pars.fsy"
                 : 'gentype_autoPropsDefnDecl));
//# 6756 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_typ in
            let _6 = parseState.GetInput(6) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2199 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            let mEnd =
                                match _5 with
                                | Some t -> t.Range
                                | _ -> _4.idRange
                            let expr = arbExpr ("autoProp1", mEnd.EndRange)
                            if Option.isSome _2 then
                                errorR (Error(FSComp.SR.parsMutableOnAutoPropertyShouldBeGetSet (), rhs parseState 2))
                            fun attribs flags rangeStart ->
                                let xmlDoc = grabXmlDocAtRangeStart (parseState, attribs, rangeStart)
                                [ mkAutoPropDefn mVal _3 _4 _5 None expr (None, (SynMemberKind.Member, None, None, None)) xmlDoc attribs flags rangeStart ] 
                   )
//# 2199 "src/Compiler/pars.fsy"
                 : 'gentype_autoPropsDefnDecl));
//# 6781 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_typ in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2212 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            let mEnd =
                                match _5 with
                                | Some t -> t.Range
                                | _ -> _4.idRange
                            let expr = arbExpr ("autoProp2", mEnd.EndRange)
                            if Option.isSome _2 then
                                errorR (Error(FSComp.SR.parsMutableOnAutoPropertyShouldBeGetSet (), rhs parseState 2))
                            fun attribs flags rangeStart ->
                                let xmlDoc = grabXmlDocAtRangeStart (parseState, attribs, rangeStart)
                                [ mkAutoPropDefn mVal _3 _4 _5 None expr (None, (SynMemberKind.Member, None, None, None)) xmlDoc attribs flags rangeStart ] 
                   )
//# 2212 "src/Compiler/pars.fsy"
                 : 'gentype_autoPropsDefnDecl));
//# 6805 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2225 "src/Compiler/pars.fsy"
                            let mVal = rhs parseState 1
                            let id = mkSynId mVal.EndRange ""
                            let expr = arbExpr ("autoProp3", mVal.EndRange)
                            if Option.isSome _2 then
                                errorR (Error(FSComp.SR.parsMutableOnAutoPropertyShouldBeGetSet (), rhs parseState 2))
                            fun attribs flags rangeStart ->
                                let xmlDoc = grabXmlDocAtRangeStart(parseState, attribs, rangeStart)
                                [ mkAutoPropDefn mVal _3 id None None expr (None, (SynMemberKind.Member, None, None, None)) xmlDoc attribs flags rangeStart ] 
                   )
//# 2225 "src/Compiler/pars.fsy"
                 : 'gentype_autoPropsDefnDecl));
//# 6825 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2237 "src/Compiler/pars.fsy"
                              None 
                   )
//# 2237 "src/Compiler/pars.fsy"
                 : 'gentype_opt_typ));
//# 6835 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2240 "src/Compiler/pars.fsy"
                              Some _2 
                   )
//# 2240 "src/Compiler/pars.fsy"
                 : 'gentype_opt_typ));
//# 6846 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2243 "src/Compiler/pars.fsy"
                              let mColon = rhs parseState 1
                              let ty = SynType.FromParseError(mColon.EndRange)
                              Some ty 
                   )
//# 2243 "src/Compiler/pars.fsy"
                 : 'gentype_opt_typ));
//# 6859 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2250 "src/Compiler/pars.fsy"
                            if not (parseState.LexBuffer.SupportsFeature LanguageFeature.SingleUnderscorePattern) then
                               raiseParseErrorAt (rhs parseState 2) (FSComp.SR.parsUnexpectedSymbolDot())
                            let underscore = ident("_", rhs parseState 1)
                            let mDot = rhs parseState 2
                            None, prependIdentInLongIdentWithTrivia (SynIdent(underscore, None)) mDot _3 
                   )
//# 2250 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPatternLongIdent));
//# 6874 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2258 "src/Compiler/pars.fsy"
                            let globalIdent = ident(MangledGlobalName, rhs parseState 1)
                            let mDot = rhs parseState 2
                            None, prependIdentInLongIdentWithTrivia (SynIdent(globalIdent, (Some(IdentTrivia.OriginalNotation "global")))) mDot _3 
                   )
//# 2258 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPatternLongIdent));
//# 6887 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2263 "src/Compiler/pars.fsy"
                            (None, _1) 
                   )
//# 2263 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPatternLongIdent));
//# 6898 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_access in
            let _4 = parseState.GetInput(4) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2266 "src/Compiler/pars.fsy"
                            if not (parseState.LexBuffer.SupportsFeature LanguageFeature.SingleUnderscorePattern) then
                               raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedSymbolDot())
                            let underscore = ident("_", rhs parseState 2)
                            let mDot = rhs parseState 3
                            Some(_1), prependIdentInLongIdentWithTrivia (SynIdent(underscore, None)) mDot _4 
                   )
//# 2266 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPatternLongIdent));
//# 6914 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_access in
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2274 "src/Compiler/pars.fsy"
                            (Some(_1), _2) 
                   )
//# 2274 "src/Compiler/pars.fsy"
                 : 'gentype_atomicPatternLongIdent));
//# 6926 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2279 "src/Compiler/pars.fsy"
                            None 
                   )
//# 2279 "src/Compiler/pars.fsy"
                 : 'gentype_opt_access));
//# 6936 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_access in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2282 "src/Compiler/pars.fsy"
                            Some(_1) 
                   )
//# 2282 "src/Compiler/pars.fsy"
                 : 'gentype_opt_access));
//# 6947 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2287 "src/Compiler/pars.fsy"
                            let m = rhs parseState 1
                            SynAccess.Private m 
                   )
//# 2287 "src/Compiler/pars.fsy"
                 : 'gentype_access));
//# 6958 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2291 "src/Compiler/pars.fsy"
                            let m = rhs parseState 1
                            SynAccess.Public m 
                   )
//# 2291 "src/Compiler/pars.fsy"
                 : 'gentype_access));
//# 6969 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2295 "src/Compiler/pars.fsy"
                            let m = rhs parseState 1
                            SynAccess.Internal m 
                   )
//# 2295 "src/Compiler/pars.fsy"
                 : 'gentype_access));
//# 6980 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_objectImplementationBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_declEnd in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2301 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            let members = _2
                            let m = (rhs parseState 1, members) ||> unionRangeWithListBy (fun (mem: SynMemberDefn) -> mem.Range)
                            Some(mWithKwd, members, m) 
                   )
//# 2301 "src/Compiler/pars.fsy"
                 : 'gentype_opt_interfaceImplDefn));
//# 6995 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2307 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            Some(mWithKwd, [], mWithKwd) 
                   )
//# 2307 "src/Compiler/pars.fsy"
                 : 'gentype_opt_interfaceImplDefn));
//# 7006 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2311 "src/Compiler/pars.fsy"
                            None 
                   )
//# 2311 "src/Compiler/pars.fsy"
                 : 'gentype_opt_interfaceImplDefn));
//# 7016 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_classDefnBlock in
            let _3 = parseState.GetInput(3) :?> 'gentype_declEnd in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2316 "src/Compiler/pars.fsy"
                            let mWithKwd = rhs parseState 1
                            (Some mWithKwd), _2 
                   )
//# 2316 "src/Compiler/pars.fsy"
                 : 'gentype_opt_classDefn));
//# 7029 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2320 "src/Compiler/pars.fsy"
                            None, [] 
                   )
//# 2320 "src/Compiler/pars.fsy"
                 : 'gentype_opt_classDefn));
//# 7039 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynType in
            let _3 = parseState.GetInput(3) :?> 'gentype_optBaseSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2326 "src/Compiler/pars.fsy"
                            let mDecl = unionRanges (rhs parseState 1) _2.Range
                            let trivia = { InheritKeyword = rhs parseState 1 }
                            SynMemberDefn.Inherit(Some _2, _3, mDecl, trivia) 
                   )
//# 2326 "src/Compiler/pars.fsy"
                 : 'gentype_inheritsDefn));
//# 7053 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynType in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _4 = parseState.GetInput(4) :?> SynExpr in
            let _5 = parseState.GetInput(5) :?> 'gentype_optBaseSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2331 "src/Compiler/pars.fsy"
                            let mDecl = unionRanges (rhs parseState 1) _4.Range
                            let trivia = { InheritKeyword = rhs parseState 1 }
                            SynMemberDefn.ImplicitInherit(_2, _4, _5, mDecl, trivia) 
                   )
//# 2331 "src/Compiler/pars.fsy"
                 : 'gentype_inheritsDefn));
//# 7069 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2336 "src/Compiler/pars.fsy"
                            let mDecl = (rhs parseState 1)
                            let trivia = { InheritKeyword = (rhs parseState 1) }
                            if not _2 then errorR (Error(FSComp.SR.parsTypeNameCannotBeEmpty (), mDecl))
                            SynMemberDefn.Inherit(None, None, mDecl, trivia) 
                   )
//# 2336 "src/Compiler/pars.fsy"
                 : 'gentype_inheritsDefn));
//# 7083 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_asSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2343 "src/Compiler/pars.fsy"
                             Some(_1) 
                   )
//# 2343 "src/Compiler/pars.fsy"
                 : 'gentype_optAsSpec));
//# 7094 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2346 "src/Compiler/pars.fsy"
                             None 
                   )
//# 2346 "src/Compiler/pars.fsy"
                 : 'gentype_optAsSpec));
//# 7104 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2350 "src/Compiler/pars.fsy"
                            rhs parseState 1, Some _2 
                   )
//# 2350 "src/Compiler/pars.fsy"
                 : 'gentype_asSpec));
//# 7115 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2353 "src/Compiler/pars.fsy"
                            rhs parseState 1, None 
                   )
//# 2353 "src/Compiler/pars.fsy"
                 : 'gentype_asSpec));
//# 7126 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_baseSpec in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2357 "src/Compiler/pars.fsy"
                            Some(_1) 
                   )
//# 2357 "src/Compiler/pars.fsy"
                 : 'gentype_optBaseSpec));
//# 7137 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2360 "src/Compiler/pars.fsy"
                            None 
                   )
//# 2360 "src/Compiler/pars.fsy"
                 : 'gentype_optBaseSpec));
//# 7147 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2364 "src/Compiler/pars.fsy"
                             if (_2).idText <> "base" then
                                  errorR(Error(FSComp.SR.parsInheritDeclarationsCannotHaveAsBindings(), rhs2 parseState 1 2))
                             ident("base", rhs parseState 2) 
                   )
//# 2364 "src/Compiler/pars.fsy"
                 : 'gentype_baseSpec));
//# 7160 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2369 "src/Compiler/pars.fsy"
                             errorR(Error(FSComp.SR.parsInheritDeclarationsCannotHaveAsBindings(), rhs2 parseState 1 2))
                             ident("base", rhs parseState 2) 
                   )
//# 2369 "src/Compiler/pars.fsy"
                 : 'gentype_baseSpec));
//# 7171 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_objectImplementationMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2376 "src/Compiler/pars.fsy"
                             _2 
                   )
//# 2376 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationBlock));
//# 7183 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_objectImplementationMembers in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2379 "src/Compiler/pars.fsy"
                             if not _3 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedEndOfFileObjectMembers())
                             _2 
                   )
//# 2379 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationBlock));
//# 7196 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_objectImplementationMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2383 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 2383 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationBlock));
//# 7207 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_objectImplementationMember in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_objectImplementationMembers in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2389 "src/Compiler/pars.fsy"
                             _1 @  _3 
                   )
//# 2389 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationMembers));
//# 7220 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_objectImplementationMember in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2392 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 2392 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationMembers));
//# 7232 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_staticMemberOrMemberOrOverride in
            let _3 = parseState.GetInput(3) :?> 'gentype_memberCore in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2398 "src/Compiler/pars.fsy"
                            let rangeStart = rhs parseState 1
                            _3 None _2 _1 rangeStart 
                   )
//# 2398 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationMember));
//# 7247 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_staticMemberOrMemberOrOverride in
            let _3 = parseState.GetInput(3) :?> 'gentype_autoPropsDefnDecl in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2402 "src/Compiler/pars.fsy"
                            let rangeStart = rhs parseState 1
                            _3 _1 _2 rangeStart 
                   )
//# 2402 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationMember));
//# 7262 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_staticMemberOrMemberOrOverride in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2406 "src/Compiler/pars.fsy"
                             let rangeStart = rhs parseState 1
                             let memFlagsBuilder, leadingKeyword = _2
                             let flags = Some(memFlagsBuilder SynMemberKind.Member)
                             let xmlDoc = grabXmlDocAtRangeStart (parseState, _1, rangeStart)
                             let trivia = { LeadingKeyword = leadingKeyword; InlineKeyword = None; EqualsRange = None }
                             let mMember = rhs parseState 2
                             let mEnd = mMember.EndRange
                             let bindingPat = patFromParseError (SynPat.Wild(mEnd))
                             let expr = arbExpr ("objectImplementationMember1", mEnd)
                             let mWhole = rhs2 parseState 1 2
                             let binding =
                                 mkSynBinding
                                     (xmlDoc, bindingPat)
                                     (None, false, false, mWhole, DebugPointAtBinding.NoneAtInvisible, None, expr, mEnd, [], _1, flags, trivia)
                             [SynMemberDefn.Member(binding, mWhole)] 
                   )
//# 2406 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationMember));
//# 7289 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_memberCore in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_ODECLEND in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2424 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 2424 "src/Compiler/pars.fsy"
                 : 'gentype_objectImplementationMember));
//# 7302 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2429 "src/Compiler/pars.fsy"
                             let mStatic = rhs parseState 1
                             let mMember = rhs parseState 2
                             ImplementStaticMemberFlags, (SynLeadingKeyword.StaticMember(mStatic, mMember)) 
                   )
//# 2429 "src/Compiler/pars.fsy"
                 : 'gentype_staticMemberOrMemberOrOverride));
//# 7314 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2433 "src/Compiler/pars.fsy"
                             let mMember = rhs parseState 1
                             OverrideMemberFlags, (SynLeadingKeyword.Member mMember) 
                   )
//# 2433 "src/Compiler/pars.fsy"
                 : 'gentype_staticMemberOrMemberOrOverride));
//# 7325 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2436 "src/Compiler/pars.fsy"
                             let mOverride = rhs parseState 1
                             OverrideMemberFlags, (SynLeadingKeyword.Override mOverride) 
                   )
//# 2436 "src/Compiler/pars.fsy"
                 : 'gentype_staticMemberOrMemberOrOverride));
//# 7336 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynLongIdent in
            let _4 = parseState.GetInput(4) :?> string * bool in
            let _5 = parseState.GetInput(5) :?> string * SynStringKind * ParseHelpers.LexerContinuation in
            let _6 = parseState.GetInput(6) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2445 "src/Compiler/pars.fsy"
                            errorR(Error(FSComp.SR.parsUnexpectedQuotationOperatorInTypeAliasDidYouMeanVerbatimString(), rhs parseState 4))
                            SynTypeDefnSimpleRepr.TypeAbbrev(ParserDetail.ErrorRecovery, SynType.LongIdent(_3), unionRanges (rhs parseState 1) _3.Range) 
                   )
//# 2445 "src/Compiler/pars.fsy"
                 : SynTypeDefnSimpleRepr));
//# 7353 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2450 "src/Compiler/pars.fsy"
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesIllegalHere(), rhs parseState 1))
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsTypeAbbreviationsCannotHaveVisibilityDeclarations(), rhs parseState 2))
                            SynTypeDefnSimpleRepr.TypeAbbrev(ParserDetail.Ok, _3, unionRanges (rhs parseState 1) _3.Range) 
                   )
//# 2450 "src/Compiler/pars.fsy"
                 : SynTypeDefnSimpleRepr));
//# 7368 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> Choice<SynEnumCase, SynUnionCase> list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2456 "src/Compiler/pars.fsy"
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesIllegalHere(), rhs parseState 1))
                            let rangesOf3 = _3 |> List.map (function Choice1Of2 ec -> ec.Range | Choice2Of2 uc -> uc.Range)
                            let mWhole = (rhs2 parseState 1 2, rangesOf3) ||> List.fold unionRanges
                            if _3 |> List.exists (function Choice1Of2 _ -> true | _ -> false) then (
                                if Option.isSome _2 then errorR(Error(FSComp.SR.parsEnumTypesCannotHaveVisibilityDeclarations(), rhs parseState 2))
                                SynTypeDefnSimpleRepr.Enum(_3 |> List.choose (function
                                                                   | Choice1Of2 data ->
                                                                     Some(data)
                                                                   | Choice2Of2(SynUnionCase(range=m)) ->
                                                                     errorR(Error(FSComp.SR.parsAllEnumFieldsRequireValues(), m)); None),
                                                mWhole)
                            ) else
                                SynTypeDefnSimpleRepr.Union(_2,
                                                 _3 |> List.choose (function Choice2Of2 data -> Some(data) | Choice1Of2 _ -> failwith "huh?"),
                                                 mWhole) 
                   )
//# 2456 "src/Compiler/pars.fsy"
                 : SynTypeDefnSimpleRepr));
//# 7395 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_braceFieldDeclList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2474 "src/Compiler/pars.fsy"
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesIllegalHere(), rhs parseState 1))
                            SynTypeDefnSimpleRepr.Record(_2, _3, lhs parseState) 
                   )
//# 2474 "src/Compiler/pars.fsy"
                 : SynTypeDefnSimpleRepr));
//# 7409 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _5 = parseState.GetInput(5) :?> 'gentype_string in
            let _7 = parseState.GetInput(7) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2479 "src/Compiler/pars.fsy"
                            if not (isNil _1) then errorR(Error(FSComp.SR.parsAttributesIllegalHere(), rhs parseState 1))
                            let mLhs = lhs parseState
                            if parseState.LexBuffer.ReportLibraryOnlyFeatures then libraryOnlyError mLhs
                            if Option.isSome _2 then errorR(Error(FSComp.SR.parsInlineAssemblyCannotHaveVisibilityDeclarations(), rhs parseState 2))
                            let s, _ = _5
                            let ilType = ParseAssemblyCodeType s parseState.LexBuffer.ReportLibraryOnlyFeatures parseState.LexBuffer.LanguageVersion parseState.LexBuffer.StrictIndentation (rhs parseState 5)
                            SynTypeDefnSimpleRepr.LibraryOnlyILAssembly(box ilType, mLhs) 
                   )
//# 2479 "src/Compiler/pars.fsy"
                 : SynTypeDefnSimpleRepr));
//# 7429 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParseHelpers.LexerContinuation in
            let _2 = parseState.GetInput(2) :?> 'gentype_recdFieldDeclList in
            let _3 = parseState.GetInput(3) :?> 'gentype_rbrace in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2491 "src/Compiler/pars.fsy"
                            _2 
                   )
//# 2491 "src/Compiler/pars.fsy"
                 : 'gentype_braceFieldDeclList));
//# 7442 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParseHelpers.LexerContinuation in
            let _2 = parseState.GetInput(2) :?> 'gentype_recdFieldDeclList in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2494 "src/Compiler/pars.fsy"
                            reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedBrace())
                            _2 
                   )
//# 2494 "src/Compiler/pars.fsy"
                 : 'gentype_braceFieldDeclList));
//# 7456 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParseHelpers.LexerContinuation in
            let _3 = parseState.GetInput(3) :?> 'gentype_rbrace in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2498 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 2498 "src/Compiler/pars.fsy"
                 : 'gentype_braceFieldDeclList));
//# 7468 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> ParseHelpers.LexerContinuation in
            let _2 = parseState.GetInput(2) :?> 'gentype_rbrace in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2501 "src/Compiler/pars.fsy"
                            errorR (Error(FSComp.SR.parsExpectingRecordField (), rhs parseState 2))
                            [] 
                   )
//# 2501 "src/Compiler/pars.fsy"
                 : 'gentype_braceFieldDeclList));
//# 7481 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_braceBarFieldDeclListCore in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2506 "src/Compiler/pars.fsy"
                               _2, true 
                   )
//# 2506 "src/Compiler/pars.fsy"
                 : 'gentype_anonRecdType));
//# 7492 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_braceBarFieldDeclListCore in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2508 "src/Compiler/pars.fsy"
                               _1, false 
                   )
//# 2508 "src/Compiler/pars.fsy"
                 : 'gentype_anonRecdType));
//# 7503 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recdFieldDeclList in
            let _3 = parseState.GetInput(3) :?> 'gentype_bar_rbrace in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2513 "src/Compiler/pars.fsy"
                            _2 
                   )
//# 2513 "src/Compiler/pars.fsy"
                 : 'gentype_braceBarFieldDeclListCore));
//# 7515 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recdFieldDeclList in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2516 "src/Compiler/pars.fsy"
                            reportParseErrorAt (rhs parseState 1) (FSComp.SR.parsUnmatchedBraceBar())
                            _2 
                   )
//# 2516 "src/Compiler/pars.fsy"
                 : 'gentype_braceBarFieldDeclListCore));
//# 7528 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_bar_rbrace in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2520 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 2520 "src/Compiler/pars.fsy"
                 : 'gentype_braceBarFieldDeclListCore));
//# 7539 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2524 "src/Compiler/pars.fsy"
                            SynTypeDefnKind.Class 
                   )
//# 2524 "src/Compiler/pars.fsy"
                 : 'gentype_classOrInterfaceOrStruct));
//# 7549 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2527 "src/Compiler/pars.fsy"
                            SynTypeDefnKind.Interface 
                   )
//# 2527 "src/Compiler/pars.fsy"
                 : 'gentype_classOrInterfaceOrStruct));
//# 7559 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2530 "src/Compiler/pars.fsy"
                            SynTypeDefnKind.Struct 
                   )
//# 2530 "src/Compiler/pars.fsy"
                 : 'gentype_classOrInterfaceOrStruct));
//# 7569 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2533 "src/Compiler/pars.fsy"
                                     
                   )
//# 2533 "src/Compiler/pars.fsy"
                 : 'gentype_interfaceMember));
//# 7579 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2534 "src/Compiler/pars.fsy"
                                             
                   )
//# 2534 "src/Compiler/pars.fsy"
                 : 'gentype_interfaceMember));
//# 7589 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_access in
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2538 "src/Compiler/pars.fsy"
                             None, _2.LongIdent, false, _1 
                   )
//# 2538 "src/Compiler/pars.fsy"
                 : 'gentype_tyconNameAndTyparDecls));
//# 7601 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_access in
            let _2 = parseState.GetInput(2) :?> 'gentype_prefixTyparDecls in
            let _3 = parseState.GetInput(3) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2541 "src/Compiler/pars.fsy"
                             Some _2, _3.LongIdent, false, _1 
                   )
//# 2541 "src/Compiler/pars.fsy"
                 : 'gentype_tyconNameAndTyparDecls));
//# 7614 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_access in
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            let _3 = parseState.GetInput(3) :?> 'gentype_postfixTyparDecls in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2544 "src/Compiler/pars.fsy"
                             Some _3, _2.LongIdent, true, _1 
                   )
//# 2544 "src/Compiler/pars.fsy"
                 : 'gentype_tyconNameAndTyparDecls));
//# 7627 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_access in
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2547 "src/Compiler/pars.fsy"
                             None, [], false, _1 
                   )
//# 2547 "src/Compiler/pars.fsy"
                 : 'gentype_tyconNameAndTyparDecls));
//# 7639 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2551 "src/Compiler/pars.fsy"
                             SynTyparDecls.SinglePrefix(SynTyparDecl([], _1, [], SynTyparDeclTrivia.Zero), rhs parseState 1) 
                   )
//# 2551 "src/Compiler/pars.fsy"
                 : 'gentype_prefixTyparDecls));
//# 7650 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typarDeclList in
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2554 "src/Compiler/pars.fsy"
                             SynTyparDecls.PrefixList(List.rev _2, rhs2 parseState 1 3) 
                   )
//# 2554 "src/Compiler/pars.fsy"
                 : 'gentype_prefixTyparDecls));
//# 7662 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typarDeclList in
            let _3 = parseState.GetInput(3) :?> 'gentype_typarDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2557 "src/Compiler/pars.fsy"
                                                         _3 :: _1 
                   )
//# 2557 "src/Compiler/pars.fsy"
                 : 'gentype_typarDeclList));
//# 7674 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typarDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2558 "src/Compiler/pars.fsy"
                                     [_1] 
                   )
//# 2558 "src/Compiler/pars.fsy"
                 : 'gentype_typarDeclList));
//# 7685 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> SynTypar in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2562 "src/Compiler/pars.fsy"
                             SynTyparDecl(_1, _2, [], SynTyparDeclTrivia.Zero) 
                   )
//# 2562 "src/Compiler/pars.fsy"
                 : 'gentype_typarDecl));
//# 7697 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> SynTypar in
            let _4 = parseState.GetInput(4) :?> 'gentype_intersectionConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2565 "src/Compiler/pars.fsy"
                             parseState.LexBuffer.CheckLanguageFeatureAndRecover LanguageFeature.ConstraintIntersectionOnFlexibleTypes (rhs2 parseState 3 4)
                             let constraints, mAmpersands = _4
                             SynTyparDecl(_1, _2, List.rev constraints, { AmpersandRanges = rhs parseState 3 :: List.rev mAmpersands }) 
                   )
//# 2565 "src/Compiler/pars.fsy"
                 : 'gentype_typarDecl));
//# 7712 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_HIGH_PRECEDENCE_TYAPP in
            let _2 = parseState.GetInput(2) :?> bool in
            let _3 = parseState.GetInput(3) :?> 'gentype_typarDeclList in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_typeConstraints in
            let _5 = parseState.GetInput(5) :?> bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2573 "src/Compiler/pars.fsy"
                             let m = rhs2 parseState 2 5
                             if not _2 then warning(Error(FSComp.SR.parsNonAdjacentTypars(), m))
                             SynTyparDecls.PostfixList(List.rev _3, _4, m) 
                   )
//# 2573 "src/Compiler/pars.fsy"
                 : 'gentype_postfixTyparDecls));
//# 7729 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typarDeclList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2581 "src/Compiler/pars.fsy"
                             (List.rev _1, true) 
                   )
//# 2581 "src/Compiler/pars.fsy"
                 : 'gentype_explicitValTyparDeclsCore));
//# 7740 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typarDeclList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2584 "src/Compiler/pars.fsy"
                             (List.rev _1, false) 
                   )
//# 2584 "src/Compiler/pars.fsy"
                 : 'gentype_explicitValTyparDeclsCore));
//# 7751 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2587 "src/Compiler/pars.fsy"
                             ([], false) 
                   )
//# 2587 "src/Compiler/pars.fsy"
                 : 'gentype_explicitValTyparDeclsCore));
//# 7761 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_HIGH_PRECEDENCE_TYAPP in
            let _2 = parseState.GetInput(2) :?> bool in
            let _3 = parseState.GetInput(3) :?> 'gentype_explicitValTyparDeclsCore in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_typeConstraints in
            let _5 = parseState.GetInput(5) :?> bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2591 "src/Compiler/pars.fsy"
                             let m = rhs2 parseState 2 5
                             if not _2 then warning(Error(FSComp.SR.parsNonAdjacentTypars(), m))
                             let tps, flex = _3
                             let tps = SynTyparDecls.PostfixList(tps, _4, m)
                             SynValTyparDecls(Some tps, flex) 
                   )
//# 2591 "src/Compiler/pars.fsy"
                 : 'gentype_explicitValTyparDecls));
//# 7780 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_explicitValTyparDecls in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2599 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 2599 "src/Compiler/pars.fsy"
                 : 'gentype_opt_explicitValTyparDecls));
//# 7791 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2601 "src/Compiler/pars.fsy"
                             SynValTyparDecls(None, true) 
                   )
//# 2601 "src/Compiler/pars.fsy"
                 : 'gentype_opt_explicitValTyparDecls));
//# 7801 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_atomType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2605 "src/Compiler/pars.fsy"
                            SynType.HashConstraint(_2, lhs parseState) 
                   )
//# 2605 "src/Compiler/pars.fsy"
                 : 'gentype_hashConstraint));
//# 7812 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2611 "src/Compiler/pars.fsy"
                            [] 
                   )
//# 2611 "src/Compiler/pars.fsy"
                 : 'gentype_opt_typeConstraints));
//# 7822 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typeConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2614 "src/Compiler/pars.fsy"
                            List.rev _2 
                   )
//# 2614 "src/Compiler/pars.fsy"
                 : 'gentype_opt_typeConstraints));
//# 7833 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeConstraints in
            let _3 = parseState.GetInput(3) :?> 'gentype_typeConstraint in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2620 "src/Compiler/pars.fsy"
                            _3 :: _1 
                   )
//# 2620 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraints));
//# 7845 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeConstraint in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2623 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 2623 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraints));
//# 7856 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_intersectionConstraints in
            let _3 = parseState.GetInput(3) :?> 'gentype_hashConstraint in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2629 "src/Compiler/pars.fsy"
                             let constraints, mAmpersands = _1
                             (_3 :: constraints), (rhs parseState 2 :: mAmpersands) 
                   )
//# 2629 "src/Compiler/pars.fsy"
                 : 'gentype_intersectionConstraints));
//# 7869 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_intersectionConstraints in
            let _3 = parseState.GetInput(3) :?> 'gentype_atomType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2633 "src/Compiler/pars.fsy"
                             let constraints, mAmpersands = _1
                             errorR(Error(FSComp.SR.parsConstraintIntersectionSyntaxUsedWithNonFlexibleType(), _3.Range))
                             (_3 :: constraints), (rhs parseState 2 :: mAmpersands) 
                   )
//# 2633 "src/Compiler/pars.fsy"
                 : 'gentype_intersectionConstraints));
//# 7883 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hashConstraint in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2638 "src/Compiler/pars.fsy"
                             [ _1 ], [] 
                   )
//# 2638 "src/Compiler/pars.fsy"
                 : 'gentype_intersectionConstraints));
//# 7894 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2641 "src/Compiler/pars.fsy"
                             errorR(Error(FSComp.SR.parsConstraintIntersectionSyntaxUsedWithNonFlexibleType(), _1.Range))
                             [ _1 ], [] 
                   )
//# 2641 "src/Compiler/pars.fsy"
                 : 'gentype_intersectionConstraints));
//# 7906 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynTypar in
            let _4 = parseState.GetInput(4) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2648 "src/Compiler/pars.fsy"
                            if parseState.LexBuffer.ReportLibraryOnlyFeatures then libraryOnlyError (lhs parseState)
                            SynTypeConstraint.WhereTyparDefaultsToType(_2, _4, lhs parseState) 
                   )
//# 2648 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7919 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _3 = parseState.GetInput(3) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2652 "src/Compiler/pars.fsy"
                            SynTypeConstraint.WhereTyparSubtypeOfType(_1, _3, lhs parseState) 
                   )
//# 2652 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7931 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2655 "src/Compiler/pars.fsy"
                            SynTypeConstraint.WhereTyparIsValueType(_1, lhs parseState) 
                   )
//# 2655 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7942 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _3 = parseState.GetInput(3) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2658 "src/Compiler/pars.fsy"
                            if _3 <> "not" then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedIdentifier(_3))
                            SynTypeConstraint.WhereTyparIsReferenceType(_1, lhs parseState) 
                   )
//# 2658 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7955 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2662 "src/Compiler/pars.fsy"
                            SynTypeConstraint.WhereTyparSupportsNull(_1, lhs parseState) 
                   )
//# 2662 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7966 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _3 = parseState.GetInput(3) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2665 "src/Compiler/pars.fsy"
                             if _3 <> "not" then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedIdentifier(_3 + " (2)"))
                             let trivia : SynTypeConstraintWhereTyparNotSupportsNullTrivia = { ColonRange = rhs parseState 2; NotRange = rhs parseState 3 }
                             SynTypeConstraint.WhereTyparNotSupportsNull(_1, lhs parseState, trivia) 
                   )
//# 2665 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7980 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _4 = parseState.GetInput(4) :?> 'gentype_classMemberSpfn in
            let _5 = parseState.GetInput(5) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2670 "src/Compiler/pars.fsy"
                            let tp = _1
                            SynTypeConstraint.WhereTyparSupportsMember(SynType.Var(tp, tp.Range), _4, lhs parseState) 
                   )
//# 2670 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 7994 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typeAlts in
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            let _6 = parseState.GetInput(6) :?> 'gentype_classMemberSpfn in
            let _7 = parseState.GetInput(7) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2674 "src/Compiler/pars.fsy"
                            let mParen = rhs2 parseState 1 3
                            let t = SynType.Paren(_2, mParen)
                            SynTypeConstraint.WhereTyparSupportsMember(t, _6, lhs parseState) 
                   )
//# 2674 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 8010 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _4 = parseState.GetInput(4) :?> range * range option * SynType list * range list * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2679 "src/Compiler/pars.fsy"
                            let _ltm, _gtm, args, _commas, mWhole = _4
                            SynTypeConstraint.WhereTyparIsDelegate(_1, args, unionRanges _1.Range mWhole) 
                   )
//# 2679 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 8023 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _3 = parseState.GetInput(3) :?> string in
            let _4 = parseState.GetInput(4) :?> range * range option * SynType list * range list * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2683 "src/Compiler/pars.fsy"
                            match _3 with
                            | "enum" ->
                                let _ltm, _gtm, args, _commas, mWhole = _4
                                SynTypeConstraint.WhereTyparIsEnum(_1, args, unionRanges _1.Range mWhole)
                            | nm -> raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedIdentifier(nm + " (3)")) 
                   )
//# 2683 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 8040 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _3 = parseState.GetInput(3) :?> string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2690 "src/Compiler/pars.fsy"
                            match _3 with
                            | "comparison" -> SynTypeConstraint.WhereTyparIsComparable(_1, lhs parseState)
                            | "equality" -> SynTypeConstraint.WhereTyparIsEquatable(_1, lhs parseState)
                            | "unmanaged" -> SynTypeConstraint.WhereTyparIsUnmanaged(_1, lhs parseState)
                            | nm -> raiseParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedIdentifier(nm + " (4)")) 
                   )
//# 2690 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 8056 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_appTypeWithoutNull in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2697 "src/Compiler/pars.fsy"
                            SynTypeConstraint.WhereSelfConstrained(_1, lhs parseState) 
                   )
//# 2697 "src/Compiler/pars.fsy"
                 : 'gentype_typeConstraint));
//# 8067 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typeAlts in
            let _3 = parseState.GetInput(3) :?> 'gentype_appTypeWithoutNull in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2701 "src/Compiler/pars.fsy"
                            let mOr = rhs parseState 2
                            let m = unionRanges _1.Range _3.Range
                            SynType.Or(_1, _3, m, { OrKeyword = mOr }) 
                   )
//# 2701 "src/Compiler/pars.fsy"
                 : 'gentype_typeAlts));
//# 8081 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_appTypeWithoutNull in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2706 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 2706 "src/Compiler/pars.fsy"
                 : 'gentype_typeAlts));
//# 8092 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_barAndgrabXmlDoc in
            let _2 = parseState.GetInput(2) :?> 'gentype_attrUnionCaseDecls in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2713 "src/Compiler/pars.fsy"
                            _2 _1 
                   )
//# 2713 "src/Compiler/pars.fsy"
                 : Choice<SynEnumCase, SynUnionCase> list));
//# 8104 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_firstUnionCaseDeclOfMany in
            let _2 = parseState.GetInput(2) :?> 'gentype_barAndgrabXmlDoc in
            let _3 = parseState.GetInput(3) :?> 'gentype_attrUnionCaseDecls in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2716 "src/Compiler/pars.fsy"
                            _1 :: _3 _2 
                   )
//# 2716 "src/Compiler/pars.fsy"
                 : Choice<SynEnumCase, SynUnionCase> list));
//# 8117 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_firstUnionCaseDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2719 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 2719 "src/Compiler/pars.fsy"
                 : Choice<SynEnumCase, SynUnionCase> list));
//# 8128 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2723 "src/Compiler/pars.fsy"
                            let mBar = rhs parseState 1
                            grabXmlDoc(parseState, [], 1), mBar 
                   )
//# 2723 "src/Compiler/pars.fsy"
                 : 'gentype_barAndgrabXmlDoc));
//# 8139 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attrUnionCaseDecl in
            let _2 = parseState.GetInput(2) :?> 'gentype_barAndgrabXmlDoc in
            let _3 = parseState.GetInput(3) :?> 'gentype_attrUnionCaseDecls in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2728 "src/Compiler/pars.fsy"
                            (fun xmlDocAndBar -> _1 xmlDocAndBar :: _3 _2) 
                   )
//# 2728 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecls));
//# 8152 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attrUnionCaseDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2731 "src/Compiler/pars.fsy"
                            (fun xmlDocAndBar -> [ _1 xmlDocAndBar ]) 
                   )
//# 2731 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecls));
//# 8163 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2736 "src/Compiler/pars.fsy"
                             mkSynUnionCase _1 _2 _3 (SynUnionCaseKind.Fields []) (rhs2 parseState 1 3) >> Choice2Of2 
                   )
//# 2736 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8176 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2739 "src/Compiler/pars.fsy"
                             fun (xmlDoc, mBar) -> mkSynUnionCase _1 _2 (SynIdent(mkSynId mBar.EndRange "", None)) (SynUnionCaseKind.Fields []) mBar (xmlDoc, mBar) |> Choice2Of2 
                   )
//# 2739 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8189 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            let _5 = parseState.GetInput(5) :?> 'gentype_unionCaseRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2742 "src/Compiler/pars.fsy"
                             let mId = rhs parseState 3
                             let fields, mFields = _5
                             let mWhole = unionRanges mId mFields
                             mkSynUnionCase _1 _2 _3 (SynUnionCaseKind.Fields fields) mWhole >> Choice2Of2 
                   )
//# 2742 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8206 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            let _4 = parseState.GetInput(4) :?> 'gentype_unionCaseRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2748 "src/Compiler/pars.fsy"
                             errorR (Error(FSComp.SR.parsMissingKeyword("of"), rhs2 parseState 3 4))
                             let mAttributes = rhs parseState 1
                             let fields, mFields = _4
                             let mWhole = unionRanges mAttributes mFields
                             mkSynUnionCase _1 _2 _3 (SynUnionCaseKind.Fields fields) mWhole >> Choice2Of2 
                   )
//# 2748 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8224 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_unionCaseRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2755 "src/Compiler/pars.fsy"
                             let mAttributes = rhs parseState 1
                             let mOf = rhs parseState 3
                             let mId = mOf.StartRange
                             let fields, mFields = _4
                             let mWhole = unionRanges mAttributes mFields
                             errorR (Error(FSComp.SR.parsMissingUnionCaseName(), mOf))
                             mkSynUnionCase _1 _2 (SynIdent(mkSynId mId "", None)) (SynUnionCaseKind.Fields fields) mWhole >> Choice2Of2 
                   )
//# 2755 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8243 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2764 "src/Compiler/pars.fsy"
                             let mOf = rhs parseState 3
                             let mId = mOf.StartRange
                             errorR (Error(FSComp.SR.parsMissingUnionCaseName(), mOf))
                             mkSynUnionCase _1 _2 (SynIdent(mkSynId mId "", None)) (SynUnionCaseKind.Fields []) (rhs2 parseState 1 3) >> Choice2Of2 
                   )
//# 2764 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8259 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            let _5 = parseState.GetInput(5) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2770 "src/Compiler/pars.fsy"
                             mkSynUnionCase _1 _2 _3 (SynUnionCaseKind.Fields []) (rhs2 parseState 1 4) >> Choice2Of2 
                   )
//# 2770 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8273 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            let _5 = parseState.GetInput(5) :?> 'gentype_topType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2773 "src/Compiler/pars.fsy"
                             let mAttributes = rhs parseState 1
                             let fullType, _ = _5
                             let mWhole = unionRanges mAttributes fullType.Range
                             if parseState.LexBuffer.ReportLibraryOnlyFeatures then libraryOnlyWarning(lhs parseState)
                             mkSynUnionCase _1 _2 _3 (SynUnionCaseKind.FullType _5) mWhole >> Choice2Of2 
                   )
//# 2773 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8291 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            let _5 = parseState.GetInput(5) :?> SynExpr * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2780 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsEnumFieldsCannotHaveVisibilityDeclarations(), rhs parseState 2))
                             let mEquals = rhs parseState 4
                             let mAttributes = rhs parseState 1
                             let expr, _ = _5
                             let mDecl = unionRanges mAttributes expr.Range
                             (fun (xmlDoc, mBar) ->
                                 let trivia: SynEnumCaseTrivia = { BarRange = Some mBar; EqualsRange = mEquals }
                                 let mDecl = unionRangeWithXmlDoc xmlDoc mDecl
                                 Choice1Of2 (SynEnumCase (_1, _3, fst _5, xmlDoc, mDecl, trivia))) 
                   )
//# 2780 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8313 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseName in
            let _5 = parseState.GetInput(5) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2791 "src/Compiler/pars.fsy"
                             if Option.isSome _2 then errorR(Error(FSComp.SR.parsEnumFieldsCannotHaveVisibilityDeclarations(), rhs parseState 2))
                             let mEquals = rhs parseState 4
                             let expr = arbExpr ("attrUnionCaseDecl", mEquals.EndRange)
                             let mDecl = rhs2 parseState 1 4
                             fun (xmlDoc, mBar) ->
                                 let trivia: SynEnumCaseTrivia = { BarRange = Some mBar; EqualsRange = mEquals }
                                 let mDecl = unionRangeWithXmlDoc xmlDoc mDecl
                                 Choice1Of2 (SynEnumCase (_1, _3, expr, xmlDoc, mDecl, trivia)) 
                   )
//# 2791 "src/Compiler/pars.fsy"
                 : 'gentype_attrUnionCaseDecl));
//# 8334 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_nameop in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2803 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 2803 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseName));
//# 8345 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2806 "src/Compiler/pars.fsy"
                             let lpr = rhs parseState 1
                             let rpr = rhs parseState 3
                             SynIdent(ident(opNameCons, rhs parseState 2), Some(IdentTrivia.OriginalNotationWithParen(lpr, "::", rpr))) 
                   )
//# 2806 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseName));
//# 8358 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _4 = parseState.GetInput(4) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2811 "src/Compiler/pars.fsy"
                             let lpr = rhs parseState 1
                             let rpr = rhs parseState 3
                             SynIdent(ident(opNameNil, rhs2 parseState 2 3), Some(IdentTrivia.OriginalNotationWithParen(lpr, "[]", rpr))) 
                   )
//# 2811 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseName));
//# 8371 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2817 "src/Compiler/pars.fsy"
                             let trivia: SynUnionCaseTrivia = { BarRange = None }
                             let xmlDoc = grabXmlDoc(parseState, [], 1)
                             let mDecl = (rhs parseState 1) |> unionRangeWithXmlDoc xmlDoc
                             Choice2Of2 (SynUnionCase ([], (SynIdent(_1, None)), SynUnionCaseKind.Fields [], xmlDoc, None, mDecl, trivia)) 
                   )
//# 2817 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDeclOfMany));
//# 8386 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> SynExpr * bool in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2823 "src/Compiler/pars.fsy"
                             let mEquals = rhs parseState 2
                             let trivia: SynEnumCaseTrivia = { BarRange = None; EqualsRange = mEquals }
                             let xmlDoc = grabXmlDoc(parseState, [], 1)
                             let mDecl = (rhs2 parseState 1 3) |> unionRangeWithXmlDoc xmlDoc
                             Choice1Of2 (SynEnumCase ([], SynIdent(_1, None), fst _3, xmlDoc, mDecl, trivia)) 
                   )
//# 2823 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDeclOfMany));
//# 8403 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2830 "src/Compiler/pars.fsy"
                             let mEquals = rhs parseState 2
                             let expr = arbExpr ("firstUnionCaseDeclOfMany1", mEquals.EndRange)
                             let trivia: SynEnumCaseTrivia = { BarRange = None; EqualsRange = mEquals }
                             let xmlDoc = grabXmlDoc(parseState, [], 1)
                             let mDecl = (rhs2 parseState 1 2) |> unionRangeWithXmlDoc xmlDoc
                             Choice1Of2 (SynEnumCase ([], SynIdent(_1, None), expr, xmlDoc, mDecl, trivia)) 
                   )
//# 2830 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDeclOfMany));
//# 8421 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_firstUnionCaseDecl in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2838 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 2838 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDeclOfMany));
//# 8433 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2842 "src/Compiler/pars.fsy"
                             let fields, mFields = _3
                             let trivia: SynUnionCaseTrivia = { BarRange = None }
                             let xmlDoc = grabXmlDoc (parseState, [], 1)
                             let mId = rhs parseState 1
                             let mDecl = unionRanges mId mFields |> unionRangeWithXmlDoc xmlDoc
                             Choice2Of2(SynUnionCase([], SynIdent(_1, None), SynUnionCaseKind.Fields fields, xmlDoc, None, mDecl, trivia)) 
                   )
//# 2842 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDecl));
//# 8450 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_unionCaseName in
            let _3 = parseState.GetInput(3) :?> 'gentype_topType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2850 "src/Compiler/pars.fsy"
                             if parseState.LexBuffer.ReportLibraryOnlyFeatures then libraryOnlyWarning(lhs parseState)
                             let trivia: SynUnionCaseTrivia = { BarRange = None }
                             let xmlDoc = grabXmlDoc (parseState, [], 1)
                             let mId = rhs parseState 1
                             let fullType, _ = _3
                             let mDecl = unionRanges mId fullType.Range |> unionRangeWithXmlDoc xmlDoc
                             Choice2Of2(SynUnionCase([], _1, SynUnionCaseKind.FullType _3, xmlDoc, None, mDecl, trivia)) 
                   )
//# 2850 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDecl));
//# 8468 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2859 "src/Compiler/pars.fsy"
                             let trivia: SynUnionCaseTrivia = { BarRange = None }
                             let xmlDoc = grabXmlDoc (parseState, [], 1)
                             let mDecl = rhs2 parseState 1 2 |> unionRangeWithXmlDoc xmlDoc
                             Choice2Of2(SynUnionCase([], SynIdent(_1, None), SynUnionCaseKind.Fields [], xmlDoc, None, mDecl, trivia)) 
                   )
//# 2859 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDecl));
//# 8483 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_unionCaseRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2865 "src/Compiler/pars.fsy"
                            let mOf = rhs parseState 1
                            let mId = mOf.StartRange
                            let fields, mFields = _2
                            errorR (Error(FSComp.SR.parsMissingUnionCaseName(), mOf))
                            let id = SynIdent(mkSynId mId "", None)
                            let trivia: SynUnionCaseTrivia = { BarRange = None }
                            let xmlDoc = grabXmlDoc (parseState, [], 1)
                            let mDecl = unionRanges mOf mFields |> unionRangeWithXmlDoc xmlDoc
                            Choice2Of2(SynUnionCase([], id, SynUnionCaseKind.Fields fields, xmlDoc, None, mDecl, trivia)) 
                   )
//# 2865 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDecl));
//# 8502 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> SynExpr * bool in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2876 "src/Compiler/pars.fsy"
                             let mId = rhs parseState 1
                             let mEquals = rhs parseState 2
                             let trivia: SynEnumCaseTrivia = { BarRange = None; EqualsRange = mEquals }
                             let xmlDoc = grabXmlDoc (parseState, [], 1)
                             let expr, _ = _3
                             let mDecl = unionRanges mId expr.Range |> unionRangeWithXmlDoc xmlDoc
                             Choice1Of2(SynEnumCase([], SynIdent(_1, None), fst _3, xmlDoc, mDecl, trivia)) 
                   )
//# 2876 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDecl));
//# 8521 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_OBLOCKSEP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2885 "src/Compiler/pars.fsy"
                             let mEquals = rhs parseState 2
                             let expr = arbExpr ("firstUnionCaseDecl", mEquals.EndRange)
                             let trivia: SynEnumCaseTrivia = { BarRange = None; EqualsRange = mEquals }
                             let xmlDoc = grabXmlDoc (parseState, [], 1)
                             let mDecl = rhs2 parseState 1 2 |> unionRangeWithXmlDoc xmlDoc
                             Choice1Of2(SynEnumCase([], SynIdent(_1, None), expr, xmlDoc, mDecl, trivia)) 
                   )
//# 2885 "src/Compiler/pars.fsy"
                 : 'gentype_firstUnionCaseDecl));
//# 8539 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_unionCaseReprElement in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseReprElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2895 "src/Compiler/pars.fsy"
                            let mField = rhs parseState 1
                            let fields, mFields = _3
                            _1 :: fields, unionRanges mField mFields 
                   )
//# 2895 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElements));
//# 8553 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_unionCaseReprElement in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2900 "src/Compiler/pars.fsy"
                            let mStar = rhs parseState 2
                            let ty = SynType.FromParseError mStar.EndRange
                            let field = mkSynAnonField (ty, PreXmlDoc.Empty)
                            [_1; field], rhs2 parseState 1 2 
                   )
//# 2900 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElements));
//# 8568 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_unionCaseReprElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2906 "src/Compiler/pars.fsy"
                            let mStar = rhs parseState 1
                            errorR (Error(FSComp.SR.parsExpectingUnionCaseField (), rhs parseState 1))
                            let fields, mFields = _2
                            let ty = SynType.FromParseError mStar.StartRange
                            let field = mkSynAnonField (ty, PreXmlDoc.Empty)
                            field :: fields, unionRanges mStar mFields 
                   )
//# 2906 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElements));
//# 8584 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_unionCaseReprElement in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2914 "src/Compiler/pars.fsy"
                            [_1], _1.Range 
                   )
//# 2914 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElements));
//# 8595 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2918 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc (parseState, [], 1)
                            let mId = rhs parseState 1
                            let mWhole = unionRanges mId _3.Range |> unionRangeWithXmlDoc xmlDoc
                            mkSynNamedField (_1, _3, xmlDoc, mWhole) 
                   )
//# 2918 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElement));
//# 8610 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2924 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc (parseState, [], 1)
                            let mColon = rhs parseState 2
                            let ty = SynType.FromParseError mColon.EndRange
                            let mWhole = rhs2 parseState 1 2 |> unionRangeWithXmlDoc xmlDoc
                            mkSynNamedField (_1, ty, xmlDoc, mWhole) 
                   )
//# 2924 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElement));
//# 8626 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2931 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc (parseState, [], 1)
                            mkSynAnonField (_1, xmlDoc) 
                   )
//# 2931 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElement));
//# 8638 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_invalidUseOfAppTypeFunction in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2935 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc (parseState, [], 1)
                            let mWhole = rhs2 parseState 1 3 |> unionRangeWithXmlDoc xmlDoc
                            reportParseErrorAt (_3: SynType).Range (FSComp.SR.tcUnexpectedFunTypeInUnionCaseField ())
                            mkSynNamedField (_1, _3, xmlDoc, mWhole) 
                   )
//# 2935 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElement));
//# 8653 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_invalidUseOfAppTypeFunction in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2941 "src/Compiler/pars.fsy"
                            let xmlDoc = grabXmlDoc (parseState, [], 1)
                            reportParseErrorAt (_1: SynType).Range (FSComp.SR.tcUnexpectedFunTypeInUnionCaseField ())
                            mkSynAnonField (_1, xmlDoc) 
                   )
//# 2941 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseReprElement));
//# 8666 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_braceFieldDeclList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2947 "src/Compiler/pars.fsy"
                            errorR(Deprecated(FSComp.SR.parsConsiderUsingSeparateRecordType(), lhs parseState))
                            _1, rhs parseState 1 
                   )
//# 2947 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseRepr));
//# 8678 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_unionCaseReprElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2951 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 2951 "src/Compiler/pars.fsy"
                 : 'gentype_unionCaseRepr));
//# 8689 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_recdFieldDecl in
            let _2 = parseState.GetInput(2) :?> 'gentype_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_recdFieldDeclList in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2956 "src/Compiler/pars.fsy"
                            _1 :: _3 
                   )
//# 2956 "src/Compiler/pars.fsy"
                 : 'gentype_recdFieldDeclList));
//# 8702 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_recdFieldDecl in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2959 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 2959 "src/Compiler/pars.fsy"
                 : 'gentype_recdFieldDeclList));
//# 8714 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_fieldDecl in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2964 "src/Compiler/pars.fsy"
                            let rangeStart = rhs parseState 1
                            let fld = _2 _1 None rangeStart None
                            let (SynField (a, b, c, d, e, xmlDoc, vis, mWhole, trivia)) = fld
                            if Option.isSome vis then errorR (Error (FSComp.SR.parsRecordFieldsCannotHaveVisibilityDeclarations (), rhs parseState 2))
                            let mWhole = unionRangeWithXmlDoc xmlDoc mWhole
                            SynField (a, b, c, d, e, xmlDoc, None, mWhole, trivia) 
                   )
//# 2964 "src/Compiler/pars.fsy"
                 : 'gentype_recdFieldDecl));
//# 8731 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_mutable in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> Ident in
            let _5 = parseState.GetInput(5) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2974 "src/Compiler/pars.fsy"
                            mkSynField parseState (Some _3) (Some _5) _1 _2 
                   )
//# 2974 "src/Compiler/pars.fsy"
                 : 'gentype_fieldDecl));
//# 8745 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_mutable in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> Ident in
            let _5 = parseState.GetInput(5) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2977 "src/Compiler/pars.fsy"
                            let mColon = rhs parseState 4
                            let t = SynType.FromParseError(mColon.EndRange)
                            mkSynField parseState (Some _3) (Some t) _1 _2 
                   )
//# 2977 "src/Compiler/pars.fsy"
                 : 'gentype_fieldDecl));
//# 8761 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_mutable in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> Ident in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2982 "src/Compiler/pars.fsy"
                            let t = SynType.FromParseError(_3.idRange.EndRange)
                            mkSynField parseState (Some _3) (Some t) _1 _2 
                   )
//# 2982 "src/Compiler/pars.fsy"
                 : 'gentype_fieldDecl));
//# 8776 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_mutable in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_access in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2986 "src/Compiler/pars.fsy"
                            mkSynField parseState None None _1 _2 
                   )
//# 2986 "src/Compiler/pars.fsy"
                 : 'gentype_fieldDecl));
//# 8789 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynExceptionDefnRepr in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_classDefn in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2991 "src/Compiler/pars.fsy"
                            let mWith, optClassDefn = _2
                            SynExceptionDefn(_1, mWith, optClassDefn, (_1.Range, optClassDefn) ||> unionRangeWithListBy (fun cd -> cd.Range)) 
                   )
//# 2991 "src/Compiler/pars.fsy"
                 : SynExceptionDefn));
//# 8802 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_exconIntro in
            let _5 = parseState.GetInput(5) :?> 'gentype_exconRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 2997 "src/Compiler/pars.fsy"
                             let m =
                                 match _5 with
                                 | None -> rhs2 parseState 1 4
                                 | Some p -> unionRanges (rangeOfLongIdent p) (rhs2 parseState 1 4)
                             SynExceptionDefnRepr(_2, _4, _5, PreXmlDoc.Empty, _3, m) 
                   )
//# 2997 "src/Compiler/pars.fsy"
                 : SynExceptionDefnRepr));
//# 8820 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_attributes in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3004 "src/Compiler/pars.fsy"
                             let m =
                                 match _3 with
                                 | Some access -> unionRanges (rhs parseState 1) access.Range
                                 | _ ->
                                 match _2 with
                                 | [] -> rhs parseState 1
                                 | attrs -> ((rhs parseState 1), attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                             let id = SynIdent(mkSynId m.EndRange "", None)
                             let unionCase = SynUnionCase([], id, SynUnionCaseKind.Fields [], PreXmlDoc.Empty, None, m, { BarRange = None })
                             SynExceptionDefnRepr(_2, unionCase, None, PreXmlDoc.Empty, _3, m) 
                   )
//# 3004 "src/Compiler/pars.fsy"
                 : SynExceptionDefnRepr));
//# 8842 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3021 "src/Compiler/pars.fsy"
                             SynUnionCase([], SynIdent(_1, None), SynUnionCaseKind.Fields [], PreXmlDoc.Empty, None, lhs parseState, { BarRange = None }) 
                   )
//# 3021 "src/Compiler/pars.fsy"
                 : 'gentype_exconIntro));
//# 8853 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_unionCaseRepr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3024 "src/Compiler/pars.fsy"
                             let fields, _ = _3
                             SynUnionCase([], SynIdent(_1, None), SynUnionCaseKind.Fields fields, PreXmlDoc.Empty, None, lhs parseState, { BarRange = None }) 
                   )
//# 3024 "src/Compiler/pars.fsy"
                 : 'gentype_exconIntro));
//# 8866 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3028 "src/Compiler/pars.fsy"
                             SynUnionCase([], SynIdent(_1, None), SynUnionCaseKind.Fields [], PreXmlDoc.Empty, None, lhs parseState, { BarRange = None }) 
                   )
//# 3028 "src/Compiler/pars.fsy"
                 : 'gentype_exconIntro));
//# 8878 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3032 "src/Compiler/pars.fsy"
                            None 
                   )
//# 3032 "src/Compiler/pars.fsy"
                 : 'gentype_exconRepr));
//# 8888 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3035 "src/Compiler/pars.fsy"
                            Some(_2.LongIdent) 
                   )
//# 3035 "src/Compiler/pars.fsy"
                 : 'gentype_exconRepr));
//# 8899 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> bool in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_rec in
            let _3 = parseState.GetInput(3) :?> 'gentype_localBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3043 "src/Compiler/pars.fsy"
                             let mLetKwd = rhs parseState 1
                             let isUse = _1
                             let isRec = _2
                             let leadingKeyword =
                                 if isRec then
                                     SynLeadingKeyword.LetRec(mLetKwd, rhs parseState 2)
                                 else
                                     SynLeadingKeyword.Let(mLetKwd)
                             let localBindingsLastRangeOpt, localBindingsBuilder = _3
                             // Calculate the precise range of the binding set, up to the end of the last r.h.s. expression
                             let bindingSetRange =
                                 match localBindingsLastRangeOpt with
                                 | None -> rhs2 parseState 1 2 (* there was some error - this will be an approximate range *)
                                 | Some lastRange -> unionRanges mLetKwd lastRange
                             // The first binding swallows any attributes prior to the 'let'
                             BindingSetPreAttrs(mLetKwd, isRec, isUse,
                                 (fun attrs vis ->
                                     let xmlDoc = grabXmlDoc(parseState, attrs, 1)
                                     // apply the builder
                                     let binds = localBindingsBuilder xmlDoc attrs vis leadingKeyword
                                     if not isRec && not (isNilOrSingleton binds) then
                                           reportParseErrorAt mLetKwd (FSComp.SR.parsLetAndForNonRecBindings())
                                     [], binds),
                                 bindingSetRange) 
                   )
//# 3043 "src/Compiler/pars.fsy"
                 : 'gentype_defnBindings));
//# 8935 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_cPrototype in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3072 "src/Compiler/pars.fsy"
                             let bindRange = lhs parseState
                             BindingSetPreAttrs(bindRange, false, false, _1, bindRange) 
                   )
//# 3072 "src/Compiler/pars.fsy"
                 : 'gentype_defnBindings));
//# 8947 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3079 "src/Compiler/pars.fsy"
                             let mDoKwd = rhs parseState 1
                             let mWhole = unionRanges mDoKwd _2.Range
                             // any attributes prior to the 'let' are left free, e.g. become top-level attributes
                             // associated with the module, 'main' function or assembly depending on their target
                             BindingSetPreAttrs(mDoKwd, false, false, (fun attrs vis -> attrs, [mkSynDoBinding (vis, mDoKwd, _2, mWhole)]), mWhole) 
                   )
//# 3079 "src/Compiler/pars.fsy"
                 : 'gentype_doBinding));
//# 8962 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> bool in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_rec in
            let _3 = parseState.GetInput(3) :?> 'gentype_localBindings in
            let _4 = parseState.GetInput(4) :?> 'gentype_hardwhiteDefnBindingsTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3089 "src/Compiler/pars.fsy"
                             let mLetKwd = rhs parseState 1
                             let isUse = _1
                             let isRec = _2
                             let leadingKeyword =
                                 if not isUse && isRec then
                                     SynLeadingKeyword.LetRec(mLetKwd, rhs parseState 2)
                                 elif isUse && not isRec then
                                     SynLeadingKeyword.Use mLetKwd
                                 elif isUse && isRec then
                                     SynLeadingKeyword.UseRec(mLetKwd, rhs parseState 2)
                                 else
                                     SynLeadingKeyword.Let(mLetKwd)
                             let report, mIn, _ = _4
                             report (if isUse then "use" else "let") mLetKwd // report unterminated error
                             let localBindingsLastRangeOpt, localBindingsBuilder = _3
                             // Calculate the precise range of the binding set, up to the end of the last r.h.s. expression
                             let bindingSetRange =
                                 match localBindingsLastRangeOpt with
                                 | None -> rhs parseState 1 (* there was some error - this will be an approximate range *)
                                 | Some lastRange -> unionRanges mLetKwd lastRange
                             // the first binding swallow any attributes prior to the 'let'
                             BindingSetPreAttrs(mLetKwd, isRec, isUse,
                               (fun attrs vis ->
                                 let xmlDoc = grabXmlDoc(parseState, attrs, 1)
                                 let binds = localBindingsBuilder xmlDoc attrs vis leadingKeyword
                                 if not isRec && not (isNilOrSingleton binds) then
                                     reportParseErrorAt mLetKwd (FSComp.SR.parsLetAndForNonRecBindings())
                                 [], binds),
                               bindingSetRange),
                               (unionRanges mLetKwd bindingSetRange),
                               mIn 
                   )
//# 3089 "src/Compiler/pars.fsy"
                 : 'gentype_hardwhiteLetBindings));
//# 9006 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynExpr in
            let _3 = parseState.GetInput(3) :?> 'gentype_hardwhiteDefnBindingsTerminator in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3129 "src/Compiler/pars.fsy"
                             let mDo = rhs parseState 1
                             let _, _, mDone = _3
                             let mAll = unionRanges mDo _2.Range
                             let seqPt = DebugPointAtBinding.NoneAtDo
                             // any attributes prior to the 'let' are left free, e.g. become top-level attributes
                             // associated with the module, 'main' function or assembly depending on their target
                             BindingSetPreAttrs(mDo, false, false, (fun attrs vis -> attrs, [mkSynDoBinding (vis, mDo, _2, mAll)]), mAll), _2 
                   )
//# 3129 "src/Compiler/pars.fsy"
                 : 'gentype_hardwhiteDoBinding));
//# 9024 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3138 "src/Compiler/pars.fsy"
                             let mDo = rhs parseState 1
                             reportParseErrorAt (rhs parseState 2) (FSComp.SR.parsExpectingExpression ())
                             let seqPt = DebugPointAtBinding.NoneAtDo
                             let expr = arbExpr ("hardwhiteDoBinding1", mDo.EndRange)
                             BindingSetPreAttrs(mDo, false, false, (fun attrs vis -> attrs, [mkSynDoBinding (vis, mDo, expr, mDo)]), mDo), expr 
                   )
//# 3138 "src/Compiler/pars.fsy"
                 : 'gentype_hardwhiteDoBinding));
//# 9039 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_defnBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3147 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 3147 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBindings));
//# 9050 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_doBinding in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3150 "src/Compiler/pars.fsy"
                            _1 
                   )
//# 3150 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBindings));
//# 9061 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hardwhiteLetBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3153 "src/Compiler/pars.fsy"
                            let b, m, _ = _1
                            b 
                   )
//# 3153 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBindings));
//# 9073 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_hardwhiteDoBinding in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3157 "src/Compiler/pars.fsy"
                            fst _1 
                   )
//# 3157 "src/Compiler/pars.fsy"
                 : 'gentype_classDefnBindings));
//# 9084 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3163 "src/Compiler/pars.fsy"
                            let mToken = rhs parseState 1
                            // In LexFilter.fs the IN token could have been transformed to an ODECLEND one.
                            let mIn = if (mToken.EndColumn - mToken.StartColumn) = 2 then Some mToken else None
                            (fun _ m -> ()), mIn, Some _1 
                   )
//# 3163 "src/Compiler/pars.fsy"
                 : 'gentype_hardwhiteDefnBindingsTerminator));
//# 9098 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3169 "src/Compiler/pars.fsy"
                            (fun kwd m ->
                              let msg =
                                  match kwd with
                                  | "let!" -> FSComp.SR.parsUnmatchedLetBang()
                                  | "use!" -> FSComp.SR.parsUnmatchedUseBang()
                                  | "use" -> FSComp.SR.parsUnmatchedUse()
                                  | _ (*"let" *) -> FSComp.SR.parsUnmatchedLet()
                              reportParseErrorAt m msg), None, None 
                   )
//# 3169 "src/Compiler/pars.fsy"
                 : 'gentype_hardwhiteDefnBindingsTerminator));
//# 9116 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_cRetType in
            let _3 = parseState.GetInput(3) :?> 'gentype_opt_access in
            let _4 = parseState.GetInput(4) :?> Ident in
            let _5 = parseState.GetInput(5) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            let _7 = parseState.GetInput(7) :?> 'gentype_externArgs in
            let _8 = parseState.GetInput(8) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3181 "src/Compiler/pars.fsy"
                             let mExtern = rhs parseState 1
                             let rty, vis, nm, (args, commas) = _2, _3, _4, _7
                             let nmm = rhs parseState 3
                             let argsm = rhs parseState 6
                             let mBindLhs = lhs parseState
                             let mWhole = lhs parseState
                             let mRhs = lhs parseState
                             let rhsExpr =
                                 SynExpr.App(
                                     ExprAtomicFlag.NonAtomic,
                                     false,
                                     SynExpr.Ident(ident("failwith", rhs parseState 6)),
                                     SynExpr.Const(SynConst.String("extern was not given a DllImport attribute", SynStringKind.Regular, rhs parseState 8), rhs parseState 8),
                                     mRhs)
                             (fun attrs _ ->
                                 let bindingPat = SynPat.LongIdent(SynLongIdent([nm], [], [None]), None, Some noInferredTypars, SynArgPats.Pats [SynPat.Tuple(false, args, commas, argsm)], vis, nmm)
                                 let mWholeBindLhs = (mBindLhs, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                 let xmlDoc = grabXmlDoc(parseState, attrs, 1)
                                 let trivia = { LeadingKeyword = SynLeadingKeyword.Extern mExtern; InlineKeyword = None; EqualsRange = None }
                                 let binding =
                                     mkSynBinding
                                         (xmlDoc, bindingPat)
                                         (vis, false, false, mWholeBindLhs, DebugPointAtBinding.NoneAtInvisible, Some(None, rty), rhsExpr, mRhs, [], attrs, None, trivia)
                                 [], [binding]) 
                   )
//# 3181 "src/Compiler/pars.fsy"
                 : 'gentype_cPrototype));
//# 9155 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_externMoreArgs in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3209 "src/Compiler/pars.fsy"
                            let args, commas = _1
                            List.rev args, (List.rev commas) 
                   )
//# 3209 "src/Compiler/pars.fsy"
                 : 'gentype_externArgs));
//# 9167 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_externArg in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3213 "src/Compiler/pars.fsy"
                            [_1], [] 
                   )
//# 3213 "src/Compiler/pars.fsy"
                 : 'gentype_externArgs));
//# 9178 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3215 "src/Compiler/pars.fsy"
                            [], [] 
                   )
//# 3215 "src/Compiler/pars.fsy"
                 : 'gentype_externArgs));
//# 9188 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_externMoreArgs in
            let _3 = parseState.GetInput(3) :?> 'gentype_externArg in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3221 "src/Compiler/pars.fsy"
                            let args, commas = _1
                            let mComma = rhs parseState 2
                            _3 :: args, (mComma :: commas) 
                   )
//# 3221 "src/Compiler/pars.fsy"
                 : 'gentype_externMoreArgs));
//# 9202 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_externArg in
            let _3 = parseState.GetInput(3) :?> 'gentype_externArg in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3226 "src/Compiler/pars.fsy"
                            let mComma = rhs parseState 2
                            [_3; _1], [mComma] 
                   )
//# 3226 "src/Compiler/pars.fsy"
                 : 'gentype_externMoreArgs));
//# 9215 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_cType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3233 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            SynPat.Typed(SynPat.Wild m, _2, m) |> addAttribs _1 
                   )
//# 3233 "src/Compiler/pars.fsy"
                 : 'gentype_externArg));
//# 9228 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_cType in
            let _3 = parseState.GetInput(3) :?> Ident in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3237 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            SynPat.Typed(SynPat.Named(SynIdent(_3, None), false, None, m), _2, m) |> addAttribs _1 
                   )
//# 3237 "src/Compiler/pars.fsy"
                 : 'gentype_externArg));
//# 9242 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynLongIdent in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3243 "src/Compiler/pars.fsy"
                            let m = _1.Range
                            SynType.App(SynType.LongIdent(_1), None, [], [], None, false, m) 
                   )
//# 3243 "src/Compiler/pars.fsy"
                 : 'gentype_cType));
//# 9254 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_cType in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_HIGH_PRECEDENCE_APP in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3247 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            SynType.App(SynType.LongIdent(SynLongIdent([ident("[]", m)], [], [None])), None, [_1], [], None, true, m) 
                   )
//# 3247 "src/Compiler/pars.fsy"
                 : 'gentype_cType));
//# 9267 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_cType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3251 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            SynType.App(SynType.LongIdent(SynLongIdent([ident("nativeptr", m)], [], [ Some(IdentTrivia.OriginalNotation "*") ])), None, [_1], [], None, true, m) 
                   )
//# 3251 "src/Compiler/pars.fsy"
                 : 'gentype_cType));
//# 9279 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_cType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3255 "src/Compiler/pars.fsy"
                           SynType.WithNull(_1, false, lhs parseState, { BarRange = rhs parseState 2 }) 
                   )
//# 3255 "src/Compiler/pars.fsy"
                 : 'gentype_cType));
//# 9290 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_cType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3258 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            SynType.App(SynType.LongIdent(SynLongIdent([ident("byref", m)], [], [ Some(IdentTrivia.OriginalNotation "&") ])), None, [_1], [], None, true, m) 
                   )
//# 3258 "src/Compiler/pars.fsy"
                 : 'gentype_cType));
//# 9302 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3262 "src/Compiler/pars.fsy"
                            let m = lhs parseState
                            SynType.App(SynType.LongIdent(SynLongIdent([ident("nativeint", m)], [], [ Some(IdentTrivia.OriginalNotation "void*") ])), None, [], [], None, true, m) 
                   )
//# 3262 "src/Compiler/pars.fsy"
                 : 'gentype_cType));
//# 9313 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_cType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3269 "src/Compiler/pars.fsy"
                            SynReturnInfo((_2, SynArgInfo(_1, false, None)), rhs parseState 2) 
                   )
//# 3269 "src/Compiler/pars.fsy"
                 : 'gentype_cRetType));
//# 9325 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3272 "src/Compiler/pars.fsy"
                            let m = rhs parseState 2
                            SynReturnInfo((SynType.App(SynType.LongIdent(SynLongIdent([ident("unit", m)], [], [ Some(IdentTrivia.OriginalNotation "void") ])), None, [], [], None, false, m), SynArgInfo(_1, false, None)), m) 
                   )
//# 3272 "src/Compiler/pars.fsy"
                 : 'gentype_cRetType));
//# 9337 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_attr_localBinding in
            let _2 = parseState.GetInput(2) :?> 'gentype_moreLocalBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3278 "src/Compiler/pars.fsy"
                             let (moreBindings, moreBindingRanges) = List.unzip _2
                             let moreLocalBindingsLastRange = if moreBindingRanges.IsEmpty then None else Some(List.last moreBindingRanges)
                             match _1 with
                             | Some(localBindingRange, attrLocalBindingBuilder) ->
                                let lastRange =
                                    match moreLocalBindingsLastRange with
                                    | None -> localBindingRange
                                    | Some m -> m
                                Some lastRange, (fun xmlDoc attrs vis leadingKeyword -> attrLocalBindingBuilder xmlDoc attrs vis leadingKeyword true :: moreBindings)
                             | None ->
                                moreLocalBindingsLastRange, (fun _xmlDoc _attrs _vis _leadingKeyword -> moreBindings) 
                   )
//# 3278 "src/Compiler/pars.fsy"
                 : 'gentype_localBindings));
//# 9359 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_attr_localBinding in
            let _3 = parseState.GetInput(3) :?> 'gentype_moreLocalBindings in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3293 "src/Compiler/pars.fsy"
                             let leadingKeyword = SynLeadingKeyword.And(rhs parseState 1)
                             (match _2 with
                              | Some(localBindingRange, attrLocalBindingBuilder) ->
                                 let xmlDoc = grabXmlDoc(parseState, [], 1)
                                 let xmlDoc = if xmlDoc.IsEmpty then grabXmlDoc(parseState, [], 2) else xmlDoc
                                 (attrLocalBindingBuilder xmlDoc [] None leadingKeyword false, localBindingRange) :: _3
                              | None -> _3) 
                   )
//# 3293 "src/Compiler/pars.fsy"
                 : 'gentype_moreLocalBindings));
//# 9377 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3302 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 3302 "src/Compiler/pars.fsy"
                 : 'gentype_moreLocalBindings));
//# 9387 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_attributes in
            let _2 = parseState.GetInput(2) :?> 'gentype_localBinding in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3308 "src/Compiler/pars.fsy"
                             let attrs2 = _1
                             let localBindingRange, localBindingBuilder = _2
                             let attrLocalBindingBuilder = (fun xmlDoc attrs vis leadingKeyword _ -> localBindingBuilder xmlDoc (attrs@attrs2) vis leadingKeyword)
                             Some(localBindingRange, attrLocalBindingBuilder) 
                   )
//# 3308 "src/Compiler/pars.fsy"
                 : 'gentype_attr_localBinding));
//# 9402 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3314 "src/Compiler/pars.fsy"
                             None 
                   )
//# 3314 "src/Compiler/pars.fsy"
                 : 'gentype_attr_localBinding));
//# 9412 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_bindingPattern in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            let _6 = parseState.GetInput(6) :?> 'gentype_typedExprWithStaticOptimizationsBlock in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3320 "src/Compiler/pars.fsy"
                             let (expr: SynExpr), opts = _6
                             let mEquals = rhs parseState 5
                             let mRhs = expr.Range
                             let optReturnType = _4
                             let bindingPat, mBindLhs = _3
                             let localBindingRange = unionRanges (rhs2 parseState 1 5) mRhs
                             let localBindingBuilder =
                               (fun xmlDoc attrs vis (leadingKeyword: SynLeadingKeyword) ->
                                 let mWhole = (unionRanges leadingKeyword.Range mRhs, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                 let spBind = if IsDebugPointBinding bindingPat expr then DebugPointAtBinding.Yes mWhole else DebugPointAtBinding.NoneAtLet
                                 let mWholeBindLhs = (mBindLhs, attrs) ||> unionRangeWithListBy (fun (a: SynAttributeList) -> a.Range)
                                 let trivia: SynBindingTrivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _1; EqualsRange = Some mEquals }
                                 mkSynBinding (xmlDoc, bindingPat) (vis, Option.isSome _1, Option.isSome _2, mWholeBindLhs, spBind, optReturnType, expr, mRhs, opts, attrs, None, trivia))
                             localBindingRange, localBindingBuilder 
                   )
//# 3320 "src/Compiler/pars.fsy"
                 : 'gentype_localBinding));
//# 9440 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_bindingPattern in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3336 "src/Compiler/pars.fsy"
                             let mWhole = rhs2 parseState 1 5
                             let mRhs = rhs parseState 5
                             let optReturnType = _4
                             let bindingPat, mBindLhs = _3
                             let localBindingBuilder =
                               (fun xmlDoc attrs vis leadingKeyword ->
                                 let mEquals = rhs parseState 5
                                 let zeroWidthAtEnd = mEquals.EndRange
                                 let rhsExpr = arbExpr ("localBinding1", zeroWidthAtEnd)
                                 let spBind = if IsDebugPointBinding bindingPat rhsExpr then DebugPointAtBinding.Yes mWhole else DebugPointAtBinding.NoneAtLet
                                 let trivia: SynBindingTrivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _1; EqualsRange = Some mEquals }
                                 mkSynBinding (xmlDoc, bindingPat) (vis, Option.isSome _1, Option.isSome _2, mBindLhs, spBind, optReturnType, rhsExpr, mRhs, [], attrs, None, trivia))
                             mWhole, localBindingBuilder 
                   )
//# 3336 "src/Compiler/pars.fsy"
                 : 'gentype_localBinding));
//# 9466 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_inline in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_mutable in
            let _3 = parseState.GetInput(3) :?> 'gentype_bindingPattern in
            let _4 = parseState.GetInput(4) :?> 'gentype_opt_topReturnTypeWithTypeConstraints in
            let _5 = parseState.GetInput(5) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3351 "src/Compiler/pars.fsy"
                             if not _5 then reportParseErrorAt (rhs parseState 5) (FSComp.SR.parsUnexpectedEndOfFileDefinition())
                             let bindingPat, mBindLhs = _3
                             let optReturnType = _4
                             let mWhole =
                                 let mStart = rhs parseState 1
                                 let mEnd =
                                     match optReturnType with
                                     | None -> bindingPat.Range
                                     | Some (_, returnInfo) -> returnInfo.Range
                                 unionRanges mStart mEnd
                             let mRhs = mWhole.EndRange // zero-width range at end of last good token
                             let localBindingBuilder =
                               (fun xmlDoc attrs vis (leadingKeyword: SynLeadingKeyword) ->
                                 let spBind = DebugPointAtBinding.Yes(unionRanges leadingKeyword.Range mRhs)
                                 let trivia = { LeadingKeyword = leadingKeyword; InlineKeyword = _1; EqualsRange = None }
                                 let rhsExpr = arbExpr ("localBinding2", mRhs)
                                 mkSynBinding (xmlDoc, bindingPat) (vis, Option.isSome _1, Option.isSome _2, mBindLhs, spBind, optReturnType, rhsExpr, mRhs, [], attrs, None, trivia))
                             mWhole, localBindingBuilder 
                   )
//# 3351 "src/Compiler/pars.fsy"
                 : 'gentype_localBinding));
//# 9498 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typedExprWithStaticOptimizations in
            let _3 = parseState.GetInput(3) :?> 'gentype_oblockend in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3373 "src/Compiler/pars.fsy"
                             _2 
                   )
//# 3373 "src/Compiler/pars.fsy"
                 : 'gentype_typedExprWithStaticOptimizationsBlock));
//# 9510 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_typedExprWithStaticOptimizations in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3376 "src/Compiler/pars.fsy"
                             if not _3 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedEndOfFile())
                             let a, b = _2
                             (exprFromParseError a, b) 
                   )
//# 3376 "src/Compiler/pars.fsy"
                 : 'gentype_typedExprWithStaticOptimizationsBlock));
//# 9524 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typedExprWithStaticOptimizations in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3381 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 3381 "src/Compiler/pars.fsy"
                 : 'gentype_typedExprWithStaticOptimizationsBlock));
//# 9535 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_typedSequentialExpr in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_staticOptimizations in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3385 "src/Compiler/pars.fsy"
                             _1, List.rev _2 
                   )
//# 3385 "src/Compiler/pars.fsy"
                 : 'gentype_typedExprWithStaticOptimizations));
//# 9547 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_opt_staticOptimizations in
            let _2 = parseState.GetInput(2) :?> 'gentype_staticOptimization in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3389 "src/Compiler/pars.fsy"
                             _2 :: _1 
                   )
//# 3389 "src/Compiler/pars.fsy"
                 : 'gentype_opt_staticOptimizations));
//# 9559 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3392 "src/Compiler/pars.fsy"
                             [] 
                   )
//# 3392 "src/Compiler/pars.fsy"
                 : 'gentype_opt_staticOptimizations));
//# 9569 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_staticOptimizationConditions in
            let _4 = parseState.GetInput(4) :?> SynExpr in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3396 "src/Compiler/pars.fsy"
                             (_2, _4) 
                   )
//# 3396 "src/Compiler/pars.fsy"
                 : 'gentype_staticOptimization));
//# 9581 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_staticOptimizationConditions in
            let _3 = parseState.GetInput(3) :?> 'gentype_staticOptimizationCondition in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3400 "src/Compiler/pars.fsy"
                             _3 :: _1 
                   )
//# 3400 "src/Compiler/pars.fsy"
                 : 'gentype_staticOptimizationConditions));
//# 9593 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_staticOptimizationCondition in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3403 "src/Compiler/pars.fsy"
                             [_1 ] 
                   )
//# 3403 "src/Compiler/pars.fsy"
                 : 'gentype_staticOptimizationConditions));
//# 9604 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            let _3 = parseState.GetInput(3) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3407 "src/Compiler/pars.fsy"
                             SynStaticOptimizationConstraint.WhenTyparTyconEqualsTycon(_1, _3, lhs parseState) 
                   )
//# 3407 "src/Compiler/pars.fsy"
                 : 'gentype_staticOptimizationCondition));
//# 9616 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynTypar in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3410 "src/Compiler/pars.fsy"
                             SynStaticOptimizationConstraint.WhenTyparIsStruct(_1, lhs parseState) 
                   )
//# 3410 "src/Compiler/pars.fsy"
                 : 'gentype_staticOptimizationCondition));
//# 9627 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> sbyte * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3414 "src/Compiler/pars.fsy"
                           if snd _1 then errorR(Error(FSComp.SR.lexOutsideEightBitSigned(), lhs parseState))
                           SynConst.SByte(fst _1) 
                   )
//# 3414 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9639 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> byte in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3418 "src/Compiler/pars.fsy"
                           SynConst.Byte _1 
                   )
//# 3418 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9650 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int16 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3421 "src/Compiler/pars.fsy"
                           if snd _1 then errorR(Error(FSComp.SR.lexOutsideSixteenBitSigned(), lhs parseState))
                           SynConst.Int16 (fst _1) 
                   )
//# 3421 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9662 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> uint16 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3425 "src/Compiler/pars.fsy"
                           SynConst.UInt16 _1 
                   )
//# 3425 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9673 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3428 "src/Compiler/pars.fsy"
                           if snd _1 then errorR(Error(FSComp.SR.lexOutsideThirtyTwoBitSigned(), lhs parseState))
                           SynConst.Int32 (fst _1) 
                   )
//# 3428 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9685 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> uint32 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3432 "src/Compiler/pars.fsy"
                           SynConst.UInt32 _1 
                   )
//# 3432 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9696 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int64 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3435 "src/Compiler/pars.fsy"
                           if snd _1 then errorR(Error(FSComp.SR.lexOutsideSixtyFourBitSigned(), lhs parseState))
                           SynConst.Int64 (fst _1) 
                   )
//# 3435 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9708 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> uint64 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3439 "src/Compiler/pars.fsy"
                           SynConst.UInt64 _1 
                   )
//# 3439 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9719 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int64 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3442 "src/Compiler/pars.fsy"
                           if snd _1 then errorR(Error(FSComp.SR.lexOutsideNativeSigned(), lhs parseState))
                           SynConst.IntPtr(fst _1) 
                   )
//# 3442 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9731 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> uint64 in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3446 "src/Compiler/pars.fsy"
                           SynConst.UIntPtr _1 
                   )
//# 3446 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9742 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> single in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3449 "src/Compiler/pars.fsy"
                           SynConst.Single _1 
                   )
//# 3449 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9753 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> double in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3452 "src/Compiler/pars.fsy"
                           SynConst.Double _1 
                   )
//# 3452 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9764 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> char in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3455 "src/Compiler/pars.fsy"
                           SynConst.Char _1 
                   )
//# 3455 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9775 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> System.Decimal in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3458 "src/Compiler/pars.fsy"
                           SynConst.Decimal _1 
                   )
//# 3458 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9786 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> (string * string) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3461 "src/Compiler/pars.fsy"
                           SynConst.UserNum _1 
                   )
//# 3461 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9797 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_string in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3464 "src/Compiler/pars.fsy"
                           let s, synStringKind = _1
                           SynConst.String(s, synStringKind, lhs parseState) 
                   )
//# 3464 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9809 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_sourceIdentifier in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3468 "src/Compiler/pars.fsy"
                           let c, v = _1
                           SynConst.SourceIdentifier(c, v, lhs parseState) 
                   )
//# 3468 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9821 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> byte[] * SynByteStringKind * ParseHelpers.LexerContinuation in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3472 "src/Compiler/pars.fsy"
                           let (v, synByteStringKind, _) = _1
                           SynConst.Bytes(v, synByteStringKind, lhs parseState) 
                   )
//# 3472 "src/Compiler/pars.fsy"
                 : 'gentype_rawConstant));
//# 9833 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int32 * bool in
            let _2 = parseState.GetInput(2) :?> string in
            let _3 = parseState.GetInput(3) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3477 "src/Compiler/pars.fsy"
                           if _2 <> "/" then reportParseErrorAt (rhs parseState 2) (FSComp.SR.parsUnexpectedOperatorForUnitOfMeasure())
                           if fst _3 = 0 then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsIllegalDenominatorForMeasureExponent())
                           if (snd _1) || (snd _3) then errorR(Error(FSComp.SR.lexOutsideThirtyTwoBitSigned(), lhs parseState))
                           SynRationalConst.Rational(fst _1, rhs parseState 1, rhs parseState 2, fst _3, rhs parseState 3, lhs parseState) 
                   )
//# 3477 "src/Compiler/pars.fsy"
                 : 'gentype_rationalConstant));
//# 9849 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> int32 * bool in
            let _3 = parseState.GetInput(3) :?> string in
            let _4 = parseState.GetInput(4) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3483 "src/Compiler/pars.fsy"
                           if _3 <> "/" then reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsUnexpectedOperatorForUnitOfMeasure())
                           if fst _4 = 0 then reportParseErrorAt (rhs parseState 4) (FSComp.SR.parsIllegalDenominatorForMeasureExponent())
                           if (snd _2) || (snd _4) then errorR(Error(FSComp.SR.lexOutsideThirtyTwoBitSigned(), lhs parseState))
                           SynRationalConst.Negate(SynRationalConst.Rational(fst _2, rhs parseState 2, rhs parseState 3, fst _4, rhs parseState 4, lhs parseState), lhs parseState) 
                   )
//# 3483 "src/Compiler/pars.fsy"
                 : 'gentype_rationalConstant));
//# 9865 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3489 "src/Compiler/pars.fsy"
                           if snd _1 then errorR(Error(FSComp.SR.lexOutsideThirtyTwoBitSigned(), lhs parseState))
                           SynRationalConst.Integer(fst _1, lhs parseState) 
                   )
//# 3489 "src/Compiler/pars.fsy"
                 : 'gentype_rationalConstant));
//# 9877 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3493 "src/Compiler/pars.fsy"
                           if snd _2 then errorR(Error(FSComp.SR.lexOutsideThirtyTwoBitSigned(), lhs parseState))
                           SynRationalConst.Negate(SynRationalConst.Integer(fst _2, rhs parseState 2), lhs parseState) 
                   )
//# 3493 "src/Compiler/pars.fsy"
                 : 'gentype_rationalConstant));
//# 9889 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> int32 * bool in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3497 "src/Compiler/pars.fsy"
                                 if snd _1 then errorR(Error(FSComp.SR.lexOutsideThirtyTwoBitSigned(), lhs parseState))
                                 SynRationalConst.Integer(fst _1, lhs parseState) 
                   )
//# 3497 "src/Compiler/pars.fsy"
                 : 'gentype_atomicUnsignedRationalConstant));
//# 9901 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_rationalConstant in
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3501 "src/Compiler/pars.fsy"
                           SynRationalConst.Paren(_2, rhs2 parseState 1 3) 
                   )
//# 3501 "src/Compiler/pars.fsy"
                 : 'gentype_atomicUnsignedRationalConstant));
//# 9913 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicUnsignedRationalConstant in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3504 "src/Compiler/pars.fsy"
                                                          _1 
                   )
//# 3504 "src/Compiler/pars.fsy"
                 : 'gentype_atomicRationalConstant));
//# 9924 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_atomicUnsignedRationalConstant in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3507 "src/Compiler/pars.fsy"
                           SynRationalConst.Negate(_2, lhs parseState) 
                   )
//# 3507 "src/Compiler/pars.fsy"
                 : 'gentype_atomicRationalConstant));
//# 9935 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_rawConstant in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3511 "src/Compiler/pars.fsy"
                           _1, rhs parseState 1 
                   )
//# 3511 "src/Compiler/pars.fsy"
                 : 'gentype_constant));
//# 9946 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_rawConstant in
            let _3 = parseState.GetInput(3) :?> 'gentype_measureTypeArg in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3514 "src/Compiler/pars.fsy"
                           let synMeasure, trivia = _3 
                           let mConstant = rhs parseState 1
                           let m = unionRanges mConstant trivia.GreaterRange
                           SynConst.Measure(_1, rhs parseState 1, synMeasure, trivia), m 
                   )
//# 3514 "src/Compiler/pars.fsy"
                 : 'gentype_constant));
//# 9961 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3521 "src/Compiler/pars.fsy"
                           _1, _1.Range 
                   )
//# 3521 "src/Compiler/pars.fsy"
                 : 'gentype_bindingPattern));
//# 9972 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_simplePatterns in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3525 "src/Compiler/pars.fsy"
                             Some _1 
                   )
//# 3525 "src/Compiler/pars.fsy"
                 : 'gentype_opt_simplePatterns));
//# 9983 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3527 "src/Compiler/pars.fsy"
                           None 
                   )
//# 3527 "src/Compiler/pars.fsy"
                 : 'gentype_opt_simplePatterns));
//# 9993 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_parenPattern in
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3531 "src/Compiler/pars.fsy"
                             SynPat.Paren(_2, rhs2 parseState 1 3) 
                   )
//# 3531 "src/Compiler/pars.fsy"
                 : 'gentype_simplePatterns));
//# 10005 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3534 "src/Compiler/pars.fsy"
                             SynPat.Const(SynConst.Unit, rhs2 parseState 1 2) 
                   )
//# 3534 "src/Compiler/pars.fsy"
                 : 'gentype_simplePatterns));
//# 10016 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3538 "src/Compiler/pars.fsy"
                              
                   )
//# 3538 "src/Compiler/pars.fsy"
                 : 'gentype_barCanBeRightBeforeNull));
//# 10026 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3540 "src/Compiler/pars.fsy"
                              
                   )
//# 3540 "src/Compiler/pars.fsy"
                 : 'gentype_barCanBeRightBeforeNull));
//# 10036 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> 'gentype_constrPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3545 "src/Compiler/pars.fsy"
                             SynPat.As(_1, _3, rhs2 parseState 1 3) 
                   )
//# 3545 "src/Compiler/pars.fsy"
                 : SynPat));
//# 10048 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3548 "src/Compiler/pars.fsy"
                             let mAs = rhs parseState 2
                             let pat2 = SynPat.Wild(mAs.EndRange)
                             SynPat.As(_1, pat2, rhs2 parseState 1 2) 
                   )
//# 3548 "src/Compiler/pars.fsy"
                 : SynPat));
//# 10062 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3553 "src/Compiler/pars.fsy"
                             let mAs = rhs parseState 2
                             reportParseErrorAt mAs (FSComp.SR.parsExpectingPattern ())
                             let pat2 = SynPat.Wild(mAs.EndRange)
                             SynPat.As(_1, pat2, rhs2 parseState 1 2) 
                   )
//# 3553 "src/Compiler/pars.fsy"
                 : SynPat));
//# 10076 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _2 = parseState.GetInput(2) :?> 'gentype_barCanBeRightBeforeNull in
            let _3 = parseState.GetInput(3) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3559 "src/Compiler/pars.fsy"
                             let mBar = rhs parseState 2
                             SynPat.Or(_1, _3, rhs2 parseState 1 3, { BarRange = mBar }) 
                   )
//# 3559 "src/Compiler/pars.fsy"
                 : SynPat));
//# 10090 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3563 "src/Compiler/pars.fsy"
                             let mColonColon = rhs parseState 2
                             SynPat.ListCons(_1, _3, rhs2 parseState 1 3, { ColonColonRange = mColonColon }) 
                   )
//# 3563 "src/Compiler/pars.fsy"
                 : SynPat));
//# 10103 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3567 "src/Compiler/pars.fsy"
                             let mColonColon = rhs parseState 2
                             let pat2 = SynPat.Wild(mColonColon.EndRange)
                             SynPat.ListCons(_1, pat2, rhs2 parseState 1 2, { ColonColonRange = mColonColon }) 
                   )
//# 3567 "src/Compiler/pars.fsy"
                 : SynPat));
//# 10117 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3572 "src/Compiler/pars.fsy"
                             let mColonColon = rhs parseState 2
                             reportParseErrorAt mColonColon (FSComp.SR.parsExpectingPattern ())
                             let pat2 = SynPat.Wild(mColonColon.EndRange)
                             SynPat.ListCons(_1, pat2, rhs2 parseState 1 2, { ColonColonRange = mColonColon }) 
                   )
//# 3572 "src/Compiler/pars.fsy"
                 : SynPat));
//# 10131 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tuplePatternElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3578 "src/Compiler/pars.fsy"
                             let pats, commas = _1
                             let pats, commas = normalizeTuplePat pats commas
                             let m = (rhs parseState 1, pats) ||> unionRangeWithListBy (fun p -> p.Range)
                             SynPat.Tuple(false, List.rev pats, List.rev commas, m) 
                   )
//# 3578 "src/Compiler/pars.fsy"
                 : SynPat));
//# 10145 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_conjPatternElements in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3584 "src/Compiler/pars.fsy"
                             SynPat.Ands(List.rev _1, lhs parseState) 
                   )
//# 3584 "src/Compiler/pars.fsy"
                 : SynPat));
//# 10156 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_constrPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3587 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 3587 "src/Compiler/pars.fsy"
                 : SynPat));
//# 10167 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tuplePatternElements in
            let _3 = parseState.GetInput(3) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3591 "src/Compiler/pars.fsy"
                             let pats, commas = _1
                             _3 :: pats, (rhs parseState 2 :: commas) 
                   )
//# 3591 "src/Compiler/pars.fsy"
                 : 'gentype_tuplePatternElements));
//# 10180 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3595 "src/Compiler/pars.fsy"
                             [_3; _1], [rhs parseState 2] 
                   )
//# 3595 "src/Compiler/pars.fsy"
                 : 'gentype_tuplePatternElements));
//# 10192 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_tuplePatternElements in
            let _3 = parseState.GetInput(3) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3598 "src/Compiler/pars.fsy"
                               let pats, commas = _1
                               let commaRange = rhs parseState 2
                               reportParseErrorAt commaRange (FSComp.SR.parsExpectingPattern ())
                               let pat2 = SynPat.Wild(commaRange.EndRange)
                               pat2 :: pats, (commaRange :: commas) 
                   )
//# 3598 "src/Compiler/pars.fsy"
                 : 'gentype_tuplePatternElements));
//# 10208 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3605 "src/Compiler/pars.fsy"
                             let commaRange = rhs parseState 2
                             reportParseErrorAt commaRange (FSComp.SR.parsExpectingPattern ())
                             let pat2 = SynPat.Wild(commaRange.EndRange)
                             [pat2; _1], [commaRange] 
                   )
//# 3605 "src/Compiler/pars.fsy"
                 : 'gentype_tuplePatternElements));
//# 10223 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3611 "src/Compiler/pars.fsy"
                             let commaRange = rhs parseState 1
                             reportParseErrorAt commaRange (FSComp.SR.parsExpectingPattern ())
                             let pat1 = SynPat.Wild(commaRange.StartRange)
                             [_2; pat1], [commaRange] 
                   )
//# 3611 "src/Compiler/pars.fsy"
                 : 'gentype_tuplePatternElements));
//# 10237 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_ends_coming_soon_or_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3617 "src/Compiler/pars.fsy"
                             let commaRange = rhs parseState 1
                             if not _2 then reportParseErrorAt commaRange (FSComp.SR.parsExpectedPatternAfterToken ())
                             let pat1 = SynPat.Wild(commaRange.StartRange)
                             let pat2 = SynPat.Wild(commaRange.EndRange)
                             [pat2; pat1], [commaRange] 
                   )
//# 3617 "src/Compiler/pars.fsy"
                 : 'gentype_tuplePatternElements));
//# 10252 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_conjPatternElements in
            let _3 = parseState.GetInput(3) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3625 "src/Compiler/pars.fsy"
                            _3 :: _1 
                   )
//# 3625 "src/Compiler/pars.fsy"
                 : 'gentype_conjPatternElements));
//# 10264 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat in
            let _3 = parseState.GetInput(3) :?> SynPat in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3628 "src/Compiler/pars.fsy"
                            _3 :: _1 :: [] 
                   )
//# 3628 "src/Compiler/pars.fsy"
                 : 'gentype_conjPatternElements));
//# 10276 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_namePatPair in
            let _2 = parseState.GetInput(2) :?> 'gentype_opt_seps in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3632 "src/Compiler/pars.fsy"
                            [_1] 
                   )
//# 3632 "src/Compiler/pars.fsy"
                 : 'gentype_namePatPairs));
//# 10288 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_namePatPair in
            let _2 = parseState.GetInput(2) :?> 'gentype_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_namePatPairs in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3635 "src/Compiler/pars.fsy"
                            _1 :: _3 
                   )
//# 3635 "src/Compiler/pars.fsy"
                 : 'gentype_namePatPairs));
//# 10301 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_namePatPair in
            let _2 = parseState.GetInput(2) :?> 'gentype_seps in
            let _3 = parseState.GetInput(3) :?> 'gentype_seps in
            let _4 = parseState.GetInput(4) :?> 'gentype_namePatPairs in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3638 "src/Compiler/pars.fsy"
                             reportParseErrorAt (rhs parseState 3) (FSComp.SR.parsExpectingPattern ())
                             (_1 :: _4) 
                   )
//# 3638 "src/Compiler/pars.fsy"
                 : 'gentype_namePatPairs));
//# 10316 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_parenPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3643 "src/Compiler/pars.fsy"
                            let mEquals = rhs parseState 2
                            _1, Some mEquals, _3 
                   )
//# 3643 "src/Compiler/pars.fsy"
                 : 'gentype_namePatPair));
//# 10329 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _3 = parseState.GetInput(3) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3647 "src/Compiler/pars.fsy"
                            let mEquals = rhs parseState 2
                            _1, Some mEquals, patFromParseError (SynPat.Wild mEquals.EndRange) 
                   )
//# 3647 "src/Compiler/pars.fsy"
                 : 'gentype_namePatPair));
//# 10342 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> Ident in
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3651 "src/Compiler/pars.fsy"
                            _1, None, patFromParseError (SynPat.Wild _1.idRange.EndRange) 
                   )
//# 3651 "src/Compiler/pars.fsy"
                 : 'gentype_namePatPair));
//# 10354 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _2 = parseState.GetInput(2) :?> 'gentype_explicitValTyparDecls in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3655 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             SynPat.LongIdent(lid, None, Some _2, SynArgPats.Pats [], vis, lhs parseState) 
                   )
//# 3655 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10367 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _2 = parseState.GetInput(2) :?> 'gentype_explicitValTyparDecls in
            let _3 = parseState.GetInput(3) :?> SynArgPats * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3659 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             let args, argsM = _3
                             let m = unionRanges (rhs2 parseState 1 2) argsM
                             SynPat.LongIdent(lid, None, Some _2, args, vis, m) 
                   )
//# 3659 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10383 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _2 = parseState.GetInput(2) :?> 'gentype_explicitValTyparDecls in
            let _4 = parseState.GetInput(4) :?> SynArgPats * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3665 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             let args, argsM = _4
                             let m = unionRanges (rhs2 parseState 1 2) argsM
                             SynPat.LongIdent(lid, None, Some _2, args, vis, m) 
                   )
//# 3665 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10399 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _2 = parseState.GetInput(2) :?> 'gentype_explicitValTyparDecls in
            let _4 = parseState.GetInput(4) :?> SynArgPats * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3671 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             let args, argsM = _4
                             let m = unionRanges (rhs2 parseState 1 2) argsM
                             SynPat.LongIdent(lid, None, Some _2, args, vis, m) 
                   )
//# 3671 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10415 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _2 = parseState.GetInput(2) :?> SynArgPats * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3677 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             let args, argsM = _2
                             let m = unionRanges (rhs parseState 1) argsM
                             SynPat.LongIdent(lid, None, None, args, vis, m) 
                   )
//# 3677 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10430 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _3 = parseState.GetInput(3) :?> SynArgPats * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3683 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             let args, argsM = _3
                             let m = unionRanges (rhs parseState 1) argsM
                             SynPat.LongIdent(lid, None, None, args, vis, m) 
                   )
//# 3683 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10445 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPatternLongIdent in
            let _3 = parseState.GetInput(3) :?> SynArgPats * range in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3689 "src/Compiler/pars.fsy"
                             let vis, lid = _1
                             let args, argsM = _3
                             let m = unionRanges (rhs parseState 1) argsM
                             SynPat.LongIdent(lid, None, None, args, vis, m) 
                   )
//# 3689 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10460 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> SynType in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3695 "src/Compiler/pars.fsy"
                             let m = unionRanges (rhs parseState 1) _2.Range
                             SynPat.IsInst(_2, m) 
                   )
//# 3695 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10472 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_recover in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3699 "src/Compiler/pars.fsy"
                             let mColon = rhs parseState 1
                             if not _2 then
                                 reportParseErrorAt mColon (FSComp.SR.parsExpectingPattern ())
                             let ty = SynType.FromParseError(mColon.EndRange)
                             SynPat.IsInst(ty, mColon) 
                   )
//# 3699 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10487 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3706 "src/Compiler/pars.fsy"
                             let mColon = rhs parseState 1
                             let ty = SynType.FromParseError(mColon.EndRange)
                             reportParseErrorAt mColon (FSComp.SR.parsExpectingType ())
                             SynPat.IsInst(ty, mColon) 
                   )
//# 3706 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10500 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> 'gentype_atomicPattern in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3712 "src/Compiler/pars.fsy"
                             _1 
                   )
//# 3712 "src/Compiler/pars.fsy"
                 : 'gentype_constrPattern));
//# 10511 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _2 = parseState.GetInput(2) :?> 'gentype_namePatPairs in
            let _3 = parseState.GetInput(3) :?> 'gentype_rparen in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3716 "src/Compiler/pars.fsy"
                             let mParen = rhs2 parseState 1 3
                             let trivia = { ParenRange = mParen }
                             SynArgPats.NamePatPairs(_2, rhs parseState 2, trivia), mParen 
                   )
//# 3716 "src/Compiler/pars.fsy"
                 : SynArgPats * range));
//# 10525 "pars.fs"
        (fun (parseState : Internal.Utilities.Text.Parsing.IParseState) ->
            let _1 = parseState.GetInput(1) :?> SynPat list in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
//# 3721 "src/Compiler/pars.fsy"
                             let mParsed = rhs parseState 1
                             let mAll = (mParsed.StartRange, _1) ||> unionRangeWithListBy (fun p -> p.Range)
                             SynArgPats.Pats _1, mAll 
                   )
//# 3721 "src/Compiler/pars.fsy"
                 : SynArgPats * ra