/* Steve, the jobserver
 * (c) 2025 Michał Górny
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <climits>

struct fd_guard {
	int fd;
	~fd_guard() { close(fd); }
};

static bool arg_to_long(const char *optarg, long *out) {
	char *endptr;
	errno = 0;
	*out = strtol(optarg, &endptr, 10);
	return (
		!*endptr && errno == 0 && *out >= 0 && *out < INT_MAX
	);
}

static bool arg_to_double(const char *optarg, double *out) {
	char *endptr;
	errno = 0;
	*out = strtod(optarg, &endptr);
	return (
		!*endptr && errno == 0
	);
}
