// generated by diplomat-tool
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { Locale } from "./Locale"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * A set of "exemplar characters" for a given locale.
 *
 * See the [Rust documentation for `locale`](https://docs.rs/icu/latest/icu/locale/index.html) for more information.
 *
 * See the [Rust documentation for `ExemplarCharacters`](https://docs.rs/icu/latest/icu/locale/exemplar_chars/struct.ExemplarCharacters.html) for more information.
 *
 * See the [Rust documentation for `ExemplarCharactersBorrowed`](https://docs.rs/icu/latest/icu/locale/exemplar_chars/struct.ExemplarCharactersBorrowed.html) for more information.
 */


export class ExemplarCharacters {
    get ffiValue(): pointer;


    /**
     * Checks whether the string is in the set.
     *
     * See the [Rust documentation for `contains_str`](https://docs.rs/icu/latest/icu/collections/codepointinvliststringlist/struct.CodePointInversionListAndStringList.html#method.contains_str) for more information.
     */
    containsStr(s: string): boolean;

    /**
     * Checks whether the code point is in the set.
     *
     * See the [Rust documentation for `contains`](https://docs.rs/icu/latest/icu/collections/codepointinvliststringlist/struct.CodePointInversionListAndStringList.html#method.contains) for more information.
     */
    contains(cp: codepoint): boolean;

    /**
     * Create an [`ExemplarCharacters`] for the "main" set of exemplar characters for a given locale, using compiled data.
     *
     * See the [Rust documentation for `try_new_main`](https://docs.rs/icu/latest/icu/locale/exemplar_chars/struct.ExemplarCharacters.html#method.try_new_main) for more information.
     */
    static createMain(locale: Locale): ExemplarCharacters;

    /**
     * Create an [`ExemplarCharacters`] for the "main" set of exemplar characters for a given locale, using a particular data source
     *
     * See the [Rust documentation for `try_new_main`](https://docs.rs/icu/latest/icu/locale/exemplar_chars/struct.ExemplarCharacters.html#method.try_new_main) for more information.
     */
    static createMainWithProvider(provider: DataProvider, locale: Locale): ExemplarCharacters;

    /**
     * Create an [`ExemplarCharacters`] for the "auxiliary" set of exemplar characters for a given locale, using compiled data.
     *
     * See the [Rust documentation for `try_new_auxiliary`](https://docs.rs/icu/latest/icu/locale/exemplar_chars/struct.ExemplarCharacters.html#method.try_new_auxiliary) for more information.
     */
    static createAuxiliary(locale: Locale): ExemplarCharacters;

    /**
     * Create an [`ExemplarCharacters`] for the "auxiliary" set of exemplar characters for a given locale, using compiled data.
     *
     * See the [Rust documentation for `try_new_auxiliary`](https://docs.rs/icu/latest/icu/locale/exemplar_chars/struct.ExemplarCharacters.html#method.try_new_auxiliary) for more information.
     */
    static createAuxiliaryWithProvider(provider: DataProvider, locale: Locale): ExemplarCharacters;

    /**
     * Create an [`ExemplarCharacters`] for the "punctuation" set of exemplar characters for a given locale, using compiled data.
     *
     * See the [Rust documentation for `try_new_punctuation`](https://docs.rs/icu/latest/icu/locale/exemplar_chars/struct.ExemplarCharacters.html#method.try_new_punctuation) for more information.
     */
    static createPunctuation(locale: Locale): ExemplarCharacters;

    /**
     * Create an [`ExemplarCharacters`] for the "punctuation" set of exemplar characters for a given locale, using compiled data.
     *
     * See the [Rust documentation for `try_new_punctuation`](https://docs.rs/icu/latest/icu/locale/exemplar_chars/struct.ExemplarCharacters.html#method.try_new_punctuation) for more information.
     */
    static createPunctuationWithProvider(provider: DataProvider, locale: Locale): ExemplarCharacters;

    /**
     * Create an [`ExemplarCharacters`] for the "numbers" set of exemplar characters for a given locale, using compiled data.
     *
     * See the [Rust documentation for `try_new_numbers`](https://docs.rs/icu/latest/icu/locale/exemplar_chars/struct.ExemplarCharacters.html#method.try_new_numbers) for more information.
     */
    static createNumbers(locale: Locale): ExemplarCharacters;

    /**
     * Create an [`ExemplarCharacters`] for the "numbers" set of exemplar characters for a given locale, using compiled data.
     *
     * See the [Rust documentation for `try_new_numbers`](https://docs.rs/icu/latest/icu/locale/exemplar_chars/struct.ExemplarCharacters.html#method.try_new_numbers) for more information.
     */
    static createNumbersWithProvider(provider: DataProvider, locale: Locale): ExemplarCharacters;

    /**
     * Create an [`ExemplarCharacters`] for the "index" set of exemplar characters for a given locale, using compiled data.
     *
     * See the [Rust documentation for `try_new_index`](https://docs.rs/icu/latest/icu/locale/exemplar_chars/struct.ExemplarCharacters.html#method.try_new_index) for more information.
     */
    static createIndex(locale: Locale): ExemplarCharacters;

    /**
     * Create an [`ExemplarCharacters`] for the "index" set of exemplar characters for a given locale, using compiled data.
     *
     * See the [Rust documentation for `try_new_index`](https://docs.rs/icu/latest/icu/locale/exemplar_chars/struct.ExemplarCharacters.html#method.try_new_index) for more information.
     */
    static createIndexWithProvider(provider: DataProvider, locale: Locale): ExemplarCharacters;
}