// generated by diplomat-tool
import { Locale } from "./Locale.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * An iterator over the locale under fallback.
 *
 * See the [Rust documentation for `LocaleFallbackIterator`](https://docs.rs/icu/latest/icu/locale/fallback/struct.LocaleFallbackIterator.html) for more information.
 */
const LocaleFallbackIterator_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_LocaleFallbackIterator_destroy_mv1(ptr);
});

export class LocaleFallbackIterator {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];
    #aEdge = [];

    #internalConstructor(symbol, ptr, selfEdge, aEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("LocaleFallbackIterator is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#aEdge = aEdge;
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            LocaleFallbackIterator_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    #iteratorNext() {

        const result = wasm.icu4x_LocaleFallbackIterator_next_mv1(this.ffiValue);

        try {
            return result === 0 ? null : new Locale(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    next(){
        const out = this.#iteratorNext();

        return {
            value: out,
            done: out === null,
        };
    }

    constructor(symbol, ptr, selfEdge, aEdge) {
        return this.#internalConstructor(...arguments)
    }
}