// generated by diplomat-tool
import { BidiInfo } from "./BidiInfo.mjs"
import { DataError } from "./DataError.mjs"
import { DataProvider } from "./DataProvider.mjs"
import { ReorderedIndexMap } from "./ReorderedIndexMap.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * An ICU4X Bidi object, containing loaded bidi data
 *
 * See the [Rust documentation for `BidiClass`](https://docs.rs/icu/latest/icu/properties/props/struct.BidiClass.html) for more information.
 */
const Bidi_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_Bidi_destroy_mv1(ptr);
});

export class Bidi {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("Bidi is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            Bidi_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Creates a new [`Bidi`] from locale data using compiled data.
     */
    #defaultConstructor() {

        const result = wasm.icu4x_Bidi_create_mv1();

        try {
            return new Bidi(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Creates a new [`Bidi`] from locale data, and a particular data source.
     */
    static createWithProvider(provider) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_Bidi_create_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DataError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DataError: ' + cause.value, { cause });
            }
            return new Bidi(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Use the data loaded in this object to process a string and calculate bidi information
     *
     * Takes in a Level for the default level, if it is an invalid value it will default to LTR
     *
     * See the [Rust documentation for `new_with_data_source`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.BidiInfo.html#method.new_with_data_source) for more information.
     */
    forText(text, defaultLevel) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        let functionGarbageCollectorGrip = new diplomatRuntime.GarbageCollectorGrip();
        const textSlice = diplomatRuntime.DiplomatBuf.str8(wasm, text);
        // This lifetime edge depends on lifetimes 'text
        let textEdges = [textSlice];


        const result = wasm.icu4x_Bidi_for_text_valid_utf8_mv1(this.ffiValue, ...textSlice.splat(), ...diplomatRuntime.optionToArgsForCalling(defaultLevel, 1, 1, (arrayBuffer, offset, jsValue) => [diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue, Uint8Array)]));

        try {
            return new BidiInfo(diplomatRuntime.internalConstructor, result, [], textEdges);
        }

        finally {
            functionCleanupArena.free();

            functionGarbageCollectorGrip.releaseToGarbageCollector();

        }
    }

    /**
     * Utility function for producing reorderings given a list of levels
     *
     * Produces a map saying which visual index maps to which source index.
     *
     * The levels array must not have values greater than 126 (this is the
     * Bidi maximum explicit depth plus one).
     * Failure to follow this invariant may lead to incorrect results,
     * but is still safe.
     *
     * See the [Rust documentation for `reorder_visual`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.BidiInfo.html#method.reorder_visual) for more information.
     */
    reorderVisual(levels) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const levelsSlice = diplomatRuntime.DiplomatBuf.slice(wasm, levels, "u8");

        const result = wasm.icu4x_Bidi_reorder_visual_mv1(this.ffiValue, ...levelsSlice.splat());

        try {
            return new ReorderedIndexMap(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
            functionCleanupArena.free();

        }
    }

    /**
     * Check if a Level returned by level_at is an RTL level.
     *
     * Invalid levels (numbers greater than 125) will be assumed LTR
     *
     * See the [Rust documentation for `is_rtl`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Level.html#method.is_rtl) for more information.
     */
    static levelIsRtl(level) {

        const result = wasm.icu4x_Bidi_level_is_rtl_mv1(level);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Check if a Level returned by level_at is an LTR level.
     *
     * Invalid levels (numbers greater than 125) will be assumed LTR
     *
     * See the [Rust documentation for `is_ltr`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Level.html#method.is_ltr) for more information.
     */
    static levelIsLtr(level) {

        const result = wasm.icu4x_Bidi_level_is_ltr_mv1(level);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Get a basic RTL Level value
     *
     * See the [Rust documentation for `rtl`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Level.html#method.rtl) for more information.
     */
    static levelRtl() {

        const result = wasm.icu4x_Bidi_level_rtl_mv1();

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Get a simple LTR Level value
     *
     * See the [Rust documentation for `ltr`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Level.html#method.ltr) for more information.
     */
    static levelLtr() {

        const result = wasm.icu4x_Bidi_level_ltr_mv1();

        try {
            return result;
        }

        finally {
        }
    }

    constructor() {
        if (arguments[0] === diplomatRuntime.exposeConstructor) {
            return this.#internalConstructor(...Array.prototype.slice.call(arguments, 1));
        } else if (arguments[0] === diplomatRuntime.internalConstructor) {
            return this.#internalConstructor(...arguments);
        } else {
            return this.#defaultConstructor(...arguments);
        }
    }
}