// generated by diplomat-tool
import { Calendar } from "./Calendar.mjs"
import { CalendarError } from "./CalendarError.mjs"
import { Date } from "./Date.mjs"
import { IsoWeekOfYear } from "./IsoWeekOfYear.mjs"
import { Rfc9557ParseError } from "./Rfc9557ParseError.mjs"
import { Weekday } from "./Weekday.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * An ICU4X Date object capable of containing a ISO-8601 date
 *
 * See the [Rust documentation for `Date`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html) for more information.
 */
const IsoDate_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_IsoDate_destroy_mv1(ptr);
});

export class IsoDate {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("IsoDate is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            IsoDate_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Creates a new [`IsoDate`] from the specified date.
     *
     * See the [Rust documentation for `try_new_iso`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.try_new_iso) for more information.
     */
    #defaultConstructor(year, month, day) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_IsoDate_create_mv1(diplomatReceive.buffer, year, month, day);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new CalendarError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('CalendarError: ' + cause.value, { cause });
            }
            return new IsoDate(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a new [`IsoDate`] from the given Rata Die
     *
     * See the [Rust documentation for `from_rata_die`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.from_rata_die) for more information.
     */
    static fromRataDie(rd) {

        const result = wasm.icu4x_IsoDate_from_rata_die_mv1(rd);

        try {
            return new IsoDate(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Creates a new [`IsoDate`] from an IXDTF string.
     *
     * See the [Rust documentation for `try_from_str`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.try_from_str) for more information.
     */
    static fromString(v) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const vSlice = diplomatRuntime.DiplomatBuf.str8(wasm, v);
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_IsoDate_from_string_mv1(diplomatReceive.buffer, ...vSlice.splat());

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new Rfc9557ParseError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('Rfc9557ParseError: ' + cause.value, { cause });
            }
            return new IsoDate(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            functionCleanupArena.free();

            diplomatReceive.free();
        }
    }

    /**
     * Convert this date to one in a different calendar
     *
     * See the [Rust documentation for `to_calendar`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.to_calendar) for more information.
     */
    toCalendar(calendar) {

        const result = wasm.icu4x_IsoDate_to_calendar_mv1(this.ffiValue, calendar.ffiValue);

        try {
            return new Date(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * See the [Rust documentation for `to_any`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.to_any) for more information.
     */
    toAny() {

        const result = wasm.icu4x_IsoDate_to_any_mv1(this.ffiValue);

        try {
            return new Date(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Returns this date's Rata Die
     *
     * See the [Rust documentation for `to_rata_die`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.to_rata_die) for more information.
     */
    get rataDie() {

        const result = wasm.icu4x_IsoDate_to_rata_die_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Returns the 1-indexed day in the year for this date
     *
     * See the [Rust documentation for `day_of_year`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.day_of_year) for more information.
     */
    get dayOfYear() {

        const result = wasm.icu4x_IsoDate_day_of_year_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Returns the 1-indexed day in the month for this date
     *
     * See the [Rust documentation for `day_of_month`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.day_of_month) for more information.
     */
    get dayOfMonth() {

        const result = wasm.icu4x_IsoDate_day_of_month_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Returns the day in the week for this day
     *
     * See the [Rust documentation for `day_of_week`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.day_of_week) for more information.
     */
    get dayOfWeek() {

        const result = wasm.icu4x_IsoDate_day_of_week_mv1(this.ffiValue);

        try {
            return new Weekday(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * Returns the week number in this year, using week data
     *
     * See the [Rust documentation for `week_of_year`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.week_of_year) for more information.
     */
    weekOfYear() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 8, 4, false);


        const result = wasm.icu4x_IsoDate_week_of_year_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            return IsoWeekOfYear._fromFFI(diplomatRuntime.internalConstructor, diplomatReceive.buffer);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Returns 1-indexed number of the month of this date in its year
     *
     * See the [Rust documentation for `ordinal`](https://docs.rs/icu/latest/icu/calendar/types/struct.MonthInfo.html#structfield.ordinal) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.month)
     */
    get month() {

        const result = wasm.icu4x_IsoDate_month_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Returns the year number in the current era for this date
     *
     * For calendars without an era, returns the extended year
     *
     * See the [Rust documentation for `year`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.year) for more information.
     */
    get year() {

        const result = wasm.icu4x_IsoDate_year_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Returns if the year is a leap year for this date
     *
     * See the [Rust documentation for `is_in_leap_year`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.is_in_leap_year) for more information.
     */
    get isInLeapYear() {

        const result = wasm.icu4x_IsoDate_is_in_leap_year_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Returns the number of months in the year represented by this date
     *
     * See the [Rust documentation for `months_in_year`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.months_in_year) for more information.
     */
    get monthsInYear() {

        const result = wasm.icu4x_IsoDate_months_in_year_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Returns the number of days in the month represented by this date
     *
     * See the [Rust documentation for `days_in_month`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.days_in_month) for more information.
     */
    get daysInMonth() {

        const result = wasm.icu4x_IsoDate_days_in_month_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Returns the number of days in the year represented by this date
     *
     * See the [Rust documentation for `days_in_year`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.days_in_year) for more information.
     */
    get daysInYear() {

        const result = wasm.icu4x_IsoDate_days_in_year_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    constructor(year, month, day) {
        if (arguments[0] === diplomatRuntime.exposeConstructor) {
            return this.#internalConstructor(...Array.prototype.slice.call(arguments, 1));
        } else if (arguments[0] === diplomatRuntime.internalConstructor) {
            return this.#internalConstructor(...arguments);
        } else {
            return this.#defaultConstructor(...arguments);
        }
    }
}