// generated by diplomat-tool
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `WordBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.WordBreak.html) for more information.
 */


export class WordBreak {
    #value = undefined;

    static #values = new Map([
        ["Other", 0],
        ["ALetter", 1],
        ["Format", 2],
        ["Katakana", 3],
        ["MidLetter", 4],
        ["MidNum", 5],
        ["Numeric", 6],
        ["ExtendNumLet", 7],
        ["Cr", 8],
        ["Extend", 9],
        ["Lf", 10],
        ["MidNumLet", 11],
        ["Newline", 12],
        ["RegionalIndicator", 13],
        ["HebrewLetter", 14],
        ["SingleQuote", 15],
        ["DoubleQuote", 16],
        ["EBase", 17],
        ["EBaseGaz", 18],
        ["EModifier", 19],
        ["GlueAfterZwj", 20],
        ["Zwj", 21],
        ["WSegSpace", 22]
    ]);

    static getAllEntries() {
        return WordBreak.#values.entries();
    }

    #internalConstructor(value) {
        if (arguments.length > 1 && arguments[0] === diplomatRuntime.internalConstructor) {
            // We pass in two internalConstructor arguments to create *new*
            // instances of this type, otherwise the enums are treated as singletons.
            if (arguments[1] === diplomatRuntime.internalConstructor ) {
                this.#value = arguments[2];
                return this;
            }
            return WordBreak.#objectValues[arguments[1]];
        }

        if (value instanceof WordBreak) {
            return value;
        }

        let intVal = WordBreak.#values.get(value);

        // Nullish check, checks for null or undefined
        if (intVal != null) {
            return WordBreak.#objectValues[intVal];
        }

        throw TypeError(value + " is not a WordBreak and does not correspond to any of its enumerator values.");
    }

    static fromValue(value) {
        return new WordBreak(value);
    }

    get value(){
        return [...WordBreak.#values.keys()][this.#value];
    }

    get ffiValue(){
        return this.#value;
    }
    static #objectValues = [
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 0),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 1),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 2),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 3),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 4),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 5),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 6),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 7),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 8),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 9),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 10),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 11),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 12),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 13),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 14),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 15),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 16),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 17),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 18),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 19),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 20),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 21),
        new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 22),
    ];

    static Other = WordBreak.#objectValues[0];
    static ALetter = WordBreak.#objectValues[1];
    static Format = WordBreak.#objectValues[2];
    static Katakana = WordBreak.#objectValues[3];
    static MidLetter = WordBreak.#objectValues[4];
    static MidNum = WordBreak.#objectValues[5];
    static Numeric = WordBreak.#objectValues[6];
    static ExtendNumLet = WordBreak.#objectValues[7];
    static Cr = WordBreak.#objectValues[8];
    static Extend = WordBreak.#objectValues[9];
    static Lf = WordBreak.#objectValues[10];
    static MidNumLet = WordBreak.#objectValues[11];
    static Newline = WordBreak.#objectValues[12];
    static RegionalIndicator = WordBreak.#objectValues[13];
    static HebrewLetter = WordBreak.#objectValues[14];
    static SingleQuote = WordBreak.#objectValues[15];
    static DoubleQuote = WordBreak.#objectValues[16];
    static EBase = WordBreak.#objectValues[17];
    static EBaseGaz = WordBreak.#objectValues[18];
    static EModifier = WordBreak.#objectValues[19];
    static GlueAfterZwj = WordBreak.#objectValues[20];
    static Zwj = WordBreak.#objectValues[21];
    static WSegSpace = WordBreak.#objectValues[22];


    /**
     * See the [Rust documentation for `for_char`](https://docs.rs/icu/latest/icu/properties/props/trait.EnumeratedProperty.html#tymethod.for_char) for more information.
     */
    static forChar(ch) {

        const result = wasm.icu4x_WordBreak_for_char_mv1(ch);

        try {
            return new WordBreak(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * Get the "long" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesLongBorrowed.html#method.get) for more information.
     */
    longName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_WordBreak_long_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Get the "short" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesShortBorrowed.html#method.get) for more information.
     */
    shortName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_WordBreak_short_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Convert to an integer value usable with ICU4C and CodePointMapData
     *
     * See the [Rust documentation for `to_icu4c_value`](https://docs.rs/icu/latest/icu/properties/props/struct.WordBreak.html#method.to_icu4c_value) for more information.
     */
    toIntegerValue() {

        const result = wasm.icu4x_WordBreak_to_integer_value_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Convert from an integer value from ICU4C or CodePointMapData
     *
     * See the [Rust documentation for `from_icu4c_value`](https://docs.rs/icu/latest/icu/properties/props/struct.WordBreak.html#method.from_icu4c_value) for more information.
     */
    static fromIntegerValue(other) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_WordBreak_from_integer_value_mv1(diplomatReceive.buffer, other);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new WordBreak(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
        }

        finally {
            diplomatReceive.free();
        }
    }

    constructor(value) {
        return this.#internalConstructor(...arguments)
    }
}