/* do not edit automatically generated by mc from NameKey.  */
/* NameKey.def provides a dynamic binary tree name to key.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_NameKey_H)
#   define _NameKey_H

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"

#   if defined (_NameKey_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#   define NameKey_NulName 0
typedef unsigned int NameKey_Name;


/*
   MakeKey - returns the Key of the symbol, a. If a is not in the
             name table then it is added, otherwise the Key of a is returned
             directly. Note that the name table has no scope - it merely
             presents a more convienient way of expressing strings. By a Key.
             These keys last for the duration of compilation.
*/

EXTERN NameKey_Name NameKey_MakeKey (const char *a_, unsigned int _a_high);

/*
   makekey - returns the Key of the symbol, a. If a is not in the
             name table then it is added, otherwise the Key of a is returned
             directly. Note that the name table has no scope - it merely
             presents a more convienient way of expressing strings. By a Key.
             These keys last for the duration of compilation.
*/

EXTERN NameKey_Name NameKey_makekey (void * a);

/*
   GetKey - returns the name, a, of the key, key.
*/

EXTERN void NameKey_GetKey (NameKey_Name key, char *a, unsigned int _a_high);

/*
   LengthKey - returns the StrLen of a Key.
*/

EXTERN unsigned int NameKey_LengthKey (NameKey_Name Key);

/*
   IsKey - returns TRUE if string, a, is currently a key.
*/

EXTERN bool NameKey_IsKey (const char *a_, unsigned int _a_high);

/*
   WriteKey - Display the symbol represented by Key.
*/

EXTERN void NameKey_WriteKey (NameKey_Name key);

/*
   IsSameExcludingCase - returns TRUE if key1 and key2 are
                         the same. It is case insensitive.
*/

EXTERN bool NameKey_IsSameExcludingCase (NameKey_Name key1, NameKey_Name key2);

/*
   KeyToCharStar - returns the C char * string equivalent for, key.
*/

EXTERN void * NameKey_KeyToCharStar (NameKey_Name key);

/*
   CharKey - returns the key[i] character.
*/

EXTERN char NameKey_CharKey (NameKey_Name key, unsigned int i);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
