; dbd-test.scm - test guil-dbi by greg
; Copyright (C) 2004, 2005 Free Software Foundation, Inc.
; Written by Maurizio Boriani <baux@member.fsf.org>
;
; This file is part of the guile-dbi.
; 
; The guile-dbi is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
; 
; The guile-dbi is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
;
;                                     
; Process this file with autoconf to produce a configure script.


(define dbh #t)


(greg-testcase "create a guile dbi handler object" #t
	       (lambda()
		 (set! dbh (dbi-open "test" "test"))
		 (if (eq? (car (dbi-get_status dbh)) 0)
		     #t
		     #f)))

(greg-testcase "guile dbi query" #t
	       (lambda()
		 (dbi-query dbh "select * from test;")
		 (if (eq? (car (dbi-get_status dbh)) 0)
		     #t
		     #f)))

(greg-testcase "guile dbi get row" #t
	       (lambda()
		 (let ((row (dbi-get_row dbh)))
		   (if (eq? (car (dbi-get_status dbh)) 0)
		       #t
		       #f))))

(greg-testcase "guile dbi close connection" #t
	       (lambda()
		 (dbi-close dbh)
		 (if (eq? (car (dbi-get_status dbh)) 0)
		     #t
		     #f)))

(greg-testcase "reopen a closed connection" #t
	       (lambda()
		 (set! dbh (dbi-open "test" "test"))
		 (if (eq? (car (dbi-get_status dbh)) 0)
		     #t
		     #f)))

(greg-testcase "guile dbi query" #t
	       (lambda()
		 (dbi-query dbh "select * from test;")
		 (if (eq? (car (dbi-get_status dbh)) 0)
		     #t
		     #f)))

(greg-testcase "guile dbi close a re-opened connection" #t
	       (lambda()
		 (dbi-close dbh)
		 (if (eq? (car (dbi-get_status dbh)) 0)
		     #t
		     #f)))

(greg-testcase "guile dbi query using closed connection" #f
	       (lambda()
		 (dbi-query dbh "select * from test;")
		 (if (eq? (car (dbi-get_status dbh)) 0)
		     #t
		     #f)))

(greg-testcase "guile dbi get row using closed connetcion" #f
	       (lambda()
		 (let ((row (dbi-get_row dbh)))
		   (if (eq? (car (dbi-get_status dbh)) 0)
		       #t
		       #f))))

(greg-testcase "close a closed connection" #f
	       (lambda()
		 (dbi-close dbh)
		 (if (eq? (car (dbi-get_status dbh)) 0)
		     #t
		     #f)))
