/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchedulerProgram;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSParameter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class OracleSchedulerProgramArgument
implements DBSParameter {
    private final OracleSchedulerProgram program;
    private String name;
    private int position;
    private final String type;
    private String metadataAttribute;
    private String defaultValue;
    private String defaultAnyDataValue;
    private String outArgument;

    public OracleSchedulerProgramArgument(OracleSchedulerProgram program, ResultSet dbResult) {
        this.program = program;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ARGUMENT_NAME");
        this.position = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ARGUMENT_POSITION");
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ARGUMENT_TYPE");
        this.metadataAttribute = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"METADATA_ATTRIBUTE");
        this.defaultValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFAULT_VALUE");
        this.defaultAnyDataValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFAULT_ANYDATA_VALUE");
        this.outArgument = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OUT_ARGUMENT");
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return this.program.getDataSource();
    }

    public OracleSchedulerProgram getParentObject() {
        return this.program;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, order=10)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=11)
    public int getPosition() {
        return this.position;
    }

    @Property(viewable=true, order=12)
    public String getType() {
        return this.type;
    }

    @Property(viewable=true, order=13)
    public String getMetadataAttribute() {
        return this.metadataAttribute;
    }

    @Property(viewable=true, order=14)
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Property(viewable=true, order=15)
    public String getDefaultAnyDataValue() {
        return this.defaultAnyDataValue;
    }

    @Property(viewable=true, order=16)
    public String getOutArgument() {
        return this.outArgument;
    }

    @NotNull
    public DBSTypedObject getParameterType() {
        return this.getDataSource().getLocalDataType(this.type);
    }
}

