/* automatically generated by rust-bindgen 0.70.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const _STDINT_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __TIMESIZE: u32 = 64;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_60559_BFP__: u32 = 201404;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_IEC_60559_COMPLEX__: u32 = 201404;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 36;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __LDOUBLE_REDIRECTS_TO_FLOAT128_ABI: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __KERNEL_OLD_TIMEVAL_MATCHES_TIMEVAL64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const BIOS_ATOM_PREFIX: &[u8; 9] = b"ATOMBIOS\0";
pub const BIOS_VERSION_PREFIX: &[u8; 15] = b"ATOMBIOSBK-AMD\0";
pub const BIOS_STRING_LENGTH: u32 = 43;
pub const SMU13_0_0_DRIVER_IF_VERSION: u32 = 61;
pub const PPTABLE_VERSION: u32 = 43;
pub const NUM_GFXCLK_DPM_LEVELS: u32 = 16;
pub const NUM_SOCCLK_DPM_LEVELS: u32 = 8;
pub const NUM_MP0CLK_DPM_LEVELS: u32 = 2;
pub const NUM_DCLK_DPM_LEVELS: u32 = 8;
pub const NUM_VCLK_DPM_LEVELS: u32 = 8;
pub const NUM_DISPCLK_DPM_LEVELS: u32 = 8;
pub const NUM_DPPCLK_DPM_LEVELS: u32 = 8;
pub const NUM_DPREFCLK_DPM_LEVELS: u32 = 8;
pub const NUM_DCFCLK_DPM_LEVELS: u32 = 8;
pub const NUM_DTBCLK_DPM_LEVELS: u32 = 8;
pub const NUM_UCLK_DPM_LEVELS: u32 = 4;
pub const NUM_LINK_LEVELS: u32 = 3;
pub const NUM_FCLK_DPM_LEVELS: u32 = 8;
pub const NUM_OD_FAN_MAX_POINTS: u32 = 6;
pub const FEATURE_FW_DATA_READ_BIT: u32 = 0;
pub const FEATURE_DPM_GFXCLK_BIT: u32 = 1;
pub const FEATURE_DPM_GFX_POWER_OPTIMIZER_BIT: u32 = 2;
pub const FEATURE_DPM_UCLK_BIT: u32 = 3;
pub const FEATURE_DPM_FCLK_BIT: u32 = 4;
pub const FEATURE_DPM_SOCCLK_BIT: u32 = 5;
pub const FEATURE_DPM_MP0CLK_BIT: u32 = 6;
pub const FEATURE_DPM_LINK_BIT: u32 = 7;
pub const FEATURE_DPM_DCN_BIT: u32 = 8;
pub const FEATURE_VMEMP_SCALING_BIT: u32 = 9;
pub const FEATURE_VDDIO_MEM_SCALING_BIT: u32 = 10;
pub const FEATURE_DS_GFXCLK_BIT: u32 = 11;
pub const FEATURE_DS_SOCCLK_BIT: u32 = 12;
pub const FEATURE_DS_FCLK_BIT: u32 = 13;
pub const FEATURE_DS_LCLK_BIT: u32 = 14;
pub const FEATURE_DS_DCFCLK_BIT: u32 = 15;
pub const FEATURE_DS_UCLK_BIT: u32 = 16;
pub const FEATURE_GFX_ULV_BIT: u32 = 17;
pub const FEATURE_FW_DSTATE_BIT: u32 = 18;
pub const FEATURE_GFXOFF_BIT: u32 = 19;
pub const FEATURE_BACO_BIT: u32 = 20;
pub const FEATURE_MM_DPM_BIT: u32 = 21;
pub const FEATURE_SOC_MPCLK_DS_BIT: u32 = 22;
pub const FEATURE_BACO_MPCLK_DS_BIT: u32 = 23;
pub const FEATURE_THROTTLERS_BIT: u32 = 24;
pub const FEATURE_SMARTSHIFT_BIT: u32 = 25;
pub const FEATURE_GTHR_BIT: u32 = 26;
pub const FEATURE_ACDC_BIT: u32 = 27;
pub const FEATURE_VR0HOT_BIT: u32 = 28;
pub const FEATURE_FW_CTF_BIT: u32 = 29;
pub const FEATURE_FAN_CONTROL_BIT: u32 = 30;
pub const FEATURE_GFX_DCS_BIT: u32 = 31;
pub const FEATURE_GFX_READ_MARGIN_BIT: u32 = 32;
pub const FEATURE_LED_DISPLAY_BIT: u32 = 33;
pub const FEATURE_GFXCLK_SPREAD_SPECTRUM_BIT: u32 = 34;
pub const FEATURE_OUT_OF_BAND_MONITOR_BIT: u32 = 35;
pub const FEATURE_OPTIMIZED_VMIN_BIT: u32 = 36;
pub const FEATURE_GFX_IMU_BIT: u32 = 37;
pub const FEATURE_BOOT_TIME_CAL_BIT: u32 = 38;
pub const FEATURE_GFX_PCC_DFLL_BIT: u32 = 39;
pub const FEATURE_SOC_CG_BIT: u32 = 40;
pub const FEATURE_DF_CSTATE_BIT: u32 = 41;
pub const FEATURE_GFX_EDC_BIT: u32 = 42;
pub const FEATURE_BOOT_POWER_OPT_BIT: u32 = 43;
pub const FEATURE_CLOCK_POWER_DOWN_BYPASS_BIT: u32 = 44;
pub const FEATURE_DS_VCN_BIT: u32 = 45;
pub const FEATURE_BACO_CG_BIT: u32 = 46;
pub const FEATURE_MEM_TEMP_READ_BIT: u32 = 47;
pub const FEATURE_ATHUB_MMHUB_PG_BIT: u32 = 48;
pub const FEATURE_SOC_PCC_BIT: u32 = 49;
pub const FEATURE_EDC_PWRBRK_BIT: u32 = 50;
pub const FEATURE_BOMXCO_SVI3_PROG_BIT: u32 = 51;
pub const FEATURE_SPARE_52_BIT: u32 = 52;
pub const FEATURE_SPARE_53_BIT: u32 = 53;
pub const FEATURE_SPARE_54_BIT: u32 = 54;
pub const FEATURE_SPARE_55_BIT: u32 = 55;
pub const FEATURE_SPARE_56_BIT: u32 = 56;
pub const FEATURE_SPARE_57_BIT: u32 = 57;
pub const FEATURE_SPARE_58_BIT: u32 = 58;
pub const FEATURE_SPARE_59_BIT: u32 = 59;
pub const FEATURE_SPARE_60_BIT: u32 = 60;
pub const FEATURE_SPARE_61_BIT: u32 = 61;
pub const FEATURE_SPARE_62_BIT: u32 = 62;
pub const FEATURE_SPARE_63_BIT: u32 = 63;
pub const NUM_FEATURES: u32 = 64;
pub const ALLOWED_FEATURE_CTRL_DEFAULT: i32 = -1;
pub const ALLOWED_FEATURE_CTRL_SCPM: u64 = 35184372218366;
pub const DEBUG_OVERRIDE_DISABLE_VOLT_LINK_VCN_FCLK: u32 = 1;
pub const DEBUG_OVERRIDE_DISABLE_VOLT_LINK_DCN_FCLK: u32 = 2;
pub const DEBUG_OVERRIDE_DISABLE_VOLT_LINK_MP0_FCLK: u32 = 4;
pub const DEBUG_OVERRIDE_DISABLE_VOLT_LINK_VCN_DCFCLK: u32 = 8;
pub const DEBUG_OVERRIDE_DISABLE_FAST_FCLK_TIMER: u32 = 16;
pub const DEBUG_OVERRIDE_DISABLE_VCN_PG: u32 = 32;
pub const DEBUG_OVERRIDE_DISABLE_FMAX_VMAX: u32 = 64;
pub const DEBUG_OVERRIDE_DISABLE_IMU_FW_CHECKS: u32 = 128;
pub const DEBUG_OVERRIDE_DISABLE_D0i2_REENTRY_HSR_TIMER_CHECK: u32 = 256;
pub const DEBUG_OVERRIDE_DISABLE_DFLL: u32 = 512;
pub const DEBUG_OVERRIDE_ENABLE_RLC_VF_BRINGUP_MODE: u32 = 1024;
pub const DEBUG_OVERRIDE_DFLL_MASTER_MODE: u32 = 2048;
pub const DEBUG_OVERRIDE_ENABLE_PROFILING_MODE: u32 = 4096;
pub const VR_MAPPING_VR_SELECT_MASK: u32 = 1;
pub const VR_MAPPING_VR_SELECT_SHIFT: u32 = 0;
pub const VR_MAPPING_PLANE_SELECT_MASK: u32 = 2;
pub const VR_MAPPING_PLANE_SELECT_SHIFT: u32 = 1;
pub const PSI_SEL_VR0_PLANE0_PSI0: u32 = 1;
pub const PSI_SEL_VR0_PLANE0_PSI1: u32 = 2;
pub const PSI_SEL_VR0_PLANE1_PSI0: u32 = 4;
pub const PSI_SEL_VR0_PLANE1_PSI1: u32 = 8;
pub const PSI_SEL_VR1_PLANE0_PSI0: u32 = 16;
pub const PSI_SEL_VR1_PLANE0_PSI1: u32 = 32;
pub const PSI_SEL_VR1_PLANE1_PSI0: u32 = 64;
pub const PSI_SEL_VR1_PLANE1_PSI1: u32 = 128;
pub const THROTTLER_TEMP_EDGE_BIT: u32 = 0;
pub const THROTTLER_TEMP_HOTSPOT_BIT: u32 = 1;
pub const THROTTLER_TEMP_HOTSPOT_G_BIT: u32 = 2;
pub const THROTTLER_TEMP_HOTSPOT_M_BIT: u32 = 3;
pub const THROTTLER_TEMP_MEM_BIT: u32 = 4;
pub const THROTTLER_TEMP_VR_GFX_BIT: u32 = 5;
pub const THROTTLER_TEMP_VR_MEM0_BIT: u32 = 6;
pub const THROTTLER_TEMP_VR_MEM1_BIT: u32 = 7;
pub const THROTTLER_TEMP_VR_SOC_BIT: u32 = 8;
pub const THROTTLER_TEMP_VR_U_BIT: u32 = 9;
pub const THROTTLER_TEMP_LIQUID0_BIT: u32 = 10;
pub const THROTTLER_TEMP_LIQUID1_BIT: u32 = 11;
pub const THROTTLER_TEMP_PLX_BIT: u32 = 12;
pub const THROTTLER_TDC_GFX_BIT: u32 = 13;
pub const THROTTLER_TDC_SOC_BIT: u32 = 14;
pub const THROTTLER_TDC_U_BIT: u32 = 15;
pub const THROTTLER_PPT0_BIT: u32 = 16;
pub const THROTTLER_PPT1_BIT: u32 = 17;
pub const THROTTLER_PPT2_BIT: u32 = 18;
pub const THROTTLER_PPT3_BIT: u32 = 19;
pub const THROTTLER_FIT_BIT: u32 = 20;
pub const THROTTLER_GFX_APCC_PLUS_BIT: u32 = 21;
pub const THROTTLER_COUNT: u32 = 22;
pub const FW_DSTATE_SOC_ULV_BIT: u32 = 0;
pub const FW_DSTATE_G6_HSR_BIT: u32 = 1;
pub const FW_DSTATE_G6_PHY_VMEMP_OFF_BIT: u32 = 2;
pub const FW_DSTATE_SMN_DS_BIT: u32 = 3;
pub const FW_DSTATE_MP1_WHISPER_MODE_BIT: u32 = 4;
pub const FW_DSTATE_SOC_LIV_MIN_BIT: u32 = 5;
pub const FW_DSTATE_SOC_PLL_PWRDN_BIT: u32 = 6;
pub const FW_DSTATE_MEM_PLL_PWRDN_BIT: u32 = 7;
pub const FW_DSTATE_MALL_ALLOC_BIT: u32 = 8;
pub const FW_DSTATE_MEM_PSI_BIT: u32 = 9;
pub const FW_DSTATE_HSR_NON_STROBE_BIT: u32 = 10;
pub const FW_DSTATE_MP0_ENTER_WFI_BIT: u32 = 11;
pub const FW_DSTATE_U_ULV_BIT: u32 = 12;
pub const FW_DSTATE_MALL_FLUSH_BIT: u32 = 13;
pub const FW_DSTATE_SOC_PSI_BIT: u32 = 14;
pub const FW_DSTATE_U_PSI_BIT: u32 = 15;
pub const FW_DSTATE_UCP_DS_BIT: u32 = 16;
pub const FW_DSTATE_CSRCLK_DS_BIT: u32 = 17;
pub const FW_DSTATE_MMHUB_INTERLOCK_BIT: u32 = 18;
pub const FW_DSTATE_D0i3_2_QUIET_FW_BIT: u32 = 19;
pub const FW_DSTATE_CLDO_PRG_BIT: u32 = 20;
pub const FW_DSTATE_DF_PLL_PWRDN_BIT: u32 = 21;
pub const FW_DSTATE_U_LOW_PWR_MODE_EN_BIT: u32 = 22;
pub const FW_DSTATE_GFX_PSI6_BIT: u32 = 23;
pub const FW_DSTATE_GFX_VR_PWR_STAGE_BIT: u32 = 24;
pub const LED_DISPLAY_GFX_DPM_BIT: u32 = 0;
pub const LED_DISPLAY_PCIE_BIT: u32 = 1;
pub const LED_DISPLAY_ERROR_BIT: u32 = 2;
pub const MEM_TEMP_READ_OUT_OF_BAND_BIT: u32 = 0;
pub const MEM_TEMP_READ_IN_BAND_REFRESH_BIT: u32 = 1;
pub const MEM_TEMP_READ_IN_BAND_DUMMY_PSTATE_BIT: u32 = 2;
pub const NUM_I2C_CONTROLLERS: u32 = 8;
pub const I2C_CONTROLLER_ENABLED: u32 = 1;
pub const I2C_CONTROLLER_DISABLED: u32 = 0;
pub const MAX_SW_I2C_COMMANDS: u32 = 24;
pub const CMDCONFIG_STOP_BIT: u32 = 0;
pub const CMDCONFIG_RESTART_BIT: u32 = 1;
pub const CMDCONFIG_READWRITE_BIT: u32 = 2;
pub const CMDCONFIG_STOP_MASK: u32 = 1;
pub const CMDCONFIG_RESTART_MASK: u32 = 2;
pub const CMDCONFIG_READWRITE_MASK: u32 = 4;
pub const PP_NUM_RTAVFS_PWL_ZONES: u32 = 5;
pub const PP_OD_FEATURE_GFX_VF_CURVE_BIT: u32 = 0;
pub const PP_OD_FEATURE_PPT_BIT: u32 = 2;
pub const PP_OD_FEATURE_FAN_CURVE_BIT: u32 = 3;
pub const PP_OD_FEATURE_GFXCLK_BIT: u32 = 7;
pub const PP_OD_FEATURE_UCLK_BIT: u32 = 8;
pub const PP_OD_FEATURE_ZERO_FAN_BIT: u32 = 9;
pub const PP_OD_FEATURE_TEMPERATURE_BIT: u32 = 10;
pub const PP_OD_FEATURE_COUNT: u32 = 13;
pub const PP_NUM_OD_VF_CURVE_POINTS: u32 = 6;
pub const INVALID_BOARD_GPIO: u32 = 255;
pub const MARKETING_BASE_CLOCKS: u32 = 0;
pub const MARKETING_GAME_CLOCKS: u32 = 1;
pub const MARKETING_BOOST_CLOCKS: u32 = 2;
pub const NUM_WM_RANGES: u32 = 4;
pub const WORKLOAD_PPLIB_DEFAULT_BIT: u32 = 0;
pub const WORKLOAD_PPLIB_FULL_SCREEN_3D_BIT: u32 = 1;
pub const WORKLOAD_PPLIB_POWER_SAVING_BIT: u32 = 2;
pub const WORKLOAD_PPLIB_VIDEO_BIT: u32 = 3;
pub const WORKLOAD_PPLIB_VR_BIT: u32 = 4;
pub const WORKLOAD_PPLIB_COMPUTE_BIT: u32 = 5;
pub const WORKLOAD_PPLIB_CUSTOM_BIT: u32 = 6;
pub const WORKLOAD_PPLIB_WINDOW_3D_BIT: u32 = 7;
pub const WORKLOAD_PPLIB_COUNT: u32 = 8;
pub const TABLE_TRANSFER_OK: u32 = 0;
pub const TABLE_TRANSFER_FAILED: u32 = 255;
pub const TABLE_TRANSFER_PENDING: u32 = 171;
pub const TABLE_PPTABLE: u32 = 0;
pub const TABLE_COMBO_PPTABLE: u32 = 1;
pub const TABLE_WATERMARKS: u32 = 2;
pub const TABLE_AVFS_PSM_DEBUG: u32 = 3;
pub const TABLE_PMSTATUSLOG: u32 = 4;
pub const TABLE_SMU_METRICS: u32 = 5;
pub const TABLE_DRIVER_SMU_CONFIG: u32 = 6;
pub const TABLE_ACTIVITY_MONITOR_COEFF: u32 = 7;
pub const TABLE_OVERDRIVE: u32 = 8;
pub const TABLE_I2C_COMMANDS: u32 = 9;
pub const TABLE_DRIVER_INFO: u32 = 10;
pub const TABLE_ECCINFO: u32 = 11;
pub const TABLE_WIFIBAND: u32 = 12;
pub const TABLE_COUNT: u32 = 13;
pub const IH_INTERRUPT_ID_TO_DRIVER: u32 = 254;
pub const IH_INTERRUPT_CONTEXT_ID_BACO: u32 = 2;
pub const IH_INTERRUPT_CONTEXT_ID_AC: u32 = 3;
pub const IH_INTERRUPT_CONTEXT_ID_DC: u32 = 4;
pub const IH_INTERRUPT_CONTEXT_ID_AUDIO_D0: u32 = 5;
pub const IH_INTERRUPT_CONTEXT_ID_AUDIO_D3: u32 = 6;
pub const IH_INTERRUPT_CONTEXT_ID_THERMAL_THROTTLING: u32 = 7;
pub const IH_INTERRUPT_CONTEXT_ID_FAN_ABNORMAL: u32 = 8;
pub const IH_INTERRUPT_CONTEXT_ID_FAN_RECOVERY: u32 = 9;
pub const SMU_13_0_0_TABLE_FORMAT_REVISION: u32 = 15;
pub const SMU_13_0_0_PP_PLATFORM_CAP_POWERPLAY: u32 = 1;
pub const SMU_13_0_0_PP_PLATFORM_CAP_SBIOSPOWERSOURCE: u32 = 2;
pub const SMU_13_0_0_PP_PLATFORM_CAP_HARDWAREDC: u32 = 4;
pub const SMU_13_0_0_PP_PLATFORM_CAP_BACO: u32 = 8;
pub const SMU_13_0_0_PP_PLATFORM_CAP_MACO: u32 = 16;
pub const SMU_13_0_0_PP_PLATFORM_CAP_SHADOWPSTATE: u32 = 32;
pub const SMU_13_0_0_PP_THERMALCONTROLLER_NONE: u32 = 0;
pub const SMU_13_0_0_PP_THERMALCONTROLLER_NAVI21: u32 = 28;
pub const SMU_13_0_0_PP_OVERDRIVE_VERSION: u32 = 131;
pub const SMU_13_0_0_PP_POWERSAVINGCLOCK_VERSION: u32 = 1;
pub const SMU_13_0_0_MAX_ODFEATURE: u32 = 32;
pub const SMU_13_0_0_MAX_ODSETTING: u32 = 64;
pub const SMU_13_0_0_MAX_PMSETTING: u32 = 32;
pub const SMU_13_0_0_MAX_PPCLOCK: u32 = 16;
pub type __u_char = ::core::ffi::c_uchar;
pub type __u_short = ::core::ffi::c_ushort;
pub type __u_int = ::core::ffi::c_uint;
pub type __u_long = ::core::ffi::c_ulong;
pub type __int8_t = ::core::ffi::c_schar;
pub type __uint8_t = ::core::ffi::c_uchar;
pub type __int16_t = ::core::ffi::c_short;
pub type __uint16_t = ::core::ffi::c_ushort;
pub type __int32_t = ::core::ffi::c_int;
pub type __uint32_t = ::core::ffi::c_uint;
pub type __int64_t = ::core::ffi::c_long;
pub type __uint64_t = ::core::ffi::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::core::ffi::c_long;
pub type __u_quad_t = ::core::ffi::c_ulong;
pub type __intmax_t = ::core::ffi::c_long;
pub type __uintmax_t = ::core::ffi::c_ulong;
pub type __dev_t = ::core::ffi::c_ulong;
pub type __uid_t = ::core::ffi::c_uint;
pub type __gid_t = ::core::ffi::c_uint;
pub type __ino_t = ::core::ffi::c_ulong;
pub type __ino64_t = ::core::ffi::c_ulong;
pub type __mode_t = ::core::ffi::c_uint;
pub type __nlink_t = ::core::ffi::c_ulong;
pub type __off_t = ::core::ffi::c_long;
pub type __off64_t = ::core::ffi::c_long;
pub type __pid_t = ::core::ffi::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::core::ffi::c_int; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __fsid_t"][::core::mem::size_of::<__fsid_t>() - 8usize];
    ["Alignment of __fsid_t"][::core::mem::align_of::<__fsid_t>() - 4usize];
    ["Offset of field: __fsid_t::__val"][::core::mem::offset_of!(__fsid_t, __val) - 0usize];
};
pub type __clock_t = ::core::ffi::c_long;
pub type __rlim_t = ::core::ffi::c_ulong;
pub type __rlim64_t = ::core::ffi::c_ulong;
pub type __id_t = ::core::ffi::c_uint;
pub type __time_t = ::core::ffi::c_long;
pub type __useconds_t = ::core::ffi::c_uint;
pub type __suseconds_t = ::core::ffi::c_long;
pub type __suseconds64_t = ::core::ffi::c_long;
pub type __daddr_t = ::core::ffi::c_int;
pub type __key_t = ::core::ffi::c_int;
pub type __clockid_t = ::core::ffi::c_int;
pub type __timer_t = *mut ::core::ffi::c_void;
pub type __blksize_t = ::core::ffi::c_long;
pub type __blkcnt_t = ::core::ffi::c_long;
pub type __blkcnt64_t = ::core::ffi::c_long;
pub type __fsblkcnt_t = ::core::ffi::c_ulong;
pub type __fsblkcnt64_t = ::core::ffi::c_ulong;
pub type __fsfilcnt_t = ::core::ffi::c_ulong;
pub type __fsfilcnt64_t = ::core::ffi::c_ulong;
pub type __fsword_t = ::core::ffi::c_long;
pub type __ssize_t = ::core::ffi::c_long;
pub type __syscall_slong_t = ::core::ffi::c_long;
pub type __syscall_ulong_t = ::core::ffi::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::core::ffi::c_char;
pub type __intptr_t = ::core::ffi::c_long;
pub type __socklen_t = ::core::ffi::c_uint;
pub type __sig_atomic_t = ::core::ffi::c_int;
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::core::ffi::c_schar;
pub type int_fast16_t = ::core::ffi::c_long;
pub type int_fast32_t = ::core::ffi::c_long;
pub type int_fast64_t = ::core::ffi::c_long;
pub type uint_fast8_t = ::core::ffi::c_uchar;
pub type uint_fast16_t = ::core::ffi::c_ulong;
pub type uint_fast32_t = ::core::ffi::c_ulong;
pub type uint_fast64_t = ::core::ffi::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
pub const atom_bios_header_version_def_ATOM_MAJOR_VERSION: atom_bios_header_version_def = 3;
pub const atom_bios_header_version_def_ATOM_MINOR_VERSION: atom_bios_header_version_def = 3;
pub type atom_bios_header_version_def = ::core::ffi::c_uint;
pub const atom_crtc_def_ATOM_CRTC1: atom_crtc_def = 0;
pub const atom_crtc_def_ATOM_CRTC2: atom_crtc_def = 1;
pub const atom_crtc_def_ATOM_CRTC3: atom_crtc_def = 2;
pub const atom_crtc_def_ATOM_CRTC4: atom_crtc_def = 3;
pub const atom_crtc_def_ATOM_CRTC5: atom_crtc_def = 4;
pub const atom_crtc_def_ATOM_CRTC6: atom_crtc_def = 5;
pub const atom_crtc_def_ATOM_CRTC_INVALID: atom_crtc_def = 255;
pub type atom_crtc_def = ::core::ffi::c_uint;
pub const atom_ppll_def_ATOM_PPLL0: atom_ppll_def = 2;
pub const atom_ppll_def_ATOM_GCK_DFS: atom_ppll_def = 8;
pub const atom_ppll_def_ATOM_FCH_CLK: atom_ppll_def = 9;
pub const atom_ppll_def_ATOM_DP_DTO: atom_ppll_def = 11;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL0: atom_ppll_def = 20;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL1: atom_ppll_def = 21;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL2: atom_ppll_def = 22;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL3: atom_ppll_def = 23;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL4: atom_ppll_def = 24;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL5: atom_ppll_def = 25;
pub const atom_ppll_def_ATOM_PPLL_INVALID: atom_ppll_def = 255;
pub type atom_ppll_def = ::core::ffi::c_uint;
pub const atom_dig_def_ASIC_INT_DIG1_ENCODER_ID: atom_dig_def = 3;
pub const atom_dig_def_ASIC_INT_DIG2_ENCODER_ID: atom_dig_def = 9;
pub const atom_dig_def_ASIC_INT_DIG3_ENCODER_ID: atom_dig_def = 10;
pub const atom_dig_def_ASIC_INT_DIG4_ENCODER_ID: atom_dig_def = 11;
pub const atom_dig_def_ASIC_INT_DIG5_ENCODER_ID: atom_dig_def = 12;
pub const atom_dig_def_ASIC_INT_DIG6_ENCODER_ID: atom_dig_def = 13;
pub const atom_dig_def_ASIC_INT_DIG7_ENCODER_ID: atom_dig_def = 14;
pub type atom_dig_def = ::core::ffi::c_uint;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP: atom_encode_mode_def = 0;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP_SST: atom_encode_mode_def = 0;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_LVDS: atom_encode_mode_def = 1;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DVI: atom_encode_mode_def = 2;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_HDMI: atom_encode_mode_def = 3;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP_AUDIO: atom_encode_mode_def = 5;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP_MST: atom_encode_mode_def = 5;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_CRT: atom_encode_mode_def = 15;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DVO: atom_encode_mode_def = 16;
pub type atom_encode_mode_def = ::core::ffi::c_uint;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_P1PLL: atom_encoder_refclk_src_def = 0;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_P2PLL: atom_encoder_refclk_src_def = 1;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_P3PLL: atom_encoder_refclk_src_def = 2;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_EXTCLK: atom_encoder_refclk_src_def = 3;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_INVALID: atom_encoder_refclk_src_def = 255;
pub type atom_encoder_refclk_src_def = ::core::ffi::c_uint;
pub const atom_scaler_def_ATOM_SCALER_DISABLE: atom_scaler_def = 0;
pub const atom_scaler_def_ATOM_SCALER_CENTER: atom_scaler_def = 1;
pub const atom_scaler_def_ATOM_SCALER_EXPANSION: atom_scaler_def = 2;
pub type atom_scaler_def = ::core::ffi::c_uint;
pub const atom_operation_def_ATOM_DISABLE: atom_operation_def = 0;
pub const atom_operation_def_ATOM_ENABLE: atom_operation_def = 1;
pub const atom_operation_def_ATOM_INIT: atom_operation_def = 7;
pub const atom_operation_def_ATOM_GET_STATUS: atom_operation_def = 8;
pub type atom_operation_def = ::core::ffi::c_uint;
pub const atom_embedded_display_op_def_ATOM_LCD_BL_OFF: atom_embedded_display_op_def = 2;
pub const atom_embedded_display_op_def_ATOM_LCD_BL_OM: atom_embedded_display_op_def = 3;
pub const atom_embedded_display_op_def_ATOM_LCD_BL_BRIGHTNESS_CONTROL:
    atom_embedded_display_op_def = 4;
pub const atom_embedded_display_op_def_ATOM_LCD_SELFTEST_START: atom_embedded_display_op_def = 5;
pub const atom_embedded_display_op_def_ATOM_LCD_SELFTEST_STOP: atom_embedded_display_op_def = 6;
pub type atom_embedded_display_op_def = ::core::ffi::c_uint;
pub const atom_spread_spectrum_mode_ATOM_SS_CENTER_OR_DOWN_MODE_MASK: atom_spread_spectrum_mode = 1;
pub const atom_spread_spectrum_mode_ATOM_SS_DOWN_SPREAD_MODE: atom_spread_spectrum_mode = 0;
pub const atom_spread_spectrum_mode_ATOM_SS_CENTRE_SPREAD_MODE: atom_spread_spectrum_mode = 1;
pub const atom_spread_spectrum_mode_ATOM_INT_OR_EXT_SS_MASK: atom_spread_spectrum_mode = 2;
pub const atom_spread_spectrum_mode_ATOM_INTERNAL_SS_MASK: atom_spread_spectrum_mode = 0;
pub const atom_spread_spectrum_mode_ATOM_EXTERNAL_SS_MASK: atom_spread_spectrum_mode = 2;
pub type atom_spread_spectrum_mode = ::core::ffi::c_uint;
pub const atom_panel_bit_per_color_PANEL_BPC_UNDEFINE: atom_panel_bit_per_color = 0;
pub const atom_panel_bit_per_color_PANEL_6BIT_PER_COLOR: atom_panel_bit_per_color = 1;
pub const atom_panel_bit_per_color_PANEL_8BIT_PER_COLOR: atom_panel_bit_per_color = 2;
pub const atom_panel_bit_per_color_PANEL_10BIT_PER_COLOR: atom_panel_bit_per_color = 3;
pub const atom_panel_bit_per_color_PANEL_12BIT_PER_COLOR: atom_panel_bit_per_color = 4;
pub const atom_panel_bit_per_color_PANEL_16BIT_PER_COLOR: atom_panel_bit_per_color = 5;
pub type atom_panel_bit_per_color = ::core::ffi::c_uint;
pub const atom_voltage_type_VOLTAGE_TYPE_VDDC: atom_voltage_type = 1;
pub const atom_voltage_type_VOLTAGE_TYPE_MVDDC: atom_voltage_type = 2;
pub const atom_voltage_type_VOLTAGE_TYPE_MVDDQ: atom_voltage_type = 3;
pub const atom_voltage_type_VOLTAGE_TYPE_VDDCI: atom_voltage_type = 4;
pub const atom_voltage_type_VOLTAGE_TYPE_VDDGFX: atom_voltage_type = 5;
pub const atom_voltage_type_VOLTAGE_TYPE_PCC: atom_voltage_type = 6;
pub const atom_voltage_type_VOLTAGE_TYPE_MVPP: atom_voltage_type = 7;
pub const atom_voltage_type_VOLTAGE_TYPE_LEDDPM: atom_voltage_type = 8;
pub const atom_voltage_type_VOLTAGE_TYPE_PCC_MVDD: atom_voltage_type = 9;
pub const atom_voltage_type_VOLTAGE_TYPE_PCIE_VDDC: atom_voltage_type = 10;
pub const atom_voltage_type_VOLTAGE_TYPE_PCIE_VDDR: atom_voltage_type = 11;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_1: atom_voltage_type = 17;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_2: atom_voltage_type = 18;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_3: atom_voltage_type = 19;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_4: atom_voltage_type = 20;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_5: atom_voltage_type = 21;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_6: atom_voltage_type = 22;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_7: atom_voltage_type = 23;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_8: atom_voltage_type = 24;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_9: atom_voltage_type = 25;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_10: atom_voltage_type = 26;
pub type atom_voltage_type = ::core::ffi::c_uint;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_GDDR5: atom_dgpu_vram_type = 80;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_HBM2: atom_dgpu_vram_type = 96;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_HBM2E: atom_dgpu_vram_type = 97;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_GDDR6: atom_dgpu_vram_type = 112;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_HBM3: atom_dgpu_vram_type = 128;
pub type atom_dgpu_vram_type = ::core::ffi::c_uint;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 0;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL1_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 1;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL2_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 2;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL3_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 3;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL1: atom_dp_vs_preemph_def = 8;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL1_PREEMPH_LEVEL1: atom_dp_vs_preemph_def = 9;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL2_PREEMPH_LEVEL1: atom_dp_vs_preemph_def = 10;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL2: atom_dp_vs_preemph_def = 16;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL1_PREEMPH_LEVEL2: atom_dp_vs_preemph_def = 17;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL3: atom_dp_vs_preemph_def = 24;
pub type atom_dp_vs_preemph_def = ::core::ffi::c_uint;
pub const atombios_image_offset_OFFSET_TO_ATOM_ROM_HEADER_POINTER: atombios_image_offset = 72;
pub const atombios_image_offset_OFFSET_TO_ATOM_ROM_IMAGE_SIZE: atombios_image_offset = 2;
pub const atombios_image_offset_OFFSET_TO_ATOMBIOS_ASIC_BUS_MEM_TYPE: atombios_image_offset = 148;
pub const atombios_image_offset_MAXSIZE_OF_ATOMBIOS_ASIC_BUS_MEM_TYPE: atombios_image_offset = 20;
pub const atombios_image_offset_OFFSET_TO_GET_ATOMBIOS_NUMBER_OF_STRINGS: atombios_image_offset =
    47;
pub const atombios_image_offset_OFFSET_TO_GET_ATOMBIOS_STRING_START: atombios_image_offset = 110;
pub const atombios_image_offset_OFFSET_TO_VBIOS_PART_NUMBER: atombios_image_offset = 128;
pub const atombios_image_offset_OFFSET_TO_VBIOS_DATE: atombios_image_offset = 80;
pub type atombios_image_offset = ::core::ffi::c_uint;
#[doc = " Common header for all tables (Data table, Command function).\n Every table pointed in _ATOM_MASTER_DATA_TABLE has this common header.\n And the pointer actually points to this header."]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_common_table_header {
    pub structuresize: u16,
    pub format_revision: u8,
    pub content_revision: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_common_table_header"]
        [::core::mem::size_of::<atom_common_table_header>() - 4usize];
    ["Alignment of atom_common_table_header"]
        [::core::mem::align_of::<atom_common_table_header>() - 1usize];
    ["Offset of field: atom_common_table_header::structuresize"]
        [::core::mem::offset_of!(atom_common_table_header, structuresize) - 0usize];
    ["Offset of field: atom_common_table_header::format_revision"]
        [::core::mem::offset_of!(atom_common_table_header, format_revision) - 2usize];
    ["Offset of field: atom_common_table_header::content_revision"]
        [::core::mem::offset_of!(atom_common_table_header, content_revision) - 3usize];
};
#[doc = " Structure stores the ROM header."]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_rom_header_v2_2 {
    pub table_header: atom_common_table_header,
    pub atom_bios_string: [u8; 4usize],
    pub bios_segment_address: u16,
    pub protectedmodeoffset: u16,
    pub configfilenameoffset: u16,
    pub crc_block_offset: u16,
    pub vbios_bootupmessageoffset: u16,
    pub int10_offset: u16,
    pub pcibusdevinitcode: u16,
    pub iobaseaddress: u16,
    pub subsystem_vendor_id: u16,
    pub subsystem_id: u16,
    pub pci_info_offset: u16,
    pub masterhwfunction_offset: u16,
    pub masterdatatable_offset: u16,
    pub reserved: u16,
    pub pspdirtableoffset: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_rom_header_v2_2"][::core::mem::size_of::<atom_rom_header_v2_2>() - 40usize];
    ["Alignment of atom_rom_header_v2_2"][::core::mem::align_of::<atom_rom_header_v2_2>() - 1usize];
    ["Offset of field: atom_rom_header_v2_2::table_header"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, table_header) - 0usize];
    ["Offset of field: atom_rom_header_v2_2::atom_bios_string"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, atom_bios_string) - 4usize];
    ["Offset of field: atom_rom_header_v2_2::bios_segment_address"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, bios_segment_address) - 8usize];
    ["Offset of field: atom_rom_header_v2_2::protectedmodeoffset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, protectedmodeoffset) - 10usize];
    ["Offset of field: atom_rom_header_v2_2::configfilenameoffset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, configfilenameoffset) - 12usize];
    ["Offset of field: atom_rom_header_v2_2::crc_block_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, crc_block_offset) - 14usize];
    ["Offset of field: atom_rom_header_v2_2::vbios_bootupmessageoffset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, vbios_bootupmessageoffset) - 16usize];
    ["Offset of field: atom_rom_header_v2_2::int10_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, int10_offset) - 18usize];
    ["Offset of field: atom_rom_header_v2_2::pcibusdevinitcode"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, pcibusdevinitcode) - 20usize];
    ["Offset of field: atom_rom_header_v2_2::iobaseaddress"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, iobaseaddress) - 22usize];
    ["Offset of field: atom_rom_header_v2_2::subsystem_vendor_id"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, subsystem_vendor_id) - 24usize];
    ["Offset of field: atom_rom_header_v2_2::subsystem_id"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, subsystem_id) - 26usize];
    ["Offset of field: atom_rom_header_v2_2::pci_info_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, pci_info_offset) - 28usize];
    ["Offset of field: atom_rom_header_v2_2::masterhwfunction_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, masterhwfunction_offset) - 30usize];
    ["Offset of field: atom_rom_header_v2_2::masterdatatable_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, masterdatatable_offset) - 32usize];
    ["Offset of field: atom_rom_header_v2_2::reserved"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, reserved) - 34usize];
    ["Offset of field: atom_rom_header_v2_2::pspdirtableoffset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, pspdirtableoffset) - 36usize];
};
#[doc = " Structures used in Command.mtb, each function name is not given here since those function could change from time to time\n The real functionality of each function is associated with the parameter structure version when defined\n For all internal cmd function definitions, please reference to atomstruct.h"]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_list_of_command_functions_v2_1 {
    pub asic_init: u16,
    pub cmd_function1: u16,
    pub cmd_function2: u16,
    pub cmd_function3: u16,
    pub digxencodercontrol: u16,
    pub cmd_function5: u16,
    pub cmd_function6: u16,
    pub cmd_function7: u16,
    pub cmd_function8: u16,
    pub cmd_function9: u16,
    pub setengineclock: u16,
    pub setmemoryclock: u16,
    pub setpixelclock: u16,
    pub enabledisppowergating: u16,
    pub cmd_function14: u16,
    pub cmd_function15: u16,
    pub cmd_function16: u16,
    pub cmd_function17: u16,
    pub cmd_function18: u16,
    pub cmd_function19: u16,
    pub cmd_function20: u16,
    pub cmd_function21: u16,
    pub cmd_function22: u16,
    pub cmd_function23: u16,
    pub cmd_function24: u16,
    pub cmd_function25: u16,
    pub cmd_function26: u16,
    pub cmd_function27: u16,
    pub cmd_function28: u16,
    pub cmd_function29: u16,
    pub cmd_function30: u16,
    pub cmd_function31: u16,
    pub cmd_function32: u16,
    pub cmd_function33: u16,
    pub blankcrtc: u16,
    pub enablecrtc: u16,
    pub cmd_function36: u16,
    pub cmd_function37: u16,
    pub cmd_function38: u16,
    pub cmd_function39: u16,
    pub cmd_function40: u16,
    pub getsmuclockinfo: u16,
    pub selectcrtc_source: u16,
    pub cmd_function43: u16,
    pub cmd_function44: u16,
    pub cmd_function45: u16,
    pub setdceclock: u16,
    pub getmemoryclock: u16,
    pub getengineclock: u16,
    pub setcrtc_usingdtdtiming: u16,
    pub externalencodercontrol: u16,
    pub cmd_function51: u16,
    pub cmd_function52: u16,
    pub cmd_function53: u16,
    pub processi2cchanneltransaction: u16,
    pub cmd_function55: u16,
    pub cmd_function56: u16,
    pub cmd_function57: u16,
    pub cmd_function58: u16,
    pub cmd_function59: u16,
    pub computegpuclockparam: u16,
    pub cmd_function61: u16,
    pub cmd_function62: u16,
    pub dynamicmemorysettings: u16,
    pub memorytraining: u16,
    pub cmd_function65: u16,
    pub cmd_function66: u16,
    pub setvoltage: u16,
    pub cmd_function68: u16,
    pub readefusevalue: u16,
    pub cmd_function70: u16,
    pub cmd_function71: u16,
    pub cmd_function72: u16,
    pub cmd_function73: u16,
    pub cmd_function74: u16,
    pub cmd_function75: u16,
    pub dig1transmittercontrol: u16,
    pub cmd_function77: u16,
    pub processauxchanneltransaction: u16,
    pub cmd_function79: u16,
    pub getvoltageinfo: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_master_list_of_command_functions_v2_1"]
        [::core::mem::size_of::<atom_master_list_of_command_functions_v2_1>() - 162usize];
    ["Alignment of atom_master_list_of_command_functions_v2_1"]
        [::core::mem::align_of::<atom_master_list_of_command_functions_v2_1>() - 1usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::asic_init"]
        [::core::mem::offset_of!(atom_master_list_of_command_functions_v2_1, asic_init) - 0usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function1"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function1
    ) - 2usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function2"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function2
    ) - 4usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function3"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function3
    ) - 6usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::digxencodercontrol"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        digxencodercontrol
    ) - 8usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function5"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function5
    ) - 10usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function6"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function6
    ) - 12usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function7"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function7
    ) - 14usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function8"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function8
    ) - 16usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function9"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function9
    ) - 18usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setengineclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setengineclock
    ) - 20usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setmemoryclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setmemoryclock
    ) - 22usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setpixelclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setpixelclock
    ) - 24usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::enabledisppowergating"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        enabledisppowergating
    )
        - 26usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function14"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function14
    ) - 28usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function15"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function15
    ) - 30usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function16"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function16
    ) - 32usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function17"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function17
    ) - 34usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function18"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function18
    ) - 36usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function19"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function19
    ) - 38usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function20"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function20
    ) - 40usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function21"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function21
    ) - 42usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function22"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function22
    ) - 44usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function23"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function23
    ) - 46usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function24"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function24
    ) - 48usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function25"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function25
    ) - 50usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function26"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function26
    ) - 52usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function27"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function27
    ) - 54usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function28"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function28
    ) - 56usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function29"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function29
    ) - 58usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function30"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function30
    ) - 60usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function31"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function31
    ) - 62usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function32"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function32
    ) - 64usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function33"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function33
    ) - 66usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::blankcrtc"]
        [::core::mem::offset_of!(atom_master_list_of_command_functions_v2_1, blankcrtc) - 68usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::enablecrtc"]
        [::core::mem::offset_of!(atom_master_list_of_command_functions_v2_1, enablecrtc) - 70usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function36"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function36
    ) - 72usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function37"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function37
    ) - 74usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function38"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function38
    ) - 76usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function39"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function39
    ) - 78usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function40"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function40
    ) - 80usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::getsmuclockinfo"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        getsmuclockinfo
    ) - 82usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::selectcrtc_source"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        selectcrtc_source
    ) - 84usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function43"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function43
    ) - 86usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function44"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function44
    ) - 88usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function45"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function45
    ) - 90usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setdceclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setdceclock
    ) - 92usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::getmemoryclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        getmemoryclock
    ) - 94usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::getengineclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        getengineclock
    ) - 96usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setcrtc_usingdtdtiming"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setcrtc_usingdtdtiming
    )
        - 98usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::externalencodercontrol"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        externalencodercontrol
    )
        - 100usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function51"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function51
    ) - 102usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function52"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function52
    ) - 104usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function53"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function53
    ) - 106usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::processi2cchanneltransaction"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        processi2cchanneltransaction
    )
        - 108usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function55"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function55
    ) - 110usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function56"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function56
    ) - 112usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function57"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function57
    ) - 114usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function58"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function58
    ) - 116usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function59"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function59
    ) - 118usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::computegpuclockparam"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        computegpuclockparam
    )
        - 120usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function61"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function61
    ) - 122usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function62"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function62
    ) - 124usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::dynamicmemorysettings"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        dynamicmemorysettings
    )
        - 126usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::memorytraining"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        memorytraining
    ) - 128usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function65"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function65
    ) - 130usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function66"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function66
    ) - 132usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setvoltage"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setvoltage
    ) - 134usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function68"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function68
    ) - 136usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::readefusevalue"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        readefusevalue
    ) - 138usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function70"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function70
    ) - 140usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function71"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function71
    ) - 142usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function72"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function72
    ) - 144usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function73"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function73
    ) - 146usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function74"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function74
    ) - 148usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function75"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function75
    ) - 150usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::dig1transmittercontrol"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        dig1transmittercontrol
    )
        - 152usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function77"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function77
    ) - 154usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::processauxchanneltransaction"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        processauxchanneltransaction
    )
        - 156usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function79"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function79
    ) - 158usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::getvoltageinfo"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        getvoltageinfo
    ) - 160usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_command_function_v2_1 {
    pub table_header: atom_common_table_header,
    pub listofcmdfunctions: atom_master_list_of_command_functions_v2_1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_master_command_function_v2_1"]
        [::core::mem::size_of::<atom_master_command_function_v2_1>() - 166usize];
    ["Alignment of atom_master_command_function_v2_1"]
        [::core::mem::align_of::<atom_master_command_function_v2_1>() - 1usize];
    ["Offset of field: atom_master_command_function_v2_1::table_header"]
        [::core::mem::offset_of!(atom_master_command_function_v2_1, table_header) - 0usize];
    ["Offset of field: atom_master_command_function_v2_1::listofcmdfunctions"]
        [::core::mem::offset_of!(atom_master_command_function_v2_1, listofcmdfunctions) - 4usize];
};
#[doc = " Structures used in every command function"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_function_attribute {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_function_attribute"][::core::mem::size_of::<atom_function_attribute>() - 2usize];
    ["Alignment of atom_function_attribute"]
        [::core::mem::align_of::<atom_function_attribute>() - 1usize];
};
impl atom_function_attribute {
    #[inline]
    pub fn ws_in_bytes(&self) -> u16 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u16) }
    }
    #[inline]
    pub fn set_ws_in_bytes(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn ps_in_bytes(&self) -> u16 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 7u8) as u16) }
    }
    #[inline]
    pub fn set_ps_in_bytes(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn updated_by_util(&self) -> u16 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_updated_by_util(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ws_in_bytes: u16,
        ps_in_bytes: u16,
        updated_by_util: u16,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let ws_in_bytes: u16 = unsafe { ::core::mem::transmute(ws_in_bytes) };
            ws_in_bytes as u64
        });
        __bindgen_bitfield_unit.set(8usize, 7u8, {
            let ps_in_bytes: u16 = unsafe { ::core::mem::transmute(ps_in_bytes) };
            ps_in_bytes as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let updated_by_util: u16 = unsafe { ::core::mem::transmute(updated_by_util) };
            updated_by_util as u64
        });
        __bindgen_bitfield_unit
    }
}
#[doc = " Common header for all hw functions.\n Every function pointed by _master_list_of_hw_function has this common header.\n And the pointer actually points to this header."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_rom_hw_function_header {
    pub func_header: atom_common_table_header,
    pub func_attrib: atom_function_attribute,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_rom_hw_function_header"]
        [::core::mem::size_of::<atom_rom_hw_function_header>() - 6usize];
    ["Alignment of atom_rom_hw_function_header"]
        [::core::mem::align_of::<atom_rom_hw_function_header>() - 1usize];
    ["Offset of field: atom_rom_hw_function_header::func_header"]
        [::core::mem::offset_of!(atom_rom_hw_function_header, func_header) - 0usize];
    ["Offset of field: atom_rom_hw_function_header::func_attrib"]
        [::core::mem::offset_of!(atom_rom_hw_function_header, func_attrib) - 4usize];
};
#[doc = " Structures used in data.mtb, each data table name is not given here since those data table could change from time to time\n The real name of each table is given when its data structure version is defined"]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_list_of_data_tables_v2_1 {
    pub utilitypipeline: u16,
    pub multimedia_info: u16,
    pub smc_dpm_info: u16,
    pub sw_datatable3: u16,
    pub firmwareinfo: u16,
    pub sw_datatable5: u16,
    pub lcd_info: u16,
    pub sw_datatable7: u16,
    pub smu_info: u16,
    pub sw_datatable9: u16,
    pub sw_datatable10: u16,
    pub vram_usagebyfirmware: u16,
    pub gpio_pin_lut: u16,
    pub sw_datatable13: u16,
    pub gfx_info: u16,
    pub powerplayinfo: u16,
    pub sw_datatable16: u16,
    pub sw_datatable17: u16,
    pub sw_datatable18: u16,
    pub sw_datatable19: u16,
    pub sw_datatable20: u16,
    pub sw_datatable21: u16,
    pub displayobjectinfo: u16,
    pub indirectioaccess: u16,
    pub umc_info: u16,
    pub sw_datatable25: u16,
    pub sw_datatable26: u16,
    pub dce_info: u16,
    pub vram_info: u16,
    pub sw_datatable29: u16,
    pub integratedsysteminfo: u16,
    pub asic_profiling_info: u16,
    pub voltageobject_info: u16,
    pub sw_datatable33: u16,
    pub sw_datatable34: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_master_list_of_data_tables_v2_1"]
        [::core::mem::size_of::<atom_master_list_of_data_tables_v2_1>() - 70usize];
    ["Alignment of atom_master_list_of_data_tables_v2_1"]
        [::core::mem::align_of::<atom_master_list_of_data_tables_v2_1>() - 1usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::utilitypipeline"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, utilitypipeline) - 0usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::multimedia_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, multimedia_info) - 2usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::smc_dpm_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, smc_dpm_info) - 4usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable3"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable3) - 6usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::firmwareinfo"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, firmwareinfo) - 8usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable5"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable5) - 10usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::lcd_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, lcd_info) - 12usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable7"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable7) - 14usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::smu_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, smu_info) - 16usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable9"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable9) - 18usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable10"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable10) - 20usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::vram_usagebyfirmware"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        vram_usagebyfirmware
    ) - 22usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::gpio_pin_lut"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, gpio_pin_lut) - 24usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable13"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable13) - 26usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::gfx_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, gfx_info) - 28usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::powerplayinfo"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, powerplayinfo) - 30usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable16"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable16) - 32usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable17"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable17) - 34usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable18"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable18) - 36usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable19"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable19) - 38usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable20"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable20) - 40usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable21"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable21) - 42usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::displayobjectinfo"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        displayobjectinfo
    ) - 44usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::indirectioaccess"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, indirectioaccess) - 46usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::umc_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, umc_info) - 48usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable25"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable25) - 50usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable26"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable26) - 52usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::dce_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, dce_info) - 54usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::vram_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, vram_info) - 56usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable29"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable29) - 58usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::integratedsysteminfo"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        integratedsysteminfo
    ) - 60usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::asic_profiling_info"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        asic_profiling_info
    ) - 62usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::voltageobject_info"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        voltageobject_info
    ) - 64usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable33"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable33) - 66usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable34"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable34) - 68usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_data_table_v2_1 {
    pub table_header: atom_common_table_header,
    pub listOfdatatables: atom_master_list_of_data_tables_v2_1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_master_data_table_v2_1"]
        [::core::mem::size_of::<atom_master_data_table_v2_1>() - 74usize];
    ["Alignment of atom_master_data_table_v2_1"]
        [::core::mem::align_of::<atom_master_data_table_v2_1>() - 1usize];
    ["Offset of field: atom_master_data_table_v2_1::table_header"]
        [::core::mem::offset_of!(atom_master_data_table_v2_1, table_header) - 0usize];
    ["Offset of field: atom_master_data_table_v2_1::listOfdatatables"]
        [::core::mem::offset_of!(atom_master_data_table_v2_1, listOfdatatables) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_dtd_format {
    pub pixclk: u16,
    pub h_active: u16,
    pub h_blanking_time: u16,
    pub v_active: u16,
    pub v_blanking_time: u16,
    pub h_sync_offset: u16,
    pub h_sync_width: u16,
    pub v_sync_offset: u16,
    pub v_syncwidth: u16,
    pub reserved: u16,
    pub reserved0: u16,
    pub h_border: u8,
    pub v_border: u8,
    pub miscinfo: u16,
    pub atom_mode_id: u8,
    pub refreshrate: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_dtd_format"][::core::mem::size_of::<atom_dtd_format>() - 28usize];
    ["Alignment of atom_dtd_format"][::core::mem::align_of::<atom_dtd_format>() - 1usize];
    ["Offset of field: atom_dtd_format::pixclk"]
        [::core::mem::offset_of!(atom_dtd_format, pixclk) - 0usize];
    ["Offset of field: atom_dtd_format::h_active"]
        [::core::mem::offset_of!(atom_dtd_format, h_active) - 2usize];
    ["Offset of field: atom_dtd_format::h_blanking_time"]
        [::core::mem::offset_of!(atom_dtd_format, h_blanking_time) - 4usize];
    ["Offset of field: atom_dtd_format::v_active"]
        [::core::mem::offset_of!(atom_dtd_format, v_active) - 6usize];
    ["Offset of field: atom_dtd_format::v_blanking_time"]
        [::core::mem::offset_of!(atom_dtd_format, v_blanking_time) - 8usize];
    ["Offset of field: atom_dtd_format::h_sync_offset"]
        [::core::mem::offset_of!(atom_dtd_format, h_sync_offset) - 10usize];
    ["Offset of field: atom_dtd_format::h_sync_width"]
        [::core::mem::offset_of!(atom_dtd_format, h_sync_width) - 12usize];
    ["Offset of field: atom_dtd_format::v_sync_offset"]
        [::core::mem::offset_of!(atom_dtd_format, v_sync_offset) - 14usize];
    ["Offset of field: atom_dtd_format::v_syncwidth"]
        [::core::mem::offset_of!(atom_dtd_format, v_syncwidth) - 16usize];
    ["Offset of field: atom_dtd_format::reserved"]
        [::core::mem::offset_of!(atom_dtd_format, reserved) - 18usize];
    ["Offset of field: atom_dtd_format::reserved0"]
        [::core::mem::offset_of!(atom_dtd_format, reserved0) - 20usize];
    ["Offset of field: atom_dtd_format::h_border"]
        [::core::mem::offset_of!(atom_dtd_format, h_border) - 22usize];
    ["Offset of field: atom_dtd_format::v_border"]
        [::core::mem::offset_of!(atom_dtd_format, v_border) - 23usize];
    ["Offset of field: atom_dtd_format::miscinfo"]
        [::core::mem::offset_of!(atom_dtd_format, miscinfo) - 24usize];
    ["Offset of field: atom_dtd_format::atom_mode_id"]
        [::core::mem::offset_of!(atom_dtd_format, atom_mode_id) - 26usize];
    ["Offset of field: atom_dtd_format::refreshrate"]
        [::core::mem::offset_of!(atom_dtd_format, refreshrate) - 27usize];
};
pub const atom_dtd_format_modemiscinfo_ATOM_HSYNC_POLARITY: atom_dtd_format_modemiscinfo = 2;
pub const atom_dtd_format_modemiscinfo_ATOM_VSYNC_POLARITY: atom_dtd_format_modemiscinfo = 4;
pub const atom_dtd_format_modemiscinfo_ATOM_H_REPLICATIONBY2: atom_dtd_format_modemiscinfo = 16;
pub const atom_dtd_format_modemiscinfo_ATOM_V_REPLICATIONBY2: atom_dtd_format_modemiscinfo = 32;
pub const atom_dtd_format_modemiscinfo_ATOM_INTERLACE: atom_dtd_format_modemiscinfo = 128;
pub const atom_dtd_format_modemiscinfo_ATOM_COMPOSITESYNC: atom_dtd_format_modemiscinfo = 64;
pub type atom_dtd_format_modemiscinfo = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_1 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub reserved2: [u32; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_firmware_info_v3_1"]
        [::core::mem::size_of::<atom_firmware_info_v3_1>() - 72usize];
    ["Alignment of atom_firmware_info_v3_1"]
        [::core::mem::align_of::<atom_firmware_info_v3_1>() - 1usize];
    ["Offset of field: atom_firmware_info_v3_1::table_header"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, table_header) - 0usize];
    ["Offset of field: atom_firmware_info_v3_1::firmware_revision"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, firmware_revision) - 4usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_sclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_sclk_in10khz) - 8usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_mclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_mclk_in10khz) - 12usize];
    ["Offset of field: atom_firmware_info_v3_1::firmware_capability"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, firmware_capability) - 16usize];
    ["Offset of field: atom_firmware_info_v3_1::main_call_parser_entry"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, main_call_parser_entry) - 20usize];
    ["Offset of field: atom_firmware_info_v3_1::bios_scratch_reg_startaddr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bios_scratch_reg_startaddr) - 24usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_vddc_mv) - 28usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_vddci_mv) - 30usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_mvddc_mv) - 32usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_vddgfx_mv) - 34usize];
    ["Offset of field: atom_firmware_info_v3_1::mem_module_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, mem_module_id) - 36usize];
    ["Offset of field: atom_firmware_info_v3_1::coolingsolution_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, coolingsolution_id) - 37usize];
    ["Offset of field: atom_firmware_info_v3_1::reserved1"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, reserved1) - 38usize];
    ["Offset of field: atom_firmware_info_v3_1::mc_baseaddr_high"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, mc_baseaddr_high) - 40usize];
    ["Offset of field: atom_firmware_info_v3_1::mc_baseaddr_low"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, mc_baseaddr_low) - 44usize];
    ["Offset of field: atom_firmware_info_v3_1::reserved2"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, reserved2) - 48usize];
};
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_FIRMWARE_POSTED:
    atombios_firmware_capability = 1;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_GPU_VIRTUALIZATION:
    atombios_firmware_capability = 2;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_WMI_SUPPORT: atombios_firmware_capability =
    64;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_HWEMU_ENABLE:
    atombios_firmware_capability = 128;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_HWEMU_UMC_CFG:
    atombios_firmware_capability = 256;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_SRAM_ECC: atombios_firmware_capability =
    512;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_ENABLE_2STAGE_BIST_TRAINING:
    atombios_firmware_capability = 1024;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_ENABLE_2ND_USB20PORT:
    atombios_firmware_capability = 32768;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_DYNAMIC_BOOT_CFG_ENABLE:
    atombios_firmware_capability = 131072;
pub type atombios_firmware_capability = ::core::ffi::c_uint;
pub const atom_cooling_solution_id_AIR_COOLING: atom_cooling_solution_id = 0;
pub const atom_cooling_solution_id_LIQUID_COOLING: atom_cooling_solution_id = 1;
pub type atom_cooling_solution_id = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_2 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub reserved3: u8,
    pub bootup_mvddq_mv: u16,
    pub bootup_mvpp_mv: u16,
    pub zfbstartaddrin16mb: u32,
    pub reserved2: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_firmware_info_v3_2"]
        [::core::mem::size_of::<atom_firmware_info_v3_2>() - 72usize];
    ["Alignment of atom_firmware_info_v3_2"]
        [::core::mem::align_of::<atom_firmware_info_v3_2>() - 1usize];
    ["Offset of field: atom_firmware_info_v3_2::table_header"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, table_header) - 0usize];
    ["Offset of field: atom_firmware_info_v3_2::firmware_revision"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, firmware_revision) - 4usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_sclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_sclk_in10khz) - 8usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_mclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_mclk_in10khz) - 12usize];
    ["Offset of field: atom_firmware_info_v3_2::firmware_capability"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, firmware_capability) - 16usize];
    ["Offset of field: atom_firmware_info_v3_2::main_call_parser_entry"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, main_call_parser_entry) - 20usize];
    ["Offset of field: atom_firmware_info_v3_2::bios_scratch_reg_startaddr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bios_scratch_reg_startaddr) - 24usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_vddc_mv) - 28usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_vddci_mv) - 30usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_mvddc_mv) - 32usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_vddgfx_mv) - 34usize];
    ["Offset of field: atom_firmware_info_v3_2::mem_module_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, mem_module_id) - 36usize];
    ["Offset of field: atom_firmware_info_v3_2::coolingsolution_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, coolingsolution_id) - 37usize];
    ["Offset of field: atom_firmware_info_v3_2::reserved1"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, reserved1) - 38usize];
    ["Offset of field: atom_firmware_info_v3_2::mc_baseaddr_high"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, mc_baseaddr_high) - 40usize];
    ["Offset of field: atom_firmware_info_v3_2::mc_baseaddr_low"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, mc_baseaddr_low) - 44usize];
    ["Offset of field: atom_firmware_info_v3_2::board_i2c_feature_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, board_i2c_feature_id) - 48usize];
    ["Offset of field: atom_firmware_info_v3_2::board_i2c_feature_gpio_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, board_i2c_feature_gpio_id) - 49usize];
    ["Offset of field: atom_firmware_info_v3_2::board_i2c_feature_slave_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, board_i2c_feature_slave_addr) - 50usize];
    ["Offset of field: atom_firmware_info_v3_2::reserved3"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, reserved3) - 51usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_mvddq_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_mvddq_mv) - 52usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_mvpp_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_mvpp_mv) - 54usize];
    ["Offset of field: atom_firmware_info_v3_2::zfbstartaddrin16mb"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, zfbstartaddrin16mb) - 56usize];
    ["Offset of field: atom_firmware_info_v3_2::reserved2"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, reserved2) - 60usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_3 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub reserved3: u8,
    pub bootup_mvddq_mv: u16,
    pub bootup_mvpp_mv: u16,
    pub zfbstartaddrin16mb: u32,
    pub pplib_pptable_id: u32,
    pub reserved2: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_firmware_info_v3_3"]
        [::core::mem::size_of::<atom_firmware_info_v3_3>() - 72usize];
    ["Alignment of atom_firmware_info_v3_3"]
        [::core::mem::align_of::<atom_firmware_info_v3_3>() - 1usize];
    ["Offset of field: atom_firmware_info_v3_3::table_header"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, table_header) - 0usize];
    ["Offset of field: atom_firmware_info_v3_3::firmware_revision"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, firmware_revision) - 4usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_sclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_sclk_in10khz) - 8usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_mclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_mclk_in10khz) - 12usize];
    ["Offset of field: atom_firmware_info_v3_3::firmware_capability"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, firmware_capability) - 16usize];
    ["Offset of field: atom_firmware_info_v3_3::main_call_parser_entry"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, main_call_parser_entry) - 20usize];
    ["Offset of field: atom_firmware_info_v3_3::bios_scratch_reg_startaddr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bios_scratch_reg_startaddr) - 24usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_vddc_mv) - 28usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_vddci_mv) - 30usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_mvddc_mv) - 32usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_vddgfx_mv) - 34usize];
    ["Offset of field: atom_firmware_info_v3_3::mem_module_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, mem_module_id) - 36usize];
    ["Offset of field: atom_firmware_info_v3_3::coolingsolution_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, coolingsolution_id) - 37usize];
    ["Offset of field: atom_firmware_info_v3_3::reserved1"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, reserved1) - 38usize];
    ["Offset of field: atom_firmware_info_v3_3::mc_baseaddr_high"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, mc_baseaddr_high) - 40usize];
    ["Offset of field: atom_firmware_info_v3_3::mc_baseaddr_low"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, mc_baseaddr_low) - 44usize];
    ["Offset of field: atom_firmware_info_v3_3::board_i2c_feature_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, board_i2c_feature_id) - 48usize];
    ["Offset of field: atom_firmware_info_v3_3::board_i2c_feature_gpio_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, board_i2c_feature_gpio_id) - 49usize];
    ["Offset of field: atom_firmware_info_v3_3::board_i2c_feature_slave_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, board_i2c_feature_slave_addr) - 50usize];
    ["Offset of field: atom_firmware_info_v3_3::reserved3"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, reserved3) - 51usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_mvddq_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_mvddq_mv) - 52usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_mvpp_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_mvpp_mv) - 54usize];
    ["Offset of field: atom_firmware_info_v3_3::zfbstartaddrin16mb"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, zfbstartaddrin16mb) - 56usize];
    ["Offset of field: atom_firmware_info_v3_3::pplib_pptable_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, pplib_pptable_id) - 60usize];
    ["Offset of field: atom_firmware_info_v3_3::reserved2"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, reserved2) - 64usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_4 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub ras_rom_i2c_slave_addr: u8,
    pub bootup_mvddq_mv: u16,
    pub bootup_mvpp_mv: u16,
    pub zfbstartaddrin16mb: u32,
    pub pplib_pptable_id: u32,
    pub mvdd_ratio: u32,
    pub hw_bootup_vddgfx_mv: u16,
    pub hw_bootup_vddc_mv: u16,
    pub hw_bootup_mvddc_mv: u16,
    pub hw_bootup_vddci_mv: u16,
    pub maco_pwrlimit_mw: u32,
    pub usb_pwrlimit_mw: u32,
    pub fw_reserved_size_in_kb: u32,
    pub pspbl_init_done_reg_addr: u32,
    pub pspbl_init_done_value: u32,
    pub pspbl_init_done_check_timeout: u32,
    pub reserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_firmware_info_v3_4"]
        [::core::mem::size_of::<atom_firmware_info_v3_4>() - 108usize];
    ["Alignment of atom_firmware_info_v3_4"]
        [::core::mem::align_of::<atom_firmware_info_v3_4>() - 1usize];
    ["Offset of field: atom_firmware_info_v3_4::table_header"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, table_header) - 0usize];
    ["Offset of field: atom_firmware_info_v3_4::firmware_revision"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, firmware_revision) - 4usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_sclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_sclk_in10khz) - 8usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_mclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_mclk_in10khz) - 12usize];
    ["Offset of field: atom_firmware_info_v3_4::firmware_capability"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, firmware_capability) - 16usize];
    ["Offset of field: atom_firmware_info_v3_4::main_call_parser_entry"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, main_call_parser_entry) - 20usize];
    ["Offset of field: atom_firmware_info_v3_4::bios_scratch_reg_startaddr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bios_scratch_reg_startaddr) - 24usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_vddc_mv) - 28usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_vddci_mv) - 30usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_mvddc_mv) - 32usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_vddgfx_mv) - 34usize];
    ["Offset of field: atom_firmware_info_v3_4::mem_module_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, mem_module_id) - 36usize];
    ["Offset of field: atom_firmware_info_v3_4::coolingsolution_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, coolingsolution_id) - 37usize];
    ["Offset of field: atom_firmware_info_v3_4::reserved1"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, reserved1) - 38usize];
    ["Offset of field: atom_firmware_info_v3_4::mc_baseaddr_high"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, mc_baseaddr_high) - 40usize];
    ["Offset of field: atom_firmware_info_v3_4::mc_baseaddr_low"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, mc_baseaddr_low) - 44usize];
    ["Offset of field: atom_firmware_info_v3_4::board_i2c_feature_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, board_i2c_feature_id) - 48usize];
    ["Offset of field: atom_firmware_info_v3_4::board_i2c_feature_gpio_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, board_i2c_feature_gpio_id) - 49usize];
    ["Offset of field: atom_firmware_info_v3_4::board_i2c_feature_slave_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, board_i2c_feature_slave_addr) - 50usize];
    ["Offset of field: atom_firmware_info_v3_4::ras_rom_i2c_slave_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, ras_rom_i2c_slave_addr) - 51usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_mvddq_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_mvddq_mv) - 52usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_mvpp_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_mvpp_mv) - 54usize];
    ["Offset of field: atom_firmware_info_v3_4::zfbstartaddrin16mb"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, zfbstartaddrin16mb) - 56usize];
    ["Offset of field: atom_firmware_info_v3_4::pplib_pptable_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, pplib_pptable_id) - 60usize];
    ["Offset of field: atom_firmware_info_v3_4::mvdd_ratio"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, mvdd_ratio) - 64usize];
    ["Offset of field: atom_firmware_info_v3_4::hw_bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, hw_bootup_vddgfx_mv) - 68usize];
    ["Offset of field: atom_firmware_info_v3_4::hw_bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, hw_bootup_vddc_mv) - 70usize];
    ["Offset of field: atom_firmware_info_v3_4::hw_bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, hw_bootup_mvddc_mv) - 72usize];
    ["Offset of field: atom_firmware_info_v3_4::hw_bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, hw_bootup_vddci_mv) - 74usize];
    ["Offset of field: atom_firmware_info_v3_4::maco_pwrlimit_mw"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, maco_pwrlimit_mw) - 76usize];
    ["Offset of field: atom_firmware_info_v3_4::usb_pwrlimit_mw"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, usb_pwrlimit_mw) - 80usize];
    ["Offset of field: atom_firmware_info_v3_4::fw_reserved_size_in_kb"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, fw_reserved_size_in_kb) - 84usize];
    ["Offset of field: atom_firmware_info_v3_4::pspbl_init_done_reg_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, pspbl_init_done_reg_addr) - 88usize];
    ["Offset of field: atom_firmware_info_v3_4::pspbl_init_done_value"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, pspbl_init_done_value) - 92usize];
    ["Offset of field: atom_firmware_info_v3_4::pspbl_init_done_check_timeout"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, pspbl_init_done_check_timeout) - 96usize];
    ["Offset of field: atom_firmware_info_v3_4::reserved"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, reserved) - 100usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct lcd_info_v2_1 {
    pub table_header: atom_common_table_header,
    pub lcd_timing: atom_dtd_format,
    pub backlight_pwm: u16,
    pub special_handle_cap: u16,
    pub panel_misc: u16,
    pub lvds_max_slink_pclk: u16,
    pub lvds_ss_percentage: u16,
    pub lvds_ss_rate_10hz: u16,
    pub pwr_on_digon_to_de: u8,
    pub pwr_on_de_to_vary_bl: u8,
    pub pwr_down_vary_bloff_to_de: u8,
    pub pwr_down_de_to_digoff: u8,
    pub pwr_off_delay: u8,
    pub pwr_on_vary_bl_to_blon: u8,
    pub pwr_down_bloff_to_vary_bloff: u8,
    pub panel_bpc: u8,
    pub dpcd_edp_config_cap: u8,
    pub dpcd_max_link_rate: u8,
    pub dpcd_max_lane_count: u8,
    pub dpcd_max_downspread: u8,
    pub min_allowed_bl_level: u8,
    pub max_allowed_bl_level: u8,
    pub bootup_bl_level: u8,
    pub dplvdsrxid: u8,
    pub reserved1: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of lcd_info_v2_1"][::core::mem::size_of::<lcd_info_v2_1>() - 92usize];
    ["Alignment of lcd_info_v2_1"][::core::mem::align_of::<lcd_info_v2_1>() - 1usize];
    ["Offset of field: lcd_info_v2_1::table_header"]
        [::core::mem::offset_of!(lcd_info_v2_1, table_header) - 0usize];
    ["Offset of field: lcd_info_v2_1::lcd_timing"]
        [::core::mem::offset_of!(lcd_info_v2_1, lcd_timing) - 4usize];
    ["Offset of field: lcd_info_v2_1::backlight_pwm"]
        [::core::mem::offset_of!(lcd_info_v2_1, backlight_pwm) - 32usize];
    ["Offset of field: lcd_info_v2_1::special_handle_cap"]
        [::core::mem::offset_of!(lcd_info_v2_1, special_handle_cap) - 34usize];
    ["Offset of field: lcd_info_v2_1::panel_misc"]
        [::core::mem::offset_of!(lcd_info_v2_1, panel_misc) - 36usize];
    ["Offset of field: lcd_info_v2_1::lvds_max_slink_pclk"]
        [::core::mem::offset_of!(lcd_info_v2_1, lvds_max_slink_pclk) - 38usize];
    ["Offset of field: lcd_info_v2_1::lvds_ss_percentage"]
        [::core::mem::offset_of!(lcd_info_v2_1, lvds_ss_percentage) - 40usize];
    ["Offset of field: lcd_info_v2_1::lvds_ss_rate_10hz"]
        [::core::mem::offset_of!(lcd_info_v2_1, lvds_ss_rate_10hz) - 42usize];
    ["Offset of field: lcd_info_v2_1::pwr_on_digon_to_de"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_on_digon_to_de) - 44usize];
    ["Offset of field: lcd_info_v2_1::pwr_on_de_to_vary_bl"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_on_de_to_vary_bl) - 45usize];
    ["Offset of field: lcd_info_v2_1::pwr_down_vary_bloff_to_de"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_down_vary_bloff_to_de) - 46usize];
    ["Offset of field: lcd_info_v2_1::pwr_down_de_to_digoff"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_down_de_to_digoff) - 47usize];
    ["Offset of field: lcd_info_v2_1::pwr_off_delay"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_off_delay) - 48usize];
    ["Offset of field: lcd_info_v2_1::pwr_on_vary_bl_to_blon"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_on_vary_bl_to_blon) - 49usize];
    ["Offset of field: lcd_info_v2_1::pwr_down_bloff_to_vary_bloff"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_down_bloff_to_vary_bloff) - 50usize];
    ["Offset of field: lcd_info_v2_1::panel_bpc"]
        [::core::mem::offset_of!(lcd_info_v2_1, panel_bpc) - 51usize];
    ["Offset of field: lcd_info_v2_1::dpcd_edp_config_cap"]
        [::core::mem::offset_of!(lcd_info_v2_1, dpcd_edp_config_cap) - 52usize];
    ["Offset of field: lcd_info_v2_1::dpcd_max_link_rate"]
        [::core::mem::offset_of!(lcd_info_v2_1, dpcd_max_link_rate) - 53usize];
    ["Offset of field: lcd_info_v2_1::dpcd_max_lane_count"]
        [::core::mem::offset_of!(lcd_info_v2_1, dpcd_max_lane_count) - 54usize];
    ["Offset of field: lcd_info_v2_1::dpcd_max_downspread"]
        [::core::mem::offset_of!(lcd_info_v2_1, dpcd_max_downspread) - 55usize];
    ["Offset of field: lcd_info_v2_1::min_allowed_bl_level"]
        [::core::mem::offset_of!(lcd_info_v2_1, min_allowed_bl_level) - 56usize];
    ["Offset of field: lcd_info_v2_1::max_allowed_bl_level"]
        [::core::mem::offset_of!(lcd_info_v2_1, max_allowed_bl_level) - 57usize];
    ["Offset of field: lcd_info_v2_1::bootup_bl_level"]
        [::core::mem::offset_of!(lcd_info_v2_1, bootup_bl_level) - 58usize];
    ["Offset of field: lcd_info_v2_1::dplvdsrxid"]
        [::core::mem::offset_of!(lcd_info_v2_1, dplvdsrxid) - 59usize];
    ["Offset of field: lcd_info_v2_1::reserved1"]
        [::core::mem::offset_of!(lcd_info_v2_1, reserved1) - 60usize];
};
pub const atom_lcd_info_panel_misc_ATOM_PANEL_MISC_FPDI: atom_lcd_info_panel_misc = 2;
pub type atom_lcd_info_panel_misc = ::core::ffi::c_uint;
pub const atom_lcd_info_dptolvds_rx_id_eDP_TO_LVDS_RX_DISABLE: atom_lcd_info_dptolvds_rx_id = 0;
pub const atom_lcd_info_dptolvds_rx_id_eDP_TO_LVDS_COMMON_ID: atom_lcd_info_dptolvds_rx_id = 1;
pub const atom_lcd_info_dptolvds_rx_id_eDP_TO_LVDS_REALTEK_ID: atom_lcd_info_dptolvds_rx_id = 2;
pub type atom_lcd_info_dptolvds_rx_id = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_pin_assignment {
    pub data_a_reg_index: u32,
    pub gpio_bitshift: u8,
    pub gpio_mask_bitshift: u8,
    pub gpio_id: u8,
    pub reserved: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gpio_pin_assignment"]
        [::core::mem::size_of::<atom_gpio_pin_assignment>() - 8usize];
    ["Alignment of atom_gpio_pin_assignment"]
        [::core::mem::align_of::<atom_gpio_pin_assignment>() - 1usize];
    ["Offset of field: atom_gpio_pin_assignment::data_a_reg_index"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, data_a_reg_index) - 0usize];
    ["Offset of field: atom_gpio_pin_assignment::gpio_bitshift"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, gpio_bitshift) - 4usize];
    ["Offset of field: atom_gpio_pin_assignment::gpio_mask_bitshift"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, gpio_mask_bitshift) - 5usize];
    ["Offset of field: atom_gpio_pin_assignment::gpio_id"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, gpio_id) - 6usize];
    ["Offset of field: atom_gpio_pin_assignment::reserved"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, reserved) - 7usize];
};
pub const atom_gpio_pin_assignment_gpio_id_I2C_HW_LANE_MUX: atom_gpio_pin_assignment_gpio_id = 15;
pub const atom_gpio_pin_assignment_gpio_id_I2C_HW_ENGINE_ID_MASK: atom_gpio_pin_assignment_gpio_id =
    112;
pub const atom_gpio_pin_assignment_gpio_id_I2C_HW_CAP: atom_gpio_pin_assignment_gpio_id = 128;
pub const atom_gpio_pin_assignment_gpio_id_PCIE_VDDC_CONTROL_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 56;
pub const atom_gpio_pin_assignment_gpio_id_PP_AC_DC_SWITCH_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 60;
pub const atom_gpio_pin_assignment_gpio_id_VDDC_VRHOT_GPIO_PINID: atom_gpio_pin_assignment_gpio_id =
    61;
pub const atom_gpio_pin_assignment_gpio_id_VDDC_PCC_GPIO_PINID: atom_gpio_pin_assignment_gpio_id =
    62;
pub const atom_gpio_pin_assignment_gpio_id_EFUSE_CUT_ENABLE_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 63;
pub const atom_gpio_pin_assignment_gpio_id_DRAM_SELF_REFRESH_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 64;
pub const atom_gpio_pin_assignment_gpio_id_THERMAL_INT_OUTPUT_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 65;
pub type atom_gpio_pin_assignment_gpio_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_pin_lut_v2_1 {
    pub table_header: atom_common_table_header,
    pub gpio_pin: [atom_gpio_pin_assignment; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gpio_pin_lut_v2_1"][::core::mem::size_of::<atom_gpio_pin_lut_v2_1>() - 68usize];
    ["Alignment of atom_gpio_pin_lut_v2_1"]
        [::core::mem::align_of::<atom_gpio_pin_lut_v2_1>() - 1usize];
    ["Offset of field: atom_gpio_pin_lut_v2_1::table_header"]
        [::core::mem::offset_of!(atom_gpio_pin_lut_v2_1, table_header) - 0usize];
    ["Offset of field: atom_gpio_pin_lut_v2_1::gpio_pin"]
        [::core::mem::offset_of!(atom_gpio_pin_lut_v2_1, gpio_pin) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct vram_usagebyfirmware_v2_1 {
    pub table_header: atom_common_table_header,
    pub start_address_in_kb: u32,
    pub used_by_firmware_in_kb: u16,
    pub used_by_driver_in_kb: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vram_usagebyfirmware_v2_1"]
        [::core::mem::size_of::<vram_usagebyfirmware_v2_1>() - 12usize];
    ["Alignment of vram_usagebyfirmware_v2_1"]
        [::core::mem::align_of::<vram_usagebyfirmware_v2_1>() - 1usize];
    ["Offset of field: vram_usagebyfirmware_v2_1::table_header"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_1, table_header) - 0usize];
    ["Offset of field: vram_usagebyfirmware_v2_1::start_address_in_kb"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_1, start_address_in_kb) - 4usize];
    ["Offset of field: vram_usagebyfirmware_v2_1::used_by_firmware_in_kb"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_1, used_by_firmware_in_kb) - 8usize];
    ["Offset of field: vram_usagebyfirmware_v2_1::used_by_driver_in_kb"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_1, used_by_driver_in_kb) - 10usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct vram_usagebyfirmware_v2_2 {
    pub table_header: atom_common_table_header,
    pub fw_region_start_address_in_kb: u32,
    pub used_by_firmware_in_kb: u16,
    pub reserved: u16,
    pub driver_region0_start_address_in_kb: u32,
    pub used_by_driver_region0_in_kb: u32,
    pub reserved32: [u32; 7usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vram_usagebyfirmware_v2_2"]
        [::core::mem::size_of::<vram_usagebyfirmware_v2_2>() - 48usize];
    ["Alignment of vram_usagebyfirmware_v2_2"]
        [::core::mem::align_of::<vram_usagebyfirmware_v2_2>() - 1usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::table_header"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_2, table_header) - 0usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::fw_region_start_address_in_kb"][::core::mem::offset_of!(
        vram_usagebyfirmware_v2_2,
        fw_region_start_address_in_kb
    ) - 4usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::used_by_firmware_in_kb"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_2, used_by_firmware_in_kb) - 8usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::reserved"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_2, reserved) - 10usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::driver_region0_start_address_in_kb"][::core::mem::offset_of!(
        vram_usagebyfirmware_v2_2,
        driver_region0_start_address_in_kb
    ) - 12usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::used_by_driver_region0_in_kb"][::core::mem::offset_of!(
        vram_usagebyfirmware_v2_2,
        used_by_driver_region0_in_kb
    ) - 16usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::reserved32"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_2, reserved32) - 20usize];
};
pub const atom_object_record_type_id_ATOM_I2C_RECORD_TYPE: atom_object_record_type_id = 1;
pub const atom_object_record_type_id_ATOM_HPD_INT_RECORD_TYPE: atom_object_record_type_id = 2;
pub const atom_object_record_type_id_ATOM_CONNECTOR_CAP_RECORD_TYPE: atom_object_record_type_id = 3;
pub const atom_object_record_type_id_ATOM_CONNECTOR_SPEED_UPTO: atom_object_record_type_id = 4;
pub const atom_object_record_type_id_ATOM_OBJECT_GPIO_CNTL_RECORD_TYPE: atom_object_record_type_id =
    9;
pub const atom_object_record_type_id_ATOM_CONNECTOR_HPDPIN_LUT_RECORD_TYPE:
    atom_object_record_type_id = 16;
pub const atom_object_record_type_id_ATOM_CONNECTOR_AUXDDC_LUT_RECORD_TYPE:
    atom_object_record_type_id = 17;
pub const atom_object_record_type_id_ATOM_ENCODER_CAP_RECORD_TYPE: atom_object_record_type_id = 20;
pub const atom_object_record_type_id_ATOM_BRACKET_LAYOUT_RECORD_TYPE: atom_object_record_type_id =
    21;
pub const atom_object_record_type_id_ATOM_CONNECTOR_FORCED_TMDS_CAP_RECORD_TYPE:
    atom_object_record_type_id = 22;
pub const atom_object_record_type_id_ATOM_DISP_CONNECTOR_CAPS_RECORD_TYPE:
    atom_object_record_type_id = 23;
pub const atom_object_record_type_id_ATOM_BRACKET_LAYOUT_V2_RECORD_TYPE:
    atom_object_record_type_id = 25;
pub const atom_object_record_type_id_ATOM_RECORD_END_TYPE: atom_object_record_type_id = 255;
pub type atom_object_record_type_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_common_record_header {
    pub record_type: u8,
    pub record_size: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_common_record_header"]
        [::core::mem::size_of::<atom_common_record_header>() - 2usize];
    ["Alignment of atom_common_record_header"]
        [::core::mem::align_of::<atom_common_record_header>() - 1usize];
    ["Offset of field: atom_common_record_header::record_type"]
        [::core::mem::offset_of!(atom_common_record_header, record_type) - 0usize];
    ["Offset of field: atom_common_record_header::record_size"]
        [::core::mem::offset_of!(atom_common_record_header, record_size) - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_record {
    pub record_header: atom_common_record_header,
    pub i2c_id: u8,
    pub i2c_slave_addr: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_i2c_record"][::core::mem::size_of::<atom_i2c_record>() - 4usize];
    ["Alignment of atom_i2c_record"][::core::mem::align_of::<atom_i2c_record>() - 1usize];
    ["Offset of field: atom_i2c_record::record_header"]
        [::core::mem::offset_of!(atom_i2c_record, record_header) - 0usize];
    ["Offset of field: atom_i2c_record::i2c_id"]
        [::core::mem::offset_of!(atom_i2c_record, i2c_id) - 2usize];
    ["Offset of field: atom_i2c_record::i2c_slave_addr"]
        [::core::mem::offset_of!(atom_i2c_record, i2c_slave_addr) - 3usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_hpd_int_record {
    pub record_header: atom_common_record_header,
    pub pin_id: u8,
    pub plugin_pin_state: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_hpd_int_record"][::core::mem::size_of::<atom_hpd_int_record>() - 4usize];
    ["Alignment of atom_hpd_int_record"][::core::mem::align_of::<atom_hpd_int_record>() - 1usize];
    ["Offset of field: atom_hpd_int_record::record_header"]
        [::core::mem::offset_of!(atom_hpd_int_record, record_header) - 0usize];
    ["Offset of field: atom_hpd_int_record::pin_id"]
        [::core::mem::offset_of!(atom_hpd_int_record, pin_id) - 2usize];
    ["Offset of field: atom_hpd_int_record::plugin_pin_state"]
        [::core::mem::offset_of!(atom_hpd_int_record, plugin_pin_state) - 3usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_caps_record {
    pub record_header: atom_common_record_header,
    pub connector_caps: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_caps_record"]
        [::core::mem::size_of::<atom_connector_caps_record>() - 4usize];
    ["Alignment of atom_connector_caps_record"]
        [::core::mem::align_of::<atom_connector_caps_record>() - 1usize];
    ["Offset of field: atom_connector_caps_record::record_header"]
        [::core::mem::offset_of!(atom_connector_caps_record, record_header) - 0usize];
    ["Offset of field: atom_connector_caps_record::connector_caps"]
        [::core::mem::offset_of!(atom_connector_caps_record, connector_caps) - 2usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_speed_record {
    pub record_header: atom_common_record_header,
    pub connector_max_speed: u32,
    pub reserved: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_speed_record"]
        [::core::mem::size_of::<atom_connector_speed_record>() - 8usize];
    ["Alignment of atom_connector_speed_record"]
        [::core::mem::align_of::<atom_connector_speed_record>() - 1usize];
    ["Offset of field: atom_connector_speed_record::record_header"]
        [::core::mem::offset_of!(atom_connector_speed_record, record_header) - 0usize];
    ["Offset of field: atom_connector_speed_record::connector_max_speed"]
        [::core::mem::offset_of!(atom_connector_speed_record, connector_max_speed) - 2usize];
    ["Offset of field: atom_connector_speed_record::reserved"]
        [::core::mem::offset_of!(atom_connector_speed_record, reserved) - 6usize];
};
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HBR2: atom_encoder_caps_def = 1;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_MST_EN: atom_encoder_caps_def = 1;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HBR2_EN: atom_encoder_caps_def = 2;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HDMI6Gbps_EN: atom_encoder_caps_def = 4;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HBR3_EN: atom_encoder_caps_def = 8;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_DP2: atom_encoder_caps_def = 16;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_UHBR10_EN: atom_encoder_caps_def = 32;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_UHBR13_5_EN: atom_encoder_caps_def = 64;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_UHBR20_EN: atom_encoder_caps_def = 128;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_USB_C_TYPE: atom_encoder_caps_def = 256;
pub type atom_encoder_caps_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_encoder_caps_record {
    pub record_header: atom_common_record_header,
    pub encodercaps: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_encoder_caps_record"]
        [::core::mem::size_of::<atom_encoder_caps_record>() - 6usize];
    ["Alignment of atom_encoder_caps_record"]
        [::core::mem::align_of::<atom_encoder_caps_record>() - 1usize];
    ["Offset of field: atom_encoder_caps_record::record_header"]
        [::core::mem::offset_of!(atom_encoder_caps_record, record_header) - 0usize];
    ["Offset of field: atom_encoder_caps_record::encodercaps"]
        [::core::mem::offset_of!(atom_encoder_caps_record, encodercaps) - 2usize];
};
pub const atom_connector_caps_def_ATOM_CONNECTOR_CAP_INTERNAL_DISPLAY: atom_connector_caps_def = 1;
pub const atom_connector_caps_def_ATOM_CONNECTOR_CAP_INTERNAL_DISPLAY_BL: atom_connector_caps_def =
    2;
pub type atom_connector_caps_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_disp_connector_caps_record {
    pub record_header: atom_common_record_header,
    pub connectcaps: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_disp_connector_caps_record"]
        [::core::mem::size_of::<atom_disp_connector_caps_record>() - 6usize];
    ["Alignment of atom_disp_connector_caps_record"]
        [::core::mem::align_of::<atom_disp_connector_caps_record>() - 1usize];
    ["Offset of field: atom_disp_connector_caps_record::record_header"]
        [::core::mem::offset_of!(atom_disp_connector_caps_record, record_header) - 0usize];
    ["Offset of field: atom_disp_connector_caps_record::connectcaps"]
        [::core::mem::offset_of!(atom_disp_connector_caps_record, connectcaps) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_pin_control_pair {
    pub gpio_id: u8,
    pub gpio_pinstate: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gpio_pin_control_pair"]
        [::core::mem::size_of::<atom_gpio_pin_control_pair>() - 2usize];
    ["Alignment of atom_gpio_pin_control_pair"]
        [::core::mem::align_of::<atom_gpio_pin_control_pair>() - 1usize];
    ["Offset of field: atom_gpio_pin_control_pair::gpio_id"]
        [::core::mem::offset_of!(atom_gpio_pin_control_pair, gpio_id) - 0usize];
    ["Offset of field: atom_gpio_pin_control_pair::gpio_pinstate"]
        [::core::mem::offset_of!(atom_gpio_pin_control_pair, gpio_pinstate) - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_object_gpio_cntl_record {
    pub record_header: atom_common_record_header,
    pub flag: u8,
    pub number_of_pins: u8,
    pub gpio: [atom_gpio_pin_control_pair; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_object_gpio_cntl_record"]
        [::core::mem::size_of::<atom_object_gpio_cntl_record>() - 6usize];
    ["Alignment of atom_object_gpio_cntl_record"]
        [::core::mem::align_of::<atom_object_gpio_cntl_record>() - 1usize];
    ["Offset of field: atom_object_gpio_cntl_record::record_header"]
        [::core::mem::offset_of!(atom_object_gpio_cntl_record, record_header) - 0usize];
    ["Offset of field: atom_object_gpio_cntl_record::flag"]
        [::core::mem::offset_of!(atom_object_gpio_cntl_record, flag) - 2usize];
    ["Offset of field: atom_object_gpio_cntl_record::number_of_pins"]
        [::core::mem::offset_of!(atom_object_gpio_cntl_record, number_of_pins) - 3usize];
    ["Offset of field: atom_object_gpio_cntl_record::gpio"]
        [::core::mem::offset_of!(atom_object_gpio_cntl_record, gpio) - 4usize];
};
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_TYPE_INPUT:
    atom_gpio_pin_control_pinstate_def = 0;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_TYPE_OUTPUT:
    atom_gpio_pin_control_pinstate_def = 16;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_TYPE_HW_CONTROL:
    atom_gpio_pin_control_pinstate_def = 32;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_OUTPUT_STATE_MASK:
    atom_gpio_pin_control_pinstate_def = 1;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_OUTPUT_STATE_SHIFT:
    atom_gpio_pin_control_pinstate_def = 0;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_STATE_ACTIVE_LOW:
    atom_gpio_pin_control_pinstate_def = 0;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_STATE_ACTIVE_HIGH:
    atom_gpio_pin_control_pinstate_def = 1;
pub type atom_gpio_pin_control_pinstate_def = ::core::ffi::c_uint;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_REFCLK:
    atom_glsync_record_gpio_index_def = 0;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_HSYNC:
    atom_glsync_record_gpio_index_def = 1;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_VSYNC:
    atom_glsync_record_gpio_index_def = 2;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_REQ:
    atom_glsync_record_gpio_index_def = 3;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_GNT:
    atom_glsync_record_gpio_index_def = 4;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_INTERRUPT:
    atom_glsync_record_gpio_index_def = 5;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_V_RESET:
    atom_glsync_record_gpio_index_def = 6;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_CNTL:
    atom_glsync_record_gpio_index_def = 7;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_SEL:
    atom_glsync_record_gpio_index_def = 8;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_MAX:
    atom_glsync_record_gpio_index_def = 9;
pub type atom_glsync_record_gpio_index_def = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_hpdpin_lut_record {
    pub record_header: atom_common_record_header,
    pub hpd_pin_map: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_hpdpin_lut_record"]
        [::core::mem::size_of::<atom_connector_hpdpin_lut_record>() - 10usize];
    ["Alignment of atom_connector_hpdpin_lut_record"]
        [::core::mem::align_of::<atom_connector_hpdpin_lut_record>() - 1usize];
    ["Offset of field: atom_connector_hpdpin_lut_record::record_header"]
        [::core::mem::offset_of!(atom_connector_hpdpin_lut_record, record_header) - 0usize];
    ["Offset of field: atom_connector_hpdpin_lut_record::hpd_pin_map"]
        [::core::mem::offset_of!(atom_connector_hpdpin_lut_record, hpd_pin_map) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_auxddc_lut_record {
    pub record_header: atom_common_record_header,
    pub aux_ddc_map: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_auxddc_lut_record"]
        [::core::mem::size_of::<atom_connector_auxddc_lut_record>() - 10usize];
    ["Alignment of atom_connector_auxddc_lut_record"]
        [::core::mem::align_of::<atom_connector_auxddc_lut_record>() - 1usize];
    ["Offset of field: atom_connector_auxddc_lut_record::record_header"]
        [::core::mem::offset_of!(atom_connector_auxddc_lut_record, record_header) - 0usize];
    ["Offset of field: atom_connector_auxddc_lut_record::aux_ddc_map"]
        [::core::mem::offset_of!(atom_connector_auxddc_lut_record, aux_ddc_map) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_forced_tmds_cap_record {
    pub record_header: atom_common_record_header,
    pub maxtmdsclkrate_in2_5mhz: u8,
    pub reserved: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_forced_tmds_cap_record"]
        [::core::mem::size_of::<atom_connector_forced_tmds_cap_record>() - 4usize];
    ["Alignment of atom_connector_forced_tmds_cap_record"]
        [::core::mem::align_of::<atom_connector_forced_tmds_cap_record>() - 1usize];
    ["Offset of field: atom_connector_forced_tmds_cap_record::record_header"]
        [::core::mem::offset_of!(atom_connector_forced_tmds_cap_record, record_header) - 0usize];
    ["Offset of field: atom_connector_forced_tmds_cap_record::maxtmdsclkrate_in2_5mhz"][::core::mem::offset_of!(
        atom_connector_forced_tmds_cap_record,
        maxtmdsclkrate_in2_5mhz
    ) - 2usize];
    ["Offset of field: atom_connector_forced_tmds_cap_record::reserved"]
        [::core::mem::offset_of!(atom_connector_forced_tmds_cap_record, reserved) - 3usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_layout_info {
    pub connectorobjid: u16,
    pub connector_type: u8,
    pub position: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_layout_info"]
        [::core::mem::size_of::<atom_connector_layout_info>() - 4usize];
    ["Alignment of atom_connector_layout_info"]
        [::core::mem::align_of::<atom_connector_layout_info>() - 1usize];
    ["Offset of field: atom_connector_layout_info::connectorobjid"]
        [::core::mem::offset_of!(atom_connector_layout_info, connectorobjid) - 0usize];
    ["Offset of field: atom_connector_layout_info::connector_type"]
        [::core::mem::offset_of!(atom_connector_layout_info, connector_type) - 2usize];
    ["Offset of field: atom_connector_layout_info::position"]
        [::core::mem::offset_of!(atom_connector_layout_info, position) - 3usize];
};
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_DVI_D:
    atom_connector_layout_info_connector_type_def = 1;
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_HDMI:
    atom_connector_layout_info_connector_type_def = 4;
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_DISPLAY_PORT:
    atom_connector_layout_info_connector_type_def = 5;
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_MINI_DISPLAY_PORT:
    atom_connector_layout_info_connector_type_def = 6;
pub type atom_connector_layout_info_connector_type_def = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_bracket_layout_record {
    pub record_header: atom_common_record_header,
    pub bracketlen: u8,
    pub bracketwidth: u8,
    pub conn_num: u8,
    pub reserved: u8,
    pub conn_info: [atom_connector_layout_info; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_bracket_layout_record"]
        [::core::mem::size_of::<atom_bracket_layout_record>() - 10usize];
    ["Alignment of atom_bracket_layout_record"]
        [::core::mem::align_of::<atom_bracket_layout_record>() - 1usize];
    ["Offset of field: atom_bracket_layout_record::record_header"]
        [::core::mem::offset_of!(atom_bracket_layout_record, record_header) - 0usize];
    ["Offset of field: atom_bracket_layout_record::bracketlen"]
        [::core::mem::offset_of!(atom_bracket_layout_record, bracketlen) - 2usize];
    ["Offset of field: atom_bracket_layout_record::bracketwidth"]
        [::core::mem::offset_of!(atom_bracket_layout_record, bracketwidth) - 3usize];
    ["Offset of field: atom_bracket_layout_record::conn_num"]
        [::core::mem::offset_of!(atom_bracket_layout_record, conn_num) - 4usize];
    ["Offset of field: atom_bracket_layout_record::reserved"]
        [::core::mem::offset_of!(atom_bracket_layout_record, reserved) - 5usize];
    ["Offset of field: atom_bracket_layout_record::conn_info"]
        [::core::mem::offset_of!(atom_bracket_layout_record, conn_info) - 6usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_bracket_layout_record_v2 {
    pub record_header: atom_common_record_header,
    pub bracketlen: u8,
    pub bracketwidth: u8,
    pub conn_num: u8,
    pub mini_type: u8,
    pub reserved1: u8,
    pub reserved2: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_bracket_layout_record_v2"]
        [::core::mem::size_of::<atom_bracket_layout_record_v2>() - 8usize];
    ["Alignment of atom_bracket_layout_record_v2"]
        [::core::mem::align_of::<atom_bracket_layout_record_v2>() - 1usize];
    ["Offset of field: atom_bracket_layout_record_v2::record_header"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, record_header) - 0usize];
    ["Offset of field: atom_bracket_layout_record_v2::bracketlen"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, bracketlen) - 2usize];
    ["Offset of field: atom_bracket_layout_record_v2::bracketwidth"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, bracketwidth) - 3usize];
    ["Offset of field: atom_bracket_layout_record_v2::conn_num"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, conn_num) - 4usize];
    ["Offset of field: atom_bracket_layout_record_v2::mini_type"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, mini_type) - 5usize];
    ["Offset of field: atom_bracket_layout_record_v2::reserved1"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, reserved1) - 6usize];
    ["Offset of field: atom_bracket_layout_record_v2::reserved2"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, reserved2) - 7usize];
};
pub const atom_connector_layout_info_mini_type_def_MINI_TYPE_NORMAL:
    atom_connector_layout_info_mini_type_def = 0;
pub const atom_connector_layout_info_mini_type_def_MINI_TYPE_MINI:
    atom_connector_layout_info_mini_type_def = 1;
pub type atom_connector_layout_info_mini_type_def = ::core::ffi::c_uint;
pub const atom_display_device_tag_def_ATOM_DISPLAY_LCD1_SUPPORT: atom_display_device_tag_def = 2;
pub const atom_display_device_tag_def_ATOM_DISPLAY_LCD2_SUPPORT: atom_display_device_tag_def = 32;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP1_SUPPORT: atom_display_device_tag_def = 8;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP2_SUPPORT: atom_display_device_tag_def = 128;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP3_SUPPORT: atom_display_device_tag_def = 512;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP4_SUPPORT: atom_display_device_tag_def = 1024;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP5_SUPPORT: atom_display_device_tag_def = 2048;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP6_SUPPORT: atom_display_device_tag_def = 64;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFPx_SUPPORT: atom_display_device_tag_def = 3784;
pub type atom_display_device_tag_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_object_path_v2 {
    pub display_objid: u16,
    pub disp_recordoffset: u16,
    pub encoderobjid: u16,
    pub extencoderobjid: u16,
    pub encoder_recordoffset: u16,
    pub extencoder_recordoffset: u16,
    pub device_tag: u16,
    pub priority_id: u8,
    pub reserved: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_object_path_v2"]
        [::core::mem::size_of::<atom_display_object_path_v2>() - 16usize];
    ["Alignment of atom_display_object_path_v2"]
        [::core::mem::align_of::<atom_display_object_path_v2>() - 1usize];
    ["Offset of field: atom_display_object_path_v2::display_objid"]
        [::core::mem::offset_of!(atom_display_object_path_v2, display_objid) - 0usize];
    ["Offset of field: atom_display_object_path_v2::disp_recordoffset"]
        [::core::mem::offset_of!(atom_display_object_path_v2, disp_recordoffset) - 2usize];
    ["Offset of field: atom_display_object_path_v2::encoderobjid"]
        [::core::mem::offset_of!(atom_display_object_path_v2, encoderobjid) - 4usize];
    ["Offset of field: atom_display_object_path_v2::extencoderobjid"]
        [::core::mem::offset_of!(atom_display_object_path_v2, extencoderobjid) - 6usize];
    ["Offset of field: atom_display_object_path_v2::encoder_recordoffset"]
        [::core::mem::offset_of!(atom_display_object_path_v2, encoder_recordoffset) - 8usize];
    ["Offset of field: atom_display_object_path_v2::extencoder_recordoffset"]
        [::core::mem::offset_of!(atom_display_object_path_v2, extencoder_recordoffset) - 10usize];
    ["Offset of field: atom_display_object_path_v2::device_tag"]
        [::core::mem::offset_of!(atom_display_object_path_v2, device_tag) - 12usize];
    ["Offset of field: atom_display_object_path_v2::priority_id"]
        [::core::mem::offset_of!(atom_display_object_path_v2, priority_id) - 14usize];
    ["Offset of field: atom_display_object_path_v2::reserved"]
        [::core::mem::offset_of!(atom_display_object_path_v2, reserved) - 15usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_object_path_v3 {
    pub display_objid: u16,
    pub disp_recordoffset: u16,
    pub encoderobjid: u16,
    pub reserved1: u16,
    pub reserved2: u16,
    pub reserved3: u16,
    pub device_tag: u16,
    pub reserved4: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_object_path_v3"]
        [::core::mem::size_of::<atom_display_object_path_v3>() - 16usize];
    ["Alignment of atom_display_object_path_v3"]
        [::core::mem::align_of::<atom_display_object_path_v3>() - 1usize];
    ["Offset of field: atom_display_object_path_v3::display_objid"]
        [::core::mem::offset_of!(atom_display_object_path_v3, display_objid) - 0usize];
    ["Offset of field: atom_display_object_path_v3::disp_recordoffset"]
        [::core::mem::offset_of!(atom_display_object_path_v3, disp_recordoffset) - 2usize];
    ["Offset of field: atom_display_object_path_v3::encoderobjid"]
        [::core::mem::offset_of!(atom_display_object_path_v3, encoderobjid) - 4usize];
    ["Offset of field: atom_display_object_path_v3::reserved1"]
        [::core::mem::offset_of!(atom_display_object_path_v3, reserved1) - 6usize];
    ["Offset of field: atom_display_object_path_v3::reserved2"]
        [::core::mem::offset_of!(atom_display_object_path_v3, reserved2) - 8usize];
    ["Offset of field: atom_display_object_path_v3::reserved3"]
        [::core::mem::offset_of!(atom_display_object_path_v3, reserved3) - 10usize];
    ["Offset of field: atom_display_object_path_v3::device_tag"]
        [::core::mem::offset_of!(atom_display_object_path_v3, device_tag) - 12usize];
    ["Offset of field: atom_display_object_path_v3::reserved4"]
        [::core::mem::offset_of!(atom_display_object_path_v3, reserved4) - 14usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct display_object_info_table_v1_4 {
    pub table_header: atom_common_table_header,
    pub supporteddevices: u16,
    pub number_of_path: u8,
    pub reserved: u8,
    pub display_path: [atom_display_object_path_v2; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of display_object_info_table_v1_4"]
        [::core::mem::size_of::<display_object_info_table_v1_4>() - 136usize];
    ["Alignment of display_object_info_table_v1_4"]
        [::core::mem::align_of::<display_object_info_table_v1_4>() - 1usize];
    ["Offset of field: display_object_info_table_v1_4::table_header"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, table_header) - 0usize];
    ["Offset of field: display_object_info_table_v1_4::supporteddevices"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, supporteddevices) - 4usize];
    ["Offset of field: display_object_info_table_v1_4::number_of_path"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, number_of_path) - 6usize];
    ["Offset of field: display_object_info_table_v1_4::reserved"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, reserved) - 7usize];
    ["Offset of field: display_object_info_table_v1_4::display_path"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, display_path) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct display_object_info_table_v1_5 {
    pub table_header: atom_common_table_header,
    pub supporteddevices: u16,
    pub number_of_path: u8,
    pub reserved: u8,
    pub display_path: [atom_display_object_path_v3; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of display_object_info_table_v1_5"]
        [::core::mem::size_of::<display_object_info_table_v1_5>() - 136usize];
    ["Alignment of display_object_info_table_v1_5"]
        [::core::mem::align_of::<display_object_info_table_v1_5>() - 1usize];
    ["Offset of field: display_object_info_table_v1_5::table_header"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, table_header) - 0usize];
    ["Offset of field: display_object_info_table_v1_5::supporteddevices"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, supporteddevices) - 4usize];
    ["Offset of field: display_object_info_table_v1_5::number_of_path"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, number_of_path) - 6usize];
    ["Offset of field: display_object_info_table_v1_5::reserved"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, reserved) - 7usize];
    ["Offset of field: display_object_info_table_v1_5::display_path"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, display_path) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub hardcode_mode_num: u8,
    pub reserved1: [u8; 3usize],
    pub dpphy_refclk_10khz: u16,
    pub reserved2: u16,
    pub dceip_min_ver: u8,
    pub dceip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub reserved3: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_1"]
        [::core::mem::size_of::<atom_display_controller_info_v4_1>() - 56usize];
    ["Alignment of atom_display_controller_info_v4_1"]
        [::core::mem::align_of::<atom_display_controller_info_v4_1>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_1::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_1::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_1::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_1::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_1::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_1,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_1::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_1::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_1::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_1::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_1::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_1::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_1::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_1::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_1::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_1::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_1::hardcode_mode_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, hardcode_mode_num) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_1::reserved1"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, reserved1) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_1::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_1::reserved2"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, reserved2) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_1::dceip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dceip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_1::dceip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dceip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_vbios_active_disp_pipe_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_1,
        max_vbios_active_disp_pipe_num
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_1::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_1::reserved3"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, reserved3) - 48usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_2 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub reserved2: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub reserved3: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_2"]
        [::core::mem::size_of::<atom_display_controller_info_v4_2>() - 56usize];
    ["Alignment of atom_display_controller_info_v4_2"]
        [::core::mem::align_of::<atom_display_controller_info_v4_2>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_2::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_2::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_2::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_2::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_2::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_2::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_2::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_2::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_2::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_2::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_2::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_2::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_2::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_2::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_2::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_2::dfp_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        dfp_hardcode_mode_num
    ) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_2::dfp_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        dfp_hardcode_refreshrate
    ) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_2::vga_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        vga_hardcode_mode_num
    ) - 34usize];
    ["Offset of field: atom_display_controller_info_v4_2::vga_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        vga_hardcode_refreshrate
    ) - 35usize];
    ["Offset of field: atom_display_controller_info_v4_2::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_2::reserved2"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, reserved2) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_2::dcnip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dcnip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_2::dcnip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dcnip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_vbios_active_disp_pipe_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        max_vbios_active_disp_pipe_num
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_2::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_2::reserved3"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, reserved3) - 48usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_3 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub reserved2: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub reserved3: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_3"]
        [::core::mem::size_of::<atom_display_controller_info_v4_3>() - 56usize];
    ["Alignment of atom_display_controller_info_v4_3"]
        [::core::mem::align_of::<atom_display_controller_info_v4_3>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_3::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_3::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_3::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_3::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_3::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_3::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_3::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_3::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_3::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_3::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_3::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_3::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_3::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_3::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_3::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_3::dfp_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        dfp_hardcode_mode_num
    ) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_3::dfp_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        dfp_hardcode_refreshrate
    ) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_3::vga_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        vga_hardcode_mode_num
    ) - 34usize];
    ["Offset of field: atom_display_controller_info_v4_3::vga_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        vga_hardcode_refreshrate
    ) - 35usize];
    ["Offset of field: atom_display_controller_info_v4_3::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_3::reserved2"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, reserved2) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_3::dcnip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dcnip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_3::dcnip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dcnip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_vbios_active_disp_pipe_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        max_vbios_active_disp_pipe_num
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_3::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_3::reserved3"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, reserved3) - 48usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_4 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub hw_chip_id: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipum: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub dispclk_pll_vco_freq: u32,
    pub dp_ref_clk_freq: u32,
    pub max_mclk_chg_lat: u32,
    pub max_sr_exit_lat: u32,
    pub max_sr_enter_exit_lat: u32,
    pub dc_golden_table_offset: u16,
    pub dc_golden_table_ver: u16,
    pub reserved3: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_4"]
        [::core::mem::size_of::<atom_display_controller_info_v4_4>() - 84usize];
    ["Alignment of atom_display_controller_info_v4_4"]
        [::core::mem::align_of::<atom_display_controller_info_v4_4>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_4::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_4::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_4::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_4::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_4::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_4::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_4::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_4::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_4::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_4::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_4::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_4::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_4::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_4::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_4::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_4::dfp_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        dfp_hardcode_mode_num
    ) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_4::dfp_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        dfp_hardcode_refreshrate
    ) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_4::vga_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        vga_hardcode_mode_num
    ) - 34usize];
    ["Offset of field: atom_display_controller_info_v4_4::vga_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        vga_hardcode_refreshrate
    ) - 35usize];
    ["Offset of field: atom_display_controller_info_v4_4::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_4::hw_chip_id"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, hw_chip_id) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_4::dcnip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dcnip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_4::dcnip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dcnip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_vbios_active_disp_pipum"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        max_vbios_active_disp_pipum
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_4::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_4::dispclk_pll_vco_freq"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        dispclk_pll_vco_freq
    ) - 48usize];
    ["Offset of field: atom_display_controller_info_v4_4::dp_ref_clk_freq"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dp_ref_clk_freq) - 52usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_mclk_chg_lat"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_mclk_chg_lat) - 56usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_sr_exit_lat"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_sr_exit_lat) - 60usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_sr_enter_exit_lat"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        max_sr_enter_exit_lat
    ) - 64usize];
    ["Offset of field: atom_display_controller_info_v4_4::dc_golden_table_offset"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        dc_golden_table_offset
    ) - 68usize];
    ["Offset of field: atom_display_controller_info_v4_4::dc_golden_table_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dc_golden_table_ver) - 70usize];
    ["Offset of field: atom_display_controller_info_v4_4::reserved3"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, reserved3) - 72usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_dc_golden_table_v1 {
    pub aux_dphy_rx_control0_val: u32,
    pub aux_dphy_tx_control_val: u32,
    pub aux_dphy_rx_control1_val: u32,
    pub dc_gpio_aux_ctrl_0_val: u32,
    pub dc_gpio_aux_ctrl_1_val: u32,
    pub dc_gpio_aux_ctrl_2_val: u32,
    pub dc_gpio_aux_ctrl_3_val: u32,
    pub dc_gpio_aux_ctrl_4_val: u32,
    pub dc_gpio_aux_ctrl_5_val: u32,
    pub reserved: [u32; 23usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_dc_golden_table_v1"]
        [::core::mem::size_of::<atom_dc_golden_table_v1>() - 128usize];
    ["Alignment of atom_dc_golden_table_v1"]
        [::core::mem::align_of::<atom_dc_golden_table_v1>() - 1usize];
    ["Offset of field: atom_dc_golden_table_v1::aux_dphy_rx_control0_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, aux_dphy_rx_control0_val) - 0usize];
    ["Offset of field: atom_dc_golden_table_v1::aux_dphy_tx_control_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, aux_dphy_tx_control_val) - 4usize];
    ["Offset of field: atom_dc_golden_table_v1::aux_dphy_rx_control1_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, aux_dphy_rx_control1_val) - 8usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_0_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_0_val) - 12usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_1_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_1_val) - 16usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_2_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_2_val) - 20usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_3_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_3_val) - 24usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_4_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_4_val) - 28usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_5_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_5_val) - 32usize];
    ["Offset of field: atom_dc_golden_table_v1::reserved"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, reserved) - 36usize];
};
pub const dce_info_caps_def_DCE_INFO_CAPS_FORCE_DISPDEV_CONNECTED: dce_info_caps_def = 2;
pub const dce_info_caps_def_DCE_INFO_CAPS_DISABLE_DFP_DP_HBR2: dce_info_caps_def = 4;
pub const dce_info_caps_def_DCE_INFO_CAPS_ENABLE_INTERLAC_TIMING: dce_info_caps_def = 8;
pub const dce_info_caps_def_DCE_INFO_CAPS_LTTPR_SUPPORT_ENABLE: dce_info_caps_def = 32;
pub const dce_info_caps_def_DCE_INFO_CAPS_VBIOS_LTTPR_TRANSPARENT_ENABLE: dce_info_caps_def = 64;
pub type dce_info_caps_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_5 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub hw_chip_id: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub dispclk_pll_vco_freq: u32,
    pub dp_ref_clk_freq: u32,
    pub max_mclk_chg_lat: u32,
    pub max_sr_exit_lat: u32,
    pub max_sr_enter_exit_lat: u32,
    pub dc_golden_table_offset: u16,
    pub dc_golden_table_ver: u16,
    pub aux_dphy_rx_control0_val: u32,
    pub aux_dphy_tx_control_val: u32,
    pub aux_dphy_rx_control1_val: u32,
    pub dc_gpio_aux_ctrl_0_val: u32,
    pub dc_gpio_aux_ctrl_1_val: u32,
    pub dc_gpio_aux_ctrl_2_val: u32,
    pub dc_gpio_aux_ctrl_3_val: u32,
    pub dc_gpio_aux_ctrl_4_val: u32,
    pub dc_gpio_aux_ctrl_5_val: u32,
    pub reserved: [u32; 26usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_5"]
        [::core::mem::size_of::<atom_display_controller_info_v4_5>() - 212usize];
    ["Alignment of atom_display_controller_info_v4_5"]
        [::core::mem::align_of::<atom_display_controller_info_v4_5>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_5::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_5::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_5::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_5::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_5::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_5::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_5::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_5::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_5::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_5::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_5::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_5::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_5::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_5::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_5::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_5::dfp_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dfp_hardcode_mode_num
    ) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_5::dfp_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dfp_hardcode_refreshrate
    ) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_5::vga_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        vga_hardcode_mode_num
    ) - 34usize];
    ["Offset of field: atom_display_controller_info_v4_5::vga_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        vga_hardcode_refreshrate
    ) - 35usize];
    ["Offset of field: atom_display_controller_info_v4_5::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_5::hw_chip_id"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, hw_chip_id) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_5::dcnip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dcnip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_5::dcnip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dcnip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_vbios_active_disp_pipe_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        max_vbios_active_disp_pipe_num
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_5::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_5::dispclk_pll_vco_freq"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dispclk_pll_vco_freq
    ) - 48usize];
    ["Offset of field: atom_display_controller_info_v4_5::dp_ref_clk_freq"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dp_ref_clk_freq) - 52usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_mclk_chg_lat"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_mclk_chg_lat) - 56usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_sr_exit_lat"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_sr_exit_lat) - 60usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_sr_enter_exit_lat"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        max_sr_enter_exit_lat
    ) - 64usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_golden_table_offset"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_golden_table_offset
    ) - 68usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_golden_table_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dc_golden_table_ver) - 70usize];
    ["Offset of field: atom_display_controller_info_v4_5::aux_dphy_rx_control0_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        aux_dphy_rx_control0_val
    ) - 72usize];
    ["Offset of field: atom_display_controller_info_v4_5::aux_dphy_tx_control_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        aux_dphy_tx_control_val
    ) - 76usize];
    ["Offset of field: atom_display_controller_info_v4_5::aux_dphy_rx_control1_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        aux_dphy_rx_control1_val
    ) - 80usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_0_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_0_val
    ) - 84usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_1_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_1_val
    ) - 88usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_2_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_2_val
    ) - 92usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_3_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_3_val
    ) - 96usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_4_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_4_val
    ) - 100usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_5_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_5_val
    ) - 104usize];
    ["Offset of field: atom_display_controller_info_v4_5::reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, reserved) - 108usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_ext_display_path {
    pub device_tag: u16,
    pub device_acpi_enum: u16,
    pub connectorobjid: u16,
    pub auxddclut_index: u8,
    pub hpdlut_index: u8,
    pub ext_encoder_objid: u16,
    pub channelmapping: u8,
    pub chpninvert: u8,
    pub caps: u16,
    pub reserved: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_ext_display_path"][::core::mem::size_of::<atom_ext_display_path>() - 16usize];
    ["Alignment of atom_ext_display_path"]
        [::core::mem::align_of::<atom_ext_display_path>() - 1usize];
    ["Offset of field: atom_ext_display_path::device_tag"]
        [::core::mem::offset_of!(atom_ext_display_path, device_tag) - 0usize];
    ["Offset of field: atom_ext_display_path::device_acpi_enum"]
        [::core::mem::offset_of!(atom_ext_display_path, device_acpi_enum) - 2usize];
    ["Offset of field: atom_ext_display_path::connectorobjid"]
        [::core::mem::offset_of!(atom_ext_display_path, connectorobjid) - 4usize];
    ["Offset of field: atom_ext_display_path::auxddclut_index"]
        [::core::mem::offset_of!(atom_ext_display_path, auxddclut_index) - 6usize];
    ["Offset of field: atom_ext_display_path::hpdlut_index"]
        [::core::mem::offset_of!(atom_ext_display_path, hpdlut_index) - 7usize];
    ["Offset of field: atom_ext_display_path::ext_encoder_objid"]
        [::core::mem::offset_of!(atom_ext_display_path, ext_encoder_objid) - 8usize];
    ["Offset of field: atom_ext_display_path::channelmapping"]
        [::core::mem::offset_of!(atom_ext_display_path, channelmapping) - 10usize];
    ["Offset of field: atom_ext_display_path::chpninvert"]
        [::core::mem::offset_of!(atom_ext_display_path, chpninvert) - 11usize];
    ["Offset of field: atom_ext_display_path::caps"]
        [::core::mem::offset_of!(atom_ext_display_path, caps) - 12usize];
    ["Offset of field: atom_ext_display_path::reserved"]
        [::core::mem::offset_of!(atom_ext_display_path, reserved) - 14usize];
};
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HBR2_DISABLE: ext_display_path_cap_def =
    1;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__DP_FIXED_VS_EN: ext_display_path_cap_def =
    2;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__EXT_CHIP_MASK: ext_display_path_cap_def =
    124;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HDMI20_PI3EQX1204:
    ext_display_path_cap_def = 4;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HDMI20_TISN65DP159RSBT:
    ext_display_path_cap_def = 8;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HDMI20_PARADE_PS175:
    ext_display_path_cap_def = 12;
pub type ext_display_path_cap_def = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_external_display_connection_info {
    pub table_header: atom_common_table_header,
    pub guid: [u8; 16usize],
    pub path: [atom_ext_display_path; 7usize],
    pub checksum: u8,
    pub stereopinid: u8,
    pub remotedisplayconfig: u8,
    pub edptolvdsrxid: u8,
    pub fixdpvoltageswing: u8,
    pub reserved: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_external_display_connection_info"]
        [::core::mem::size_of::<atom_external_display_connection_info>() - 140usize];
    ["Alignment of atom_external_display_connection_info"]
        [::core::mem::align_of::<atom_external_display_connection_info>() - 1usize];
    ["Offset of field: atom_external_display_connection_info::table_header"]
        [::core::mem::offset_of!(atom_external_display_connection_info, table_header) - 0usize];
    ["Offset of field: atom_external_display_connection_info::guid"]
        [::core::mem::offset_of!(atom_external_display_connection_info, guid) - 4usize];
    ["Offset of field: atom_external_display_connection_info::path"]
        [::core::mem::offset_of!(atom_external_display_connection_info, path) - 20usize];
    ["Offset of field: atom_external_display_connection_info::checksum"]
        [::core::mem::offset_of!(atom_external_display_connection_info, checksum) - 132usize];
    ["Offset of field: atom_external_display_connection_info::stereopinid"]
        [::core::mem::offset_of!(atom_external_display_connection_info, stereopinid) - 133usize];
    ["Offset of field: atom_external_display_connection_info::remotedisplayconfig"][::core::mem::offset_of!(
        atom_external_display_connection_info,
        remotedisplayconfig
    ) - 134usize];
    ["Offset of field: atom_external_display_connection_info::edptolvdsrxid"]
        [::core::mem::offset_of!(atom_external_display_connection_info, edptolvdsrxid) - 135usize];
    ["Offset of field: atom_external_display_connection_info::fixdpvoltageswing"][::core::mem::offset_of!(
        atom_external_display_connection_info,
        fixdpvoltageswing
    ) - 136usize];
    ["Offset of field: atom_external_display_connection_info::reserved"]
        [::core::mem::offset_of!(atom_external_display_connection_info, reserved) - 137usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_dphy_timing_param {
    pub profile_id: u8,
    pub param: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_dphy_timing_param"]
        [::core::mem::size_of::<atom_camera_dphy_timing_param>() - 5usize];
    ["Alignment of atom_camera_dphy_timing_param"]
        [::core::mem::align_of::<atom_camera_dphy_timing_param>() - 1usize];
    ["Offset of field: atom_camera_dphy_timing_param::profile_id"]
        [::core::mem::offset_of!(atom_camera_dphy_timing_param, profile_id) - 0usize];
    ["Offset of field: atom_camera_dphy_timing_param::param"]
        [::core::mem::offset_of!(atom_camera_dphy_timing_param, param) - 1usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_dphy_elec_param {
    pub param: [u16; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_dphy_elec_param"]
        [::core::mem::size_of::<atom_camera_dphy_elec_param>() - 6usize];
    ["Alignment of atom_camera_dphy_elec_param"]
        [::core::mem::align_of::<atom_camera_dphy_elec_param>() - 1usize];
    ["Offset of field: atom_camera_dphy_elec_param::param"]
        [::core::mem::offset_of!(atom_camera_dphy_elec_param, param) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_module_info {
    pub module_id: u8,
    pub module_name: [u8; 8usize],
    pub timingparam: [atom_camera_dphy_timing_param; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_module_info"]
        [::core::mem::size_of::<atom_camera_module_info>() - 39usize];
    ["Alignment of atom_camera_module_info"]
        [::core::mem::align_of::<atom_camera_module_info>() - 1usize];
    ["Offset of field: atom_camera_module_info::module_id"]
        [::core::mem::offset_of!(atom_camera_module_info, module_id) - 0usize];
    ["Offset of field: atom_camera_module_info::module_name"]
        [::core::mem::offset_of!(atom_camera_module_info, module_name) - 1usize];
    ["Offset of field: atom_camera_module_info::timingparam"]
        [::core::mem::offset_of!(atom_camera_module_info, timingparam) - 9usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_flashlight_info {
    pub flashlight_id: u8,
    pub name: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_flashlight_info"]
        [::core::mem::size_of::<atom_camera_flashlight_info>() - 9usize];
    ["Alignment of atom_camera_flashlight_info"]
        [::core::mem::align_of::<atom_camera_flashlight_info>() - 1usize];
    ["Offset of field: atom_camera_flashlight_info::flashlight_id"]
        [::core::mem::offset_of!(atom_camera_flashlight_info, flashlight_id) - 0usize];
    ["Offset of field: atom_camera_flashlight_info::name"]
        [::core::mem::offset_of!(atom_camera_flashlight_info, name) - 1usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_data {
    pub versionCode: u32,
    pub cameraInfo: [atom_camera_module_info; 3usize],
    pub flashInfo: atom_camera_flashlight_info,
    pub dphy_param: atom_camera_dphy_elec_param,
    pub crc_val: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_data"][::core::mem::size_of::<atom_camera_data>() - 140usize];
    ["Alignment of atom_camera_data"][::core::mem::align_of::<atom_camera_data>() - 1usize];
    ["Offset of field: atom_camera_data::versionCode"]
        [::core::mem::offset_of!(atom_camera_data, versionCode) - 0usize];
    ["Offset of field: atom_camera_data::cameraInfo"]
        [::core::mem::offset_of!(atom_camera_data, cameraInfo) - 4usize];
    ["Offset of field: atom_camera_data::flashInfo"]
        [::core::mem::offset_of!(atom_camera_data, flashInfo) - 121usize];
    ["Offset of field: atom_camera_data::dphy_param"]
        [::core::mem::offset_of!(atom_camera_data, dphy_param) - 130usize];
    ["Offset of field: atom_camera_data::crc_val"]
        [::core::mem::offset_of!(atom_camera_data, crc_val) - 136usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dpphy_dvihdmi_tuningset {
    pub max_symclk_in10khz: u32,
    pub encoder_mode: u8,
    pub phy_sel: u8,
    pub margindeemph: u16,
    pub deemph_6db_4: u8,
    pub boostadj: u8,
    pub tx_driver_fifty_ohms: u8,
    pub deemph_sel: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_dpphy_dvihdmi_tuningset"]
        [::core::mem::size_of::<atom_14nm_dpphy_dvihdmi_tuningset>() - 12usize];
    ["Alignment of atom_14nm_dpphy_dvihdmi_tuningset"]
        [::core::mem::align_of::<atom_14nm_dpphy_dvihdmi_tuningset>() - 1usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::max_symclk_in10khz"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, max_symclk_in10khz) - 0usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::encoder_mode"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, encoder_mode) - 4usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::phy_sel"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, phy_sel) - 5usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::margindeemph"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, margindeemph) - 6usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::deemph_6db_4"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, deemph_6db_4) - 8usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::boostadj"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, boostadj) - 9usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::tx_driver_fifty_ohms"][::core::mem::offset_of!(
        atom_14nm_dpphy_dvihdmi_tuningset,
        tx_driver_fifty_ohms
    ) - 10usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::deemph_sel"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, deemph_sel) - 11usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dpphy_dp_setting {
    pub dp_vs_pemph_level: u8,
    pub margindeemph: u16,
    pub deemph_6db_4: u8,
    pub boostadj: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_dpphy_dp_setting"]
        [::core::mem::size_of::<atom_14nm_dpphy_dp_setting>() - 5usize];
    ["Alignment of atom_14nm_dpphy_dp_setting"]
        [::core::mem::align_of::<atom_14nm_dpphy_dp_setting>() - 1usize];
    ["Offset of field: atom_14nm_dpphy_dp_setting::dp_vs_pemph_level"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_setting, dp_vs_pemph_level) - 0usize];
    ["Offset of field: atom_14nm_dpphy_dp_setting::margindeemph"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_setting, margindeemph) - 1usize];
    ["Offset of field: atom_14nm_dpphy_dp_setting::deemph_6db_4"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_setting, deemph_6db_4) - 3usize];
    ["Offset of field: atom_14nm_dpphy_dp_setting::boostadj"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_setting, boostadj) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dpphy_dp_tuningset {
    pub phy_sel: u8,
    pub version: u8,
    pub table_size: u16,
    pub reserved: u16,
    pub dptuning: [atom_14nm_dpphy_dp_setting; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_dpphy_dp_tuningset"]
        [::core::mem::size_of::<atom_14nm_dpphy_dp_tuningset>() - 56usize];
    ["Alignment of atom_14nm_dpphy_dp_tuningset"]
        [::core::mem::align_of::<atom_14nm_dpphy_dp_tuningset>() - 1usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::phy_sel"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, phy_sel) - 0usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::version"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, version) - 1usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::table_size"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, table_size) - 2usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::reserved"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, reserved) - 4usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::dptuning"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, dptuning) - 6usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dig_transmitter_info_header_v4_0 {
    pub table_header: atom_common_table_header,
    pub pcie_phy_tmds_hdmi_macro_settings_offset: u16,
    pub uniphy_vs_emph_lookup_table_offset: u16,
    pub uniphy_xbar_settings_table_offset: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_dig_transmitter_info_header_v4_0"]
        [::core::mem::size_of::<atom_14nm_dig_transmitter_info_header_v4_0>() - 10usize];
    ["Alignment of atom_14nm_dig_transmitter_info_header_v4_0"]
        [::core::mem::align_of::<atom_14nm_dig_transmitter_info_header_v4_0>() - 1usize];
    ["Offset of field: atom_14nm_dig_transmitter_info_header_v4_0::table_header"][::core::mem::offset_of!(
        atom_14nm_dig_transmitter_info_header_v4_0,
        table_header
    ) - 0usize];
    ["Offset of field: atom_14nm_dig_transmitter_info_header_v4_0::pcie_phy_tmds_hdmi_macro_settings_offset"] [:: core :: mem :: offset_of ! (atom_14nm_dig_transmitter_info_header_v4_0 , pcie_phy_tmds_hdmi_macro_settings_offset) - 4usize] ;
    ["Offset of field: atom_14nm_dig_transmitter_info_header_v4_0::uniphy_vs_emph_lookup_table_offset"] [:: core :: mem :: offset_of ! (atom_14nm_dig_transmitter_info_header_v4_0 , uniphy_vs_emph_lookup_table_offset) - 6usize] ;
    ["Offset of field: atom_14nm_dig_transmitter_info_header_v4_0::uniphy_xbar_settings_table_offset"] [:: core :: mem :: offset_of ! (atom_14nm_dig_transmitter_info_header_v4_0 , uniphy_xbar_settings_table_offset) - 8usize] ;
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_combphy_tmds_vs_set {
    pub sym_clk: u8,
    pub dig_mode: u8,
    pub phy_sel: u8,
    pub common_mar_deemph_nom__margin_deemph_val: u16,
    pub common_seldeemph60__deemph_6db_4_val: u8,
    pub cmd_bus_global_for_tx_lane0__boostadj_val: u8,
    pub common_zcalcode_ctrl__tx_driver_fifty_ohms_val: u8,
    pub margin_deemph_lane0__deemph_sel_val: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_combphy_tmds_vs_set"]
        [::core::mem::size_of::<atom_14nm_combphy_tmds_vs_set>() - 9usize];
    ["Alignment of atom_14nm_combphy_tmds_vs_set"]
        [::core::mem::align_of::<atom_14nm_combphy_tmds_vs_set>() - 1usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::sym_clk"]
        [::core::mem::offset_of!(atom_14nm_combphy_tmds_vs_set, sym_clk) - 0usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::dig_mode"]
        [::core::mem::offset_of!(atom_14nm_combphy_tmds_vs_set, dig_mode) - 1usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::phy_sel"]
        [::core::mem::offset_of!(atom_14nm_combphy_tmds_vs_set, phy_sel) - 2usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::common_mar_deemph_nom__margin_deemph_val"][::core::mem::offset_of!(
        atom_14nm_combphy_tmds_vs_set,
        common_mar_deemph_nom__margin_deemph_val
    )
        - 3usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::common_seldeemph60__deemph_6db_4_val"][::core::mem::offset_of!(
        atom_14nm_combphy_tmds_vs_set,
        common_seldeemph60__deemph_6db_4_val
    )
        - 5usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::cmd_bus_global_for_tx_lane0__boostadj_val"][::core::mem::offset_of!(
        atom_14nm_combphy_tmds_vs_set,
        cmd_bus_global_for_tx_lane0__boostadj_val
    )
        - 6usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::common_zcalcode_ctrl__tx_driver_fifty_ohms_val"] [:: core :: mem :: offset_of ! (atom_14nm_combphy_tmds_vs_set , common_zcalcode_ctrl__tx_driver_fifty_ohms_val) - 7usize] ;
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::margin_deemph_lane0__deemph_sel_val"][::core::mem::offset_of!(
        atom_14nm_combphy_tmds_vs_set,
        margin_deemph_lane0__deemph_sel_val
    )
        - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_DCN_dpphy_dvihdmi_tuningset {
    pub max_symclk_in10khz: u32,
    pub encoder_mode: u8,
    pub phy_sel: u8,
    pub tx_eq_main: u8,
    pub tx_eq_pre: u8,
    pub tx_eq_post: u8,
    pub reserved1: u8,
    pub tx_vboost_lvl: u8,
    pub reserved2: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_DCN_dpphy_dvihdmi_tuningset"]
        [::core::mem::size_of::<atom_DCN_dpphy_dvihdmi_tuningset>() - 12usize];
    ["Alignment of atom_DCN_dpphy_dvihdmi_tuningset"]
        [::core::mem::align_of::<atom_DCN_dpphy_dvihdmi_tuningset>() - 1usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::max_symclk_in10khz"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, max_symclk_in10khz) - 0usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::encoder_mode"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, encoder_mode) - 4usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::phy_sel"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, phy_sel) - 5usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::tx_eq_main"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, tx_eq_main) - 6usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::tx_eq_pre"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, tx_eq_pre) - 7usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::tx_eq_post"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, tx_eq_post) - 8usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::reserved1"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, reserved1) - 9usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::tx_vboost_lvl"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, tx_vboost_lvl) - 10usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::reserved2"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, reserved2) - 11usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_DCN_dpphy_dp_setting {
    pub dp_vs_pemph_level: u8,
    pub tx_eq_main: u8,
    pub tx_eq_pre: u8,
    pub tx_eq_post: u8,
    pub tx_vboost_lvl: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_DCN_dpphy_dp_setting"]
        [::core::mem::size_of::<atom_DCN_dpphy_dp_setting>() - 5usize];
    ["Alignment of atom_DCN_dpphy_dp_setting"]
        [::core::mem::align_of::<atom_DCN_dpphy_dp_setting>() - 1usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::dp_vs_pemph_level"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, dp_vs_pemph_level) - 0usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::tx_eq_main"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, tx_eq_main) - 1usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::tx_eq_pre"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, tx_eq_pre) - 2usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::tx_eq_post"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, tx_eq_post) - 3usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::tx_vboost_lvl"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, tx_vboost_lvl) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_DCN_dpphy_dp_tuningset {
    pub phy_sel: u8,
    pub version: u8,
    pub table_size: u16,
    pub reserved: u16,
    pub dptunings: [atom_DCN_dpphy_dp_setting; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_DCN_dpphy_dp_tuningset"]
        [::core::mem::size_of::<atom_DCN_dpphy_dp_tuningset>() - 56usize];
    ["Alignment of atom_DCN_dpphy_dp_tuningset"]
        [::core::mem::align_of::<atom_DCN_dpphy_dp_tuningset>() - 1usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::phy_sel"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, phy_sel) - 0usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::version"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, version) - 1usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::table_size"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, table_size) - 2usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::reserved"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, reserved) - 4usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::dptunings"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, dptunings) - 6usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_reg_info {
    pub ucI2cRegIndex: u8,
    pub ucI2cRegVal: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_i2c_reg_info"][::core::mem::size_of::<atom_i2c_reg_info>() - 2usize];
    ["Alignment of atom_i2c_reg_info"][::core::mem::align_of::<atom_i2c_reg_info>() - 1usize];
    ["Offset of field: atom_i2c_reg_info::ucI2cRegIndex"]
        [::core::mem::offset_of!(atom_i2c_reg_info, ucI2cRegIndex) - 0usize];
    ["Offset of field: atom_i2c_reg_info::ucI2cRegVal"]
        [::core::mem::offset_of!(atom_i2c_reg_info, ucI2cRegVal) - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_hdmi_retimer_redriver_set {
    pub HdmiSlvAddr: u8,
    pub HdmiRegNum: u8,
    pub Hdmi6GRegNum: u8,
    pub HdmiRegSetting: [atom_i2c_reg_info; 9usize],
    pub Hdmi6GhzRegSetting: [atom_i2c_reg_info; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_hdmi_retimer_redriver_set"]
        [::core::mem::size_of::<atom_hdmi_retimer_redriver_set>() - 27usize];
    ["Alignment of atom_hdmi_retimer_redriver_set"]
        [::core::mem::align_of::<atom_hdmi_retimer_redriver_set>() - 1usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::HdmiSlvAddr"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, HdmiSlvAddr) - 0usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::HdmiRegNum"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, HdmiRegNum) - 1usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::Hdmi6GRegNum"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, Hdmi6GRegNum) - 2usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::HdmiRegSetting"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, HdmiRegSetting) - 3usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::Hdmi6GhzRegSetting"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, Hdmi6GhzRegSetting) - 21usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v1_11 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub lvds_ss_percentage: u16,
    pub lvds_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub dpphy_override: u16,
    pub lvds_misc: u16,
    pub backlight_pwm_hz: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub pwr_on_digon_to_de: u8,
    pub pwr_on_de_to_vary_bl: u8,
    pub pwr_down_vary_bloff_to_de: u8,
    pub pwr_down_de_to_digoff: u8,
    pub pwr_off_delay: u8,
    pub pwr_on_vary_bl_to_blon: u8,
    pub pwr_down_bloff_to_vary_bloff: u8,
    pub min_allowed_bl_level: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub extdispconninfo: atom_external_display_connection_info,
    pub dvi_tuningset: atom_14nm_dpphy_dvihdmi_tuningset,
    pub hdmi_tuningset: atom_14nm_dpphy_dvihdmi_tuningset,
    pub hdmi6g_tuningset: atom_14nm_dpphy_dvihdmi_tuningset,
    pub dp_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub dp_hbr3_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub camera_info: atom_camera_data,
    pub dp0_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp1_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp2_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp3_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp_hbr_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub dp_hbr2_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub edp_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub reserved: [u32; 66usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_integrated_system_info_v1_11"]
        [::core::mem::size_of::<atom_integrated_system_info_v1_11>() - 1024usize];
    ["Alignment of atom_integrated_system_info_v1_11"]
        [::core::mem::align_of::<atom_integrated_system_info_v1_11>() - 1usize];
    ["Offset of field: atom_integrated_system_info_v1_11::table_header"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, table_header) - 0usize];
    ["Offset of field: atom_integrated_system_info_v1_11::vbios_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, vbios_misc) - 4usize];
    ["Offset of field: atom_integrated_system_info_v1_11::gpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, gpucapinfo) - 8usize];
    ["Offset of field: atom_integrated_system_info_v1_11::system_config"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, system_config) - 12usize];
    ["Offset of field: atom_integrated_system_info_v1_11::cpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, cpucapinfo) - 16usize];
    ["Offset of field: atom_integrated_system_info_v1_11::gpuclk_ss_percentage"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        gpuclk_ss_percentage
    ) - 20usize];
    ["Offset of field: atom_integrated_system_info_v1_11::gpuclk_ss_type"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, gpuclk_ss_type) - 22usize];
    ["Offset of field: atom_integrated_system_info_v1_11::lvds_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, lvds_ss_percentage) - 24usize];
    ["Offset of field: atom_integrated_system_info_v1_11::lvds_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, lvds_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_integrated_system_info_v1_11::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, hdmi_ss_percentage) - 28usize];
    ["Offset of field: atom_integrated_system_info_v1_11::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, hdmi_ss_rate_10hz) - 30usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dvi_ss_percentage) - 32usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dvi_ss_rate_10hz) - 34usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dpphy_override"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dpphy_override) - 36usize];
    ["Offset of field: atom_integrated_system_info_v1_11::lvds_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, lvds_misc) - 38usize];
    ["Offset of field: atom_integrated_system_info_v1_11::backlight_pwm_hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, backlight_pwm_hz) - 40usize];
    ["Offset of field: atom_integrated_system_info_v1_11::memorytype"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, memorytype) - 42usize];
    ["Offset of field: atom_integrated_system_info_v1_11::umachannelnumber"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, umachannelnumber) - 43usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_on_digon_to_de"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, pwr_on_digon_to_de) - 44usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_on_de_to_vary_bl"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_on_de_to_vary_bl
    ) - 45usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_down_vary_bloff_to_de"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_down_vary_bloff_to_de
    ) - 46usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_down_de_to_digoff"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_down_de_to_digoff
    ) - 47usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_off_delay"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, pwr_off_delay) - 48usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_on_vary_bl_to_blon"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_on_vary_bl_to_blon
    ) - 49usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_down_bloff_to_vary_bloff"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_down_bloff_to_vary_bloff
    )
        - 50usize];
    ["Offset of field: atom_integrated_system_info_v1_11::min_allowed_bl_level"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        min_allowed_bl_level
    ) - 51usize];
    ["Offset of field: atom_integrated_system_info_v1_11::htc_hyst_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, htc_hyst_limit) - 52usize];
    ["Offset of field: atom_integrated_system_info_v1_11::htc_tmp_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, htc_tmp_limit) - 53usize];
    ["Offset of field: atom_integrated_system_info_v1_11::reserved1"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, reserved1) - 54usize];
    ["Offset of field: atom_integrated_system_info_v1_11::reserved2"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, reserved2) - 55usize];
    ["Offset of field: atom_integrated_system_info_v1_11::extdispconninfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, extdispconninfo) - 56usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dvi_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dvi_tuningset) - 196usize];
    ["Offset of field: atom_integrated_system_info_v1_11::hdmi_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, hdmi_tuningset) - 208usize];
    ["Offset of field: atom_integrated_system_info_v1_11::hdmi6g_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, hdmi6g_tuningset) - 220usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp_tuningset) - 232usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp_hbr3_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp_hbr3_tuningset) - 288usize];
    ["Offset of field: atom_integrated_system_info_v1_11::camera_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, camera_info) - 344usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp0_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp0_retimer_set) - 484usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp1_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp1_retimer_set) - 511usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp2_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp2_retimer_set) - 538usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp3_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp3_retimer_set) - 565usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp_hbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp_hbr_tuningset) - 592usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp_hbr2_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp_hbr2_tuningset) - 648usize];
    ["Offset of field: atom_integrated_system_info_v1_11::edp_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, edp_tuningset) - 704usize];
    ["Offset of field: atom_integrated_system_info_v1_11::reserved"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, reserved) - 760usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v1_12 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub lvds_ss_percentage: u16,
    pub lvds_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub dpphy_override: u16,
    pub lvds_misc: u16,
    pub backlight_pwm_hz: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub pwr_on_digon_to_de: u8,
    pub pwr_on_de_to_vary_bl: u8,
    pub pwr_down_vary_bloff_to_de: u8,
    pub pwr_down_de_to_digoff: u8,
    pub pwr_off_delay: u8,
    pub pwr_on_vary_bl_to_blon: u8,
    pub pwr_down_bloff_to_vary_bloff: u8,
    pub min_allowed_bl_level: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub extdispconninfo: atom_external_display_connection_info,
    pub TMDS_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK5_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK8_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub rbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr3_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub camera_info: atom_camera_data,
    pub dp0_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp1_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp2_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp3_retimer_set: atom_hdmi_retimer_redriver_set,
    pub hbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr2_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub edp_tunings: atom_DCN_dpphy_dp_tuningset,
    pub hdmiCLK6_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub reserved: [u32; 63usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_integrated_system_info_v1_12"]
        [::core::mem::size_of::<atom_integrated_system_info_v1_12>() - 1024usize];
    ["Alignment of atom_integrated_system_info_v1_12"]
        [::core::mem::align_of::<atom_integrated_system_info_v1_12>() - 1usize];
    ["Offset of field: atom_integrated_system_info_v1_12::table_header"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, table_header) - 0usize];
    ["Offset of field: atom_integrated_system_info_v1_12::vbios_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, vbios_misc) - 4usize];
    ["Offset of field: atom_integrated_system_info_v1_12::gpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, gpucapinfo) - 8usize];
    ["Offset of field: atom_integrated_system_info_v1_12::system_config"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, system_config) - 12usize];
    ["Offset of field: atom_integrated_system_info_v1_12::cpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, cpucapinfo) - 16usize];
    ["Offset of field: atom_integrated_system_info_v1_12::gpuclk_ss_percentage"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        gpuclk_ss_percentage
    ) - 20usize];
    ["Offset of field: atom_integrated_system_info_v1_12::gpuclk_ss_type"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, gpuclk_ss_type) - 22usize];
    ["Offset of field: atom_integrated_system_info_v1_12::lvds_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, lvds_ss_percentage) - 24usize];
    ["Offset of field: atom_integrated_system_info_v1_12::lvds_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, lvds_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmi_ss_percentage) - 28usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmi_ss_rate_10hz) - 30usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dvi_ss_percentage) - 32usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dvi_ss_rate_10hz) - 34usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dpphy_override"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dpphy_override) - 36usize];
    ["Offset of field: atom_integrated_system_info_v1_12::lvds_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, lvds_misc) - 38usize];
    ["Offset of field: atom_integrated_system_info_v1_12::backlight_pwm_hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, backlight_pwm_hz) - 40usize];
    ["Offset of field: atom_integrated_system_info_v1_12::memorytype"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, memorytype) - 42usize];
    ["Offset of field: atom_integrated_system_info_v1_12::umachannelnumber"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, umachannelnumber) - 43usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_on_digon_to_de"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, pwr_on_digon_to_de) - 44usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_on_de_to_vary_bl"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_on_de_to_vary_bl
    ) - 45usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_down_vary_bloff_to_de"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_down_vary_bloff_to_de
    ) - 46usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_down_de_to_digoff"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_down_de_to_digoff
    ) - 47usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_off_delay"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, pwr_off_delay) - 48usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_on_vary_bl_to_blon"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_on_vary_bl_to_blon
    ) - 49usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_down_bloff_to_vary_bloff"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_down_bloff_to_vary_bloff
    )
        - 50usize];
    ["Offset of field: atom_integrated_system_info_v1_12::min_allowed_bl_level"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        min_allowed_bl_level
    ) - 51usize];
    ["Offset of field: atom_integrated_system_info_v1_12::htc_hyst_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, htc_hyst_limit) - 52usize];
    ["Offset of field: atom_integrated_system_info_v1_12::htc_tmp_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, htc_tmp_limit) - 53usize];
    ["Offset of field: atom_integrated_system_info_v1_12::reserved1"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, reserved1) - 54usize];
    ["Offset of field: atom_integrated_system_info_v1_12::reserved2"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, reserved2) - 55usize];
    ["Offset of field: atom_integrated_system_info_v1_12::extdispconninfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, extdispconninfo) - 56usize];
    ["Offset of field: atom_integrated_system_info_v1_12::TMDS_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, TMDS_tuningset) - 196usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmiCLK5_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmiCLK5_tuningset) - 208usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmiCLK8_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmiCLK8_tuningset) - 220usize];
    ["Offset of field: atom_integrated_system_info_v1_12::rbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, rbr_tuningset) - 232usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hbr3_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hbr3_tuningset) - 288usize];
    ["Offset of field: atom_integrated_system_info_v1_12::camera_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, camera_info) - 344usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dp0_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dp0_retimer_set) - 484usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dp1_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dp1_retimer_set) - 511usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dp2_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dp2_retimer_set) - 538usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dp3_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dp3_retimer_set) - 565usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hbr_tuningset) - 592usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hbr2_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hbr2_tuningset) - 648usize];
    ["Offset of field: atom_integrated_system_info_v1_12::edp_tunings"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, edp_tunings) - 704usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmiCLK6_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmiCLK6_tuningset) - 760usize];
    ["Offset of field: atom_integrated_system_info_v1_12::reserved"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, reserved) - 772usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct edp_info_table {
    pub edp_backlight_pwm_hz: u16,
    pub edp_ss_percentage: u16,
    pub edp_ss_rate_10hz: u16,
    pub reserved1: u16,
    pub reserved2: u32,
    pub edp_pwr_on_off_delay: u8,
    pub edp_pwr_on_vary_bl_to_blon: u8,
    pub edp_pwr_down_bloff_to_vary_bloff: u8,
    pub edp_panel_bpc: u8,
    pub edp_bootup_bl_level: u8,
    pub reserved3: [u8; 3usize],
    pub reserved4: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of edp_info_table"][::core::mem::size_of::<edp_info_table>() - 32usize];
    ["Alignment of edp_info_table"][::core::mem::align_of::<edp_info_table>() - 1usize];
    ["Offset of field: edp_info_table::edp_backlight_pwm_hz"]
        [::core::mem::offset_of!(edp_info_table, edp_backlight_pwm_hz) - 0usize];
    ["Offset of field: edp_info_table::edp_ss_percentage"]
        [::core::mem::offset_of!(edp_info_table, edp_ss_percentage) - 2usize];
    ["Offset of field: edp_info_table::edp_ss_rate_10hz"]
        [::core::mem::offset_of!(edp_info_table, edp_ss_rate_10hz) - 4usize];
    ["Offset of field: edp_info_table::reserved1"]
        [::core::mem::offset_of!(edp_info_table, reserved1) - 6usize];
    ["Offset of field: edp_info_table::reserved2"]
        [::core::mem::offset_of!(edp_info_table, reserved2) - 8usize];
    ["Offset of field: edp_info_table::edp_pwr_on_off_delay"]
        [::core::mem::offset_of!(edp_info_table, edp_pwr_on_off_delay) - 12usize];
    ["Offset of field: edp_info_table::edp_pwr_on_vary_bl_to_blon"]
        [::core::mem::offset_of!(edp_info_table, edp_pwr_on_vary_bl_to_blon) - 13usize];
    ["Offset of field: edp_info_table::edp_pwr_down_bloff_to_vary_bloff"]
        [::core::mem::offset_of!(edp_info_table, edp_pwr_down_bloff_to_vary_bloff) - 14usize];
    ["Offset of field: edp_info_table::edp_panel_bpc"]
        [::core::mem::offset_of!(edp_info_table, edp_panel_bpc) - 15usize];
    ["Offset of field: edp_info_table::edp_bootup_bl_level"]
        [::core::mem::offset_of!(edp_info_table, edp_bootup_bl_level) - 16usize];
    ["Offset of field: edp_info_table::reserved3"]
        [::core::mem::offset_of!(edp_info_table, reserved3) - 17usize];
    ["Offset of field: edp_info_table::reserved4"]
        [::core::mem::offset_of!(edp_info_table, reserved4) - 20usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v2_1 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub dpphy_override: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub edp1_info: edp_info_table,
    pub edp2_info: edp_info_table,
    pub reserved3: [u32; 8usize],
    pub extdispconninfo: atom_external_display_connection_info,
    pub TMDS_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK5_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK6_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK8_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub reserved4: [u32; 6usize],
    pub rbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr2_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr3_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub edp_tunings: atom_DCN_dpphy_dp_tuningset,
    pub reserved5: [u32; 28usize],
    pub dp0_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp1_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp2_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp3_retimer_set: atom_hdmi_retimer_redriver_set,
    pub reserved6: [u32; 30usize],
    pub reserved7: [u32; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_integrated_system_info_v2_1"]
        [::core::mem::size_of::<atom_integrated_system_info_v2_1>() - 1088usize];
    ["Alignment of atom_integrated_system_info_v2_1"]
        [::core::mem::align_of::<atom_integrated_system_info_v2_1>() - 1usize];
    ["Offset of field: atom_integrated_system_info_v2_1::table_header"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, table_header) - 0usize];
    ["Offset of field: atom_integrated_system_info_v2_1::vbios_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, vbios_misc) - 4usize];
    ["Offset of field: atom_integrated_system_info_v2_1::gpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, gpucapinfo) - 8usize];
    ["Offset of field: atom_integrated_system_info_v2_1::system_config"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, system_config) - 12usize];
    ["Offset of field: atom_integrated_system_info_v2_1::cpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, cpucapinfo) - 16usize];
    ["Offset of field: atom_integrated_system_info_v2_1::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, gpuclk_ss_percentage) - 20usize];
    ["Offset of field: atom_integrated_system_info_v2_1::gpuclk_ss_type"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, gpuclk_ss_type) - 22usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dpphy_override"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dpphy_override) - 24usize];
    ["Offset of field: atom_integrated_system_info_v2_1::memorytype"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, memorytype) - 26usize];
    ["Offset of field: atom_integrated_system_info_v2_1::umachannelnumber"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, umachannelnumber) - 27usize];
    ["Offset of field: atom_integrated_system_info_v2_1::htc_hyst_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, htc_hyst_limit) - 28usize];
    ["Offset of field: atom_integrated_system_info_v2_1::htc_tmp_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, htc_tmp_limit) - 29usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved1"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved1) - 30usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved2"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved2) - 31usize];
    ["Offset of field: atom_integrated_system_info_v2_1::edp1_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, edp1_info) - 32usize];
    ["Offset of field: atom_integrated_system_info_v2_1::edp2_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, edp2_info) - 64usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved3"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved3) - 96usize];
    ["Offset of field: atom_integrated_system_info_v2_1::extdispconninfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, extdispconninfo) - 128usize];
    ["Offset of field: atom_integrated_system_info_v2_1::TMDS_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, TMDS_tuningset) - 268usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hdmiCLK5_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hdmiCLK5_tuningset) - 280usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hdmiCLK6_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hdmiCLK6_tuningset) - 292usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hdmiCLK8_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hdmiCLK8_tuningset) - 304usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved4"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved4) - 316usize];
    ["Offset of field: atom_integrated_system_info_v2_1::rbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, rbr_tuningset) - 340usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hbr_tuningset) - 396usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hbr2_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hbr2_tuningset) - 452usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hbr3_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hbr3_tuningset) - 508usize];
    ["Offset of field: atom_integrated_system_info_v2_1::edp_tunings"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, edp_tunings) - 564usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved5"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved5) - 620usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dp0_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dp0_retimer_set) - 732usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dp1_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dp1_retimer_set) - 759usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dp2_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dp2_retimer_set) - 786usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dp3_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dp3_retimer_set) - 813usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved6"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved6) - 840usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved7"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved7) - 960usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_n6_display_phy_tuning_set {
    pub display_signal_type: u8,
    pub phy_sel: u8,
    pub preset_level: u8,
    pub reserved1: u8,
    pub reserved2: u32,
    pub speed_upto: u32,
    pub tx_vboost_level: u8,
    pub tx_vreg_v2i: u8,
    pub tx_vregdrv_byp: u8,
    pub tx_term_cntl: u8,
    pub tx_peak_level: u8,
    pub tx_slew_en: u8,
    pub tx_eq_pre: u8,
    pub tx_eq_main: u8,
    pub tx_eq_post: u8,
    pub tx_en_inv_pre: u8,
    pub tx_en_inv_post: u8,
    pub reserved3: u8,
    pub reserved4: u32,
    pub reserved5: u32,
    pub reserved6: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_n6_display_phy_tuning_set"]
        [::core::mem::size_of::<atom_n6_display_phy_tuning_set>() - 36usize];
    ["Alignment of atom_n6_display_phy_tuning_set"]
        [::core::mem::align_of::<atom_n6_display_phy_tuning_set>() - 1usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::display_signal_type"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, display_signal_type) - 0usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::phy_sel"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, phy_sel) - 1usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::preset_level"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, preset_level) - 2usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved1"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved1) - 3usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved2"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved2) - 4usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::speed_upto"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, speed_upto) - 8usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_vboost_level"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_vboost_level) - 12usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_vreg_v2i"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_vreg_v2i) - 13usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_vregdrv_byp"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_vregdrv_byp) - 14usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_term_cntl"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_term_cntl) - 15usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_peak_level"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_peak_level) - 16usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_slew_en"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_slew_en) - 17usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_eq_pre"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_eq_pre) - 18usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_eq_main"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_eq_main) - 19usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_eq_post"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_eq_post) - 20usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_en_inv_pre"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_en_inv_pre) - 21usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_en_inv_post"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_en_inv_post) - 22usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved3"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved3) - 23usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved4"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved4) - 24usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved5"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved5) - 28usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved6"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved6) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_phy_tuning_info {
    pub table_header: atom_common_table_header,
    pub disp_phy_tuning: [atom_n6_display_phy_tuning_set; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_phy_tuning_info"]
        [::core::mem::size_of::<atom_display_phy_tuning_info>() - 40usize];
    ["Alignment of atom_display_phy_tuning_info"]
        [::core::mem::align_of::<atom_display_phy_tuning_info>() - 1usize];
    ["Offset of field: atom_display_phy_tuning_info::table_header"]
        [::core::mem::offset_of!(atom_display_phy_tuning_info, table_header) - 0usize];
    ["Offset of field: atom_display_phy_tuning_info::disp_phy_tuning"]
        [::core::mem::offset_of!(atom_display_phy_tuning_info, disp_phy_tuning) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v2_2 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub dpphy_override: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub edp1_info: edp_info_table,
    pub edp2_info: edp_info_table,
    pub reserved3: [u32; 8usize],
    pub extdispconninfo: atom_external_display_connection_info,
    pub reserved4: [u32; 189usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_integrated_system_info_v2_2"]
        [::core::mem::size_of::<atom_integrated_system_info_v2_2>() - 1024usize];
    ["Alignment of atom_integrated_system_info_v2_2"]
        [::core::mem::align_of::<atom_integrated_system_info_v2_2>() - 1usize];
    ["Offset of field: atom_integrated_system_info_v2_2::table_header"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, table_header) - 0usize];
    ["Offset of field: atom_integrated_system_info_v2_2::vbios_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, vbios_misc) - 4usize];
    ["Offset of field: atom_integrated_system_info_v2_2::gpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, gpucapinfo) - 8usize];
    ["Offset of field: atom_integrated_system_info_v2_2::system_config"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, system_config) - 12usize];
    ["Offset of field: atom_integrated_system_info_v2_2::cpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, cpucapinfo) - 16usize];
    ["Offset of field: atom_integrated_system_info_v2_2::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, gpuclk_ss_percentage) - 20usize];
    ["Offset of field: atom_integrated_system_info_v2_2::gpuclk_ss_type"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, gpuclk_ss_type) - 22usize];
    ["Offset of field: atom_integrated_system_info_v2_2::dpphy_override"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, dpphy_override) - 24usize];
    ["Offset of field: atom_integrated_system_info_v2_2::memorytype"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, memorytype) - 26usize];
    ["Offset of field: atom_integrated_system_info_v2_2::umachannelnumber"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, umachannelnumber) - 27usize];
    ["Offset of field: atom_integrated_system_info_v2_2::htc_hyst_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, htc_hyst_limit) - 28usize];
    ["Offset of field: atom_integrated_system_info_v2_2::htc_tmp_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, htc_tmp_limit) - 29usize];
    ["Offset of field: atom_integrated_system_info_v2_2::reserved1"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, reserved1) - 30usize];
    ["Offset of field: atom_integrated_system_info_v2_2::reserved2"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, reserved2) - 31usize];
    ["Offset of field: atom_integrated_system_info_v2_2::edp1_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, edp1_info) - 32usize];
    ["Offset of field: atom_integrated_system_info_v2_2::edp2_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, edp2_info) - 64usize];
    ["Offset of field: atom_integrated_system_info_v2_2::reserved3"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, reserved3) - 96usize];
    ["Offset of field: atom_integrated_system_info_v2_2::extdispconninfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, extdispconninfo) - 128usize];
    ["Offset of field: atom_integrated_system_info_v2_2::reserved4"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, reserved4) - 268usize];
};
pub const atom_system_vbiosmisc_def_INTEGRATED_SYSTEM_INFO__GET_EDID_CALLBACK_FUNC_SUPPORT:
    atom_system_vbiosmisc_def = 1;
pub type atom_system_vbiosmisc_def = ::core::ffi::c_uint;
pub const atom_system_gpucapinf_def_SYS_INFO_GPUCAPS__ENABEL_DFS_BYPASS: atom_system_gpucapinf_def =
    16;
pub type atom_system_gpucapinf_def = ::core::ffi::c_uint;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_DVI_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 1;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_HDMI_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 2;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_HDMI6G_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 4;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_DP_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 8;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_DP_HBR3_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 16;
pub type atom_sysinfo_dpphy_override_def = ::core::ffi::c_uint;
pub const atom_sys_info_lvds_misc_def_SYS_INFO_LVDS_MISC_888_FPDI_MODE:
    atom_sys_info_lvds_misc_def = 1;
pub const atom_sys_info_lvds_misc_def_SYS_INFO_LVDS_MISC_888_BPC_MODE: atom_sys_info_lvds_misc_def =
    4;
pub const atom_sys_info_lvds_misc_def_SYS_INFO_LVDS_MISC_OVERRIDE_EN: atom_sys_info_lvds_misc_def =
    8;
pub type atom_sys_info_lvds_misc_def = ::core::ffi::c_uint;
#[doc = "< Assign 01 to Other"]
pub const atom_dmi_t17_mem_type_def_OtherMemType: atom_dmi_t17_mem_type_def = 1;
#[doc = "< Assign 02 to Unknown"]
pub const atom_dmi_t17_mem_type_def_UnknownMemType: atom_dmi_t17_mem_type_def = 2;
#[doc = "< Assign 03 to DRAM"]
pub const atom_dmi_t17_mem_type_def_DramMemType: atom_dmi_t17_mem_type_def = 3;
#[doc = "< Assign 04 to EDRAM"]
pub const atom_dmi_t17_mem_type_def_EdramMemType: atom_dmi_t17_mem_type_def = 4;
#[doc = "< Assign 05 to VRAM"]
pub const atom_dmi_t17_mem_type_def_VramMemType: atom_dmi_t17_mem_type_def = 5;
#[doc = "< Assign 06 to SRAM"]
pub const atom_dmi_t17_mem_type_def_SramMemType: atom_dmi_t17_mem_type_def = 6;
#[doc = "< Assign 07 to RAM"]
pub const atom_dmi_t17_mem_type_def_RamMemType: atom_dmi_t17_mem_type_def = 7;
#[doc = "< Assign 08 to ROM"]
pub const atom_dmi_t17_mem_type_def_RomMemType: atom_dmi_t17_mem_type_def = 8;
#[doc = "< Assign 09 to Flash"]
pub const atom_dmi_t17_mem_type_def_FlashMemType: atom_dmi_t17_mem_type_def = 9;
#[doc = "< Assign 10 to EEPROM"]
pub const atom_dmi_t17_mem_type_def_EepromMemType: atom_dmi_t17_mem_type_def = 10;
#[doc = "< Assign 11 to FEPROM"]
pub const atom_dmi_t17_mem_type_def_FepromMemType: atom_dmi_t17_mem_type_def = 11;
#[doc = "< Assign 12 to EPROM"]
pub const atom_dmi_t17_mem_type_def_EpromMemType: atom_dmi_t17_mem_type_def = 12;
#[doc = "< Assign 13 to CDRAM"]
pub const atom_dmi_t17_mem_type_def_CdramMemType: atom_dmi_t17_mem_type_def = 13;
#[doc = "< Assign 14 to 3DRAM"]
pub const atom_dmi_t17_mem_type_def_ThreeDramMemType: atom_dmi_t17_mem_type_def = 14;
#[doc = "< Assign 15 to SDRAM"]
pub const atom_dmi_t17_mem_type_def_SdramMemType: atom_dmi_t17_mem_type_def = 15;
#[doc = "< Assign 16 to SGRAM"]
pub const atom_dmi_t17_mem_type_def_SgramMemType: atom_dmi_t17_mem_type_def = 16;
#[doc = "< Assign 17 to RDRAM"]
pub const atom_dmi_t17_mem_type_def_RdramMemType: atom_dmi_t17_mem_type_def = 17;
#[doc = "< Assign 18 to DDR"]
pub const atom_dmi_t17_mem_type_def_DdrMemType: atom_dmi_t17_mem_type_def = 18;
#[doc = "< Assign 19 to DDR2"]
pub const atom_dmi_t17_mem_type_def_Ddr2MemType: atom_dmi_t17_mem_type_def = 19;
#[doc = "< Assign 20 to DDR2 FB-DIMM"]
pub const atom_dmi_t17_mem_type_def_Ddr2FbdimmMemType: atom_dmi_t17_mem_type_def = 20;
#[doc = "< Assign 24 to DDR3"]
pub const atom_dmi_t17_mem_type_def_Ddr3MemType: atom_dmi_t17_mem_type_def = 24;
#[doc = "< Assign 25 to FBD2"]
pub const atom_dmi_t17_mem_type_def_Fbd2MemType: atom_dmi_t17_mem_type_def = 25;
#[doc = "< Assign 26 to DDR4"]
pub const atom_dmi_t17_mem_type_def_Ddr4MemType: atom_dmi_t17_mem_type_def = 26;
#[doc = "< Assign 27 to LPDDR"]
pub const atom_dmi_t17_mem_type_def_LpDdrMemType: atom_dmi_t17_mem_type_def = 27;
#[doc = "< Assign 28 to LPDDR2"]
pub const atom_dmi_t17_mem_type_def_LpDdr2MemType: atom_dmi_t17_mem_type_def = 28;
#[doc = "< Assign 29 to LPDDR3"]
pub const atom_dmi_t17_mem_type_def_LpDdr3MemType: atom_dmi_t17_mem_type_def = 29;
#[doc = "< Assign 30 to LPDDR4"]
pub const atom_dmi_t17_mem_type_def_LpDdr4MemType: atom_dmi_t17_mem_type_def = 30;
#[doc = "< Assign 31 to GDDR6"]
pub const atom_dmi_t17_mem_type_def_GDdr6MemType: atom_dmi_t17_mem_type_def = 31;
#[doc = "< Assign 32 to HBM"]
pub const atom_dmi_t17_mem_type_def_HbmMemType: atom_dmi_t17_mem_type_def = 32;
#[doc = "< Assign 33 to HBM2"]
pub const atom_dmi_t17_mem_type_def_Hbm2MemType: atom_dmi_t17_mem_type_def = 33;
#[doc = "< Assign 34 to DDR5"]
pub const atom_dmi_t17_mem_type_def_Ddr5MemType: atom_dmi_t17_mem_type_def = 34;
#[doc = "< Assign 35 to LPDDR5"]
pub const atom_dmi_t17_mem_type_def_LpDdr5MemType: atom_dmi_t17_mem_type_def = 35;
pub type atom_dmi_t17_mem_type_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_fusion_system_info_v4 {
    pub sysinfo: atom_integrated_system_info_v1_11,
    pub powerplayinfo: [u32; 256usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_fusion_system_info_v4"]
        [::core::mem::size_of::<atom_fusion_system_info_v4>() - 2048usize];
    ["Alignment of atom_fusion_system_info_v4"]
        [::core::mem::align_of::<atom_fusion_system_info_v4>() - 1usize];
    ["Offset of field: atom_fusion_system_info_v4::sysinfo"]
        [::core::mem::offset_of!(atom_fusion_system_info_v4, sysinfo) - 0usize];
    ["Offset of field: atom_fusion_system_info_v4::powerplayinfo"]
        [::core::mem::offset_of!(atom_fusion_system_info_v4, powerplayinfo) - 1024usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_2 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub max_tile_pipes: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v2_2"][::core::mem::size_of::<atom_gfx_info_v2_2>() - 44usize];
    ["Alignment of atom_gfx_info_v2_2"][::core::mem::align_of::<atom_gfx_info_v2_2>() - 1usize];
    ["Offset of field: atom_gfx_info_v2_2::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v2_2::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v2_2::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v2_2::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v2_2::max_tile_pipes"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_tile_pipes) - 7usize];
    ["Offset of field: atom_gfx_info_v2_2::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v2_2::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v2_2::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v2_2::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_src_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_src_addr) - 12usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_src_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_src_addr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_dst_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_dst_addr) - 20usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_dst_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_dst_addr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_status"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_status) - 32usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_rlc_gpu_clock_32"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_rlc_gpu_clock_32) - 36usize];
    ["Offset of field: atom_gfx_info_v2_2::rlc_gpu_timer_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, rlc_gpu_timer_refclk) - 40usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_3 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub max_tile_pipes: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
    pub active_cu_per_sh: u8,
    pub active_rb_per_se: u8,
    pub gcgoldenoffset: u16,
    pub rm21_sram_vmin_value: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v2_3"][::core::mem::size_of::<atom_gfx_info_v2_3>() - 52usize];
    ["Alignment of atom_gfx_info_v2_3"][::core::mem::align_of::<atom_gfx_info_v2_3>() - 1usize];
    ["Offset of field: atom_gfx_info_v2_3::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v2_3::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v2_3::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v2_3::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v2_3::max_tile_pipes"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_tile_pipes) - 7usize];
    ["Offset of field: atom_gfx_info_v2_3::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v2_3::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v2_3::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v2_3::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_src_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_src_addr) - 12usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_src_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_src_addr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_dst_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_dst_addr) - 20usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_dst_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_dst_addr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_status"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_status) - 32usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_rlc_gpu_clock_32"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_rlc_gpu_clock_32) - 36usize];
    ["Offset of field: atom_gfx_info_v2_3::rlc_gpu_timer_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, rlc_gpu_timer_refclk) - 40usize];
    ["Offset of field: atom_gfx_info_v2_3::active_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, active_cu_per_sh) - 44usize];
    ["Offset of field: atom_gfx_info_v2_3::active_rb_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, active_rb_per_se) - 45usize];
    ["Offset of field: atom_gfx_info_v2_3::gcgoldenoffset"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, gcgoldenoffset) - 46usize];
    ["Offset of field: atom_gfx_info_v2_3::rm21_sram_vmin_value"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, rm21_sram_vmin_value) - 48usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_4 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub reserved: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
    pub active_cu_per_sh: u8,
    pub active_rb_per_se: u8,
    pub gcgoldenoffset: u16,
    pub gc_num_gprs: u16,
    pub gc_gsprim_buff_depth: u16,
    pub gc_parameter_cache_depth: u16,
    pub gc_wave_size: u16,
    pub gc_max_waves_per_simd: u16,
    pub gc_lds_size: u16,
    pub gc_num_max_gs_thds: u8,
    pub gc_gs_table_depth: u8,
    pub gc_double_offchip_lds_buffer: u8,
    pub gc_max_scratch_slots_per_cu: u8,
    pub sram_rm_fuses_val: u32,
    pub sram_custom_rm_fuses_val: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v2_4"][::core::mem::size_of::<atom_gfx_info_v2_4>() - 72usize];
    ["Alignment of atom_gfx_info_v2_4"][::core::mem::align_of::<atom_gfx_info_v2_4>() - 1usize];
    ["Offset of field: atom_gfx_info_v2_4::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v2_4::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v2_4::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v2_4::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v2_4::reserved"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, reserved) - 7usize];
    ["Offset of field: atom_gfx_info_v2_4::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v2_4::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v2_4::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v2_4::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_src_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_src_addr) - 12usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_src_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_src_addr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_dst_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_dst_addr) - 20usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_dst_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_dst_addr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_status"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_status) - 32usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_rlc_gpu_clock_32"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_rlc_gpu_clock_32) - 36usize];
    ["Offset of field: atom_gfx_info_v2_4::rlc_gpu_timer_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, rlc_gpu_timer_refclk) - 40usize];
    ["Offset of field: atom_gfx_info_v2_4::active_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, active_cu_per_sh) - 44usize];
    ["Offset of field: atom_gfx_info_v2_4::active_rb_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, active_rb_per_se) - 45usize];
    ["Offset of field: atom_gfx_info_v2_4::gcgoldenoffset"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gcgoldenoffset) - 46usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_num_gprs"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_num_gprs) - 48usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_gsprim_buff_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_gsprim_buff_depth) - 50usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_parameter_cache_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_parameter_cache_depth) - 52usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_wave_size"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_wave_size) - 54usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_max_waves_per_simd"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_max_waves_per_simd) - 56usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_lds_size"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_lds_size) - 58usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_num_max_gs_thds"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_num_max_gs_thds) - 60usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_gs_table_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_gs_table_depth) - 61usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_double_offchip_lds_buffer"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_double_offchip_lds_buffer) - 62usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_max_scratch_slots_per_cu"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_max_scratch_slots_per_cu) - 63usize];
    ["Offset of field: atom_gfx_info_v2_4::sram_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, sram_rm_fuses_val) - 64usize];
    ["Offset of field: atom_gfx_info_v2_4::sram_custom_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, sram_custom_rm_fuses_val) - 68usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_7 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub reserved: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
    pub active_cu_per_sh: u8,
    pub active_rb_per_se: u8,
    pub gcgoldenoffset: u16,
    pub gc_num_gprs: u16,
    pub gc_gsprim_buff_depth: u16,
    pub gc_parameter_cache_depth: u16,
    pub gc_wave_size: u16,
    pub gc_max_waves_per_simd: u16,
    pub gc_lds_size: u16,
    pub gc_num_max_gs_thds: u8,
    pub gc_gs_table_depth: u8,
    pub gc_double_offchip_lds_buffer: u8,
    pub gc_max_scratch_slots_per_cu: u8,
    pub sram_rm_fuses_val: u32,
    pub sram_custom_rm_fuses_val: u32,
    pub cut_cu: u8,
    pub active_cu_total: u8,
    pub cu_reserved: [u8; 2usize],
    pub gc_config: u32,
    pub inactive_cu_per_se: [u8; 8usize],
    pub reserved2: [u32; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v2_7"][::core::mem::size_of::<atom_gfx_info_v2_7>() - 112usize];
    ["Alignment of atom_gfx_info_v2_7"][::core::mem::align_of::<atom_gfx_info_v2_7>() - 1usize];
    ["Offset of field: atom_gfx_info_v2_7::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v2_7::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v2_7::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v2_7::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v2_7::reserved"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, reserved) - 7usize];
    ["Offset of field: atom_gfx_info_v2_7::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v2_7::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v2_7::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v2_7::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_src_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_src_addr) - 12usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_src_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_src_addr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_dst_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_dst_addr) - 20usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_dst_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_dst_addr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_status"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_status) - 32usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_rlc_gpu_clock_32"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_rlc_gpu_clock_32) - 36usize];
    ["Offset of field: atom_gfx_info_v2_7::rlc_gpu_timer_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, rlc_gpu_timer_refclk) - 40usize];
    ["Offset of field: atom_gfx_info_v2_7::active_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, active_cu_per_sh) - 44usize];
    ["Offset of field: atom_gfx_info_v2_7::active_rb_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, active_rb_per_se) - 45usize];
    ["Offset of field: atom_gfx_info_v2_7::gcgoldenoffset"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gcgoldenoffset) - 46usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_num_gprs"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_num_gprs) - 48usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_gsprim_buff_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_gsprim_buff_depth) - 50usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_parameter_cache_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_parameter_cache_depth) - 52usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_wave_size"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_wave_size) - 54usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_max_waves_per_simd"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_max_waves_per_simd) - 56usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_lds_size"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_lds_size) - 58usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_num_max_gs_thds"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_num_max_gs_thds) - 60usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_gs_table_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_gs_table_depth) - 61usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_double_offchip_lds_buffer"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_double_offchip_lds_buffer) - 62usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_max_scratch_slots_per_cu"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_max_scratch_slots_per_cu) - 63usize];
    ["Offset of field: atom_gfx_info_v2_7::sram_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, sram_rm_fuses_val) - 64usize];
    ["Offset of field: atom_gfx_info_v2_7::sram_custom_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, sram_custom_rm_fuses_val) - 68usize];
    ["Offset of field: atom_gfx_info_v2_7::cut_cu"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, cut_cu) - 72usize];
    ["Offset of field: atom_gfx_info_v2_7::active_cu_total"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, active_cu_total) - 73usize];
    ["Offset of field: atom_gfx_info_v2_7::cu_reserved"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, cu_reserved) - 74usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_config"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_config) - 76usize];
    ["Offset of field: atom_gfx_info_v2_7::inactive_cu_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, inactive_cu_per_se) - 80usize];
    ["Offset of field: atom_gfx_info_v2_7::reserved2"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, reserved2) - 88usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v3_0 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub max_tile_pipes: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_lsdma_queue0_rb_rptr: u32,
    pub regaddr_lsdma_queue0_rb_rptr_hi: u32,
    pub regaddr_lsdma_queue0_rb_wptr: u32,
    pub regaddr_lsdma_queue0_rb_wptr_hi: u32,
    pub regaddr_lsdma_command: u32,
    pub regaddr_lsdma_status: u32,
    pub regaddr_golden_tsc_count_lower: u32,
    pub golden_tsc_count_lower_refclk: u32,
    pub active_wgp_per_se: u8,
    pub active_rb_per_se: u8,
    pub active_se: u8,
    pub reserved1: u8,
    pub sram_rm_fuses_val: u32,
    pub sram_custom_rm_fuses_val: u32,
    pub inactive_sa_mask: u32,
    pub gc_config: u32,
    pub inactive_wgp: [u8; 16usize],
    pub inactive_rb: [u8; 16usize],
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub reserved: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v3_0"][::core::mem::size_of::<atom_gfx_info_v3_0>() - 136usize];
    ["Alignment of atom_gfx_info_v3_0"][::core::mem::align_of::<atom_gfx_info_v3_0>() - 1usize];
    ["Offset of field: atom_gfx_info_v3_0::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v3_0::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v3_0::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v3_0::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v3_0::max_tile_pipes"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_tile_pipes) - 7usize];
    ["Offset of field: atom_gfx_info_v3_0::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v3_0::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v3_0::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v3_0::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_queue0_rb_rptr"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_queue0_rb_rptr) - 12usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_queue0_rb_rptr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_queue0_rb_rptr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_queue0_rb_wptr"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_queue0_rb_wptr) - 20usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_queue0_rb_wptr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_queue0_rb_wptr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_status"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_status) - 32usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_golden_tsc_count_lower"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_golden_tsc_count_lower) - 36usize];
    ["Offset of field: atom_gfx_info_v3_0::golden_tsc_count_lower_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, golden_tsc_count_lower_refclk) - 40usize];
    ["Offset of field: atom_gfx_info_v3_0::active_wgp_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, active_wgp_per_se) - 44usize];
    ["Offset of field: atom_gfx_info_v3_0::active_rb_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, active_rb_per_se) - 45usize];
    ["Offset of field: atom_gfx_info_v3_0::active_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, active_se) - 46usize];
    ["Offset of field: atom_gfx_info_v3_0::reserved1"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, reserved1) - 47usize];
    ["Offset of field: atom_gfx_info_v3_0::sram_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, sram_rm_fuses_val) - 48usize];
    ["Offset of field: atom_gfx_info_v3_0::sram_custom_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, sram_custom_rm_fuses_val) - 52usize];
    ["Offset of field: atom_gfx_info_v3_0::inactive_sa_mask"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, inactive_sa_mask) - 56usize];
    ["Offset of field: atom_gfx_info_v3_0::gc_config"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gc_config) - 60usize];
    ["Offset of field: atom_gfx_info_v3_0::inactive_wgp"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, inactive_wgp) - 64usize];
    ["Offset of field: atom_gfx_info_v3_0::inactive_rb"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, inactive_rb) - 80usize];
    ["Offset of field: atom_gfx_info_v3_0::gdfll_as_wait_ctrl_val"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gdfll_as_wait_ctrl_val) - 96usize];
    ["Offset of field: atom_gfx_info_v3_0::gdfll_as_step_ctrl_val"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gdfll_as_step_ctrl_val) - 100usize];
    ["Offset of field: atom_gfx_info_v3_0::reserved"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, reserved) - 104usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_1 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub smu_rsd1: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub ac_dc_gpio_bit: u8,
    pub ac_dc_polarity: u8,
    pub vr0hot_gpio_bit: u8,
    pub vr0hot_polarity: u8,
    pub vr1hot_gpio_bit: u8,
    pub vr1hot_polarity: u8,
    pub fw_ctf_gpio_bit: u8,
    pub fw_ctf_polarity: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_1"][::core::mem::size_of::<atom_smu_info_v3_1>() - 28usize];
    ["Alignment of atom_smu_info_v3_1"][::core::mem::align_of::<atom_smu_info_v3_1>() - 1usize];
    ["Offset of field: atom_smu_info_v3_1::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_1::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_1::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_1::smu_rsd1"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, smu_rsd1) - 6usize];
    ["Offset of field: atom_smu_info_v3_1::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_1::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_1::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_1::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_1::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_1::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_1::ac_dc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, ac_dc_gpio_bit) - 20usize];
    ["Offset of field: atom_smu_info_v3_1::ac_dc_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, ac_dc_polarity) - 21usize];
    ["Offset of field: atom_smu_info_v3_1::vr0hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, vr0hot_gpio_bit) - 22usize];
    ["Offset of field: atom_smu_info_v3_1::vr0hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, vr0hot_polarity) - 23usize];
    ["Offset of field: atom_smu_info_v3_1::vr1hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, vr1hot_gpio_bit) - 24usize];
    ["Offset of field: atom_smu_info_v3_1::vr1hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, vr1hot_polarity) - 25usize];
    ["Offset of field: atom_smu_info_v3_1::fw_ctf_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, fw_ctf_gpio_bit) - 26usize];
    ["Offset of field: atom_smu_info_v3_1::fw_ctf_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, fw_ctf_polarity) - 27usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_2 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub smu_rsd1: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub ac_dc_gpio_bit: u8,
    pub ac_dc_polarity: u8,
    pub vr0hot_gpio_bit: u8,
    pub vr0hot_polarity: u8,
    pub vr1hot_gpio_bit: u8,
    pub vr1hot_polarity: u8,
    pub fw_ctf_gpio_bit: u8,
    pub fw_ctf_polarity: u8,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub gpupll_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub reserved: [u32; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_2"][::core::mem::size_of::<atom_smu_info_v3_2>() - 84usize];
    ["Alignment of atom_smu_info_v3_2"][::core::mem::align_of::<atom_smu_info_v3_2>() - 1usize];
    ["Offset of field: atom_smu_info_v3_2::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_2::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_2::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_2::smu_rsd1"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, smu_rsd1) - 6usize];
    ["Offset of field: atom_smu_info_v3_2::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_2::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_2::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_2::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_2::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_2::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_2::ac_dc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, ac_dc_gpio_bit) - 20usize];
    ["Offset of field: atom_smu_info_v3_2::ac_dc_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, ac_dc_polarity) - 21usize];
    ["Offset of field: atom_smu_info_v3_2::vr0hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, vr0hot_gpio_bit) - 22usize];
    ["Offset of field: atom_smu_info_v3_2::vr0hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, vr0hot_polarity) - 23usize];
    ["Offset of field: atom_smu_info_v3_2::vr1hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, vr1hot_gpio_bit) - 24usize];
    ["Offset of field: atom_smu_info_v3_2::vr1hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, vr1hot_polarity) - 25usize];
    ["Offset of field: atom_smu_info_v3_2::fw_ctf_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, fw_ctf_gpio_bit) - 26usize];
    ["Offset of field: atom_smu_info_v3_2::fw_ctf_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, fw_ctf_polarity) - 27usize];
    ["Offset of field: atom_smu_info_v3_2::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v3_2::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v3_2::smugoldenoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, smugoldenoffset) - 30usize];
    ["Offset of field: atom_smu_info_v3_2::gpupll_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, gpupll_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_dcefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_dcefclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v3_2::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v3_2::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, reserved) - 64usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_3 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub waflclk_ss_mode: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub ac_dc_gpio_bit: u8,
    pub ac_dc_polarity: u8,
    pub vr0hot_gpio_bit: u8,
    pub vr0hot_polarity: u8,
    pub vr1hot_gpio_bit: u8,
    pub vr1hot_polarity: u8,
    pub fw_ctf_gpio_bit: u8,
    pub fw_ctf_polarity: u8,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub gpupll_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_0_vco_freq_10khz: u32,
    pub syspll3_1_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_3"][::core::mem::size_of::<atom_smu_info_v3_3>() - 92usize];
    ["Alignment of atom_smu_info_v3_3"][::core::mem::align_of::<atom_smu_info_v3_3>() - 1usize];
    ["Offset of field: atom_smu_info_v3_3::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_3::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_3::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_3::waflclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, waflclk_ss_mode) - 6usize];
    ["Offset of field: atom_smu_info_v3_3::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_3::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_3::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_3::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_3::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_3::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_3::ac_dc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, ac_dc_gpio_bit) - 20usize];
    ["Offset of field: atom_smu_info_v3_3::ac_dc_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, ac_dc_polarity) - 21usize];
    ["Offset of field: atom_smu_info_v3_3::vr0hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, vr0hot_gpio_bit) - 22usize];
    ["Offset of field: atom_smu_info_v3_3::vr0hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, vr0hot_polarity) - 23usize];
    ["Offset of field: atom_smu_info_v3_3::vr1hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, vr1hot_gpio_bit) - 24usize];
    ["Offset of field: atom_smu_info_v3_3::vr1hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, vr1hot_polarity) - 25usize];
    ["Offset of field: atom_smu_info_v3_3::fw_ctf_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, fw_ctf_gpio_bit) - 26usize];
    ["Offset of field: atom_smu_info_v3_3::fw_ctf_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, fw_ctf_polarity) - 27usize];
    ["Offset of field: atom_smu_info_v3_3::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v3_3::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v3_3::smugoldenoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smugoldenoffset) - 30usize];
    ["Offset of field: atom_smu_info_v3_3::gpupll_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, gpupll_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_dcefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_dcefclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v3_3::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v3_3::syspll3_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, syspll3_0_vco_freq_10khz) - 64usize];
    ["Offset of field: atom_smu_info_v3_3::syspll3_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, syspll3_1_vco_freq_10khz) - 68usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_fclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_fclk_10khz) - 72usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_waflclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_waflclk_10khz) - 76usize];
    ["Offset of field: atom_smu_info_v3_3::smu_info_caps"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smu_info_caps) - 80usize];
    ["Offset of field: atom_smu_info_v3_3::waflclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, waflclk_ss_percentage) - 84usize];
    ["Offset of field: atom_smu_info_v3_3::smuinitoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smuinitoffset) - 86usize];
    ["Offset of field: atom_smu_info_v3_3::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, reserved) - 88usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_5 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub waflclk_ss_mode: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub syspll0_1_vco_freq_10khz: u32,
    pub syspll0_2_vco_freq_10khz: u32,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub syspll0_0_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_0_vco_freq_10khz: u32,
    pub syspll3_1_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub bootup_dprefclk_10khz: u32,
    pub bootup_usbclk_10khz: u32,
    pub smb_slave_address: u32,
    pub cg_fdo_ctrl0_val: u32,
    pub cg_fdo_ctrl1_val: u32,
    pub cg_fdo_ctrl2_val: u32,
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub bootup_dtbclk_10khz: u32,
    pub fclk_syspll_refclk_10khz: u32,
    pub smusvi_svc0_val: u32,
    pub smusvi_svc1_val: u32,
    pub smusvi_svd0_val: u32,
    pub smusvi_svd1_val: u32,
    pub smusvi_svt0_val: u32,
    pub smusvi_svt1_val: u32,
    pub cg_tach_ctrl_val: u32,
    pub cg_pump_ctrl1_val: u32,
    pub cg_pump_tach_ctrl_val: u32,
    pub thm_ctf_delay_val: u32,
    pub thm_thermal_int_ctrl_val: u32,
    pub thm_tmon_config_val: u32,
    pub reserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_5"][::core::mem::size_of::<atom_smu_info_v3_5>() - 240usize];
    ["Alignment of atom_smu_info_v3_5"][::core::mem::align_of::<atom_smu_info_v3_5>() - 1usize];
    ["Offset of field: atom_smu_info_v3_5::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_5::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_5::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_5::waflclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, waflclk_ss_mode) - 6usize];
    ["Offset of field: atom_smu_info_v3_5::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_5::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_5::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_5::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_5::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_5::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_5::syspll0_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll0_1_vco_freq_10khz) - 20usize];
    ["Offset of field: atom_smu_info_v3_5::syspll0_2_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll0_2_vco_freq_10khz) - 24usize];
    ["Offset of field: atom_smu_info_v3_5::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v3_5::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v3_5::smugoldenoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smugoldenoffset) - 30usize];
    ["Offset of field: atom_smu_info_v3_5::syspll0_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll0_0_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_dcefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_dcefclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v3_5::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v3_5::syspll3_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll3_0_vco_freq_10khz) - 64usize];
    ["Offset of field: atom_smu_info_v3_5::syspll3_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll3_1_vco_freq_10khz) - 68usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_fclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_fclk_10khz) - 72usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_waflclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_waflclk_10khz) - 76usize];
    ["Offset of field: atom_smu_info_v3_5::smu_info_caps"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smu_info_caps) - 80usize];
    ["Offset of field: atom_smu_info_v3_5::waflclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, waflclk_ss_percentage) - 84usize];
    ["Offset of field: atom_smu_info_v3_5::smuinitoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smuinitoffset) - 86usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_dprefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_dprefclk_10khz) - 88usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_usbclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_usbclk_10khz) - 92usize];
    ["Offset of field: atom_smu_info_v3_5::smb_slave_address"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smb_slave_address) - 96usize];
    ["Offset of field: atom_smu_info_v3_5::cg_fdo_ctrl0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_fdo_ctrl0_val) - 100usize];
    ["Offset of field: atom_smu_info_v3_5::cg_fdo_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_fdo_ctrl1_val) - 104usize];
    ["Offset of field: atom_smu_info_v3_5::cg_fdo_ctrl2_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_fdo_ctrl2_val) - 108usize];
    ["Offset of field: atom_smu_info_v3_5::gdfll_as_wait_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gdfll_as_wait_ctrl_val) - 112usize];
    ["Offset of field: atom_smu_info_v3_5::gdfll_as_step_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gdfll_as_step_ctrl_val) - 116usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_dtbclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_dtbclk_10khz) - 120usize];
    ["Offset of field: atom_smu_info_v3_5::fclk_syspll_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, fclk_syspll_refclk_10khz) - 124usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svc0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svc0_val) - 128usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svc1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svc1_val) - 132usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svd0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svd0_val) - 136usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svd1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svd1_val) - 140usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svt0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svt0_val) - 144usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svt1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svt1_val) - 148usize];
    ["Offset of field: atom_smu_info_v3_5::cg_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_tach_ctrl_val) - 152usize];
    ["Offset of field: atom_smu_info_v3_5::cg_pump_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_pump_ctrl1_val) - 156usize];
    ["Offset of field: atom_smu_info_v3_5::cg_pump_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_pump_tach_ctrl_val) - 160usize];
    ["Offset of field: atom_smu_info_v3_5::thm_ctf_delay_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, thm_ctf_delay_val) - 164usize];
    ["Offset of field: atom_smu_info_v3_5::thm_thermal_int_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, thm_thermal_int_ctrl_val) - 168usize];
    ["Offset of field: atom_smu_info_v3_5::thm_tmon_config_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, thm_tmon_config_val) - 172usize];
    ["Offset of field: atom_smu_info_v3_5::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, reserved) - 176usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_6 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub waflclk_ss_mode: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub syspll0_1_vco_freq_10khz: u32,
    pub syspll0_2_vco_freq_10khz: u32,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub syspll0_0_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dxioclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_0_vco_freq_10khz: u32,
    pub syspll3_1_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub bootup_gfxavsclk_10khz: u32,
    pub bootup_mpioclk_10khz: u32,
    pub smb_slave_address: u32,
    pub cg_fdo_ctrl0_val: u32,
    pub cg_fdo_ctrl1_val: u32,
    pub cg_fdo_ctrl2_val: u32,
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub reserved_clk: u32,
    pub fclk_syspll_refclk_10khz: u32,
    pub smusvi_svc0_val: u32,
    pub smusvi_svc1_val: u32,
    pub smusvi_svd0_val: u32,
    pub smusvi_svd1_val: u32,
    pub smusvi_svt0_val: u32,
    pub smusvi_svt1_val: u32,
    pub cg_tach_ctrl_val: u32,
    pub cg_pump_ctrl1_val: u32,
    pub cg_pump_tach_ctrl_val: u32,
    pub thm_ctf_delay_val: u32,
    pub thm_thermal_int_ctrl_val: u32,
    pub thm_tmon_config_val: u32,
    pub bootup_vclk_10khz: u32,
    pub bootup_dclk_10khz: u32,
    pub smu_gpiopad_pu_en_val: u32,
    pub smu_gpiopad_pd_en_val: u32,
    pub reserved: [u32; 12usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_6"][::core::mem::size_of::<atom_smu_info_v3_6>() - 240usize];
    ["Alignment of atom_smu_info_v3_6"][::core::mem::align_of::<atom_smu_info_v3_6>() - 1usize];
    ["Offset of field: atom_smu_info_v3_6::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_6::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_6::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_6::waflclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, waflclk_ss_mode) - 6usize];
    ["Offset of field: atom_smu_info_v3_6::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_6::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_6::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_6::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_6::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_6::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_6::syspll0_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll0_1_vco_freq_10khz) - 20usize];
    ["Offset of field: atom_smu_info_v3_6::syspll0_2_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll0_2_vco_freq_10khz) - 24usize];
    ["Offset of field: atom_smu_info_v3_6::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v3_6::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v3_6::smugoldenoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smugoldenoffset) - 30usize];
    ["Offset of field: atom_smu_info_v3_6::syspll0_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll0_0_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_dxioclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_dxioclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v3_6::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v3_6::syspll3_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll3_0_vco_freq_10khz) - 64usize];
    ["Offset of field: atom_smu_info_v3_6::syspll3_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll3_1_vco_freq_10khz) - 68usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_fclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_fclk_10khz) - 72usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_waflclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_waflclk_10khz) - 76usize];
    ["Offset of field: atom_smu_info_v3_6::smu_info_caps"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smu_info_caps) - 80usize];
    ["Offset of field: atom_smu_info_v3_6::waflclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, waflclk_ss_percentage) - 84usize];
    ["Offset of field: atom_smu_info_v3_6::smuinitoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smuinitoffset) - 86usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_gfxavsclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_gfxavsclk_10khz) - 88usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_mpioclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_mpioclk_10khz) - 92usize];
    ["Offset of field: atom_smu_info_v3_6::smb_slave_address"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smb_slave_address) - 96usize];
    ["Offset of field: atom_smu_info_v3_6::cg_fdo_ctrl0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_fdo_ctrl0_val) - 100usize];
    ["Offset of field: atom_smu_info_v3_6::cg_fdo_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_fdo_ctrl1_val) - 104usize];
    ["Offset of field: atom_smu_info_v3_6::cg_fdo_ctrl2_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_fdo_ctrl2_val) - 108usize];
    ["Offset of field: atom_smu_info_v3_6::gdfll_as_wait_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gdfll_as_wait_ctrl_val) - 112usize];
    ["Offset of field: atom_smu_info_v3_6::gdfll_as_step_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gdfll_as_step_ctrl_val) - 116usize];
    ["Offset of field: atom_smu_info_v3_6::reserved_clk"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, reserved_clk) - 120usize];
    ["Offset of field: atom_smu_info_v3_6::fclk_syspll_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, fclk_syspll_refclk_10khz) - 124usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svc0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svc0_val) - 128usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svc1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svc1_val) - 132usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svd0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svd0_val) - 136usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svd1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svd1_val) - 140usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svt0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svt0_val) - 144usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svt1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svt1_val) - 148usize];
    ["Offset of field: atom_smu_info_v3_6::cg_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_tach_ctrl_val) - 152usize];
    ["Offset of field: atom_smu_info_v3_6::cg_pump_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_pump_ctrl1_val) - 156usize];
    ["Offset of field: atom_smu_info_v3_6::cg_pump_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_pump_tach_ctrl_val) - 160usize];
    ["Offset of field: atom_smu_info_v3_6::thm_ctf_delay_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, thm_ctf_delay_val) - 164usize];
    ["Offset of field: atom_smu_info_v3_6::thm_thermal_int_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, thm_thermal_int_ctrl_val) - 168usize];
    ["Offset of field: atom_smu_info_v3_6::thm_tmon_config_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, thm_tmon_config_val) - 172usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_vclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_vclk_10khz) - 176usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_dclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_dclk_10khz) - 180usize];
    ["Offset of field: atom_smu_info_v3_6::smu_gpiopad_pu_en_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smu_gpiopad_pu_en_val) - 184usize];
    ["Offset of field: atom_smu_info_v3_6::smu_gpiopad_pd_en_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smu_gpiopad_pd_en_val) - 188usize];
    ["Offset of field: atom_smu_info_v3_6::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, reserved) - 192usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v4_0 {
    pub table_header: atom_common_table_header,
    pub bootup_gfxclk_bypass_10khz: u32,
    pub bootup_usrclk_10khz: u32,
    pub bootup_csrclk_10khz: u32,
    pub core_refclk_10khz: u32,
    pub syspll1_vco_freq_10khz: u32,
    pub syspll2_vco_freq_10khz: u32,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub bootup_vddusr_mv: u16,
    pub syspll0_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_vco_freq_10khz: u32,
    pub mm_syspll_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub bootup_dprefclk_10khz: u32,
    pub bootup_usbclk_10khz: u32,
    pub smb_slave_address: u32,
    pub cg_fdo_ctrl0_val: u32,
    pub cg_fdo_ctrl1_val: u32,
    pub cg_fdo_ctrl2_val: u32,
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub bootup_dtbclk_10khz: u32,
    pub fclk_syspll_refclk_10khz: u32,
    pub smusvi_svc0_val: u32,
    pub smusvi_svc1_val: u32,
    pub smusvi_svd0_val: u32,
    pub smusvi_svd1_val: u32,
    pub smusvi_svt0_val: u32,
    pub smusvi_svt1_val: u32,
    pub cg_tach_ctrl_val: u32,
    pub cg_pump_ctrl1_val: u32,
    pub cg_pump_tach_ctrl_val: u32,
    pub thm_ctf_delay_val: u32,
    pub thm_thermal_int_ctrl_val: u32,
    pub thm_tmon_config_val: u32,
    pub smbus_timing_cntrl0_val: u32,
    pub smbus_timing_cntrl1_val: u32,
    pub smbus_timing_cntrl2_val: u32,
    pub pwr_disp_timer_global_control_val: u32,
    pub bootup_mpioclk_10khz: u32,
    pub bootup_dclk0_10khz: u32,
    pub bootup_vclk0_10khz: u32,
    pub bootup_dclk1_10khz: u32,
    pub bootup_vclk1_10khz: u32,
    pub bootup_baco400clk_10khz: u32,
    pub bootup_baco1200clk_bypass_10khz: u32,
    pub bootup_baco700clk_bypass_10khz: u32,
    pub reserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v4_0"][::core::mem::size_of::<atom_smu_info_v4_0>() - 288usize];
    ["Alignment of atom_smu_info_v4_0"][::core::mem::align_of::<atom_smu_info_v4_0>() - 1usize];
    ["Offset of field: atom_smu_info_v4_0::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_gfxclk_bypass_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_gfxclk_bypass_10khz) - 4usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_usrclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_usrclk_10khz) - 8usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_csrclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_csrclk_10khz) - 12usize];
    ["Offset of field: atom_smu_info_v4_0::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v4_0::syspll1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, syspll1_vco_freq_10khz) - 20usize];
    ["Offset of field: atom_smu_info_v4_0::syspll2_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, syspll2_vco_freq_10khz) - 24usize];
    ["Offset of field: atom_smu_info_v4_0::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v4_0::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_vddusr_mv"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_vddusr_mv) - 30usize];
    ["Offset of field: atom_smu_info_v4_0::syspll0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, syspll0_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dcefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dcefclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v4_0::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v4_0::syspll3_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, syspll3_vco_freq_10khz) - 64usize];
    ["Offset of field: atom_smu_info_v4_0::mm_syspll_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, mm_syspll_vco_freq_10khz) - 68usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_fclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_fclk_10khz) - 72usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_waflclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_waflclk_10khz) - 76usize];
    ["Offset of field: atom_smu_info_v4_0::smu_info_caps"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smu_info_caps) - 80usize];
    ["Offset of field: atom_smu_info_v4_0::waflclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, waflclk_ss_percentage) - 84usize];
    ["Offset of field: atom_smu_info_v4_0::smuinitoffset"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smuinitoffset) - 86usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dprefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dprefclk_10khz) - 88usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_usbclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_usbclk_10khz) - 92usize];
    ["Offset of field: atom_smu_info_v4_0::smb_slave_address"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smb_slave_address) - 96usize];
    ["Offset of field: atom_smu_info_v4_0::cg_fdo_ctrl0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_fdo_ctrl0_val) - 100usize];
    ["Offset of field: atom_smu_info_v4_0::cg_fdo_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_fdo_ctrl1_val) - 104usize];
    ["Offset of field: atom_smu_info_v4_0::cg_fdo_ctrl2_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_fdo_ctrl2_val) - 108usize];
    ["Offset of field: atom_smu_info_v4_0::gdfll_as_wait_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, gdfll_as_wait_ctrl_val) - 112usize];
    ["Offset of field: atom_smu_info_v4_0::gdfll_as_step_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, gdfll_as_step_ctrl_val) - 116usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dtbclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dtbclk_10khz) - 120usize];
    ["Offset of field: atom_smu_info_v4_0::fclk_syspll_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, fclk_syspll_refclk_10khz) - 124usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svc0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svc0_val) - 128usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svc1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svc1_val) - 132usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svd0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svd0_val) - 136usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svd1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svd1_val) - 140usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svt0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svt0_val) - 144usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svt1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svt1_val) - 148usize];
    ["Offset of field: atom_smu_info_v4_0::cg_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_tach_ctrl_val) - 152usize];
    ["Offset of field: atom_smu_info_v4_0::cg_pump_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_pump_ctrl1_val) - 156usize];
    ["Offset of field: atom_smu_info_v4_0::cg_pump_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_pump_tach_ctrl_val) - 160usize];
    ["Offset of field: atom_smu_info_v4_0::thm_ctf_delay_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, thm_ctf_delay_val) - 164usize];
    ["Offset of field: atom_smu_info_v4_0::thm_thermal_int_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, thm_thermal_int_ctrl_val) - 168usize];
    ["Offset of field: atom_smu_info_v4_0::thm_tmon_config_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, thm_tmon_config_val) - 172usize];
    ["Offset of field: atom_smu_info_v4_0::smbus_timing_cntrl0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smbus_timing_cntrl0_val) - 176usize];
    ["Offset of field: atom_smu_info_v4_0::smbus_timing_cntrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smbus_timing_cntrl1_val) - 180usize];
    ["Offset of field: atom_smu_info_v4_0::smbus_timing_cntrl2_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smbus_timing_cntrl2_val) - 184usize];
    ["Offset of field: atom_smu_info_v4_0::pwr_disp_timer_global_control_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, pwr_disp_timer_global_control_val) - 188usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_mpioclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_mpioclk_10khz) - 192usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dclk0_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dclk0_10khz) - 196usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_vclk0_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_vclk0_10khz) - 200usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dclk1_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dclk1_10khz) - 204usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_vclk1_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_vclk1_10khz) - 208usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_baco400clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_baco400clk_10khz) - 212usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_baco1200clk_bypass_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_baco1200clk_bypass_10khz) - 216usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_baco700clk_bypass_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_baco700clk_bypass_10khz) - 220usize];
    ["Offset of field: atom_smu_info_v4_0::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, reserved) - 224usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub liquid1_i2c_address: u8,
    pub liquid2_i2c_address: u8,
    pub vr_i2c_address: u8,
    pub plx_i2c_address: u8,
    pub liquid_i2c_linescl: u8,
    pub liquid_i2c_linesda: u8,
    pub vr_i2c_linescl: u8,
    pub vr_i2c_linesda: u8,
    pub plx_i2c_linescl: u8,
    pub plx_i2c_linesda: u8,
    pub vrsensorpresent: u8,
    pub liquidsensorpresent: u8,
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmem0vrmapping: u8,
    pub vddmem1vrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub soculvphasesheddingmask: u8,
    pub padding8_v: [u8; 2usize],
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub mem0maxcurrent: u16,
    pub mem0offset: u8,
    pub padding_telemetrymem0: u8,
    pub mem1maxcurrent: u16,
    pub mem1offset: u8,
    pub padding_telemetrymem1: u8,
    pub acdcgpio: u8,
    pub acdcpolarity: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub padding1: u8,
    pub padding2: u8,
    pub ledpin0: u8,
    pub ledpin1: u8,
    pub ledpin2: u8,
    pub padding8_4: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub socclkspreadenabled: u8,
    pub socclkspreadpercent: u8,
    pub socclkspreadfreq: u16,
    pub acggfxclkspreadenabled: u8,
    pub acggfxclkspreadpercent: u8,
    pub acggfxclkspreadfreq: u16,
    pub Vr2_I2C_address: u8,
    pub padding_vr2: [u8; 3usize],
    pub boardreserved: [u32; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_1"][::core::mem::size_of::<atom_smc_dpm_info_v4_1>() - 112usize];
    ["Alignment of atom_smc_dpm_info_v4_1"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_1>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquid1_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquid1_i2c_address) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquid2_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquid2_i2c_address) - 5usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr_i2c_address) - 6usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::plx_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, plx_i2c_address) - 7usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquid_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquid_i2c_linescl) - 8usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquid_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquid_i2c_linesda) - 9usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr_i2c_linescl) - 10usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr_i2c_linesda) - 11usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::plx_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, plx_i2c_linescl) - 12usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::plx_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, plx_i2c_linesda) - 13usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vrsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vrsensorpresent) - 14usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquidsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquidsensorpresent) - 15usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::maxvoltagestepgfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, maxvoltagestepgfx) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::maxvoltagestepsoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, maxvoltagestepsoc) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vddgfxvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vddgfxvrmapping) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vddsocvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vddsocvrmapping) - 21usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vddmem0vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vddmem0vrmapping) - 22usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vddmem1vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vddmem1vrmapping) - 23usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::gfxulvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, gfxulvphasesheddingmask) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::soculvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, soculvphasesheddingmask) - 25usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding8_v"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding8_v) - 26usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::gfxmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, gfxmaxcurrent) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::gfxoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, gfxoffset) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_telemetrygfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_telemetrygfx) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socmaxcurrent) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socoffset) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_telemetrysoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_telemetrysoc) - 35usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::mem0maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, mem0maxcurrent) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::mem0offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, mem0offset) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_telemetrymem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_telemetrymem0) - 39usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::mem1maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, mem1maxcurrent) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::mem1offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, mem1offset) - 42usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_telemetrymem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_telemetrymem1) - 43usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acdcgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acdcgpio) - 44usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acdcpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acdcpolarity) - 45usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr0hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr0hotgpio) - 46usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr0hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr0hotpolarity) - 47usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr1hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr1hotgpio) - 48usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr1hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr1hotpolarity) - 49usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding1) - 50usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding2) - 51usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::ledpin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, ledpin0) - 52usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::ledpin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, ledpin1) - 53usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::ledpin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, ledpin2) - 54usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding8_4) - 55usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::pllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, pllgfxclkspreadenabled) - 56usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::pllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, pllgfxclkspreadpercent) - 57usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::pllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, pllgfxclkspreadfreq) - 58usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::uclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, uclkspreadenabled) - 60usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::uclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, uclkspreadpercent) - 61usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::uclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, uclkspreadfreq) - 62usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socclkspreadenabled) - 64usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socclkspreadpercent) - 65usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socclkspreadfreq) - 66usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acggfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acggfxclkspreadenabled) - 68usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acggfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acggfxclkspreadpercent) - 69usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acggfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acggfxclkspreadfreq) - 70usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::Vr2_I2C_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, Vr2_I2C_address) - 72usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_vr2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_vr2) - 73usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::boardreserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, boardreserved) - 76usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_3 {
    pub table_header: atom_common_table_header,
    pub liquid1_i2c_address: u8,
    pub liquid2_i2c_address: u8,
    pub vr_i2c_address: u8,
    pub plx_i2c_address: u8,
    pub liquid_i2c_linescl: u8,
    pub liquid_i2c_linesda: u8,
    pub vr_i2c_linescl: u8,
    pub vr_i2c_linesda: u8,
    pub plx_i2c_linescl: u8,
    pub plx_i2c_linesda: u8,
    pub vrsensorpresent: u8,
    pub liquidsensorpresent: u8,
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmem0vrmapping: u8,
    pub vddmem1vrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub soculvphasesheddingmask: u8,
    pub externalsensorpresent: u8,
    pub padding8_v: u8,
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub mem0maxcurrent: u16,
    pub mem0offset: u8,
    pub padding_telemetrymem0: u8,
    pub mem1maxcurrent: u16,
    pub mem1offset: u8,
    pub padding_telemetrymem1: u8,
    pub acdcgpio: u8,
    pub acdcpolarity: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub padding1: u8,
    pub padding2: u8,
    pub ledpin0: u8,
    pub ledpin1: u8,
    pub ledpin2: u8,
    pub padding8_4: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub fclkspreadenabled: u8,
    pub fclkspreadpercent: u8,
    pub fclkspreadfreq: u16,
    pub fllgfxclkspreadenabled: u8,
    pub fllgfxclkspreadpercent: u8,
    pub fllgfxclkspreadfreq: u16,
    pub boardreserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_3"][::core::mem::size_of::<atom_smc_dpm_info_v4_3>() - 112usize];
    ["Alignment of atom_smc_dpm_info_v4_3"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_3>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquid1_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquid1_i2c_address) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquid2_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquid2_i2c_address) - 5usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr_i2c_address) - 6usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::plx_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, plx_i2c_address) - 7usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquid_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquid_i2c_linescl) - 8usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquid_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquid_i2c_linesda) - 9usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr_i2c_linescl) - 10usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr_i2c_linesda) - 11usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::plx_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, plx_i2c_linescl) - 12usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::plx_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, plx_i2c_linesda) - 13usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vrsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vrsensorpresent) - 14usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquidsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquidsensorpresent) - 15usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::maxvoltagestepgfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, maxvoltagestepgfx) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::maxvoltagestepsoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, maxvoltagestepsoc) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vddgfxvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vddgfxvrmapping) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vddsocvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vddsocvrmapping) - 21usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vddmem0vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vddmem0vrmapping) - 22usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vddmem1vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vddmem1vrmapping) - 23usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::gfxulvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, gfxulvphasesheddingmask) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::soculvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, soculvphasesheddingmask) - 25usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::externalsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, externalsensorpresent) - 26usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding8_v"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding8_v) - 27usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::gfxmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, gfxmaxcurrent) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::gfxoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, gfxoffset) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding_telemetrygfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding_telemetrygfx) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::socmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, socmaxcurrent) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::socoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, socoffset) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding_telemetrysoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding_telemetrysoc) - 35usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::mem0maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, mem0maxcurrent) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::mem0offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, mem0offset) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding_telemetrymem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding_telemetrymem0) - 39usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::mem1maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, mem1maxcurrent) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::mem1offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, mem1offset) - 42usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding_telemetrymem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding_telemetrymem1) - 43usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::acdcgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, acdcgpio) - 44usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::acdcpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, acdcpolarity) - 45usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr0hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr0hotgpio) - 46usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr0hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr0hotpolarity) - 47usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr1hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr1hotgpio) - 48usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr1hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr1hotpolarity) - 49usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding1) - 50usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding2) - 51usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::ledpin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, ledpin0) - 52usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::ledpin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, ledpin1) - 53usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::ledpin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, ledpin2) - 54usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding8_4) - 55usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::pllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, pllgfxclkspreadenabled) - 56usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::pllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, pllgfxclkspreadpercent) - 57usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::pllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, pllgfxclkspreadfreq) - 58usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::uclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, uclkspreadenabled) - 60usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::uclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, uclkspreadpercent) - 61usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::uclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, uclkspreadfreq) - 62usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fclkspreadenabled) - 64usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fclkspreadpercent) - 65usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fclkspreadfreq) - 66usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fllgfxclkspreadenabled) - 68usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fllgfxclkspreadpercent) - 69usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fllgfxclkspreadfreq) - 70usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::boardreserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, boardreserved) - 72usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smudpm_i2ccontrollerconfig_t {
    pub enabled: u32,
    pub slaveaddress: u32,
    pub controllerport: u32,
    pub controllername: u32,
    pub thermalthrottler: u32,
    pub i2cprotocol: u32,
    pub i2cspeed: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smudpm_i2ccontrollerconfig_t"]
        [::core::mem::size_of::<smudpm_i2ccontrollerconfig_t>() - 28usize];
    ["Alignment of smudpm_i2ccontrollerconfig_t"]
        [::core::mem::align_of::<smudpm_i2ccontrollerconfig_t>() - 1usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::enabled"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, enabled) - 0usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::slaveaddress"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, slaveaddress) - 4usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::controllerport"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, controllerport) - 8usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::controllername"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, controllername) - 12usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::thermalthrottler"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, thermalthrottler) - 16usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::i2cprotocol"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, i2cprotocol) - 20usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::i2cspeed"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, i2cspeed) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_4 {
    pub table_header: atom_common_table_header,
    pub i2c_padding: [u32; 3usize],
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmem0vrmapping: u8,
    pub vddmem1vrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub soculvphasesheddingmask: u8,
    pub externalsensorpresent: u8,
    pub padding8_v: u8,
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub mem0maxcurrent: u16,
    pub mem0offset: u8,
    pub padding_telemetrymem0: u8,
    pub mem1maxcurrent: u16,
    pub mem1offset: u8,
    pub padding_telemetrymem1: u8,
    pub acdcgpio: u8,
    pub acdcpolarity: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub padding1: u8,
    pub padding2: u8,
    pub ledpin0: u8,
    pub ledpin1: u8,
    pub ledpin2: u8,
    pub padding8_4: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub fclkspreadenabled: u8,
    pub fclkspreadpercent: u8,
    pub fclkspreadfreq: u16,
    pub fllgfxclkspreadenabled: u8,
    pub fllgfxclkspreadpercent: u8,
    pub fllgfxclkspreadfreq: u16,
    pub i2ccontrollers: [smudpm_i2ccontrollerconfig_t; 7usize],
    pub boardreserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_4"][::core::mem::size_of::<atom_smc_dpm_info_v4_4>() - 308usize];
    ["Alignment of atom_smc_dpm_info_v4_4"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_4>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::i2c_padding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, i2c_padding) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::maxvoltagestepgfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, maxvoltagestepgfx) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::maxvoltagestepsoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, maxvoltagestepsoc) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vddgfxvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vddgfxvrmapping) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vddsocvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vddsocvrmapping) - 21usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vddmem0vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vddmem0vrmapping) - 22usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vddmem1vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vddmem1vrmapping) - 23usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::gfxulvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, gfxulvphasesheddingmask) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::soculvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, soculvphasesheddingmask) - 25usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::externalsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, externalsensorpresent) - 26usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding8_v"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding8_v) - 27usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::gfxmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, gfxmaxcurrent) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::gfxoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, gfxoffset) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding_telemetrygfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding_telemetrygfx) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::socmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, socmaxcurrent) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::socoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, socoffset) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding_telemetrysoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding_telemetrysoc) - 35usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::mem0maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, mem0maxcurrent) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::mem0offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, mem0offset) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding_telemetrymem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding_telemetrymem0) - 39usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::mem1maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, mem1maxcurrent) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::mem1offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, mem1offset) - 42usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding_telemetrymem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding_telemetrymem1) - 43usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::acdcgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, acdcgpio) - 44usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::acdcpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, acdcpolarity) - 45usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vr0hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vr0hotgpio) - 46usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vr0hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vr0hotpolarity) - 47usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vr1hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vr1hotgpio) - 48usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vr1hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vr1hotpolarity) - 49usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding1) - 50usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding2) - 51usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::ledpin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, ledpin0) - 52usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::ledpin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, ledpin1) - 53usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::ledpin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, ledpin2) - 54usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding8_4) - 55usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::pllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, pllgfxclkspreadenabled) - 56usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::pllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, pllgfxclkspreadpercent) - 57usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::pllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, pllgfxclkspreadfreq) - 58usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::uclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, uclkspreadenabled) - 60usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::uclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, uclkspreadpercent) - 61usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::uclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, uclkspreadfreq) - 62usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fclkspreadenabled) - 64usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fclkspreadpercent) - 65usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fclkspreadfreq) - 66usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fllgfxclkspreadenabled) - 68usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fllgfxclkspreadpercent) - 69usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fllgfxclkspreadfreq) - 70usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::i2ccontrollers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, i2ccontrollers) - 72usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::boardreserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, boardreserved) - 268usize];
};
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_GFX:
    smudpm_v4_5_i2ccontrollername_e = 0;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_SOC:
    smudpm_v4_5_i2ccontrollername_e = 1;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_VDDCI:
    smudpm_v4_5_i2ccontrollername_e = 2;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_MVDD:
    smudpm_v4_5_i2ccontrollername_e = 3;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_LIQUID0:
    smudpm_v4_5_i2ccontrollername_e = 4;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_LIQUID1:
    smudpm_v4_5_i2ccontrollername_e = 5;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_PLX:
    smudpm_v4_5_i2ccontrollername_e = 6;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_SPARE:
    smudpm_v4_5_i2ccontrollername_e = 7;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_COUNT:
    smudpm_v4_5_i2ccontrollername_e = 8;
pub type smudpm_v4_5_i2ccontrollername_e = ::core::ffi::c_uint;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_TYPE_NONE:
    smudpm_v4_5_i2ccontrollerthrottler_e = 0;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_GFX:
    smudpm_v4_5_i2ccontrollerthrottler_e = 1;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_SOC:
    smudpm_v4_5_i2ccontrollerthrottler_e = 2;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_VDDCI:
    smudpm_v4_5_i2ccontrollerthrottler_e = 3;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_MVDD:
    smudpm_v4_5_i2ccontrollerthrottler_e = 4;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_LIQUID0:
    smudpm_v4_5_i2ccontrollerthrottler_e = 5;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_LIQUID1:
    smudpm_v4_5_i2ccontrollerthrottler_e = 6;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_PLX:
    smudpm_v4_5_i2ccontrollerthrottler_e = 7;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_COUNT:
    smudpm_v4_5_i2ccontrollerthrottler_e = 8;
pub type smudpm_v4_5_i2ccontrollerthrottler_e = ::core::ffi::c_uint;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_VR_0:
    smudpm_v4_5_i2ccontrollerprotocol_e = 0;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_VR_1:
    smudpm_v4_5_i2ccontrollerprotocol_e = 1;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_TMP_0:
    smudpm_v4_5_i2ccontrollerprotocol_e = 2;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_TMP_1:
    smudpm_v4_5_i2ccontrollerprotocol_e = 3;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_SPARE_0:
    smudpm_v4_5_i2ccontrollerprotocol_e = 4;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_SPARE_1:
    smudpm_v4_5_i2ccontrollerprotocol_e = 5;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_COUNT:
    smudpm_v4_5_i2ccontrollerprotocol_e = 6;
pub type smudpm_v4_5_i2ccontrollerprotocol_e = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smudpm_i2c_controller_config_v2 {
    pub Enabled: u8,
    pub Speed: u8,
    pub Padding: [u8; 2usize],
    pub SlaveAddress: u32,
    pub ControllerPort: u8,
    pub ControllerName: u8,
    pub ThermalThrotter: u8,
    pub I2cProtocol: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smudpm_i2c_controller_config_v2"]
        [::core::mem::size_of::<smudpm_i2c_controller_config_v2>() - 12usize];
    ["Alignment of smudpm_i2c_controller_config_v2"]
        [::core::mem::align_of::<smudpm_i2c_controller_config_v2>() - 1usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::Enabled"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, Enabled) - 0usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::Speed"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, Speed) - 1usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::Padding"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, Padding) - 2usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::SlaveAddress"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, SlaveAddress) - 4usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::ControllerPort"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, ControllerPort) - 8usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::ControllerName"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, ControllerName) - 9usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::ThermalThrotter"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, ThermalThrotter) - 10usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::I2cProtocol"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, I2cProtocol) - 11usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_5 {
    pub table_header: atom_common_table_header,
    pub I2cControllers: [smudpm_i2c_controller_config_v2; 8usize],
    pub MaxVoltageStepGfx: u16,
    pub MaxVoltageStepSoc: u16,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub ExternalSensorPresent: u8,
    pub Padding8_V: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: u8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: u8,
    pub Padding_TelemetryMem1: u8,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub padding8_4: u8,
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub SoclkSpreadEnabled: u8,
    pub SocclkSpreadPercent: u8,
    pub SocclkSpreadFreq: u16,
    pub TotalBoardPower: u16,
    pub BoardPadding: u16,
    pub MvddRatio: u32,
    pub BoardReserved: [u32; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_5"][::core::mem::size_of::<atom_smc_dpm_info_v4_5>() - 200usize];
    ["Alignment of atom_smc_dpm_info_v4_5"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_5>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::I2cControllers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, I2cControllers) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::MaxVoltageStepGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, MaxVoltageStepGfx) - 100usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::MaxVoltageStepSoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, MaxVoltageStepSoc) - 102usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VddGfxVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VddGfxVrMapping) - 104usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VddSocVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VddSocVrMapping) - 105usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VddMem0VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VddMem0VrMapping) - 106usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VddMem1VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VddMem1VrMapping) - 107usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GfxUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GfxUlvPhaseSheddingMask) - 108usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocUlvPhaseSheddingMask) - 109usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::ExternalSensorPresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, ExternalSensorPresent) - 110usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding8_V"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding8_V) - 111usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GfxMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GfxMaxCurrent) - 112usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GfxOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GfxOffset) - 114usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding_TelemetryGfx) - 115usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocMaxCurrent) - 116usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocOffset) - 118usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding_TelemetrySoc) - 119usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Mem0MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Mem0MaxCurrent) - 120usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Mem0Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Mem0Offset) - 122usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding_TelemetryMem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding_TelemetryMem0) - 123usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Mem1MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Mem1MaxCurrent) - 124usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Mem1Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Mem1Offset) - 126usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding_TelemetryMem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding_TelemetryMem1) - 127usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::AcDcGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, AcDcGpio) - 128usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::AcDcPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, AcDcPolarity) - 129usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VR0HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VR0HotGpio) - 130usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VR0HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VR0HotPolarity) - 131usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VR1HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VR1HotGpio) - 132usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VR1HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VR1HotPolarity) - 133usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GthrGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GthrGpio) - 134usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GthrPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GthrPolarity) - 135usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::LedPin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, LedPin0) - 136usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::LedPin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, LedPin1) - 137usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::LedPin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, LedPin2) - 138usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, padding8_4) - 139usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::PllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, PllGfxclkSpreadEnabled) - 140usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::PllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, PllGfxclkSpreadPercent) - 141usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::PllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, PllGfxclkSpreadFreq) - 142usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::DfllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, DfllGfxclkSpreadEnabled) - 144usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::DfllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, DfllGfxclkSpreadPercent) - 145usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::DfllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, DfllGfxclkSpreadFreq) - 146usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::UclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, UclkSpreadEnabled) - 148usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::UclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, UclkSpreadPercent) - 149usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::UclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, UclkSpreadFreq) - 150usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SoclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SoclkSpreadEnabled) - 152usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocclkSpreadPercent) - 153usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocclkSpreadFreq) - 154usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::TotalBoardPower"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, TotalBoardPower) - 156usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::BoardPadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, BoardPadding) - 158usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::MvddRatio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, MvddRatio) - 160usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::BoardReserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, BoardReserved) - 164usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_6 {
    pub table_header: atom_common_table_header,
    pub i2c_padding: [u32; 3usize],
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmemvrmapping: u8,
    pub boardvrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub externalsensorpresent: u8,
    pub padding8_v: [u8; 2usize],
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub memmaxcurrent: u16,
    pub memoffset: u8,
    pub padding_telemetrymem: u8,
    pub boardmaxcurrent: u16,
    pub boardoffset: u8,
    pub padding_telemetryboardinput: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub fclkspreadenabled: u8,
    pub fclkspreadpercent: u8,
    pub fclkspreadfreq: u16,
    pub fllgfxclkspreadenabled: u8,
    pub fllgfxclkspreadpercent: u8,
    pub fllgfxclkspreadfreq: u16,
    pub i2ccontrollers: [smudpm_i2c_controller_config_v2; 8usize],
    pub memorychannelenabled: u32,
    pub drambitwidth: u8,
    pub paddingmem: [u8; 3usize],
    pub totalboardpower: u16,
    pub boardpadding: u16,
    pub xgmilinkspeed: [u8; 4usize],
    pub xgmilinkwidth: [u8; 4usize],
    pub xgmifclkfreq: [u16; 4usize],
    pub xgmisocvoltage: [u16; 4usize],
    pub boardreserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_6"][::core::mem::size_of::<atom_smc_dpm_info_v4_6>() - 236usize];
    ["Alignment of atom_smc_dpm_info_v4_6"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_6>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::i2c_padding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, i2c_padding) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::maxvoltagestepgfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, maxvoltagestepgfx) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::maxvoltagestepsoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, maxvoltagestepsoc) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vddgfxvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vddgfxvrmapping) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vddsocvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vddsocvrmapping) - 21usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vddmemvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vddmemvrmapping) - 22usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardvrmapping) - 23usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::gfxulvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, gfxulvphasesheddingmask) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::externalsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, externalsensorpresent) - 25usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding8_v"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding8_v) - 26usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::gfxmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, gfxmaxcurrent) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::gfxoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, gfxoffset) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding_telemetrygfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding_telemetrygfx) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::socmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, socmaxcurrent) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::socoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, socoffset) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding_telemetrysoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding_telemetrysoc) - 35usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::memmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, memmaxcurrent) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::memoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, memoffset) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding_telemetrymem"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding_telemetrymem) - 39usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardmaxcurrent) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardoffset) - 42usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding_telemetryboardinput"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding_telemetryboardinput) - 43usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vr0hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vr0hotgpio) - 44usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vr0hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vr0hotpolarity) - 45usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vr1hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vr1hotgpio) - 46usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vr1hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vr1hotpolarity) - 47usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::pllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, pllgfxclkspreadenabled) - 48usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::pllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, pllgfxclkspreadpercent) - 49usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::pllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, pllgfxclkspreadfreq) - 50usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::uclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, uclkspreadenabled) - 52usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::uclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, uclkspreadpercent) - 53usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::uclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, uclkspreadfreq) - 54usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fclkspreadenabled) - 56usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fclkspreadpercent) - 57usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fclkspreadfreq) - 58usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fllgfxclkspreadenabled) - 60usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fllgfxclkspreadpercent) - 61usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fllgfxclkspreadfreq) - 62usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::i2ccontrollers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, i2ccontrollers) - 64usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::memorychannelenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, memorychannelenabled) - 160usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::drambitwidth"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, drambitwidth) - 164usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::paddingmem"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, paddingmem) - 165usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::totalboardpower"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, totalboardpower) - 168usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardpadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardpadding) - 170usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::xgmilinkspeed"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, xgmilinkspeed) - 172usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::xgmilinkwidth"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, xgmilinkwidth) - 176usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::xgmifclkfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, xgmifclkfreq) - 180usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::xgmisocvoltage"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, xgmisocvoltage) - 188usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardreserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardreserved) - 196usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_7 {
    pub table_header: atom_common_table_header,
    pub I2cControllers: [smudpm_i2c_controller_config_v2; 8usize],
    pub MaxVoltageStepGfx: u16,
    pub MaxVoltageStepSoc: u16,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub ExternalSensorPresent: u8,
    pub Padding8_V: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: u8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: u8,
    pub Padding_TelemetryMem1: u8,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub padding8_4: u8,
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub SoclkSpreadEnabled: u8,
    pub SocclkSpreadPercent: u8,
    pub SocclkSpreadFreq: u16,
    pub TotalBoardPower: u16,
    pub BoardPadding: u16,
    pub MvddRatio: u32,
    pub GpioI2cScl: u8,
    pub GpioI2cSda: u8,
    pub GpioPadding: u16,
    pub LedPin3: u8,
    pub LedPin4: u8,
    pub LedEnableMask: u16,
    pub PowerLimitScalar: [u8; 4usize],
    pub MvddUlvPhaseSheddingMask: u8,
    pub VddciUlvPhaseSheddingMask: u8,
    pub Padding8_Psi1: u8,
    pub Padding8_Psi2: u8,
    pub BoardReserved: [u32; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_7"][::core::mem::size_of::<atom_smc_dpm_info_v4_7>() - 200usize];
    ["Alignment of atom_smc_dpm_info_v4_7"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_7>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::I2cControllers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, I2cControllers) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::MaxVoltageStepGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, MaxVoltageStepGfx) - 100usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::MaxVoltageStepSoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, MaxVoltageStepSoc) - 102usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddGfxVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddGfxVrMapping) - 104usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddSocVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddSocVrMapping) - 105usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddMem0VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddMem0VrMapping) - 106usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddMem1VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddMem1VrMapping) - 107usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GfxUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GfxUlvPhaseSheddingMask) - 108usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocUlvPhaseSheddingMask) - 109usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::ExternalSensorPresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, ExternalSensorPresent) - 110usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding8_V"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding8_V) - 111usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GfxMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GfxMaxCurrent) - 112usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GfxOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GfxOffset) - 114usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding_TelemetryGfx) - 115usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocMaxCurrent) - 116usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocOffset) - 118usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding_TelemetrySoc) - 119usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Mem0MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Mem0MaxCurrent) - 120usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Mem0Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Mem0Offset) - 122usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding_TelemetryMem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding_TelemetryMem0) - 123usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Mem1MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Mem1MaxCurrent) - 124usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Mem1Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Mem1Offset) - 126usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding_TelemetryMem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding_TelemetryMem1) - 127usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::AcDcGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, AcDcGpio) - 128usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::AcDcPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, AcDcPolarity) - 129usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VR0HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VR0HotGpio) - 130usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VR0HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VR0HotPolarity) - 131usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VR1HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VR1HotGpio) - 132usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VR1HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VR1HotPolarity) - 133usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GthrGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GthrGpio) - 134usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GthrPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GthrPolarity) - 135usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin0) - 136usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin1) - 137usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin2) - 138usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, padding8_4) - 139usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::PllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, PllGfxclkSpreadEnabled) - 140usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::PllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, PllGfxclkSpreadPercent) - 141usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::PllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, PllGfxclkSpreadFreq) - 142usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::DfllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, DfllGfxclkSpreadEnabled) - 144usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::DfllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, DfllGfxclkSpreadPercent) - 145usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::DfllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, DfllGfxclkSpreadFreq) - 146usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::UclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, UclkSpreadEnabled) - 148usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::UclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, UclkSpreadPercent) - 149usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::UclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, UclkSpreadFreq) - 150usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SoclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SoclkSpreadEnabled) - 152usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocclkSpreadPercent) - 153usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocclkSpreadFreq) - 154usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::TotalBoardPower"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, TotalBoardPower) - 156usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::BoardPadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, BoardPadding) - 158usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::MvddRatio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, MvddRatio) - 160usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GpioI2cScl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GpioI2cScl) - 164usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GpioI2cSda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GpioI2cSda) - 165usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GpioPadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GpioPadding) - 166usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin3"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin3) - 168usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin4) - 169usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedEnableMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedEnableMask) - 170usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::PowerLimitScalar"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, PowerLimitScalar) - 172usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::MvddUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, MvddUlvPhaseSheddingMask) - 176usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddciUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddciUlvPhaseSheddingMask) - 177usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding8_Psi1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding8_Psi1) - 178usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding8_Psi2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding8_Psi2) - 179usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::BoardReserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, BoardReserved) - 180usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct smudpm_i2c_controller_config_v3 {
    pub Enabled: u8,
    pub Speed: u8,
    pub SlaveAddress: u8,
    pub ControllerPort: u8,
    pub ControllerName: u8,
    pub ThermalThrotter: u8,
    pub I2cProtocol: u8,
    pub PaddingConfig: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smudpm_i2c_controller_config_v3"]
        [::core::mem::size_of::<smudpm_i2c_controller_config_v3>() - 8usize];
    ["Alignment of smudpm_i2c_controller_config_v3"]
        [::core::mem::align_of::<smudpm_i2c_controller_config_v3>() - 1usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::Enabled"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, Enabled) - 0usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::Speed"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, Speed) - 1usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::SlaveAddress"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, SlaveAddress) - 2usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::ControllerPort"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, ControllerPort) - 3usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::ControllerName"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, ControllerName) - 4usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::ThermalThrotter"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, ThermalThrotter) - 5usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::I2cProtocol"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, I2cProtocol) - 6usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::PaddingConfig"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, PaddingConfig) - 7usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_9 {
    pub table_header: atom_common_table_header,
    pub I2cControllers: [smudpm_i2c_controller_config_v3; 16usize],
    pub GpioScl: u8,
    pub GpioSda: u8,
    pub FchUsbPdSlaveAddr: u8,
    pub I2cSpare: u8,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub VddciUlvPhaseSheddingMask: u8,
    pub MvddUlvPhaseSheddingMask: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: u8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: u8,
    pub Padding_TelemetryMem1: u8,
    pub MvddRatio: u32,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub LedEnableMask: u8,
    pub LedPcie: u8,
    pub LedError: u8,
    pub LedSpare1: [u8; 2usize],
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub FclkSpreadEnabled: u8,
    pub FclkSpreadPercent: u8,
    pub FclkSpreadFreq: u16,
    pub MemoryChannelEnabled: u32,
    pub DramBitWidth: u8,
    pub PaddingMem1: [u8; 3usize],
    pub TotalBoardPower: u16,
    pub BoardPowerPadding: u16,
    pub XgmiLinkSpeed: [u8; 4usize],
    pub XgmiLinkWidth: [u8; 4usize],
    pub XgmiFclkFreq: [u16; 4usize],
    pub XgmiSocVoltage: [u16; 4usize],
    pub BoardReserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_9"][::core::mem::size_of::<atom_smc_dpm_info_v4_9>() - 296usize];
    ["Alignment of atom_smc_dpm_info_v4_9"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_9>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::I2cControllers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, I2cControllers) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GpioScl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GpioScl) - 132usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GpioSda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GpioSda) - 133usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::FchUsbPdSlaveAddr"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, FchUsbPdSlaveAddr) - 134usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::I2cSpare"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, I2cSpare) - 135usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddGfxVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddGfxVrMapping) - 136usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddSocVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddSocVrMapping) - 137usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddMem0VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddMem0VrMapping) - 138usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddMem1VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddMem1VrMapping) - 139usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GfxUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GfxUlvPhaseSheddingMask) - 140usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::SocUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, SocUlvPhaseSheddingMask) - 141usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddciUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddciUlvPhaseSheddingMask) - 142usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::MvddUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, MvddUlvPhaseSheddingMask) - 143usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GfxMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GfxMaxCurrent) - 144usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GfxOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GfxOffset) - 146usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Padding_TelemetryGfx) - 147usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::SocMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, SocMaxCurrent) - 148usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::SocOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, SocOffset) - 150usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Padding_TelemetrySoc) - 151usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Mem0MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Mem0MaxCurrent) - 152usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Mem0Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Mem0Offset) - 154usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Padding_TelemetryMem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Padding_TelemetryMem0) - 155usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Mem1MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Mem1MaxCurrent) - 156usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Mem1Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Mem1Offset) - 158usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Padding_TelemetryMem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Padding_TelemetryMem1) - 159usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::MvddRatio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, MvddRatio) - 160usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::AcDcGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, AcDcGpio) - 164usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::AcDcPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, AcDcPolarity) - 165usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VR0HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VR0HotGpio) - 166usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VR0HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VR0HotPolarity) - 167usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VR1HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VR1HotGpio) - 168usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VR1HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VR1HotPolarity) - 169usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GthrGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GthrGpio) - 170usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GthrPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GthrPolarity) - 171usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedPin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedPin0) - 172usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedPin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedPin1) - 173usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedPin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedPin2) - 174usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedEnableMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedEnableMask) - 175usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedPcie"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedPcie) - 176usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedError"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedError) - 177usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedSpare1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedSpare1) - 178usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::PllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, PllGfxclkSpreadEnabled) - 180usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::PllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, PllGfxclkSpreadPercent) - 181usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::PllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, PllGfxclkSpreadFreq) - 182usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::DfllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, DfllGfxclkSpreadEnabled) - 184usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::DfllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, DfllGfxclkSpreadPercent) - 185usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::DfllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, DfllGfxclkSpreadFreq) - 186usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::UclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, UclkSpreadEnabled) - 188usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::UclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, UclkSpreadPercent) - 189usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::UclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, UclkSpreadFreq) - 190usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::FclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, FclkSpreadEnabled) - 192usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::FclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, FclkSpreadPercent) - 193usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::FclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, FclkSpreadFreq) - 194usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::MemoryChannelEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, MemoryChannelEnabled) - 196usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::DramBitWidth"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, DramBitWidth) - 200usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::PaddingMem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, PaddingMem1) - 201usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::TotalBoardPower"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, TotalBoardPower) - 204usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::BoardPowerPadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, BoardPowerPadding) - 206usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::XgmiLinkSpeed"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, XgmiLinkSpeed) - 208usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::XgmiLinkWidth"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, XgmiLinkWidth) - 212usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::XgmiFclkFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, XgmiFclkFreq) - 216usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::XgmiSocVoltage"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, XgmiSocVoltage) - 224usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::BoardReserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, BoardReserved) - 232usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_10 {
    pub table_header: atom_common_table_header,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub MemMaxCurrent: u16,
    pub MemOffset: u8,
    pub Padding_TelemetryMem: u8,
    pub BoardMaxCurrent: u16,
    pub BoardOffset: u8,
    pub Padding_TelemetryBoardInput: u8,
    pub BoardVoltageCoeffA: u32,
    pub BoardVoltageCoeffB: u32,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub FclkSpreadEnabled: u8,
    pub FclkSpreadPercent: u8,
    pub FclkSpreadFreq: u16,
    pub I2cControllers: [smudpm_i2c_controller_config_v3; 8usize],
    pub GpioI2cScl: u8,
    pub GpioI2cSda: u8,
    pub spare5: u16,
    pub reserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_10"]
        [::core::mem::size_of::<atom_smc_dpm_info_v4_10>() - 172usize];
    ["Alignment of atom_smc_dpm_info_v4_10"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_10>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::GfxMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, GfxMaxCurrent) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::GfxOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, GfxOffset) - 6usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, Padding_TelemetryGfx) - 7usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::SocMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, SocMaxCurrent) - 8usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::SocOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, SocOffset) - 10usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, Padding_TelemetrySoc) - 11usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::MemMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, MemMaxCurrent) - 12usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::MemOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, MemOffset) - 14usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::Padding_TelemetryMem"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, Padding_TelemetryMem) - 15usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::BoardMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, BoardMaxCurrent) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::BoardOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, BoardOffset) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::Padding_TelemetryBoardInput"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, Padding_TelemetryBoardInput) - 19usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::BoardVoltageCoeffA"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, BoardVoltageCoeffA) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::BoardVoltageCoeffB"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, BoardVoltageCoeffB) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::VR0HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, VR0HotGpio) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::VR0HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, VR0HotPolarity) - 29usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::VR1HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, VR1HotGpio) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::VR1HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, VR1HotPolarity) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::UclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, UclkSpreadEnabled) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::UclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, UclkSpreadPercent) - 33usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::UclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, UclkSpreadFreq) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::FclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, FclkSpreadEnabled) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::FclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, FclkSpreadPercent) - 37usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::FclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, FclkSpreadFreq) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::I2cControllers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, I2cControllers) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::GpioI2cScl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, GpioI2cScl) - 104usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::GpioI2cSda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, GpioI2cSda) - 105usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::spare5"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, spare5) - 106usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::reserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, reserved) - 108usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_asic_profiling_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub maxvddc: u32,
    pub minvddc: u32,
    pub avfs_meannsigma_acontant0: u32,
    pub avfs_meannsigma_acontant1: u32,
    pub avfs_meannsigma_acontant2: u32,
    pub avfs_meannsigma_dc_tol_sigma: u16,
    pub avfs_meannsigma_platform_mean: u16,
    pub avfs_meannsigma_platform_sigma: u16,
    pub gb_vdroop_table_cksoff_a0: u32,
    pub gb_vdroop_table_cksoff_a1: u32,
    pub gb_vdroop_table_cksoff_a2: u32,
    pub gb_vdroop_table_ckson_a0: u32,
    pub gb_vdroop_table_ckson_a1: u32,
    pub gb_vdroop_table_ckson_a2: u32,
    pub avfsgb_fuse_table_cksoff_m1: u32,
    pub avfsgb_fuse_table_cksoff_m2: u32,
    pub avfsgb_fuse_table_cksoff_b: u32,
    pub avfsgb_fuse_table_ckson_m1: u32,
    pub avfsgb_fuse_table_ckson_m2: u32,
    pub avfsgb_fuse_table_ckson_b: u32,
    pub max_voltage_0_25mv: u16,
    pub enable_gb_vdroop_table_cksoff: u8,
    pub enable_gb_vdroop_table_ckson: u8,
    pub enable_gb_fuse_table_cksoff: u8,
    pub enable_gb_fuse_table_ckson: u8,
    pub psm_age_comfactor: u16,
    pub enable_apply_avfs_cksoff_voltage: u8,
    pub reserved: u8,
    pub dispclk2gfxclk_a: u32,
    pub dispclk2gfxclk_b: u32,
    pub dispclk2gfxclk_c: u32,
    pub pixclk2gfxclk_a: u32,
    pub pixclk2gfxclk_b: u32,
    pub pixclk2gfxclk_c: u32,
    pub dcefclk2gfxclk_a: u32,
    pub dcefclk2gfxclk_b: u32,
    pub dcefclk2gfxclk_c: u32,
    pub phyclk2gfxclk_a: u32,
    pub phyclk2gfxclk_b: u32,
    pub phyclk2gfxclk_c: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_asic_profiling_info_v4_1"]
        [::core::mem::size_of::<atom_asic_profiling_info_v4_1>() - 136usize];
    ["Alignment of atom_asic_profiling_info_v4_1"]
        [::core::mem::align_of::<atom_asic_profiling_info_v4_1>() - 1usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::table_header"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, table_header) - 0usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::maxvddc"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, maxvddc) - 4usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::minvddc"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, minvddc) - 8usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_acontant0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_acontant0
    ) - 12usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_acontant1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_acontant1
    ) - 16usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_acontant2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_acontant2
    ) - 20usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_dc_tol_sigma"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_dc_tol_sigma
    ) - 24usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_platform_mean"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_platform_mean
    ) - 26usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_platform_sigma"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_platform_sigma
    ) - 28usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_cksoff_a0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_cksoff_a0
    ) - 30usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_cksoff_a1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_cksoff_a1
    ) - 34usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_cksoff_a2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_cksoff_a2
    ) - 38usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_ckson_a0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_ckson_a0
    ) - 42usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_ckson_a1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_ckson_a1
    ) - 46usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_ckson_a2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_ckson_a2
    ) - 50usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_cksoff_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_cksoff_m1
    ) - 54usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_cksoff_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_cksoff_m2
    ) - 58usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_cksoff_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_cksoff_b
    ) - 62usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_ckson_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_ckson_m1
    ) - 66usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_ckson_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_ckson_m2
    ) - 70usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_ckson_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_ckson_b
    ) - 74usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::max_voltage_0_25mv"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, max_voltage_0_25mv) - 78usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_gb_vdroop_table_cksoff"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_gb_vdroop_table_cksoff
    ) - 80usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_gb_vdroop_table_ckson"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_gb_vdroop_table_ckson
    ) - 81usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_gb_fuse_table_cksoff"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_gb_fuse_table_cksoff
    ) - 82usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_gb_fuse_table_ckson"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_gb_fuse_table_ckson
    ) - 83usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::psm_age_comfactor"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, psm_age_comfactor) - 84usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_apply_avfs_cksoff_voltage"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_apply_avfs_cksoff_voltage
    )
        - 86usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::reserved"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, reserved) - 87usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dispclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dispclk2gfxclk_a) - 88usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dispclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dispclk2gfxclk_b) - 92usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dispclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dispclk2gfxclk_c) - 96usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::pixclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, pixclk2gfxclk_a) - 100usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::pixclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, pixclk2gfxclk_b) - 104usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::pixclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, pixclk2gfxclk_c) - 108usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dcefclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dcefclk2gfxclk_a) - 112usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dcefclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dcefclk2gfxclk_b) - 116usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dcefclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dcefclk2gfxclk_c) - 120usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::phyclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, phyclk2gfxclk_a) - 124usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::phyclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, phyclk2gfxclk_b) - 128usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::phyclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, phyclk2gfxclk_c) - 132usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_asic_profiling_info_v4_2 {
    pub table_header: atom_common_table_header,
    pub maxvddc: u32,
    pub minvddc: u32,
    pub avfs_meannsigma_acontant0: u32,
    pub avfs_meannsigma_acontant1: u32,
    pub avfs_meannsigma_acontant2: u32,
    pub avfs_meannsigma_dc_tol_sigma: u16,
    pub avfs_meannsigma_platform_mean: u16,
    pub avfs_meannsigma_platform_sigma: u16,
    pub gb_vdroop_table_cksoff_a0: u32,
    pub gb_vdroop_table_cksoff_a1: u32,
    pub gb_vdroop_table_cksoff_a2: u32,
    pub gb_vdroop_table_ckson_a0: u32,
    pub gb_vdroop_table_ckson_a1: u32,
    pub gb_vdroop_table_ckson_a2: u32,
    pub avfsgb_fuse_table_cksoff_m1: u32,
    pub avfsgb_fuse_table_cksoff_m2: u32,
    pub avfsgb_fuse_table_cksoff_b: u32,
    pub avfsgb_fuse_table_ckson_m1: u32,
    pub avfsgb_fuse_table_ckson_m2: u32,
    pub avfsgb_fuse_table_ckson_b: u32,
    pub max_voltage_0_25mv: u16,
    pub enable_gb_vdroop_table_cksoff: u8,
    pub enable_gb_vdroop_table_ckson: u8,
    pub enable_gb_fuse_table_cksoff: u8,
    pub enable_gb_fuse_table_ckson: u8,
    pub psm_age_comfactor: u16,
    pub enable_apply_avfs_cksoff_voltage: u8,
    pub reserved: u8,
    pub dispclk2gfxclk_a: u32,
    pub dispclk2gfxclk_b: u32,
    pub dispclk2gfxclk_c: u32,
    pub pixclk2gfxclk_a: u32,
    pub pixclk2gfxclk_b: u32,
    pub pixclk2gfxclk_c: u32,
    pub dcefclk2gfxclk_a: u32,
    pub dcefclk2gfxclk_b: u32,
    pub dcefclk2gfxclk_c: u32,
    pub phyclk2gfxclk_a: u32,
    pub phyclk2gfxclk_b: u32,
    pub phyclk2gfxclk_c: u32,
    pub acg_gb_vdroop_table_a0: u32,
    pub acg_gb_vdroop_table_a1: u32,
    pub acg_gb_vdroop_table_a2: u32,
    pub acg_avfsgb_fuse_table_m1: u32,
    pub acg_avfsgb_fuse_table_m2: u32,
    pub acg_avfsgb_fuse_table_b: u32,
    pub enable_acg_gb_vdroop_table: u8,
    pub enable_acg_gb_fuse_table: u8,
    pub acg_dispclk2gfxclk_a: u32,
    pub acg_dispclk2gfxclk_b: u32,
    pub acg_dispclk2gfxclk_c: u32,
    pub acg_pixclk2gfxclk_a: u32,
    pub acg_pixclk2gfxclk_b: u32,
    pub acg_pixclk2gfxclk_c: u32,
    pub acg_dcefclk2gfxclk_a: u32,
    pub acg_dcefclk2gfxclk_b: u32,
    pub acg_dcefclk2gfxclk_c: u32,
    pub acg_phyclk2gfxclk_a: u32,
    pub acg_phyclk2gfxclk_b: u32,
    pub acg_phyclk2gfxclk_c: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_asic_profiling_info_v4_2"]
        [::core::mem::size_of::<atom_asic_profiling_info_v4_2>() - 210usize];
    ["Alignment of atom_asic_profiling_info_v4_2"]
        [::core::mem::align_of::<atom_asic_profiling_info_v4_2>() - 1usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::table_header"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, table_header) - 0usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::maxvddc"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, maxvddc) - 4usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::minvddc"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, minvddc) - 8usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_acontant0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_acontant0
    ) - 12usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_acontant1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_acontant1
    ) - 16usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_acontant2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_acontant2
    ) - 20usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_dc_tol_sigma"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_dc_tol_sigma
    ) - 24usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_platform_mean"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_platform_mean
    ) - 26usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_platform_sigma"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_platform_sigma
    ) - 28usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_cksoff_a0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_cksoff_a0
    ) - 30usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_cksoff_a1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_cksoff_a1
    ) - 34usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_cksoff_a2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_cksoff_a2
    ) - 38usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_ckson_a0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_ckson_a0
    ) - 42usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_ckson_a1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_ckson_a1
    ) - 46usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_ckson_a2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_ckson_a2
    ) - 50usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_cksoff_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_cksoff_m1
    ) - 54usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_cksoff_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_cksoff_m2
    ) - 58usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_cksoff_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_cksoff_b
    ) - 62usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_ckson_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_ckson_m1
    ) - 66usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_ckson_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_ckson_m2
    ) - 70usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_ckson_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_ckson_b
    ) - 74usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::max_voltage_0_25mv"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, max_voltage_0_25mv) - 78usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_gb_vdroop_table_cksoff"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_gb_vdroop_table_cksoff
    ) - 80usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_gb_vdroop_table_ckson"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_gb_vdroop_table_ckson
    ) - 81usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_gb_fuse_table_cksoff"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_gb_fuse_table_cksoff
    ) - 82usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_gb_fuse_table_ckson"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_gb_fuse_table_ckson
    ) - 83usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::psm_age_comfactor"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, psm_age_comfactor) - 84usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_apply_avfs_cksoff_voltage"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_apply_avfs_cksoff_voltage
    )
        - 86usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::reserved"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, reserved) - 87usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dispclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dispclk2gfxclk_a) - 88usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dispclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dispclk2gfxclk_b) - 92usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dispclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dispclk2gfxclk_c) - 96usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::pixclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, pixclk2gfxclk_a) - 100usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::pixclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, pixclk2gfxclk_b) - 104usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::pixclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, pixclk2gfxclk_c) - 108usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dcefclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dcefclk2gfxclk_a) - 112usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dcefclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dcefclk2gfxclk_b) - 116usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dcefclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dcefclk2gfxclk_c) - 120usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::phyclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, phyclk2gfxclk_a) - 124usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::phyclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, phyclk2gfxclk_b) - 128usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::phyclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, phyclk2gfxclk_c) - 132usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_gb_vdroop_table_a0"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_gb_vdroop_table_a0) - 136usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_gb_vdroop_table_a1"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_gb_vdroop_table_a1) - 140usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_gb_vdroop_table_a2"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_gb_vdroop_table_a2) - 144usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_avfsgb_fuse_table_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        acg_avfsgb_fuse_table_m1
    ) - 148usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_avfsgb_fuse_table_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        acg_avfsgb_fuse_table_m2
    ) - 152usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_avfsgb_fuse_table_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        acg_avfsgb_fuse_table_b
    ) - 156usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_acg_gb_vdroop_table"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_acg_gb_vdroop_table
    ) - 160usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_acg_gb_fuse_table"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_acg_gb_fuse_table
    ) - 161usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dispclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dispclk2gfxclk_a) - 162usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dispclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dispclk2gfxclk_b) - 166usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dispclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dispclk2gfxclk_c) - 170usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_pixclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_pixclk2gfxclk_a) - 174usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_pixclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_pixclk2gfxclk_b) - 178usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_pixclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_pixclk2gfxclk_c) - 182usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dcefclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dcefclk2gfxclk_a) - 186usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dcefclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dcefclk2gfxclk_b) - 190usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dcefclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dcefclk2gfxclk_c) - 194usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_phyclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_phyclk2gfxclk_a) - 198usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_phyclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_phyclk2gfxclk_b) - 202usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_phyclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_phyclk2gfxclk_c) - 206usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_multimedia_info_v2_1 {
    pub table_header: atom_common_table_header,
    pub uvdip_min_ver: u8,
    pub uvdip_max_ver: u8,
    pub vceip_min_ver: u8,
    pub vceip_max_ver: u8,
    pub uvd_enc_max_input_width_pixels: u16,
    pub uvd_enc_max_input_height_pixels: u16,
    pub vce_enc_max_input_width_pixels: u16,
    pub vce_enc_max_input_height_pixels: u16,
    pub uvd_enc_max_bandwidth: u32,
    pub vce_enc_max_bandwidth: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_multimedia_info_v2_1"]
        [::core::mem::size_of::<atom_multimedia_info_v2_1>() - 24usize];
    ["Alignment of atom_multimedia_info_v2_1"]
        [::core::mem::align_of::<atom_multimedia_info_v2_1>() - 1usize];
    ["Offset of field: atom_multimedia_info_v2_1::table_header"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, table_header) - 0usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvdip_min_ver"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, uvdip_min_ver) - 4usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvdip_max_ver"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, uvdip_max_ver) - 5usize];
    ["Offset of field: atom_multimedia_info_v2_1::vceip_min_ver"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, vceip_min_ver) - 6usize];
    ["Offset of field: atom_multimedia_info_v2_1::vceip_max_ver"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, vceip_max_ver) - 7usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvd_enc_max_input_width_pixels"][::core::mem::offset_of!(
        atom_multimedia_info_v2_1,
        uvd_enc_max_input_width_pixels
    ) - 8usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvd_enc_max_input_height_pixels"][::core::mem::offset_of!(
        atom_multimedia_info_v2_1,
        uvd_enc_max_input_height_pixels
    ) - 10usize];
    ["Offset of field: atom_multimedia_info_v2_1::vce_enc_max_input_width_pixels"][::core::mem::offset_of!(
        atom_multimedia_info_v2_1,
        vce_enc_max_input_width_pixels
    ) - 12usize];
    ["Offset of field: atom_multimedia_info_v2_1::vce_enc_max_input_height_pixels"][::core::mem::offset_of!(
        atom_multimedia_info_v2_1,
        vce_enc_max_input_height_pixels
    ) - 14usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvd_enc_max_bandwidth"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, uvd_enc_max_bandwidth) - 16usize];
    ["Offset of field: atom_multimedia_info_v2_1::vce_enc_max_bandwidth"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, vce_enc_max_bandwidth) - 20usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v3_1 {
    pub table_header: atom_common_table_header,
    pub ucode_version: u32,
    pub ucode_rom_startaddr: u32,
    pub ucode_length: u32,
    pub umc_reg_init_offset: u16,
    pub customer_ucode_name_offset: u16,
    pub mclk_ss_percentage: u16,
    pub mclk_ss_rate_10hz: u16,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_info_v3_1"][::core::mem::size_of::<atom_umc_info_v3_1>() - 32usize];
    ["Alignment of atom_umc_info_v3_1"][::core::mem::align_of::<atom_umc_info_v3_1>() - 1usize];
    ["Offset of field: atom_umc_info_v3_1::table_header"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, table_header) - 0usize];
    ["Offset of field: atom_umc_info_v3_1::ucode_version"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, ucode_version) - 4usize];
    ["Offset of field: atom_umc_info_v3_1::ucode_rom_startaddr"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, ucode_rom_startaddr) - 8usize];
    ["Offset of field: atom_umc_info_v3_1::ucode_length"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, ucode_length) - 12usize];
    ["Offset of field: atom_umc_info_v3_1::umc_reg_init_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, umc_reg_init_offset) - 16usize];
    ["Offset of field: atom_umc_info_v3_1::customer_ucode_name_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, customer_ucode_name_offset) - 18usize];
    ["Offset of field: atom_umc_info_v3_1::mclk_ss_percentage"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, mclk_ss_percentage) - 20usize];
    ["Offset of field: atom_umc_info_v3_1::mclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, mclk_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_umc_info_v3_1::umcip_min_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, umcip_min_ver) - 24usize];
    ["Offset of field: atom_umc_info_v3_1::umcip_max_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, umcip_max_ver) - 25usize];
    ["Offset of field: atom_umc_info_v3_1::vram_type"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, vram_type) - 26usize];
    ["Offset of field: atom_umc_info_v3_1::umc_config"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, umc_config) - 27usize];
    ["Offset of field: atom_umc_info_v3_1::mem_refclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, mem_refclk_10khz) - 28usize];
};
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_1KB_INTERLEAVE_MODE: atom_umc_config_def = 1;
pub const atom_umc_config_def_UMC_CONFIG__DEFAULT_MEM_ECC_ENABLE: atom_umc_config_def = 2;
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_HBM_LANE_REPAIR: atom_umc_config_def = 4;
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_BANK_HARVESTING: atom_umc_config_def = 8;
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_PHY_REINIT: atom_umc_config_def = 16;
pub const atom_umc_config_def_UMC_CONFIG__DISABLE_UCODE_CHKSTATUS: atom_umc_config_def = 32;
pub type atom_umc_config_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v3_2 {
    pub table_header: atom_common_table_header,
    pub ucode_version: u32,
    pub ucode_rom_startaddr: u32,
    pub ucode_length: u32,
    pub umc_reg_init_offset: u16,
    pub customer_ucode_name_offset: u16,
    pub mclk_ss_percentage: u16,
    pub mclk_ss_rate_10hz: u16,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
    pub pstate_uclk_10khz: [u32; 4usize],
    pub umcgoldenoffset: u16,
    pub densitygoldenoffset: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_info_v3_2"][::core::mem::size_of::<atom_umc_info_v3_2>() - 52usize];
    ["Alignment of atom_umc_info_v3_2"][::core::mem::align_of::<atom_umc_info_v3_2>() - 1usize];
    ["Offset of field: atom_umc_info_v3_2::table_header"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, table_header) - 0usize];
    ["Offset of field: atom_umc_info_v3_2::ucode_version"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, ucode_version) - 4usize];
    ["Offset of field: atom_umc_info_v3_2::ucode_rom_startaddr"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, ucode_rom_startaddr) - 8usize];
    ["Offset of field: atom_umc_info_v3_2::ucode_length"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, ucode_length) - 12usize];
    ["Offset of field: atom_umc_info_v3_2::umc_reg_init_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umc_reg_init_offset) - 16usize];
    ["Offset of field: atom_umc_info_v3_2::customer_ucode_name_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, customer_ucode_name_offset) - 18usize];
    ["Offset of field: atom_umc_info_v3_2::mclk_ss_percentage"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, mclk_ss_percentage) - 20usize];
    ["Offset of field: atom_umc_info_v3_2::mclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, mclk_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_umc_info_v3_2::umcip_min_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umcip_min_ver) - 24usize];
    ["Offset of field: atom_umc_info_v3_2::umcip_max_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umcip_max_ver) - 25usize];
    ["Offset of field: atom_umc_info_v3_2::vram_type"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, vram_type) - 26usize];
    ["Offset of field: atom_umc_info_v3_2::umc_config"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umc_config) - 27usize];
    ["Offset of field: atom_umc_info_v3_2::mem_refclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, mem_refclk_10khz) - 28usize];
    ["Offset of field: atom_umc_info_v3_2::pstate_uclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, pstate_uclk_10khz) - 32usize];
    ["Offset of field: atom_umc_info_v3_2::umcgoldenoffset"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umcgoldenoffset) - 48usize];
    ["Offset of field: atom_umc_info_v3_2::densitygoldenoffset"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, densitygoldenoffset) - 50usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v3_3 {
    pub table_header: atom_common_table_header,
    pub ucode_reserved: u32,
    pub ucode_rom_startaddr: u32,
    pub ucode_length: u32,
    pub umc_reg_init_offset: u16,
    pub customer_ucode_name_offset: u16,
    pub mclk_ss_percentage: u16,
    pub mclk_ss_rate_10hz: u16,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
    pub pstate_uclk_10khz: [u32; 4usize],
    pub umcgoldenoffset: u16,
    pub densitygoldenoffset: u16,
    pub umc_config1: u32,
    pub bist_data_startaddr: u32,
    pub reserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_info_v3_3"][::core::mem::size_of::<atom_umc_info_v3_3>() - 68usize];
    ["Alignment of atom_umc_info_v3_3"][::core::mem::align_of::<atom_umc_info_v3_3>() - 1usize];
    ["Offset of field: atom_umc_info_v3_3::table_header"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, table_header) - 0usize];
    ["Offset of field: atom_umc_info_v3_3::ucode_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, ucode_reserved) - 4usize];
    ["Offset of field: atom_umc_info_v3_3::ucode_rom_startaddr"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, ucode_rom_startaddr) - 8usize];
    ["Offset of field: atom_umc_info_v3_3::ucode_length"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, ucode_length) - 12usize];
    ["Offset of field: atom_umc_info_v3_3::umc_reg_init_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umc_reg_init_offset) - 16usize];
    ["Offset of field: atom_umc_info_v3_3::customer_ucode_name_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, customer_ucode_name_offset) - 18usize];
    ["Offset of field: atom_umc_info_v3_3::mclk_ss_percentage"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, mclk_ss_percentage) - 20usize];
    ["Offset of field: atom_umc_info_v3_3::mclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, mclk_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_umc_info_v3_3::umcip_min_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umcip_min_ver) - 24usize];
    ["Offset of field: atom_umc_info_v3_3::umcip_max_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umcip_max_ver) - 25usize];
    ["Offset of field: atom_umc_info_v3_3::vram_type"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, vram_type) - 26usize];
    ["Offset of field: atom_umc_info_v3_3::umc_config"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umc_config) - 27usize];
    ["Offset of field: atom_umc_info_v3_3::mem_refclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, mem_refclk_10khz) - 28usize];
    ["Offset of field: atom_umc_info_v3_3::pstate_uclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, pstate_uclk_10khz) - 32usize];
    ["Offset of field: atom_umc_info_v3_3::umcgoldenoffset"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umcgoldenoffset) - 48usize];
    ["Offset of field: atom_umc_info_v3_3::densitygoldenoffset"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, densitygoldenoffset) - 50usize];
    ["Offset of field: atom_umc_info_v3_3::umc_config1"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umc_config1) - 52usize];
    ["Offset of field: atom_umc_info_v3_3::bist_data_startaddr"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, bist_data_startaddr) - 56usize];
    ["Offset of field: atom_umc_info_v3_3::reserved"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, reserved) - 60usize];
};
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_PSTATE_PHASE_STORE_TRAIN: atom_umc_config1_def =
    1;
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_AUTO_FRAMING: atom_umc_config1_def = 2;
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_RESTORE_BIST_DATA: atom_umc_config1_def = 4;
pub const atom_umc_config1_def_UMC_CONFIG1__DISABLE_STROBE_MODE: atom_umc_config1_def = 8;
pub const atom_umc_config1_def_UMC_CONFIG1__DEBUG_DATA_PARITY_EN: atom_umc_config1_def = 16;
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_ECC_CAPABLE: atom_umc_config1_def = 65536;
pub type atom_umc_config1_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v4_0 {
    pub table_header: atom_common_table_header,
    pub ucode_reserved: [u32; 5usize],
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
    pub clk_reserved: [u32; 4usize],
    pub golden_reserved: u32,
    pub umc_config1: u32,
    pub reserved: [u32; 2usize],
    pub channel_num: u8,
    pub channel_width: u8,
    pub channel_reserve: [u8; 2usize],
    pub umc_info_reserved: [u8; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_info_v4_0"][::core::mem::size_of::<atom_umc_info_v4_0>() - 84usize];
    ["Alignment of atom_umc_info_v4_0"][::core::mem::align_of::<atom_umc_info_v4_0>() - 1usize];
    ["Offset of field: atom_umc_info_v4_0::table_header"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, table_header) - 0usize];
    ["Offset of field: atom_umc_info_v4_0::ucode_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, ucode_reserved) - 4usize];
    ["Offset of field: atom_umc_info_v4_0::umcip_min_ver"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umcip_min_ver) - 24usize];
    ["Offset of field: atom_umc_info_v4_0::umcip_max_ver"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umcip_max_ver) - 25usize];
    ["Offset of field: atom_umc_info_v4_0::vram_type"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, vram_type) - 26usize];
    ["Offset of field: atom_umc_info_v4_0::umc_config"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umc_config) - 27usize];
    ["Offset of field: atom_umc_info_v4_0::mem_refclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, mem_refclk_10khz) - 28usize];
    ["Offset of field: atom_umc_info_v4_0::clk_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, clk_reserved) - 32usize];
    ["Offset of field: atom_umc_info_v4_0::golden_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, golden_reserved) - 48usize];
    ["Offset of field: atom_umc_info_v4_0::umc_config1"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umc_config1) - 52usize];
    ["Offset of field: atom_umc_info_v4_0::reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, reserved) - 56usize];
    ["Offset of field: atom_umc_info_v4_0::channel_num"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, channel_num) - 64usize];
    ["Offset of field: atom_umc_info_v4_0::channel_width"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, channel_width) - 65usize];
    ["Offset of field: atom_umc_info_v4_0::channel_reserve"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, channel_reserve) - 66usize];
    ["Offset of field: atom_umc_info_v4_0::umc_info_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umc_info_reserved) - 68usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v9 {
    pub memory_size: u32,
    pub channel_enable: u32,
    pub max_mem_clk: u32,
    pub reserved: [u16; 3usize],
    pub mem_voltage: u16,
    pub vram_module_size: u16,
    pub ext_memory_id: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub density: u8,
    pub tunningset_id: u8,
    pub vender_rev_id: u8,
    pub refreshrate: u8,
    pub hbm_ven_rev_id: u8,
    pub vram_rsd2: u8,
    pub dram_pnstring: [::core::ffi::c_char; 20usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_module_v9"][::core::mem::size_of::<atom_vram_module_v9>() - 52usize];
    ["Alignment of atom_vram_module_v9"][::core::mem::align_of::<atom_vram_module_v9>() - 1usize];
    ["Offset of field: atom_vram_module_v9::memory_size"]
        [::core::mem::offset_of!(atom_vram_module_v9, memory_size) - 0usize];
    ["Offset of field: atom_vram_module_v9::channel_enable"]
        [::core::mem::offset_of!(atom_vram_module_v9, channel_enable) - 4usize];
    ["Offset of field: atom_vram_module_v9::max_mem_clk"]
        [::core::mem::offset_of!(atom_vram_module_v9, max_mem_clk) - 8usize];
    ["Offset of field: atom_vram_module_v9::reserved"]
        [::core::mem::offset_of!(atom_vram_module_v9, reserved) - 12usize];
    ["Offset of field: atom_vram_module_v9::mem_voltage"]
        [::core::mem::offset_of!(atom_vram_module_v9, mem_voltage) - 18usize];
    ["Offset of field: atom_vram_module_v9::vram_module_size"]
        [::core::mem::offset_of!(atom_vram_module_v9, vram_module_size) - 20usize];
    ["Offset of field: atom_vram_module_v9::ext_memory_id"]
        [::core::mem::offset_of!(atom_vram_module_v9, ext_memory_id) - 22usize];
    ["Offset of field: atom_vram_module_v9::memory_type"]
        [::core::mem::offset_of!(atom_vram_module_v9, memory_type) - 23usize];
    ["Offset of field: atom_vram_module_v9::channel_num"]
        [::core::mem::offset_of!(atom_vram_module_v9, channel_num) - 24usize];
    ["Offset of field: atom_vram_module_v9::channel_width"]
        [::core::mem::offset_of!(atom_vram_module_v9, channel_width) - 25usize];
    ["Offset of field: atom_vram_module_v9::density"]
        [::core::mem::offset_of!(atom_vram_module_v9, density) - 26usize];
    ["Offset of field: atom_vram_module_v9::tunningset_id"]
        [::core::mem::offset_of!(atom_vram_module_v9, tunningset_id) - 27usize];
    ["Offset of field: atom_vram_module_v9::vender_rev_id"]
        [::core::mem::offset_of!(atom_vram_module_v9, vender_rev_id) - 28usize];
    ["Offset of field: atom_vram_module_v9::refreshrate"]
        [::core::mem::offset_of!(atom_vram_module_v9, refreshrate) - 29usize];
    ["Offset of field: atom_vram_module_v9::hbm_ven_rev_id"]
        [::core::mem::offset_of!(atom_vram_module_v9, hbm_ven_rev_id) - 30usize];
    ["Offset of field: atom_vram_module_v9::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_module_v9, vram_rsd2) - 31usize];
    ["Offset of field: atom_vram_module_v9::dram_pnstring"]
        [::core::mem::offset_of!(atom_vram_module_v9, dram_pnstring) - 32usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_3 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub mem_clk_patch_tbloffset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub tmrs_seq_offset: u16,
    pub post_ucode_init_offset: u16,
    pub vram_rsd2: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v9; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v2_3"]
        [::core::mem::size_of::<atom_vram_info_header_v2_3>() - 856usize];
    ["Alignment of atom_vram_info_header_v2_3"]
        [::core::mem::align_of::<atom_vram_info_header_v2_3>() - 1usize];
    ["Offset of field: atom_vram_info_header_v2_3::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v2_3::mem_adjust_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mem_adjust_tbloffset) - 4usize];
    ["Offset of field: atom_vram_info_header_v2_3::mem_clk_patch_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mem_clk_patch_tbloffset) - 6usize];
    ["Offset of field: atom_vram_info_header_v2_3::mc_adjust_pertile_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mc_adjust_pertile_tbloffset) - 8usize];
    ["Offset of field: atom_vram_info_header_v2_3::mc_phyinit_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mc_phyinit_tbloffset) - 10usize];
    ["Offset of field: atom_vram_info_header_v2_3::dram_data_remap_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, dram_data_remap_tbloffset) - 12usize];
    ["Offset of field: atom_vram_info_header_v2_3::tmrs_seq_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, tmrs_seq_offset) - 14usize];
    ["Offset of field: atom_vram_info_header_v2_3::post_ucode_init_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, post_ucode_init_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v2_3::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, vram_rsd2) - 18usize];
    ["Offset of field: atom_vram_info_header_v2_3::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v2_3::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v2_3::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v2_3::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v2_3::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, vram_module) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v3_0 {
    pub density: u8,
    pub tunningset_id: u8,
    pub ext_memory_id: u8,
    pub dram_vendor_id: u8,
    pub dram_info_offset: u16,
    pub mem_tuning_offset: u16,
    pub tmrs_seq_offset: u16,
    pub reserved1: u16,
    pub dram_size_per_ch: u32,
    pub reserved: [u32; 3usize],
    pub dram_pnstring: [::core::ffi::c_char; 40usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_module_v3_0"][::core::mem::size_of::<atom_vram_module_v3_0>() - 68usize];
    ["Alignment of atom_vram_module_v3_0"]
        [::core::mem::align_of::<atom_vram_module_v3_0>() - 1usize];
    ["Offset of field: atom_vram_module_v3_0::density"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, density) - 0usize];
    ["Offset of field: atom_vram_module_v3_0::tunningset_id"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, tunningset_id) - 1usize];
    ["Offset of field: atom_vram_module_v3_0::ext_memory_id"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, ext_memory_id) - 2usize];
    ["Offset of field: atom_vram_module_v3_0::dram_vendor_id"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, dram_vendor_id) - 3usize];
    ["Offset of field: atom_vram_module_v3_0::dram_info_offset"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, dram_info_offset) - 4usize];
    ["Offset of field: atom_vram_module_v3_0::mem_tuning_offset"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, mem_tuning_offset) - 6usize];
    ["Offset of field: atom_vram_module_v3_0::tmrs_seq_offset"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, tmrs_seq_offset) - 8usize];
    ["Offset of field: atom_vram_module_v3_0::reserved1"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, reserved1) - 10usize];
    ["Offset of field: atom_vram_module_v3_0::dram_size_per_ch"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, dram_size_per_ch) - 12usize];
    ["Offset of field: atom_vram_module_v3_0::reserved"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, reserved) - 16usize];
    ["Offset of field: atom_vram_module_v3_0::dram_pnstring"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, dram_pnstring) - 28usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v3_0 {
    pub table_header: atom_common_table_header,
    pub mem_tuning_table_offset: u16,
    pub dram_info_table_offset: u16,
    pub tmrs_table_offset: u16,
    pub mc_init_table_offset: u16,
    pub dram_data_remap_table_offset: u16,
    pub umc_emuinittable_offset: u16,
    pub reserved_sub_table_offset: [u16; 2usize],
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub reserved1: u8,
    pub channel_enable: u32,
    pub channel1_enable: u32,
    pub feature_enable: u32,
    pub feature1_enable: u32,
    pub hardcode_mem_size: u32,
    pub reserved4: [u32; 4usize],
    pub vram_module: [atom_vram_module_v3_0; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v3_0"]
        [::core::mem::size_of::<atom_vram_info_header_v3_0>() - 608usize];
    ["Alignment of atom_vram_info_header_v3_0"]
        [::core::mem::align_of::<atom_vram_info_header_v3_0>() - 1usize];
    ["Offset of field: atom_vram_info_header_v3_0::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v3_0::mem_tuning_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, mem_tuning_table_offset) - 4usize];
    ["Offset of field: atom_vram_info_header_v3_0::dram_info_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, dram_info_table_offset) - 6usize];
    ["Offset of field: atom_vram_info_header_v3_0::tmrs_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, tmrs_table_offset) - 8usize];
    ["Offset of field: atom_vram_info_header_v3_0::mc_init_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, mc_init_table_offset) - 10usize];
    ["Offset of field: atom_vram_info_header_v3_0::dram_data_remap_table_offset"][::core::mem::offset_of!(
        atom_vram_info_header_v3_0,
        dram_data_remap_table_offset
    ) - 12usize];
    ["Offset of field: atom_vram_info_header_v3_0::umc_emuinittable_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, umc_emuinittable_offset) - 14usize];
    ["Offset of field: atom_vram_info_header_v3_0::reserved_sub_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, reserved_sub_table_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v3_0::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v3_0::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v3_0::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v3_0::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v3_0::memory_type"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, memory_type) - 24usize];
    ["Offset of field: atom_vram_info_header_v3_0::channel_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, channel_num) - 25usize];
    ["Offset of field: atom_vram_info_header_v3_0::channel_width"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, channel_width) - 26usize];
    ["Offset of field: atom_vram_info_header_v3_0::reserved1"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, reserved1) - 27usize];
    ["Offset of field: atom_vram_info_header_v3_0::channel_enable"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, channel_enable) - 28usize];
    ["Offset of field: atom_vram_info_header_v3_0::channel1_enable"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, channel1_enable) - 32usize];
    ["Offset of field: atom_vram_info_header_v3_0::feature_enable"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, feature_enable) - 36usize];
    ["Offset of field: atom_vram_info_header_v3_0::feature1_enable"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, feature1_enable) - 40usize];
    ["Offset of field: atom_vram_info_header_v3_0::hardcode_mem_size"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, hardcode_mem_size) - 44usize];
    ["Offset of field: atom_vram_info_header_v3_0::reserved4"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, reserved4) - 48usize];
    ["Offset of field: atom_vram_info_header_v3_0::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, vram_module) - 64usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_register_addr_info {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_register_addr_info"]
        [::core::mem::size_of::<atom_umc_register_addr_info>() - 4usize];
    ["Alignment of atom_umc_register_addr_info"]
        [::core::mem::align_of::<atom_umc_register_addr_info>() - 1usize];
};
impl atom_umc_register_addr_info {
    #[inline]
    pub fn umc_register_addr(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_umc_register_addr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn umc_reg_type_ind(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_umc_reg_type_ind(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn umc_reg_rsvd(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(25usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_umc_reg_rsvd(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(25usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        umc_register_addr: u32,
        umc_reg_type_ind: u32,
        umc_reg_rsvd: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let umc_register_addr: u32 = unsafe { ::core::mem::transmute(umc_register_addr) };
            umc_register_addr as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let umc_reg_type_ind: u32 = unsafe { ::core::mem::transmute(umc_reg_type_ind) };
            umc_reg_type_ind as u64
        });
        __bindgen_bitfield_unit.set(25usize, 7u8, {
            let umc_reg_rsvd: u32 = unsafe { ::core::mem::transmute(umc_reg_rsvd) };
            umc_reg_rsvd as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const atom_umc_register_addr_info_flag_b3ATOM_UMC_REG_ADD_INFO_INDIRECT_ACCESS:
    atom_umc_register_addr_info_flag = 1;
pub type atom_umc_register_addr_info_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union atom_umc_register_addr_info_access {
    pub umc_reg_addr: atom_umc_register_addr_info,
    pub u32umc_reg_addr: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_register_addr_info_access"]
        [::core::mem::size_of::<atom_umc_register_addr_info_access>() - 4usize];
    ["Alignment of atom_umc_register_addr_info_access"]
        [::core::mem::align_of::<atom_umc_register_addr_info_access>() - 1usize];
    ["Offset of field: atom_umc_register_addr_info_access::umc_reg_addr"]
        [::core::mem::offset_of!(atom_umc_register_addr_info_access, umc_reg_addr) - 0usize];
    ["Offset of field: atom_umc_register_addr_info_access::u32umc_reg_addr"]
        [::core::mem::offset_of!(atom_umc_register_addr_info_access, u32umc_reg_addr) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_reg_setting_id_config {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_reg_setting_id_config"]
        [::core::mem::size_of::<atom_umc_reg_setting_id_config>() - 4usize];
    ["Alignment of atom_umc_reg_setting_id_config"]
        [::core::mem::align_of::<atom_umc_reg_setting_id_config>() - 1usize];
};
impl atom_umc_reg_setting_id_config {
    #[inline]
    pub fn memclockrange(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_memclockrange(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn mem_blk_id(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_mem_blk_id(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        memclockrange: u32,
        mem_blk_id: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let memclockrange: u32 = unsafe { ::core::mem::transmute(memclockrange) };
            memclockrange as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let mem_blk_id: u32 = unsafe { ::core::mem::transmute(mem_blk_id) };
            mem_blk_id as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union atom_umc_reg_setting_id_config_access {
    pub umc_id_access: atom_umc_reg_setting_id_config,
    pub u32umc_id_access: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_reg_setting_id_config_access"]
        [::core::mem::size_of::<atom_umc_reg_setting_id_config_access>() - 4usize];
    ["Alignment of atom_umc_reg_setting_id_config_access"]
        [::core::mem::align_of::<atom_umc_reg_setting_id_config_access>() - 1usize];
    ["Offset of field: atom_umc_reg_setting_id_config_access::umc_id_access"]
        [::core::mem::offset_of!(atom_umc_reg_setting_id_config_access, umc_id_access) - 0usize];
    ["Offset of field: atom_umc_reg_setting_id_config_access::u32umc_id_access"]
        [::core::mem::offset_of!(atom_umc_reg_setting_id_config_access, u32umc_id_access) - 0usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct atom_umc_reg_setting_data_block {
    pub block_id: atom_umc_reg_setting_id_config_access,
    pub u32umc_reg_data: [u32; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_reg_setting_data_block"]
        [::core::mem::size_of::<atom_umc_reg_setting_data_block>() - 8usize];
    ["Alignment of atom_umc_reg_setting_data_block"]
        [::core::mem::align_of::<atom_umc_reg_setting_data_block>() - 1usize];
    ["Offset of field: atom_umc_reg_setting_data_block::block_id"]
        [::core::mem::offset_of!(atom_umc_reg_setting_data_block, block_id) - 0usize];
    ["Offset of field: atom_umc_reg_setting_data_block::u32umc_reg_data"]
        [::core::mem::offset_of!(atom_umc_reg_setting_data_block, u32umc_reg_data) - 4usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct atom_umc_init_reg_block {
    pub umc_reg_num: u16,
    pub reserved: u16,
    pub umc_reg_list: [atom_umc_register_addr_info_access; 1usize],
    pub umc_reg_setting_list: [atom_umc_reg_setting_data_block; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_init_reg_block"]
        [::core::mem::size_of::<atom_umc_init_reg_block>() - 16usize];
    ["Alignment of atom_umc_init_reg_block"]
        [::core::mem::align_of::<atom_umc_init_reg_block>() - 1usize];
    ["Offset of field: atom_umc_init_reg_block::umc_reg_num"]
        [::core::mem::offset_of!(atom_umc_init_reg_block, umc_reg_num) - 0usize];
    ["Offset of field: atom_umc_init_reg_block::reserved"]
        [::core::mem::offset_of!(atom_umc_init_reg_block, reserved) - 2usize];
    ["Offset of field: atom_umc_init_reg_block::umc_reg_list"]
        [::core::mem::offset_of!(atom_umc_init_reg_block, umc_reg_list) - 4usize];
    ["Offset of field: atom_umc_init_reg_block::umc_reg_setting_list"]
        [::core::mem::offset_of!(atom_umc_init_reg_block, umc_reg_setting_list) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v10 {
    pub memory_size: u32,
    pub channel_enable: u32,
    pub max_mem_clk: u32,
    pub reserved: [u16; 3usize],
    pub mem_voltage: u16,
    pub vram_module_size: u16,
    pub ext_memory_id: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub density: u8,
    pub tunningset_id: u8,
    pub vender_rev_id: u8,
    pub refreshrate: u8,
    pub vram_flags: u8,
    pub vram_rsd2: u8,
    pub gddr6_mr10: u16,
    pub gddr6_mr1: u16,
    pub gddr6_mr2: u16,
    pub gddr6_mr7: u16,
    pub dram_pnstring: [::core::ffi::c_char; 20usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_module_v10"][::core::mem::size_of::<atom_vram_module_v10>() - 60usize];
    ["Alignment of atom_vram_module_v10"][::core::mem::align_of::<atom_vram_module_v10>() - 1usize];
    ["Offset of field: atom_vram_module_v10::memory_size"]
        [::core::mem::offset_of!(atom_vram_module_v10, memory_size) - 0usize];
    ["Offset of field: atom_vram_module_v10::channel_enable"]
        [::core::mem::offset_of!(atom_vram_module_v10, channel_enable) - 4usize];
    ["Offset of field: atom_vram_module_v10::max_mem_clk"]
        [::core::mem::offset_of!(atom_vram_module_v10, max_mem_clk) - 8usize];
    ["Offset of field: atom_vram_module_v10::reserved"]
        [::core::mem::offset_of!(atom_vram_module_v10, reserved) - 12usize];
    ["Offset of field: atom_vram_module_v10::mem_voltage"]
        [::core::mem::offset_of!(atom_vram_module_v10, mem_voltage) - 18usize];
    ["Offset of field: atom_vram_module_v10::vram_module_size"]
        [::core::mem::offset_of!(atom_vram_module_v10, vram_module_size) - 20usize];
    ["Offset of field: atom_vram_module_v10::ext_memory_id"]
        [::core::mem::offset_of!(atom_vram_module_v10, ext_memory_id) - 22usize];
    ["Offset of field: atom_vram_module_v10::memory_type"]
        [::core::mem::offset_of!(atom_vram_module_v10, memory_type) - 23usize];
    ["Offset of field: atom_vram_module_v10::channel_num"]
        [::core::mem::offset_of!(atom_vram_module_v10, channel_num) - 24usize];
    ["Offset of field: atom_vram_module_v10::channel_width"]
        [::core::mem::offset_of!(atom_vram_module_v10, channel_width) - 25usize];
    ["Offset of field: atom_vram_module_v10::density"]
        [::core::mem::offset_of!(atom_vram_module_v10, density) - 26usize];
    ["Offset of field: atom_vram_module_v10::tunningset_id"]
        [::core::mem::offset_of!(atom_vram_module_v10, tunningset_id) - 27usize];
    ["Offset of field: atom_vram_module_v10::vender_rev_id"]
        [::core::mem::offset_of!(atom_vram_module_v10, vender_rev_id) - 28usize];
    ["Offset of field: atom_vram_module_v10::refreshrate"]
        [::core::mem::offset_of!(atom_vram_module_v10, refreshrate) - 29usize];
    ["Offset of field: atom_vram_module_v10::vram_flags"]
        [::core::mem::offset_of!(atom_vram_module_v10, vram_flags) - 30usize];
    ["Offset of field: atom_vram_module_v10::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_module_v10, vram_rsd2) - 31usize];
    ["Offset of field: atom_vram_module_v10::gddr6_mr10"]
        [::core::mem::offset_of!(atom_vram_module_v10, gddr6_mr10) - 32usize];
    ["Offset of field: atom_vram_module_v10::gddr6_mr1"]
        [::core::mem::offset_of!(atom_vram_module_v10, gddr6_mr1) - 34usize];
    ["Offset of field: atom_vram_module_v10::gddr6_mr2"]
        [::core::mem::offset_of!(atom_vram_module_v10, gddr6_mr2) - 36usize];
    ["Offset of field: atom_vram_module_v10::gddr6_mr7"]
        [::core::mem::offset_of!(atom_vram_module_v10, gddr6_mr7) - 38usize];
    ["Offset of field: atom_vram_module_v10::dram_pnstring"]
        [::core::mem::offset_of!(atom_vram_module_v10, dram_pnstring) - 40usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_4 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub mem_clk_patch_tbloffset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub reserved: u16,
    pub post_ucode_init_offset: u16,
    pub vram_rsd2: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v10; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v2_4"]
        [::core::mem::size_of::<atom_vram_info_header_v2_4>() - 984usize];
    ["Alignment of atom_vram_info_header_v2_4"]
        [::core::mem::align_of::<atom_vram_info_header_v2_4>() - 1usize];
    ["Offset of field: atom_vram_info_header_v2_4::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v2_4::mem_adjust_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mem_adjust_tbloffset) - 4usize];
    ["Offset of field: atom_vram_info_header_v2_4::mem_clk_patch_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mem_clk_patch_tbloffset) - 6usize];
    ["Offset of field: atom_vram_info_header_v2_4::mc_adjust_pertile_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mc_adjust_pertile_tbloffset) - 8usize];
    ["Offset of field: atom_vram_info_header_v2_4::mc_phyinit_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mc_phyinit_tbloffset) - 10usize];
    ["Offset of field: atom_vram_info_header_v2_4::dram_data_remap_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, dram_data_remap_tbloffset) - 12usize];
    ["Offset of field: atom_vram_info_header_v2_4::reserved"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, reserved) - 14usize];
    ["Offset of field: atom_vram_info_header_v2_4::post_ucode_init_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, post_ucode_init_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v2_4::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, vram_rsd2) - 18usize];
    ["Offset of field: atom_vram_info_header_v2_4::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v2_4::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v2_4::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v2_4::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v2_4::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, vram_module) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v11 {
    pub memory_size: u32,
    pub channel_enable: u32,
    pub mem_voltage: u16,
    pub vram_module_size: u16,
    pub ext_memory_id: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub density: u8,
    pub tunningset_id: u8,
    pub reserved: [u16; 4usize],
    pub vender_rev_id: u8,
    pub refreshrate: u8,
    pub vram_flags: u8,
    pub vram_rsd2: u8,
    pub gddr6_mr10: u16,
    pub gddr6_mr0: u16,
    pub gddr6_mr1: u16,
    pub gddr6_mr2: u16,
    pub gddr6_mr4: u16,
    pub gddr6_mr7: u16,
    pub gddr6_mr8: u16,
    pub dram_pnstring: [::core::ffi::c_char; 40usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_module_v11"][::core::mem::size_of::<atom_vram_module_v11>() - 84usize];
    ["Alignment of atom_vram_module_v11"][::core::mem::align_of::<atom_vram_module_v11>() - 1usize];
    ["Offset of field: atom_vram_module_v11::memory_size"]
        [::core::mem::offset_of!(atom_vram_module_v11, memory_size) - 0usize];
    ["Offset of field: atom_vram_module_v11::channel_enable"]
        [::core::mem::offset_of!(atom_vram_module_v11, channel_enable) - 4usize];
    ["Offset of field: atom_vram_module_v11::mem_voltage"]
        [::core::mem::offset_of!(atom_vram_module_v11, mem_voltage) - 8usize];
    ["Offset of field: atom_vram_module_v11::vram_module_size"]
        [::core::mem::offset_of!(atom_vram_module_v11, vram_module_size) - 10usize];
    ["Offset of field: atom_vram_module_v11::ext_memory_id"]
        [::core::mem::offset_of!(atom_vram_module_v11, ext_memory_id) - 12usize];
    ["Offset of field: atom_vram_module_v11::memory_type"]
        [::core::mem::offset_of!(atom_vram_module_v11, memory_type) - 13usize];
    ["Offset of field: atom_vram_module_v11::channel_num"]
        [::core::mem::offset_of!(atom_vram_module_v11, channel_num) - 14usize];
    ["Offset of field: atom_vram_module_v11::channel_width"]
        [::core::mem::offset_of!(atom_vram_module_v11, channel_width) - 15usize];
    ["Offset of field: atom_vram_module_v11::density"]
        [::core::mem::offset_of!(atom_vram_module_v11, density) - 16usize];
    ["Offset of field: atom_vram_module_v11::tunningset_id"]
        [::core::mem::offset_of!(atom_vram_module_v11, tunningset_id) - 17usize];
    ["Offset of field: atom_vram_module_v11::reserved"]
        [::core::mem::offset_of!(atom_vram_module_v11, reserved) - 18usize];
    ["Offset of field: atom_vram_module_v11::vender_rev_id"]
        [::core::mem::offset_of!(atom_vram_module_v11, vender_rev_id) - 26usize];
    ["Offset of field: atom_vram_module_v11::refreshrate"]
        [::core::mem::offset_of!(atom_vram_module_v11, refreshrate) - 27usize];
    ["Offset of field: atom_vram_module_v11::vram_flags"]
        [::core::mem::offset_of!(atom_vram_module_v11, vram_flags) - 28usize];
    ["Offset of field: atom_vram_module_v11::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_module_v11, vram_rsd2) - 29usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr10"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr10) - 30usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr0"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr0) - 32usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr1"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr1) - 34usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr2"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr2) - 36usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr4"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr4) - 38usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr7"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr7) - 40usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr8"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr8) - 42usize];
    ["Offset of field: atom_vram_module_v11::dram_pnstring"]
        [::core::mem::offset_of!(atom_vram_module_v11, dram_pnstring) - 44usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gddr6_ac_timing_v2_5 {
    pub u32umc_id_access: u32,
    pub RL: u8,
    pub WL: u8,
    pub tRAS: u8,
    pub tRC: u8,
    pub tREFI: u16,
    pub tRFC: u8,
    pub tRFCpb: u8,
    pub tRREFD: u8,
    pub tRCDRD: u8,
    pub tRCDWR: u8,
    pub tRP: u8,
    pub tRRDS: u8,
    pub tRRDL: u8,
    pub tWR: u8,
    pub tWTRS: u8,
    pub tWTRL: u8,
    pub tFAW: u8,
    pub tCCDS: u8,
    pub tCCDL: u8,
    pub tCRCRL: u8,
    pub tCRCWL: u8,
    pub tCKE: u8,
    pub tCKSRE: u8,
    pub tCKSRX: u8,
    pub tRTPS: u8,
    pub tRTPL: u8,
    pub tMRD: u8,
    pub tMOD: u8,
    pub tXS: u8,
    pub tXHP: u8,
    pub tXSMRS: u8,
    pub tXSH: u32,
    pub tPD: u8,
    pub tXP: u8,
    pub tCPDED: u8,
    pub tACTPDE: u8,
    pub tPREPDE: u8,
    pub tREFPDE: u8,
    pub tMRSPDEN: u8,
    pub tRDSRE: u8,
    pub tWRSRE: u8,
    pub tPPD: u8,
    pub tCCDMW: u8,
    pub tWTRTR: u8,
    pub tLTLTR: u8,
    pub tREFTR: u8,
    pub VNDR: u8,
    pub reserved: [u8; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gddr6_ac_timing_v2_5"]
        [::core::mem::size_of::<atom_gddr6_ac_timing_v2_5>() - 64usize];
    ["Alignment of atom_gddr6_ac_timing_v2_5"]
        [::core::mem::align_of::<atom_gddr6_ac_timing_v2_5>() - 1usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::u32umc_id_access"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, u32umc_id_access) - 0usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::RL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, RL) - 4usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::WL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, WL) - 5usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRAS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRAS) - 6usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRC"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRC) - 7usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tREFI"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tREFI) - 8usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRFC"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRFC) - 10usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRFCpb"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRFCpb) - 11usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRREFD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRREFD) - 12usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRCDRD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRCDRD) - 13usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRCDWR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRCDWR) - 14usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRP"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRP) - 15usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRRDS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRRDS) - 16usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRRDL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRRDL) - 17usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWR) - 18usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWTRS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWTRS) - 19usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWTRL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWTRL) - 20usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tFAW"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tFAW) - 21usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCCDS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCCDS) - 22usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCCDL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCCDL) - 23usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCRCRL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCRCRL) - 24usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCRCWL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCRCWL) - 25usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCKE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCKE) - 26usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCKSRE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCKSRE) - 27usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCKSRX"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCKSRX) - 28usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRTPS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRTPS) - 29usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRTPL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRTPL) - 30usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tMRD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tMRD) - 31usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tMOD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tMOD) - 32usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXS) - 33usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXHP"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXHP) - 34usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXSMRS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXSMRS) - 35usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXSH"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXSH) - 36usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tPD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tPD) - 40usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXP"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXP) - 41usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCPDED"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCPDED) - 42usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tACTPDE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tACTPDE) - 43usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tPREPDE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tPREPDE) - 44usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tREFPDE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tREFPDE) - 45usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tMRSPDEN"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tMRSPDEN) - 46usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRDSRE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRDSRE) - 47usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWRSRE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWRSRE) - 48usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tPPD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tPPD) - 49usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCCDMW"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCCDMW) - 50usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWTRTR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWTRTR) - 51usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tLTLTR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tLTLTR) - 52usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tREFTR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tREFTR) - 53usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::VNDR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, VNDR) - 54usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::reserved"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, reserved) - 55usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gddr6_bit_byte_remap {
    pub dphy_byteremap: u32,
    pub dphy_bitremap0: u32,
    pub dphy_bitremap1: u32,
    pub dphy_bitremap2: u32,
    pub aphy_bitremap0: u32,
    pub aphy_bitremap1: u32,
    pub phy_dram: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gddr6_bit_byte_remap"]
        [::core::mem::size_of::<atom_gddr6_bit_byte_remap>() - 28usize];
    ["Alignment of atom_gddr6_bit_byte_remap"]
        [::core::mem::align_of::<atom_gddr6_bit_byte_remap>() - 1usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::dphy_byteremap"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, dphy_byteremap) - 0usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::dphy_bitremap0"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, dphy_bitremap0) - 4usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::dphy_bitremap1"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, dphy_bitremap1) - 8usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::dphy_bitremap2"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, dphy_bitremap2) - 12usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::aphy_bitremap0"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, aphy_bitremap0) - 16usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::aphy_bitremap1"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, aphy_bitremap1) - 20usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::phy_dram"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, phy_dram) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gddr6_dram_data_remap {
    pub table_size: u32,
    pub phyintf_ck_inverted: [u8; 8usize],
    pub bit_byte_remap: [atom_gddr6_bit_byte_remap; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gddr6_dram_data_remap"]
        [::core::mem::size_of::<atom_gddr6_dram_data_remap>() - 460usize];
    ["Alignment of atom_gddr6_dram_data_remap"]
        [::core::mem::align_of::<atom_gddr6_dram_data_remap>() - 1usize];
    ["Offset of field: atom_gddr6_dram_data_remap::table_size"]
        [::core::mem::offset_of!(atom_gddr6_dram_data_remap, table_size) - 0usize];
    ["Offset of field: atom_gddr6_dram_data_remap::phyintf_ck_inverted"]
        [::core::mem::offset_of!(atom_gddr6_dram_data_remap, phyintf_ck_inverted) - 4usize];
    ["Offset of field: atom_gddr6_dram_data_remap::bit_byte_remap"]
        [::core::mem::offset_of!(atom_gddr6_dram_data_remap, bit_byte_remap) - 12usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_5 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub gddr6_ac_timing_offset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub reserved: u16,
    pub post_ucode_init_offset: u16,
    pub strobe_mode_patch_tbloffset: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v11; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v2_5"]
        [::core::mem::size_of::<atom_vram_info_header_v2_5>() - 1368usize];
    ["Alignment of atom_vram_info_header_v2_5"]
        [::core::mem::align_of::<atom_vram_info_header_v2_5>() - 1usize];
    ["Offset of field: atom_vram_info_header_v2_5::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v2_5::mem_adjust_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, mem_adjust_tbloffset) - 4usize];
    ["Offset of field: atom_vram_info_header_v2_5::gddr6_ac_timing_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, gddr6_ac_timing_offset) - 6usize];
    ["Offset of field: atom_vram_info_header_v2_5::mc_adjust_pertile_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, mc_adjust_pertile_tbloffset) - 8usize];
    ["Offset of field: atom_vram_info_header_v2_5::mc_phyinit_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, mc_phyinit_tbloffset) - 10usize];
    ["Offset of field: atom_vram_info_header_v2_5::dram_data_remap_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, dram_data_remap_tbloffset) - 12usize];
    ["Offset of field: atom_vram_info_header_v2_5::reserved"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, reserved) - 14usize];
    ["Offset of field: atom_vram_info_header_v2_5::post_ucode_init_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, post_ucode_init_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v2_5::strobe_mode_patch_tbloffset"][::core::mem::offset_of!(
        atom_vram_info_header_v2_5,
        strobe_mode_patch_tbloffset
    ) - 18usize];
    ["Offset of field: atom_vram_info_header_v2_5::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v2_5::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v2_5::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v2_5::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v2_5::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, vram_module) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_6 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub mem_clk_patch_tbloffset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub tmrs_seq_offset: u16,
    pub post_ucode_init_offset: u16,
    pub vram_rsd2: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v9; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v2_6"]
        [::core::mem::size_of::<atom_vram_info_header_v2_6>() - 856usize];
    ["Alignment of atom_vram_info_header_v2_6"]
        [::core::mem::align_of::<atom_vram_info_header_v2_6>() - 1usize];
    ["Offset of field: atom_vram_info_header_v2_6::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v2_6::mem_adjust_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mem_adjust_tbloffset) - 4usize];
    ["Offset of field: atom_vram_info_header_v2_6::mem_clk_patch_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mem_clk_patch_tbloffset) - 6usize];
    ["Offset of field: atom_vram_info_header_v2_6::mc_adjust_pertile_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mc_adjust_pertile_tbloffset) - 8usize];
    ["Offset of field: atom_vram_info_header_v2_6::mc_phyinit_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mc_phyinit_tbloffset) - 10usize];
    ["Offset of field: atom_vram_info_header_v2_6::dram_data_remap_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, dram_data_remap_tbloffset) - 12usize];
    ["Offset of field: atom_vram_info_header_v2_6::tmrs_seq_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, tmrs_seq_offset) - 14usize];
    ["Offset of field: atom_vram_info_header_v2_6::post_ucode_init_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, post_ucode_init_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v2_6::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, vram_rsd2) - 18usize];
    ["Offset of field: atom_vram_info_header_v2_6::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v2_6::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v2_6::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v2_6::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v2_6::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, vram_module) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_data_entry {
    pub i2c_reg_index: u16,
    pub i2c_reg_data: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_i2c_data_entry"][::core::mem::size_of::<atom_i2c_data_entry>() - 4usize];
    ["Alignment of atom_i2c_data_entry"][::core::mem::align_of::<atom_i2c_data_entry>() - 1usize];
    ["Offset of field: atom_i2c_data_entry::i2c_reg_index"]
        [::core::mem::offset_of!(atom_i2c_data_entry, i2c_reg_index) - 0usize];
    ["Offset of field: atom_i2c_data_entry::i2c_reg_data"]
        [::core::mem::offset_of!(atom_i2c_data_entry, i2c_reg_data) - 2usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_voltage_object_header_v4 {
    pub voltage_type: u8,
    pub voltage_mode: u8,
    pub object_size: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_voltage_object_header_v4"]
        [::core::mem::size_of::<atom_voltage_object_header_v4>() - 4usize];
    ["Alignment of atom_voltage_object_header_v4"]
        [::core::mem::align_of::<atom_voltage_object_header_v4>() - 1usize];
    ["Offset of field: atom_voltage_object_header_v4::voltage_type"]
        [::core::mem::offset_of!(atom_voltage_object_header_v4, voltage_type) - 0usize];
    ["Offset of field: atom_voltage_object_header_v4::voltage_mode"]
        [::core::mem::offset_of!(atom_voltage_object_header_v4, voltage_mode) - 1usize];
    ["Offset of field: atom_voltage_object_header_v4::object_size"]
        [::core::mem::offset_of!(atom_voltage_object_header_v4, object_size) - 2usize];
};
pub const atom_voltage_object_mode_VOLTAGE_OBJ_GPIO_LUT: atom_voltage_object_mode = 0;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_VR_I2C_INIT_SEQ: atom_voltage_object_mode = 3;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_PHASE_LUT: atom_voltage_object_mode = 4;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_SVID2: atom_voltage_object_mode = 7;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_EVV: atom_voltage_object_mode = 8;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_MERGED_POWER: atom_voltage_object_mode = 9;
pub type atom_voltage_object_mode = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub regulator_id: u8,
    pub i2c_id: u8,
    pub i2c_slave_addr: u8,
    pub i2c_control_offset: u8,
    pub i2c_flag: u8,
    pub i2c_speed: u8,
    pub reserved: [u8; 2usize],
    pub i2cdatalut: [atom_i2c_data_entry; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_i2c_voltage_object_v4"]
        [::core::mem::size_of::<atom_i2c_voltage_object_v4>() - 16usize];
    ["Alignment of atom_i2c_voltage_object_v4"]
        [::core::mem::align_of::<atom_i2c_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_i2c_voltage_object_v4::header"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, header) - 0usize];
    ["Offset of field: atom_i2c_voltage_object_v4::regulator_id"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, regulator_id) - 4usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_id"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_id) - 5usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_slave_addr"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_slave_addr) - 6usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_control_offset"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_control_offset) - 7usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_flag"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_flag) - 8usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_speed"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_speed) - 9usize];
    ["Offset of field: atom_i2c_voltage_object_v4::reserved"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, reserved) - 10usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2cdatalut"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2cdatalut) - 12usize];
};
pub const atom_i2c_voltage_control_flag_VOLTAGE_DATA_ONE_BYTE: atom_i2c_voltage_control_flag = 0;
pub const atom_i2c_voltage_control_flag_VOLTAGE_DATA_TWO_BYTE: atom_i2c_voltage_control_flag = 1;
pub type atom_i2c_voltage_control_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_voltage_gpio_map_lut {
    pub voltage_gpio_reg_val: u32,
    pub voltage_level_mv: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_voltage_gpio_map_lut"]
        [::core::mem::size_of::<atom_voltage_gpio_map_lut>() - 6usize];
    ["Alignment of atom_voltage_gpio_map_lut"]
        [::core::mem::align_of::<atom_voltage_gpio_map_lut>() - 1usize];
    ["Offset of field: atom_voltage_gpio_map_lut::voltage_gpio_reg_val"]
        [::core::mem::offset_of!(atom_voltage_gpio_map_lut, voltage_gpio_reg_val) - 0usize];
    ["Offset of field: atom_voltage_gpio_map_lut::voltage_level_mv"]
        [::core::mem::offset_of!(atom_voltage_gpio_map_lut, voltage_level_mv) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub gpio_control_id: u8,
    pub gpio_entry_num: u8,
    pub phase_delay_us: u8,
    pub reserved: u8,
    pub gpio_mask_val: u32,
    pub voltage_gpio_lut: [atom_voltage_gpio_map_lut; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gpio_voltage_object_v4"]
        [::core::mem::size_of::<atom_gpio_voltage_object_v4>() - 18usize];
    ["Alignment of atom_gpio_voltage_object_v4"]
        [::core::mem::align_of::<atom_gpio_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_gpio_voltage_object_v4::header"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, header) - 0usize];
    ["Offset of field: atom_gpio_voltage_object_v4::gpio_control_id"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, gpio_control_id) - 4usize];
    ["Offset of field: atom_gpio_voltage_object_v4::gpio_entry_num"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, gpio_entry_num) - 5usize];
    ["Offset of field: atom_gpio_voltage_object_v4::phase_delay_us"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, phase_delay_us) - 6usize];
    ["Offset of field: atom_gpio_voltage_object_v4::reserved"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, reserved) - 7usize];
    ["Offset of field: atom_gpio_voltage_object_v4::gpio_mask_val"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, gpio_mask_val) - 8usize];
    ["Offset of field: atom_gpio_voltage_object_v4::voltage_gpio_lut"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, voltage_gpio_lut) - 12usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_svid2_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub loadline_psi1: u8,
    pub psi0_l_vid_thresd: u8,
    pub psi0_enable: u8,
    pub maxvstep: u8,
    pub telemetry_offset: u8,
    pub telemetry_gain: u8,
    pub reserved1: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_svid2_voltage_object_v4"]
        [::core::mem::size_of::<atom_svid2_voltage_object_v4>() - 12usize];
    ["Alignment of atom_svid2_voltage_object_v4"]
        [::core::mem::align_of::<atom_svid2_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_svid2_voltage_object_v4::header"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, header) - 0usize];
    ["Offset of field: atom_svid2_voltage_object_v4::loadline_psi1"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, loadline_psi1) - 4usize];
    ["Offset of field: atom_svid2_voltage_object_v4::psi0_l_vid_thresd"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, psi0_l_vid_thresd) - 5usize];
    ["Offset of field: atom_svid2_voltage_object_v4::psi0_enable"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, psi0_enable) - 6usize];
    ["Offset of field: atom_svid2_voltage_object_v4::maxvstep"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, maxvstep) - 7usize];
    ["Offset of field: atom_svid2_voltage_object_v4::telemetry_offset"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, telemetry_offset) - 8usize];
    ["Offset of field: atom_svid2_voltage_object_v4::telemetry_gain"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, telemetry_gain) - 9usize];
    ["Offset of field: atom_svid2_voltage_object_v4::reserved1"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, reserved1) - 10usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_merged_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub merged_powerrail_type: u8,
    pub reserved: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_merged_voltage_object_v4"]
        [::core::mem::size_of::<atom_merged_voltage_object_v4>() - 8usize];
    ["Alignment of atom_merged_voltage_object_v4"]
        [::core::mem::align_of::<atom_merged_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_merged_voltage_object_v4::header"]
        [::core::mem::offset_of!(atom_merged_voltage_object_v4, header) - 0usize];
    ["Offset of field: atom_merged_voltage_object_v4::merged_powerrail_type"]
        [::core::mem::offset_of!(atom_merged_voltage_object_v4, merged_powerrail_type) - 4usize];
    ["Offset of field: atom_merged_voltage_object_v4::reserved"]
        [::core::mem::offset_of!(atom_merged_voltage_object_v4, reserved) - 5usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union atom_voltage_object_v4 {
    pub gpio_voltage_obj: atom_gpio_voltage_object_v4,
    pub i2c_voltage_obj: atom_i2c_voltage_object_v4,
    pub svid2_voltage_obj: atom_svid2_voltage_object_v4,
    pub merged_voltage_obj: atom_merged_voltage_object_v4,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_voltage_object_v4"][::core::mem::size_of::<atom_voltage_object_v4>() - 18usize];
    ["Alignment of atom_voltage_object_v4"]
        [::core::mem::align_of::<atom_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_voltage_object_v4::gpio_voltage_obj"]
        [::core::mem::offset_of!(atom_voltage_object_v4, gpio_voltage_obj) - 0usize];
    ["Offset of field: atom_voltage_object_v4::i2c_voltage_obj"]
        [::core::mem::offset_of!(atom_voltage_object_v4, i2c_voltage_obj) - 0usize];
    ["Offset of field: atom_voltage_object_v4::svid2_voltage_obj"]
        [::core::mem::offset_of!(atom_voltage_object_v4, svid2_voltage_obj) - 0usize];
    ["Offset of field: atom_voltage_object_v4::merged_voltage_obj"]
        [::core::mem::offset_of!(atom_voltage_object_v4, merged_voltage_obj) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct atom_voltage_objects_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub voltage_object: [atom_voltage_object_v4; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_voltage_objects_info_v4_1"]
        [::core::mem::size_of::<atom_voltage_objects_info_v4_1>() - 22usize];
    ["Alignment of atom_voltage_objects_info_v4_1"]
        [::core::mem::align_of::<atom_voltage_objects_info_v4_1>() - 1usize];
    ["Offset of field: atom_voltage_objects_info_v4_1::table_header"]
        [::core::mem::offset_of!(atom_voltage_objects_info_v4_1, table_header) - 0usize];
    ["Offset of field: atom_voltage_objects_info_v4_1::voltage_object"]
        [::core::mem::offset_of!(atom_voltage_objects_info_v4_1, voltage_object) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_engine_parameters {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of asic_init_engine_parameters"]
        [::core::mem::size_of::<asic_init_engine_parameters>() - 4usize];
    ["Alignment of asic_init_engine_parameters"]
        [::core::mem::align_of::<asic_init_engine_parameters>() - 1usize];
};
impl asic_init_engine_parameters {
    #[inline]
    pub fn sclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_sclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn engineflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_engineflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sclkfreqin10khz: u32,
        engineflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let sclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(sclkfreqin10khz) };
            sclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let engineflag: u32 = unsafe { ::core::mem::transmute(engineflag) };
            engineflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_mem_parameters {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of asic_init_mem_parameters"]
        [::core::mem::size_of::<asic_init_mem_parameters>() - 4usize];
    ["Alignment of asic_init_mem_parameters"]
        [::core::mem::align_of::<asic_init_mem_parameters>() - 1usize];
};
impl asic_init_mem_parameters {
    #[inline]
    pub fn mclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_mclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn memflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_memflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mclkfreqin10khz: u32,
        memflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let mclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(mclkfreqin10khz) };
            mclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let memflag: u32 = unsafe { ::core::mem::transmute(memflag) };
            memflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_parameters_v2_1 {
    pub engineparam: asic_init_engine_parameters,
    pub memparam: asic_init_mem_parameters,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of asic_init_parameters_v2_1"]
        [::core::mem::size_of::<asic_init_parameters_v2_1>() - 8usize];
    ["Alignment of asic_init_parameters_v2_1"]
        [::core::mem::align_of::<asic_init_parameters_v2_1>() - 1usize];
    ["Offset of field: asic_init_parameters_v2_1::engineparam"]
        [::core::mem::offset_of!(asic_init_parameters_v2_1, engineparam) - 0usize];
    ["Offset of field: asic_init_parameters_v2_1::memparam"]
        [::core::mem::offset_of!(asic_init_parameters_v2_1, memparam) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_ps_allocation_v2_1 {
    pub param: asic_init_parameters_v2_1,
    pub reserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of asic_init_ps_allocation_v2_1"]
        [::core::mem::size_of::<asic_init_ps_allocation_v2_1>() - 72usize];
    ["Alignment of asic_init_ps_allocation_v2_1"]
        [::core::mem::align_of::<asic_init_ps_allocation_v2_1>() - 1usize];
    ["Offset of field: asic_init_ps_allocation_v2_1::param"]
        [::core::mem::offset_of!(asic_init_ps_allocation_v2_1, param) - 0usize];
    ["Offset of field: asic_init_ps_allocation_v2_1::reserved"]
        [::core::mem::offset_of!(asic_init_ps_allocation_v2_1, reserved) - 8usize];
};
pub const atom_asic_init_engine_flag_b3NORMAL_ENGINE_INIT: atom_asic_init_engine_flag = 0;
pub const atom_asic_init_engine_flag_b3SRIOV_SKIP_ASIC_INIT: atom_asic_init_engine_flag = 2;
pub const atom_asic_init_engine_flag_b3SRIOV_LOAD_UCODE: atom_asic_init_engine_flag = 64;
pub type atom_asic_init_engine_flag = ::core::ffi::c_uint;
pub const atom_asic_init_mem_flag_b3NORMAL_MEM_INIT: atom_asic_init_mem_flag = 0;
pub const atom_asic_init_mem_flag_b3DRAM_SELF_REFRESH_EXIT: atom_asic_init_mem_flag = 32;
pub type atom_asic_init_mem_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_engine_clock_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_engine_clock_parameters_v2_1"]
        [::core::mem::size_of::<set_engine_clock_parameters_v2_1>() - 44usize];
    ["Alignment of set_engine_clock_parameters_v2_1"]
        [::core::mem::align_of::<set_engine_clock_parameters_v2_1>() - 1usize];
    ["Offset of field: set_engine_clock_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(set_engine_clock_parameters_v2_1, reserved) - 4usize];
};
impl set_engine_clock_parameters_v2_1 {
    #[inline]
    pub fn sclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_sclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn sclkflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_sclkflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sclkfreqin10khz: u32,
        sclkflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let sclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(sclkfreqin10khz) };
            sclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let sclkflag: u32 = unsafe { ::core::mem::transmute(sclkflag) };
            sclkflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_engine_clock_ps_allocation_v2_1 {
    pub clockinfo: set_engine_clock_parameters_v2_1,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_engine_clock_ps_allocation_v2_1"]
        [::core::mem::size_of::<set_engine_clock_ps_allocation_v2_1>() - 84usize];
    ["Alignment of set_engine_clock_ps_allocation_v2_1"]
        [::core::mem::align_of::<set_engine_clock_ps_allocation_v2_1>() - 1usize];
    ["Offset of field: set_engine_clock_ps_allocation_v2_1::clockinfo"]
        [::core::mem::offset_of!(set_engine_clock_ps_allocation_v2_1, clockinfo) - 0usize];
    ["Offset of field: set_engine_clock_ps_allocation_v2_1::reserved"]
        [::core::mem::offset_of!(set_engine_clock_ps_allocation_v2_1, reserved) - 44usize];
};
pub const atom_set_engine_mem_clock_flag_b3NORMAL_CHANGE_CLOCK: atom_set_engine_mem_clock_flag = 0;
pub const atom_set_engine_mem_clock_flag_b3FIRST_TIME_CHANGE_CLOCK: atom_set_engine_mem_clock_flag =
    8;
pub const atom_set_engine_mem_clock_flag_b3STORE_DPM_TRAINGING: atom_set_engine_mem_clock_flag = 64;
pub type atom_set_engine_mem_clock_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct get_engine_clock_parameter {
    pub sclk_10khz: u32,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of get_engine_clock_parameter"]
        [::core::mem::size_of::<get_engine_clock_parameter>() - 8usize];
    ["Alignment of get_engine_clock_parameter"]
        [::core::mem::align_of::<get_engine_clock_parameter>() - 1usize];
    ["Offset of field: get_engine_clock_parameter::sclk_10khz"]
        [::core::mem::offset_of!(get_engine_clock_parameter, sclk_10khz) - 0usize];
    ["Offset of field: get_engine_clock_parameter::reserved"]
        [::core::mem::offset_of!(get_engine_clock_parameter, reserved) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_memory_clock_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_memory_clock_parameters_v2_1"]
        [::core::mem::size_of::<set_memory_clock_parameters_v2_1>() - 44usize];
    ["Alignment of set_memory_clock_parameters_v2_1"]
        [::core::mem::align_of::<set_memory_clock_parameters_v2_1>() - 1usize];
    ["Offset of field: set_memory_clock_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(set_memory_clock_parameters_v2_1, reserved) - 4usize];
};
impl set_memory_clock_parameters_v2_1 {
    #[inline]
    pub fn mclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_mclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn mclkflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_mclkflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mclkfreqin10khz: u32,
        mclkflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let mclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(mclkfreqin10khz) };
            mclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let mclkflag: u32 = unsafe { ::core::mem::transmute(mclkflag) };
            mclkflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_memory_clock_ps_allocation_v2_1 {
    pub clockinfo: set_memory_clock_parameters_v2_1,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_memory_clock_ps_allocation_v2_1"]
        [::core::mem::size_of::<set_memory_clock_ps_allocation_v2_1>() - 84usize];
    ["Alignment of set_memory_clock_ps_allocation_v2_1"]
        [::core::mem::align_of::<set_memory_clock_ps_allocation_v2_1>() - 1usize];
    ["Offset of field: set_memory_clock_ps_allocation_v2_1::clockinfo"]
        [::core::mem::offset_of!(set_memory_clock_ps_allocation_v2_1, clockinfo) - 0usize];
    ["Offset of field: set_memory_clock_ps_allocation_v2_1::reserved"]
        [::core::mem::offset_of!(set_memory_clock_ps_allocation_v2_1, reserved) - 44usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct get_memory_clock_parameter {
    pub mclk_10khz: u32,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of get_memory_clock_parameter"]
        [::core::mem::size_of::<get_memory_clock_parameter>() - 8usize];
    ["Alignment of get_memory_clock_parameter"]
        [::core::mem::align_of::<get_memory_clock_parameter>() - 1usize];
    ["Offset of field: get_memory_clock_parameter::mclk_10khz"]
        [::core::mem::offset_of!(get_memory_clock_parameter, mclk_10khz) - 0usize];
    ["Offset of field: get_memory_clock_parameter::reserved"]
        [::core::mem::offset_of!(get_memory_clock_parameter, reserved) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_voltage_parameters_v1_4 {
    pub voltagetype: u8,
    pub command: u8,
    pub vlevel_mv: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_voltage_parameters_v1_4"]
        [::core::mem::size_of::<set_voltage_parameters_v1_4>() - 4usize];
    ["Alignment of set_voltage_parameters_v1_4"]
        [::core::mem::align_of::<set_voltage_parameters_v1_4>() - 1usize];
    ["Offset of field: set_voltage_parameters_v1_4::voltagetype"]
        [::core::mem::offset_of!(set_voltage_parameters_v1_4, voltagetype) - 0usize];
    ["Offset of field: set_voltage_parameters_v1_4::command"]
        [::core::mem::offset_of!(set_voltage_parameters_v1_4, command) - 1usize];
    ["Offset of field: set_voltage_parameters_v1_4::vlevel_mv"]
        [::core::mem::offset_of!(set_voltage_parameters_v1_4, vlevel_mv) - 2usize];
};
pub const atom_set_voltage_command_ATOM_SET_VOLTAGE: atom_set_voltage_command = 0;
pub const atom_set_voltage_command_ATOM_INIT_VOLTAGE_REGULATOR: atom_set_voltage_command = 3;
pub const atom_set_voltage_command_ATOM_SET_VOLTAGE_PHASE: atom_set_voltage_command = 4;
pub const atom_set_voltage_command_ATOM_GET_LEAKAGE_ID: atom_set_voltage_command = 8;
pub type atom_set_voltage_command = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_voltage_ps_allocation_v1_4 {
    pub setvoltageparam: set_voltage_parameters_v1_4,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_voltage_ps_allocation_v1_4"]
        [::core::mem::size_of::<set_voltage_ps_allocation_v1_4>() - 44usize];
    ["Alignment of set_voltage_ps_allocation_v1_4"]
        [::core::mem::align_of::<set_voltage_ps_allocation_v1_4>() - 1usize];
    ["Offset of field: set_voltage_ps_allocation_v1_4::setvoltageparam"]
        [::core::mem::offset_of!(set_voltage_ps_allocation_v1_4, setvoltageparam) - 0usize];
    ["Offset of field: set_voltage_ps_allocation_v1_4::reserved"]
        [::core::mem::offset_of!(set_voltage_ps_allocation_v1_4, reserved) - 4usize];
};
pub const atom_gpu_clock_type_COMPUTE_GPUCLK_INPUT_FLAG_DEFAULT_GPUCLK: atom_gpu_clock_type = 0;
pub const atom_gpu_clock_type_COMPUTE_GPUCLK_INPUT_FLAG_GFXCLK: atom_gpu_clock_type = 1;
pub const atom_gpu_clock_type_COMPUTE_GPUCLK_INPUT_FLAG_UCLK: atom_gpu_clock_type = 2;
pub type atom_gpu_clock_type = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct compute_gpu_clock_input_parameter_v1_8 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: [u32; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of compute_gpu_clock_input_parameter_v1_8"]
        [::core::mem::size_of::<compute_gpu_clock_input_parameter_v1_8>() - 24usize];
    ["Alignment of compute_gpu_clock_input_parameter_v1_8"]
        [::core::mem::align_of::<compute_gpu_clock_input_parameter_v1_8>() - 1usize];
    ["Offset of field: compute_gpu_clock_input_parameter_v1_8::reserved"]
        [::core::mem::offset_of!(compute_gpu_clock_input_parameter_v1_8, reserved) - 4usize];
};
impl compute_gpu_clock_input_parameter_v1_8 {
    #[inline]
    pub fn gpuclock_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_gpuclock_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn gpu_clock_type(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_gpu_clock_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        gpuclock_10khz: u32,
        gpu_clock_type: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let gpuclock_10khz: u32 = unsafe { ::core::mem::transmute(gpuclock_10khz) };
            gpuclock_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let gpu_clock_type: u32 = unsafe { ::core::mem::transmute(gpu_clock_type) };
            gpu_clock_type as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct compute_gpu_clock_output_parameter_v1_8 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub pll_fb_mult: u32,
    pub pll_ss_fbsmult: u32,
    pub pll_ss_slew_frac: u16,
    pub pll_ss_enable: u8,
    pub reserved: u8,
    pub reserved1: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of compute_gpu_clock_output_parameter_v1_8"]
        [::core::mem::size_of::<compute_gpu_clock_output_parameter_v1_8>() - 24usize];
    ["Alignment of compute_gpu_clock_output_parameter_v1_8"]
        [::core::mem::align_of::<compute_gpu_clock_output_parameter_v1_8>() - 1usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::pll_fb_mult"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, pll_fb_mult) - 4usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::pll_ss_fbsmult"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, pll_ss_fbsmult) - 8usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::pll_ss_slew_frac"][::core::mem::offset_of!(
        compute_gpu_clock_output_parameter_v1_8,
        pll_ss_slew_frac
    ) - 12usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::pll_ss_enable"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, pll_ss_enable) - 14usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::reserved"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, reserved) - 15usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::reserved1"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, reserved1) - 16usize];
};
impl compute_gpu_clock_output_parameter_v1_8 {
    #[inline]
    pub fn gpuclock_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_gpuclock_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn dfs_did(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_dfs_did(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        gpuclock_10khz: u32,
        dfs_did: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let gpuclock_10khz: u32 = unsafe { ::core::mem::transmute(gpuclock_10khz) };
            gpuclock_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let dfs_did: u32 = unsafe { ::core::mem::transmute(dfs_did) };
            dfs_did as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct read_efuse_input_parameters_v3_1 {
    pub efuse_start_index: u16,
    pub reserved: u8,
    pub bitslen: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of read_efuse_input_parameters_v3_1"]
        [::core::mem::size_of::<read_efuse_input_parameters_v3_1>() - 4usize];
    ["Alignment of read_efuse_input_parameters_v3_1"]
        [::core::mem::align_of::<read_efuse_input_parameters_v3_1>() - 1usize];
    ["Offset of field: read_efuse_input_parameters_v3_1::efuse_start_index"]
        [::core::mem::offset_of!(read_efuse_input_parameters_v3_1, efuse_start_index) - 0usize];
    ["Offset of field: read_efuse_input_parameters_v3_1::reserved"]
        [::core::mem::offset_of!(read_efuse_input_parameters_v3_1, reserved) - 2usize];
    ["Offset of field: read_efuse_input_parameters_v3_1::bitslen"]
        [::core::mem::offset_of!(read_efuse_input_parameters_v3_1, bitslen) - 3usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union read_efuse_value_parameters_v3_1 {
    pub efuse_info: read_efuse_input_parameters_v3_1,
    pub efusevalue: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of read_efuse_value_parameters_v3_1"]
        [::core::mem::size_of::<read_efuse_value_parameters_v3_1>() - 4usize];
    ["Alignment of read_efuse_value_parameters_v3_1"]
        [::core::mem::align_of::<read_efuse_value_parameters_v3_1>() - 1usize];
    ["Offset of field: read_efuse_value_parameters_v3_1::efuse_info"]
        [::core::mem::offset_of!(read_efuse_value_parameters_v3_1, efuse_info) - 0usize];
    ["Offset of field: read_efuse_value_parameters_v3_1::efusevalue"]
        [::core::mem::offset_of!(read_efuse_value_parameters_v3_1, efusevalue) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_get_smu_clock_info_parameters_v3_1 {
    pub syspll_id: u8,
    pub clk_id: u8,
    pub command: u8,
    pub dfsdid: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_get_smu_clock_info_parameters_v3_1"]
        [::core::mem::size_of::<atom_get_smu_clock_info_parameters_v3_1>() - 4usize];
    ["Alignment of atom_get_smu_clock_info_parameters_v3_1"]
        [::core::mem::align_of::<atom_get_smu_clock_info_parameters_v3_1>() - 1usize];
    ["Offset of field: atom_get_smu_clock_info_parameters_v3_1::syspll_id"]
        [::core::mem::offset_of!(atom_get_smu_clock_info_parameters_v3_1, syspll_id) - 0usize];
    ["Offset of field: atom_get_smu_clock_info_parameters_v3_1::clk_id"]
        [::core::mem::offset_of!(atom_get_smu_clock_info_parameters_v3_1, clk_id) - 1usize];
    ["Offset of field: atom_get_smu_clock_info_parameters_v3_1::command"]
        [::core::mem::offset_of!(atom_get_smu_clock_info_parameters_v3_1, command) - 2usize];
    ["Offset of field: atom_get_smu_clock_info_parameters_v3_1::dfsdid"]
        [::core::mem::offset_of!(atom_get_smu_clock_info_parameters_v3_1, dfsdid) - 3usize];
};
pub const atom_get_smu_clock_info_command_GET_SMU_CLOCK_INFO_V3_1_GET_CLOCK_FREQ:
    atom_get_smu_clock_info_command = 0;
pub const atom_get_smu_clock_info_command_GET_SMU_CLOCK_INFO_V3_1_GET_PLLVCO_FREQ:
    atom_get_smu_clock_info_command = 1;
pub const atom_get_smu_clock_info_command_GET_SMU_CLOCK_INFO_V3_1_GET_PLLREFCLK_FREQ:
    atom_get_smu_clock_info_command = 2;
pub type atom_get_smu_clock_info_command = ::core::ffi::c_uint;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_SMNCLK_ID: atom_smu9_syspll0_clock_id = 0;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_SOCCLK_ID: atom_smu9_syspll0_clock_id = 1;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_MP0CLK_ID: atom_smu9_syspll0_clock_id = 2;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_MP1CLK_ID: atom_smu9_syspll0_clock_id = 3;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_LCLK_ID: atom_smu9_syspll0_clock_id = 4;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DCLK_ID: atom_smu9_syspll0_clock_id = 5;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_VCLK_ID: atom_smu9_syspll0_clock_id = 6;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_ECLK_ID: atom_smu9_syspll0_clock_id = 7;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DCEFCLK_ID: atom_smu9_syspll0_clock_id = 8;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DPREFCLK_ID: atom_smu9_syspll0_clock_id = 10;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DISPCLK_ID: atom_smu9_syspll0_clock_id = 11;
pub type atom_smu9_syspll0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll_id_SMU11_SYSPLL0_ID: atom_smu11_syspll_id = 0;
pub const atom_smu11_syspll_id_SMU11_SYSPLL1_0_ID: atom_smu11_syspll_id = 1;
pub const atom_smu11_syspll_id_SMU11_SYSPLL1_1_ID: atom_smu11_syspll_id = 2;
pub const atom_smu11_syspll_id_SMU11_SYSPLL1_2_ID: atom_smu11_syspll_id = 3;
pub const atom_smu11_syspll_id_SMU11_SYSPLL2_ID: atom_smu11_syspll_id = 4;
pub const atom_smu11_syspll_id_SMU11_SYSPLL3_0_ID: atom_smu11_syspll_id = 5;
pub const atom_smu11_syspll_id_SMU11_SYSPLL3_1_ID: atom_smu11_syspll_id = 6;
pub type atom_smu11_syspll_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_ECLK_ID: atom_smu11_syspll0_clock_id = 0;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_SOCCLK_ID: atom_smu11_syspll0_clock_id = 1;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_MP0CLK_ID: atom_smu11_syspll0_clock_id = 2;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_DCLK_ID: atom_smu11_syspll0_clock_id = 3;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_VCLK_ID: atom_smu11_syspll0_clock_id = 4;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_DCEFCLK_ID: atom_smu11_syspll0_clock_id = 5;
pub type atom_smu11_syspll0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll1_0_clock_id_SMU11_SYSPLL1_0_UCLKA_ID: atom_smu11_syspll1_0_clock_id = 0;
pub type atom_smu11_syspll1_0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll1_1_clock_id_SMU11_SYSPLL1_0_UCLKB_ID: atom_smu11_syspll1_1_clock_id = 0;
pub type atom_smu11_syspll1_1_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll1_2_clock_id_SMU11_SYSPLL1_0_FCLK_ID: atom_smu11_syspll1_2_clock_id = 0;
pub type atom_smu11_syspll1_2_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll2_clock_id_SMU11_SYSPLL2_GFXCLK_ID: atom_smu11_syspll2_clock_id = 0;
pub type atom_smu11_syspll2_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll3_0_clock_id_SMU11_SYSPLL3_0_WAFCLK_ID: atom_smu11_syspll3_0_clock_id =
    0;
pub const atom_smu11_syspll3_0_clock_id_SMU11_SYSPLL3_0_DISPCLK_ID: atom_smu11_syspll3_0_clock_id =
    1;
pub const atom_smu11_syspll3_0_clock_id_SMU11_SYSPLL3_0_DPREFCLK_ID: atom_smu11_syspll3_0_clock_id =
    2;
pub type atom_smu11_syspll3_0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll3_1_clock_id_SMU11_SYSPLL3_1_MP1CLK_ID: atom_smu11_syspll3_1_clock_id =
    0;
pub const atom_smu11_syspll3_1_clock_id_SMU11_SYSPLL3_1_SMNCLK_ID: atom_smu11_syspll3_1_clock_id =
    1;
pub const atom_smu11_syspll3_1_clock_id_SMU11_SYSPLL3_1_LCLK_ID: atom_smu11_syspll3_1_clock_id = 2;
pub type atom_smu11_syspll3_1_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll_id_SMU12_SYSPLL0_ID: atom_smu12_syspll_id = 0;
pub const atom_smu12_syspll_id_SMU12_SYSPLL1_ID: atom_smu12_syspll_id = 1;
pub const atom_smu12_syspll_id_SMU12_SYSPLL2_ID: atom_smu12_syspll_id = 2;
pub const atom_smu12_syspll_id_SMU12_SYSPLL3_0_ID: atom_smu12_syspll_id = 3;
pub const atom_smu12_syspll_id_SMU12_SYSPLL3_1_ID: atom_smu12_syspll_id = 4;
pub type atom_smu12_syspll_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_SMNCLK_ID: atom_smu12_syspll0_clock_id = 0;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_SOCCLK_ID: atom_smu12_syspll0_clock_id = 1;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_MP0CLK_ID: atom_smu12_syspll0_clock_id = 2;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_MP1CLK_ID: atom_smu12_syspll0_clock_id = 3;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_MP2CLK_ID: atom_smu12_syspll0_clock_id = 4;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_VCLK_ID: atom_smu12_syspll0_clock_id = 5;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_LCLK_ID: atom_smu12_syspll0_clock_id = 6;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_DCLK_ID: atom_smu12_syspll0_clock_id = 7;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_ACLK_ID: atom_smu12_syspll0_clock_id = 8;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_ISPCLK_ID: atom_smu12_syspll0_clock_id = 9;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_SHUBCLK_ID: atom_smu12_syspll0_clock_id = 10;
pub type atom_smu12_syspll0_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DISPCLK_ID: atom_smu12_syspll1_clock_id = 0;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DPPCLK_ID: atom_smu12_syspll1_clock_id = 1;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DPREFCLK_ID: atom_smu12_syspll1_clock_id = 2;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DCFCLK_ID: atom_smu12_syspll1_clock_id = 3;
pub type atom_smu12_syspll1_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll2_clock_id_SMU12_SYSPLL2_Pre_GFXCLK_ID: atom_smu12_syspll2_clock_id = 0;
pub type atom_smu12_syspll2_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll3_0_clock_id_SMU12_SYSPLL3_0_FCLK_ID: atom_smu12_syspll3_0_clock_id = 0;
pub type atom_smu12_syspll3_0_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll3_1_clock_id_SMU12_SYSPLL3_1_UMCCLK_ID: atom_smu12_syspll3_1_clock_id =
    0;
pub type atom_smu12_syspll3_1_clock_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct atom_get_smu_clock_info_output_parameters_v3_1 {
    pub atom_smu_outputclkfreq: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 {
    pub smu_clock_freq_hz: u32,
    pub syspllvcofreq_10khz: u32,
    pub sysspllrefclk_10khz: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1"][::core::mem::size_of::<
        atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1,
    >() - 4usize];
    ["Alignment of atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1"]
        [::core::mem::align_of::<atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1>()
            - 1usize];
    ["Offset of field: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1::smu_clock_freq_hz"] [:: core :: mem :: offset_of ! (atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 , smu_clock_freq_hz) - 0usize] ;
    ["Offset of field: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1::syspllvcofreq_10khz"] [:: core :: mem :: offset_of ! (atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 , syspllvcofreq_10khz) - 0usize] ;
    ["Offset of field: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1::sysspllrefclk_10khz"] [:: core :: mem :: offset_of ! (atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 , sysspllrefclk_10khz) - 0usize] ;
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_get_smu_clock_info_output_parameters_v3_1"]
        [::core::mem::size_of::<atom_get_smu_clock_info_output_parameters_v3_1>() - 4usize];
    ["Alignment of atom_get_smu_clock_info_output_parameters_v3_1"]
        [::core::mem::align_of::<atom_get_smu_clock_info_output_parameters_v3_1>() - 1usize];
    ["Offset of field: atom_get_smu_clock_info_output_parameters_v3_1::atom_smu_outputclkfreq"][::core::mem::offset_of!(
        atom_get_smu_clock_info_output_parameters_v3_1,
        atom_smu_outputclkfreq
    )
        - 0usize];
};
pub const atom_dynamic_memory_setting_command_COMPUTE_MEMORY_PLL_PARAM:
    atom_dynamic_memory_setting_command = 1;
pub const atom_dynamic_memory_setting_command_COMPUTE_ENGINE_PLL_PARAM:
    atom_dynamic_memory_setting_command = 2;
pub const atom_dynamic_memory_setting_command_ADJUST_MC_SETTING_PARAM:
    atom_dynamic_memory_setting_command = 3;
pub type atom_dynamic_memory_setting_command = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dynamic_mclk_settings_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dynamic_mclk_settings_parameters_v2_1"]
        [::core::mem::size_of::<dynamic_mclk_settings_parameters_v2_1>() - 8usize];
    ["Alignment of dynamic_mclk_settings_parameters_v2_1"]
        [::core::mem::align_of::<dynamic_mclk_settings_parameters_v2_1>() - 1usize];
    ["Offset of field: dynamic_mclk_settings_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(dynamic_mclk_settings_parameters_v2_1, reserved) - 4usize];
};
impl dynamic_mclk_settings_parameters_v2_1 {
    #[inline]
    pub fn mclk_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_mclk_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn command(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_command(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(mclk_10khz: u32, command: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let mclk_10khz: u32 = unsafe { ::core::mem::transmute(mclk_10khz) };
            mclk_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let command: u32 = unsafe { ::core::mem::transmute(command) };
            command as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dynamic_sclk_settings_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub mclk_10khz: u32,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dynamic_sclk_settings_parameters_v2_1"]
        [::core::mem::size_of::<dynamic_sclk_settings_parameters_v2_1>() - 12usize];
    ["Alignment of dynamic_sclk_settings_parameters_v2_1"]
        [::core::mem::align_of::<dynamic_sclk_settings_parameters_v2_1>() - 1usize];
    ["Offset of field: dynamic_sclk_settings_parameters_v2_1::mclk_10khz"]
        [::core::mem::offset_of!(dynamic_sclk_settings_parameters_v2_1, mclk_10khz) - 4usize];
    ["Offset of field: dynamic_sclk_settings_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(dynamic_sclk_settings_parameters_v2_1, reserved) - 8usize];
};
impl dynamic_sclk_settings_parameters_v2_1 {
    #[inline]
    pub fn sclk_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_sclk_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn command(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_command(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(sclk_10khz: u32, command: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let sclk_10khz: u32 = unsafe { ::core::mem::transmute(sclk_10khz) };
            sclk_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let command: u32 = unsafe { ::core::mem::transmute(command) };
            command as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union dynamic_memory_settings_parameters_v2_1 {
    pub mclk_setting: dynamic_mclk_settings_parameters_v2_1,
    pub sclk_setting: dynamic_sclk_settings_parameters_v2_1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dynamic_memory_settings_parameters_v2_1"]
        [::core::mem::size_of::<dynamic_memory_settings_parameters_v2_1>() - 12usize];
    ["Alignment of dynamic_memory_settings_parameters_v2_1"]
        [::core::mem::align_of::<dynamic_memory_settings_parameters_v2_1>() - 1usize];
    ["Offset of field: dynamic_memory_settings_parameters_v2_1::mclk_setting"]
        [::core::mem::offset_of!(dynamic_memory_settings_parameters_v2_1, mclk_setting) - 0usize];
    ["Offset of field: dynamic_memory_settings_parameters_v2_1::sclk_setting"]
        [::core::mem::offset_of!(dynamic_memory_settings_parameters_v2_1, sclk_setting) - 0usize];
};
pub const atom_umc6_0_ucode_function_call_enum_id_UMC60_UCODE_FUNC_ID_REINIT:
    atom_umc6_0_ucode_function_call_enum_id = 0;
pub const atom_umc6_0_ucode_function_call_enum_id_UMC60_UCODE_FUNC_ID_ENTER_SELFREFRESH:
    atom_umc6_0_ucode_function_call_enum_id = 1;
pub const atom_umc6_0_ucode_function_call_enum_id_UMC60_UCODE_FUNC_ID_EXIT_SELFREFRESH:
    atom_umc6_0_ucode_function_call_enum_id = 2;
pub type atom_umc6_0_ucode_function_call_enum_id = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct memory_training_parameters_v2_1 {
    pub ucode_func_id: u8,
    pub ucode_reserved: [u8; 3usize],
    pub reserved: [u32; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of memory_training_parameters_v2_1"]
        [::core::mem::size_of::<memory_training_parameters_v2_1>() - 24usize];
    ["Alignment of memory_training_parameters_v2_1"]
        [::core::mem::align_of::<memory_training_parameters_v2_1>() - 1usize];
    ["Offset of field: memory_training_parameters_v2_1::ucode_func_id"]
        [::core::mem::offset_of!(memory_training_parameters_v2_1, ucode_func_id) - 0usize];
    ["Offset of field: memory_training_parameters_v2_1::ucode_reserved"]
        [::core::mem::offset_of!(memory_training_parameters_v2_1, ucode_reserved) - 1usize];
    ["Offset of field: memory_training_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(memory_training_parameters_v2_1, reserved) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_pixel_clock_parameter_v1_7 {
    pub pixclk_100hz: u32,
    pub pll_id: u8,
    pub encoderobjid: u8,
    pub encoder_mode: u8,
    pub miscinfo: u8,
    pub crtc_id: u8,
    pub deep_color_ratio: u8,
    pub reserved1: [u8; 2usize],
    pub reserved2: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_pixel_clock_parameter_v1_7"]
        [::core::mem::size_of::<set_pixel_clock_parameter_v1_7>() - 16usize];
    ["Alignment of set_pixel_clock_parameter_v1_7"]
        [::core::mem::align_of::<set_pixel_clock_parameter_v1_7>() - 1usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::pixclk_100hz"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, pixclk_100hz) - 0usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::pll_id"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, pll_id) - 4usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::encoderobjid"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, encoderobjid) - 5usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::encoder_mode"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, encoder_mode) - 6usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::miscinfo"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, miscinfo) - 7usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::crtc_id"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, crtc_id) - 8usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::deep_color_ratio"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, deep_color_ratio) - 9usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::reserved1"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, reserved1) - 10usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::reserved2"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, reserved2) - 12usize];
};
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_FORCE_PROG_PPLL:
    atom_set_pixel_clock_v1_7_misc_info = 1;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_PROG_PHYPLL:
    atom_set_pixel_clock_v1_7_misc_info = 2;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_YUV420_MODE:
    atom_set_pixel_clock_v1_7_misc_info = 4;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_DVI_DUALLINK_EN:
    atom_set_pixel_clock_v1_7_misc_info = 8;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC:
    atom_set_pixel_clock_v1_7_misc_info = 48;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_XTALIN:
    atom_set_pixel_clock_v1_7_misc_info = 0;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_PCIE:
    atom_set_pixel_clock_v1_7_misc_info = 16;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_GENLK:
    atom_set_pixel_clock_v1_7_misc_info = 32;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_REFPAD:
    atom_set_pixel_clock_v1_7_misc_info = 48;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_ATOMIC_UPDATE:
    atom_set_pixel_clock_v1_7_misc_info = 64;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_FORCE_SS_DIS:
    atom_set_pixel_clock_v1_7_misc_info = 128;
pub type atom_set_pixel_clock_v1_7_misc_info = ::core::ffi::c_uint;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_DIS:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 0;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_5_4:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 1;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_3_2:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 2;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_2_1:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 3;
pub type atom_set_pixel_clock_v1_7_deepcolor_ratio = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_dce_clock_parameters_v2_1 {
    pub dceclk_10khz: u32,
    pub dceclktype: u8,
    pub dceclksrc: u8,
    pub dceclkflag: u8,
    pub crtc_id: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_dce_clock_parameters_v2_1"]
        [::core::mem::size_of::<set_dce_clock_parameters_v2_1>() - 8usize];
    ["Alignment of set_dce_clock_parameters_v2_1"]
        [::core::mem::align_of::<set_dce_clock_parameters_v2_1>() - 1usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::dceclk_10khz"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, dceclk_10khz) - 0usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::dceclktype"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, dceclktype) - 4usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::dceclksrc"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, dceclksrc) - 5usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::dceclkflag"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, dceclkflag) - 6usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::crtc_id"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, crtc_id) - 7usize];
};
pub const atom_set_dce_clock_clock_type_DCE_CLOCK_TYPE_DISPCLK: atom_set_dce_clock_clock_type = 0;
pub const atom_set_dce_clock_clock_type_DCE_CLOCK_TYPE_DPREFCLK: atom_set_dce_clock_clock_type = 1;
pub const atom_set_dce_clock_clock_type_DCE_CLOCK_TYPE_PIXELCLK: atom_set_dce_clock_clock_type = 2;
pub type atom_set_dce_clock_clock_type = ::core::ffi::c_uint;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_MASK:
    atom_set_dce_clock_dprefclk_flag = 3;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_GENERICA:
    atom_set_dce_clock_dprefclk_flag = 0;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_GENLK:
    atom_set_dce_clock_dprefclk_flag = 1;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_PCIE:
    atom_set_dce_clock_dprefclk_flag = 2;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_XTALIN:
    atom_set_dce_clock_dprefclk_flag = 3;
pub type atom_set_dce_clock_dprefclk_flag = ::core::ffi::c_uint;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_MASK:
    atom_set_dce_clock_pixclk_flag = 3;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_DIS:
    atom_set_dce_clock_pixclk_flag = 0;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_5_4:
    atom_set_dce_clock_pixclk_flag = 1;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_3_2:
    atom_set_dce_clock_pixclk_flag = 2;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_2_1:
    atom_set_dce_clock_pixclk_flag = 3;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PIXCLK_YUV420_MODE:
    atom_set_dce_clock_pixclk_flag = 4;
pub type atom_set_dce_clock_pixclk_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_dce_clock_ps_allocation_v2_1 {
    pub param: set_dce_clock_parameters_v2_1,
    pub ulReserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_dce_clock_ps_allocation_v2_1"]
        [::core::mem::size_of::<set_dce_clock_ps_allocation_v2_1>() - 16usize];
    ["Alignment of set_dce_clock_ps_allocation_v2_1"]
        [::core::mem::align_of::<set_dce_clock_ps_allocation_v2_1>() - 1usize];
    ["Offset of field: set_dce_clock_ps_allocation_v2_1::param"]
        [::core::mem::offset_of!(set_dce_clock_ps_allocation_v2_1, param) - 0usize];
    ["Offset of field: set_dce_clock_ps_allocation_v2_1::ulReserved"]
        [::core::mem::offset_of!(set_dce_clock_ps_allocation_v2_1, ulReserved) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct blank_crtc_parameters {
    pub crtc_id: u8,
    pub blanking: u8,
    pub reserved: u16,
    pub reserved1: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of blank_crtc_parameters"][::core::mem::size_of::<blank_crtc_parameters>() - 8usize];
    ["Alignment of blank_crtc_parameters"]
        [::core::mem::align_of::<blank_crtc_parameters>() - 1usize];
    ["Offset of field: blank_crtc_parameters::crtc_id"]
        [::core::mem::offset_of!(blank_crtc_parameters, crtc_id) - 0usize];
    ["Offset of field: blank_crtc_parameters::blanking"]
        [::core::mem::offset_of!(blank_crtc_parameters, blanking) - 1usize];
    ["Offset of field: blank_crtc_parameters::reserved"]
        [::core::mem::offset_of!(blank_crtc_parameters, reserved) - 2usize];
    ["Offset of field: blank_crtc_parameters::reserved1"]
        [::core::mem::offset_of!(blank_crtc_parameters, reserved1) - 4usize];
};
pub const atom_blank_crtc_command_ATOM_BLANKING: atom_blank_crtc_command = 1;
pub const atom_blank_crtc_command_ATOM_BLANKING_OFF: atom_blank_crtc_command = 0;
pub type atom_blank_crtc_command = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct enable_crtc_parameters {
    pub crtc_id: u8,
    pub enable: u8,
    pub padding: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of enable_crtc_parameters"][::core::mem::size_of::<enable_crtc_parameters>() - 4usize];
    ["Alignment of enable_crtc_parameters"]
        [::core::mem::align_of::<enable_crtc_parameters>() - 1usize];
    ["Offset of field: enable_crtc_parameters::crtc_id"]
        [::core::mem::offset_of!(enable_crtc_parameters, crtc_id) - 0usize];
    ["Offset of field: enable_crtc_parameters::enable"]
        [::core::mem::offset_of!(enable_crtc_parameters, enable) - 1usize];
    ["Offset of field: enable_crtc_parameters::padding"]
        [::core::mem::offset_of!(enable_crtc_parameters, padding) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct enable_disp_power_gating_parameters_v2_1 {
    pub disp_pipe_id: u8,
    pub enable: u8,
    pub padding: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of enable_disp_power_gating_parameters_v2_1"]
        [::core::mem::size_of::<enable_disp_power_gating_parameters_v2_1>() - 4usize];
    ["Alignment of enable_disp_power_gating_parameters_v2_1"]
        [::core::mem::align_of::<enable_disp_power_gating_parameters_v2_1>() - 1usize];
    ["Offset of field: enable_disp_power_gating_parameters_v2_1::disp_pipe_id"]
        [::core::mem::offset_of!(enable_disp_power_gating_parameters_v2_1, disp_pipe_id) - 0usize];
    ["Offset of field: enable_disp_power_gating_parameters_v2_1::enable"]
        [::core::mem::offset_of!(enable_disp_power_gating_parameters_v2_1, enable) - 1usize];
    ["Offset of field: enable_disp_power_gating_parameters_v2_1::padding"]
        [::core::mem::offset_of!(enable_disp_power_gating_parameters_v2_1, padding) - 2usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct enable_disp_power_gating_ps_allocation {
    pub param: enable_disp_power_gating_parameters_v2_1,
    pub ulReserved: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of enable_disp_power_gating_ps_allocation"]
        [::core::mem::size_of::<enable_disp_power_gating_ps_allocation>() - 20usize];
    ["Alignment of enable_disp_power_gating_ps_allocation"]
        [::core::mem::align_of::<enable_disp_power_gating_ps_allocation>() - 1usize];
    ["Offset of field: enable_disp_power_gating_ps_allocation::param"]
        [::core::mem::offset_of!(enable_disp_power_gating_ps_allocation, param) - 0usize];
    ["Offset of field: enable_disp_power_gating_ps_allocation::ulReserved"]
        [::core::mem::offset_of!(enable_disp_power_gating_ps_allocation, ulReserved) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_crtc_using_dtd_timing_parameters {
    pub h_size: u16,
    pub h_blanking_time: u16,
    pub v_size: u16,
    pub v_blanking_time: u16,
    pub h_syncoffset: u16,
    pub h_syncwidth: u16,
    pub v_syncoffset: u16,
    pub v_syncwidth: u16,
    pub modemiscinfo: u16,
    pub h_border: u8,
    pub v_border: u8,
    pub crtc_id: u8,
    pub encoder_mode: u8,
    pub padding: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_crtc_using_dtd_timing_parameters"]
        [::core::mem::size_of::<set_crtc_using_dtd_timing_parameters>() - 24usize];
    ["Alignment of set_crtc_using_dtd_timing_parameters"]
        [::core::mem::align_of::<set_crtc_using_dtd_timing_parameters>() - 1usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_size"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_size) - 0usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_blanking_time"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_blanking_time) - 2usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_size"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_size) - 4usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_blanking_time"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_blanking_time) - 6usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_syncoffset"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_syncoffset) - 8usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_syncwidth"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_syncwidth) - 10usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_syncoffset"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_syncoffset) - 12usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_syncwidth"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_syncwidth) - 14usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::modemiscinfo"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, modemiscinfo) - 16usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_border"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_border) - 18usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_border"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_border) - 19usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::crtc_id"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, crtc_id) - 20usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::encoder_mode"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, encoder_mode) - 21usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::padding"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, padding) - 22usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct process_i2c_channel_transaction_parameters {
    pub i2cspeed_khz: u8,
    pub regind_status: process_i2c_channel_transaction_parameters__bindgen_ty_1,
    pub i2c_data_out: u16,
    pub flag: u8,
    pub trans_bytes: u8,
    pub slave_addr: u8,
    pub i2c_id: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union process_i2c_channel_transaction_parameters__bindgen_ty_1 {
    pub regindex: u8,
    pub status: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of process_i2c_channel_transaction_parameters__bindgen_ty_1"][::core::mem::size_of::<
        process_i2c_channel_transaction_parameters__bindgen_ty_1,
    >() - 1usize];
    ["Alignment of process_i2c_channel_transaction_parameters__bindgen_ty_1"][::core::mem::align_of::<
        process_i2c_channel_transaction_parameters__bindgen_ty_1,
    >() - 1usize];
    ["Offset of field: process_i2c_channel_transaction_parameters__bindgen_ty_1::regindex"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters__bindgen_ty_1,
        regindex
    )
        - 0usize];
    ["Offset of field: process_i2c_channel_transaction_parameters__bindgen_ty_1::status"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters__bindgen_ty_1,
        status
    )
        - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of process_i2c_channel_transaction_parameters"]
        [::core::mem::size_of::<process_i2c_channel_transaction_parameters>() - 8usize];
    ["Alignment of process_i2c_channel_transaction_parameters"]
        [::core::mem::align_of::<process_i2c_channel_transaction_parameters>() - 1usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::i2cspeed_khz"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters,
        i2cspeed_khz
    ) - 0usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::regind_status"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters,
        regind_status
    ) - 1usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::i2c_data_out"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters,
        i2c_data_out
    ) - 2usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::flag"]
        [::core::mem::offset_of!(process_i2c_channel_transaction_parameters, flag) - 4usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::trans_bytes"]
        [::core::mem::offset_of!(process_i2c_channel_transaction_parameters, trans_bytes) - 5usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::slave_addr"]
        [::core::mem::offset_of!(process_i2c_channel_transaction_parameters, slave_addr) - 6usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::i2c_id"]
        [::core::mem::offset_of!(process_i2c_channel_transaction_parameters, i2c_id) - 7usize];
};
pub const atom_process_i2c_flag_HW_I2C_WRITE: atom_process_i2c_flag = 1;
pub const atom_process_i2c_flag_HW_I2C_READ: atom_process_i2c_flag = 0;
pub const atom_process_i2c_flag_I2C_2BYTE_ADDR: atom_process_i2c_flag = 2;
pub const atom_process_i2c_flag_HW_I2C_SMBUS_BYTE_WR: atom_process_i2c_flag = 4;
pub type atom_process_i2c_flag = ::core::ffi::c_uint;
pub const atom_process_i2c_status_HW_ASSISTED_I2C_STATUS_FAILURE: atom_process_i2c_status = 2;
pub const atom_process_i2c_status_HW_ASSISTED_I2C_STATUS_SUCCESS: atom_process_i2c_status = 1;
pub type atom_process_i2c_status = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct process_aux_channel_transaction_parameters_v1_2 {
    pub aux_request: u16,
    pub dataout: u16,
    pub channelid: u8,
    pub aux_status_delay: process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1,
    pub dataout_len: u8,
    pub hpd_id: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1 {
    pub reply_status: u8,
    pub aux_delay: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1"][::core::mem::size_of::<
        process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1,
    >() - 1usize];
    ["Alignment of process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1"]
        [::core::mem::align_of::<process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1>()
            - 1usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1::reply_status"] [:: core :: mem :: offset_of ! (process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1 , reply_status) - 0usize] ;
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1::aux_delay"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1,
        aux_delay
    )
        - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of process_aux_channel_transaction_parameters_v1_2"]
        [::core::mem::size_of::<process_aux_channel_transaction_parameters_v1_2>() - 8usize];
    ["Alignment of process_aux_channel_transaction_parameters_v1_2"]
        [::core::mem::align_of::<process_aux_channel_transaction_parameters_v1_2>() - 1usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::aux_request"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        aux_request
    ) - 0usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::dataout"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        dataout
    ) - 2usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::channelid"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        channelid
    ) - 4usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::aux_status_delay"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        aux_status_delay
    )
        - 5usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::dataout_len"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        dataout_len
    ) - 6usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::hpd_id"]
        [::core::mem::offset_of!(process_aux_channel_transaction_parameters_v1_2, hpd_id) - 7usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct select_crtc_source_parameters_v2_3 {
    pub crtc_id: u8,
    pub encoder_id: u8,
    pub encode_mode: u8,
    pub dst_bpc: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of select_crtc_source_parameters_v2_3"]
        [::core::mem::size_of::<select_crtc_source_parameters_v2_3>() - 4usize];
    ["Alignment of select_crtc_source_parameters_v2_3"]
        [::core::mem::align_of::<select_crtc_source_parameters_v2_3>() - 1usize];
    ["Offset of field: select_crtc_source_parameters_v2_3::crtc_id"]
        [::core::mem::offset_of!(select_crtc_source_parameters_v2_3, crtc_id) - 0usize];
    ["Offset of field: select_crtc_source_parameters_v2_3::encoder_id"]
        [::core::mem::offset_of!(select_crtc_source_parameters_v2_3, encoder_id) - 1usize];
    ["Offset of field: select_crtc_source_parameters_v2_3::encode_mode"]
        [::core::mem::offset_of!(select_crtc_source_parameters_v2_3, encode_mode) - 2usize];
    ["Offset of field: select_crtc_source_parameters_v2_3::dst_bpc"]
        [::core::mem::offset_of!(select_crtc_source_parameters_v2_3, dst_bpc) - 3usize];
};
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DISABLE_DIG:
    atom_dig_encoder_control_action = 0;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_ENABLE_DIG:
    atom_dig_encoder_control_action = 1;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_START:
    atom_dig_encoder_control_action = 8;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN1:
    atom_dig_encoder_control_action = 9;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN2:
    atom_dig_encoder_control_action = 10;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN3:
    atom_dig_encoder_control_action = 19;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_COMPLETE:
    atom_dig_encoder_control_action = 11;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_VIDEO_OFF:
    atom_dig_encoder_control_action = 12;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_VIDEO_ON:
    atom_dig_encoder_control_action = 13;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_SETUP_PANEL_MODE:
    atom_dig_encoder_control_action = 16;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN4:
    atom_dig_encoder_control_action = 20;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_STREAM_SETUP:
    atom_dig_encoder_control_action = 15;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_LINK_SETUP:
    atom_dig_encoder_control_action = 17;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_ENCODER_BLANK:
    atom_dig_encoder_control_action = 18;
pub type atom_dig_encoder_control_action = ::core::ffi::c_uint;
pub const atom_dig_encoder_control_panelmode_DP_PANEL_MODE_DISABLE:
    atom_dig_encoder_control_panelmode = 0;
pub const atom_dig_encoder_control_panelmode_DP_PANEL_MODE_ENABLE_eDP_MODE:
    atom_dig_encoder_control_panelmode = 1;
pub const atom_dig_encoder_control_panelmode_DP_PANEL_MODE_ENABLE_LVLINK_MODE:
    atom_dig_encoder_control_panelmode = 17;
pub type atom_dig_encoder_control_panelmode = ::core::ffi::c_uint;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG0_ENCODER:
    atom_dig_encoder_control_v5_digid = 0;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG1_ENCODER:
    atom_dig_encoder_control_v5_digid = 1;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG2_ENCODER:
    atom_dig_encoder_control_v5_digid = 2;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG3_ENCODER:
    atom_dig_encoder_control_v5_digid = 3;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG4_ENCODER:
    atom_dig_encoder_control_v5_digid = 4;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG5_ENCODER:
    atom_dig_encoder_control_v5_digid = 5;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG6_ENCODER:
    atom_dig_encoder_control_v5_digid = 6;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG7_ENCODER:
    atom_dig_encoder_control_v5_digid = 7;
pub type atom_dig_encoder_control_v5_digid = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dig_encoder_stream_setup_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub digmode: u8,
    pub lanenum: u8,
    pub pclk_10khz: u32,
    pub bitpercolor: u8,
    pub dplinkrate_270mhz: u8,
    pub reserved: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_encoder_stream_setup_parameters_v1_5"]
        [::core::mem::size_of::<dig_encoder_stream_setup_parameters_v1_5>() - 12usize];
    ["Alignment of dig_encoder_stream_setup_parameters_v1_5"]
        [::core::mem::align_of::<dig_encoder_stream_setup_parameters_v1_5>() - 1usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::digid"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, digid) - 0usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::action"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, action) - 1usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::digmode"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, digmode) - 2usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::lanenum"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, lanenum) - 3usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::pclk_10khz"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, pclk_10khz) - 4usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::bitpercolor"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, bitpercolor) - 8usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::dplinkrate_270mhz"][::core::mem::offset_of!(
        dig_encoder_stream_setup_parameters_v1_5,
        dplinkrate_270mhz
    ) - 9usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::reserved"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, reserved) - 10usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dig_encoder_link_setup_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub digmode: u8,
    pub lanenum: u8,
    pub symclk_10khz: u8,
    pub hpd_sel: u8,
    pub digfe_sel: u8,
    pub reserved: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_encoder_link_setup_parameters_v1_5"]
        [::core::mem::size_of::<dig_encoder_link_setup_parameters_v1_5>() - 9usize];
    ["Alignment of dig_encoder_link_setup_parameters_v1_5"]
        [::core::mem::align_of::<dig_encoder_link_setup_parameters_v1_5>() - 1usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::digid"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, digid) - 0usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::action"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, action) - 1usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::digmode"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, digmode) - 2usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::lanenum"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, lanenum) - 3usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::symclk_10khz"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, symclk_10khz) - 4usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::hpd_sel"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, hpd_sel) - 5usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::digfe_sel"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, digfe_sel) - 6usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::reserved"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, reserved) - 7usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dp_panel_mode_set_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub panelmode: u8,
    pub reserved1: u8,
    pub reserved2: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dp_panel_mode_set_parameters_v1_5"]
        [::core::mem::size_of::<dp_panel_mode_set_parameters_v1_5>() - 12usize];
    ["Alignment of dp_panel_mode_set_parameters_v1_5"]
        [::core::mem::align_of::<dp_panel_mode_set_parameters_v1_5>() - 1usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::digid"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, digid) - 0usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::action"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, action) - 1usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::panelmode"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, panelmode) - 2usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::reserved1"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, reserved1) - 3usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::reserved2"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, reserved2) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dig_encoder_generic_cmd_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub reserved1: [u8; 2usize],
    pub reserved2: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_encoder_generic_cmd_parameters_v1_5"]
        [::core::mem::size_of::<dig_encoder_generic_cmd_parameters_v1_5>() - 12usize];
    ["Alignment of dig_encoder_generic_cmd_parameters_v1_5"]
        [::core::mem::align_of::<dig_encoder_generic_cmd_parameters_v1_5>() - 1usize];
    ["Offset of field: dig_encoder_generic_cmd_parameters_v1_5::digid"]
        [::core::mem::offset_of!(dig_encoder_generic_cmd_parameters_v1_5, digid) - 0usize];
    ["Offset of field: dig_encoder_generic_cmd_parameters_v1_5::action"]
        [::core::mem::offset_of!(dig_encoder_generic_cmd_parameters_v1_5, action) - 1usize];
    ["Offset of field: dig_encoder_generic_cmd_parameters_v1_5::reserved1"]
        [::core::mem::offset_of!(dig_encoder_generic_cmd_parameters_v1_5, reserved1) - 2usize];
    ["Offset of field: dig_encoder_generic_cmd_parameters_v1_5::reserved2"]
        [::core::mem::offset_of!(dig_encoder_generic_cmd_parameters_v1_5, reserved2) - 4usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union dig_encoder_control_parameters_v1_5 {
    pub cmd_param: dig_encoder_generic_cmd_parameters_v1_5,
    pub stream_param: dig_encoder_stream_setup_parameters_v1_5,
    pub link_param: dig_encoder_link_setup_parameters_v1_5,
    pub dppanel_param: dp_panel_mode_set_parameters_v1_5,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_encoder_control_parameters_v1_5"]
        [::core::mem::size_of::<dig_encoder_control_parameters_v1_5>() - 12usize];
    ["Alignment of dig_encoder_control_parameters_v1_5"]
        [::core::mem::align_of::<dig_encoder_control_parameters_v1_5>() - 1usize];
    ["Offset of field: dig_encoder_control_parameters_v1_5::cmd_param"]
        [::core::mem::offset_of!(dig_encoder_control_parameters_v1_5, cmd_param) - 0usize];
    ["Offset of field: dig_encoder_control_parameters_v1_5::stream_param"]
        [::core::mem::offset_of!(dig_encoder_control_parameters_v1_5, stream_param) - 0usize];
    ["Offset of field: dig_encoder_control_parameters_v1_5::link_param"]
        [::core::mem::offset_of!(dig_encoder_control_parameters_v1_5, link_param) - 0usize];
    ["Offset of field: dig_encoder_control_parameters_v1_5::dppanel_param"]
        [::core::mem::offset_of!(dig_encoder_control_parameters_v1_5, dppanel_param) - 0usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct dig_transmitter_control_parameters_v1_6 {
    pub phyid: u8,
    pub action: u8,
    pub mode_laneset: dig_transmitter_control_parameters_v1_6__bindgen_ty_1,
    pub lanenum: u8,
    pub symclk_10khz: u32,
    pub hpdsel: u8,
    pub digfe_sel: u8,
    pub connobj_id: u8,
    pub reserved: u8,
    pub reserved1: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union dig_transmitter_control_parameters_v1_6__bindgen_ty_1 {
    pub digmode: u8,
    pub dplaneset: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_transmitter_control_parameters_v1_6__bindgen_ty_1"]
        [::core::mem::size_of::<dig_transmitter_control_parameters_v1_6__bindgen_ty_1>() - 1usize];
    ["Alignment of dig_transmitter_control_parameters_v1_6__bindgen_ty_1"]
        [::core::mem::align_of::<dig_transmitter_control_parameters_v1_6__bindgen_ty_1>() - 1usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6__bindgen_ty_1::digmode"][::core::mem::offset_of!(
        dig_transmitter_control_parameters_v1_6__bindgen_ty_1,
        digmode
    ) - 0usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6__bindgen_ty_1::dplaneset"][::core::mem::offset_of!(
        dig_transmitter_control_parameters_v1_6__bindgen_ty_1,
        dplaneset
    )
        - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_transmitter_control_parameters_v1_6"]
        [::core::mem::size_of::<dig_transmitter_control_parameters_v1_6>() - 16usize];
    ["Alignment of dig_transmitter_control_parameters_v1_6"]
        [::core::mem::align_of::<dig_transmitter_control_parameters_v1_6>() - 1usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::phyid"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, phyid) - 0usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::action"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, action) - 1usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::mode_laneset"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, mode_laneset) - 2usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::lanenum"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, lanenum) - 3usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::symclk_10khz"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, symclk_10khz) - 4usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::hpdsel"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, hpdsel) - 8usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::digfe_sel"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, digfe_sel) - 9usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::connobj_id"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, connobj_id) - 10usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::reserved"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, reserved) - 11usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::reserved1"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, reserved1) - 12usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct dig_transmitter_control_ps_allocation_v1_6 {
    pub param: dig_transmitter_control_parameters_v1_6,
    pub reserved: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_transmitter_control_ps_allocation_v1_6"]
        [::core::mem::size_of::<dig_transmitter_control_ps_allocation_v1_6>() - 32usize];
    ["Alignment of dig_transmitter_control_ps_allocation_v1_6"]
        [::core::mem::align_of::<dig_transmitter_control_ps_allocation_v1_6>() - 1usize];
    ["Offset of field: dig_transmitter_control_ps_allocation_v1_6::param"]
        [::core::mem::offset_of!(dig_transmitter_control_ps_allocation_v1_6, param) - 0usize];
    ["Offset of field: dig_transmitter_control_ps_allocation_v1_6::reserved"]
        [::core::mem::offset_of!(dig_transmitter_control_ps_allocation_v1_6, reserved) - 16usize];
};
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_DISABLE:
    atom_dig_transmitter_control_action = 0;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_ENABLE:
    atom_dig_transmitter_control_action = 1;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_BLOFF:
    atom_dig_transmitter_control_action = 2;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_BLON:
    atom_dig_transmitter_control_action = 3;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_BL_BRIGHTNESS_CONTROL:
    atom_dig_transmitter_control_action = 4;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_SELFTEST_START:
    atom_dig_transmitter_control_action = 5;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_SELFTEST_STOP:
    atom_dig_transmitter_control_action = 6;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_INIT:
    atom_dig_transmitter_control_action = 7;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_DISABLE_OUTPUT:
    atom_dig_transmitter_control_action = 8;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_ENABLE_OUTPUT:
    atom_dig_transmitter_control_action = 9;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_SETUP:
    atom_dig_transmitter_control_action = 10;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_SETUP_VSEMPH:
    atom_dig_transmitter_control_action = 11;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_POWER_ON:
    atom_dig_transmitter_control_action = 12;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_POWER_OFF:
    atom_dig_transmitter_control_action = 13;
pub type atom_dig_transmitter_control_action = ::core::ffi::c_uint;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGA_SEL:
    atom_dig_transmitter_control_digfe_sel = 1;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGB_SEL:
    atom_dig_transmitter_control_digfe_sel = 2;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGC_SEL:
    atom_dig_transmitter_control_digfe_sel = 4;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGD_SEL:
    atom_dig_transmitter_control_digfe_sel = 8;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGE_SEL:
    atom_dig_transmitter_control_digfe_sel = 16;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGF_SEL:
    atom_dig_transmitter_control_digfe_sel = 32;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGG_SEL:
    atom_dig_transmitter_control_digfe_sel = 64;
pub type atom_dig_transmitter_control_digfe_sel = ::core::ffi::c_uint;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_NO_HPD_SEL:
    atom_dig_transmitter_control_hpd_sel = 0;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD1_SEL:
    atom_dig_transmitter_control_hpd_sel = 1;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD2_SEL:
    atom_dig_transmitter_control_hpd_sel = 2;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD3_SEL:
    atom_dig_transmitter_control_hpd_sel = 3;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD4_SEL:
    atom_dig_transmitter_control_hpd_sel = 4;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD5_SEL:
    atom_dig_transmitter_control_hpd_sel = 5;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD6_SEL:
    atom_dig_transmitter_control_hpd_sel = 6;
pub type atom_dig_transmitter_control_hpd_sel = ::core::ffi::c_uint;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 0;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_0_6V:
    atom_dig_transmitter_control_dplaneset = 1;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_0_8V:
    atom_dig_transmitter_control_dplaneset = 2;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_1_2V:
    atom_dig_transmitter_control_dplaneset = 3;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__3_5DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 8;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__3_5DB_0_6V:
    atom_dig_transmitter_control_dplaneset = 9;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__3_5DB_0_8V:
    atom_dig_transmitter_control_dplaneset = 10;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__6DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 16;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__6DB_0_6V:
    atom_dig_transmitter_control_dplaneset = 17;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__9_5DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 24;
pub type atom_dig_transmitter_control_dplaneset = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct external_encoder_control_parameters_v2_4 {
    pub pixelclock_10khz: u16,
    pub config: u8,
    pub action: u8,
    pub encodermode: u8,
    pub lanenum: u8,
    pub bitpercolor: u8,
    pub hpd_id: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of external_encoder_control_parameters_v2_4"]
        [::core::mem::size_of::<external_encoder_control_parameters_v2_4>() - 8usize];
    ["Alignment of external_encoder_control_parameters_v2_4"]
        [::core::mem::align_of::<external_encoder_control_parameters_v2_4>() - 1usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::pixelclock_10khz"][::core::mem::offset_of!(
        external_encoder_control_parameters_v2_4,
        pixelclock_10khz
    ) - 0usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::config"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, config) - 2usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::action"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, action) - 3usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::encodermode"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, encodermode) - 4usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::lanenum"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, lanenum) - 5usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::bitpercolor"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, bitpercolor) - 6usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::hpd_id"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, hpd_id) - 7usize];
};
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_DISABLE_OUTPUT:
    external_encoder_control_action_def = 0;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENABLE_OUTPUT:
    external_encoder_control_action_def = 1;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_INIT:
    external_encoder_control_action_def = 7;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_SETUP:
    external_encoder_control_action_def = 15;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_BLANKING_OFF:
    external_encoder_control_action_def = 16;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_BLANKING:
    external_encoder_control_action_def = 17;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_DACLOAD_DETECTION:
    external_encoder_control_action_def = 18;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_DDC_SETUP:
    external_encoder_control_action_def = 20;
pub type external_encoder_control_action_def = ::core::ffi::c_uint;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_MASK:
    external_encoder_control_v2_4_config_def = 3;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_1_62GHZ:
    external_encoder_control_v2_4_config_def = 0;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_2_70GHZ:
    external_encoder_control_v2_4_config_def = 1;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_5_40GHZ:
    external_encoder_control_v2_4_config_def = 2;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_3_24GHZ:
    external_encoder_control_v2_4_config_def = 3;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER_SEL_MAKS:
    external_encoder_control_v2_4_config_def = 112;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER1:
    external_encoder_control_v2_4_config_def = 0;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER2:
    external_encoder_control_v2_4_config_def = 16;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER3:
    external_encoder_control_v2_4_config_def = 32;
pub type external_encoder_control_v2_4_config_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct external_encoder_control_ps_allocation_v2_4 {
    pub sExtEncoder: external_encoder_control_parameters_v2_4,
    pub reserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of external_encoder_control_ps_allocation_v2_4"]
        [::core::mem::size_of::<external_encoder_control_ps_allocation_v2_4>() - 16usize];
    ["Alignment of external_encoder_control_ps_allocation_v2_4"]
        [::core::mem::align_of::<external_encoder_control_ps_allocation_v2_4>() - 1usize];
    ["Offset of field: external_encoder_control_ps_allocation_v2_4::sExtEncoder"][::core::mem::offset_of!(
        external_encoder_control_ps_allocation_v2_4,
        sExtEncoder
    ) - 0usize];
    ["Offset of field: external_encoder_control_ps_allocation_v2_4::reserved"]
        [::core::mem::offset_of!(external_encoder_control_ps_allocation_v2_4, reserved) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct amd_acpi_description_header {
    pub signature: u32,
    pub tableLength: u32,
    pub revision: u8,
    pub checksum: u8,
    pub oemId: [u8; 6usize],
    pub oemTableId: [u8; 8usize],
    pub oemRevision: u32,
    pub creatorId: u32,
    pub creatorRevision: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amd_acpi_description_header"]
        [::core::mem::size_of::<amd_acpi_description_header>() - 36usize];
    ["Alignment of amd_acpi_description_header"]
        [::core::mem::align_of::<amd_acpi_description_header>() - 1usize];
    ["Offset of field: amd_acpi_description_header::signature"]
        [::core::mem::offset_of!(amd_acpi_description_header, signature) - 0usize];
    ["Offset of field: amd_acpi_description_header::tableLength"]
        [::core::mem::offset_of!(amd_acpi_description_header, tableLength) - 4usize];
    ["Offset of field: amd_acpi_description_header::revision"]
        [::core::mem::offset_of!(amd_acpi_description_header, revision) - 8usize];
    ["Offset of field: amd_acpi_description_header::checksum"]
        [::core::mem::offset_of!(amd_acpi_description_header, checksum) - 9usize];
    ["Offset of field: amd_acpi_description_header::oemId"]
        [::core::mem::offset_of!(amd_acpi_description_header, oemId) - 10usize];
    ["Offset of field: amd_acpi_description_header::oemTableId"]
        [::core::mem::offset_of!(amd_acpi_description_header, oemTableId) - 16usize];
    ["Offset of field: amd_acpi_description_header::oemRevision"]
        [::core::mem::offset_of!(amd_acpi_description_header, oemRevision) - 24usize];
    ["Offset of field: amd_acpi_description_header::creatorId"]
        [::core::mem::offset_of!(amd_acpi_description_header, creatorId) - 28usize];
    ["Offset of field: amd_acpi_description_header::creatorRevision"]
        [::core::mem::offset_of!(amd_acpi_description_header, creatorRevision) - 32usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct uefi_acpi_vfct {
    pub sheader: amd_acpi_description_header,
    pub tableUUID: [u8; 16usize],
    pub vbiosimageoffset: u32,
    pub lib1Imageoffset: u32,
    pub reserved: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of uefi_acpi_vfct"][::core::mem::size_of::<uefi_acpi_vfct>() - 76usize];
    ["Alignment of uefi_acpi_vfct"][::core::mem::align_of::<uefi_acpi_vfct>() - 1usize];
    ["Offset of field: uefi_acpi_vfct::sheader"]
        [::core::mem::offset_of!(uefi_acpi_vfct, sheader) - 0usize];
    ["Offset of field: uefi_acpi_vfct::tableUUID"]
        [::core::mem::offset_of!(uefi_acpi_vfct, tableUUID) - 36usize];
    ["Offset of field: uefi_acpi_vfct::vbiosimageoffset"]
        [::core::mem::offset_of!(uefi_acpi_vfct, vbiosimageoffset) - 52usize];
    ["Offset of field: uefi_acpi_vfct::lib1Imageoffset"]
        [::core::mem::offset_of!(uefi_acpi_vfct, lib1Imageoffset) - 56usize];
    ["Offset of field: uefi_acpi_vfct::reserved"]
        [::core::mem::offset_of!(uefi_acpi_vfct, reserved) - 60usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct vfct_image_header {
    pub pcibus: u32,
    pub pcidevice: u32,
    pub pcifunction: u32,
    pub vendorid: u16,
    pub deviceid: u16,
    pub ssvid: u16,
    pub ssid: u16,
    pub revision: u32,
    pub imagelength: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vfct_image_header"][::core::mem::size_of::<vfct_image_header>() - 28usize];
    ["Alignment of vfct_image_header"][::core::mem::align_of::<vfct_image_header>() - 1usize];
    ["Offset of field: vfct_image_header::pcibus"]
        [::core::mem::offset_of!(vfct_image_header, pcibus) - 0usize];
    ["Offset of field: vfct_image_header::pcidevice"]
        [::core::mem::offset_of!(vfct_image_header, pcidevice) - 4usize];
    ["Offset of field: vfct_image_header::pcifunction"]
        [::core::mem::offset_of!(vfct_image_header, pcifunction) - 8usize];
    ["Offset of field: vfct_image_header::vendorid"]
        [::core::mem::offset_of!(vfct_image_header, vendorid) - 12usize];
    ["Offset of field: vfct_image_header::deviceid"]
        [::core::mem::offset_of!(vfct_image_header, deviceid) - 14usize];
    ["Offset of field: vfct_image_header::ssvid"]
        [::core::mem::offset_of!(vfct_image_header, ssvid) - 16usize];
    ["Offset of field: vfct_image_header::ssid"]
        [::core::mem::offset_of!(vfct_image_header, ssid) - 18usize];
    ["Offset of field: vfct_image_header::revision"]
        [::core::mem::offset_of!(vfct_image_header, revision) - 20usize];
    ["Offset of field: vfct_image_header::imagelength"]
        [::core::mem::offset_of!(vfct_image_header, imagelength) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gop_vbios_content {
    pub vbiosheader: vfct_image_header,
    pub vbioscontent: [u8; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of gop_vbios_content"][::core::mem::size_of::<gop_vbios_content>() - 29usize];
    ["Alignment of gop_vbios_content"][::core::mem::align_of::<gop_vbios_content>() - 1usize];
    ["Offset of field: gop_vbios_content::vbiosheader"]
        [::core::mem::offset_of!(gop_vbios_content, vbiosheader) - 0usize];
    ["Offset of field: gop_vbios_content::vbioscontent"]
        [::core::mem::offset_of!(gop_vbios_content, vbioscontent) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gop_lib1_content {
    pub lib1header: vfct_image_header,
    pub lib1content: [u8; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of gop_lib1_content"][::core::mem::size_of::<gop_lib1_content>() - 29usize];
    ["Alignment of gop_lib1_content"][::core::mem::align_of::<gop_lib1_content>() - 1usize];
    ["Offset of field: gop_lib1_content::lib1header"]
        [::core::mem::offset_of!(gop_lib1_content, lib1header) - 0usize];
    ["Offset of field: gop_lib1_content::lib1content"]
        [::core::mem::offset_of!(gop_lib1_content, lib1content) - 28usize];
};
pub const scratch_register_def_ATOM_DEVICE_CONNECT_INFO_DEF: scratch_register_def = 0;
pub const scratch_register_def_ATOM_BL_BRI_LEVEL_INFO_DEF: scratch_register_def = 2;
pub const scratch_register_def_ATOM_ACTIVE_INFO_DEF: scratch_register_def = 3;
pub const scratch_register_def_ATOM_LCD_INFO_DEF: scratch_register_def = 4;
pub const scratch_register_def_ATOM_DEVICE_REQ_INFO_DEF: scratch_register_def = 5;
pub const scratch_register_def_ATOM_ACC_CHANGE_INFO_DEF: scratch_register_def = 6;
pub const scratch_register_def_ATOM_PRE_OS_MODE_INFO_DEF: scratch_register_def = 7;
pub const scratch_register_def_ATOM_PRE_OS_ASSERTION_DEF: scratch_register_def = 8;
pub const scratch_register_def_ATOM_INTERNAL_TIMER_INFO_DEF: scratch_register_def = 10;
pub type scratch_register_def = ::core::ffi::c_uint;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_LCD1_CONNECT:
    scratch_device_connect_info_bit_def = 2;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP1_CONNECT:
    scratch_device_connect_info_bit_def = 8;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP2_CONNECT:
    scratch_device_connect_info_bit_def = 128;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP3_CONNECT:
    scratch_device_connect_info_bit_def = 512;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP4_CONNECT:
    scratch_device_connect_info_bit_def = 1024;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP5_CONNECT:
    scratch_device_connect_info_bit_def = 2048;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP6_CONNECT:
    scratch_device_connect_info_bit_def = 64;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFPx_CONNECT:
    scratch_device_connect_info_bit_def = 3784;
pub const scratch_device_connect_info_bit_def_ATOM_CONNECT_INFO_DEVICE_MASK:
    scratch_device_connect_info_bit_def = 4095;
pub type scratch_device_connect_info_bit_def = ::core::ffi::c_uint;
pub const scratch_bl_bri_level_info_bit_def_ATOM_CURRENT_BL_LEVEL_SHIFT:
    scratch_bl_bri_level_info_bit_def = 8;
pub const scratch_bl_bri_level_info_bit_def_ATOM_CURRENT_BL_LEVEL_MASK:
    scratch_bl_bri_level_info_bit_def = 65280;
pub const scratch_bl_bri_level_info_bit_def_ATOM_DEVICE_DPMS_STATE:
    scratch_bl_bri_level_info_bit_def = 65536;
pub type scratch_bl_bri_level_info_bit_def = ::core::ffi::c_uint;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_LCD1_ACTIVE: scratch_active_info_bits_def = 2;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP1_ACTIVE: scratch_active_info_bits_def = 8;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP2_ACTIVE: scratch_active_info_bits_def = 128;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP3_ACTIVE: scratch_active_info_bits_def = 512;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP4_ACTIVE: scratch_active_info_bits_def =
    1024;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP5_ACTIVE: scratch_active_info_bits_def =
    2048;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP6_ACTIVE: scratch_active_info_bits_def = 64;
pub const scratch_active_info_bits_def_ATOM_ACTIVE_INFO_DEVICE_MASK: scratch_active_info_bits_def =
    4095;
pub type scratch_active_info_bits_def = ::core::ffi::c_uint;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_LCD1_REQ: scratch_device_req_info_bits_def =
    2;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP1_REQ: scratch_device_req_info_bits_def =
    8;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP2_REQ: scratch_device_req_info_bits_def =
    128;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP3_REQ: scratch_device_req_info_bits_def =
    512;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP4_REQ: scratch_device_req_info_bits_def =
    1024;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP5_REQ: scratch_device_req_info_bits_def =
    2048;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP6_REQ: scratch_device_req_info_bits_def =
    64;
pub const scratch_device_req_info_bits_def_ATOM_REQ_INFO_DEVICE_MASK:
    scratch_device_req_info_bits_def = 4095;
pub type scratch_device_req_info_bits_def = ::core::ffi::c_uint;
pub const scratch_acc_change_info_bitshift_def_ATOM_ACC_CHANGE_ACC_MODE_SHIFT:
    scratch_acc_change_info_bitshift_def = 4;
pub const scratch_acc_change_info_bitshift_def_ATOM_ACC_CHANGE_LID_STATUS_SHIFT:
    scratch_acc_change_info_bitshift_def = 6;
pub type scratch_acc_change_info_bitshift_def = ::core::ffi::c_uint;
pub const scratch_acc_change_info_bits_def_ATOM_ACC_CHANGE_ACC_MODE:
    scratch_acc_change_info_bits_def = 16;
pub const scratch_acc_change_info_bits_def_ATOM_ACC_CHANGE_LID_STATUS:
    scratch_acc_change_info_bits_def = 64;
pub type scratch_acc_change_info_bits_def = ::core::ffi::c_uint;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_MASK:
    scratch_pre_os_mode_info_bits_def = 3;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_VGA:
    scratch_pre_os_mode_info_bits_def = 0;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_VESA:
    scratch_pre_os_mode_info_bits_def = 1;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_GOP:
    scratch_pre_os_mode_info_bits_def = 2;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_PIXEL_DEPTH:
    scratch_pre_os_mode_info_bits_def = 12;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_PIXEL_FORMAT_MASK:
    scratch_pre_os_mode_info_bits_def = 240;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_8BIT_PAL_EN:
    scratch_pre_os_mode_info_bits_def = 256;
pub const scratch_pre_os_mode_info_bits_def_ATOM_ASIC_INIT_COMPLETE:
    scratch_pre_os_mode_info_bits_def = 512;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_NUMBER_MASK:
    scratch_pre_os_mode_info_bits_def = 4294901760;
pub type scratch_pre_os_mode_info_bits_def = ::core::ffi::c_uint;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__UTILITY_PIPELINE: atom_master_data_table_id =
    0;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__MULTIMEDIA_INF: atom_master_data_table_id =
    1;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__FIRMWARE_INF: atom_master_data_table_id = 2;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__LCD_INF: atom_master_data_table_id = 3;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__SMU_INF: atom_master_data_table_id = 4;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__VRAM_USAGE_BY_FIRMWARE:
    atom_master_data_table_id = 5;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__GPIO_PIN_LUT: atom_master_data_table_id = 6;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__GFX_INF: atom_master_data_table_id = 7;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__POWER_PLAY_INF: atom_master_data_table_id =
    8;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__DISPLAY_OBJECT_INF:
    atom_master_data_table_id = 9;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__INDIRECT_IO_ACCESS:
    atom_master_data_table_id = 10;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__UMC_INF: atom_master_data_table_id = 11;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__DCE_INF: atom_master_data_table_id = 12;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__VRAM_INF: atom_master_data_table_id = 13;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__INTEGRATED_SYS_INF:
    atom_master_data_table_id = 14;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__ASIC_PROFILING_INF:
    atom_master_data_table_id = 15;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__VOLTAGE_OBJ_INF: atom_master_data_table_id =
    16;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__UNDEFINED: atom_master_data_table_id = 17;
pub type atom_master_data_table_id = ::core::ffi::c_uint;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__ASIC_INIT: atom_master_command_table_id =
    0;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__DIGX_ENCODER_CONTROL:
    atom_master_command_table_id = 1;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_ENGINE_CLOCK:
    atom_master_command_table_id = 2;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_MEMORY_CLOCK:
    atom_master_command_table_id = 3;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_PIXEL_CLOCK:
    atom_master_command_table_id = 4;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__ENABLE_DISP_POWER_GATING:
    atom_master_command_table_id = 5;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__BLANK_CRTC: atom_master_command_table_id =
    6;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__ENABLE_CRTC: atom_master_command_table_id =
    7;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_SMU_CLOCK_INFO:
    atom_master_command_table_id = 8;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SELECT_CRTC_SOURCE:
    atom_master_command_table_id = 9;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_DCE_CLOCK:
    atom_master_command_table_id = 10;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_MEMORY_CLOCK:
    atom_master_command_table_id = 11;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_ENGINE_CLOCK:
    atom_master_command_table_id = 12;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_CRTC_USING_DTD_TIMING:
    atom_master_command_table_id = 13;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__EXTENAL_ENCODER_CONTROL:
    atom_master_command_table_id = 14;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__PROCESS_I2C_CHANNEL_TRANSACTION:
    atom_master_command_table_id = 15;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__COMPUTE_GPU_CLOCK_PARAM:
    atom_master_command_table_id = 16;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__DYNAMIC_MEMORY_SETTINGS:
    atom_master_command_table_id = 17;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__MEMORY_TRAINING:
    atom_master_command_table_id = 18;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_VOLTAGE: atom_master_command_table_id =
    19;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__DIG1_TRANSMITTER_CONTROL:
    atom_master_command_table_id = 20;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__PROCESS_AUX_CHANNEL_TRANSACTION:
    atom_master_command_table_id = 21;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_VOLTAGE_INF:
    atom_master_command_table_id = 22;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__UNDEFINED: atom_master_command_table_id =
    23;
pub type atom_master_command_table_id = ::core::ffi::c_uint;
pub const FEATURE_PWR_DOMAIN_e_FEATURE_PWR_ALL: FEATURE_PWR_DOMAIN_e = 0;
pub const FEATURE_PWR_DOMAIN_e_FEATURE_PWR_S5: FEATURE_PWR_DOMAIN_e = 1;
pub const FEATURE_PWR_DOMAIN_e_FEATURE_PWR_BACO: FEATURE_PWR_DOMAIN_e = 2;
pub const FEATURE_PWR_DOMAIN_e_FEATURE_PWR_SOC: FEATURE_PWR_DOMAIN_e = 3;
pub const FEATURE_PWR_DOMAIN_e_FEATURE_PWR_GFX: FEATURE_PWR_DOMAIN_e = 4;
pub const FEATURE_PWR_DOMAIN_e_FEATURE_PWR_DOMAIN_COUNT: FEATURE_PWR_DOMAIN_e = 5;
pub type FEATURE_PWR_DOMAIN_e = ::core::ffi::c_uint;
pub const SVI_PSI_e_SVI_PSI_0: SVI_PSI_e = 0;
pub const SVI_PSI_e_SVI_PSI_1: SVI_PSI_e = 1;
pub const SVI_PSI_e_SVI_PSI_2: SVI_PSI_e = 2;
pub const SVI_PSI_e_SVI_PSI_3: SVI_PSI_e = 3;
pub const SVI_PSI_e_SVI_PSI_4: SVI_PSI_e = 4;
pub const SVI_PSI_e_SVI_PSI_5: SVI_PSI_e = 5;
pub const SVI_PSI_e_SVI_PSI_6: SVI_PSI_e = 6;
pub const SVI_PSI_e_SVI_PSI_7: SVI_PSI_e = 7;
pub type SVI_PSI_e = ::core::ffi::c_uint;
pub const SMARTSHIFT_VERSION_e_SMARTSHIFT_VERSION_1: SMARTSHIFT_VERSION_e = 0;
pub const SMARTSHIFT_VERSION_e_SMARTSHIFT_VERSION_2: SMARTSHIFT_VERSION_e = 1;
pub const SMARTSHIFT_VERSION_e_SMARTSHIFT_VERSION_3: SMARTSHIFT_VERSION_e = 2;
pub type SMARTSHIFT_VERSION_e = ::core::ffi::c_uint;
pub const FOPT_CALC_e_FOPT_CALC_AC_CALC_DC: FOPT_CALC_e = 0;
pub const FOPT_CALC_e_FOPT_PPTABLE_AC_CALC_DC: FOPT_CALC_e = 1;
pub const FOPT_CALC_e_FOPT_CALC_AC_PPTABLE_DC: FOPT_CALC_e = 2;
pub const FOPT_CALC_e_FOPT_PPTABLE_AC_PPTABLE_DC: FOPT_CALC_e = 3;
pub type FOPT_CALC_e = ::core::ffi::c_uint;
pub const DRAM_BIT_WIDTH_TYPE_e_DRAM_BIT_WIDTH_DISABLED: DRAM_BIT_WIDTH_TYPE_e = 0;
pub const DRAM_BIT_WIDTH_TYPE_e_DRAM_BIT_WIDTH_X_8: DRAM_BIT_WIDTH_TYPE_e = 8;
pub const DRAM_BIT_WIDTH_TYPE_e_DRAM_BIT_WIDTH_X_16: DRAM_BIT_WIDTH_TYPE_e = 16;
pub const DRAM_BIT_WIDTH_TYPE_e_DRAM_BIT_WIDTH_X_32: DRAM_BIT_WIDTH_TYPE_e = 32;
pub const DRAM_BIT_WIDTH_TYPE_e_DRAM_BIT_WIDTH_X_64: DRAM_BIT_WIDTH_TYPE_e = 64;
pub const DRAM_BIT_WIDTH_TYPE_e_DRAM_BIT_WIDTH_X_128: DRAM_BIT_WIDTH_TYPE_e = 128;
pub const DRAM_BIT_WIDTH_TYPE_e_DRAM_BIT_WIDTH_COUNT: DRAM_BIT_WIDTH_TYPE_e = 129;
pub type DRAM_BIT_WIDTH_TYPE_e = ::core::ffi::c_uint;
pub const I2cControllerPort_e_I2C_CONTROLLER_PORT_0: I2cControllerPort_e = 0;
pub const I2cControllerPort_e_I2C_CONTROLLER_PORT_1: I2cControllerPort_e = 1;
pub const I2cControllerPort_e_I2C_CONTROLLER_PORT_COUNT: I2cControllerPort_e = 2;
pub type I2cControllerPort_e = ::core::ffi::c_uint;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_VR_GFX: I2cControllerName_e = 0;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_VR_SOC: I2cControllerName_e = 1;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_VR_VMEMP: I2cControllerName_e = 2;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_VR_VDDIO: I2cControllerName_e = 3;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_LIQUID0: I2cControllerName_e = 4;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_LIQUID1: I2cControllerName_e = 5;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_PLX: I2cControllerName_e = 6;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_FAN_INTAKE: I2cControllerName_e = 7;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_COUNT: I2cControllerName_e = 8;
pub type I2cControllerName_e = ::core::ffi::c_uint;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_TYPE_NONE: I2cControllerThrottler_e = 0;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_VR_GFX: I2cControllerThrottler_e = 1;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_VR_SOC: I2cControllerThrottler_e = 2;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_VR_VMEMP: I2cControllerThrottler_e = 3;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_VR_VDDIO: I2cControllerThrottler_e = 4;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_LIQUID0: I2cControllerThrottler_e = 5;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_LIQUID1: I2cControllerThrottler_e = 6;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_PLX: I2cControllerThrottler_e = 7;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_FAN_INTAKE: I2cControllerThrottler_e =
    8;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_INA3221: I2cControllerThrottler_e = 9;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_COUNT: I2cControllerThrottler_e = 10;
pub type I2cControllerThrottler_e = ::core::ffi::c_uint;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_VR_XPDE132G5: I2cControllerProtocol_e = 0;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_VR_IR35217: I2cControllerProtocol_e = 1;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_TMP_MAX31875: I2cControllerProtocol_e = 2;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_INA3221: I2cControllerProtocol_e = 3;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_TMP_MAX6604: I2cControllerProtocol_e = 4;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_COUNT: I2cControllerProtocol_e = 5;
pub type I2cControllerProtocol_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct I2cControllerConfig_t {
    pub Enabled: u8,
    pub Speed: u8,
    pub SlaveAddress: u8,
    pub ControllerPort: u8,
    pub ControllerName: u8,
    pub ThermalThrotter: u8,
    pub I2cProtocol: u8,
    pub PaddingConfig: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of I2cControllerConfig_t"][::core::mem::size_of::<I2cControllerConfig_t>() - 8usize];
    ["Alignment of I2cControllerConfig_t"]
        [::core::mem::align_of::<I2cControllerConfig_t>() - 1usize];
    ["Offset of field: I2cControllerConfig_t::Enabled"]
        [::core::mem::offset_of!(I2cControllerConfig_t, Enabled) - 0usize];
    ["Offset of field: I2cControllerConfig_t::Speed"]
        [::core::mem::offset_of!(I2cControllerConfig_t, Speed) - 1usize];
    ["Offset of field: I2cControllerConfig_t::SlaveAddress"]
        [::core::mem::offset_of!(I2cControllerConfig_t, SlaveAddress) - 2usize];
    ["Offset of field: I2cControllerConfig_t::ControllerPort"]
        [::core::mem::offset_of!(I2cControllerConfig_t, ControllerPort) - 3usize];
    ["Offset of field: I2cControllerConfig_t::ControllerName"]
        [::core::mem::offset_of!(I2cControllerConfig_t, ControllerName) - 4usize];
    ["Offset of field: I2cControllerConfig_t::ThermalThrotter"]
        [::core::mem::offset_of!(I2cControllerConfig_t, ThermalThrotter) - 5usize];
    ["Offset of field: I2cControllerConfig_t::I2cProtocol"]
        [::core::mem::offset_of!(I2cControllerConfig_t, I2cProtocol) - 6usize];
    ["Offset of field: I2cControllerConfig_t::PaddingConfig"]
        [::core::mem::offset_of!(I2cControllerConfig_t, PaddingConfig) - 7usize];
};
pub const I2cPort_e_I2C_PORT_SVD_SCL: I2cPort_e = 0;
pub const I2cPort_e_I2C_PORT_GPIO: I2cPort_e = 1;
pub type I2cPort_e = ::core::ffi::c_uint;
pub const I2cSpeed_e_I2C_SPEED_FAST_50K: I2cSpeed_e = 0;
pub const I2cSpeed_e_I2C_SPEED_FAST_100K: I2cSpeed_e = 1;
pub const I2cSpeed_e_I2C_SPEED_FAST_400K: I2cSpeed_e = 2;
pub const I2cSpeed_e_I2C_SPEED_FAST_PLUS_1M: I2cSpeed_e = 3;
pub const I2cSpeed_e_I2C_SPEED_HIGH_1M: I2cSpeed_e = 4;
pub const I2cSpeed_e_I2C_SPEED_HIGH_2M: I2cSpeed_e = 5;
pub const I2cSpeed_e_I2C_SPEED_COUNT: I2cSpeed_e = 6;
pub type I2cSpeed_e = ::core::ffi::c_uint;
pub const I2cCmdType_e_I2C_CMD_READ: I2cCmdType_e = 0;
pub const I2cCmdType_e_I2C_CMD_WRITE: I2cCmdType_e = 1;
pub const I2cCmdType_e_I2C_CMD_COUNT: I2cCmdType_e = 2;
pub type I2cCmdType_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SwI2cCmd_t {
    pub ReadWriteData: u8,
    pub CmdConfig: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SwI2cCmd_t"][::core::mem::size_of::<SwI2cCmd_t>() - 2usize];
    ["Alignment of SwI2cCmd_t"][::core::mem::align_of::<SwI2cCmd_t>() - 1usize];
    ["Offset of field: SwI2cCmd_t::ReadWriteData"]
        [::core::mem::offset_of!(SwI2cCmd_t, ReadWriteData) - 0usize];
    ["Offset of field: SwI2cCmd_t::CmdConfig"]
        [::core::mem::offset_of!(SwI2cCmd_t, CmdConfig) - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SwI2cRequest_t {
    pub I2CcontrollerPort: u8,
    pub I2CSpeed: u8,
    pub SlaveAddress: u8,
    pub NumCmds: u8,
    pub SwI2cCmds: [SwI2cCmd_t; 24usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SwI2cRequest_t"][::core::mem::size_of::<SwI2cRequest_t>() - 52usize];
    ["Alignment of SwI2cRequest_t"][::core::mem::align_of::<SwI2cRequest_t>() - 1usize];
    ["Offset of field: SwI2cRequest_t::I2CcontrollerPort"]
        [::core::mem::offset_of!(SwI2cRequest_t, I2CcontrollerPort) - 0usize];
    ["Offset of field: SwI2cRequest_t::I2CSpeed"]
        [::core::mem::offset_of!(SwI2cRequest_t, I2CSpeed) - 1usize];
    ["Offset of field: SwI2cRequest_t::SlaveAddress"]
        [::core::mem::offset_of!(SwI2cRequest_t, SlaveAddress) - 2usize];
    ["Offset of field: SwI2cRequest_t::NumCmds"]
        [::core::mem::offset_of!(SwI2cRequest_t, NumCmds) - 3usize];
    ["Offset of field: SwI2cRequest_t::SwI2cCmds"]
        [::core::mem::offset_of!(SwI2cRequest_t, SwI2cCmds) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SwI2cRequestExternal_t {
    pub SwI2cRequest: SwI2cRequest_t,
    pub Spare: [u32; 8usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SwI2cRequestExternal_t"][::core::mem::size_of::<SwI2cRequestExternal_t>() - 116usize];
    ["Alignment of SwI2cRequestExternal_t"]
        [::core::mem::align_of::<SwI2cRequestExternal_t>() - 4usize];
    ["Offset of field: SwI2cRequestExternal_t::SwI2cRequest"]
        [::core::mem::offset_of!(SwI2cRequestExternal_t, SwI2cRequest) - 0usize];
    ["Offset of field: SwI2cRequestExternal_t::Spare"]
        [::core::mem::offset_of!(SwI2cRequestExternal_t, Spare) - 52usize];
    ["Offset of field: SwI2cRequestExternal_t::MmHubPadding"]
        [::core::mem::offset_of!(SwI2cRequestExternal_t, MmHubPadding) - 84usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EccInfo_t {
    pub mca_umc_status: u64,
    pub mca_umc_addr: u64,
    pub ce_count_lo_chip: u16,
    pub ce_count_hi_chip: u16,
    pub eccPadding: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of EccInfo_t"][::core::mem::size_of::<EccInfo_t>() - 24usize];
    ["Alignment of EccInfo_t"][::core::mem::align_of::<EccInfo_t>() - 8usize];
    ["Offset of field: EccInfo_t::mca_umc_status"]
        [::core::mem::offset_of!(EccInfo_t, mca_umc_status) - 0usize];
    ["Offset of field: EccInfo_t::mca_umc_addr"]
        [::core::mem::offset_of!(EccInfo_t, mca_umc_addr) - 8usize];
    ["Offset of field: EccInfo_t::ce_count_lo_chip"]
        [::core::mem::offset_of!(EccInfo_t, ce_count_lo_chip) - 16usize];
    ["Offset of field: EccInfo_t::ce_count_hi_chip"]
        [::core::mem::offset_of!(EccInfo_t, ce_count_hi_chip) - 18usize];
    ["Offset of field: EccInfo_t::eccPadding"]
        [::core::mem::offset_of!(EccInfo_t, eccPadding) - 20usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EccInfoTable_t {
    pub EccInfo: [EccInfo_t; 24usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of EccInfoTable_t"][::core::mem::size_of::<EccInfoTable_t>() - 576usize];
    ["Alignment of EccInfoTable_t"][::core::mem::align_of::<EccInfoTable_t>() - 8usize];
    ["Offset of field: EccInfoTable_t::EccInfo"]
        [::core::mem::offset_of!(EccInfoTable_t, EccInfo) - 0usize];
};
pub const D3HOTSequence_e_BACO_SEQUENCE: D3HOTSequence_e = 0;
pub const D3HOTSequence_e_MSR_SEQUENCE: D3HOTSequence_e = 1;
pub const D3HOTSequence_e_BAMACO_SEQUENCE: D3HOTSequence_e = 2;
pub const D3HOTSequence_e_ULPS_SEQUENCE: D3HOTSequence_e = 3;
pub const D3HOTSequence_e_D3HOT_SEQUENCE_COUNT: D3HOTSequence_e = 4;
pub type D3HOTSequence_e = ::core::ffi::c_uint;
pub const PowerGatingMode_e_PG_DYNAMIC_MODE: PowerGatingMode_e = 0;
pub const PowerGatingMode_e_PG_STATIC_MODE: PowerGatingMode_e = 1;
pub type PowerGatingMode_e = ::core::ffi::c_uint;
pub const PowerGatingSettings_e_PG_POWER_DOWN: PowerGatingSettings_e = 0;
pub const PowerGatingSettings_e_PG_POWER_UP: PowerGatingSettings_e = 1;
pub type PowerGatingSettings_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QuadraticInt_t {
    pub a: u32,
    pub b: u32,
    pub c: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of QuadraticInt_t"][::core::mem::size_of::<QuadraticInt_t>() - 12usize];
    ["Alignment of QuadraticInt_t"][::core::mem::align_of::<QuadraticInt_t>() - 4usize];
    ["Offset of field: QuadraticInt_t::a"][::core::mem::offset_of!(QuadraticInt_t, a) - 0usize];
    ["Offset of field: QuadraticInt_t::b"][::core::mem::offset_of!(QuadraticInt_t, b) - 4usize];
    ["Offset of field: QuadraticInt_t::c"][::core::mem::offset_of!(QuadraticInt_t, c) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LinearInt_t {
    pub m: u32,
    pub b: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of LinearInt_t"][::core::mem::size_of::<LinearInt_t>() - 8usize];
    ["Alignment of LinearInt_t"][::core::mem::align_of::<LinearInt_t>() - 4usize];
    ["Offset of field: LinearInt_t::m"][::core::mem::offset_of!(LinearInt_t, m) - 0usize];
    ["Offset of field: LinearInt_t::b"][::core::mem::offset_of!(LinearInt_t, b) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DroopInt_t {
    pub a: u32,
    pub b: u32,
    pub c: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DroopInt_t"][::core::mem::size_of::<DroopInt_t>() - 12usize];
    ["Alignment of DroopInt_t"][::core::mem::align_of::<DroopInt_t>() - 4usize];
    ["Offset of field: DroopInt_t::a"][::core::mem::offset_of!(DroopInt_t, a) - 0usize];
    ["Offset of field: DroopInt_t::b"][::core::mem::offset_of!(DroopInt_t, b) - 4usize];
    ["Offset of field: DroopInt_t::c"][::core::mem::offset_of!(DroopInt_t, c) - 8usize];
};
pub const DCS_ARCH_e_DCS_ARCH_DISABLED: DCS_ARCH_e = 0;
pub const DCS_ARCH_e_DCS_ARCH_FADCS: DCS_ARCH_e = 1;
pub const DCS_ARCH_e_DCS_ARCH_ASYNC: DCS_ARCH_e = 2;
pub type DCS_ARCH_e = ::core::ffi::c_uint;
pub const PPCLK_e_PPCLK_GFXCLK: PPCLK_e = 0;
pub const PPCLK_e_PPCLK_SOCCLK: PPCLK_e = 1;
pub const PPCLK_e_PPCLK_UCLK: PPCLK_e = 2;
pub const PPCLK_e_PPCLK_FCLK: PPCLK_e = 3;
pub const PPCLK_e_PPCLK_DCLK_0: PPCLK_e = 4;
pub const PPCLK_e_PPCLK_VCLK_0: PPCLK_e = 5;
pub const PPCLK_e_PPCLK_DCLK_1: PPCLK_e = 6;
pub const PPCLK_e_PPCLK_VCLK_1: PPCLK_e = 7;
pub const PPCLK_e_PPCLK_DISPCLK: PPCLK_e = 8;
pub const PPCLK_e_PPCLK_DPPCLK: PPCLK_e = 9;
pub const PPCLK_e_PPCLK_DPREFCLK: PPCLK_e = 10;
pub const PPCLK_e_PPCLK_DCFCLK: PPCLK_e = 11;
pub const PPCLK_e_PPCLK_DTBCLK: PPCLK_e = 12;
pub const PPCLK_e_PPCLK_COUNT: PPCLK_e = 13;
pub type PPCLK_e = ::core::ffi::c_uint;
pub const VOLTAGE_MODE_e_VOLTAGE_MODE_PPTABLE: VOLTAGE_MODE_e = 0;
pub const VOLTAGE_MODE_e_VOLTAGE_MODE_FUSES: VOLTAGE_MODE_e = 1;
pub const VOLTAGE_MODE_e_VOLTAGE_MODE_COUNT: VOLTAGE_MODE_e = 2;
pub type VOLTAGE_MODE_e = ::core::ffi::c_uint;
pub const AVFS_VOLTAGE_TYPE_e_AVFS_VOLTAGE_GFX: AVFS_VOLTAGE_TYPE_e = 0;
pub const AVFS_VOLTAGE_TYPE_e_AVFS_VOLTAGE_SOC: AVFS_VOLTAGE_TYPE_e = 1;
pub const AVFS_VOLTAGE_TYPE_e_AVFS_VOLTAGE_COUNT: AVFS_VOLTAGE_TYPE_e = 2;
pub type AVFS_VOLTAGE_TYPE_e = ::core::ffi::c_uint;
pub const AVFS_TEMP_e_AVFS_TEMP_COLD: AVFS_TEMP_e = 0;
pub const AVFS_TEMP_e_AVFS_TEMP_HOT: AVFS_TEMP_e = 1;
pub const AVFS_TEMP_e_AVFS_TEMP_COUNT: AVFS_TEMP_e = 2;
pub type AVFS_TEMP_e = ::core::ffi::c_uint;
pub const AVFS_D_e_AVFS_D_G: AVFS_D_e = 0;
pub const AVFS_D_e_AVFS_D_M_B: AVFS_D_e = 1;
pub const AVFS_D_e_AVFS_D_M_S: AVFS_D_e = 2;
pub const AVFS_D_e_AVFS_D_COUNT: AVFS_D_e = 3;
pub type AVFS_D_e = ::core::ffi::c_uint;
pub const UCLK_DIV_e_UCLK_DIV_BY_1: UCLK_DIV_e = 0;
pub const UCLK_DIV_e_UCLK_DIV_BY_2: UCLK_DIV_e = 1;
pub const UCLK_DIV_e_UCLK_DIV_BY_4: UCLK_DIV_e = 2;
pub const UCLK_DIV_e_UCLK_DIV_BY_8: UCLK_DIV_e = 3;
pub type UCLK_DIV_e = ::core::ffi::c_uint;
pub const GpioIntPolarity_e_GPIO_INT_POLARITY_ACTIVE_LOW: GpioIntPolarity_e = 0;
pub const GpioIntPolarity_e_GPIO_INT_POLARITY_ACTIVE_HIGH: GpioIntPolarity_e = 1;
pub type GpioIntPolarity_e = ::core::ffi::c_uint;
pub const PwrConfig_e_PWR_CONFIG_TDP: PwrConfig_e = 0;
pub const PwrConfig_e_PWR_CONFIG_TGP: PwrConfig_e = 1;
pub const PwrConfig_e_PWR_CONFIG_TCP_ESTIMATED: PwrConfig_e = 2;
pub const PwrConfig_e_PWR_CONFIG_TCP_MEASURED: PwrConfig_e = 3;
pub type PwrConfig_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DpmDescriptor_t {
    pub Padding: u8,
    pub SnapToDiscrete: u8,
    pub NumDiscreteLevels: u8,
    pub CalculateFopt: u8,
    pub ConversionToAvfsClk: LinearInt_t,
    pub Padding3: [u32; 3usize],
    pub Padding4: u16,
    pub FoptimalDc: u16,
    pub FoptimalAc: u16,
    pub Padding2: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DpmDescriptor_t"][::core::mem::size_of::<DpmDescriptor_t>() - 32usize];
    ["Alignment of DpmDescriptor_t"][::core::mem::align_of::<DpmDescriptor_t>() - 4usize];
    ["Offset of field: DpmDescriptor_t::Padding"]
        [::core::mem::offset_of!(DpmDescriptor_t, Padding) - 0usize];
    ["Offset of field: DpmDescriptor_t::SnapToDiscrete"]
        [::core::mem::offset_of!(DpmDescriptor_t, SnapToDiscrete) - 1usize];
    ["Offset of field: DpmDescriptor_t::NumDiscreteLevels"]
        [::core::mem::offset_of!(DpmDescriptor_t, NumDiscreteLevels) - 2usize];
    ["Offset of field: DpmDescriptor_t::CalculateFopt"]
        [::core::mem::offset_of!(DpmDescriptor_t, CalculateFopt) - 3usize];
    ["Offset of field: DpmDescriptor_t::ConversionToAvfsClk"]
        [::core::mem::offset_of!(DpmDescriptor_t, ConversionToAvfsClk) - 4usize];
    ["Offset of field: DpmDescriptor_t::Padding3"]
        [::core::mem::offset_of!(DpmDescriptor_t, Padding3) - 12usize];
    ["Offset of field: DpmDescriptor_t::Padding4"]
        [::core::mem::offset_of!(DpmDescriptor_t, Padding4) - 24usize];
    ["Offset of field: DpmDescriptor_t::FoptimalDc"]
        [::core::mem::offset_of!(DpmDescriptor_t, FoptimalDc) - 26usize];
    ["Offset of field: DpmDescriptor_t::FoptimalAc"]
        [::core::mem::offset_of!(DpmDescriptor_t, FoptimalAc) - 28usize];
    ["Offset of field: DpmDescriptor_t::Padding2"]
        [::core::mem::offset_of!(DpmDescriptor_t, Padding2) - 30usize];
};
pub const PPT_THROTTLER_e_PPT_THROTTLER_PPT0: PPT_THROTTLER_e = 0;
pub const PPT_THROTTLER_e_PPT_THROTTLER_PPT1: PPT_THROTTLER_e = 1;
pub const PPT_THROTTLER_e_PPT_THROTTLER_PPT2: PPT_THROTTLER_e = 2;
pub const PPT_THROTTLER_e_PPT_THROTTLER_PPT3: PPT_THROTTLER_e = 3;
pub const PPT_THROTTLER_e_PPT_THROTTLER_COUNT: PPT_THROTTLER_e = 4;
pub type PPT_THROTTLER_e = ::core::ffi::c_uint;
pub const TEMP_e_TEMP_EDGE: TEMP_e = 0;
pub const TEMP_e_TEMP_HOTSPOT: TEMP_e = 1;
pub const TEMP_e_TEMP_HOTSPOT_G: TEMP_e = 2;
pub const TEMP_e_TEMP_HOTSPOT_M: TEMP_e = 3;
pub const TEMP_e_TEMP_MEM: TEMP_e = 4;
pub const TEMP_e_TEMP_VR_GFX: TEMP_e = 5;
pub const TEMP_e_TEMP_VR_MEM0: TEMP_e = 6;
pub const TEMP_e_TEMP_VR_MEM1: TEMP_e = 7;
pub const TEMP_e_TEMP_VR_SOC: TEMP_e = 8;
pub const TEMP_e_TEMP_VR_U: TEMP_e = 9;
pub const TEMP_e_TEMP_LIQUID0: TEMP_e = 10;
pub const TEMP_e_TEMP_LIQUID1: TEMP_e = 11;
pub const TEMP_e_TEMP_PLX: TEMP_e = 12;
pub const TEMP_e_TEMP_COUNT: TEMP_e = 13;
pub type TEMP_e = ::core::ffi::c_uint;
pub const TDC_THROTTLER_e_TDC_THROTTLER_GFX: TDC_THROTTLER_e = 0;
pub const TDC_THROTTLER_e_TDC_THROTTLER_SOC: TDC_THROTTLER_e = 1;
pub const TDC_THROTTLER_e_TDC_THROTTLER_U: TDC_THROTTLER_e = 2;
pub const TDC_THROTTLER_e_TDC_THROTTLER_COUNT: TDC_THROTTLER_e = 3;
pub type TDC_THROTTLER_e = ::core::ffi::c_uint;
pub const SVI_PLANE_e_SVI_PLANE_GFX: SVI_PLANE_e = 0;
pub const SVI_PLANE_e_SVI_PLANE_SOC: SVI_PLANE_e = 1;
pub const SVI_PLANE_e_SVI_PLANE_VMEMP: SVI_PLANE_e = 2;
pub const SVI_PLANE_e_SVI_PLANE_VDDIO_MEM: SVI_PLANE_e = 3;
pub const SVI_PLANE_e_SVI_PLANE_U: SVI_PLANE_e = 4;
pub const SVI_PLANE_e_SVI_PLANE_COUNT: SVI_PLANE_e = 5;
pub type SVI_PLANE_e = ::core::ffi::c_uint;
pub const PMFW_VOLT_PLANE_e_PMFW_VOLT_PLANE_GFX: PMFW_VOLT_PLANE_e = 0;
pub const PMFW_VOLT_PLANE_e_PMFW_VOLT_PLANE_SOC: PMFW_VOLT_PLANE_e = 1;
pub const PMFW_VOLT_PLANE_e_PMFW_VOLT_PLANE_COUNT: PMFW_VOLT_PLANE_e = 2;
pub type PMFW_VOLT_PLANE_e = ::core::ffi::c_uint;
pub const CUSTOMER_VARIANT_e_CUSTOMER_VARIANT_ROW: CUSTOMER_VARIANT_e = 0;
pub const CUSTOMER_VARIANT_e_CUSTOMER_VARIANT_FALCON: CUSTOMER_VARIANT_e = 1;
pub const CUSTOMER_VARIANT_e_CUSTOMER_VARIANT_COUNT: CUSTOMER_VARIANT_e = 2;
pub type CUSTOMER_VARIANT_e = ::core::ffi::c_uint;
pub const POWER_SOURCE_e_POWER_SOURCE_AC: POWER_SOURCE_e = 0;
pub const POWER_SOURCE_e_POWER_SOURCE_DC: POWER_SOURCE_e = 1;
pub const POWER_SOURCE_e_POWER_SOURCE_COUNT: POWER_SOURCE_e = 2;
pub type POWER_SOURCE_e = ::core::ffi::c_uint;
pub const MEM_VENDOR_e_MEM_VENDOR_PLACEHOLDER0: MEM_VENDOR_e = 0;
pub const MEM_VENDOR_e_MEM_VENDOR_SAMSUNG: MEM_VENDOR_e = 1;
pub const MEM_VENDOR_e_MEM_VENDOR_INFINEON: MEM_VENDOR_e = 2;
pub const MEM_VENDOR_e_MEM_VENDOR_ELPIDA: MEM_VENDOR_e = 3;
pub const MEM_VENDOR_e_MEM_VENDOR_ETRON: MEM_VENDOR_e = 4;
pub const MEM_VENDOR_e_MEM_VENDOR_NANYA: MEM_VENDOR_e = 5;
pub const MEM_VENDOR_e_MEM_VENDOR_HYNIX: MEM_VENDOR_e = 6;
pub const MEM_VENDOR_e_MEM_VENDOR_MOSEL: MEM_VENDOR_e = 7;
pub const MEM_VENDOR_e_MEM_VENDOR_WINBOND: MEM_VENDOR_e = 8;
pub const MEM_VENDOR_e_MEM_VENDOR_ESMT: MEM_VENDOR_e = 9;
pub const MEM_VENDOR_e_MEM_VENDOR_PLACEHOLDER1: MEM_VENDOR_e = 10;
pub const MEM_VENDOR_e_MEM_VENDOR_PLACEHOLDER2: MEM_VENDOR_e = 11;
pub const MEM_VENDOR_e_MEM_VENDOR_PLACEHOLDER3: MEM_VENDOR_e = 12;
pub const MEM_VENDOR_e_MEM_VENDOR_PLACEHOLDER4: MEM_VENDOR_e = 13;
pub const MEM_VENDOR_e_MEM_VENDOR_PLACEHOLDER5: MEM_VENDOR_e = 14;
pub const MEM_VENDOR_e_MEM_VENDOR_MICRON: MEM_VENDOR_e = 15;
pub const MEM_VENDOR_e_MEM_VENDOR_COUNT: MEM_VENDOR_e = 16;
pub type MEM_VENDOR_e = ::core::ffi::c_uint;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_CTL_ZONE0: PP_GRTAVFS_HW_FUSE_e = 0;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_CTL_ZONE1: PP_GRTAVFS_HW_FUSE_e = 1;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_CTL_ZONE2: PP_GRTAVFS_HW_FUSE_e = 2;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_CTL_ZONE3: PP_GRTAVFS_HW_FUSE_e = 3;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_CTL_ZONE4: PP_GRTAVFS_HW_FUSE_e = 4;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_EN_0_31_ZONE0: PP_GRTAVFS_HW_FUSE_e = 5;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_EN_32_63_ZONE0: PP_GRTAVFS_HW_FUSE_e = 6;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_EN_0_31_ZONE1: PP_GRTAVFS_HW_FUSE_e = 7;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_EN_32_63_ZONE1: PP_GRTAVFS_HW_FUSE_e = 8;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_EN_0_31_ZONE2: PP_GRTAVFS_HW_FUSE_e = 9;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_EN_32_63_ZONE2: PP_GRTAVFS_HW_FUSE_e = 10;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_EN_0_31_ZONE3: PP_GRTAVFS_HW_FUSE_e = 11;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_EN_32_63_ZONE3: PP_GRTAVFS_HW_FUSE_e = 12;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_EN_0_31_ZONE4: PP_GRTAVFS_HW_FUSE_e = 13;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPO_EN_32_63_ZONE4: PP_GRTAVFS_HW_FUSE_e = 14;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_ZONE0_VF: PP_GRTAVFS_HW_FUSE_e = 15;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_ZONE1_VF1: PP_GRTAVFS_HW_FUSE_e = 16;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_ZONE2_VF2: PP_GRTAVFS_HW_FUSE_e = 17;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_ZONE3_VF3: PP_GRTAVFS_HW_FUSE_e = 18;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_VOLTAGE_GB: PP_GRTAVFS_HW_FUSE_e = 19;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPOSCALINGCTRL_ZONE0: PP_GRTAVFS_HW_FUSE_e = 20;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPOSCALINGCTRL_ZONE1: PP_GRTAVFS_HW_FUSE_e = 21;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPOSCALINGCTRL_ZONE2: PP_GRTAVFS_HW_FUSE_e = 22;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPOSCALINGCTRL_ZONE3: PP_GRTAVFS_HW_FUSE_e = 23;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_CPOSCALINGCTRL_ZONE4: PP_GRTAVFS_HW_FUSE_e = 24;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_RESERVED_0: PP_GRTAVFS_HW_FUSE_e = 25;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_RESERVED_1: PP_GRTAVFS_HW_FUSE_e = 26;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_RESERVED_2: PP_GRTAVFS_HW_FUSE_e = 27;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_RESERVED_3: PP_GRTAVFS_HW_FUSE_e = 28;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_RESERVED_4: PP_GRTAVFS_HW_FUSE_e = 29;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_RESERVED_5: PP_GRTAVFS_HW_FUSE_e = 30;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_RESERVED_6: PP_GRTAVFS_HW_FUSE_e = 31;
pub const PP_GRTAVFS_HW_FUSE_e_PP_GRTAVFS_HW_FUSE_COUNT: PP_GRTAVFS_HW_FUSE_e = 32;
pub type PP_GRTAVFS_HW_FUSE_e = ::core::ffi::c_uint;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_PPVMIN_Z1_HOT_T0:
    PP_GRTAVFS_FW_COMMON_FUSE_e = 0;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_PPVMIN_Z1_COLD_T0:
    PP_GRTAVFS_FW_COMMON_FUSE_e = 1;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_PPVMIN_Z2_HOT_T0:
    PP_GRTAVFS_FW_COMMON_FUSE_e = 2;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_PPVMIN_Z2_COLD_T0:
    PP_GRTAVFS_FW_COMMON_FUSE_e = 3;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_PPVMIN_Z3_HOT_T0:
    PP_GRTAVFS_FW_COMMON_FUSE_e = 4;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_PPVMIN_Z3_COLD_T0:
    PP_GRTAVFS_FW_COMMON_FUSE_e = 5;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_PPVMIN_Z4_HOT_T0:
    PP_GRTAVFS_FW_COMMON_FUSE_e = 6;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_PPVMIN_Z4_COLD_T0:
    PP_GRTAVFS_FW_COMMON_FUSE_e = 7;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_SRAM_RM_Z0: PP_GRTAVFS_FW_COMMON_FUSE_e =
    8;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_SRAM_RM_Z1: PP_GRTAVFS_FW_COMMON_FUSE_e =
    9;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_SRAM_RM_Z2: PP_GRTAVFS_FW_COMMON_FUSE_e =
    10;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_SRAM_RM_Z3: PP_GRTAVFS_FW_COMMON_FUSE_e =
    11;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_SRAM_RM_Z4: PP_GRTAVFS_FW_COMMON_FUSE_e =
    12;
pub const PP_GRTAVFS_FW_COMMON_FUSE_e_PP_GRTAVFS_FW_COMMON_FUSE_COUNT: PP_GRTAVFS_FW_COMMON_FUSE_e =
    13;
pub type PP_GRTAVFS_FW_COMMON_FUSE_e = ::core::ffi::c_uint;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_GB1_PWL_VOLTAGE_NEG_1:
    PP_GRTAVFS_FW_SEP_FUSE_e = 0;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_GB1_PWL_VOLTAGE_0:
    PP_GRTAVFS_FW_SEP_FUSE_e = 1;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_GB1_PWL_VOLTAGE_1:
    PP_GRTAVFS_FW_SEP_FUSE_e = 2;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_GB1_PWL_VOLTAGE_2:
    PP_GRTAVFS_FW_SEP_FUSE_e = 3;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_GB1_PWL_VOLTAGE_3:
    PP_GRTAVFS_FW_SEP_FUSE_e = 4;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_GB1_PWL_VOLTAGE_4:
    PP_GRTAVFS_FW_SEP_FUSE_e = 5;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_GB2_PWL_VOLTAGE_NEG_1:
    PP_GRTAVFS_FW_SEP_FUSE_e = 6;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_GB2_PWL_VOLTAGE_0:
    PP_GRTAVFS_FW_SEP_FUSE_e = 7;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_GB2_PWL_VOLTAGE_1:
    PP_GRTAVFS_FW_SEP_FUSE_e = 8;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_GB2_PWL_VOLTAGE_2:
    PP_GRTAVFS_FW_SEP_FUSE_e = 9;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_GB2_PWL_VOLTAGE_3:
    PP_GRTAVFS_FW_SEP_FUSE_e = 10;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_GB2_PWL_VOLTAGE_4:
    PP_GRTAVFS_FW_SEP_FUSE_e = 11;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_VF_NEG_1_FREQUENCY:
    PP_GRTAVFS_FW_SEP_FUSE_e = 12;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_VF4_FREQUENCY: PP_GRTAVFS_FW_SEP_FUSE_e =
    13;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_FREQUENCY_TO_COUNT_SCALER_0:
    PP_GRTAVFS_FW_SEP_FUSE_e = 14;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_FREQUENCY_TO_COUNT_SCALER_1:
    PP_GRTAVFS_FW_SEP_FUSE_e = 15;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_FREQUENCY_TO_COUNT_SCALER_2:
    PP_GRTAVFS_FW_SEP_FUSE_e = 16;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_FREQUENCY_TO_COUNT_SCALER_3:
    PP_GRTAVFS_FW_SEP_FUSE_e = 17;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_FREQUENCY_TO_COUNT_SCALER_4:
    PP_GRTAVFS_FW_SEP_FUSE_e = 18;
pub const PP_GRTAVFS_FW_SEP_FUSE_e_PP_GRTAVFS_FW_SEP_FUSE_COUNT: PP_GRTAVFS_FW_SEP_FUSE_e = 19;
pub type PP_GRTAVFS_FW_SEP_FUSE_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SviTelemetryScale_t {
    pub Offset: i8,
    pub Padding: u8,
    pub MaxCurrent: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SviTelemetryScale_t"][::core::mem::size_of::<SviTelemetryScale_t>() - 4usize];
    ["Alignment of SviTelemetryScale_t"][::core::mem::align_of::<SviTelemetryScale_t>() - 2usize];
    ["Offset of field: SviTelemetryScale_t::Offset"]
        [::core::mem::offset_of!(SviTelemetryScale_t, Offset) - 0usize];
    ["Offset of field: SviTelemetryScale_t::Padding"]
        [::core::mem::offset_of!(SviTelemetryScale_t, Padding) - 1usize];
    ["Offset of field: SviTelemetryScale_t::MaxCurrent"]
        [::core::mem::offset_of!(SviTelemetryScale_t, MaxCurrent) - 2usize];
};
pub const FanMode_e_FAN_MODE_AUTO: FanMode_e = 0;
pub const FanMode_e_FAN_MODE_MANUAL_LINEAR: FanMode_e = 1;
pub type FanMode_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OverDriveTable_t {
    pub FeatureCtrlMask: u32,
    pub VoltageOffsetPerZoneBoundary: [i16; 6usize],
    pub Reserved: u32,
    pub GfxclkFmin: i16,
    pub GfxclkFmax: i16,
    pub UclkFmin: u16,
    pub UclkFmax: u16,
    pub Ppt: i16,
    pub Tdc: i16,
    pub FanLinearPwmPoints: [u8; 6usize],
    pub FanLinearTempPoints: [u8; 6usize],
    pub FanMinimumPwm: u16,
    pub AcousticTargetRpmThreshold: u16,
    pub AcousticLimitRpmThreshold: u16,
    pub FanTargetTemperature: u16,
    pub FanZeroRpmEnable: u8,
    pub FanZeroRpmStopTemp: u8,
    pub FanMode: u8,
    pub MaxOpTemp: u8,
    pub Spare: [u32; 13usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of OverDriveTable_t"][::core::mem::size_of::<OverDriveTable_t>() - 140usize];
    ["Alignment of OverDriveTable_t"][::core::mem::align_of::<OverDriveTable_t>() - 4usize];
    ["Offset of field: OverDriveTable_t::FeatureCtrlMask"]
        [::core::mem::offset_of!(OverDriveTable_t, FeatureCtrlMask) - 0usize];
    ["Offset of field: OverDriveTable_t::VoltageOffsetPerZoneBoundary"]
        [::core::mem::offset_of!(OverDriveTable_t, VoltageOffsetPerZoneBoundary) - 4usize];
    ["Offset of field: OverDriveTable_t::Reserved"]
        [::core::mem::offset_of!(OverDriveTable_t, Reserved) - 16usize];
    ["Offset of field: OverDriveTable_t::GfxclkFmin"]
        [::core::mem::offset_of!(OverDriveTable_t, GfxclkFmin) - 20usize];
    ["Offset of field: OverDriveTable_t::GfxclkFmax"]
        [::core::mem::offset_of!(OverDriveTable_t, GfxclkFmax) - 22usize];
    ["Offset of field: OverDriveTable_t::UclkFmin"]
        [::core::mem::offset_of!(OverDriveTable_t, UclkFmin) - 24usize];
    ["Offset of field: OverDriveTable_t::UclkFmax"]
        [::core::mem::offset_of!(OverDriveTable_t, UclkFmax) - 26usize];
    ["Offset of field: OverDriveTable_t::Ppt"]
        [::core::mem::offset_of!(OverDriveTable_t, Ppt) - 28usize];
    ["Offset of field: OverDriveTable_t::Tdc"]
        [::core::mem::offset_of!(OverDriveTable_t, Tdc) - 30usize];
    ["Offset of field: OverDriveTable_t::FanLinearPwmPoints"]
        [::core::mem::offset_of!(OverDriveTable_t, FanLinearPwmPoints) - 32usize];
    ["Offset of field: OverDriveTable_t::FanLinearTempPoints"]
        [::core::mem::offset_of!(OverDriveTable_t, FanLinearTempPoints) - 38usize];
    ["Offset of field: OverDriveTable_t::FanMinimumPwm"]
        [::core::mem::offset_of!(OverDriveTable_t, FanMinimumPwm) - 44usize];
    ["Offset of field: OverDriveTable_t::AcousticTargetRpmThreshold"]
        [::core::mem::offset_of!(OverDriveTable_t, AcousticTargetRpmThreshold) - 46usize];
    ["Offset of field: OverDriveTable_t::AcousticLimitRpmThreshold"]
        [::core::mem::offset_of!(OverDriveTable_t, AcousticLimitRpmThreshold) - 48usize];
    ["Offset of field: OverDriveTable_t::FanTargetTemperature"]
        [::core::mem::offset_of!(OverDriveTable_t, FanTargetTemperature) - 50usize];
    ["Offset of field: OverDriveTable_t::FanZeroRpmEnable"]
        [::core::mem::offset_of!(OverDriveTable_t, FanZeroRpmEnable) - 52usize];
    ["Offset of field: OverDriveTable_t::FanZeroRpmStopTemp"]
        [::core::mem::offset_of!(OverDriveTable_t, FanZeroRpmStopTemp) - 53usize];
    ["Offset of field: OverDriveTable_t::FanMode"]
        [::core::mem::offset_of!(OverDriveTable_t, FanMode) - 54usize];
    ["Offset of field: OverDriveTable_t::MaxOpTemp"]
        [::core::mem::offset_of!(OverDriveTable_t, MaxOpTemp) - 55usize];
    ["Offset of field: OverDriveTable_t::Spare"]
        [::core::mem::offset_of!(OverDriveTable_t, Spare) - 56usize];
    ["Offset of field: OverDriveTable_t::MmHubPadding"]
        [::core::mem::offset_of!(OverDriveTable_t, MmHubPadding) - 108usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OverDriveTableExternal_t {
    pub OverDriveTable: OverDriveTable_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of OverDriveTableExternal_t"]
        [::core::mem::size_of::<OverDriveTableExternal_t>() - 140usize];
    ["Alignment of OverDriveTableExternal_t"]
        [::core::mem::align_of::<OverDriveTableExternal_t>() - 4usize];
    ["Offset of field: OverDriveTableExternal_t::OverDriveTable"]
        [::core::mem::offset_of!(OverDriveTableExternal_t, OverDriveTable) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OverDriveLimits_t {
    pub FeatureCtrlMask: u32,
    pub VoltageOffsetPerZoneBoundary: i16,
    pub Reserved1: u16,
    pub Reserved2: u16,
    pub GfxclkFmin: i16,
    pub GfxclkFmax: i16,
    pub UclkFmin: u16,
    pub UclkFmax: u16,
    pub Ppt: i16,
    pub Tdc: i16,
    pub FanLinearPwmPoints: u8,
    pub FanLinearTempPoints: u8,
    pub FanMinimumPwm: u16,
    pub AcousticTargetRpmThreshold: u16,
    pub AcousticLimitRpmThreshold: u16,
    pub FanTargetTemperature: u16,
    pub FanZeroRpmEnable: u8,
    pub FanZeroRpmStopTemp: u8,
    pub FanMode: u8,
    pub MaxOpTemp: u8,
    pub Spare: [u32; 13usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of OverDriveLimits_t"][::core::mem::size_of::<OverDriveLimits_t>() - 88usize];
    ["Alignment of OverDriveLimits_t"][::core::mem::align_of::<OverDriveLimits_t>() - 4usize];
    ["Offset of field: OverDriveLimits_t::FeatureCtrlMask"]
        [::core::mem::offset_of!(OverDriveLimits_t, FeatureCtrlMask) - 0usize];
    ["Offset of field: OverDriveLimits_t::VoltageOffsetPerZoneBoundary"]
        [::core::mem::offset_of!(OverDriveLimits_t, VoltageOffsetPerZoneBoundary) - 4usize];
    ["Offset of field: OverDriveLimits_t::Reserved1"]
        [::core::mem::offset_of!(OverDriveLimits_t, Reserved1) - 6usize];
    ["Offset of field: OverDriveLimits_t::Reserved2"]
        [::core::mem::offset_of!(OverDriveLimits_t, Reserved2) - 8usize];
    ["Offset of field: OverDriveLimits_t::GfxclkFmin"]
        [::core::mem::offset_of!(OverDriveLimits_t, GfxclkFmin) - 10usize];
    ["Offset of field: OverDriveLimits_t::GfxclkFmax"]
        [::core::mem::offset_of!(OverDriveLimits_t, GfxclkFmax) - 12usize];
    ["Offset of field: OverDriveLimits_t::UclkFmin"]
        [::core::mem::offset_of!(OverDriveLimits_t, UclkFmin) - 14usize];
    ["Offset of field: OverDriveLimits_t::UclkFmax"]
        [::core::mem::offset_of!(OverDriveLimits_t, UclkFmax) - 16usize];
    ["Offset of field: OverDriveLimits_t::Ppt"]
        [::core::mem::offset_of!(OverDriveLimits_t, Ppt) - 18usize];
    ["Offset of field: OverDriveLimits_t::Tdc"]
        [::core::mem::offset_of!(OverDriveLimits_t, Tdc) - 20usize];
    ["Offset of field: OverDriveLimits_t::FanLinearPwmPoints"]
        [::core::mem::offset_of!(OverDriveLimits_t, FanLinearPwmPoints) - 22usize];
    ["Offset of field: OverDriveLimits_t::FanLinearTempPoints"]
        [::core::mem::offset_of!(OverDriveLimits_t, FanLinearTempPoints) - 23usize];
    ["Offset of field: OverDriveLimits_t::FanMinimumPwm"]
        [::core::mem::offset_of!(OverDriveLimits_t, FanMinimumPwm) - 24usize];
    ["Offset of field: OverDriveLimits_t::AcousticTargetRpmThreshold"]
        [::core::mem::offset_of!(OverDriveLimits_t, AcousticTargetRpmThreshold) - 26usize];
    ["Offset of field: OverDriveLimits_t::AcousticLimitRpmThreshold"]
        [::core::mem::offset_of!(OverDriveLimits_t, AcousticLimitRpmThreshold) - 28usize];
    ["Offset of field: OverDriveLimits_t::FanTargetTemperature"]
        [::core::mem::offset_of!(OverDriveLimits_t, FanTargetTemperature) - 30usize];
    ["Offset of field: OverDriveLimits_t::FanZeroRpmEnable"]
        [::core::mem::offset_of!(OverDriveLimits_t, FanZeroRpmEnable) - 32usize];
    ["Offset of field: OverDriveLimits_t::FanZeroRpmStopTemp"]
        [::core::mem::offset_of!(OverDriveLimits_t, FanZeroRpmStopTemp) - 33usize];
    ["Offset of field: OverDriveLimits_t::FanMode"]
        [::core::mem::offset_of!(OverDriveLimits_t, FanMode) - 34usize];
    ["Offset of field: OverDriveLimits_t::MaxOpTemp"]
        [::core::mem::offset_of!(OverDriveLimits_t, MaxOpTemp) - 35usize];
    ["Offset of field: OverDriveLimits_t::Spare"]
        [::core::mem::offset_of!(OverDriveLimits_t, Spare) - 36usize];
};
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_0: BOARD_GPIO_TYPE_e = 0;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_1: BOARD_GPIO_TYPE_e = 1;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_2: BOARD_GPIO_TYPE_e = 2;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_3: BOARD_GPIO_TYPE_e = 3;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_4: BOARD_GPIO_TYPE_e = 4;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_5: BOARD_GPIO_TYPE_e = 5;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_6: BOARD_GPIO_TYPE_e = 6;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_7: BOARD_GPIO_TYPE_e = 7;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_8: BOARD_GPIO_TYPE_e = 8;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_9: BOARD_GPIO_TYPE_e = 9;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_10: BOARD_GPIO_TYPE_e = 10;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_11: BOARD_GPIO_TYPE_e = 11;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_12: BOARD_GPIO_TYPE_e = 12;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_13: BOARD_GPIO_TYPE_e = 13;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_14: BOARD_GPIO_TYPE_e = 14;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_15: BOARD_GPIO_TYPE_e = 15;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_16: BOARD_GPIO_TYPE_e = 16;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_17: BOARD_GPIO_TYPE_e = 17;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_18: BOARD_GPIO_TYPE_e = 18;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_19: BOARD_GPIO_TYPE_e = 19;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_20: BOARD_GPIO_TYPE_e = 20;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_21: BOARD_GPIO_TYPE_e = 21;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_22: BOARD_GPIO_TYPE_e = 22;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_23: BOARD_GPIO_TYPE_e = 23;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_24: BOARD_GPIO_TYPE_e = 24;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_25: BOARD_GPIO_TYPE_e = 25;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_26: BOARD_GPIO_TYPE_e = 26;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_27: BOARD_GPIO_TYPE_e = 27;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_28: BOARD_GPIO_TYPE_e = 28;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_29: BOARD_GPIO_TYPE_e = 29;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_30: BOARD_GPIO_TYPE_e = 30;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_SMUIO_31: BOARD_GPIO_TYPE_e = 31;
pub const BOARD_GPIO_TYPE_e_MAX_BOARD_GPIO_SMUIO_NUM: BOARD_GPIO_TYPE_e = 32;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_DC_GEN_A: BOARD_GPIO_TYPE_e = 33;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_DC_GEN_B: BOARD_GPIO_TYPE_e = 34;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_DC_GEN_C: BOARD_GPIO_TYPE_e = 35;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_DC_GEN_D: BOARD_GPIO_TYPE_e = 36;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_DC_GEN_E: BOARD_GPIO_TYPE_e = 37;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_DC_GEN_F: BOARD_GPIO_TYPE_e = 38;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_DC_GEN_G: BOARD_GPIO_TYPE_e = 39;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_DC_GENLK_CLK: BOARD_GPIO_TYPE_e = 40;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_DC_GENLK_VSYNC: BOARD_GPIO_TYPE_e = 41;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_DC_SWAPLOCK_A: BOARD_GPIO_TYPE_e = 42;
pub const BOARD_GPIO_TYPE_e_BOARD_GPIO_DC_SWAPLOCK_B: BOARD_GPIO_TYPE_e = 43;
pub type BOARD_GPIO_TYPE_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BootValues_t {
    pub InitGfxclk_bypass: u16,
    pub InitSocclk: u16,
    pub InitMp0clk: u16,
    pub InitMpioclk: u16,
    pub InitSmnclk: u16,
    pub InitUcpclk: u16,
    pub InitCsrclk: u16,
    pub InitDprefclk: u16,
    pub InitDcfclk: u16,
    pub InitDtbclk: u16,
    pub InitDclk: u16,
    pub InitVclk: u16,
    pub InitUsbdfsclk: u16,
    pub InitMp1clk: u16,
    pub InitLclk: u16,
    pub InitBaco400clk_bypass: u16,
    pub InitBaco1200clk_bypass: u16,
    pub InitBaco700clk_bypass: u16,
    pub InitFclk: u16,
    pub InitGfxclk_clkb: u16,
    pub InitUclkDPMState: u8,
    pub Padding: [u8; 3usize],
    pub InitVcoFreqPll0: u32,
    pub InitVcoFreqPll1: u32,
    pub InitVcoFreqPll2: u32,
    pub InitVcoFreqPll3: u32,
    pub InitVcoFreqPll4: u32,
    pub InitVcoFreqPll5: u32,
    pub InitVcoFreqPll6: u32,
    pub InitGfx: u16,
    pub InitSoc: u16,
    pub InitU: u16,
    pub Padding2: u16,
    pub Spare: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of BootValues_t"][::core::mem::size_of::<BootValues_t>() - 112usize];
    ["Alignment of BootValues_t"][::core::mem::align_of::<BootValues_t>() - 4usize];
    ["Offset of field: BootValues_t::InitGfxclk_bypass"]
        [::core::mem::offset_of!(BootValues_t, InitGfxclk_bypass) - 0usize];
    ["Offset of field: BootValues_t::InitSocclk"]
        [::core::mem::offset_of!(BootValues_t, InitSocclk) - 2usize];
    ["Offset of field: BootValues_t::InitMp0clk"]
        [::core::mem::offset_of!(BootValues_t, InitMp0clk) - 4usize];
    ["Offset of field: BootValues_t::InitMpioclk"]
        [::core::mem::offset_of!(BootValues_t, InitMpioclk) - 6usize];
    ["Offset of field: BootValues_t::InitSmnclk"]
        [::core::mem::offset_of!(BootValues_t, InitSmnclk) - 8usize];
    ["Offset of field: BootValues_t::InitUcpclk"]
        [::core::mem::offset_of!(BootValues_t, InitUcpclk) - 10usize];
    ["Offset of field: BootValues_t::InitCsrclk"]
        [::core::mem::offset_of!(BootValues_t, InitCsrclk) - 12usize];
    ["Offset of field: BootValues_t::InitDprefclk"]
        [::core::mem::offset_of!(BootValues_t, InitDprefclk) - 14usize];
    ["Offset of field: BootValues_t::InitDcfclk"]
        [::core::mem::offset_of!(BootValues_t, InitDcfclk) - 16usize];
    ["Offset of field: BootValues_t::InitDtbclk"]
        [::core::mem::offset_of!(BootValues_t, InitDtbclk) - 18usize];
    ["Offset of field: BootValues_t::InitDclk"]
        [::core::mem::offset_of!(BootValues_t, InitDclk) - 20usize];
    ["Offset of field: BootValues_t::InitVclk"]
        [::core::mem::offset_of!(BootValues_t, InitVclk) - 22usize];
    ["Offset of field: BootValues_t::InitUsbdfsclk"]
        [::core::mem::offset_of!(BootValues_t, InitUsbdfsclk) - 24usize];
    ["Offset of field: BootValues_t::InitMp1clk"]
        [::core::mem::offset_of!(BootValues_t, InitMp1clk) - 26usize];
    ["Offset of field: BootValues_t::InitLclk"]
        [::core::mem::offset_of!(BootValues_t, InitLclk) - 28usize];
    ["Offset of field: BootValues_t::InitBaco400clk_bypass"]
        [::core::mem::offset_of!(BootValues_t, InitBaco400clk_bypass) - 30usize];
    ["Offset of field: BootValues_t::InitBaco1200clk_bypass"]
        [::core::mem::offset_of!(BootValues_t, InitBaco1200clk_bypass) - 32usize];
    ["Offset of field: BootValues_t::InitBaco700clk_bypass"]
        [::core::mem::offset_of!(BootValues_t, InitBaco700clk_bypass) - 34usize];
    ["Offset of field: BootValues_t::InitFclk"]
        [::core::mem::offset_of!(BootValues_t, InitFclk) - 36usize];
    ["Offset of field: BootValues_t::InitGfxclk_clkb"]
        [::core::mem::offset_of!(BootValues_t, InitGfxclk_clkb) - 38usize];
    ["Offset of field: BootValues_t::InitUclkDPMState"]
        [::core::mem::offset_of!(BootValues_t, InitUclkDPMState) - 40usize];
    ["Offset of field: BootValues_t::Padding"]
        [::core::mem::offset_of!(BootValues_t, Padding) - 41usize];
    ["Offset of field: BootValues_t::InitVcoFreqPll0"]
        [::core::mem::offset_of!(BootValues_t, InitVcoFreqPll0) - 44usize];
    ["Offset of field: BootValues_t::InitVcoFreqPll1"]
        [::core::mem::offset_of!(BootValues_t, InitVcoFreqPll1) - 48usize];
    ["Offset of field: BootValues_t::InitVcoFreqPll2"]
        [::core::mem::offset_of!(BootValues_t, InitVcoFreqPll2) - 52usize];
    ["Offset of field: BootValues_t::InitVcoFreqPll3"]
        [::core::mem::offset_of!(BootValues_t, InitVcoFreqPll3) - 56usize];
    ["Offset of field: BootValues_t::InitVcoFreqPll4"]
        [::core::mem::offset_of!(BootValues_t, InitVcoFreqPll4) - 60usize];
    ["Offset of field: BootValues_t::InitVcoFreqPll5"]
        [::core::mem::offset_of!(BootValues_t, InitVcoFreqPll5) - 64usize];
    ["Offset of field: BootValues_t::InitVcoFreqPll6"]
        [::core::mem::offset_of!(BootValues_t, InitVcoFreqPll6) - 68usize];
    ["Offset of field: BootValues_t::InitGfx"]
        [::core::mem::offset_of!(BootValues_t, InitGfx) - 72usize];
    ["Offset of field: BootValues_t::InitSoc"]
        [::core::mem::offset_of!(BootValues_t, InitSoc) - 74usize];
    ["Offset of field: BootValues_t::InitU"]
        [::core::mem::offset_of!(BootValues_t, InitU) - 76usize];
    ["Offset of field: BootValues_t::Padding2"]
        [::core::mem::offset_of!(BootValues_t, Padding2) - 78usize];
    ["Offset of field: BootValues_t::Spare"]
        [::core::mem::offset_of!(BootValues_t, Spare) - 80usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MsgLimits_t {
    pub Power: [[u16; 2usize]; 4usize],
    pub Tdc: [u16; 3usize],
    pub Temperature: [u16; 13usize],
    pub PwmLimitMin: u8,
    pub PwmLimitMax: u8,
    pub FanTargetTemperature: u8,
    pub Spare1: [u8; 1usize],
    pub AcousticTargetRpmThresholdMin: u16,
    pub AcousticTargetRpmThresholdMax: u16,
    pub AcousticLimitRpmThresholdMin: u16,
    pub AcousticLimitRpmThresholdMax: u16,
    pub PccLimitMin: u16,
    pub PccLimitMax: u16,
    pub FanStopTempMin: u16,
    pub FanStopTempMax: u16,
    pub FanStartTempMin: u16,
    pub FanStartTempMax: u16,
    pub PowerMinPpt0: [u16; 2usize],
    pub Spare: [u32; 11usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MsgLimits_t"][::core::mem::size_of::<MsgLimits_t>() - 120usize];
    ["Alignment of MsgLimits_t"][::core::mem::align_of::<MsgLimits_t>() - 4usize];
    ["Offset of field: MsgLimits_t::Power"][::core::mem::offset_of!(MsgLimits_t, Power) - 0usize];
    ["Offset of field: MsgLimits_t::Tdc"][::core::mem::offset_of!(MsgLimits_t, Tdc) - 16usize];
    ["Offset of field: MsgLimits_t::Temperature"]
        [::core::mem::offset_of!(MsgLimits_t, Temperature) - 22usize];
    ["Offset of field: MsgLimits_t::PwmLimitMin"]
        [::core::mem::offset_of!(MsgLimits_t, PwmLimitMin) - 48usize];
    ["Offset of field: MsgLimits_t::PwmLimitMax"]
        [::core::mem::offset_of!(MsgLimits_t, PwmLimitMax) - 49usize];
    ["Offset of field: MsgLimits_t::FanTargetTemperature"]
        [::core::mem::offset_of!(MsgLimits_t, FanTargetTemperature) - 50usize];
    ["Offset of field: MsgLimits_t::Spare1"]
        [::core::mem::offset_of!(MsgLimits_t, Spare1) - 51usize];
    ["Offset of field: MsgLimits_t::AcousticTargetRpmThresholdMin"]
        [::core::mem::offset_of!(MsgLimits_t, AcousticTargetRpmThresholdMin) - 52usize];
    ["Offset of field: MsgLimits_t::AcousticTargetRpmThresholdMax"]
        [::core::mem::offset_of!(MsgLimits_t, AcousticTargetRpmThresholdMax) - 54usize];
    ["Offset of field: MsgLimits_t::AcousticLimitRpmThresholdMin"]
        [::core::mem::offset_of!(MsgLimits_t, AcousticLimitRpmThresholdMin) - 56usize];
    ["Offset of field: MsgLimits_t::AcousticLimitRpmThresholdMax"]
        [::core::mem::offset_of!(MsgLimits_t, AcousticLimitRpmThresholdMax) - 58usize];
    ["Offset of field: MsgLimits_t::PccLimitMin"]
        [::core::mem::offset_of!(MsgLimits_t, PccLimitMin) - 60usize];
    ["Offset of field: MsgLimits_t::PccLimitMax"]
        [::core::mem::offset_of!(MsgLimits_t, PccLimitMax) - 62usize];
    ["Offset of field: MsgLimits_t::FanStopTempMin"]
        [::core::mem::offset_of!(MsgLimits_t, FanStopTempMin) - 64usize];
    ["Offset of field: MsgLimits_t::FanStopTempMax"]
        [::core::mem::offset_of!(MsgLimits_t, FanStopTempMax) - 66usize];
    ["Offset of field: MsgLimits_t::FanStartTempMin"]
        [::core::mem::offset_of!(MsgLimits_t, FanStartTempMin) - 68usize];
    ["Offset of field: MsgLimits_t::FanStartTempMax"]
        [::core::mem::offset_of!(MsgLimits_t, FanStartTempMax) - 70usize];
    ["Offset of field: MsgLimits_t::PowerMinPpt0"]
        [::core::mem::offset_of!(MsgLimits_t, PowerMinPpt0) - 72usize];
    ["Offset of field: MsgLimits_t::Spare"][::core::mem::offset_of!(MsgLimits_t, Spare) - 76usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DriverReportedClocks_t {
    pub BaseClockAc: u16,
    pub GameClockAc: u16,
    pub BoostClockAc: u16,
    pub BaseClockDc: u16,
    pub GameClockDc: u16,
    pub BoostClockDc: u16,
    pub Reserved: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DriverReportedClocks_t"][::core::mem::size_of::<DriverReportedClocks_t>() - 28usize];
    ["Alignment of DriverReportedClocks_t"]
        [::core::mem::align_of::<DriverReportedClocks_t>() - 4usize];
    ["Offset of field: DriverReportedClocks_t::BaseClockAc"]
        [::core::mem::offset_of!(DriverReportedClocks_t, BaseClockAc) - 0usize];
    ["Offset of field: DriverReportedClocks_t::GameClockAc"]
        [::core::mem::offset_of!(DriverReportedClocks_t, GameClockAc) - 2usize];
    ["Offset of field: DriverReportedClocks_t::BoostClockAc"]
        [::core::mem::offset_of!(DriverReportedClocks_t, BoostClockAc) - 4usize];
    ["Offset of field: DriverReportedClocks_t::BaseClockDc"]
        [::core::mem::offset_of!(DriverReportedClocks_t, BaseClockDc) - 6usize];
    ["Offset of field: DriverReportedClocks_t::GameClockDc"]
        [::core::mem::offset_of!(DriverReportedClocks_t, GameClockDc) - 8usize];
    ["Offset of field: DriverReportedClocks_t::BoostClockDc"]
        [::core::mem::offset_of!(DriverReportedClocks_t, BoostClockDc) - 10usize];
    ["Offset of field: DriverReportedClocks_t::Reserved"]
        [::core::mem::offset_of!(DriverReportedClocks_t, Reserved) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AvfsDcBtcParams_t {
    pub DcBtcEnabled: u8,
    pub Padding: [u8; 3usize],
    pub DcTol: u16,
    pub DcBtcGb: u16,
    pub DcBtcMin: u16,
    pub DcBtcMax: u16,
    pub DcBtcGbScalar: LinearInt_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AvfsDcBtcParams_t"][::core::mem::size_of::<AvfsDcBtcParams_t>() - 20usize];
    ["Alignment of AvfsDcBtcParams_t"][::core::mem::align_of::<AvfsDcBtcParams_t>() - 4usize];
    ["Offset of field: AvfsDcBtcParams_t::DcBtcEnabled"]
        [::core::mem::offset_of!(AvfsDcBtcParams_t, DcBtcEnabled) - 0usize];
    ["Offset of field: AvfsDcBtcParams_t::Padding"]
        [::core::mem::offset_of!(AvfsDcBtcParams_t, Padding) - 1usize];
    ["Offset of field: AvfsDcBtcParams_t::DcTol"]
        [::core::mem::offset_of!(AvfsDcBtcParams_t, DcTol) - 4usize];
    ["Offset of field: AvfsDcBtcParams_t::DcBtcGb"]
        [::core::mem::offset_of!(AvfsDcBtcParams_t, DcBtcGb) - 6usize];
    ["Offset of field: AvfsDcBtcParams_t::DcBtcMin"]
        [::core::mem::offset_of!(AvfsDcBtcParams_t, DcBtcMin) - 8usize];
    ["Offset of field: AvfsDcBtcParams_t::DcBtcMax"]
        [::core::mem::offset_of!(AvfsDcBtcParams_t, DcBtcMax) - 10usize];
    ["Offset of field: AvfsDcBtcParams_t::DcBtcGbScalar"]
        [::core::mem::offset_of!(AvfsDcBtcParams_t, DcBtcGbScalar) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AvfsFuseOverride_t {
    pub AvfsTemp: [u16; 2usize],
    pub VftFMin: u16,
    pub VInversion: u16,
    pub qVft: [QuadraticInt_t; 2usize],
    pub qAvfsGb: QuadraticInt_t,
    pub qAvfsGb2: QuadraticInt_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AvfsFuseOverride_t"][::core::mem::size_of::<AvfsFuseOverride_t>() - 56usize];
    ["Alignment of AvfsFuseOverride_t"][::core::mem::align_of::<AvfsFuseOverride_t>() - 4usize];
    ["Offset of field: AvfsFuseOverride_t::AvfsTemp"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, AvfsTemp) - 0usize];
    ["Offset of field: AvfsFuseOverride_t::VftFMin"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, VftFMin) - 4usize];
    ["Offset of field: AvfsFuseOverride_t::VInversion"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, VInversion) - 6usize];
    ["Offset of field: AvfsFuseOverride_t::qVft"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, qVft) - 8usize];
    ["Offset of field: AvfsFuseOverride_t::qAvfsGb"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, qAvfsGb) - 32usize];
    ["Offset of field: AvfsFuseOverride_t::qAvfsGb2"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, qAvfsGb2) - 44usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkuTable_t {
    pub Version: u32,
    pub FeaturesToRun: [u32; 2usize],
    pub TotalPowerConfig: u8,
    pub CustomerVariant: u8,
    pub MemoryTemperatureTypeMask: u8,
    pub SmartShiftVersion: u8,
    pub SocketPowerLimitAc: [u16; 4usize],
    pub SocketPowerLimitDc: [u16; 4usize],
    pub SocketPowerLimitSmartShift2: u16,
    pub EnableLegacyPptLimit: u8,
    pub UseInputTelemetry: u8,
    pub SmartShiftMinReportedPptinDcs: u8,
    pub PaddingPpt: [u8; 1usize],
    pub VrTdcLimit: [u16; 3usize],
    pub PlatformTdcLimit: [u16; 3usize],
    pub TemperatureLimit: [u16; 13usize],
    pub HwCtfTempLimit: u16,
    pub PaddingInfra: u16,
    pub FitControllerFailureRateLimit: u32,
    pub FitControllerGfxDutyCycle: u32,
    pub FitControllerSocDutyCycle: u32,
    pub FitControllerSocOffset: u32,
    pub GfxApccPlusResidencyLimit: u32,
    pub ThrottlerControlMask: u32,
    pub FwDStateMask: u32,
    pub UlvVoltageOffset: [u16; 2usize],
    pub UlvVoltageOffsetU: u16,
    pub DeepUlvVoltageOffsetSoc: u16,
    pub DefaultMaxVoltage: [u16; 2usize],
    pub BoostMaxVoltage: [u16; 2usize],
    pub VminTempHystersis: [i16; 2usize],
    pub VminTempThreshold: [i16; 2usize],
    pub Vmin_Hot_T0: [u16; 2usize],
    pub Vmin_Cold_T0: [u16; 2usize],
    pub Vmin_Hot_Eol: [u16; 2usize],
    pub Vmin_Cold_Eol: [u16; 2usize],
    pub Vmin_Aging_Offset: [u16; 2usize],
    pub Spare_Vmin_Plat_Offset_Hot: [u16; 2usize],
    pub Spare_Vmin_Plat_Offset_Cold: [u16; 2usize],
    pub VcBtcFixedVminAgingOffset: [u16; 2usize],
    pub VcBtcVmin2PsmDegrationGb: [u16; 2usize],
    pub VcBtcPsmA: [u32; 2usize],
    pub VcBtcPsmB: [u32; 2usize],
    pub VcBtcVminA: [u32; 2usize],
    pub VcBtcVminB: [u32; 2usize],
    pub PerPartVminEnabled: [u8; 2usize],
    pub VcBtcEnabled: [u8; 2usize],
    pub SocketPowerLimitAcTau: [u16; 4usize],
    pub SocketPowerLimitDcTau: [u16; 4usize],
    pub Vmin_droop: QuadraticInt_t,
    pub SpareVmin: [u32; 9usize],
    pub DpmDescriptor: [DpmDescriptor_t; 13usize],
    pub FreqTableGfx: [u16; 16usize],
    pub FreqTableVclk: [u16; 8usize],
    pub FreqTableDclk: [u16; 8usize],
    pub FreqTableSocclk: [u16; 8usize],
    pub FreqTableUclk: [u16; 4usize],
    pub FreqTableDispclk: [u16; 8usize],
    pub FreqTableDppClk: [u16; 8usize],
    pub FreqTableDprefclk: [u16; 8usize],
    pub FreqTableDcfclk: [u16; 8usize],
    pub FreqTableDtbclk: [u16; 8usize],
    pub FreqTableFclk: [u16; 8usize],
    pub DcModeMaxFreq: [u32; 13usize],
    pub Mp0clkFreq: [u16; 2usize],
    pub Mp0DpmVoltage: [u16; 2usize],
    pub GfxclkSpare: [u8; 2usize],
    pub GfxclkFreqCap: u16,
    pub GfxclkFgfxoffEntry: u16,
    pub GfxclkFgfxoffExitImu: u16,
    pub GfxclkFgfxoffExitRlc: u16,
    pub GfxclkThrottleClock: u16,
    pub EnableGfxPowerStagesGpio: u8,
    pub GfxIdlePadding: u8,
    pub SmsRepairWRCKClkDivEn: u8,
    pub SmsRepairWRCKClkDivVal: u8,
    pub GfxOffEntryEarlyMGCGEn: u8,
    pub GfxOffEntryForceCGCGEn: u8,
    pub GfxOffEntryForceCGCGDelayEn: u8,
    pub GfxOffEntryForceCGCGDelayVal: u8,
    pub GfxclkFreqGfxUlv: u16,
    pub GfxIdlePadding2: [u8; 2usize],
    pub GfxOffEntryHysteresis: u32,
    pub GfxoffSpare: [u32; 15usize],
    pub DfllBtcMasterScalerM: u32,
    pub DfllBtcMasterScalerB: i32,
    pub DfllBtcSlaveScalerM: u32,
    pub DfllBtcSlaveScalerB: i32,
    pub DfllPccAsWaitCtrl: u32,
    pub DfllPccAsStepCtrl: u32,
    pub DfllL2FrequencyBoostM: u32,
    pub DfllL2FrequencyBoostB: u32,
    pub GfxGpoSpare: [u32; 8usize],
    pub DcsGfxOffVoltage: u16,
    pub PaddingDcs: u16,
    pub DcsMinGfxOffTime: u16,
    pub DcsMaxGfxOffTime: u16,
    pub DcsMinCreditAccum: u32,
    pub DcsExitHysteresis: u16,
    pub DcsTimeout: u16,
    pub FoptEnabled: u8,
    pub DcsSpare2: [u8; 3usize],
    pub DcsFoptM: u32,
    pub DcsFoptB: u32,
    pub DcsSpare: [u32; 11usize],
    pub ShadowFreqTableUclk: [u16; 4usize],
    pub UseStrobeModeOptimizations: u8,
    pub PaddingMem: [u8; 3usize],
    pub UclkDpmPstates: [u8; 4usize],
    pub FreqTableUclkDiv: [u8; 4usize],
    pub MemVmempVoltage: [u16; 4usize],
    pub MemVddioVoltage: [u16; 4usize],
    pub FclkDpmUPstates: [u8; 8usize],
    pub FclkDpmVddU: [u16; 8usize],
    pub FclkDpmUSpeed: [u16; 8usize],
    pub FclkDpmDisallowPstateFreq: u16,
    pub PaddingFclk: u16,
    #[doc = "< 0:PciE-gen1 1:PciE-gen2 2:PciE-gen3 3:PciE-gen4"]
    pub PcieGenSpeed: [u8; 3usize],
    #[doc = "< 1=x1, 2=x2, 3=x4, 4=x8, 5=x12, 6=x16"]
    pub PcieLaneCount: [u8; 3usize],
    pub LclkFreq: [u16; 3usize],
    pub FanStopTemp: [u16; 13usize],
    pub FanStartTemp: [u16; 13usize],
    pub FanGain: [u16; 13usize],
    pub FanGainPadding: u16,
    pub FanPwmMin: u16,
    pub AcousticTargetRpmThreshold: u16,
    pub AcousticLimitRpmThreshold: u16,
    pub FanMaximumRpm: u16,
    pub MGpuAcousticLimitRpmThreshold: u16,
    pub FanTargetGfxclk: u16,
    pub TempInputSelectMask: u32,
    pub FanZeroRpmEnable: u8,
    pub FanTachEdgePerRev: u8,
    pub FanTargetTemperature: [u16; 13usize],
    pub FuzzyFan_ErrorSetDelta: i16,
    pub FuzzyFan_ErrorRateSetDelta: i16,
    pub FuzzyFan_PwmSetDelta: i16,
    pub FuzzyFan_Reserved: u16,
    pub FwCtfLimit: [u16; 13usize],
    pub IntakeTempEnableRPM: u16,
    pub IntakeTempOffsetTemp: i16,
    pub IntakeTempReleaseTemp: u16,
    pub IntakeTempHighIntakeAcousticLimit: u16,
    pub IntakeTempAcouticLimitReleaseRate: u16,
    pub FanAbnormalTempLimitOffset: i16,
    pub FanStalledTriggerRpm: u16,
    pub FanAbnormalTriggerRpmCoeff: u16,
    pub FanAbnormalDetectionEnable: u16,
    pub FanIntakeSensorSupport: u8,
    pub FanIntakePadding: [u8; 3usize],
    pub FanSpare: [u32; 13usize],
    pub OverrideGfxAvfsFuses: u8,
    pub GfxAvfsPadding: [u8; 3usize],
    pub L2HwRtAvfsFuses: [u32; 32usize],
    pub SeHwRtAvfsFuses: [u32; 32usize],
    pub CommonRtAvfs: [u32; 13usize],
    pub L2FwRtAvfsFuses: [u32; 19usize],
    pub SeFwRtAvfsFuses: [u32; 19usize],
    pub Droop_PWL_F: [u32; 5usize],
    pub Droop_PWL_a: [u32; 5usize],
    pub Droop_PWL_b: [u32; 5usize],
    pub Droop_PWL_c: [u32; 5usize],
    pub Static_PWL_Offset: [u32; 5usize],
    pub dGbV_dT_vmin: u32,
    pub dGbV_dT_vmax: u32,
    pub V2F_vmin_range_low: u32,
    pub V2F_vmin_range_high: u32,
    pub V2F_vmax_range_low: u32,
    pub V2F_vmax_range_high: u32,
    pub DcBtcGfxParams: AvfsDcBtcParams_t,
    pub GfxAvfsSpare: [u32; 32usize],
    pub OverrideSocAvfsFuses: u8,
    pub MinSocAvfsRevision: u8,
    pub SocAvfsPadding: [u8; 2usize],
    pub SocAvfsFuseOverride: [AvfsFuseOverride_t; 3usize],
    pub dBtcGbSoc: [DroopInt_t; 3usize],
    pub qAgingGb: [LinearInt_t; 3usize],
    pub qStaticVoltageOffset: [QuadraticInt_t; 3usize],
    pub DcBtcSocParams: [AvfsDcBtcParams_t; 3usize],
    pub SocAvfsSpare: [u32; 32usize],
    pub BootValues: BootValues_t,
    pub DriverReportedClocks: DriverReportedClocks_t,
    pub MsgLimits: MsgLimits_t,
    pub OverDriveLimitsMin: OverDriveLimits_t,
    pub OverDriveLimitsBasicMax: OverDriveLimits_t,
    pub reserved: [u32; 22usize],
    pub DebugOverrides: u32,
    pub TotalBoardPowerSupport: u8,
    pub TotalBoardPowerPadding: [u8; 3usize],
    pub TotalIdleBoardPowerM: i16,
    pub TotalIdleBoardPowerB: i16,
    pub TotalBoardPowerM: i16,
    pub TotalBoardPowerB: i16,
    pub qFeffCoeffGameClock: [QuadraticInt_t; 2usize],
    pub qFeffCoeffBaseClock: [QuadraticInt_t; 2usize],
    pub qFeffCoeffBoostClock: [QuadraticInt_t; 2usize],
    pub TemperatureLimit_Hynix: u16,
    pub TemperatureLimit_Micron: u16,
    pub TemperatureFwCtfLimit_Hynix: u16,
    pub TemperatureFwCtfLimit_Micron: u16,
    pub Spare: [u32; 41usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkuTable_t"][::core::mem::size_of::<SkuTable_t>() - 3484usize];
    ["Alignment of SkuTable_t"][::core::mem::align_of::<SkuTable_t>() - 4usize];
    ["Offset of field: SkuTable_t::Version"][::core::mem::offset_of!(SkuTable_t, Version) - 0usize];
    ["Offset of field: SkuTable_t::FeaturesToRun"]
        [::core::mem::offset_of!(SkuTable_t, FeaturesToRun) - 4usize];
    ["Offset of field: SkuTable_t::TotalPowerConfig"]
        [::core::mem::offset_of!(SkuTable_t, TotalPowerConfig) - 12usize];
    ["Offset of field: SkuTable_t::CustomerVariant"]
        [::core::mem::offset_of!(SkuTable_t, CustomerVariant) - 13usize];
    ["Offset of field: SkuTable_t::MemoryTemperatureTypeMask"]
        [::core::mem::offset_of!(SkuTable_t, MemoryTemperatureTypeMask) - 14usize];
    ["Offset of field: SkuTable_t::SmartShiftVersion"]
        [::core::mem::offset_of!(SkuTable_t, SmartShiftVersion) - 15usize];
    ["Offset of field: SkuTable_t::SocketPowerLimitAc"]
        [::core::mem::offset_of!(SkuTable_t, SocketPowerLimitAc) - 16usize];
    ["Offset of field: SkuTable_t::SocketPowerLimitDc"]
        [::core::mem::offset_of!(SkuTable_t, SocketPowerLimitDc) - 24usize];
    ["Offset of field: SkuTable_t::SocketPowerLimitSmartShift2"]
        [::core::mem::offset_of!(SkuTable_t, SocketPowerLimitSmartShift2) - 32usize];
    ["Offset of field: SkuTable_t::EnableLegacyPptLimit"]
        [::core::mem::offset_of!(SkuTable_t, EnableLegacyPptLimit) - 34usize];
    ["Offset of field: SkuTable_t::UseInputTelemetry"]
        [::core::mem::offset_of!(SkuTable_t, UseInputTelemetry) - 35usize];
    ["Offset of field: SkuTable_t::SmartShiftMinReportedPptinDcs"]
        [::core::mem::offset_of!(SkuTable_t, SmartShiftMinReportedPptinDcs) - 36usize];
    ["Offset of field: SkuTable_t::PaddingPpt"]
        [::core::mem::offset_of!(SkuTable_t, PaddingPpt) - 37usize];
    ["Offset of field: SkuTable_t::VrTdcLimit"]
        [::core::mem::offset_of!(SkuTable_t, VrTdcLimit) - 38usize];
    ["Offset of field: SkuTable_t::PlatformTdcLimit"]
        [::core::mem::offset_of!(SkuTable_t, PlatformTdcLimit) - 44usize];
    ["Offset of field: SkuTable_t::TemperatureLimit"]
        [::core::mem::offset_of!(SkuTable_t, TemperatureLimit) - 50usize];
    ["Offset of field: SkuTable_t::HwCtfTempLimit"]
        [::core::mem::offset_of!(SkuTable_t, HwCtfTempLimit) - 76usize];
    ["Offset of field: SkuTable_t::PaddingInfra"]
        [::core::mem::offset_of!(SkuTable_t, PaddingInfra) - 78usize];
    ["Offset of field: SkuTable_t::FitControllerFailureRateLimit"]
        [::core::mem::offset_of!(SkuTable_t, FitControllerFailureRateLimit) - 80usize];
    ["Offset of field: SkuTable_t::FitControllerGfxDutyCycle"]
        [::core::mem::offset_of!(SkuTable_t, FitControllerGfxDutyCycle) - 84usize];
    ["Offset of field: SkuTable_t::FitControllerSocDutyCycle"]
        [::core::mem::offset_of!(SkuTable_t, FitControllerSocDutyCycle) - 88usize];
    ["Offset of field: SkuTable_t::FitControllerSocOffset"]
        [::core::mem::offset_of!(SkuTable_t, FitControllerSocOffset) - 92usize];
    ["Offset of field: SkuTable_t::GfxApccPlusResidencyLimit"]
        [::core::mem::offset_of!(SkuTable_t, GfxApccPlusResidencyLimit) - 96usize];
    ["Offset of field: SkuTable_t::ThrottlerControlMask"]
        [::core::mem::offset_of!(SkuTable_t, ThrottlerControlMask) - 100usize];
    ["Offset of field: SkuTable_t::FwDStateMask"]
        [::core::mem::offset_of!(SkuTable_t, FwDStateMask) - 104usize];
    ["Offset of field: SkuTable_t::UlvVoltageOffset"]
        [::core::mem::offset_of!(SkuTable_t, UlvVoltageOffset) - 108usize];
    ["Offset of field: SkuTable_t::UlvVoltageOffsetU"]
        [::core::mem::offset_of!(SkuTable_t, UlvVoltageOffsetU) - 112usize];
    ["Offset of field: SkuTable_t::DeepUlvVoltageOffsetSoc"]
        [::core::mem::offset_of!(SkuTable_t, DeepUlvVoltageOffsetSoc) - 114usize];
    ["Offset of field: SkuTable_t::DefaultMaxVoltage"]
        [::core::mem::offset_of!(SkuTable_t, DefaultMaxVoltage) - 116usize];
    ["Offset of field: SkuTable_t::BoostMaxVoltage"]
        [::core::mem::offset_of!(SkuTable_t, BoostMaxVoltage) - 120usize];
    ["Offset of field: SkuTable_t::VminTempHystersis"]
        [::core::mem::offset_of!(SkuTable_t, VminTempHystersis) - 124usize];
    ["Offset of field: SkuTable_t::VminTempThreshold"]
        [::core::mem::offset_of!(SkuTable_t, VminTempThreshold) - 128usize];
    ["Offset of field: SkuTable_t::Vmin_Hot_T0"]
        [::core::mem::offset_of!(SkuTable_t, Vmin_Hot_T0) - 132usize];
    ["Offset of field: SkuTable_t::Vmin_Cold_T0"]
        [::core::mem::offset_of!(SkuTable_t, Vmin_Cold_T0) - 136usize];
    ["Offset of field: SkuTable_t::Vmin_Hot_Eol"]
        [::core::mem::offset_of!(SkuTable_t, Vmin_Hot_Eol) - 140usize];
    ["Offset of field: SkuTable_t::Vmin_Cold_Eol"]
        [::core::mem::offset_of!(SkuTable_t, Vmin_Cold_Eol) - 144usize];
    ["Offset of field: SkuTable_t::Vmin_Aging_Offset"]
        [::core::mem::offset_of!(SkuTable_t, Vmin_Aging_Offset) - 148usize];
    ["Offset of field: SkuTable_t::Spare_Vmin_Plat_Offset_Hot"]
        [::core::mem::offset_of!(SkuTable_t, Spare_Vmin_Plat_Offset_Hot) - 152usize];
    ["Offset of field: SkuTable_t::Spare_Vmin_Plat_Offset_Cold"]
        [::core::mem::offset_of!(SkuTable_t, Spare_Vmin_Plat_Offset_Cold) - 156usize];
    ["Offset of field: SkuTable_t::VcBtcFixedVminAgingOffset"]
        [::core::mem::offset_of!(SkuTable_t, VcBtcFixedVminAgingOffset) - 160usize];
    ["Offset of field: SkuTable_t::VcBtcVmin2PsmDegrationGb"]
        [::core::mem::offset_of!(SkuTable_t, VcBtcVmin2PsmDegrationGb) - 164usize];
    ["Offset of field: SkuTable_t::VcBtcPsmA"]
        [::core::mem::offset_of!(SkuTable_t, VcBtcPsmA) - 168usize];
    ["Offset of field: SkuTable_t::VcBtcPsmB"]
        [::core::mem::offset_of!(SkuTable_t, VcBtcPsmB) - 176usize];
    ["Offset of field: SkuTable_t::VcBtcVminA"]
        [::core::mem::offset_of!(SkuTable_t, VcBtcVminA) - 184usize];
    ["Offset of field: SkuTable_t::VcBtcVminB"]
        [::core::mem::offset_of!(SkuTable_t, VcBtcVminB) - 192usize];
    ["Offset of field: SkuTable_t::PerPartVminEnabled"]
        [::core::mem::offset_of!(SkuTable_t, PerPartVminEnabled) - 200usize];
    ["Offset of field: SkuTable_t::VcBtcEnabled"]
        [::core::mem::offset_of!(SkuTable_t, VcBtcEnabled) - 202usize];
    ["Offset of field: SkuTable_t::SocketPowerLimitAcTau"]
        [::core::mem::offset_of!(SkuTable_t, SocketPowerLimitAcTau) - 204usize];
    ["Offset of field: SkuTable_t::SocketPowerLimitDcTau"]
        [::core::mem::offset_of!(SkuTable_t, SocketPowerLimitDcTau) - 212usize];
    ["Offset of field: SkuTable_t::Vmin_droop"]
        [::core::mem::offset_of!(SkuTable_t, Vmin_droop) - 220usize];
    ["Offset of field: SkuTable_t::SpareVmin"]
        [::core::mem::offset_of!(SkuTable_t, SpareVmin) - 232usize];
    ["Offset of field: SkuTable_t::DpmDescriptor"]
        [::core::mem::offset_of!(SkuTable_t, DpmDescriptor) - 268usize];
    ["Offset of field: SkuTable_t::FreqTableGfx"]
        [::core::mem::offset_of!(SkuTable_t, FreqTableGfx) - 684usize];
    ["Offset of field: SkuTable_t::FreqTableVclk"]
        [::core::mem::offset_of!(SkuTable_t, FreqTableVclk) - 716usize];
    ["Offset of field: SkuTable_t::FreqTableDclk"]
        [::core::mem::offset_of!(SkuTable_t, FreqTableDclk) - 732usize];
    ["Offset of field: SkuTable_t::FreqTableSocclk"]
        [::core::mem::offset_of!(SkuTable_t, FreqTableSocclk) - 748usize];
    ["Offset of field: SkuTable_t::FreqTableUclk"]
        [::core::mem::offset_of!(SkuTable_t, FreqTableUclk) - 764usize];
    ["Offset of field: SkuTable_t::FreqTableDispclk"]
        [::core::mem::offset_of!(SkuTable_t, FreqTableDispclk) - 772usize];
    ["Offset of field: SkuTable_t::FreqTableDppClk"]
        [::core::mem::offset_of!(SkuTable_t, FreqTableDppClk) - 788usize];
    ["Offset of field: SkuTable_t::FreqTableDprefclk"]
        [::core::mem::offset_of!(SkuTable_t, FreqTableDprefclk) - 804usize];
    ["Offset of field: SkuTable_t::FreqTableDcfclk"]
        [::core::mem::offset_of!(SkuTable_t, FreqTableDcfclk) - 820usize];
    ["Offset of field: SkuTable_t::FreqTableDtbclk"]
        [::core::mem::offset_of!(SkuTable_t, FreqTableDtbclk) - 836usize];
    ["Offset of field: SkuTable_t::FreqTableFclk"]
        [::core::mem::offset_of!(SkuTable_t, FreqTableFclk) - 852usize];
    ["Offset of field: SkuTable_t::DcModeMaxFreq"]
        [::core::mem::offset_of!(SkuTable_t, DcModeMaxFreq) - 868usize];
    ["Offset of field: SkuTable_t::Mp0clkFreq"]
        [::core::mem::offset_of!(SkuTable_t, Mp0clkFreq) - 920usize];
    ["Offset of field: SkuTable_t::Mp0DpmVoltage"]
        [::core::mem::offset_of!(SkuTable_t, Mp0DpmVoltage) - 924usize];
    ["Offset of field: SkuTable_t::GfxclkSpare"]
        [::core::mem::offset_of!(SkuTable_t, GfxclkSpare) - 928usize];
    ["Offset of field: SkuTable_t::GfxclkFreqCap"]
        [::core::mem::offset_of!(SkuTable_t, GfxclkFreqCap) - 930usize];
    ["Offset of field: SkuTable_t::GfxclkFgfxoffEntry"]
        [::core::mem::offset_of!(SkuTable_t, GfxclkFgfxoffEntry) - 932usize];
    ["Offset of field: SkuTable_t::GfxclkFgfxoffExitImu"]
        [::core::mem::offset_of!(SkuTable_t, GfxclkFgfxoffExitImu) - 934usize];
    ["Offset of field: SkuTable_t::GfxclkFgfxoffExitRlc"]
        [::core::mem::offset_of!(SkuTable_t, GfxclkFgfxoffExitRlc) - 936usize];
    ["Offset of field: SkuTable_t::GfxclkThrottleClock"]
        [::core::mem::offset_of!(SkuTable_t, GfxclkThrottleClock) - 938usize];
    ["Offset of field: SkuTable_t::EnableGfxPowerStagesGpio"]
        [::core::mem::offset_of!(SkuTable_t, EnableGfxPowerStagesGpio) - 940usize];
    ["Offset of field: SkuTable_t::GfxIdlePadding"]
        [::core::mem::offset_of!(SkuTable_t, GfxIdlePadding) - 941usize];
    ["Offset of field: SkuTable_t::SmsRepairWRCKClkDivEn"]
        [::core::mem::offset_of!(SkuTable_t, SmsRepairWRCKClkDivEn) - 942usize];
    ["Offset of field: SkuTable_t::SmsRepairWRCKClkDivVal"]
        [::core::mem::offset_of!(SkuTable_t, SmsRepairWRCKClkDivVal) - 943usize];
    ["Offset of field: SkuTable_t::GfxOffEntryEarlyMGCGEn"]
        [::core::mem::offset_of!(SkuTable_t, GfxOffEntryEarlyMGCGEn) - 944usize];
    ["Offset of field: SkuTable_t::GfxOffEntryForceCGCGEn"]
        [::core::mem::offset_of!(SkuTable_t, GfxOffEntryForceCGCGEn) - 945usize];
    ["Offset of field: SkuTable_t::GfxOffEntryForceCGCGDelayEn"]
        [::core::mem::offset_of!(SkuTable_t, GfxOffEntryForceCGCGDelayEn) - 946usize];
    ["Offset of field: SkuTable_t::GfxOffEntryForceCGCGDelayVal"]
        [::core::mem::offset_of!(SkuTable_t, GfxOffEntryForceCGCGDelayVal) - 947usize];
    ["Offset of field: SkuTable_t::GfxclkFreqGfxUlv"]
        [::core::mem::offset_of!(SkuTable_t, GfxclkFreqGfxUlv) - 948usize];
    ["Offset of field: SkuTable_t::GfxIdlePadding2"]
        [::core::mem::offset_of!(SkuTable_t, GfxIdlePadding2) - 950usize];
    ["Offset of field: SkuTable_t::GfxOffEntryHysteresis"]
        [::core::mem::offset_of!(SkuTable_t, GfxOffEntryHysteresis) - 952usize];
    ["Offset of field: SkuTable_t::GfxoffSpare"]
        [::core::mem::offset_of!(SkuTable_t, GfxoffSpare) - 956usize];
    ["Offset of field: SkuTable_t::DfllBtcMasterScalerM"]
        [::core::mem::offset_of!(SkuTable_t, DfllBtcMasterScalerM) - 1016usize];
    ["Offset of field: SkuTable_t::DfllBtcMasterScalerB"]
        [::core::mem::offset_of!(SkuTable_t, DfllBtcMasterScalerB) - 1020usize];
    ["Offset of field: SkuTable_t::DfllBtcSlaveScalerM"]
        [::core::mem::offset_of!(SkuTable_t, DfllBtcSlaveScalerM) - 1024usize];
    ["Offset of field: SkuTable_t::DfllBtcSlaveScalerB"]
        [::core::mem::offset_of!(SkuTable_t, DfllBtcSlaveScalerB) - 1028usize];
    ["Offset of field: SkuTable_t::DfllPccAsWaitCtrl"]
        [::core::mem::offset_of!(SkuTable_t, DfllPccAsWaitCtrl) - 1032usize];
    ["Offset of field: SkuTable_t::DfllPccAsStepCtrl"]
        [::core::mem::offset_of!(SkuTable_t, DfllPccAsStepCtrl) - 1036usize];
    ["Offset of field: SkuTable_t::DfllL2FrequencyBoostM"]
        [::core::mem::offset_of!(SkuTable_t, DfllL2FrequencyBoostM) - 1040usize];
    ["Offset of field: SkuTable_t::DfllL2FrequencyBoostB"]
        [::core::mem::offset_of!(SkuTable_t, DfllL2FrequencyBoostB) - 1044usize];
    ["Offset of field: SkuTable_t::GfxGpoSpare"]
        [::core::mem::offset_of!(SkuTable_t, GfxGpoSpare) - 1048usize];
    ["Offset of field: SkuTable_t::DcsGfxOffVoltage"]
        [::core::mem::offset_of!(SkuTable_t, DcsGfxOffVoltage) - 1080usize];
    ["Offset of field: SkuTable_t::PaddingDcs"]
        [::core::mem::offset_of!(SkuTable_t, PaddingDcs) - 1082usize];
    ["Offset of field: SkuTable_t::DcsMinGfxOffTime"]
        [::core::mem::offset_of!(SkuTable_t, DcsMinGfxOffTime) - 1084usize];
    ["Offset of field: SkuTable_t::DcsMaxGfxOffTime"]
        [::core::mem::offset_of!(SkuTable_t, DcsMaxGfxOffTime) - 1086usize];
    ["Offset of field: SkuTable_t::DcsMinCreditAccum"]
        [::core::mem::offset_of!(SkuTable_t, DcsMinCreditAccum) - 1088usize];
    ["Offset of field: SkuTable_t::DcsExitHysteresis"]
        [::core::mem::offset_of!(SkuTable_t, DcsExitHysteresis) - 1092usize];
    ["Offset of field: SkuTable_t::DcsTimeout"]
        [::core::mem::offset_of!(SkuTable_t, DcsTimeout) - 1094usize];
    ["Offset of field: SkuTable_t::FoptEnabled"]
        [::core::mem::offset_of!(SkuTable_t, FoptEnabled) - 1096usize];
    ["Offset of field: SkuTable_t::DcsSpare2"]
        [::core::mem::offset_of!(SkuTable_t, DcsSpare2) - 1097usize];
    ["Offset of field: SkuTable_t::DcsFoptM"]
        [::core::mem::offset_of!(SkuTable_t, DcsFoptM) - 1100usize];
    ["Offset of field: SkuTable_t::DcsFoptB"]
        [::core::mem::offset_of!(SkuTable_t, DcsFoptB) - 1104usize];
    ["Offset of field: SkuTable_t::DcsSpare"]
        [::core::mem::offset_of!(SkuTable_t, DcsSpare) - 1108usize];
    ["Offset of field: SkuTable_t::ShadowFreqTableUclk"]
        [::core::mem::offset_of!(SkuTable_t, ShadowFreqTableUclk) - 1152usize];
    ["Offset of field: SkuTable_t::UseStrobeModeOptimizations"]
        [::core::mem::offset_of!(SkuTable_t, UseStrobeModeOptimizations) - 1160usize];
    ["Offset of field: SkuTable_t::PaddingMem"]
        [::core::mem::offset_of!(SkuTable_t, PaddingMem) - 1161usize];
    ["Offset of field: SkuTable_t::UclkDpmPstates"]
        [::core::mem::offset_of!(SkuTable_t, UclkDpmPstates) - 1164usize];
    ["Offset of field: SkuTable_t::FreqTableUclkDiv"]
        [::core::mem::offset_of!(SkuTable_t, FreqTableUclkDiv) - 1168usize];
    ["Offset of field: SkuTable_t::MemVmempVoltage"]
        [::core::mem::offset_of!(SkuTable_t, MemVmempVoltage) - 1172usize];
    ["Offset of field: SkuTable_t::MemVddioVoltage"]
        [::core::mem::offset_of!(SkuTable_t, MemVddioVoltage) - 1180usize];
    ["Offset of field: SkuTable_t::FclkDpmUPstates"]
        [::core::mem::offset_of!(SkuTable_t, FclkDpmUPstates) - 1188usize];
    ["Offset of field: SkuTable_t::FclkDpmVddU"]
        [::core::mem::offset_of!(SkuTable_t, FclkDpmVddU) - 1196usize];
    ["Offset of field: SkuTable_t::FclkDpmUSpeed"]
        [::core::mem::offset_of!(SkuTable_t, FclkDpmUSpeed) - 1212usize];
    ["Offset of field: SkuTable_t::FclkDpmDisallowPstateFreq"]
        [::core::mem::offset_of!(SkuTable_t, FclkDpmDisallowPstateFreq) - 1228usize];
    ["Offset of field: SkuTable_t::PaddingFclk"]
        [::core::mem::offset_of!(SkuTable_t, PaddingFclk) - 1230usize];
    ["Offset of field: SkuTable_t::PcieGenSpeed"]
        [::core::mem::offset_of!(SkuTable_t, PcieGenSpeed) - 1232usize];
    ["Offset of field: SkuTable_t::PcieLaneCount"]
        [::core::mem::offset_of!(SkuTable_t, PcieLaneCount) - 1235usize];
    ["Offset of field: SkuTable_t::LclkFreq"]
        [::core::mem::offset_of!(SkuTable_t, LclkFreq) - 1238usize];
    ["Offset of field: SkuTable_t::FanStopTemp"]
        [::core::mem::offset_of!(SkuTable_t, FanStopTemp) - 1244usize];
    ["Offset of field: SkuTable_t::FanStartTemp"]
        [::core::mem::offset_of!(SkuTable_t, FanStartTemp) - 1270usize];
    ["Offset of field: SkuTable_t::FanGain"]
        [::core::mem::offset_of!(SkuTable_t, FanGain) - 1296usize];
    ["Offset of field: SkuTable_t::FanGainPadding"]
        [::core::mem::offset_of!(SkuTable_t, FanGainPadding) - 1322usize];
    ["Offset of field: SkuTable_t::FanPwmMin"]
        [::core::mem::offset_of!(SkuTable_t, FanPwmMin) - 1324usize];
    ["Offset of field: SkuTable_t::AcousticTargetRpmThreshold"]
        [::core::mem::offset_of!(SkuTable_t, AcousticTargetRpmThreshold) - 1326usize];
    ["Offset of field: SkuTable_t::AcousticLimitRpmThreshold"]
        [::core::mem::offset_of!(SkuTable_t, AcousticLimitRpmThreshold) - 1328usize];
    ["Offset of field: SkuTable_t::FanMaximumRpm"]
        [::core::mem::offset_of!(SkuTable_t, FanMaximumRpm) - 1330usize];
    ["Offset of field: SkuTable_t::MGpuAcousticLimitRpmThreshold"]
        [::core::mem::offset_of!(SkuTable_t, MGpuAcousticLimitRpmThreshold) - 1332usize];
    ["Offset of field: SkuTable_t::FanTargetGfxclk"]
        [::core::mem::offset_of!(SkuTable_t, FanTargetGfxclk) - 1334usize];
    ["Offset of field: SkuTable_t::TempInputSelectMask"]
        [::core::mem::offset_of!(SkuTable_t, TempInputSelectMask) - 1336usize];
    ["Offset of field: SkuTable_t::FanZeroRpmEnable"]
        [::core::mem::offset_of!(SkuTable_t, FanZeroRpmEnable) - 1340usize];
    ["Offset of field: SkuTable_t::FanTachEdgePerRev"]
        [::core::mem::offset_of!(SkuTable_t, FanTachEdgePerRev) - 1341usize];
    ["Offset of field: SkuTable_t::FanTargetTemperature"]
        [::core::mem::offset_of!(SkuTable_t, FanTargetTemperature) - 1342usize];
    ["Offset of field: SkuTable_t::FuzzyFan_ErrorSetDelta"]
        [::core::mem::offset_of!(SkuTable_t, FuzzyFan_ErrorSetDelta) - 1368usize];
    ["Offset of field: SkuTable_t::FuzzyFan_ErrorRateSetDelta"]
        [::core::mem::offset_of!(SkuTable_t, FuzzyFan_ErrorRateSetDelta) - 1370usize];
    ["Offset of field: SkuTable_t::FuzzyFan_PwmSetDelta"]
        [::core::mem::offset_of!(SkuTable_t, FuzzyFan_PwmSetDelta) - 1372usize];
    ["Offset of field: SkuTable_t::FuzzyFan_Reserved"]
        [::core::mem::offset_of!(SkuTable_t, FuzzyFan_Reserved) - 1374usize];
    ["Offset of field: SkuTable_t::FwCtfLimit"]
        [::core::mem::offset_of!(SkuTable_t, FwCtfLimit) - 1376usize];
    ["Offset of field: SkuTable_t::IntakeTempEnableRPM"]
        [::core::mem::offset_of!(SkuTable_t, IntakeTempEnableRPM) - 1402usize];
    ["Offset of field: SkuTable_t::IntakeTempOffsetTemp"]
        [::core::mem::offset_of!(SkuTable_t, IntakeTempOffsetTemp) - 1404usize];
    ["Offset of field: SkuTable_t::IntakeTempReleaseTemp"]
        [::core::mem::offset_of!(SkuTable_t, IntakeTempReleaseTemp) - 1406usize];
    ["Offset of field: SkuTable_t::IntakeTempHighIntakeAcousticLimit"]
        [::core::mem::offset_of!(SkuTable_t, IntakeTempHighIntakeAcousticLimit) - 1408usize];
    ["Offset of field: SkuTable_t::IntakeTempAcouticLimitReleaseRate"]
        [::core::mem::offset_of!(SkuTable_t, IntakeTempAcouticLimitReleaseRate) - 1410usize];
    ["Offset of field: SkuTable_t::FanAbnormalTempLimitOffset"]
        [::core::mem::offset_of!(SkuTable_t, FanAbnormalTempLimitOffset) - 1412usize];
    ["Offset of field: SkuTable_t::FanStalledTriggerRpm"]
        [::core::mem::offset_of!(SkuTable_t, FanStalledTriggerRpm) - 1414usize];
    ["Offset of field: SkuTable_t::FanAbnormalTriggerRpmCoeff"]
        [::core::mem::offset_of!(SkuTable_t, FanAbnormalTriggerRpmCoeff) - 1416usize];
    ["Offset of field: SkuTable_t::FanAbnormalDetectionEnable"]
        [::core::mem::offset_of!(SkuTable_t, FanAbnormalDetectionEnable) - 1418usize];
    ["Offset of field: SkuTable_t::FanIntakeSensorSupport"]
        [::core::mem::offset_of!(SkuTable_t, FanIntakeSensorSupport) - 1420usize];
    ["Offset of field: SkuTable_t::FanIntakePadding"]
        [::core::mem::offset_of!(SkuTable_t, FanIntakePadding) - 1421usize];
    ["Offset of field: SkuTable_t::FanSpare"]
        [::core::mem::offset_of!(SkuTable_t, FanSpare) - 1424usize];
    ["Offset of field: SkuTable_t::OverrideGfxAvfsFuses"]
        [::core::mem::offset_of!(SkuTable_t, OverrideGfxAvfsFuses) - 1476usize];
    ["Offset of field: SkuTable_t::GfxAvfsPadding"]
        [::core::mem::offset_of!(SkuTable_t, GfxAvfsPadding) - 1477usize];
    ["Offset of field: SkuTable_t::L2HwRtAvfsFuses"]
        [::core::mem::offset_of!(SkuTable_t, L2HwRtAvfsFuses) - 1480usize];
    ["Offset of field: SkuTable_t::SeHwRtAvfsFuses"]
        [::core::mem::offset_of!(SkuTable_t, SeHwRtAvfsFuses) - 1608usize];
    ["Offset of field: SkuTable_t::CommonRtAvfs"]
        [::core::mem::offset_of!(SkuTable_t, CommonRtAvfs) - 1736usize];
    ["Offset of field: SkuTable_t::L2FwRtAvfsFuses"]
        [::core::mem::offset_of!(SkuTable_t, L2FwRtAvfsFuses) - 1788usize];
    ["Offset of field: SkuTable_t::SeFwRtAvfsFuses"]
        [::core::mem::offset_of!(SkuTable_t, SeFwRtAvfsFuses) - 1864usize];
    ["Offset of field: SkuTable_t::Droop_PWL_F"]
        [::core::mem::offset_of!(SkuTable_t, Droop_PWL_F) - 1940usize];
    ["Offset of field: SkuTable_t::Droop_PWL_a"]
        [::core::mem::offset_of!(SkuTable_t, Droop_PWL_a) - 1960usize];
    ["Offset of field: SkuTable_t::Droop_PWL_b"]
        [::core::mem::offset_of!(SkuTable_t, Droop_PWL_b) - 1980usize];
    ["Offset of field: SkuTable_t::Droop_PWL_c"]
        [::core::mem::offset_of!(SkuTable_t, Droop_PWL_c) - 2000usize];
    ["Offset of field: SkuTable_t::Static_PWL_Offset"]
        [::core::mem::offset_of!(SkuTable_t, Static_PWL_Offset) - 2020usize];
    ["Offset of field: SkuTable_t::dGbV_dT_vmin"]
        [::core::mem::offset_of!(SkuTable_t, dGbV_dT_vmin) - 2040usize];
    ["Offset of field: SkuTable_t::dGbV_dT_vmax"]
        [::core::mem::offset_of!(SkuTable_t, dGbV_dT_vmax) - 2044usize];
    ["Offset of field: SkuTable_t::V2F_vmin_range_low"]
        [::core::mem::offset_of!(SkuTable_t, V2F_vmin_range_low) - 2048usize];
    ["Offset of field: SkuTable_t::V2F_vmin_range_high"]
        [::core::mem::offset_of!(SkuTable_t, V2F_vmin_range_high) - 2052usize];
    ["Offset of field: SkuTable_t::V2F_vmax_range_low"]
        [::core::mem::offset_of!(SkuTable_t, V2F_vmax_range_low) - 2056usize];
    ["Offset of field: SkuTable_t::V2F_vmax_range_high"]
        [::core::mem::offset_of!(SkuTable_t, V2F_vmax_range_high) - 2060usize];
    ["Offset of field: SkuTable_t::DcBtcGfxParams"]
        [::core::mem::offset_of!(SkuTable_t, DcBtcGfxParams) - 2064usize];
    ["Offset of field: SkuTable_t::GfxAvfsSpare"]
        [::core::mem::offset_of!(SkuTable_t, GfxAvfsSpare) - 2084usize];
    ["Offset of field: SkuTable_t::OverrideSocAvfsFuses"]
        [::core::mem::offset_of!(SkuTable_t, OverrideSocAvfsFuses) - 2212usize];
    ["Offset of field: SkuTable_t::MinSocAvfsRevision"]
        [::core::mem::offset_of!(SkuTable_t, MinSocAvfsRevision) - 2213usize];
    ["Offset of field: SkuTable_t::SocAvfsPadding"]
        [::core::mem::offset_of!(SkuTable_t, SocAvfsPadding) - 2214usize];
    ["Offset of field: SkuTable_t::SocAvfsFuseOverride"]
        [::core::mem::offset_of!(SkuTable_t, SocAvfsFuseOverride) - 2216usize];
    ["Offset of field: SkuTable_t::dBtcGbSoc"]
        [::core::mem::offset_of!(SkuTable_t, dBtcGbSoc) - 2384usize];
    ["Offset of field: SkuTable_t::qAgingGb"]
        [::core::mem::offset_of!(SkuTable_t, qAgingGb) - 2420usize];
    ["Offset of field: SkuTable_t::qStaticVoltageOffset"]
        [::core::mem::offset_of!(SkuTable_t, qStaticVoltageOffset) - 2444usize];
    ["Offset of field: SkuTable_t::DcBtcSocParams"]
        [::core::mem::offset_of!(SkuTable_t, DcBtcSocParams) - 2480usize];
    ["Offset of field: SkuTable_t::SocAvfsSpare"]
        [::core::mem::offset_of!(SkuTable_t, SocAvfsSpare) - 2540usize];
    ["Offset of field: SkuTable_t::BootValues"]
        [::core::mem::offset_of!(SkuTable_t, BootValues) - 2668usize];
    ["Offset of field: SkuTable_t::DriverReportedClocks"]
        [::core::mem::offset_of!(SkuTable_t, DriverReportedClocks) - 2780usize];
    ["Offset of field: SkuTable_t::MsgLimits"]
        [::core::mem::offset_of!(SkuTable_t, MsgLimits) - 2808usize];
    ["Offset of field: SkuTable_t::OverDriveLimitsMin"]
        [::core::mem::offset_of!(SkuTable_t, OverDriveLimitsMin) - 2928usize];
    ["Offset of field: SkuTable_t::OverDriveLimitsBasicMax"]
        [::core::mem::offset_of!(SkuTable_t, OverDriveLimitsBasicMax) - 3016usize];
    ["Offset of field: SkuTable_t::reserved"]
        [::core::mem::offset_of!(SkuTable_t, reserved) - 3104usize];
    ["Offset of field: SkuTable_t::DebugOverrides"]
        [::core::mem::offset_of!(SkuTable_t, DebugOverrides) - 3192usize];
    ["Offset of field: SkuTable_t::TotalBoardPowerSupport"]
        [::core::mem::offset_of!(SkuTable_t, TotalBoardPowerSupport) - 3196usize];
    ["Offset of field: SkuTable_t::TotalBoardPowerPadding"]
        [::core::mem::offset_of!(SkuTable_t, TotalBoardPowerPadding) - 3197usize];
    ["Offset of field: SkuTable_t::TotalIdleBoardPowerM"]
        [::core::mem::offset_of!(SkuTable_t, TotalIdleBoardPowerM) - 3200usize];
    ["Offset of field: SkuTable_t::TotalIdleBoardPowerB"]
        [::core::mem::offset_of!(SkuTable_t, TotalIdleBoardPowerB) - 3202usize];
    ["Offset of field: SkuTable_t::TotalBoardPowerM"]
        [::core::mem::offset_of!(SkuTable_t, TotalBoardPowerM) - 3204usize];
    ["Offset of field: SkuTable_t::TotalBoardPowerB"]
        [::core::mem::offset_of!(SkuTable_t, TotalBoardPowerB) - 3206usize];
    ["Offset of field: SkuTable_t::qFeffCoeffGameClock"]
        [::core::mem::offset_of!(SkuTable_t, qFeffCoeffGameClock) - 3208usize];
    ["Offset of field: SkuTable_t::qFeffCoeffBaseClock"]
        [::core::mem::offset_of!(SkuTable_t, qFeffCoeffBaseClock) - 3232usize];
    ["Offset of field: SkuTable_t::qFeffCoeffBoostClock"]
        [::core::mem::offset_of!(SkuTable_t, qFeffCoeffBoostClock) - 3256usize];
    ["Offset of field: SkuTable_t::TemperatureLimit_Hynix"]
        [::core::mem::offset_of!(SkuTable_t, TemperatureLimit_Hynix) - 3280usize];
    ["Offset of field: SkuTable_t::TemperatureLimit_Micron"]
        [::core::mem::offset_of!(SkuTable_t, TemperatureLimit_Micron) - 3282usize];
    ["Offset of field: SkuTable_t::TemperatureFwCtfLimit_Hynix"]
        [::core::mem::offset_of!(SkuTable_t, TemperatureFwCtfLimit_Hynix) - 3284usize];
    ["Offset of field: SkuTable_t::TemperatureFwCtfLimit_Micron"]
        [::core::mem::offset_of!(SkuTable_t, TemperatureFwCtfLimit_Micron) - 3286usize];
    ["Offset of field: SkuTable_t::Spare"][::core::mem::offset_of!(SkuTable_t, Spare) - 3288usize];
    ["Offset of field: SkuTable_t::MmHubPadding"]
        [::core::mem::offset_of!(SkuTable_t, MmHubPadding) - 3452usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BoardTable_t {
    pub Version: u32,
    pub I2cControllers: [I2cControllerConfig_t; 8usize],
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub VmempUlvPhaseSheddingMask: u8,
    pub VddioUlvPhaseSheddingMask: u8,
    pub SlaveAddrMapping: [u8; 5usize],
    pub VrPsiSupport: [u8; 5usize],
    pub PaddingPsi: [u8; 5usize],
    pub EnablePsi6: [u8; 5usize],
    pub SviTelemetryScale: [SviTelemetryScale_t; 5usize],
    pub VoltageTelemetryRatio: [u32; 5usize],
    pub DownSlewRateVr: [u8; 5usize],
    pub LedOffGpio: u8,
    pub FanOffGpio: u8,
    pub GfxVrPowerStageOffGpio: u8,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub LedEnableMask: u8,
    pub LedPcie: u8,
    pub LedError: u8,
    pub UclkTrainingModeSpreadPercent: u8,
    pub UclkSpreadPadding: u8,
    pub UclkSpreadFreq: u16,
    pub UclkSpreadPercent: [u8; 16usize],
    pub GfxclkSpreadEnable: u8,
    pub FclkSpreadPercent: u8,
    pub FclkSpreadFreq: u16,
    pub DramWidth: u8,
    pub PaddingMem1: [u8; 7usize],
    pub HsrEnabled: u8,
    pub VddqOffEnabled: u8,
    pub PaddingUmcFlags: [u8; 2usize],
    pub PostVoltageSetBacoDelay: u32,
    pub BacoEntryDelay: u32,
    pub FuseWritePowerMuxPresent: u8,
    pub FuseWritePadding: [u8; 3usize],
    pub BoardSpare: [u32; 63usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of BoardTable_t"][::core::mem::size_of::<BoardTable_t>() - 488usize];
    ["Alignment of BoardTable_t"][::core::mem::align_of::<BoardTable_t>() - 4usize];
    ["Offset of field: BoardTable_t::Version"]
        [::core::mem::offset_of!(BoardTable_t, Version) - 0usize];
    ["Offset of field: BoardTable_t::I2cControllers"]
        [::core::mem::offset_of!(BoardTable_t, I2cControllers) - 4usize];
    ["Offset of field: BoardTable_t::VddGfxVrMapping"]
        [::core::mem::offset_of!(BoardTable_t, VddGfxVrMapping) - 68usize];
    ["Offset of field: BoardTable_t::VddSocVrMapping"]
        [::core::mem::offset_of!(BoardTable_t, VddSocVrMapping) - 69usize];
    ["Offset of field: BoardTable_t::VddMem0VrMapping"]
        [::core::mem::offset_of!(BoardTable_t, VddMem0VrMapping) - 70usize];
    ["Offset of field: BoardTable_t::VddMem1VrMapping"]
        [::core::mem::offset_of!(BoardTable_t, VddMem1VrMapping) - 71usize];
    ["Offset of field: BoardTable_t::GfxUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(BoardTable_t, GfxUlvPhaseSheddingMask) - 72usize];
    ["Offset of field: BoardTable_t::SocUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(BoardTable_t, SocUlvPhaseSheddingMask) - 73usize];
    ["Offset of field: BoardTable_t::VmempUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(BoardTable_t, VmempUlvPhaseSheddingMask) - 74usize];
    ["Offset of field: BoardTable_t::VddioUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(BoardTable_t, VddioUlvPhaseSheddingMask) - 75usize];
    ["Offset of field: BoardTable_t::SlaveAddrMapping"]
        [::core::mem::offset_of!(BoardTable_t, SlaveAddrMapping) - 76usize];
    ["Offset of field: BoardTable_t::VrPsiSupport"]
        [::core::mem::offset_of!(BoardTable_t, VrPsiSupport) - 81usize];
    ["Offset of field: BoardTable_t::PaddingPsi"]
        [::core::mem::offset_of!(BoardTable_t, PaddingPsi) - 86usize];
    ["Offset of field: BoardTable_t::EnablePsi6"]
        [::core::mem::offset_of!(BoardTable_t, EnablePsi6) - 91usize];
    ["Offset of field: BoardTable_t::SviTelemetryScale"]
        [::core::mem::offset_of!(BoardTable_t, SviTelemetryScale) - 96usize];
    ["Offset of field: BoardTable_t::VoltageTelemetryRatio"]
        [::core::mem::offset_of!(BoardTable_t, VoltageTelemetryRatio) - 116usize];
    ["Offset of field: BoardTable_t::DownSlewRateVr"]
        [::core::mem::offset_of!(BoardTable_t, DownSlewRateVr) - 136usize];
    ["Offset of field: BoardTable_t::LedOffGpio"]
        [::core::mem::offset_of!(BoardTable_t, LedOffGpio) - 141usize];
    ["Offset of field: BoardTable_t::FanOffGpio"]
        [::core::mem::offset_of!(BoardTable_t, FanOffGpio) - 142usize];
    ["Offset of field: BoardTable_t::GfxVrPowerStageOffGpio"]
        [::core::mem::offset_of!(BoardTable_t, GfxVrPowerStageOffGpio) - 143usize];
    ["Offset of field: BoardTable_t::AcDcGpio"]
        [::core::mem::offset_of!(BoardTable_t, AcDcGpio) - 144usize];
    ["Offset of field: BoardTable_t::AcDcPolarity"]
        [::core::mem::offset_of!(BoardTable_t, AcDcPolarity) - 145usize];
    ["Offset of field: BoardTable_t::VR0HotGpio"]
        [::core::mem::offset_of!(BoardTable_t, VR0HotGpio) - 146usize];
    ["Offset of field: BoardTable_t::VR0HotPolarity"]
        [::core::mem::offset_of!(BoardTable_t, VR0HotPolarity) - 147usize];
    ["Offset of field: BoardTable_t::GthrGpio"]
        [::core::mem::offset_of!(BoardTable_t, GthrGpio) - 148usize];
    ["Offset of field: BoardTable_t::GthrPolarity"]
        [::core::mem::offset_of!(BoardTable_t, GthrPolarity) - 149usize];
    ["Offset of field: BoardTable_t::LedPin0"]
        [::core::mem::offset_of!(BoardTable_t, LedPin0) - 150usize];
    ["Offset of field: BoardTable_t::LedPin1"]
        [::core::mem::offset_of!(BoardTable_t, LedPin1) - 151usize];
    ["Offset of field: BoardTable_t::LedPin2"]
        [::core::mem::offset_of!(BoardTable_t, LedPin2) - 152usize];
    ["Offset of field: BoardTable_t::LedEnableMask"]
        [::core::mem::offset_of!(BoardTable_t, LedEnableMask) - 153usize];
    ["Offset of field: BoardTable_t::LedPcie"]
        [::core::mem::offset_of!(BoardTable_t, LedPcie) - 154usize];
    ["Offset of field: BoardTable_t::LedError"]
        [::core::mem::offset_of!(BoardTable_t, LedError) - 155usize];
    ["Offset of field: BoardTable_t::UclkTrainingModeSpreadPercent"]
        [::core::mem::offset_of!(BoardTable_t, UclkTrainingModeSpreadPercent) - 156usize];
    ["Offset of field: BoardTable_t::UclkSpreadPadding"]
        [::core::mem::offset_of!(BoardTable_t, UclkSpreadPadding) - 157usize];
    ["Offset of field: BoardTable_t::UclkSpreadFreq"]
        [::core::mem::offset_of!(BoardTable_t, UclkSpreadFreq) - 158usize];
    ["Offset of field: BoardTable_t::UclkSpreadPercent"]
        [::core::mem::offset_of!(BoardTable_t, UclkSpreadPercent) - 160usize];
    ["Offset of field: BoardTable_t::GfxclkSpreadEnable"]
        [::core::mem::offset_of!(BoardTable_t, GfxclkSpreadEnable) - 176usize];
    ["Offset of field: BoardTable_t::FclkSpreadPercent"]
        [::core::mem::offset_of!(BoardTable_t, FclkSpreadPercent) - 177usize];
    ["Offset of field: BoardTable_t::FclkSpreadFreq"]
        [::core::mem::offset_of!(BoardTable_t, FclkSpreadFreq) - 178usize];
    ["Offset of field: BoardTable_t::DramWidth"]
        [::core::mem::offset_of!(BoardTable_t, DramWidth) - 180usize];
    ["Offset of field: BoardTable_t::PaddingMem1"]
        [::core::mem::offset_of!(BoardTable_t, PaddingMem1) - 181usize];
    ["Offset of field: BoardTable_t::HsrEnabled"]
        [::core::mem::offset_of!(BoardTable_t, HsrEnabled) - 188usize];
    ["Offset of field: BoardTable_t::VddqOffEnabled"]
        [::core::mem::offset_of!(BoardTable_t, VddqOffEnabled) - 189usize];
    ["Offset of field: BoardTable_t::PaddingUmcFlags"]
        [::core::mem::offset_of!(BoardTable_t, PaddingUmcFlags) - 190usize];
    ["Offset of field: BoardTable_t::PostVoltageSetBacoDelay"]
        [::core::mem::offset_of!(BoardTable_t, PostVoltageSetBacoDelay) - 192usize];
    ["Offset of field: BoardTable_t::BacoEntryDelay"]
        [::core::mem::offset_of!(BoardTable_t, BacoEntryDelay) - 196usize];
    ["Offset of field: BoardTable_t::FuseWritePowerMuxPresent"]
        [::core::mem::offset_of!(BoardTable_t, FuseWritePowerMuxPresent) - 200usize];
    ["Offset of field: BoardTable_t::FuseWritePadding"]
        [::core::mem::offset_of!(BoardTable_t, FuseWritePadding) - 201usize];
    ["Offset of field: BoardTable_t::BoardSpare"]
        [::core::mem::offset_of!(BoardTable_t, BoardSpare) - 204usize];
    ["Offset of field: BoardTable_t::MmHubPadding"]
        [::core::mem::offset_of!(BoardTable_t, MmHubPadding) - 456usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct PPTable_t {
    pub SkuTable: SkuTable_t,
    pub BoardTable: BoardTable_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of PPTable_t"][::core::mem::size_of::<PPTable_t>() - 3972usize];
    ["Alignment of PPTable_t"][::core::mem::align_of::<PPTable_t>() - 1usize];
    ["Offset of field: PPTable_t::SkuTable"][::core::mem::offset_of!(PPTable_t, SkuTable) - 0usize];
    ["Offset of field: PPTable_t::BoardTable"]
        [::core::mem::offset_of!(PPTable_t, BoardTable) - 3484usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DriverSmuConfig_t {
    pub GfxclkAverageLpfTau: u16,
    pub FclkAverageLpfTau: u16,
    pub UclkAverageLpfTau: u16,
    pub GfxActivityLpfTau: u16,
    pub UclkActivityLpfTau: u16,
    pub SocketPowerLpfTau: u16,
    pub VcnClkAverageLpfTau: u16,
    pub VcnUsageAverageLpfTau: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DriverSmuConfig_t"][::core::mem::size_of::<DriverSmuConfig_t>() - 16usize];
    ["Alignment of DriverSmuConfig_t"][::core::mem::align_of::<DriverSmuConfig_t>() - 2usize];
    ["Offset of field: DriverSmuConfig_t::GfxclkAverageLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, GfxclkAverageLpfTau) - 0usize];
    ["Offset of field: DriverSmuConfig_t::FclkAverageLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, FclkAverageLpfTau) - 2usize];
    ["Offset of field: DriverSmuConfig_t::UclkAverageLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, UclkAverageLpfTau) - 4usize];
    ["Offset of field: DriverSmuConfig_t::GfxActivityLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, GfxActivityLpfTau) - 6usize];
    ["Offset of field: DriverSmuConfig_t::UclkActivityLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, UclkActivityLpfTau) - 8usize];
    ["Offset of field: DriverSmuConfig_t::SocketPowerLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, SocketPowerLpfTau) - 10usize];
    ["Offset of field: DriverSmuConfig_t::VcnClkAverageLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, VcnClkAverageLpfTau) - 12usize];
    ["Offset of field: DriverSmuConfig_t::VcnUsageAverageLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, VcnUsageAverageLpfTau) - 14usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DriverSmuConfigExternal_t {
    pub DriverSmuConfig: DriverSmuConfig_t,
    pub Spare: [u32; 8usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DriverSmuConfigExternal_t"]
        [::core::mem::size_of::<DriverSmuConfigExternal_t>() - 80usize];
    ["Alignment of DriverSmuConfigExternal_t"]
        [::core::mem::align_of::<DriverSmuConfigExternal_t>() - 4usize];
    ["Offset of field: DriverSmuConfigExternal_t::DriverSmuConfig"]
        [::core::mem::offset_of!(DriverSmuConfigExternal_t, DriverSmuConfig) - 0usize];
    ["Offset of field: DriverSmuConfigExternal_t::Spare"]
        [::core::mem::offset_of!(DriverSmuConfigExternal_t, Spare) - 16usize];
    ["Offset of field: DriverSmuConfigExternal_t::MmHubPadding"]
        [::core::mem::offset_of!(DriverSmuConfigExternal_t, MmHubPadding) - 48usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DriverInfoTable_t {
    pub FreqTableGfx: [u16; 16usize],
    pub FreqTableVclk: [u16; 8usize],
    pub FreqTableDclk: [u16; 8usize],
    pub FreqTableSocclk: [u16; 8usize],
    pub FreqTableUclk: [u16; 4usize],
    pub FreqTableDispclk: [u16; 8usize],
    pub FreqTableDppClk: [u16; 8usize],
    pub FreqTableDprefclk: [u16; 8usize],
    pub FreqTableDcfclk: [u16; 8usize],
    pub FreqTableDtbclk: [u16; 8usize],
    pub FreqTableFclk: [u16; 8usize],
    pub DcModeMaxFreq: [u16; 13usize],
    pub Padding: u16,
    pub Spare: [u32; 32usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DriverInfoTable_t"][::core::mem::size_of::<DriverInfoTable_t>() - 372usize];
    ["Alignment of DriverInfoTable_t"][::core::mem::align_of::<DriverInfoTable_t>() - 4usize];
    ["Offset of field: DriverInfoTable_t::FreqTableGfx"]
        [::core::mem::offset_of!(DriverInfoTable_t, FreqTableGfx) - 0usize];
    ["Offset of field: DriverInfoTable_t::FreqTableVclk"]
        [::core::mem::offset_of!(DriverInfoTable_t, FreqTableVclk) - 32usize];
    ["Offset of field: DriverInfoTable_t::FreqTableDclk"]
        [::core::mem::offset_of!(DriverInfoTable_t, FreqTableDclk) - 48usize];
    ["Offset of field: DriverInfoTable_t::FreqTableSocclk"]
        [::core::mem::offset_of!(DriverInfoTable_t, FreqTableSocclk) - 64usize];
    ["Offset of field: DriverInfoTable_t::FreqTableUclk"]
        [::core::mem::offset_of!(DriverInfoTable_t, FreqTableUclk) - 80usize];
    ["Offset of field: DriverInfoTable_t::FreqTableDispclk"]
        [::core::mem::offset_of!(DriverInfoTable_t, FreqTableDispclk) - 88usize];
    ["Offset of field: DriverInfoTable_t::FreqTableDppClk"]
        [::core::mem::offset_of!(DriverInfoTable_t, FreqTableDppClk) - 104usize];
    ["Offset of field: DriverInfoTable_t::FreqTableDprefclk"]
        [::core::mem::offset_of!(DriverInfoTable_t, FreqTableDprefclk) - 120usize];
    ["Offset of field: DriverInfoTable_t::FreqTableDcfclk"]
        [::core::mem::offset_of!(DriverInfoTable_t, FreqTableDcfclk) - 136usize];
    ["Offset of field: DriverInfoTable_t::FreqTableDtbclk"]
        [::core::mem::offset_of!(DriverInfoTable_t, FreqTableDtbclk) - 152usize];
    ["Offset of field: DriverInfoTable_t::FreqTableFclk"]
        [::core::mem::offset_of!(DriverInfoTable_t, FreqTableFclk) - 168usize];
    ["Offset of field: DriverInfoTable_t::DcModeMaxFreq"]
        [::core::mem::offset_of!(DriverInfoTable_t, DcModeMaxFreq) - 184usize];
    ["Offset of field: DriverInfoTable_t::Padding"]
        [::core::mem::offset_of!(DriverInfoTable_t, Padding) - 210usize];
    ["Offset of field: DriverInfoTable_t::Spare"]
        [::core::mem::offset_of!(DriverInfoTable_t, Spare) - 212usize];
    ["Offset of field: DriverInfoTable_t::MmHubPadding"]
        [::core::mem::offset_of!(DriverInfoTable_t, MmHubPadding) - 340usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SmuMetrics_t {
    pub CurrClock: [u32; 13usize],
    pub AverageGfxclkFrequencyTarget: u16,
    pub AverageGfxclkFrequencyPreDs: u16,
    pub AverageGfxclkFrequencyPostDs: u16,
    pub AverageFclkFrequencyPreDs: u16,
    pub AverageFclkFrequencyPostDs: u16,
    pub AverageMemclkFrequencyPreDs: u16,
    pub AverageMemclkFrequencyPostDs: u16,
    pub AverageVclk0Frequency: u16,
    pub AverageDclk0Frequency: u16,
    pub AverageVclk1Frequency: u16,
    pub AverageDclk1Frequency: u16,
    pub PCIeBusy: u16,
    pub dGPU_W_MAX: u16,
    pub padding: u16,
    pub MetricsCounter: u32,
    pub AvgVoltage: [u16; 5usize],
    pub AvgCurrent: [u16; 5usize],
    pub AverageGfxActivity: u16,
    pub AverageUclkActivity: u16,
    pub Vcn0ActivityPercentage: u16,
    pub Vcn1ActivityPercentage: u16,
    pub EnergyAccumulator: u32,
    pub AverageSocketPower: u16,
    pub AverageTotalBoardPower: u16,
    pub AvgTemperature: [u16; 13usize],
    pub AvgTemperatureFanIntake: u16,
    pub PcieRate: u8,
    pub PcieWidth: u8,
    pub AvgFanPwm: u8,
    pub Padding: [u8; 1usize],
    pub AvgFanRpm: u16,
    pub ThrottlingPercentage: [u8; 22usize],
    pub VmaxThrottlingPercentage: u8,
    pub Padding1: [u8; 3usize],
    pub D3HotEntryCountPerMode: [u32; 4usize],
    pub D3HotExitCountPerMode: [u32; 4usize],
    pub ArmMsgReceivedCountPerMode: [u32; 4usize],
    pub ApuSTAPMSmartShiftLimit: u16,
    pub ApuSTAPMLimit: u16,
    pub AvgApuSocketPower: u16,
    pub AverageUclkActivity_MAX: u16,
    pub PublicSerialNumberLower: u32,
    pub PublicSerialNumberUpper: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SmuMetrics_t"][::core::mem::size_of::<SmuMetrics_t>() - 244usize];
    ["Alignment of SmuMetrics_t"][::core::mem::align_of::<SmuMetrics_t>() - 4usize];
    ["Offset of field: SmuMetrics_t::CurrClock"]
        [::core::mem::offset_of!(SmuMetrics_t, CurrClock) - 0usize];
    ["Offset of field: SmuMetrics_t::AverageGfxclkFrequencyTarget"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageGfxclkFrequencyTarget) - 52usize];
    ["Offset of field: SmuMetrics_t::AverageGfxclkFrequencyPreDs"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageGfxclkFrequencyPreDs) - 54usize];
    ["Offset of field: SmuMetrics_t::AverageGfxclkFrequencyPostDs"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageGfxclkFrequencyPostDs) - 56usize];
    ["Offset of field: SmuMetrics_t::AverageFclkFrequencyPreDs"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageFclkFrequencyPreDs) - 58usize];
    ["Offset of field: SmuMetrics_t::AverageFclkFrequencyPostDs"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageFclkFrequencyPostDs) - 60usize];
    ["Offset of field: SmuMetrics_t::AverageMemclkFrequencyPreDs"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageMemclkFrequencyPreDs) - 62usize];
    ["Offset of field: SmuMetrics_t::AverageMemclkFrequencyPostDs"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageMemclkFrequencyPostDs) - 64usize];
    ["Offset of field: SmuMetrics_t::AverageVclk0Frequency"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageVclk0Frequency) - 66usize];
    ["Offset of field: SmuMetrics_t::AverageDclk0Frequency"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageDclk0Frequency) - 68usize];
    ["Offset of field: SmuMetrics_t::AverageVclk1Frequency"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageVclk1Frequency) - 70usize];
    ["Offset of field: SmuMetrics_t::AverageDclk1Frequency"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageDclk1Frequency) - 72usize];
    ["Offset of field: SmuMetrics_t::PCIeBusy"]
        [::core::mem::offset_of!(SmuMetrics_t, PCIeBusy) - 74usize];
    ["Offset of field: SmuMetrics_t::dGPU_W_MAX"]
        [::core::mem::offset_of!(SmuMetrics_t, dGPU_W_MAX) - 76usize];
    ["Offset of field: SmuMetrics_t::padding"]
        [::core::mem::offset_of!(SmuMetrics_t, padding) - 78usize];
    ["Offset of field: SmuMetrics_t::MetricsCounter"]
        [::core::mem::offset_of!(SmuMetrics_t, MetricsCounter) - 80usize];
    ["Offset of field: SmuMetrics_t::AvgVoltage"]
        [::core::mem::offset_of!(SmuMetrics_t, AvgVoltage) - 84usize];
    ["Offset of field: SmuMetrics_t::AvgCurrent"]
        [::core::mem::offset_of!(SmuMetrics_t, AvgCurrent) - 94usize];
    ["Offset of field: SmuMetrics_t::AverageGfxActivity"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageGfxActivity) - 104usize];
    ["Offset of field: SmuMetrics_t::AverageUclkActivity"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageUclkActivity) - 106usize];
    ["Offset of field: SmuMetrics_t::Vcn0ActivityPercentage"]
        [::core::mem::offset_of!(SmuMetrics_t, Vcn0ActivityPercentage) - 108usize];
    ["Offset of field: SmuMetrics_t::Vcn1ActivityPercentage"]
        [::core::mem::offset_of!(SmuMetrics_t, Vcn1ActivityPercentage) - 110usize];
    ["Offset of field: SmuMetrics_t::EnergyAccumulator"]
        [::core::mem::offset_of!(SmuMetrics_t, EnergyAccumulator) - 112usize];
    ["Offset of field: SmuMetrics_t::AverageSocketPower"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageSocketPower) - 116usize];
    ["Offset of field: SmuMetrics_t::AverageTotalBoardPower"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageTotalBoardPower) - 118usize];
    ["Offset of field: SmuMetrics_t::AvgTemperature"]
        [::core::mem::offset_of!(SmuMetrics_t, AvgTemperature) - 120usize];
    ["Offset of field: SmuMetrics_t::AvgTemperatureFanIntake"]
        [::core::mem::offset_of!(SmuMetrics_t, AvgTemperatureFanIntake) - 146usize];
    ["Offset of field: SmuMetrics_t::PcieRate"]
        [::core::mem::offset_of!(SmuMetrics_t, PcieRate) - 148usize];
    ["Offset of field: SmuMetrics_t::PcieWidth"]
        [::core::mem::offset_of!(SmuMetrics_t, PcieWidth) - 149usize];
    ["Offset of field: SmuMetrics_t::AvgFanPwm"]
        [::core::mem::offset_of!(SmuMetrics_t, AvgFanPwm) - 150usize];
    ["Offset of field: SmuMetrics_t::Padding"]
        [::core::mem::offset_of!(SmuMetrics_t, Padding) - 151usize];
    ["Offset of field: SmuMetrics_t::AvgFanRpm"]
        [::core::mem::offset_of!(SmuMetrics_t, AvgFanRpm) - 152usize];
    ["Offset of field: SmuMetrics_t::ThrottlingPercentage"]
        [::core::mem::offset_of!(SmuMetrics_t, ThrottlingPercentage) - 154usize];
    ["Offset of field: SmuMetrics_t::VmaxThrottlingPercentage"]
        [::core::mem::offset_of!(SmuMetrics_t, VmaxThrottlingPercentage) - 176usize];
    ["Offset of field: SmuMetrics_t::Padding1"]
        [::core::mem::offset_of!(SmuMetrics_t, Padding1) - 177usize];
    ["Offset of field: SmuMetrics_t::D3HotEntryCountPerMode"]
        [::core::mem::offset_of!(SmuMetrics_t, D3HotEntryCountPerMode) - 180usize];
    ["Offset of field: SmuMetrics_t::D3HotExitCountPerMode"]
        [::core::mem::offset_of!(SmuMetrics_t, D3HotExitCountPerMode) - 196usize];
    ["Offset of field: SmuMetrics_t::ArmMsgReceivedCountPerMode"]
        [::core::mem::offset_of!(SmuMetrics_t, ArmMsgReceivedCountPerMode) - 212usize];
    ["Offset of field: SmuMetrics_t::ApuSTAPMSmartShiftLimit"]
        [::core::mem::offset_of!(SmuMetrics_t, ApuSTAPMSmartShiftLimit) - 228usize];
    ["Offset of field: SmuMetrics_t::ApuSTAPMLimit"]
        [::core::mem::offset_of!(SmuMetrics_t, ApuSTAPMLimit) - 230usize];
    ["Offset of field: SmuMetrics_t::AvgApuSocketPower"]
        [::core::mem::offset_of!(SmuMetrics_t, AvgApuSocketPower) - 232usize];
    ["Offset of field: SmuMetrics_t::AverageUclkActivity_MAX"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageUclkActivity_MAX) - 234usize];
    ["Offset of field: SmuMetrics_t::PublicSerialNumberLower"]
        [::core::mem::offset_of!(SmuMetrics_t, PublicSerialNumberLower) - 236usize];
    ["Offset of field: SmuMetrics_t::PublicSerialNumberUpper"]
        [::core::mem::offset_of!(SmuMetrics_t, PublicSerialNumberUpper) - 240usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SmuMetricsExternal_t {
    pub SmuMetrics: SmuMetrics_t,
    pub Spare: [u32; 29usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SmuMetricsExternal_t"][::core::mem::size_of::<SmuMetricsExternal_t>() - 392usize];
    ["Alignment of SmuMetricsExternal_t"][::core::mem::align_of::<SmuMetricsExternal_t>() - 4usize];
    ["Offset of field: SmuMetricsExternal_t::SmuMetrics"]
        [::core::mem::offset_of!(SmuMetricsExternal_t, SmuMetrics) - 0usize];
    ["Offset of field: SmuMetricsExternal_t::Spare"]
        [::core::mem::offset_of!(SmuMetricsExternal_t, Spare) - 244usize];
    ["Offset of field: SmuMetricsExternal_t::MmHubPadding"]
        [::core::mem::offset_of!(SmuMetricsExternal_t, MmHubPadding) - 360usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WatermarkRowGeneric_t {
    pub WmSetting: u8,
    pub Flags: u8,
    pub Padding: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of WatermarkRowGeneric_t"][::core::mem::size_of::<WatermarkRowGeneric_t>() - 4usize];
    ["Alignment of WatermarkRowGeneric_t"]
        [::core::mem::align_of::<WatermarkRowGeneric_t>() - 1usize];
    ["Offset of field: WatermarkRowGeneric_t::WmSetting"]
        [::core::mem::offset_of!(WatermarkRowGeneric_t, WmSetting) - 0usize];
    ["Offset of field: WatermarkRowGeneric_t::Flags"]
        [::core::mem::offset_of!(WatermarkRowGeneric_t, Flags) - 1usize];
    ["Offset of field: WatermarkRowGeneric_t::Padding"]
        [::core::mem::offset_of!(WatermarkRowGeneric_t, Padding) - 2usize];
};
pub const WATERMARKS_FLAGS_e_WATERMARKS_CLOCK_RANGE: WATERMARKS_FLAGS_e = 0;
pub const WATERMARKS_FLAGS_e_WATERMARKS_DUMMY_PSTATE: WATERMARKS_FLAGS_e = 1;
pub const WATERMARKS_FLAGS_e_WATERMARKS_MALL: WATERMARKS_FLAGS_e = 2;
pub const WATERMARKS_FLAGS_e_WATERMARKS_COUNT: WATERMARKS_FLAGS_e = 3;
pub type WATERMARKS_FLAGS_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Watermarks_t {
    pub WatermarkRow: [WatermarkRowGeneric_t; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of Watermarks_t"][::core::mem::size_of::<Watermarks_t>() - 16usize];
    ["Alignment of Watermarks_t"][::core::mem::align_of::<Watermarks_t>() - 1usize];
    ["Offset of field: Watermarks_t::WatermarkRow"]
        [::core::mem::offset_of!(Watermarks_t, WatermarkRow) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WatermarksExternal_t {
    pub Watermarks: Watermarks_t,
    pub Spare: [u32; 16usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of WatermarksExternal_t"][::core::mem::size_of::<WatermarksExternal_t>() - 112usize];
    ["Alignment of WatermarksExternal_t"][::core::mem::align_of::<WatermarksExternal_t>() - 4usize];
    ["Offset of field: WatermarksExternal_t::Watermarks"]
        [::core::mem::offset_of!(WatermarksExternal_t, Watermarks) - 0usize];
    ["Offset of field: WatermarksExternal_t::Spare"]
        [::core::mem::offset_of!(WatermarksExternal_t, Spare) - 16usize];
    ["Offset of field: WatermarksExternal_t::MmHubPadding"]
        [::core::mem::offset_of!(WatermarksExternal_t, MmHubPadding) - 80usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AvfsDebugTable_t {
    pub avgPsmCount: [u16; 214usize],
    pub minPsmCount: [u16; 214usize],
    pub avgPsmVoltage: [f32; 214usize],
    pub minPsmVoltage: [f32; 214usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AvfsDebugTable_t"][::core::mem::size_of::<AvfsDebugTable_t>() - 2568usize];
    ["Alignment of AvfsDebugTable_t"][::core::mem::align_of::<AvfsDebugTable_t>() - 4usize];
    ["Offset of field: AvfsDebugTable_t::avgPsmCount"]
        [::core::mem::offset_of!(AvfsDebugTable_t, avgPsmCount) - 0usize];
    ["Offset of field: AvfsDebugTable_t::minPsmCount"]
        [::core::mem::offset_of!(AvfsDebugTable_t, minPsmCount) - 428usize];
    ["Offset of field: AvfsDebugTable_t::avgPsmVoltage"]
        [::core::mem::offset_of!(AvfsDebugTable_t, avgPsmVoltage) - 856usize];
    ["Offset of field: AvfsDebugTable_t::minPsmVoltage"]
        [::core::mem::offset_of!(AvfsDebugTable_t, minPsmVoltage) - 1712usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AvfsDebugTableExternal_t {
    pub AvfsDebugTable: AvfsDebugTable_t,
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AvfsDebugTableExternal_t"]
        [::core::mem::size_of::<AvfsDebugTableExternal_t>() - 2600usize];
    ["Alignment of AvfsDebugTableExternal_t"]
        [::core::mem::align_of::<AvfsDebugTableExternal_t>() - 4usize];
    ["Offset of field: AvfsDebugTableExternal_t::AvfsDebugTable"]
        [::core::mem::offset_of!(AvfsDebugTableExternal_t, AvfsDebugTable) - 0usize];
    ["Offset of field: AvfsDebugTableExternal_t::MmHubPadding"]
        [::core::mem::offset_of!(AvfsDebugTableExternal_t, MmHubPadding) - 2568usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DpmActivityMonitorCoeffInt_t {
    pub Gfx_ActiveHystLimit: u8,
    pub Gfx_IdleHystLimit: u8,
    pub Gfx_FPS: u8,
    pub Gfx_MinActiveFreqType: u8,
    pub Gfx_BoosterFreqType: u8,
    pub PaddingGfx: u8,
    pub Gfx_MinActiveFreq: u16,
    pub Gfx_BoosterFreq: u16,
    pub Gfx_PD_Data_time_constant: u16,
    pub Gfx_PD_Data_limit_a: u32,
    pub Gfx_PD_Data_limit_b: u32,
    pub Gfx_PD_Data_limit_c: u32,
    pub Gfx_PD_Data_error_coeff: u32,
    pub Gfx_PD_Data_error_rate_coeff: u32,
    pub Fclk_ActiveHystLimit: u8,
    pub Fclk_IdleHystLimit: u8,
    pub Fclk_FPS: u8,
    pub Fclk_MinActiveFreqType: u8,
    pub Fclk_BoosterFreqType: u8,
    pub PaddingFclk: u8,
    pub Fclk_MinActiveFreq: u16,
    pub Fclk_BoosterFreq: u16,
    pub Fclk_PD_Data_time_constant: u16,
    pub Fclk_PD_Data_limit_a: u32,
    pub Fclk_PD_Data_limit_b: u32,
    pub Fclk_PD_Data_limit_c: u32,
    pub Fclk_PD_Data_error_coeff: u32,
    pub Fclk_PD_Data_error_rate_coeff: u32,
    pub Mem_UpThreshold_Limit: [u32; 4usize],
    pub Mem_UpHystLimit: [u8; 4usize],
    pub Mem_DownHystLimit: [u8; 4usize],
    pub Mem_Fps: u16,
    pub padding: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DpmActivityMonitorCoeffInt_t"]
        [::core::mem::size_of::<DpmActivityMonitorCoeffInt_t>() - 92usize];
    ["Alignment of DpmActivityMonitorCoeffInt_t"]
        [::core::mem::align_of::<DpmActivityMonitorCoeffInt_t>() - 4usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_ActiveHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_ActiveHystLimit) - 0usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_IdleHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_IdleHystLimit) - 1usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_FPS"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_FPS) - 2usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_MinActiveFreqType"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_MinActiveFreqType) - 3usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_BoosterFreqType"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_BoosterFreqType) - 4usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::PaddingGfx"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, PaddingGfx) - 5usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_MinActiveFreq"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_MinActiveFreq) - 6usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_BoosterFreq"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_BoosterFreq) - 8usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_PD_Data_time_constant"][::core::mem::offset_of!(
        DpmActivityMonitorCoeffInt_t,
        Gfx_PD_Data_time_constant
    ) - 10usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_PD_Data_limit_a"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_PD_Data_limit_a) - 12usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_PD_Data_limit_b"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_PD_Data_limit_b) - 16usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_PD_Data_limit_c"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_PD_Data_limit_c) - 20usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_PD_Data_error_coeff"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_PD_Data_error_coeff) - 24usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_PD_Data_error_rate_coeff"][::core::mem::offset_of!(
        DpmActivityMonitorCoeffInt_t,
        Gfx_PD_Data_error_rate_coeff
    ) - 28usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_ActiveHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Fclk_ActiveHystLimit) - 32usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_IdleHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Fclk_IdleHystLimit) - 33usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_FPS"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Fclk_FPS) - 34usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_MinActiveFreqType"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Fclk_MinActiveFreqType) - 35usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_BoosterFreqType"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Fclk_BoosterFreqType) - 36usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::PaddingFclk"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, PaddingFclk) - 37usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_MinActiveFreq"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Fclk_MinActiveFreq) - 38usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_BoosterFreq"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Fclk_BoosterFreq) - 40usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_PD_Data_time_constant"][::core::mem::offset_of!(
        DpmActivityMonitorCoeffInt_t,
        Fclk_PD_Data_time_constant
    ) - 42usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_PD_Data_limit_a"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Fclk_PD_Data_limit_a) - 44usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_PD_Data_limit_b"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Fclk_PD_Data_limit_b) - 48usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_PD_Data_limit_c"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Fclk_PD_Data_limit_c) - 52usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_PD_Data_error_coeff"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Fclk_PD_Data_error_coeff) - 56usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Fclk_PD_Data_error_rate_coeff"][::core::mem::offset_of!(
        DpmActivityMonitorCoeffInt_t,
        Fclk_PD_Data_error_rate_coeff
    ) - 60usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_UpThreshold_Limit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_UpThreshold_Limit) - 64usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_UpHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_UpHystLimit) - 80usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_DownHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_DownHystLimit) - 84usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_Fps"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_Fps) - 88usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::padding"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, padding) - 90usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DpmActivityMonitorCoeffIntExternal_t {
    pub DpmActivityMonitorCoeffInt: DpmActivityMonitorCoeffInt_t,
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DpmActivityMonitorCoeffIntExternal_t"]
        [::core::mem::size_of::<DpmActivityMonitorCoeffIntExternal_t>() - 124usize];
    ["Alignment of DpmActivityMonitorCoeffIntExternal_t"]
        [::core::mem::align_of::<DpmActivityMonitorCoeffIntExternal_t>() - 4usize];
    ["Offset of field: DpmActivityMonitorCoeffIntExternal_t::DpmActivityMonitorCoeffInt"][::core::mem::offset_of!(
        DpmActivityMonitorCoeffIntExternal_t,
        DpmActivityMonitorCoeffInt
    )
        - 0usize];
    ["Offset of field: DpmActivityMonitorCoeffIntExternal_t::MmHubPadding"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffIntExternal_t, MmHubPadding) - 92usize];
};
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_GFXCLK_LIMITS: SMU_13_0_0_ODFEATURE_CAP = 0;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_UCLK_LIMITS: SMU_13_0_0_ODFEATURE_CAP = 1;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_POWER_LIMIT: SMU_13_0_0_ODFEATURE_CAP = 2;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_FAN_ACOUSTIC_LIMIT: SMU_13_0_0_ODFEATURE_CAP =
    3;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_FAN_SPEED_MIN: SMU_13_0_0_ODFEATURE_CAP = 4;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_TEMPERATURE_FAN: SMU_13_0_0_ODFEATURE_CAP = 5;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_TEMPERATURE_SYSTEM: SMU_13_0_0_ODFEATURE_CAP =
    6;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_MEMORY_TIMING_TUNE: SMU_13_0_0_ODFEATURE_CAP =
    7;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_FAN_ZERO_RPM_CONTROL: SMU_13_0_0_ODFEATURE_CAP =
    8;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_AUTO_UV_ENGINE: SMU_13_0_0_ODFEATURE_CAP = 9;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_AUTO_OC_ENGINE: SMU_13_0_0_ODFEATURE_CAP = 10;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_AUTO_OC_MEMORY: SMU_13_0_0_ODFEATURE_CAP = 11;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_FAN_CURVE: SMU_13_0_0_ODFEATURE_CAP = 12;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_AUTO_FAN_ACOUSTIC_LIMIT:
    SMU_13_0_0_ODFEATURE_CAP = 13;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_POWER_MODE: SMU_13_0_0_ODFEATURE_CAP = 14;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_PER_ZONE_GFX_VOLTAGE_OFFSET:
    SMU_13_0_0_ODFEATURE_CAP = 15;
pub const SMU_13_0_0_ODFEATURE_CAP_SMU_13_0_0_ODCAP_COUNT: SMU_13_0_0_ODFEATURE_CAP = 16;
pub type SMU_13_0_0_ODFEATURE_CAP = ::core::ffi::c_uint;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_GFXCLK_LIMITS: SMU_13_0_0_ODFEATURE_ID = 1;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_UCLK_LIMITS: SMU_13_0_0_ODFEATURE_ID = 2;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_POWER_LIMIT: SMU_13_0_0_ODFEATURE_ID = 4;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_FAN_ACOUSTIC_LIMIT: SMU_13_0_0_ODFEATURE_ID =
    8;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_FAN_SPEED_MIN: SMU_13_0_0_ODFEATURE_ID = 16;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_TEMPERATURE_FAN: SMU_13_0_0_ODFEATURE_ID =
    32;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_TEMPERATURE_SYSTEM: SMU_13_0_0_ODFEATURE_ID =
    64;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_MEMORY_TIMING_TUNE: SMU_13_0_0_ODFEATURE_ID =
    128;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_FAN_ZERO_RPM_CONTROL:
    SMU_13_0_0_ODFEATURE_ID = 256;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_AUTO_UV_ENGINE: SMU_13_0_0_ODFEATURE_ID =
    512;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_AUTO_OC_ENGINE: SMU_13_0_0_ODFEATURE_ID =
    1024;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_AUTO_OC_MEMORY: SMU_13_0_0_ODFEATURE_ID =
    2048;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_FAN_CURVE: SMU_13_0_0_ODFEATURE_ID = 4096;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_AUTO_FAN_ACOUSTIC_LIMIT:
    SMU_13_0_0_ODFEATURE_ID = 8192;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_POWER_MODE: SMU_13_0_0_ODFEATURE_ID = 16384;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_PER_ZONE_GFX_VOLTAGE_OFFSET:
    SMU_13_0_0_ODFEATURE_ID = 32768;
pub const SMU_13_0_0_ODFEATURE_ID_SMU_13_0_0_ODFEATURE_COUNT: SMU_13_0_0_ODFEATURE_ID = 16;
pub type SMU_13_0_0_ODFEATURE_ID = ::core::ffi::c_uint;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_GFXCLKFMAX: SMU_13_0_0_ODSETTING_ID = 0;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_GFXCLKFMIN: SMU_13_0_0_ODSETTING_ID = 1;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_UCLKFMIN: SMU_13_0_0_ODSETTING_ID = 2;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_UCLKFMAX: SMU_13_0_0_ODSETTING_ID = 3;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_POWERPERCENTAGE: SMU_13_0_0_ODSETTING_ID = 4;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FANRPMMIN: SMU_13_0_0_ODSETTING_ID = 5;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FANRPMACOUSTICLIMIT:
    SMU_13_0_0_ODSETTING_ID = 6;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FANTARGETTEMPERATURE:
    SMU_13_0_0_ODSETTING_ID = 7;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_OPERATINGTEMPMAX: SMU_13_0_0_ODSETTING_ID =
    8;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_ACTIMING: SMU_13_0_0_ODSETTING_ID = 9;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FAN_ZERO_RPM_CONTROL:
    SMU_13_0_0_ODSETTING_ID = 10;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_AUTOUVENGINE: SMU_13_0_0_ODSETTING_ID = 11;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_AUTOOCENGINE: SMU_13_0_0_ODSETTING_ID = 12;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_AUTOOCMEMORY: SMU_13_0_0_ODSETTING_ID = 13;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FAN_CURVE_TEMPERATURE_1:
    SMU_13_0_0_ODSETTING_ID = 14;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FAN_CURVE_SPEED_1: SMU_13_0_0_ODSETTING_ID =
    15;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FAN_CURVE_TEMPERATURE_2:
    SMU_13_0_0_ODSETTING_ID = 16;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FAN_CURVE_SPEED_2: SMU_13_0_0_ODSETTING_ID =
    17;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FAN_CURVE_TEMPERATURE_3:
    SMU_13_0_0_ODSETTING_ID = 18;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FAN_CURVE_SPEED_3: SMU_13_0_0_ODSETTING_ID =
    19;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FAN_CURVE_TEMPERATURE_4:
    SMU_13_0_0_ODSETTING_ID = 20;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FAN_CURVE_SPEED_4: SMU_13_0_0_ODSETTING_ID =
    21;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FAN_CURVE_TEMPERATURE_5:
    SMU_13_0_0_ODSETTING_ID = 22;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_FAN_CURVE_SPEED_5: SMU_13_0_0_ODSETTING_ID =
    23;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_AUTO_FAN_ACOUSTIC_LIMIT:
    SMU_13_0_0_ODSETTING_ID = 24;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_POWER_MODE: SMU_13_0_0_ODSETTING_ID = 25;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_PER_ZONE_GFX_VOLTAGE_OFFSET_POINT_1:
    SMU_13_0_0_ODSETTING_ID = 26;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_PER_ZONE_GFX_VOLTAGE_OFFSET_POINT_2:
    SMU_13_0_0_ODSETTING_ID = 27;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_PER_ZONE_GFX_VOLTAGE_OFFSET_POINT_3:
    SMU_13_0_0_ODSETTING_ID = 28;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_PER_ZONE_GFX_VOLTAGE_OFFSET_POINT_4:
    SMU_13_0_0_ODSETTING_ID = 29;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_PER_ZONE_GFX_VOLTAGE_OFFSET_POINT_5:
    SMU_13_0_0_ODSETTING_ID = 30;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_PER_ZONE_GFX_VOLTAGE_OFFSET_POINT_6:
    SMU_13_0_0_ODSETTING_ID = 31;
pub const SMU_13_0_0_ODSETTING_ID_SMU_13_0_0_ODSETTING_COUNT: SMU_13_0_0_ODSETTING_ID = 32;
pub type SMU_13_0_0_ODSETTING_ID = ::core::ffi::c_uint;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_POWER_LIMIT_QUIET:
    SMU_13_0_0_PWRMODE_SETTING = 0;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_POWER_LIMIT_BALANCE:
    SMU_13_0_0_PWRMODE_SETTING = 1;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_POWER_LIMIT_TURBO:
    SMU_13_0_0_PWRMODE_SETTING = 2;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_POWER_LIMIT_RAGE:
    SMU_13_0_0_PWRMODE_SETTING = 3;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_ACOUSTIC_TEMP_QUIET:
    SMU_13_0_0_PWRMODE_SETTING = 4;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_ACOUSTIC_TEMP_BALANCE:
    SMU_13_0_0_PWRMODE_SETTING = 5;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_ACOUSTIC_TEMP_TURBO:
    SMU_13_0_0_PWRMODE_SETTING = 6;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_ACOUSTIC_TEMP_RAGE:
    SMU_13_0_0_PWRMODE_SETTING = 7;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_ACOUSTIC_TARGET_RPM_QUIET:
    SMU_13_0_0_PWRMODE_SETTING = 8;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_ACOUSTIC_TARGET_RPM_BALANCE:
    SMU_13_0_0_PWRMODE_SETTING = 9;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_ACOUSTIC_TARGET_RPM_TURBO:
    SMU_13_0_0_PWRMODE_SETTING = 10;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_ACOUSTIC_TARGET_RPM_RAGE:
    SMU_13_0_0_PWRMODE_SETTING = 11;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_ACOUSTIC_LIMIT_RPM_QUIET:
    SMU_13_0_0_PWRMODE_SETTING = 12;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_ACOUSTIC_LIMIT_RPM_BALANCE:
    SMU_13_0_0_PWRMODE_SETTING = 13;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_ACOUSTIC_LIMIT_RPM_TURBO:
    SMU_13_0_0_PWRMODE_SETTING = 14;
pub const SMU_13_0_0_PWRMODE_SETTING_SMU_13_0_0_PMSETTING_ACOUSTIC_LIMIT_RPM_RAGE:
    SMU_13_0_0_PWRMODE_SETTING = 15;
pub type SMU_13_0_0_PWRMODE_SETTING = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smu_13_0_0_overdrive_table {
    pub revision: u8,
    pub reserve: [u8; 3usize],
    pub feature_count: u32,
    pub setting_count: u32,
    pub cap: [u8; 32usize],
    pub max: [u32; 64usize],
    pub min: [u32; 64usize],
    pub pm_setting: [i16; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smu_13_0_0_overdrive_table"]
        [::core::mem::size_of::<smu_13_0_0_overdrive_table>() - 620usize];
    ["Alignment of smu_13_0_0_overdrive_table"]
        [::core::mem::align_of::<smu_13_0_0_overdrive_table>() - 1usize];
    ["Offset of field: smu_13_0_0_overdrive_table::revision"]
        [::core::mem::offset_of!(smu_13_0_0_overdrive_table, revision) - 0usize];
    ["Offset of field: smu_13_0_0_overdrive_table::reserve"]
        [::core::mem::offset_of!(smu_13_0_0_overdrive_table, reserve) - 1usize];
    ["Offset of field: smu_13_0_0_overdrive_table::feature_count"]
        [::core::mem::offset_of!(smu_13_0_0_overdrive_table, feature_count) - 4usize];
    ["Offset of field: smu_13_0_0_overdrive_table::setting_count"]
        [::core::mem::offset_of!(smu_13_0_0_overdrive_table, setting_count) - 8usize];
    ["Offset of field: smu_13_0_0_overdrive_table::cap"]
        [::core::mem::offset_of!(smu_13_0_0_overdrive_table, cap) - 12usize];
    ["Offset of field: smu_13_0_0_overdrive_table::max"]
        [::core::mem::offset_of!(smu_13_0_0_overdrive_table, max) - 44usize];
    ["Offset of field: smu_13_0_0_overdrive_table::min"]
        [::core::mem::offset_of!(smu_13_0_0_overdrive_table, min) - 300usize];
    ["Offset of field: smu_13_0_0_overdrive_table::pm_setting"]
        [::core::mem::offset_of!(smu_13_0_0_overdrive_table, pm_setting) - 556usize];
};
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_GFXCLK: SMU_13_0_0_PPCLOCK_ID = 0;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_SOCCLK: SMU_13_0_0_PPCLOCK_ID = 1;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_UCLK: SMU_13_0_0_PPCLOCK_ID = 2;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_FCLK: SMU_13_0_0_PPCLOCK_ID = 3;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_DCLK_0: SMU_13_0_0_PPCLOCK_ID = 4;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_VCLK_0: SMU_13_0_0_PPCLOCK_ID = 5;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_DCLK_1: SMU_13_0_0_PPCLOCK_ID = 6;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_VCLK_1: SMU_13_0_0_PPCLOCK_ID = 7;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_DCEFCLK: SMU_13_0_0_PPCLOCK_ID = 8;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_DISPCLK: SMU_13_0_0_PPCLOCK_ID = 9;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_PIXCLK: SMU_13_0_0_PPCLOCK_ID = 10;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_PHYCLK: SMU_13_0_0_PPCLOCK_ID = 11;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_DTBCLK: SMU_13_0_0_PPCLOCK_ID = 12;
pub const SMU_13_0_0_PPCLOCK_ID_SMU_13_0_0_PPCLOCK_COUNT: SMU_13_0_0_PPCLOCK_ID = 13;
pub type SMU_13_0_0_PPCLOCK_ID = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smu_13_0_0_powerplay_table {
    pub header: atom_common_table_header,
    pub table_revision: u8,
    pub padding: u8,
    pub table_size: u16,
    pub golden_pp_id: u32,
    pub golden_revision: u32,
    pub format_id: u16,
    pub platform_caps: u32,
    pub thermal_controller_type: u8,
    pub small_power_limit1: u16,
    pub small_power_limit2: u16,
    pub boost_power_limit: u16,
    pub software_shutdown_temp: u16,
    pub reserve: [u32; 45usize],
    pub overdrive_table: smu_13_0_0_overdrive_table,
    pub padding1: u8,
    pub smc_pptable: PPTable_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smu_13_0_0_powerplay_table"]
        [::core::mem::size_of::<smu_13_0_0_powerplay_table>() - 4804usize];
    ["Alignment of smu_13_0_0_powerplay_table"]
        [::core::mem::align_of::<smu_13_0_0_powerplay_table>() - 1usize];
    ["Offset of field: smu_13_0_0_powerplay_table::header"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, header) - 0usize];
    ["Offset of field: smu_13_0_0_powerplay_table::table_revision"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, table_revision) - 4usize];
    ["Offset of field: smu_13_0_0_powerplay_table::padding"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, padding) - 5usize];
    ["Offset of field: smu_13_0_0_powerplay_table::table_size"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, table_size) - 6usize];
    ["Offset of field: smu_13_0_0_powerplay_table::golden_pp_id"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, golden_pp_id) - 8usize];
    ["Offset of field: smu_13_0_0_powerplay_table::golden_revision"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, golden_revision) - 12usize];
    ["Offset of field: smu_13_0_0_powerplay_table::format_id"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, format_id) - 16usize];
    ["Offset of field: smu_13_0_0_powerplay_table::platform_caps"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, platform_caps) - 18usize];
    ["Offset of field: smu_13_0_0_powerplay_table::thermal_controller_type"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, thermal_controller_type) - 22usize];
    ["Offset of field: smu_13_0_0_powerplay_table::small_power_limit1"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, small_power_limit1) - 23usize];
    ["Offset of field: smu_13_0_0_powerplay_table::small_power_limit2"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, small_power_limit2) - 25usize];
    ["Offset of field: smu_13_0_0_powerplay_table::boost_power_limit"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, boost_power_limit) - 27usize];
    ["Offset of field: smu_13_0_0_powerplay_table::software_shutdown_temp"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, software_shutdown_temp) - 29usize];
    ["Offset of field: smu_13_0_0_powerplay_table::reserve"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, reserve) - 31usize];
    ["Offset of field: smu_13_0_0_powerplay_table::overdrive_table"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, overdrive_table) - 211usize];
    ["Offset of field: smu_13_0_0_powerplay_table::padding1"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, padding1) - 831usize];
    ["Offset of field: smu_13_0_0_powerplay_table::smc_pptable"]
        [::core::mem::offset_of!(smu_13_0_0_powerplay_table, smc_pptable) - 832usize];
};
