//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuidentifier?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type UIMenuIdentifier = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIMenuOptions(pub NSUInteger);
bitflags::bitflags! {
    impl UIMenuOptions: NSUInteger {
/// Show children inline in parent, instead of hierarchically
        #[doc(alias = "UIMenuOptionsDisplayInline")]
        const DisplayInline = 1<<0;
/// Indicates whether the menu should be rendered with a destructive appearance in its parent
        #[doc(alias = "UIMenuOptionsDestructive")]
        const Destructive = 1<<1;
/// Indicates whether the menu (and any submenus) should only allow a single "on" menu item.
        #[doc(alias = "UIMenuOptionsSingleSelection")]
        const SingleSelection = 1<<5;
/// Indicates that this menu should be rendered as a palette.
        #[doc(alias = "UIMenuOptionsDisplayAsPalette")]
        const DisplayAsPalette = 1<<7;
    }
}

unsafe impl Encode for UIMenuOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UIMenuOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuelementsize?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIMenuElementSize(pub NSInteger);
impl UIMenuElementSize {
    #[doc(alias = "UIMenuElementSizeSmall")]
    pub const Small: Self = Self(0);
    #[doc(alias = "UIMenuElementSizeMedium")]
    pub const Medium: Self = Self(1);
    #[doc(alias = "UIMenuElementSizeLarge")]
    pub const Large: Self = Self(2);
    /// Automatically determine the appropriate element size for the current context.
    #[doc(alias = "UIMenuElementSizeAutomatic")]
    pub const Automatic: Self = Self(-1);
}

unsafe impl Encode for UIMenuElementSize {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIMenuElementSize {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenu?language=objc)
    #[unsafe(super(UIMenuElement, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIMenuElement")]
    pub struct UIMenu;
);

#[cfg(feature = "UIMenuElement")]
extern_conformance!(
    unsafe impl NSCoding for UIMenu {}
);

#[cfg(feature = "UIMenuElement")]
extern_conformance!(
    unsafe impl NSCopying for UIMenu {}
);

#[cfg(feature = "UIMenuElement")]
unsafe impl CopyingHelper for UIMenu {
    type Result = Self;
}

#[cfg(feature = "UIMenuElement")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIMenu {}
);

#[cfg(feature = "UIMenuElement")]
extern_conformance!(
    unsafe impl NSSecureCoding for UIMenu {}
);

#[cfg(feature = "UIMenuElement")]
impl UIMenu {
    extern_methods!(
        /// Unique identifier.
        #[unsafe(method(identifier))]
        #[unsafe(method_family = none)]
        pub fn identifier(&self) -> Retained<UIMenuIdentifier>;

        /// Options.
        #[unsafe(method(options))]
        #[unsafe(method_family = none)]
        pub fn options(&self) -> UIMenuOptions;

        /// Size of this menu's child elements. This property has no effect on Mac Catalyst.
        #[unsafe(method(preferredElementSize))]
        #[unsafe(method_family = none)]
        pub fn preferredElementSize(&self) -> UIMenuElementSize;

        /// Setter for [`preferredElementSize`][Self::preferredElementSize].
        #[unsafe(method(setPreferredElementSize:))]
        #[unsafe(method_family = none)]
        pub fn setPreferredElementSize(&self, preferred_element_size: UIMenuElementSize);

        /// The menu's sub-elements and sub-menus. On iOS 14.0, elements of your own menus are mutable, -copying a menu will produce mutable elements, and UIKit will take immutable copies of menus it receives. Prior to iOS 14.0, menus are always fully immutable.
        #[unsafe(method(children))]
        #[unsafe(method_family = none)]
        pub fn children(&self) -> Retained<NSArray<UIMenuElement>>;

        /// The element(s) in the menu and sub-menus that have an "on" menu item state.
        #[unsafe(method(selectedElements))]
        #[unsafe(method_family = none)]
        pub fn selectedElements(&self) -> Retained<NSArray<UIMenuElement>>;

        #[cfg(feature = "UIMenuDisplayPreferences")]
        /// Display preferences for this menu's immediate children. Preferences are not inherited by sub menus,
        /// and may be ignored or overridden by the system in certain element sizes or menu layouts.
        #[unsafe(method(displayPreferences))]
        #[unsafe(method_family = none)]
        pub fn displayPreferences(&self) -> Option<Retained<UIMenuDisplayPreferences>>;

        #[cfg(feature = "UIMenuDisplayPreferences")]
        /// Setter for [`displayPreferences`][Self::displayPreferences].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setDisplayPreferences:))]
        #[unsafe(method_family = none)]
        pub fn setDisplayPreferences(&self, display_preferences: Option<&UIMenuDisplayPreferences>);

        /// Creates a UIMenu with an empty title, nil image, automatically generated identifier, and default options.
        ///
        ///
        /// Parameter `children`: The menu's action-based sub-elements and sub-menus.
        ///
        ///
        /// Returns: A new UIMenu.
        #[unsafe(method(menuWithChildren:))]
        #[unsafe(method_family = none)]
        pub fn menuWithChildren(
            children: &NSArray<UIMenuElement>,
            mtm: MainThreadMarker,
        ) -> Retained<UIMenu>;

        /// Creates a UIMenu with the given arguments.
        ///
        ///
        /// Parameter `title`: The menu's title.
        ///
        /// Parameter `children`: The menu's action-based sub-elements and sub-menus.
        ///
        ///
        /// Returns: A new UIMenu.
        #[unsafe(method(menuWithTitle:children:))]
        #[unsafe(method_family = none)]
        pub fn menuWithTitle_children(
            title: &NSString,
            children: &NSArray<UIMenuElement>,
            mtm: MainThreadMarker,
        ) -> Retained<UIMenu>;

        #[cfg(feature = "UIImage")]
        /// Creates a UIMenu with the given arguments.
        ///
        ///
        /// Parameter `title`: The menu's title.
        ///
        /// Parameter `image`: Image to be displayed alongside the menu's title.
        ///
        /// Parameter `identifier`: The menu's unique identifier. Pass nil to use an auto-generated identifier.
        ///
        /// Parameter `options`: The menu's options.
        ///
        /// Parameter `children`: The menu's action-based sub-elements and sub-menus.
        ///
        ///
        /// Returns: A new UIMenu.
        #[unsafe(method(menuWithTitle:image:identifier:options:children:))]
        #[unsafe(method_family = none)]
        pub fn menuWithTitle_image_identifier_options_children(
            title: &NSString,
            image: Option<&UIImage>,
            identifier: Option<&UIMenuIdentifier>,
            options: UIMenuOptions,
            children: &NSArray<UIMenuElement>,
            mtm: MainThreadMarker,
        ) -> Retained<UIMenu>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        /// Copies this menu and replaces its children.
        ///
        ///
        /// Parameter `newChildren`: The replacement children.
        ///
        ///
        /// Returns: A copy of this menu with updated children.
        #[unsafe(method(menuByReplacingChildren:))]
        #[unsafe(method_family = none)]
        pub fn menuByReplacingChildren(
            &self,
            new_children: &NSArray<UIMenuElement>,
        ) -> Retained<UIMenu>;
    );
}

extern "C" {
    /// Application menu top-level menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuapplication?language=objc)
    pub static UIMenuApplication: &'static UIMenuIdentifier;
}

extern "C" {
    /// File menu top-level menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenufile?language=objc)
    pub static UIMenuFile: &'static UIMenuIdentifier;
}

extern "C" {
    /// Edit menu top-level menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuedit?language=objc)
    pub static UIMenuEdit: &'static UIMenuIdentifier;
}

extern "C" {
    /// View menu top-level menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuview?language=objc)
    pub static UIMenuView: &'static UIMenuIdentifier;
}

extern "C" {
    /// Window menu top-level menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuwindow?language=objc)
    pub static UIMenuWindow: &'static UIMenuIdentifier;
}

extern "C" {
    /// Help menu top-level menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuhelp?language=objc)
    pub static UIMenuHelp: &'static UIMenuIdentifier;
}

extern "C" {
    /// About menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuabout?language=objc)
    pub static UIMenuAbout: &'static UIMenuIdentifier;
}

extern "C" {
    /// Preferences menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenupreferences?language=objc)
    pub static UIMenuPreferences: &'static UIMenuIdentifier;
}

extern "C" {
    /// Services menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuservices?language=objc)
    pub static UIMenuServices: &'static UIMenuIdentifier;
}

extern "C" {
    /// Hide, Hide Others, Show All menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuhide?language=objc)
    pub static UIMenuHide: &'static UIMenuIdentifier;
}

extern "C" {
    /// Quit menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuquit?language=objc)
    pub static UIMenuQuit: &'static UIMenuIdentifier;
}

extern "C" {
    /// New item menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenunewitem?language=objc)
    pub static UIMenuNewItem: &'static UIMenuIdentifier;
}

extern "C" {
    /// New scene menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenunewscene?language=objc)
    #[deprecated]
    pub static UIMenuNewScene: &'static UIMenuIdentifier;
}

extern "C" {
    /// Open menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuopen?language=objc)
    pub static UIMenuOpen: &'static UIMenuIdentifier;
}

extern "C" {
    /// Open Recent menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuopenrecent?language=objc)
    pub static UIMenuOpenRecent: &'static UIMenuIdentifier;
}

extern "C" {
    /// Close menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuclose?language=objc)
    pub static UIMenuClose: &'static UIMenuIdentifier;
}

extern "C" {
    /// Print menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuprint?language=objc)
    pub static UIMenuPrint: &'static UIMenuIdentifier;
}

extern "C" {
    /// Document-related menu items: Duplicate, Move, Rename, Export. The `.document` menu is added to Mac Catalyst applications by default. iOS Apps on the Mac will have the `.document` menu inserted when and if `UINavigationItem.titleMenuProvider` is set to a nonnull value, and from launch on subsequent executions.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenudocument?language=objc)
    pub static UIMenuDocument: &'static UIMenuIdentifier;
}

extern "C" {
    /// Undo, Redo menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuundoredo?language=objc)
    pub static UIMenuUndoRedo: &'static UIMenuIdentifier;
}

extern "C" {
    /// Cut, Copy, Paste, Delete, Select, Select All menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenustandardedit?language=objc)
    pub static UIMenuStandardEdit: &'static UIMenuIdentifier;
}

extern "C" {
    /// Find menu, containing Find Panel items and other finding operations like Use Selection for Find
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenufind?language=objc)
    pub static UIMenuFind: &'static UIMenuIdentifier;
}

extern "C" {
    /// Find panel menu (Find, Find and Replace, Find Next, Find Previous)
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenufindpanel?language=objc)
    pub static UIMenuFindPanel: &'static UIMenuIdentifier;
}

extern "C" {
    /// Replace..., Transliterate Chinese menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenureplace?language=objc)
    pub static UIMenuReplace: &'static UIMenuIdentifier;
}

extern "C" {
    /// Share menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenushare?language=objc)
    pub static UIMenuShare: &'static UIMenuIdentifier;
}

extern "C" {
    /// Bold, Italics, Underline  menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenutextstyle?language=objc)
    pub static UIMenuTextStyle: &'static UIMenuIdentifier;
}

extern "C" {
    /// Spelling menu contained within Edit menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuspelling?language=objc)
    pub static UIMenuSpelling: &'static UIMenuIdentifier;
}

extern "C" {
    /// Show Spelling, Check Document Now menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuspellingpanel?language=objc)
    pub static UIMenuSpellingPanel: &'static UIMenuIdentifier;
}

extern "C" {
    /// Check Spelling While Typing and other spelling and grammar-checking options menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuspellingoptions?language=objc)
    pub static UIMenuSpellingOptions: &'static UIMenuIdentifier;
}

extern "C" {
    /// Substitutions menu contained within Edit menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenusubstitutions?language=objc)
    pub static UIMenuSubstitutions: &'static UIMenuIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenusubstitutionspanel?language=objc)
    pub static UIMenuSubstitutionsPanel: &'static UIMenuIdentifier;
}

extern "C" {
    /// Smart Copy, Smart Paste, Smart Quotes, and other substitution options menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenusubstitutionoptions?language=objc)
    pub static UIMenuSubstitutionOptions: &'static UIMenuIdentifier;
}

extern "C" {
    /// Transformations menu contained within Edit menu (contains Make Uppercase, Make Lowercase, Capitalize)
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenutransformations?language=objc)
    pub static UIMenuTransformations: &'static UIMenuIdentifier;
}

extern "C" {
    /// Speech menu contained within Edit menu (contains Speak, Speak..., Pause)
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuspeech?language=objc)
    pub static UIMenuSpeech: &'static UIMenuIdentifier;
}

extern "C" {
    /// Lookup menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenulookup?language=objc)
    pub static UIMenuLookup: &'static UIMenuIdentifier;
}

extern "C" {
    /// Learn menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenulearn?language=objc)
    pub static UIMenuLearn: &'static UIMenuIdentifier;
}

extern "C" {
    /// Format top-level menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuformat?language=objc)
    pub static UIMenuFormat: &'static UIMenuIdentifier;
}

extern "C" {
    /// AutoFill menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuautofill?language=objc)
    pub static UIMenuAutoFill: &'static UIMenuIdentifier;
}

extern "C" {
    /// Font menu contained within Format menu (contains UIMenuTextStyle)
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenufont?language=objc)
    pub static UIMenuFont: &'static UIMenuIdentifier;
}

extern "C" {
    /// Bigger and Smaller menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenutextsize?language=objc)
    pub static UIMenuTextSize: &'static UIMenuIdentifier;
}

extern "C" {
    /// Show Colors menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenutextcolor?language=objc)
    pub static UIMenuTextColor: &'static UIMenuIdentifier;
}

extern "C" {
    /// Copy Style and Paste Style menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenutextstylepasteboard?language=objc)
    pub static UIMenuTextStylePasteboard: &'static UIMenuIdentifier;
}

extern "C" {
    /// Text menu contained within Format menu (contains UIMenuAlignment and UIMenuWritingDirection)
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenutext?language=objc)
    pub static UIMenuText: &'static UIMenuIdentifier;
}

extern "C" {
    /// Default, Right to Left, Left to Right menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuwritingdirection?language=objc)
    pub static UIMenuWritingDirection: &'static UIMenuIdentifier;
}

extern "C" {
    /// Align Left, Center, Justify, Align Right menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenualignment?language=objc)
    pub static UIMenuAlignment: &'static UIMenuIdentifier;
}

extern "C" {
    /// Show/Hide and Customize Toolbar menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenutoolbar?language=objc)
    pub static UIMenuToolbar: &'static UIMenuIdentifier;
}

extern "C" {
    /// Sidebar menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenusidebar?language=objc)
    pub static UIMenuSidebar: &'static UIMenuIdentifier;
}

extern "C" {
    /// Fullscreen menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenufullscreen?language=objc)
    pub static UIMenuFullscreen: &'static UIMenuIdentifier;
}

extern "C" {
    /// Minimize, Zoom menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuminimizeandzoom?language=objc)
    pub static UIMenuMinimizeAndZoom: &'static UIMenuIdentifier;
}

extern "C" {
    /// Bring All to Front, Arrange in Front menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenubringalltofront?language=objc)
    pub static UIMenuBringAllToFront: &'static UIMenuIdentifier;
}

extern "C" {
    /// Root-level menu
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenuroot?language=objc)
    pub static UIMenuRoot: &'static UIMenuIdentifier;
}
