//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointerstyle?language=objc)
    #[unsafe(super(UIHoverStyle, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIHoverStyle")]
    pub struct UIPointerStyle;
);

#[cfg(feature = "UIHoverStyle")]
extern_conformance!(
    unsafe impl NSCopying for UIPointerStyle {}
);

#[cfg(feature = "UIHoverStyle")]
unsafe impl CopyingHelper for UIPointerStyle {
    type Result = Self;
}

#[cfg(feature = "UIHoverStyle")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIPointerStyle {}
);

#[cfg(feature = "UIHoverStyle")]
impl UIPointerStyle {
    extern_methods!(
        #[cfg(feature = "UIPointerAccessory")]
        /// Accessories to display alongside this UIPointerStyle. Supports up to 4 accessories.
        /// The system will attempt to animate between neighboring or similar accessories.
        #[unsafe(method(accessories))]
        #[unsafe(method_family = none)]
        pub fn accessories(&self) -> Retained<NSArray<UIPointerAccessory>>;

        #[cfg(feature = "UIPointerAccessory")]
        /// Setter for [`accessories`][Self::accessories].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessories:))]
        #[unsafe(method_family = none)]
        pub fn setAccessories(&self, accessories: &NSArray<UIPointerAccessory>);

        /// Applies the provided content effect and pointer shape within the current region.
        ///
        ///
        /// Parameter `effect`: The desired pointer effect.
        ///
        /// Parameter `shape`: The desired pointer shape. If omitted, a pointer will be generated automatically from the effect's preview view.
        #[unsafe(method(styleWithEffect:shape:))]
        #[unsafe(method_family = none)]
        pub unsafe fn styleWithEffect_shape(
            effect: &UIPointerEffect,
            shape: Option<&UIPointerShape>,
        ) -> Retained<Self>;

        #[cfg(feature = "UIGeometry")]
        /// Morphs the pointer into the provided shape when hovering over the current region.
        ///
        ///
        /// Parameter `shape`: The desired pointer shape.
        ///
        /// Parameter `axes`: Axes along which to recenter the pointer on touch up.
        #[unsafe(method(styleWithShape:constrainedAxes:))]
        #[unsafe(method_family = none)]
        pub fn styleWithShape_constrainedAxes(
            shape: &UIPointerShape,
            axes: UIAxis,
        ) -> Retained<Self>;

        /// Hides the pointer when hovering over the current region.
        #[unsafe(method(hiddenPointerStyle))]
        #[unsafe(method_family = none)]
        pub fn hiddenPointerStyle(mtm: MainThreadMarker) -> Retained<Self>;

        /// Pointer style that displays an unconstrained system pointer. Use this to display accessories alongside the default pointer.
        #[unsafe(method(systemPointerStyle))]
        #[unsafe(method_family = none)]
        pub fn systemPointerStyle(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// Methods declared on superclass `UIHoverStyle`.
#[cfg(feature = "UIHoverStyle")]
impl UIPointerStyle {
    extern_methods!(
        #[cfg(feature = "UIShape")]
        /// Creates a hover style with the provided shape and a `UIHoverAutomaticEffect`.
        #[unsafe(method(styleWithShape:))]
        #[unsafe(method_family = none)]
        pub fn styleWithShape(shape: Option<&UIShape>, mtm: MainThreadMarker) -> Retained<Self>;

        /// Creates a hover style with the default shape and a `UIHoverAutomaticEffect`.
        #[unsafe(method(automaticStyle))]
        #[unsafe(method_family = none)]
        pub fn automaticStyle(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointereffect?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPointerEffect;
);

extern_conformance!(
    unsafe impl NSCopying for UIPointerEffect {}
);

unsafe impl CopyingHelper for UIPointerEffect {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPointerEffect {}
);

#[cfg(feature = "UIHoverEffect")]
extern_conformance!(
    unsafe impl UIHoverEffect for UIPointerEffect {}
);

impl UIPointerEffect {
    extern_methods!(
        #[cfg(feature = "UITargetedPreview")]
        #[unsafe(method(preview))]
        #[unsafe(method_family = none)]
        pub fn preview(&self) -> Retained<UITargetedPreview>;

        #[cfg(feature = "UITargetedPreview")]
        /// Creates a pointer content effect with the given preview's view.
        ///
        ///
        /// Parameter `preview`: A UITargetedPreview object describing a view with which to construct the effect.
        ///
        ///
        /// UIPointerEffect attempts to determine the appropriate effect for the given preview automatically.
        /// Use one of its subclasses to request a specific system-provided effect.
        #[unsafe(method(effectWithPreview:))]
        #[unsafe(method_family = none)]
        pub fn effectWithPreview(preview: &UITargetedPreview) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// Pointer slides under the given view and morphs into the view's shape
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointerhighlighteffect?language=objc)
    #[unsafe(super(UIPointerEffect, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPointerHighlightEffect;
);

extern_conformance!(
    unsafe impl NSCopying for UIPointerHighlightEffect {}
);

unsafe impl CopyingHelper for UIPointerHighlightEffect {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPointerHighlightEffect {}
);

#[cfg(feature = "UIHoverEffect")]
extern_conformance!(
    unsafe impl UIHoverEffect for UIPointerHighlightEffect {}
);

impl UIPointerHighlightEffect {
    extern_methods!();
}

/// Methods declared on superclass `UIPointerEffect`.
impl UIPointerHighlightEffect {
    extern_methods!(
        #[cfg(feature = "UITargetedPreview")]
        /// Creates a pointer content effect with the given preview's view.
        ///
        ///
        /// Parameter `preview`: A UITargetedPreview object describing a view with which to construct the effect.
        ///
        ///
        /// UIPointerEffect attempts to determine the appropriate effect for the given preview automatically.
        /// Use one of its subclasses to request a specific system-provided effect.
        #[unsafe(method(effectWithPreview:))]
        #[unsafe(method_family = none)]
        pub fn effectWithPreview(preview: &UITargetedPreview) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// Pointer slides under the given view and disappears as the view scales up and gains a shadow.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointerlifteffect?language=objc)
    #[unsafe(super(UIPointerEffect, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPointerLiftEffect;
);

extern_conformance!(
    unsafe impl NSCopying for UIPointerLiftEffect {}
);

unsafe impl CopyingHelper for UIPointerLiftEffect {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPointerLiftEffect {}
);

#[cfg(feature = "UIHoverEffect")]
extern_conformance!(
    unsafe impl UIHoverEffect for UIPointerLiftEffect {}
);

impl UIPointerLiftEffect {
    extern_methods!();
}

/// Methods declared on superclass `UIPointerEffect`.
impl UIPointerLiftEffect {
    extern_methods!(
        #[cfg(feature = "UITargetedPreview")]
        /// Creates a pointer content effect with the given preview's view.
        ///
        ///
        /// Parameter `preview`: A UITargetedPreview object describing a view with which to construct the effect.
        ///
        ///
        /// UIPointerEffect attempts to determine the appropriate effect for the given preview automatically.
        /// Use one of its subclasses to request a specific system-provided effect.
        #[unsafe(method(effectWithPreview:))]
        #[unsafe(method_family = none)]
        pub fn effectWithPreview(preview: &UITargetedPreview) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointereffecttintmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIPointerEffectTintMode(pub NSInteger);
impl UIPointerEffectTintMode {
    #[doc(alias = "UIPointerEffectTintModeNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "UIPointerEffectTintModeOverlay")]
    pub const Overlay: Self = Self(1);
    #[doc(alias = "UIPointerEffectTintModeUnderlay")]
    pub const Underlay: Self = Self(2);
}

unsafe impl Encode for UIPointerEffectTintMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIPointerEffectTintMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// Pointer retains the system shape while over the given view. Visual changes applied to the view are dictated by the effect's properties.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointerhovereffect?language=objc)
    #[unsafe(super(UIPointerEffect, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPointerHoverEffect;
);

extern_conformance!(
    unsafe impl NSCopying for UIPointerHoverEffect {}
);

unsafe impl CopyingHelper for UIPointerHoverEffect {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPointerHoverEffect {}
);

#[cfg(feature = "UIHoverEffect")]
extern_conformance!(
    unsafe impl UIHoverEffect for UIPointerHoverEffect {}
);

impl UIPointerHoverEffect {
    extern_methods!(
        #[unsafe(method(preferredTintMode))]
        #[unsafe(method_family = none)]
        pub fn preferredTintMode(&self) -> UIPointerEffectTintMode;

        /// Setter for [`preferredTintMode`][Self::preferredTintMode].
        #[unsafe(method(setPreferredTintMode:))]
        #[unsafe(method_family = none)]
        pub fn setPreferredTintMode(&self, preferred_tint_mode: UIPointerEffectTintMode);

        #[unsafe(method(prefersShadow))]
        #[unsafe(method_family = none)]
        pub fn prefersShadow(&self) -> bool;

        /// Setter for [`prefersShadow`][Self::prefersShadow].
        #[unsafe(method(setPrefersShadow:))]
        #[unsafe(method_family = none)]
        pub fn setPrefersShadow(&self, prefers_shadow: bool);

        #[unsafe(method(prefersScaledContent))]
        #[unsafe(method_family = none)]
        pub fn prefersScaledContent(&self) -> bool;

        /// Setter for [`prefersScaledContent`][Self::prefersScaledContent].
        #[unsafe(method(setPrefersScaledContent:))]
        #[unsafe(method_family = none)]
        pub fn setPrefersScaledContent(&self, prefers_scaled_content: bool);
    );
}

/// Methods declared on superclass `UIPointerEffect`.
impl UIPointerHoverEffect {
    extern_methods!(
        #[cfg(feature = "UITargetedPreview")]
        /// Creates a pointer content effect with the given preview's view.
        ///
        ///
        /// Parameter `preview`: A UITargetedPreview object describing a view with which to construct the effect.
        ///
        ///
        /// UIPointerEffect attempts to determine the appropriate effect for the given preview automatically.
        /// Use one of its subclasses to request a specific system-provided effect.
        #[unsafe(method(effectWithPreview:))]
        #[unsafe(method_family = none)]
        pub fn effectWithPreview(preview: &UITargetedPreview) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointershape?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPointerShape;
);

extern_conformance!(
    unsafe impl NSCopying for UIPointerShape {}
);

unsafe impl CopyingHelper for UIPointerShape {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPointerShape {}
);

impl UIPointerShape {
    extern_methods!(
        #[cfg(feature = "UIBezierPath")]
        /// UIBezierPath describing the pointer's shape. If used alongside a content effect, the shape must be
        /// in the effect's preview's container view's coordinate space. When used as a standalone shape,
        /// The path's bounds' origin corresponds to the pointer's physical location.
        #[unsafe(method(shapeWithPath:))]
        #[unsafe(method_family = none)]
        pub fn shapeWithPath(path: &UIBezierPath, mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Morphs the pointer to a rounded rectangle with the provided rect and the standard system corner radius.
        ///
        ///
        /// Parameter `rect`: CGRect describing the pointer's frame. If used alongside a content effect, this rect must be in the effect's
        /// preview's container view's coordinate space. Otherwise, it is centered about the pointer's current location
        /// and the rect's origin is interpreted as an offset.
        #[unsafe(method(shapeWithRoundedRect:))]
        #[unsafe(method_family = none)]
        pub fn shapeWithRoundedRect(rect: CGRect, mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Morphs the pointer to a rounded rectangle with the provided rect and cornerRadius.
        ///
        ///
        /// Parameter `rect`: CGRect describing the pointer's frame. If used alongside a content effect, this rect must be in
        /// the effect's preview's container view's coordinate space. Otherwise, it is centered about the
        /// pointer's current location and the rect's origin is interpreted as an offset.
        ///
        /// Parameter `cornerRadius`: Corner radius to apply to the pointer.
        #[unsafe(method(shapeWithRoundedRect:cornerRadius:))]
        #[unsafe(method_family = none)]
        pub fn shapeWithRoundedRect_cornerRadius(
            rect: CGRect,
            corner_radius: CGFloat,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Morphs the pointer to a beam with the given length and axis.
        ///
        ///
        /// Parameter `length`: The beam's length. Limited to the region's width or height, depending on the beam's axis.
        ///
        /// Parameter `axis`: The axis along which to draw the beam. Axis must be either UIAxisVertical or UIAxisHorizontal.
        #[unsafe(method(beamWithPreferredLength:axis:))]
        #[unsafe(method_family = none)]
        pub fn beamWithPreferredLength_axis(
            length: CGFloat,
            axis: UIAxis,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
