\page Examplepy8decayer Example py8decayer 

  This example demonstrates how to outfit Pythia8-based decay features 
  to those resonances in Geant4 where decay tables are not implemented
  by default. In addition, it showns how to replace existing
  Geant4 decay tables to such resonances as tau+/- or B+/- with 
  the Pythia8-based ones.
  
  The complete Pythia8 information, including on download, and documentation 
  is available from the following site:
  https://pythia.org
 
  The original version of this example has been implemented by Julia Yarba
  (FNAL, USA)
  
  <hr>

  For the complete list of the classes that compose this example please 
  see later in this document.

  Location of example:
  
  examples/extended/eventgenerator/pythia/py8decayer
  

  ## Installation of Pythia8: 

  NOTE: As of May 2025, pythia8.3.15 is the most current version, 
  thus it is used in this example.
  In general, this example is expected to work with any reasonably modern
  pythia8.x.y revision.
  In the future, please check updates at Pythia8 site: https://pythia.org
  
- 1.
```
cd path/to/your/pythia8/area
```
- 2. Download desired version of Pythia8 and un-tar it, e.g. 
```
wget https://pythia.org/download/pythia83/pythia8315.tgz
tar xzf pythia8315.tgz
```

- 3. Build/install Pythia8
```
cd pythia8315
export CXX=\`which g++\`
./configure --prefix=$PWD --cxx=$CXX
make
```
     NOTE: By default, Pythia8 (as of 8.3.15) builds with C++11 standards. 
     If one wants to turn to e.g. C++17 standard, one needs to override flags 
     via `--cxx-common` argument to configure script. 
     Alternatively, one can setup `CXX_COMMON` environment variable.
     As of pythia8310, the default flags are the following:
     `-O2 -std=c++11 -pedantic -W -Wall -Wshadow -fPIC -pthread`. \n 
     Please note use of `-pthread` which was not among default flags in earlier
     releases of Pythia8.
     Example of specifying C++17 standards by overriding the default flags via 
     use of `--cxx_common` argument to configure script:
```
./configure --prefix=$PWD --cxx=$CXX \
	--cxx-common='-O2 -std=c++17 -pedantic -W -Wall -Wshadow -fPIC -pthread'
```

- 4. Setup Pythia8_ROOT environment variable to point to the area where Pythia8
      is built/installed:
```
export Pythia8_ROOT=$PWD
```


  ## Building example:
  
  Upon setup of `Pythia8_ROOT` environment variable to point to the area where 
  Pythia8 package is installed, the pythia/py8decayer example will be
  compiled together with several other features of the eventgenerator example.


  ## Description of classes:
  
  Py8Decayer class provides implementation of the G4VExternalDecayer interface 
  with the use of PYTHIA8.
  It is reasonably annotated, and demonstrates what features of Pythia8 need
  to be activated and/or disactivated in order to make Pythia8 work only in
  the decay mode.
  It also illustrated how to control several other features of Pythia8, including
  some reduction of Pythia8 verbosity (by default, Pythia8 produces quite a large
  amount of printouts, thus reducing it could be useful in some cases).
  It also shown how to deactivate decays of pi0's by Pythia8 as the idea is to handle
  pi0's back to Geant4 for decays.
  
  Last but not least, it shows how to outfit Pythia8 with a custom random engine, 
  i.e. Py8DecayerEngine.
  
  Py8DecayerEngine class inherits from Pythia8::RndmEngine which in its turns is
  provided by the Pythia8 package in order to allow replacing the generator's native
  random engine with the one of user's choice.
  In this specific case Py8DecayerEngine allows to replace Pythia8 native random engine
  with the same engine that Geant4 uses (i.e. CLHEP::RanecuEngine as in this application).
  The feature is important for running the example in the MT/Tasking mode.

  Py8DecayerPhysics class implements a G4VPhysicsConstructor type of component
  with the use of Py8Decayer; this component can later be used with a ddsired
  physics list (see main program).
  Specifically, in the Py8DecayerPhysics::ConstructProcess() the Py8Decayer is
  instantiated and is used to
  a) replace existing decay tables of such resonances as tau+/- and B+/-
  b) supplement decay features to those resonances in Geant4 where the decay
     tables are not implemnted by defaukt
    
  In principle, classes Py8Decayer, Py8DecayerEngine, and Py8DecayerPhysics can be
  directly reused with another user application.
  Alternatively, they can be used as an inspiration to implement similar, or perhaps 
  even more extensive Pythia8-based functionalities of user's choice.
  
  Class DetConstruction demostrates how to implement minimalistic detector geometry.
  
  Class SingleParticleGun demonstrates how to implement generaton of the primary
  particle.

  Class ActionInitialization instantiates and registers to Geant4 kernel all user 
  action classes; in this case it is SingleParticleGun.
  

  ## Main program:
  
  pythia8_decayer.cc

  This application currently uses the default RunManager which is Tasking and is
  initialized with 5 threads.
  It will then run 5 events, one per thread.
  SerialOnly RunManager can also be employed should the user choose so.
  

  ## Executable:
  
  `pythia8_decayer`
  

  ## Execution:
  
  At present, the `pythia8_decayer` executable does not take any input arguments.
  Everything, including the choine of primary particle, is hardcoded.
  Although in the future some configurability may be added.

  As mentioned earlier, it will run 5 single tau events using Pythia8 to decays them. 

  It should print some Pythia8 event information, including on decays. 
  Once again, please bear in mind that the decay of pi0's by Pythia8 is disabled 
  (see Py8Decayer constructor) since the idea is to hand the pi0's back to Geant4 
  and make Geant4 decay them.


  ## Additional notes on the contents of Geant4 and Pythia8 Particle Data Tables (PDT) :
  
  In their default form, PDT's in Geant4 and Pythia8 have a number of differences 
  that need to be kept in mind.

  In the case of the Geant4 py8decayer example those differences are unlikely 
  to cause any major issues.

  But Pythia8 can, in principle, be used within Geant4 in more ways that just 
  as an external decayer.
  Thus, if one is potentially interested in more sophisticated use of Pythia8 
  in Geant4, one may want to consider whatever differences exist between (default) 
  Geant4 and Pythia8 PDT's.

  Both Geant4 and Pythia8 codes are evolving, and specific numbers may be different
  in earlier and/or in future releases.

  To be more precise, by default Pythia8.3.10 PDT contains 677 entries, of which 
  531 particles have an antiparticle (it looks like antiparticles do not make 
  separate entries in Pythia8 PDT, but the total number of available species 
  should be considered as 1208).

  Geant4 PDT contains 508 entries. 

  Of those, 239 particles/antiparticles match by Particle ID's (on the Geant4 side 
  it is explicitly called "PDG encoding" while on Pythia8 side it is just "id").

  Many of Pythia8 PDT's entries are not available in Geant4 PDT, e.g. Z or W bosons 
  are not in Geant4.

  Some of the species in the Geant4 PDT do not seem to be in the Pythia8 PDT 
  (e.g. excited nucleons do not seem to be in the Pythia8 PDT).

  Also, there are entries in both PDT's that mean the same particles but are 
  marked with different ID's.
  For example, excited Delta(s) are present in both PDT's but in Geant4 each one 
  is marked with a 4-digit number as an ID (PDG encoding) while in Pythia8 an ID 
  for such particle would be a 6-digit number starting with "20" and the last 
  4 digits would be the same as the Geant4 ID for such particle.
  
  Speaking of the 239 particles that match by ID (PDG ID), there may be further 
  differences, e.g. by mass, either central value or width, or both (there might be 
  other aspects but they have not been checked for).

  Starting October 2022, checks have been made from time to time for differences 
  larger that 1 keV in either mass central value or width.

  The largest differences have been observed for quarks/diquarks.
  It appears that Geant4 sets (at least) masses of quarks as listed in PDG.
  For details on default settings for the quark masses in Pythia8 please refer 
  to the Pythia8 manual: 
  https://pythia.org/manuals/pythia8315/Welcome.html
  See Particles and Decays section, Particle Data subsection.

  Beyond quarks/diquarks some differences in mass central values or width have also
  been observed, mainly for resonances.
  But even for such particles as proton or muon there may be differences on the order 
  of a few keV (e.g. central value of the proton mass is 938.27 MeV in Pythia8 and 
  938.272 MeV in Geant4)

