\page Examplestandalone Example standalone

examples/extended/visualization/standalone


This example illustrates how one might use the Geant4 Visualization
System as a "standalone" graphics library and viewer, i.e, without
the overhead of the run manager and all the actions and physics.

It makes use of the "user action" feature of the Geant4 vis manager - for
a simple example see examples/extended/visualization/userVisAction.  You
have to encapsulate your drawing in a vis action so that the vis manager
can call it and re-call it as appropriate.

1) Define a G4VUserVisAction that implements a Draw method.  Two
   examples are provided:
   - StandaloneVisAction:
     - a simple box;
     - a Boolean solid;
     - an alternative way of drawing a solid by obtaining the
       polyhedral representation (included for interest, not as a
       recommendation).
   - DrawGeometryVisAction:
     - Shows how to visualise your geometry alone, i.e., without the
       run manager and the physics stuff.
      
2) In the main() program, the vis actions must be instantiated and
   registered with the visualization manager. You may (optionally)
   specify an extent to assist the viewers to locate the objects.

3) To visualise, you need: 
   - `/vis/scene/add/userAction`

4) Use the usual Geant4 vis commands to create a scene
   and view (including the above command) - see standalone.mac.

Note: The system needs an "extent" in order to point the virtual
camera and adjust its field of view, etc.  This defines the "standard
view".  You may zoom, etc., from this standard view.  The extent may
be specified as suggested above or by using `/vis/scene/add/extent`.


John Allison
30th December 2022