/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.os;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.motd.maven.os.DetectionException;
import kr.motd.maven.os.FileOperationProvider;
import kr.motd.maven.os.SystemPropertyOperationProvider;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.classpath.declarations.FileInputStreamInterceptorsDeclaration;

public abstract class Detector {
    public static final String DETECTED_NAME = "os.detected.name";
    public static final String DETECTED_ARCH = "os.detected.arch";
    public static final String DETECTED_BITNESS = "os.detected.bitness";
    public static final String DETECTED_VERSION = "os.detected.version";
    public static final String DETECTED_VERSION_MAJOR = "os.detected.version.major";
    public static final String DETECTED_VERSION_MINOR = "os.detected.version.minor";
    public static final String DETECTED_CLASSIFIER = "os.detected.classifier";
    public static final String DETECTED_RELEASE = "os.detected.release";
    public static final String DETECTED_RELEASE_VERSION = "os.detected.release.version";
    public static final String DETECTED_RELEASE_LIKE_PREFIX = "os.detected.release.like.";
    private static final String UNKNOWN = "unknown";
    private static final String LINUX_ID_PREFIX = "ID=";
    private static final String LINUX_ID_LIKE_PREFIX = "ID_LIKE=";
    private static final String LINUX_VERSION_ID_PREFIX = "VERSION_ID=";
    private static final String[] LINUX_OS_RELEASE_FILES = new String[]{"/etc/os-release", "/usr/lib/os-release"};
    private static final String REDHAT_RELEASE_FILE = "/etc/redhat-release";
    private static final String[] DEFAULT_REDHAT_VARIANTS = new String[]{"rhel", "fedora"};
    private static final Pattern VERSION_REGEX = Pattern.compile("((\\d+)\\.(\\d+)).*");
    private static final Pattern REDHAT_MAJOR_VERSION_REGEX = Pattern.compile("(\\d+)");
    private final SystemPropertyOperationProvider systemPropertyOperationProvider;
    private final FileOperationProvider fileOperationProvider;

    public Detector() {
        this(new SimpleSystemPropertyOperations(), new SimpleFileOperations());
    }

    public Detector(SystemPropertyOperationProvider systemPropertyOperationProvider, FileOperationProvider fileOperationProvider) {
        this.systemPropertyOperationProvider = systemPropertyOperationProvider;
        this.fileOperationProvider = fileOperationProvider;
    }

    protected void detect(Properties props, List<String> classifierWithLikes) {
        LinuxRelease linuxRelease;
        String failOnUnknownOS;
        this.log("------------------------------------------------------------------------");
        this.log("Detecting the operating system and CPU architecture");
        this.log("------------------------------------------------------------------------");
        String osName = this.systemPropertyOperationProvider.getSystemProperty("os.name");
        String osArch = this.systemPropertyOperationProvider.getSystemProperty("os.arch");
        String osVersion = this.systemPropertyOperationProvider.getSystemProperty("os.version");
        String detectedName = Detector.normalizeOs(osName);
        String detectedArch = Detector.normalizeArch(osArch);
        int detectedBitness = this.determineBitness(detectedArch);
        this.setProperty(props, DETECTED_NAME, detectedName);
        this.setProperty(props, DETECTED_ARCH, detectedArch);
        this.setProperty(props, DETECTED_BITNESS, "" + detectedBitness);
        Matcher versionMatcher = VERSION_REGEX.matcher(osVersion);
        if (versionMatcher.matches()) {
            this.setProperty(props, DETECTED_VERSION, versionMatcher.group(1));
            this.setProperty(props, DETECTED_VERSION_MAJOR, versionMatcher.group(2));
            this.setProperty(props, DETECTED_VERSION_MINOR, versionMatcher.group(3));
        }
        if (!"false".equalsIgnoreCase(failOnUnknownOS = this.systemPropertyOperationProvider.getSystemProperty("failOnUnknownOS"))) {
            if (UNKNOWN.equals(detectedName)) {
                throw new DetectionException("unknown os.name: " + osName);
            }
            if (UNKNOWN.equals(detectedArch)) {
                throw new DetectionException("unknown os.arch: " + osArch);
            }
        }
        StringBuilder detectedClassifierBuilder = new StringBuilder();
        detectedClassifierBuilder.append(detectedName);
        detectedClassifierBuilder.append('-');
        detectedClassifierBuilder.append(detectedArch);
        LinuxRelease linuxRelease2 = linuxRelease = "linux".equals(detectedName) ? this.getLinuxRelease() : null;
        if (linuxRelease != null) {
            this.setProperty(props, DETECTED_RELEASE, linuxRelease.id);
            if (linuxRelease.version != null) {
                this.setProperty(props, DETECTED_RELEASE_VERSION, linuxRelease.version);
            }
            for (String like : linuxRelease.like) {
                String propKey = DETECTED_RELEASE_LIKE_PREFIX + like;
                this.setProperty(props, propKey, "true");
            }
            for (String classifierLike : classifierWithLikes) {
                if (!linuxRelease.like.contains(classifierLike)) continue;
                detectedClassifierBuilder.append('-');
                detectedClassifierBuilder.append(classifierLike);
                break;
            }
        }
        this.setProperty(props, DETECTED_CLASSIFIER, detectedClassifierBuilder.toString());
    }

    private void setProperty(Properties props, String name, String value) {
        props.setProperty(name, value);
        this.systemPropertyOperationProvider.setSystemProperty(name, value);
        this.logProperty(name, value);
    }

    protected abstract void log(String var1);

    protected abstract void logProperty(String var1, String var2);

    private static String normalizeOs(String value) {
        if ((value = Detector.normalize(value)).startsWith("aix")) {
            return "aix";
        }
        if (value.startsWith("hpux")) {
            return "hpux";
        }
        if (value.startsWith("os400") && (value.length() <= 5 || !Character.isDigit(value.charAt(5)))) {
            return "os400";
        }
        if (value.startsWith("linux")) {
            return "linux";
        }
        if (value.startsWith("mac") || value.startsWith("osx")) {
            return "osx";
        }
        if (value.startsWith("freebsd")) {
            return "freebsd";
        }
        if (value.startsWith("openbsd")) {
            return "openbsd";
        }
        if (value.startsWith("netbsd")) {
            return "netbsd";
        }
        if (value.startsWith("solaris") || value.startsWith("sunos")) {
            return "sunos";
        }
        if (value.startsWith("windows")) {
            return "windows";
        }
        if (value.startsWith("zos")) {
            return "zos";
        }
        return UNKNOWN;
    }

    private static String normalizeArch(String value) {
        if ((value = Detector.normalize(value)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (value.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (value.matches("^(ia64w?|itanium64)$")) {
            return "itanium_64";
        }
        if ("ia64n".equals(value)) {
            return "itanium_32";
        }
        if (value.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (value.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (value.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(value)) {
            return "aarch_64";
        }
        if (value.matches("^(mips|mips32)$")) {
            return "mips_32";
        }
        if (value.matches("^(mipsel|mips32el)$")) {
            return "mipsel_32";
        }
        if ("mips64".equals(value)) {
            return "mips_64";
        }
        if ("mips64el".equals(value)) {
            return "mipsel_64";
        }
        if (value.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if (value.matches("^(ppcle|ppc32le)$")) {
            return "ppcle_32";
        }
        if ("ppc64".equals(value)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(value)) {
            return "ppcle_64";
        }
        if ("s390".equals(value)) {
            return "s390_32";
        }
        if ("s390x".equals(value)) {
            return "s390_64";
        }
        if (value.matches("^(riscv|riscv32)$")) {
            return "riscv";
        }
        if ("riscv64".equals(value)) {
            return "riscv64";
        }
        if ("e2k".equals(value)) {
            return "e2k";
        }
        if ("loongarch64".equals(value)) {
            return "loongarch_64";
        }
        return UNKNOWN;
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private LinuxRelease getLinuxRelease() {
        for (String osReleaseFileName : LINUX_OS_RELEASE_FILES) {
            LinuxRelease res = this.parseLinuxOsReleaseFile(osReleaseFileName);
            if (res == null) continue;
            return res;
        }
        return this.parseLinuxRedhatReleaseFile(REDHAT_RELEASE_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinuxRelease parseLinuxOsReleaseFile(String fileName) {
        BufferedReader reader;
        block6: {
            LinuxRelease linuxRelease;
            reader = null;
            try {
                String line;
                InputStream in = this.fileOperationProvider.readFile(fileName);
                reader = new BufferedReader(new InputStreamReader(in, "utf-8"));
                String id = null;
                String version = null;
                LinkedHashSet<String> likeSet = new LinkedHashSet<String>();
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith(LINUX_ID_PREFIX)) {
                        id = Detector.normalizeOsReleaseValue(line.substring(LINUX_ID_PREFIX.length()));
                        likeSet.add(id);
                        continue;
                    }
                    if (line.startsWith(LINUX_VERSION_ID_PREFIX)) {
                        version = Detector.normalizeOsReleaseValue(line.substring(LINUX_VERSION_ID_PREFIX.length()));
                        continue;
                    }
                    if (!line.startsWith(LINUX_ID_LIKE_PREFIX)) continue;
                    line = Detector.normalizeOsReleaseValue(line.substring(LINUX_ID_LIKE_PREFIX.length()));
                    String[] parts = line.split("\\s+");
                    Collections.addAll(likeSet, parts);
                }
                if (id == null) break block6;
                linuxRelease = new LinuxRelease(id, version, likeSet);
            }
            catch (IOException iOException) {
                Detector.closeQuietly(reader);
            }
            catch (Throwable throwable) {
                Detector.closeQuietly(reader);
                throw throwable;
            }
            Detector.closeQuietly(reader);
            return linuxRelease;
        }
        Detector.closeQuietly(reader);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinuxRelease parseLinuxRedhatReleaseFile(String fileName) {
        block10: {
            BufferedReader reader;
            block8: {
                LinuxRelease linuxRelease;
                String id;
                String version;
                String line;
                block9: {
                    reader = null;
                    InputStream in = this.fileOperationProvider.readFile(fileName);
                    reader = new BufferedReader(new InputStreamReader(in, "utf-8"));
                    line = reader.readLine();
                    if (line == null) break block8;
                    line = line.toLowerCase(Locale.US);
                    version = null;
                    if (line.contains("centos")) {
                        id = "centos";
                        break block9;
                    }
                    if (line.contains("fedora")) {
                        id = "fedora";
                        break block9;
                    }
                    if (line.contains("red hat enterprise linux")) {
                        id = "rhel";
                        break block9;
                    }
                    LinuxRelease linuxRelease2 = null;
                    Detector.closeQuietly(reader);
                    return linuxRelease2;
                }
                try {
                    Matcher versionMatcher = REDHAT_MAJOR_VERSION_REGEX.matcher(line);
                    if (versionMatcher.find()) {
                        version = versionMatcher.group(1);
                    }
                    LinkedHashSet<String> likeSet = new LinkedHashSet<String>(Arrays.asList(DEFAULT_REDHAT_VARIANTS));
                    likeSet.add(id);
                    linuxRelease = new LinuxRelease(id, version, likeSet);
                }
                catch (IOException iOException) {
                    Detector.closeQuietly(reader);
                    break block10;
                }
                catch (Throwable throwable) {
                    Detector.closeQuietly(reader);
                    throw throwable;
                }
                Detector.closeQuietly(reader);
                return linuxRelease;
            }
            Detector.closeQuietly(reader);
        }
        return null;
    }

    private static String normalizeOsReleaseValue(String value) {
        return value.trim().replace("\"", "");
    }

    private int determineBitness(String architecture) {
        String bitness = this.systemPropertyOperationProvider.getSystemProperty("sun.arch.data.model", "");
        if (!bitness.isEmpty() && bitness.matches("[0-9]+")) {
            return Integer.parseInt(bitness, 10);
        }
        bitness = this.systemPropertyOperationProvider.getSystemProperty("com.ibm.vm.bitmode", "");
        if (!bitness.isEmpty() && bitness.matches("[0-9]+")) {
            return Integer.parseInt(bitness, 10);
        }
        return Detector.guessBitnessFromArchitecture(architecture);
    }

    public static int guessBitnessFromArchitecture(String arch) {
        if (arch.contains("64")) {
            return 64;
        }
        return 32;
    }

    private static void closeQuietly(Closeable obj) {
        try {
            if (obj != null) {
                obj.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class SimpleFileOperations
    implements FileOperationProvider {
        private SimpleFileOperations() {
        }

        @Override
        public InputStream readFile(String fileName) throws IOException {
            String string = fileName;
            FileInputStream fileInputStream = new FileInputStream(string);
            FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)fileInputStream, (String)string, (String)"kr.motd.maven.os.Detector$SimpleFileOperations");
            return fileInputStream;
        }
    }

    private static class SimpleSystemPropertyOperations
    implements SystemPropertyOperationProvider {
        private SimpleSystemPropertyOperations() {
        }

        @Override
        public String getSystemProperty(String name) {
            return Instrumented.systemProperty((String)name, (String)"kr.motd.maven.os.Detector$SimpleSystemPropertyOperations");
        }

        @Override
        public String getSystemProperty(String name, String def) {
            return Instrumented.systemProperty((String)name, (String)def, (String)"kr.motd.maven.os.Detector$SimpleSystemPropertyOperations");
        }

        @Override
        public String setSystemProperty(String name, String value) {
            return Instrumented.setSystemProperty((String)name, (String)value, (String)"kr.motd.maven.os.Detector$SimpleSystemPropertyOperations");
        }
    }

    private static class LinuxRelease {
        final String id;
        final String version;
        final Collection<String> like;

        LinuxRelease(String id, String version, Set<String> like) {
            this.id = id;
            this.version = version;
            this.like = Collections.unmodifiableCollection(like);
        }
    }
}

